<?php
  include("html_functions.php");

  echo "<b>StatsLab Validator</b>";
  echo "<br/>";
  echo "<br/>";

  ################## START OF PAGE CONTENT #########################
  ## Check php version
  echo "Current PHP version: ".phpversion()." (must be 7.2 or greater)<br/>";

  ## Check for sodium
  if (!extension_loaded('sodium'))
  {
	  echo "ERROR: PHP sodium extensions is not loaded.  Please contact your host to enable sodium in order to login to StatsLab.<br/>";
	  exit;
  }
  else {echo "OK: PHP sodium extension loaded.<br/>";}
  ## Check for curl
  if (!extension_loaded('curl'))
  {
	  echo "ERROR: PHP cURL extension is not loaded.  Please contact your host to enable cURL in order to run StatsLab.<br/>";
	  exit;
  }
  else {echo "OK: PHP cURL extension loaded.<br/>";}

  echo "<br/>";

  ## Check for config.txt
  $fpath="./config.txt";
  if (file_exists($fpath)) {echo "OK: config.txt file found.<br/>";}
  else 
  {
	  echo "ERROR: config.txt file not found in StatsLab directory.  Please create this file based on config.txt.sample.<br/>After doing so, return to this page.";
      	  exit;
  }

  set_adminpath();
  ## Check for dbopen.php
  $fpath=$_SESSION['adminpath']."/dbopen.php";
  if (file_exists($fpath)) {echo "OK: dbopen.php file found in SQL upload directory.<br/>";}
  else
  {
	  echo "ERROR: dbopen.php file not found in SQL upload directory.  Please create this file based on dbopen.php.sample.<br/>After doing so, return to this page.";
	  exit;
  }

  echo "<br/>";

  ## Check for mysql.sql files required
  $fileList=Array(
	   "divisions"
	  ,"games"
	  ,"games_score"
	  ,"human_managers"
	  ,"human_manager_history"
	  ,"human_manager_history_record"
	  ,"league_history"
	  ,"league_playoffs"
	  ,"league_playoff_fixtures"
	  ,"leagues"
	  ,"parks"
	  ,"players"
	  ,"players_awards"
	  ,"players_batting"
	  ,"players_career_batting_stats"
	  ,"players_career_fielding_stats"
	  ,"players_career_pitching_stats"
	  ,"players_contract"
	  ,"players_contract_extension"
	  ,"players_fielding"
	  ,"players_game_batting"
	  ,"players_game_pitching_stats"
	  ,"players_league_leader"
	  ,"players_pitching"
	  ,"players_roster_status"
	  ,"players_streak"
	  ,"sub_leagues"
	  ,"team_batting_stats"
	  ,"team_fielding_stats_stats"
	  ,"team_financials"
	  ,"team_history"
	  ,"team_history_batting_stats"
	  ,"team_history_fielding_stats_stats"
	  ,"team_history_financials"
	  ,"team_history_pitching_stats"
	  ,"team_history_record"
	  ,"team_pitching_stats"
	  ,"team_record"
	  ,"team_relations"
	  ,"team_roster"
	  ,"teams"
	  ,"trade_history"
  );
  $cnt=0;
  foreach ($fileList as $key => $filename)
  {
	  $fpath=$_SESSION['adminpath']."/".$filename.".mysql.sql";
	  if (file_exists($fpath)) {echo "OK: $filename.mysql.sql found in SQL upload directory.<br/>";$cnt++;}
	  else {echo "ERROR: $filename.mysql.sql not found in SQL upload directory.  Please include this in your MySQL dump from OOTP.<br/>";}
  }
  if ($cnt<count($fileList)) {echo "ERROR";} else {echo "OK";}
  echo ": $cnt of ".count($fileList)." SQL files present.<br/>";

  echo "<br/>";

  include($_SESSION['adminpath']."/dbopen.php");
  echo "***** MySQL Connection Errors ****************************************<br/>";
  echo "* ".mysqli_error($db)."<br/>";
  echo "*******************************************************************<br/>";
  echo "(If the above section is blank, you've got a valid connection to your database)<br/>";
  mysqli_close($db);


  echo "<br/>";
  echo "<a href='./sql_file_load.php'>SQL Files</a><br/>";
  echo "<a href='./admin.php'>StatsLab Admin</a><br/>";

?>
