<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgpath=$_SESSION['lgpath'];

  $date=new Date($_SESSION['lgdate']);

  $lgyear=$date->format("Y");

  

  ini_set("memory_limit","64M");



  ##### Get Report Settings #####

  $view=$_GET['view'];

  $team_id=$_GET['team_id'];

  $position=$_GET['pos'];

  $posFilt=$_GET['filter'];

  $userOrgID=$_SESSION['user_team_id'];



  if ($team_id!="") {$view='team';}



  if (($_SESSION['user_organization_id']!=$team_id)&&($view=='admin')) {$view='all_blocks';}

  if ($view!="team")

  {

       	  $view='all_blocks';

  }

  

  include($_SESSION['adminpath']."/dbopen.php");



  ##### Check if table exists #####

  $query="SHOW TABLES LIKE 'trade_block_teams';";

  $result=mysqli_query($db,$query);

  if (!mysqli_num_rows($result))

  {

       	  ##### Initialize Table #####

	  $query="CREATE TABLE IF NOT EXISTS trade_block_teams (team_id INT, notice TEXT, catcher SMALLINT DEFAULT 0, first_base SMALLINT DEFAULT 0, second_base SMALLINT DEFAULT 0, third_base SMALLINT DEFAULT 0, shortstop SMALLINT DEFAULT 0, left_field SMALLINT DEFAULT 0, center_field SMALLINT DEFAULT 0, right_field SMALLINT DEFAULT 0, starting_pitcher SMALLINT DEFAULT 0, relief_pitcher SMALLINT DEFAULT 0, PRIMARY KEY (team_id));";

       	  $result=mysqli_query($db,$query);

  }

  

  ##### Check if table exists #####

  $query="SHOW TABLES LIKE 'trade_block_players';";

  $result=mysqli_query($db,$query);

  if (!mysqli_num_rows($result))

  {

       	  ##### Initialize Table #####

	  $query="CREATE TABLE IF NOT EXISTS trade_block_players (player_id INT, team_id INT, headline VARCHAR(50), notice TEXT, trade_status SMALLINT DEFAULT NULL, PRIMARY KEY (player_id));";

	  $result=mysqli_query($db,$query);

  }

  

  #### Check for Enabled Reports ####

  $query="SHOW TABLES LIKE 'ootp_sql_admin';";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)) 

  {

	  $query="SELECT setting,value FROM ootp_sql_admin WHERE setting IN ('finEnable','scoutsOn');";

       	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result)) 

      	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $setting=$row['setting'];

			  $settings[$setting]=$row['value'];

		  }

      	  }

  }



  ##### Verify that Trade Block Status and Tables are Accurate Since Last Load #####

  ## Find players who've switched teams

  $query="SELECT p.player_id FROM players as p,trade_block_players as tbp WHERE p.player_id=tbp.player_id AND tbp.team_id!=p.organization_id";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

       	  $remList="";

	  while ($row=mysqli_fetch_array($result))

      	  {

		  $pid=$row['player_id'];

	    	  $remList.=",$pid";

	  }

       	  $remList=trim($remList,",");

	  ## Update entries for players who are on the block

	  $query="DELETE FROM trade_block_players WHERE player_id IN ($remList);";

	  mysqli_query($db,$query);

  }

  

  ## Add Players Not in OOTP Trade Block

  $query="UPDATE players_roster_status SET trade_status=2 WHERE trade_status=0 AND player_id IN (SELECT player_id FROM trade_block_players WHERE trade_status=2);";

  mysqli_query($db,$query);

  $query="UPDATE players_roster_status SET trade_status=1 WHERE trade_status=0 AND player_id IN (SELECT player_id FROM trade_block_players WHERE trade_status=1);";

  mysqli_query($db,$query);



  $title="";

  if ($team_id!="")

  {

	  $query="SELECT name,nickname FROM teams WHERE team_id=$team_id";

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  $row=mysqli_fetch_array($result);

		  $title=$row['name']." ".$row['nickname']." - ";

	  }

  }

  

  ##### Get Manager PM/Email Information #####

  $query="SELECT team_id,x.* FROM human_managers as hm,(SELECT identifier as human_manager_id,setting,value FROM ootp_sql_admin WHERE module='users') as x WHERE hm.human_manager_id=x.human_manager_id";

  if ($team_id>0) {$query.=" AND team_id=$team_id";}

  else {$query.=" AND league_id=$lgid";}

  if ($_GET['showq']==1) {echo $query."<br/>\n";}

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

	  while ($row=mysqli_fetch_array($result))

	  {

		  $tid=$row['team_id'];

		  $setting=$row['setting'];



		  $managers[$tid][$setting]=$row['value'];

	  }

	  foreach ($managers as $tid => $val)

	  {

		  if (($managers[$tid]['hideinfo']==1)&&(!isset($_SESSION['user_id']))) {unset($managers[$tid]);}

	  }

  }



  

  mysqli_close($db);



  # Title Bar

  $title.='Trade Block';



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title,$team_id);

  nav_toolbar('front_office',"Front Office");

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");

  

  ##### All Teams Trade Block View #####

  if ($view=='all_blocks')

  {

       	  ## Get Team Info

	  $query="SELECT team_id,league_id,name,nickname,abbr,parent_team_id,league_id,level,background_color_id,text_color_id,logo_file_name FROM teams WHERE (league_id=$lgid OR parent_team_id IN (SELECT team_id FROM teams WHERE league_id=$lgid AND allstar_team=0)) AND allstar_team=0 ORDER BY name,nickname;";

       	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

       	  while ($row=mysqli_fetch_array($result))

	  {

	    	  $tid=$row['team_id'];

		  $league_id=$row['league_id'];

	    	  $name=$row['name']." ".$row['nickname'];

		  $teams[$tid]['name']=$name;

	    	  $teams[$tid]['abbr']=$row['abbr'];

		  $teams[$tid]['league_id']=$row['league_id'];

	    	  $teams[$tid]['parent_team_id']=$row['parent_team_id'];

		  $lvl=get_level($row['level']);

	    	  $teams[$tid]['level']=$lvl;

		  $teams[$tid]['background_color_id']=$row['background_color_id'];

	    	  $teams[$tid]['text_color_id']=$row['text_color_id'];

		  $teams[$tid]['logo_file']=urlencode($row['logo_file_name']);

	    	  if (!isset($leagues[$league_id]['lvl'])) {$leagues[$league_id]['lvl']=$lvl;}

	  }

       

	  ## Get team notice

	  $query="SELECT * FROM trade_block_teams;";

       	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

       	  if (mysqli_num_rows($result))

	  {

	    	  $numFields=mysqli_num_fields($result);

		  while ($row=mysqli_fetch_array($result))

	   	  {

			  $tid=$row['team_id'];

		 	  for ($i=1;$i<$numFields;$i++) 

			  {

				$fieldInfo = mysqli_fetch_field_direct( $result, $i);

				$fieldname = $fieldInfo->name;

				  $teams[$tid][$fieldname]=$row[$fieldname];

			  }

			  $notice=stripslashes($teams[$tid]['notice']);

			  $notice=clean_bbcode(htmlspecialchars($notice));

			  $notice=nl2br($notice);

			  $teams[$tid]['notice']=$notice;

		 	  $tneeds="";

			  if ($teams[$tid]['catcher']==1) {$tneeds.=" C";}

		 	  if ($teams[$tid]['first_base']==1) {$tneeds.=", 1B";}

			  if ($teams[$tid]['second_base']==1) {$tneeds.=", 2B";}

		 	  if ($teams[$tid]['third_base']==1) {$tneeds.=", 3B";}

			  if ($teams[$tid]['shortstop']==1) {$tneeds.=", SS";}

		 	  if ($teams[$tid]['left_field']==1) {$tneeds.=", LF";}

			  if ($teams[$tid]['center_field']==1) {$tneeds.=", CF";}

		 	  if ($teams[$tid]['right_field']==1) {$tneeds.=", RF";}

			  if ($teams[$tid]['starting_pitcher']==1) {$tneeds.=", SP";}

		 	  if ($teams[$tid]['relief_pitcher']==1) {$tneeds.=", RP";}

			  $teams[$tid]['needs']=trim($tneeds,", ");

		  }

      	  }

       

	  ## Get Player Trade Block Info

	  $query="SELECT * FROM trade_block_players;";

       	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

       	  if (mysqli_num_rows($result))

	  {

	    	  while ($row=mysqli_fetch_array($result))

		  {

		 	  $pid=$row['player_id'];

			  $players[$pid]['headline']=stripslashes($row['headline']);

			  $notice=stripslashes($row['notice']);

			  $notice=clean_bbcode(htmlspecialchars($notice));

			  $notice=nl2br($notice);

		 	  $players[$pid]['notice']=$notice;

		  }

      	  }	  



	  $posFilters=array('catcher','first_base','second_base','third_base','shortstop','left_field','center_field','right_field','starting_pitcher','relief_pitcher');

       

	  ## Display Filters

	  echo " <div class='textbox' style='border:0;'>\n";

       	  echo "  <table cellpadding=0 cellspacing=0 border=0>\n";

	  echo "   <tr>\n";

       	  echo "    <td style='text-align:left;'><b>Filter On:</b></td>\n";

	  echo "    <td style='text-align:right;'>\n";

       	  echo "     <select onchange=\"window.location='./tradeBlock.php?filter='+this[this.selectedIndex].value;\">\n";

	  echo "      <option value='none'>None</option>\n";

       	  if (($userOrgID!="")&&($teams[$userOrgID]['needs']!=""))

	  {

	    	  echo "      <option value='need'";

		  if ($posFilt=='need') {echo " selected";}

	    	  echo ">My Team Needs</option>\n";

	  }

       	  foreach ($posFilters as $key => $val)

	  {

	    	  echo "      <option value='$val'";

		  if ($posFilt==$val) {echo " selected";}

	    	  $val=str_replace("_"," ",$val);

		  $val=ucwords($val);

	    	  echo ">$val</option>\n";

	  }

       	  echo "     </select>\n";

	  echo "    </td>\n";

       	  if ($posFilt=='need') {echo "    <td><b>Filtered on:</b> ".$teams[$userOrgID]['needs']."</td>\n";}

	  echo "   </tr>\n";

       	  echo "  </table>\n";

	  echo "</div>\n";



	  if (($settings['scoutsOn']==1)&&((($_SESSION['Ratings']!='Hidden')&&($_SESSION['Ratings']!=""))||(($_SESSION['Talents']!='Hidden')&&($_SESSION['Ratings']!=""))))

	  {

		  echo "<div class='textbox' style='border:0px;float:right;clear:none;'>Ratings scouted by StatsLab</div>\n";

	  }

       

	  ## Get Player List

	  $pList="";

       	  $query="SELECT player_id FROM players_roster_status WHERE trade_status=2;";

	  $result=mysqli_query($db,$query);

       	  if (mysqli_num_rows($result))

	  {

	    	  while ($row=mysqli_fetch_array($result))

		  {

		 	  $pid=$row['player_id'];

			  $pList.=",$pid";

	   	  }

		  $pList=trim($pList,",");

      	  }

       

	  ## Apply Filter

	  if (($posFilt!="")&&($posFilt!="none")&&($pList!=""))

      	  {

		  switch ($posFilt)

	   	  {

		  case 'catcher':

	       		  $query="SELECT player_id FROM players_fielding";

			  if ($settings['scoutsOn']==1) {$query.="_scouted";}

			  $query.=" WHERE player_id IN ($pList) AND fielding_rating_pos2>0;";

			  break;

	 	  case 'first_base':

			  $query="SELECT player_id FROM players_fielding";

			  if ($settings['scoutsOn']==1) {$query.="_scouted";}

			  $query.=" WHERE player_id IN ($pList) AND fielding_rating_pos3>0;";

	       		  break;

		  case 'second_base':

	       		  $query="SELECT player_id FROM players_fielding";

			  if ($settings['scoutsOn']==1) {$query.="_scouted";}

			  $query.=" WHERE player_id IN ($pList) AND fielding_rating_pos4>0;";

			  break;

	 	  case 'third_base':

			  $query="SELECT player_id FROM players_fielding";

			  if ($settings['scoutsOn']==1) {$query.="_scouted";}

			  $query.=" WHERE player_id IN ($pList) AND fielding_rating_pos5>0;";

	       		  break;

		  case 'shortstop':

	       		  $query="SELECT player_id FROM players_fielding";

			  if ($settings['scoutsOn']==1) {$query.="_scouted";}

			  $query.=" WHERE player_id IN ($pList) AND fielding_rating_pos6>0;";

			  break;

	 	  case 'left_field':

			  $query="SELECT player_id FROM players_fielding";

			  if ($settings['scoutsOn']==1) {$query.="_scouted";}

			  $query.=" WHERE player_id IN ($pList) AND fielding_rating_pos7>0;";

	       		  break;

		  case 'center_field':

	       		  $query="SELECT player_id FROM players_fielding";

			  if ($settings['scoutsOn']==1) {$query.="_scouted";}

			  $query.=" WHERE player_id IN ($pList) AND fielding_rating_pos8>0;";

			  break;

	 	  case 'right_field':

			  $query="SELECT player_id FROM players_fielding";

			  if ($settings['scoutsOn']==1) {$query.="_scouted";}

			  $query.=" WHERE player_id IN ($pList) AND fielding_rating_pos9>0;";

	       		  break;

		  case 'starting_pitcher':

	       		  $query="SELECT player_id FROM players WHERE player_id IN ($pList) AND role=11;";

			  break;

	 	  case 'relief_pitcher':

			  $query="SELECT player_id FROM players WHERE player_id IN ($pList) AND role IN (12,13);";

	       		  break;

		  case 'need':

	       		  $query="";

			  if (($teams[$userOrgID]['catcher']==1)||($teams[$userOrgID]['first_base']==1)||($teams[$userOrgID]['second_base']==1)||($teams[$userOrgID]['third_base']==1)||($teams[$userOrgID]['shortstop']==1)||($teams[$userOrgID]['left_field']==1)||($teams[$userOrgID]['center_field']==1)||($teams[$userOrgID]['right_field']==1))

	      		  {

				  $query="SELECT player_id FROM players_fielding";

				  if ($settings['scoutsOn']==1) {$query.="_scouted";}

				  $query.=" WHERE player_id IN ($pList) AND (";

		    		  $subquery="";

				  if ($teams[$userOrgID]['catcher']==1) {$subquery="fielding_rating_pos2>0";}

		    		  if ($teams[$userOrgID]['first_base']==1) {$subquery.=" OR fielding_rating_pos3>0";}

				  if ($teams[$userOrgID]['second_base']==1) {$subquery.=" OR fielding_rating_pos4>0";}

		    		  if ($teams[$userOrgID]['third_base']==1) {$subquery.=" OR fielding_rating_pos5>0";}

				  if ($teams[$userOrgID]['shortstop']==1) {$subquery.=" OR fielding_rating_pos6>0";}

		    		  if ($teams[$userOrgID]['left_field']==1) {$subquery.=" OR fielding_rating_pos7>0";}

				  if ($teams[$userOrgID]['center_field']==1) {$subquery.=" OR fielding_rating_pos8>0";}

		    		  if ($teams[$userOrgID]['right_field']==1) {$subquery.=" OR fielding_rating_pos9>0";}

				  $subquery=trim($subquery," OR");

		    		  $query.=$subquery.")";

				  if (($teams[$userOrgID]['starting_pitcher']==1)||($teams[$userOrgID]['relief_pitcher']==1)) {$query.=" UNION ";}

			  }

	       

			  if (($teams[$userOrgID]['starting_pitcher']==1)&&($teams[$userOrgID]['relief_pitcher']==1)) {$query.="SELECT player_id FROM players_fielding";

			  if ($settings['scoutsOn']==1) {$query.="_scouted";}

			  $query.=" WHERE player_id IN ($pList) AND fielding_rating_pos1>0";}

	      		  elseif ($teams[$userOrgID]['starting_pitcher']==1) {$query.="SELECT player_id FROM players WHERE player_id IN ($pList) AND role=11";}

			  elseif ($teams[$userOrgID]['relief_pitcher']==1) {$query.="SELECT player_id FROM players WHERE player_id IN ($pList) AND role IN (12,13)";}

		       	  break;

		  }

	    	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  $pList="";

		  if (mysqli_num_rows($result))

	   	  {

			  while ($row=mysqli_fetch_array($result))

			  {	 

				  $pid=$row['player_id'];

		      		  $pList.=",$pid";

			  }

		 	  $pList=trim($pList,",");

		  }

	  }

       

	  if ($pList=="")

	  {

	    	  if (($posFilt!="")&&($posFilt!="none")) {echo " <div class='textbox' style='border:0;width:935px;'>No players match filter criteria</div>\n";} else {echo " <div class='textbox' style='border:0;width:935px;'>No players on the block</div>\n";}

	  }

      	  else

	  {

		  ## Get Batter Ratings

		  $ratArray=Array('batting_ratings_overall_contact','batting_ratings_overall_power','batting_ratings_overall_eye','batting_ratings_talent_contact','batting_ratings_talent_power','batting_ratings_talent_eye');

		  $query="SELECT player_id";

		  foreach ($ratArray as $key => $ratLbl)

		  {

			  # Get scale

			  $ratScale=get_scale($ratLbl);

			  $scale=$_SESSION[$ratScale];

	  

			  # Add to query

			  $query.=",".ratings_query($ratLbl,$scale);

			  $query.=" as $ratLbl";

		  }

		  $query.=" FROM players_batting";

		  if ($settings['scoutsOn']==1) {$query.="_scouted";}

		  $query.=" WHERE player_id IN ($pList);";

	    	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  foreach ($ratArray as $key => $ratLbl) {$players[$pid][$ratLbl]=$row[$ratLbl];}

		  }

	    

		  ## Get Pitcher Ratings

		  $ratArray=Array('pitching_ratings_overall_stuff','pitching_ratings_overall_control','pitching_ratings_overall_movement','pitching_ratings_talent_stuff','pitching_ratings_talent_control','pitching_ratings_talent_movement');

		  $query="SELECT player_id";

		  foreach ($ratArray as $key => $ratLbl)

		  {

			  # Get scale

			  $ratScale=get_scale($ratLbl);

			  $scale=$_SESSION[$ratScale];

	  

			  # Add to query

			  $query.=",".ratings_query($ratLbl,$scale);

			  $query.=" as $ratLbl";

		  }

		  $query.=" FROM players_pitching";

		  if ($settings['scoutsOn']==1) {$query.="_scouted";}

		  $query.=" WHERE player_id IN ($pList);";

	    	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  while ($row=mysqli_fetch_array($result))

		  {

		 	  $pid=$row['player_id'];

			  foreach ($ratArray as $key => $ratLbl) {$players[$pid][$ratLbl]=$row[$ratLbl];}

		  }

	    

		  ## Check games played and find year to display stats from

		  $query="SELECT COUNT(game_id) as g FROM games WHERE league_id=$lgid AND game_type=0 AND games.date LIKE '".$lgyear."%' AND played=1;";

		  $result=mysqli_query($db,$query);

	    	  $row=mysqli_fetch_array($result);

		  $minG=$row['g'];

	    	  $query="SELECT MIN(year) as yr FROM players_career_batting_stats WHERE league_id=$lgid;";

		  $result=mysqli_query($db,$query);

	    	  $row=mysqli_fetch_array($result);

		  $minYr=$row['yr'];

	    	  if (($minG<15)&&($minYr<$lgyear)) {$dispYr=$lgyear-1;}

		  else {$dispYr=$lgyear;}

		    

		  ## Get Batter Stats

		  $statArray=Array('avg','hr','rbi','pa','sb','bb','ops');

		  $query="SELECT player_id,league_id";

		  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}

		  $query.=" FROM players_career_batting_stats WHERE split_id=1 AND player_id IN ($pList) AND year=$dispYr GROUP BY player_id,league_id ORDER BY player_id,league_id;";

	    	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  if (mysqli_num_rows($result))

		  {

		 	  while ($row=mysqli_fetch_array($result))

			  {

		      		  $pid=$row['player_id'];

				  if (isset($players[$pid]['avg'])) {continue;}

		      		  $league_id=$row['league_id'];

				  $players[$pid]['blvl']=$leagues[$league_id]['lvl'];

				  foreach ($statArray as $key => $statLbl) {$players[$pid][$statLbl]=stat_format($statLbl,$row[$statLbl]);}

			  }

	   	  }

  

		  ## Get Pitcher Stats

		  $statArray=Array('w','l','era','k','ip','pbb','hra','whip');

		  $query="SELECT player_id,league_id";

		  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}

		  $query.=" FROM players_career_pitching_stats WHERE split_id=1 AND player_id IN ($pList) AND year=$dispYr GROUP BY player_id,league_id ORDER BY player_id,league_id;";

	    	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  if (mysqli_num_rows($result))

		  {

		 	  while ($row=mysqli_fetch_array($result))

			  {

		      		  $pid=$row['player_id'];

				  if (isset($players[$pid]['era'])) {continue;}

		      		  $league_id=$row['league_id'];

				  $players[$pid]['plvl']=$leagues[$league_id]['lvl'];

		      		  $players[$pid]['w-l']=$row['w']."-".$row['l'];

				  foreach ($statArray as $key => $statLbl) {$players[$pid][$statLbl]=stat_format($statLbl,$row[$statLbl]);}

			  }

		  }

	    

		  ## Get Salary Info

		  if ($settings['finEnable']==1)

	   	  {

			  $query="SELECT player_id,season_year,salary0,salary1,salary2,salary3,salary4,salary5,salary6,salary7,salary8,salary9,years FROM players_contract WHERE player_id IN ($pList);";

		 	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

			  $result=mysqli_query($db,$query);

		 	  while ($row=mysqli_fetch_array($result))

			  {

		      		  $pid=$row['player_id'];

				  $yr=$row['season_year'];

		      		  $remYrs=$lgyear-$yr;

				  $field='salary'.$remYrs;

		      		  $totYrs=$row['years'];

				  $remYrs=$lgyear+$totYrs-$remYrs-1;



				  $sal=$row[$field];

		      		  if ($sal==0) {$sal="MLC";} else {$sal="<a href='./payroll.php?player=$pid'>$".number_format($sal)."</a>";}

				  $players[$pid]['salary']=$sal;

		      		  $players[$pid]['salThrough']=$remYrs;

			  }

		  }

	    

		  ## Get Players

		  $query="SELECT player_id,first_name,last_name,age,if(position=1,'P','B') as pPos,position,role,league_id,team_id,organization_id,bats,throws,injury_is_injured FROM players WHERE player_id IN ($pList) ORDER BY organization_id,pPos,last_name,first_name";

	    	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  if (mysqli_num_rows($result))

		  {

		 	  while ($row=mysqli_fetch_array($result))

			  {

                  $pid=$row['player_id'];

				  $name=$row['first_name']." ".$row['last_name'];

                  $orgID=$row['organization_id'];

                  $plgid=$row['league_id'];

                  $tid=$row['team_id'];

				  $players[$pid]['name']=$name;

                  $players[$pid]['age']=$row['age'];

				  $players[$pid]['team_id']=$tid;

                  $players[$pid]['orgID']=$orgID;

                  if ($plgid<0) {$level='INT';}

                  else {$level=$teams[$tid]['level'];}

                  $players[$pid]['level']=$level;

                  

				  $pos=$row['position'];

				  if ($pos==1) {$pos=get_pos($row['role'],1);} else {$pos=get_pos($pos,1);}

		      		  $bats=get_hand($row['bats']);

				  $throws=get_hand($row['throws']);

		      		  $inj=$row['injury_is_injured'];

				  $pPos=$row['pPos'];



				  $players[$pid]['pos']=$pos;

		      		  $players[$pid]['bats']=$bats;

				  $players[$pid]['throws']=$throws;

		      		  $players[$pid]['inj']=$inj;

				  $players[$pid]['pPos']=$pPos;



				  $teams[$orgID]['pOnBlock']=$teams[$orgID]['pOnBlock'].",".$pid;

			  }

		  }

	    

		  ## Display Team Blocks

		  foreach ($teams as $orgID => $val)

	   	  {

			  $prevPos="";

		 	  if ($teams[$orgID]['league_id']!=$lgid) {continue;}

			  if (($teams[$orgID]['notice']=="")&&($teams[$orgID]['needs']=="")&&($teams[$orgID]['pOnBlock'])=="") {continue;}



			  echo " <div class='textbox'>\n";    

		 	  echo "  <table cellpadding=2 cellspacing=0 border=0 width='935px'>\n";

			  echo "   <tr><td colspan=18 style='background-color:".$teams[$orgID]['background_color_id'].";color:".$teams[$orgID]['text_color_id'].";font-weight:bold;font-size:2em;'> <img src='$lgpath/images/team_logos/".str_replace(".png","_40.png",htmlentities($teams[$orgID]['logo_file']))."' style='vertical-align:bottom;height:30px;width:30px;' /> ".$teams[$orgID]['name']."</td></tr>\n";

		 	  if ($teams[$orgID]['notice']!="") {echo "   <tr><td colspan=2 style='vertical-align:top;'><b>Team Notice:</b></td><td colspan=16>".$teams[$orgID]['notice']."</td></td></tr>\n";}

			  if ($teams[$orgID]['needs']!="") {echo "   <tr><td colspan=2><b>Team Needs:</b></td><td colspan=16>".htmlspecialchars($teams[$orgID]['needs'])."</td></td></tr>\n";}



			  $pList=$teams[$orgID]['pOnBlock'];

		 	  $pList=trim($pList,",");

			  if (isset($playerList)) {unset($playerList);}

			  $playerList=explode(",",$pList);

		 	  $statCols=4;

			  if (($_SESSION['Ratings']=='Hidden')||($_SESSION['Ratings']=="")) {$statCols+=3;}

		 	  if (($_SESSION['Talents']=='Hidden')||($_SESSION['Talents']=="")) {$statCols+=3;}

			  foreach ($playerList as $key => $pid)

			  {

		      		  if ($pid=="") {continue;}

				  $name=$players[$pid]['name'];

		      		  $age=$players[$pid]['age'];

				  $tid=$players[$pid]['team_id'];

		      		  $pos=$players[$pid]['pos'];

				  $bats=$players[$pid]['bats'];

		      		  $throws=$players[$pid]['throws'];

				  $inj=$players[$pid]['inj'];

		      		  $pPos=$players[$pid]['pPos'];



				  if ($prevPos!=$pPos)

		     		  {

					  if ($pPos=='B') {echo "   <tr class='headline'><td class='hsc2_l' colspan=6>Batters</td>";}

			  		  else {echo "   <tr class='headline'><td class='hsc2_l' colspan=6>Pitchers</td>";}

					  if (($_SESSION['Ratings']!='Hidden')&&($_SESSION['Ratings']!=""))

					  {

						  echo "<td class='hsc2' colspan=3 style='text-align:center;border-left:1px solid #AAAAAA;'>Ovr</td>";

					  }

			   		  if (($_SESSION['Talents']!='Hidden')&&($_SESSION['Ratings']!=""))

					  {

						  echo "<td class='hsc2' colspan=3 style='text-align:center;border-left:1px solid #AAAAAA;'>Pot</td>";

					  }

					  echo "<td class='hsc2' colspan=$statCols style='text-align:center;border-left:1px solid #AAAAAA;'>$dispYr Stats</td><td class='hsc2_l' colspan=2 style='border-left:1px solid #AAAAAA;'>&nbsp;</td></tr>\n";

			   		  echo "   <tr class='headline'><td class='hsc2'>Pos</td><td class='hsc2_l'>Player</td><td class='hsc2'>Age</td><td class='hsc2_l'>Team</td><td class='hsc2'>Level</td>";

					  if ($settings['finEnable']==1) {echo "<td class='hsc2'>Salary</td>";} else {echo "<td class='hsc2'>&nbsp;</td>";}

			   		  if ($pPos=='B')

					  {

						  if (($_SESSION['Ratings']!='Hidden')&&($_SESSION['Ratings']!=""))

						  {

				     			  echo "<td class='hsc2' style='border-left:1px solid #AAAAAA;'>C</td><td class='hsc2'>P</td><td class='hsc2'>E</td>";

						  }

						  if (($_SESSION['Talents']!='Hidden')&&($_SESSION['Ratings']!=""))

						  {

				     			  echo "<td class='hsc2' style='border-left:1px solid #AAAAAA;'>C</td><td class='hsc2'>P</td><td class='hsc2'>E</td>";

						  }

						  if (($_SESSION['Ratings']=='Hidden')||($_SESSION['Ratings']=="")||($_SESSION['Talents']=='Hidden')||($_SESSION['Talents']==""))

						  {

				     			  echo "<td class='hsc2' style='border-left:1px solid #AAAAAA;'>PA</td><td class='hsc2'>";

						  }

			       			  else {echo "<td class='hsc2' style='border-left:1px solid #AAAAAA;'>";}

						  echo "Avg</td><td class='hsc2'>HR</td><td class='hsc2'>RBI</td>";

						  if (($_SESSION['Ratings']=='Hidden')||($_SESSION['Ratings']=="")||($_SESSION['Talents']=='Hidden')||($_SESSION['Talents']==""))

						  {

				     			  echo "<td class='hsc2'>BB</td><td class='hsc2'>SB</td>";

						  }

						  if ((($_SESSION['Ratings']=='Hidden')||($_SESSION['Ratings']==""))&&(($_SESSION['Talents']=='Hidden')||($_SESSION['Talents']=="")))

						  {

				     			  echo "<td class='hsc2' colspan=3>OPS</td>";

						  }

			  		  }

					  else 

			  		  {

						  if (($_SESSION['Ratings']!='Hidden')&&($_SESSION['Ratings']!=""))

			       			  {

							  echo "<td class='hsc2' style='border-left:1px solid #AAAAAA;'>S</td><td class='hsc2'>C</td><td class='hsc2'>M</td>";

			       			  }

						  if (($_SESSION['Talents']!='Hidden')&&($_SESSION['Ratings']!=""))

			       			  {

							  echo "<td class='hsc2' style='border-left:1px solid #AAAAAA;'>S</td><td class='hsc2'>C</td><td class='hsc2'>M</td>";

			       			  }

						  echo "<td class='hsc2' style='border-left:1px solid #AAAAAA;'>W-L</td><td class='hsc2'>ERA</td>";

						  if (($_SESSION['Ratings']=='Hidden')||($_SESSION['Ratings']=="")||($_SESSION['Talents']=='Hidden')||($_SESSION['Talents']==""))

						  {

				     			  echo "<td class='hsc2'>IP</td><td class='hsc2'>BB</td><td class='hsc2'>HRA</td>";

						  }

						  echo "<td class='hsc2'>K</td>";

						  if ((($_SESSION['Ratings']=='Hidden')||($_SESSION['Ratings']==""))&&(($_SESSION['Talents']=='Hidden')||($_SESSION['Talents']=="")))

			       			  {

							  echo "<td class='hsc2' colspan=3>WHIP</td>";

			       			  }

					  }

			   		  echo "<td class='hsc2'>Lvl</td><td class='hsc2' style='border-left:1px solid #AAAAAA;'>&nbsp;</td><td class='hsc2'>Headline</td></tr>\n";

				  }

		      

				  $cls='s'.($cnt%2+1);

				  echo "   <tr class='$cls'>";

		      		  echo "<td>$pos</td>";

				  if ($players[$pid]['level']=='ML')

		     		  {

					  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>$name</a></td>";

		     		  }

				  else

		     		  {

					  echo "<td class='".$cls."_l'><a href='$lgpath/players/player_$pid.html'>$name</a></td>";

		     		  }

				  echo "<td>$age</td>";

		      		  echo "<td class='".$cls."_l'><a href='$lgpath/teams/team_$tid.html'>".$teams[$tid]['abbr']."</a></td>";

				  echo "<td><a href='$lgpath/teams/team_$tid.html'>".$players[$pid]['level']."</a></td>";

		      		  if ($settings['finEnable']==1) {echo "<td>".$players[$pid]['salary']."</td>";} else {echo "<td class='hsc2'>&nbsp;</td>";}

				  if ($pPos=='B')

		     		  {

					  if (($_SESSION['Ratings']!='Hidden')&&($_SESSION['Ratings']!=""))

			  		  {

						  echo "<td style='border-left:1px solid #AAAAAA;'>".$players[$pid]['batting_ratings_overall_contact']."</td>";

						  echo "<td>".$players[$pid]['batting_ratings_overall_power']."</td>";

						  echo "<td>".$players[$pid]['batting_ratings_overall_eye']."</td>";

			  		  }

					  if (($_SESSION['Talents']!='Hidden')&&($_SESSION['Ratings']!=""))

			  		  {

						  echo "<td style='border-left:1px solid #AAAAAA;'>".$players[$pid]['batting_ratings_talent_contact']."</td>";

						  echo "<td>".$players[$pid]['batting_ratings_talent_power']."</td>";

						  echo "<td>".$players[$pid]['batting_ratings_talent_eye']."</td>";

			  		  }

					  if (($_SESSION['Ratings']=='Hidden')||($_SESSION['Ratings']=="")||($_SESSION['Talents']=='Hidden')||($_SESSION['Talents']==""))

			  		  {

						  echo "<td style='border-left:1px solid #AAAAAA;'>".$players[$pid]['pa']."</td><td>";

			  		  }

					  else {echo "<td style='border-left:1px solid #AAAAAA;'>";}

			   		  echo $players[$pid]['avg']."</td>";

					  echo "<td>".$players[$pid]['hr']."</td>";

			   		  echo "<td>".$players[$pid]['rbi']."</td>";

					  if (($_SESSION['Ratings']=='Hidden')||($_SESSION['Ratings']=="")||($_SESSION['Talents']=='Hidden')||($_SESSION['Talents']==""))

					  {

						  echo "<td>".$players[$pid]['bb']."</td>";

						  echo "<td>".$players[$pid]['sb']."</td>";

			  		  }

					  if ((($_SESSION['Ratings']=='Hidden')||($_SESSION['Ratings']==""))&&(($_SESSION['Talents']=='Hidden')||($_SESSION['Talents']=="")))

			  		  {

						  echo "<td colspan=3>".$players[$pid]['ops']."</td>";

			  		  }

					  echo "<td>".$players[$pid]['blvl']."</td>";

		     		  }

				  else

		     		  {

					  if (($_SESSION['Ratings']!='Hidden')&&($_SESSION['Ratings']!=""))

			  		  {

						  echo "<td style='border-left:1px solid #AAAAAA;'>".$players[$pid]['pitching_ratings_overall_stuff']."</td>";

						  echo "<td>".$players[$pid]['pitching_ratings_overall_control']."</td>";

						  echo "<td>".$players[$pid]['pitching_ratings_overall_movement']."</td>";

			  		  }

					  if (($_SESSION['Talents']!='Hidden')&&($_SESSION['Ratings']!=""))

			  		  {

						  echo "<td style='border-left:1px solid #AAAAAA;'>".$players[$pid]['pitching_ratings_talent_stuff']."</td>";

						  echo "<td>".$players[$pid]['pitching_ratings_talent_control']."</td>";

						  echo "<td>".$players[$pid]['pitching_ratings_talent_movement']."</td>";

			  		  }

					  echo "<td style='border-left:1px solid #AAAAAA;'>".$players[$pid]['w-l']."</td>";

			   		  echo "<td>".$players[$pid]['era']."</td>";

					  if (($_SESSION['Ratings']=='Hidden')||($_SESSION['Ratings']=="")||($_SESSION['Talents']=='Hidden')||($_SESSION['Talents']==""))

			  		  {

						  echo "<td>".$players[$pid]['ip']."</td>";

						  echo "<td>".$players[$pid]['pbb']."</td>";

						  echo "<td>".$players[$pid]['hra']."</td>";

			  		  }

					  echo "<td>".$players[$pid]['k']."</td>";

			   		  if ((($_SESSION['Ratings']=='Hidden')||($_SESSION['Ratings']==""))&&(($_SESSION['Talents']=='Hidden')||($_SESSION['Talents']=="")))

					  {

						  echo "<td colspan=3>".$players[$pid]['whip']."</td>";

					  }

			   		  echo "<td>".$players[$pid]['plvl']."</td>";

				  }

		      		  if ($inj==1) {echo "   <td style='color:#990000;border-left:1px solid #AAAAAA;'>Inj</td>";} else {echo "<td style='border-left:1px solid #AAAAAA;'>&nbsp;</td>";}

				  echo "<td>".$players[$pid]['headline']."</td>";

		      		  echo "</tr>\n";

				  $cnt++;



				  $prevPos=$pPos;

			  }

			  if ($prevPos=="")

			  {

				  if (($posFilt!="")&&($posFilt!="none")) {echo "   <tr><td class='s2' colspan=18 style='text-align:center;'>No players match filter criteria</td></tr>\n";} else {echo "   <tr><td class='s2' colspan=18 style='text-align:center;'>No players on the block</td></tr>\n";}

			  }

		 	  echo "   <tr>";

			  echo "<td colspan=9 style='border-top:1px solid black;text-align:left;'>";

		 	  $first=1;

			  $hide_info=$managers[$orgID]['hideinfo'];

		 	  if ($_GET['showq']==1) {echo "$orgID::hideinfo::$hide_info<br/>\n";}

			  if (($hide_info==0)||(isset($_SESSION['user_id'])))

			  {

				  $pm_link=$managers[$orgID]['flink'];

		      		  $email=$managers[$orgID]['email'];

				  $aim=$managers[$orgID]['aim'];

		      		  $yim=$managers[$orgID]['yim'];

				  $msn=$managers[$orgID]['msn'];

		      		  $icq=$managers[$orgID]['icq'];

				  if ($_GET['showq']==1) {echo "$orgID::pm_link::$pm_link<br/>\n";}

		      		  if ($_GET['showq']==1) {echo "$orgID::email::$email<br/>\n";}

				  if ($_GET['showq']==1) {echo "$orgID::aim::$aim<br/>\n";}

				  if ($_GET['showq']==1) {echo "$orgID::yim::$yim<br/>\n";}

				  if ($_GET['showq']==1) {echo "$orgID::msn::$msn<br/>\n";}

		      		  if ($_GET['showq']==1) {echo "$orgID::icq::$icq<br/>\n";}

			      

				  echo "<b>Contact:</b> ";

				  if ($email!="")

		     		  {

					  $e=explode(";",$email);

			   		  echo "<a href='mailto:".$e[0]."'>Email</a>";

					  $first=0;

		     		  }

				  if ($pm_link!="") {if ($first==0) {echo " / ";} else {$first=0;} echo "<a href='$pm_link'>PM</a>";}

		      		  if ($aim!="") {if ($first==0) {echo " / ";} else {$first=0;} echo "<a href='aim:goim?screenname=$aim'>AIM</a>";}

				  if ($yim!="") {if ($first==0) {echo " / ";} else {$first=0;} echo "<a href='http://webmessenger.yahoo.com/?im=$yim'>Yahoo</a>";}

				  if ($msn!="") {if ($first==0) {echo " / ";} else {$first=0;} echo "<a href='msnim:chat?contact=$msn'>MSN</a>";}

		      		  if ($icq!="") {if ($first==0) {echo " / ";} else {$first=0;} echo "<a href='http://www.icq.com/people/cmd.php?uin=$icq&action=message'>ICQ</a>";}

				  if ($first==1) {echo "No contact information available";}

			  }

		 	  else {echo "&nbsp;";}

			  echo "</td>";

		 	  echo "<td colspan=9 style='border-top:1px solid black;text-align:right;'><a href='./tradeBlock.php?team_id=$orgID'>Expand Block</a></td</tr>\n";

			  echo "  </table>\n";

		 	  echo " </div>\n";

		  }

      	  }

  }   ##### End of All-Blocks #####

  

  ##### Team Specific Trade Block View #####

  if ($view=='team')

  {

	  echo " <div class='textbox' style='border:0;'>\n";

       	  echo "  <table cellpadding=0 cellspacing=0 border=0 width='935px'>\n";

	  echo "   <tr>\n";

       	  echo "    <td style='text-align:left;'><a href='./tradeBlock.php'>Back to Full Trade Block Listing</a></td>\n";

	  echo "    <td style='text-align:right;'>\n";

       	  echo "     <select onchange=\"window.location='./tradeBlock.php?team_id='+this[this.selectedIndex].value;\">\n";

	  $query="SELECT team_id,name,nickname FROM teams WHERE league_id=$lgid AND allstar_team=0 ORDER BY name,nickname;";

       	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))

      	  {

		  $tid=$row['team_id'];

	    	  echo "      <option value=$tid";

		  if ($tid==$team_id) {echo " selected";}

	    	  echo ">".$row['name']." ".$row['nickname']."</option>\n";

	  }

       	  echo "     </select>\n";

	  echo "    </td>\n";

       	  echo "   </tr>\n";

	  echo "  </table>\n";

       	  echo "</div>\n";

       

	  if (($settings['scoutsOn']==1)&&((($_SESSION['Ratings']!='Hidden')&&($_SESSION['Ratings']!=""))||(($_SESSION['Talents']!='Hidden')&&($_SESSION['Ratings']!=""))))

	  {

		  echo "<div class='textbox' style='border:0px;'>Ratings scouted by StatsLab</div>\n";

	  }



	  ## Get Team Info

	  $tList="";

       	  $query="SELECT team_id,league_id,name,nickname,abbr,parent_team_id,league_id,level,background_color_id,text_color_id,logo_file_name FROM teams WHERE (team_id=$team_id OR parent_team_id=$team_id);";

	  $result=mysqli_query($db,$query);

       	  while ($row=mysqli_fetch_array($result))

	  {

	    	  $tid=$row['team_id'];

		  $league_id=$row['league_id'];

	     	  $name=$row['name']." ".$row['nickname'];

		  $teams[$tid]['name']=$name;

	    	  $teams[$tid]['abbr']=$row['abbr'];

		  $teams[$tid]['league_id']=$row['league_id'];

	    	  $teams[$tid]['parent_team_id']=$row['parent_team_id'];

		  $lvl=get_level($row['level']);

	    	  $teams[$tid]['level']=$lvl;

		  $teams[$tid]['background_color_id']=$row['background_color_id'];

	    	  $teams[$tid]['text_color_id']=$row['text_color_id'];

		  $teams[$tid]['logo_file']=urlencode($row['logo_file_name']);

	    	  if (!isset($leagues[$league_id]['lvl'])) {$leagues[$league_id]['lvl']=$lvl;}

		  $tList.=",$tid";

      	  }

	  $tList=trim($tList,",");



	  ## Get team notice

	  $query="SELECT * FROM trade_block_teams WHERE team_id=$team_id;";

	  $result=mysqli_query($db,$query);

       	  if (mysqli_num_rows($result))

	  {

	    	  $numFields=mysqli_num_fields($result);

		  while ($row=mysqli_fetch_array($result))

	   	  {

			  $tid=$row['team_id'];

		 	  for ($i=1;$i<$numFields;$i++) 

			  {

				$fieldInfo = mysqli_fetch_field_direct( $result, $i);

				$fieldname = $fieldInfo->name;

				  $teams[$tid][$fieldname]=$row[$fieldname];

			  }

			  $notice=stripslashes($teams[$tid]['notice']);

			  $notice=clean_bbcode(htmlspecialchars($notice));

			  $notice=nl2br($notice);

			  $teams[$tid]['notice']=$notice;

		 	  $tneeds="";

			  if ($teams[$tid]['catcher']==1) {$tneeds.=" C";}

		 	  if ($teams[$tid]['first_base']==1) {$tneeds.=", 1B";}

			  if ($teams[$tid]['second_base']==1) {$tneeds.=", 2B";}

		 	  if ($teams[$tid]['third_base']==1) {$tneeds.=", 3B";}

			  if ($teams[$tid]['shortstop']==1) {$tneeds.=", SS";}

		 	  if ($teams[$tid]['left_field']==1) {$tneeds.=", RF";}

			  if ($teams[$tid]['center_field']==1) {$tneeds.=", CF";}

		 	  if ($teams[$tid]['right_field']==1) {$tneeds.=", LF";}

			  if ($teams[$tid]['starting_pitcher']==1) {$tneeds.=", SP";}

		 	  if ($teams[$tid]['relief_pitcher']==1) {$tneeds.=", RP";}

			  $teams[$tid]['needs']=trim($tneeds,", ");

	   	  }

	  }

       

	  echo " <div class='textbox' style='background-color:".$teams[$team_id]['background_color_id'].";color:".$teams[$team_id]['text_color_id'].";font-weight:bold;font-size:2em;text-align:center;width:935px;margin-bottom:0;border-bottom:0;'>".$teams[$team_id]['name']."</div>\n";

	  echo " <div class='textbox' style='text-align:center;width:935px;margin-top:0;border-top:0;border-bottom:0;'><b>Team Notice:</b><br/>".$teams[$team_id]['notice']."</div>\n";

       	  echo " <div class='textbox' style='text-align:center;width:935px;margin-top:0;border-top:0;border-bottom:0;'><b>Team Needs:</b><br/>".htmlspecialchars($teams[$team_id]['needs'])."</div>\n";

       

	  echo " <div class='textbox' style='text-align:center;width:935px;margin-top:0;border-top:0;'><b>Contact:</b> ";

	  $first=1;

       	  $hide_info=$managers[$team_id]['hide_info'];

	  if (($hide_info==0)||(isset($_SESSION['user_id'])))

      	  {

		  $pm_link=$managers[$team_id]['pm_link'];

	    	  $email=$managers[$team_id]['email'];

		  $aim=$managers[$team_id]['aim'];

	    	  $yim=$managers[$team_id]['yim'];

		  $msn=$managers[$team_id]['msn'];

	    	  $icq=$managers[$team_id]['icq'];

	    

		  if ($email!="")

		  {

		 	  $e=explode(";",$email);

			  echo "<a href='mailto:".$e[0]."'>Email</a>";

		 	  $first=0;

		  }

	    	  if ($pm_link!="") {if ($first==0) {echo " / ";} else {$first=0;} echo "<a href='$pm_link'>PM</a>";}

		  if ($aim!="") {if ($first==0) {echo " / ";} else {$first=0;} echo "<a href='aim:goim?screenname=$aim'>AIM</a>";}

	    	  if ($yim!="") {if ($first==0) {echo " / ";} else {$first=0;} echo "<a href='http://webmessenger.yahoo.com/?im=$yim'>Yahoo</a>";}

		  if ($msn!="") {if ($first==0) {echo " / ";} else {$first=0;} echo "<a href='msnim:chat?contact=$msn'>MSN</a>";}

	    	  if ($icq!="") {if ($first==0) {echo " / ";} else {$first=0;} echo "<a href='http://www.icq.com/people/cmd.php?uin=$icq&action=message'>ICQ</a>";}

		  if ($first==1) {echo "No contact information available";}

	  }

      	  else {echo "You must be logged in to see contact information";}

	  echo "</div>\n";

       

	  ## Get Player List

	  $pList="";

       	  $query="SELECT player_id FROM players_roster_status WHERE team_id IN ($tList) AND trade_status=2;";

	  $result=mysqli_query($db,$query);

       	  if (!mysqli_num_rows($result))

	  {

	    	  echo " <div class='textbox' style='border:0;width:935px;'>No players on the block</div>\n";

	  }

	  else

      	  {

		  while ($row=mysqli_fetch_array($result))

	   	  {

			  $pid=$row['player_id'];

		 	  $pList.=",$pid";

		  }

		  $pList=trim($pList,",");



		  ## Get Batter Ratings

		  $bratArray=Array('batting_ratings_overall_contact','batting_ratings_overall_gap','batting_ratings_overall_power','batting_ratings_overall_eye','batting_ratings_overall_strikeouts','batting_ratings_talent_contact','batting_ratings_talent_gap','batting_ratings_talent_power','batting_ratings_talent_eye','batting_ratings_talent_strikeouts');

		  $brRatArray=Array('running_ratings_speed','running_ratings_stealing','running_ratings_baserunning');

		  $query="SELECT player_id";

		  foreach ($bratArray as $key => $ratLbl)

		  {

			  # Get scale

			  $ratScale=get_scale($ratLbl);

			  $scale=$_SESSION[$ratScale];

	  

			  # Add to query

			  $query.=",".ratings_query($ratLbl,$scale);

			  $query.=" as $ratLbl";

		  }

		  if ($settings['scoutsOn']==1)

		  {

			  foreach ($brRatArray as $key => $ratLbl)

			  {

				  # Get scale

				  $ratScale=get_scale($ratLbl);

				  $scale=$_SESSION[$ratScale];

	  

				  # Add to query

				  $query.=",".ratings_query($ratLbl,$scale);

				  $query.=" as $ratLbl";

			  }

		  }		  $query.=" FROM players_batting";

		  if ($settings['scoutsOn']==1) {$query.="_scouted";}

		  $query.=" WHERE player_id IN ($pList);";

	    	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  foreach ($bratArray as $key => $ratLbl) {$players[$pid][$ratLbl]=$row[$ratLbl];}

			  if ($settings['scoutsOn']==1)

			  {

				  foreach ($brRatArray as $key => $ratLbl) {$players[$pid][$ratLbl]=$row[$ratLbl];}

			  }

		  }

	    

		  ## Get Pitcher Ratings

		  $pratArray=Array('pitching_ratings_overall_stuff','pitching_ratings_overall_control','pitching_ratings_overall_movement','pitching_ratings_misc_velocity','pitching_ratings_misc_stamina','pitching_ratings_pitches_fastball','pitching_ratings_pitches_slider','pitching_ratings_pitches_curveball','pitching_ratings_pitches_screwball','pitching_ratings_pitches_forkball','pitching_ratings_pitches_changeup','pitching_ratings_pitches_sinker','pitching_ratings_pitches_splitter','pitching_ratings_pitches_knuckleball','pitching_ratings_pitches_cutter','pitching_ratings_pitches_circlechange','pitching_ratings_pitches_knucklecurve','pitching_ratings_misc_ground_fly','pitching_ratings_talent_stuff','pitching_ratings_talent_control','pitching_ratings_talent_movement','pitching_ratings_pitches_talent_fastball','pitching_ratings_pitches_talent_slider','pitching_ratings_pitches_talent_curveball','pitching_ratings_pitches_talent_screwball','pitching_ratings_pitches_talent_forkball','pitching_ratings_pitches_talent_changeup','pitching_ratings_pitches_talent_sinker','pitching_ratings_pitches_talent_splitter','pitching_ratings_pitches_talent_knuckleball','pitching_ratings_pitches_talent_cutter','pitching_ratings_pitches_talent_circlechange','pitching_ratings_pitches_talent_knucklecurve');

		  $query="SELECT player_id";

		  foreach ($pratArray as $key => $ratLbl)

		  {

			  # Get scale

			  $ratScale=get_scale($ratLbl);

			  $scale=$_SESSION[$ratScale];

	  

			  # Add to query

			  $query.=",".ratings_query($ratLbl,$scale);

			  $query.=" as $ratLbl";

		  }

		  $query.=" FROM players_pitching";

		  if ($settings['scoutsOn']==1) {$query.="_scouted";}

		  $query.=" WHERE player_id IN ($pList);";

	    	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  while ($row=mysqli_fetch_array($result))

		  {

		 	  $pid=$row['player_id'];

			  foreach ($pratArray as $key => $ratLbl) {$players[$pid][$ratLbl]=$row[$ratLbl];}

		  }

	    

		  ## Get Fielding Ratings

		  $fratArray=Array('fielding_rating_pos2','fielding_rating_pos3','fielding_rating_pos4','fielding_rating_pos5','fielding_rating_pos6','fielding_rating_pos7','fielding_rating_pos8','fielding_rating_pos9','fielding_ratings_catcher_arm','fielding_ratings_infield_arm','fielding_ratings_outfield_arm');

		  $query="SELECT player_id";

		  foreach ($fratArray as $key => $ratLbl)

		  {

			  # Get scale

			  $ratScale=get_scale($ratLbl);

			  $scale=$_SESSION[$ratScale];

	  

			  # Add to query

			  $query.=",".ratings_query($ratLbl,$scale);

			  $query.=" as $ratLbl";

		  }

		  $query.=" FROM players_fielding";

		  if ($settings['scoutsOn']==1) {$query.="_scouted";}

		  $query.=" WHERE player_id IN ($pList);";

	    	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  while ($row=mysqli_fetch_array($result))

		  {

		 	  $pid=$row['player_id'];

			  foreach ($fratArray as $key => $ratLbl) {$players[$pid][$ratLbl]=$row[$ratLbl];}

		  }

	    

		  #### Get Batting Stats

		  ## This Year

		  $bstatArray=Array('g','ab','h','d','t','hr','rbi','r','bb','hp','sh','sf','k','sb','cs','avg','obp','slg','ops','war','wOBA');

		  $query="SELECT player_id";

		  foreach ($bstatArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}

		  $query.=" FROM players_career_batting_stats WHERE player_id IN ($pList) AND league_id=$lgid AND split_id=1 AND year=$lgyear GROUP BY player_id";

		  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	    	  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

	   	  {

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];

		      		  foreach ($bstatArray as $key => $statLbl) {$players[$pid][$lgyear][$statLbl]=stat_format($statLbl,$row[$statLbl]);}

			  }

	   	  }

	    

		  ## 3 Year Average

		  $avgString=($lgyear-3)."-".(($lgyear-1)%100)." Avg";

		  $query="SELECT player_id,COUNT(DISTINCT year) as yrs";

		  foreach ($bstatArray as $key => $statLbl) 

		  {

			  switch ($statLbl)

			  {

			  case 'avg':

			  case 'obp':

			  case 'slg':

			  case 'ops':

			  case 'wOBA':

				  $query.=",".stat_query($statLbl)." as $statLbl";

				  break;

			  default:

				  $query.=",(".stat_query($statLbl).")/COUNT(DISTINCT year) as $statLbl";

				  break;

			  }

		  }

		  $query.=" FROM players_career_batting_stats WHERE player_id IN ($pList) AND league_id=$lgid AND split_id=1 AND year>=($lgyear-3) AND year<=($lgyear-1) GROUP BY player_id";

	    	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  if (mysqli_num_rows($result))

		  {

		 	  while ($row=mysqli_fetch_array($result))

			  {

		      		  $pid=$row['player_id'];

				  $players[$pid][$avgString]['yrs']=$row['yrs'];

				  foreach ($bstatArray as $key => $statLbl)

				  {

					  switch ($statLbl)

					  {

					  case 'avg':

					  case 'obp':

					  case 'slg':

					  case 'ops':

					  case 'wOBA':	

						  $players[$pid][$avgString][$statLbl]=stat_format($statLbl,$row[$statLbl]);

						  break;

					  default:

						  $players[$pid][$avgString][$statLbl]=stat_format($statLbl,$row[$statLbl],0);

						  break;

					  }

				  }

			  }

	   	  }

	    

		  ## Career

		  $query="SELECT player_id";

		  foreach ($bstatArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}

		  $query.=" FROM players_career_batting_stats WHERE player_id IN ($pList) AND league_id=$lgid AND split_id=1 GROUP BY player_id";

		  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	    	  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

	   	  {

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];

		      		  foreach ($bstatArray as $key => $statLbl) {$players[$pid]['Career'][$statLbl]=stat_format($statLbl,$row[$statLbl]);}

			  }

	   	  }

	    

		  #### Get Pitching Stats

		  ## This Year

		  $pstatArray=Array('g','gs','w','l','s','era','ip','ha','r','er','hra','bb','k','hld','cg','sho','whip','oavg','war');

		  $query="SELECT player_id";

		  foreach ($pstatArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}

		  $query.=" FROM players_career_pitching_stats WHERE player_id IN ($pList) AND league_id=$lgid AND split_id=1 AND year=$lgyear GROUP BY player_id";

		  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	    	  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

	   	  {

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];

		      		  foreach ($pstatArray as $key => $statLbl) {$players[$pid][$lgyear]['p'][$statLbl]=stat_format($statLbl,$row[$statLbl]);}

		      		  $players[$pid][$lgyear]['pg']=$row['g'];

			  }

	   	  }

	    

		  ## 3 Year Average

		  $query="SELECT player_id,COUNT(DISTINCT year) as yrs";

		  foreach ($pstatArray as $key => $statLbl) 

		  {

			  switch ($statLbl)

			  {

			  case 'era':

			  case 'whip':

			  case 'oavg':

				  $query.=",".stat_query($statLbl)." as $statLbl";

				  break;

			  default:

				  $query.=",(".stat_query($statLbl).")/COUNT(DISTINCT year) as $statLbl";

				  break;

			  }

		  }

		  $query.=" FROM players_career_pitching_stats WHERE player_id IN ($pList) AND league_id=$lgid AND split_id=1 AND year>=($lgyear-3) AND year<=($lgyear-1) GROUP BY player_id";

	    	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  if (mysqli_num_rows($result))

		  {

		 	  while ($row=mysqli_fetch_array($result))

			  {

		      		  $pid=$row['player_id'];

				  $players[$pid][$avgString]['pyrs']=$row['yrs'];

				  foreach ($pstatArray as $key => $statLbl)

				  {

					  switch ($statLbl)

					  {

					  case 'era':

					  case 'whip':

					  case 'oavg':

						  $players[$pid][$avgString]['p'][$statLbl]=stat_format($statLbl,$row[$statLbl]);

						  break;

					  default:

						  $players[$pid][$avgString]['p'][$statLbl]=stat_format($statLbl,$row[$statLbl],0);

						  break;

					  }

				  }

			  }

	   	  }      

	    

		  ## Career

		  $query="SELECT player_id";

		  foreach ($pstatArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}

		  $query.=" FROM players_career_pitching_stats WHERE player_id IN ($pList) AND league_id=$lgid AND split_id=1 GROUP BY player_id";

	    	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  if (mysqli_num_rows($result))

		  {

		 	  while ($row=mysqli_fetch_array($result))

			  {

		      		  $pid=$row['player_id'];

		      		  foreach ($pstatArray as $key => $statLbl) {$players[$pid]['Career']['p'][$statLbl]=stat_format($statLbl,$row[$statLbl]);}

			  }

	   	  }

	    

		  $statScope=array($lgyear,$avgString,'Career');

	    

		  ## Get trade block information

		  $query="SELECT * FROM trade_block_players WHERE player_id IN ($pList);";

	    	  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

	   	  {

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];

		      		  $players[$pid]['headline']=stripslashes($row['headline']);

				  $notice=stripslashes($row['notice']);

				  $notice=clean_bbcode(htmlspecialchars($notice));

				  $notice=nl2br($notice);

				  $players[$pid]['notice']=$notice;

			  }

		  }

	     

		  ## Get Salary Info

		  if ($settings['finEnable']==1)

	   	  {

			  $query="SELECT player_id,season_year,salary0,salary1,salary2,salary3,salary4,salary5,salary6,salary7,salary8,salary9,years FROM players_contract WHERE player_id IN ($pList);";

		 	  $result=mysqli_query($db,$query);

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];

		      		  $yr=$row['season_year'];

				  $remYrs=$lgyear-$yr;

		      		  $field='salary'.$remYrs;

				  $totYrs=$row['years'];

		      		  $remYrs=$lgyear+$totYrs-$remYrs-1;

		      

				  $sal=$row[$field];

				  if ($sal==0) {$sal="MLC";} else {$sal="$".number_format($sal)." (<a href='./payroll.php?player=$pid' title='Contract detail'>$</a>)";}

		      		  $players[$pid]['salary']=$sal;

				  $players[$pid]['salThrough']=$remYrs;

			  }

	   	  }

	    

		  ## Get Players

		  $query="SELECT player_id,first_name,last_name,date_of_birth,age,position,role,height,weight,team_id,bats,throws,injury_is_injured";

		  if ($settings['scoutsOn']!=1)

		  {

			  foreach ($brRatArray as $key => $ratLbl)

			  {

				  # Get scale

				  $ratScale=get_scale($ratLbl);

				  $scale=$_SESSION[$ratScale];

	  

				  # Add to query

				  $query.=",".ratings_query($ratLbl,$scale);

				  $query.=" as $ratLbl";

			  }

		  }

		  $query.=" FROM players WHERE player_id IN ($pList) ORDER BY last_name,first_name;";

	    	  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

	   	  {

			  $htmlpath=$_SESSION['htmlroot'].$_SESSION['htmlpath'];

		 	  while ($row=mysqli_fetch_array($result))

			  {

		      		  $pid=$row['player_id'];

				  $name=$row['first_name']." ".$row['last_name'];

		      		  $dob=new Date($row['date_of_birth']);

				  $age=$row['age'];

		      		  $tid=$row['team_id'];

				  $orgID=$row['organization_id'];

		      		  $pos=$row['position'];

				  $bats=get_hand($row['bats']);

		      		  $throws=get_hand($row['throws']);

				  $height=cm_to_ft_in($row['height']);

		      		  $weight=$row['weight']." lbs";

				  $inj=$row['injury_is_injured'];



				  if ($settings['scoutsOn']!=1)

				  {

					  foreach ($brRatArray as $key => $ratLbl) {$players[$pid][$ratLbl]=$row[$ratLbl];}

				  }

			

				  echo " <div class='textbox'>\n";

				  echo "  <table cellpadding=0 cellspacing=0 border=0 width='935px'>\n";

		      		  echo "   <tr class='title2'><td colspan=2>";

				  if ($pos==1) {echo get_pos($row['role'],1);} else {echo get_pos($pos,1);}

		      		  echo " $name ($age yrs old)</td></tr>\n";

				  echo "   <tr>\n";

		      		  echo "    <td valign='top'>";

				  $imgpath=$lgpath."/images/person_pictures/player_$pid.png";            ## Check for photo by player ID

				  $ch = curl_init($imgpath);

				  curl_setopt($ch, CURLOPT_NOBODY, true);

				  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

				  curl_setopt($ch, CURLOPT_FILETIME, true); 

				  curl_exec($ch);

				  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

				  if ($retcode==200) {echo "<img src='$imgpath'>";}

				  else

				  {

					  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".png";   ## Check for capitalized name PNG

					  $ch = curl_init($imgpath);

					  curl_setopt($ch, CURLOPT_NOBODY, true);

					  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

					  curl_setopt($ch, CURLOPT_FILETIME, true); 

					  curl_exec($ch);

					  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

					  if ($retcode==200) {echo "<img src='$imgpath'>";}

					  else

					  {

						  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".png";   ## Check for lowercase name PNG

						  $ch = curl_init($imgpath);

						  curl_setopt($ch, CURLOPT_NOBODY, true);

						  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

						  curl_setopt($ch, CURLOPT_FILETIME, true); 

						  curl_exec($ch);

						  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

						  if ($retcode==200) {echo "<img src='$imgpath'>";}

						  else

						  {

							  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".jpg";   ## Check for capitalized name JPG

							  $ch = curl_init($imgpath);

							  curl_setopt($ch, CURLOPT_NOBODY, true);

							  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

							  curl_setopt($ch, CURLOPT_FILETIME, true); 

							  curl_exec($ch);

							  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

							  if ($retcode==200) {echo "<img src='$imgpath'>";}

							  else

							  {

								  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".jpg";   ## Check for lowercase name JPG

								  $ch = curl_init($imgpath);

								  curl_setopt($ch, CURLOPT_NOBODY, true);

								  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

								  curl_setopt($ch, CURLOPT_FILETIME, true); 

								  curl_exec($ch);

								  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

								  if ($retcode==200) {echo "<img src='$imgpath'>";}

								  else

								  {

									  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".bmp";   ## Check for capitalized name BMP

									  $ch = curl_init($imgpath);

									  curl_setopt($ch, CURLOPT_NOBODY, true);

									  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

									  curl_setopt($ch, CURLOPT_FILETIME, true); 

									  curl_exec($ch);

									  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

									  if ($retcode==200) {echo "<img src='$imgpath'>";}

									  else

									  {

										  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".bmp";   ## Check for lowercase name bmp

										  $ch = curl_init($imgpath);

										  curl_setopt($ch, CURLOPT_NOBODY, true);

										  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

										  curl_setopt($ch, CURLOPT_FILETIME, true); 

										  curl_exec($ch);

										  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

										  if ($retcode==200) {echo "<img src='$imgpath'>";}

										  else

										  {

											  echo "<img src='$lgpath/images/default_player_photo.jpg'>";   ## Show default

										  }

									  }

								  }

							  }

						  }

					  }

				  }

				  echo "</td>\n";

				  echo "    <td valign='top'>\n";



				  echo "     <table cellpadding=2 cellspacing=0 border=0 width='845px'>\n";

		      		  echo "      <tr class='s2_l'><td colspan=20><b>Links:</b> <a href='./player.php?player_id=$pid'>StatsLab Player Page</a>, <a href='$lgpath/players/player_$pid.html'>OOTP Player Page</a>, <a href='$lgpath/teams/team_$tid.html'>".$teams[$tid]['name']."</a></td></tr>\n";

				  echo "      <tr class='s1_l'><td colspan=2><b>DOB:</b> ".$dob->format("m/d/Y")."</td><td colspan=2><b>Bat:</b> $bats</td><td colspan=2><b>Throw:</b> $throws</td><td colspan=2><b>Ht:</b> $height</td><td colspan=2><b>Wt:</b> $weight</td>";

		      		  if ($settings['finEnable']==1) {echo "<td colspan=8><b>Salary:</b> ".$players[$pid]['salary']."</td>";} else {echo "<td colspan=8>&nbsp;</td>";}

				  if ($inj==1) {echo "<td colspan=2 style='text-align:right;color:#990000;font-weight:bold;'>Injured</td>";} else {echo "<td colspan=2>&nbsp;</td>";}

				  echo "</tr>\n";

				  echo "      <tr class='s2_l'><td colspan=20><b>Headline:</b> ".$players[$pid]['headline']."</td></tr>\n";

		      		  echo "      <tr class='s1_l'><td colspan=20><b>Notice:</b> ".$players[$pid]['notice']."</td></tr>\n";

			

				  ## Display Ratings

				  if ((($_SESSION['Ratings']=='Hidden')||($_SESSION['Ratings']==""))&&(($_SESSION['Talents']=='Hidden')||($_SESSION['Talents']==""))&&(($_SESSION['Others']=='Hidden')||($_SESSION['Others']=="")))

				  {

			   		  echo "      <tr class='s1'><td colspan=20 rowspan=4>&nbsp;</td></tr>\n";

				  }

		     		  else

				  {

			   		  echo "      <tr class='headline'><td colspan=20>Ratings</td></tr>\n";

					  if ($pos==1)

			  		  {

						  echo "      <tr class='headline'><td colspan=2>&nbsp;</td><td class='hsc2'>Stuff</td><td class='hsc2'>Control</td><td class='hsc2'>Movement</td><td class='hsc2'>Velocity</td><td class='hsc2'>Stamina</td><td class='hsc2' style='border-left:1px solid #AAAAAA;'>Fst</td><td class='hsc2'>Sld</td><td class='hsc2'>Crv</td><td class='hsc2'>Scw</td><td class='hsc2'>Frk</td><td class='hsc2'>Chg</td><td class='hsc2'>Snk</td><td class='hsc2'>Spl</td><td class='hsc2'>Knk</td><td class='hsc2'>Cut</td><td class='hsc2'>CCh</td><td class='hsc2'>KCv</td><td class='hsc2' style='border-left:1px solid #AAAAAA;'>GB%</td></tr>\n";

						  echo "      <tr class='s2'><td class='s2_l' colspan=2>Overall</td>";

						  foreach ($pratArray as $key => $ratLbl)

						  {

							  switch ($ratLbl)

							  {

							  case 'pitching_ratings_misc_velocity':

								  echo "<td>".get_velocity($players[$pid][$ratLbl])."</td>";

								  break;

							  case 'pitching_ratings_pitches_talent_fastball':

								  echo "<td>&nbsp;</td>";

								  echo "<td>&nbsp;</td>";

							  case 'pitching_ratings_pitches_fastball':

							  case 'pitching_ratings_misc_ground_fly':

								  echo "<td style='border-left:1px solid #AAAAAA;'>".$players[$pid][$ratLbl]."</td>";

								  break;

							  case 'pitching_ratings_talent_stuff':

								  echo "</tr>\n";

								  echo "      <tr class='s1'><td class='s1_l' colspan=2>Potential</td>";

							  default:

								  echo "<td>".$players[$pid][$ratLbl]."</td>";

								  break;

							  }

						  }

						  echo "<td style='border-left:1px solid #AAAAAA;'>&nbsp;</td>";

						  echo "</tr>\n";

			  		  }

					  else

					  {

						  echo "      <tr class='headline'><td>&nbsp;</td><td class='hsc2'>Contact</td><td class='hsc2'>Gap</td><td class='hsc2'>Power</td><td class='hsc2'>Eye</td><td class='hsc2'>Avoid K's</td><td class='hsc2' style='border-left:1px solid #AAAAAA;'>Sp</td><td class='hsc2'>Sta</td><td class='hsc2'>BR</td><td class='hsc2' style='border-left:1px solid #AAAAAA;'>C</td><td class='hsc2'>1B</td><td class='hsc2'>2B</td><td class='hsc2'>3B</td><td class='hsc2'>SS</td><td class='hsc2'>LF</td><td class='hsc2'>CF</td><td class='hsc2'>RF</td><td class='hsc2' style='border-left:1px solid #AAAAAA;'>C Arm</td><td class='hsc2'>IF Arm</td><td class='hsc2'>OF Arm</td></tr>\n";

						  echo "      <tr class='s2'><td class='s2_l'>Overall</td>";

						  $dratArray=array_merge(array_slice($bratArray,0,5),$fratArray,array_slice($bratArray,5));

						  foreach ($dratArray as $key => $ratLbl)

						  {

							  switch ($ratLbl)

							  {

							  case 'fielding_rating_pos2':

								  foreach ($brRatArray as $key => $brRatLbl)

								  {

									  if ($brRatLbl=='running_ratings_speed') {echo "<td style='border-left:1px solid #AAAAAA;'>".$players[$pid][$brRatLbl]."</td>";}

									  else {echo "<td>".$players[$pid][$brRatLbl]."</td>";}

								  }

							  case 'fielding_ratings_catcher_arm':

								  echo "<td style='border-left:1px solid #AAAAAA;'>".$players[$pid][$ratLbl]."</td>";

								  break;

							  case 'batting_ratings_talent_contact':

								  echo "</tr>\n";

								  echo "      <tr class='s1'><td class='s1_l'>Potential</td>";

							  default:

								  echo "<td>".$players[$pid][$ratLbl]."</td>";

								  break;

							  }

						  }

						  echo "<td colspan=3 style='border-left:1px solid #AAAAAA;'>&nbsp;</td>";

						  echo "<td colspan=8 style='border-left:1px solid #AAAAAA;'>&nbsp;</td>";

						  echo "<td colspan=3 style='border-left:1px solid #AAAAAA;'>&nbsp;</td>";

						  echo "</tr>\n";

			  		  }

				  }

		      		  echo "     </table>\n";

				  echo "    </td>\n";

		      		  echo "   </tr>\n";

		      

				  ## Display Stats

				  echo "   <tr>\n";

		      		  echo "    <td colspan=2>\n";

				  echo "     <table cellpadding=2 cellspacing=0 border=0 width='935px'>\n";

		      		  if ($pos==1) {$nCols=2+count($pstatArray);} else {$nCols=2+count($bstatArray);}

				  echo "      <tr class='headline'><td colspan=$nCols>Major League Statistics</td></tr>\n";

		      		  echo "      <tr class='headline'><td class='hsc2_l'>Scope</td>";

				  if ($pos==1) 

				  {

					  foreach ($pstatArray as $key => $statLbl) {echo "<td class='hsc2'>".stat_text($statLbl,1)."</td>";}

					  echo "</tr>\n";

					  $cnt=0;

			   		  foreach ($statScope as $key => $val)

					  {

						  $cls='s'.($cnt%2+1);

						  echo "      <tr class='$cls'>";

						  if (($val==$avgString)&&($players[$pid][$val]['pyrs']==1)) {$dispVal=$val." (1 yr)";}

						  elseif (($val==$avgString)&&($players[$pid][$val]['pyrs']==2)) {$dispVal=$val." (2 yrs)";}

			       			  else {$dispVal=$val;}

						  echo "<td class='".$cls."_l'>$dispVal</td>";

						  if (!isset($players[$pid][$val]['p']['g'])) {echo "<td colspan=".($nCols-1)." style='text-align:center;'>- No major league statistics -</td>";}

						  else

						  {

							  foreach ($pstatArray as $key => $statLbl) {echo "<td>".$players[$pid][$val]['p'][$statLbl]."</td>";}

						  }

						  echo "</tr>\n";

						  $cnt++;

			  		  }

				  }

		     		  else

				  {

					  foreach ($bstatArray as $key => $statLbl) {echo "<td class='hsc2'>".stat_text($statLbl,1)."</td>";}

				   	  echo "</tr>\n";

					  $cnt=0;

			   		  foreach ($statScope as $key => $val)

					  {

						  $cls='s'.($cnt%2+1);

						  echo "      <tr class='$cls'>";

						  if (($val==$avgString)&&($players[$pid][$val]['yrs']==1)) {$dispVal=$val." (1 yr)";}

						  elseif (($val==$avgString)&&($players[$pid][$val]['yrs']==2)) {$dispVal=$val." (2 yrs)";}

			       			  else {$dispVal=$val;}

						  echo "<td class='".$cls."_l'>$dispVal</td>";

						  if (!isset($players[$pid][$val]['g'])) {echo "<td colspan=".($nCols-1)." style='text-align:center;'>- No major league statistics -</td>";}

						  else

			       			  {

							  foreach ($bstatArray as $key => $statLbl) {echo "<td>".$players[$pid][$val][$statLbl]."</td>";}

						  }

						  echo "</tr>\n";

						  $cnt++;

			  		  }

				  }

		      		  echo "     </table>\n";

				  echo "    </td>\n";

		      		  echo "   </tr>\n";

				  echo "  </table>\n";

		      		  echo " </div>\n";

				  $cnt++;

			  }

		  }

      	  }

  }



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);





?>

