<?php
  include("html_functions.php");

  ################## PAGE INITIALIZATION #########################
  $lgid=$_SESSION['lgid'];
  $lgpath=$_SESSION['lgpath'];
  $date=new Date($_SESSION['lgdate']);
  $lgyear=$date->format("Y");

  if (($_SESSION['user_team_id']>0)&&(!isset($_GET['team_id'])))
  {
	  if ($_SESSION['user_league_id']==$lgid) {$team_id=$_SESSION['user_team_id'];}
	  else
	  {
		  include($_SESSION['adminpath']."/dbopen.php");
		  $query="SELECT team_id FROM teams WHERE parent_team_id=".$_SESSION['user_team_id']." AND league_id=$lgid";
		  $result=mysqli_query($db,$query);
		  if (mysqli_num_rows($result))
		  {
			  $row=mysqli_fetch_array($result);
			  $team_id=$row['team_id'];
		  }
		  mysqli_close($db);
	  }
  }
  elseif (isset($_GET['team_id'])) {$team_id=$_GET['team_id'];}
  if ($team_id=="") {$team_id=-1;}
  $tyear=$_GET['year'];
	  
  ##### Get Team Names #####
  include($_SESSION['adminpath']."/dbopen.php");
  $query="SELECT team_id,name,nickname FROM teams WHERE league_id=$lgid";
  if ($team_id>0) {$query.=" AND team_id=$team_id";}
  $query.=" AND allstar_team=0 ORDER BY name,nickname LIMIT 1;";
  $result=mysqli_query($db,$query);
  while ($row=mysqli_fetch_array($result))
  {
	  $team_id=$row['team_id'];
	  $tname=$row['name']." ".$row['nickname'];
  }
  mysqli_close($db);
  
  ##### Get Title #####
  $title=$tname." History - Pitching Registry";
  page_head($title,$_SESSION['lgpath'],"","","./jquery/excanvas.js|./jquery/jquery.min.js|./jquery/jquery.jqplot.min.js|./jquery/plugins/jqplot.categoryAxisRenderer.min.js|./jquery/plugins/jqplot.pointLabels.min.js|./jquery/plugins/jqplot.barRenderer.min.js|./jquery/plugins/jqplot.highlighter.min.js|./jquery/plugins/jqplot.cursor.min.js");
  echo " <div id='topbar'>\n";
  main_titlebar($lgid,$_SESSION['lgpath'],$title,$team_id);
  nav_toolbar("history","History");
  nav_toolbar("teams","Teams","","",$team_id,$tyear);

  ##### Show Page Content #####
  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";

  ##### Check for file #####
  echo gen_pit($team_id);

  ################## END OF PAGE #########################
  echo " </div>   <!-- END contentpane DIV -->\n";
  page_foot($_SESSION['lgpath']);

  exit;

##############################################################################################
# gen_pit - Pitcher Registry
##############################################################################################
function gen_pit($tid="")
 {
   ##### Exit if no team_id #####
   if ($tid=="") {exit;}
   include($_SESSION['adminpath']."/dbopen.php");

   ##### Check for tables #####
   $query="SHOW TABLES LIKE 'team_history%';";
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result)<5) {return "Please load the team_history SQL tables first";}

   ##### Get basic parameters #####
   $lgdate=$_SESSION['lgdate'];
   $lgpath=$_SESSION['lgpath'];
   $lgid=$_GET['lgid'];
   if ($lgid=="") {$lgid=$_SESSION['lgid'];}
   if ($lgid=="") {$lgid=100;}
   $text="";
	
   ##### Get Team Totals #####
   $query="SELECT year,r,g,cg,sho,s,(ip*3+ipf)/3 as ip,er,ha,hra,bb,k,ab,sf FROM team_history_pitching_stats WHERE team_id=$tid UNION SELECT year,r,g,cg,sho,s,(ip*3+ipf)/3 as ip,er,ha,hra,bb,k,ab,sf FROM team_pitching_stats WHERE team_id=$tid ORDER BY year;";
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result)>0)
    {
      $text.="<div class='textbox'>\n";
      $text.=" <table cellpadding=0 cellspacing=0 border=0 width='930px'>\n";
      $text.="  <tr class='title'><td style='padding:2px;'>Team Pitching Totals</td></tr>\n";
      $text.="  <tr><td>\n";
      $text.="   <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='100%'>\n";
      $text.="    <thead><tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2'>R/G</td><td class='hsc2'>R</td><td class='hsc2'>G</td><td class='hsc2'>CG</td><td class='hsc2'>SHO</td><td class='hsc2'>SV</td><td class='hsc2'>ERA</td><td class='hsc2'>IP</td><td class='hsc2'>H</td><td class='hsc2'>HR</td><td class='hsc2'>BB</td><td class='hsc2'>K</td><td class='hsc2'>WHIP</td><td class='hsc2'>OAVG</td><td class='hsc2'>BABIP</td></tr></thead>\n";
      $cnt=0;
      while ($row=mysqli_fetch_array($result))
       {
         $yr=$row['year'];
	 $r=$row['r'];
	 $g=$row['g'];
         if (($yr==0)||($g==0)) {continue;}
	 $cg=$row['cg'];
	 $sho=$row['sho'];
	 $sv=$row['s'];
	 $ip=$row['ip'];
	 $er=$row['er'];
	 $ha=$row['ha'];
	 $hra=$row['hra'];
	 $bb=$row['bb'];
	 $k=$row['k'];
	 $ab=$row['ab'];
	 $sf=$row['sf'];

	 $Tyr+=1;
	 $Tr+=$r;
	 $Tg+=$g;
	 $Tcg+=$cg;
	 $Tsho+=$sho;
	 $Tsv+=$sv;
	 $Tip+=$ip;
	 $Ter+=$er;
	 $Tha+=$ha;
	 $Thra+=$hra;
	 $Tbb+=$bb;
	 $Tk+=$k;
	 $Tab+=$ab;
	 $Tsf+=$sf;

         if ($g==0) {$rpg=0;}
	  else {$rpg=$r/$g;}
	 $rpg=sprintf("%.1f",$rpg);

	 if ($ip==0) {$era=0;$whip=0;}
          else
          {
            $era=9*$er/$ip;
            $whip=($ha+$bb)/$ip;
          }
	 $bip=$ab-$k-$hra+$sf;
         if ($bip==0) {$babip=0;}
          else {$babip=($ha-$hra)/$bip;}
      
	 if ($ab==0) {$oavg=0;}
          else {$oavg=$ha/$ab;}
         $oavg=sprintf("%.3f",$oavg);
         if ($oavg<1) {$oavg=strstr($oavg,".");}
		 
	 $era=sprintf("%.2f",$era);
         $whip=sprintf("%.2f",$whip);
	 $babip=sprintf("%.3f",$babip);
	 if ($whip<1) {$whip=strstr($whip,".");}
	 if ($babip<1) {$babip=strstr($babip,".");}
	 $ip=sprintf("%.1f",$ip);

	 $cls='s'.($cnt%2+1);
	 $text.="    <tr class='$cls'><td class='".$cls."_l'><a href='./team_summary.php?team_id=$tid&year=$yr'>$yr</a></td>";
	 $text.="<td>$rpg</td>";
	 $text.="<td>$r</td>";
	 $text.="<td>$g</td>";
	 $text.="<td>$cg</td>";
	 $text.="<td>$sho</td>";
	 $text.="<td>$sv</td>";
	 $text.="<td>$era</td>";
	 $text.="<td>$ip</td>";
	 $text.="<td>$ha</td>";
	 $text.="<td>$hra</td>";
	 $text.="<td>$bb</td>";
	 $text.="<td>$k</td>";
	 $text.="<td>$whip</td>";
	 $text.="<td>$oavg</td>";
	 $text.="<td>$babip</td>";
	 $text.="</tr>\n";

	 $cnt++;
       }

      ## Show Team Totals
      if ($Tg==0) {$rpg=0;}
       else {$rpg=$Tr/$Tg;}
      $rpg=sprintf("%.1f",$rpg);

      if ($Tip==0) {$era=0;$whip=0;}
       else
       {
         $era=9*$Ter/$Tip;
         $whip=($Tha+$Tbb)/$Tip;
       }
      $bip=$Tab-$Tk-$Thra+$Tsf;
      if ($bip==0) {$babip=0;}
       else {$babip=($Tha-$Thra)/$bip;}
      
      if ($Tab==0) {$oavg=0;}
       else {$oavg=$Tha/$Tab;}
      $oavg=sprintf("%.3f",$oavg);
      if ($oavg<1) {$oavg=strstr($oavg,".");}

      $era=sprintf("%.2f",$era);
      $whip=sprintf("%.2f",$whip);
      $babip=sprintf("%.3f",$babip);
      if ($whip<1) {$whip=strstr($whip,".");}
      if ($babip<1) {$babip=strstr($babip,".");}
      $Tip=sprintf("%.1f",$Tip);

      $text.="    <tfoot>\n";
      $text.="     <tr class='headline'>";
      if ($Tyr>0) {$text.="<td class='hsc2_l'>Total over $Tyr years</td>";}
       else {$text.="<td class='hsc2_l'>Total over $Tyr year</td>";}
      $text.="<td class='hsc2'>$rpg</td>";
      $text.="<td class='hsc2'>$Tr</td>";
      $text.="<td class='hsc2'>$Tg</td>";
      $text.="<td class='hsc2'>$Tcg</td>";
      $text.="<td class='hsc2'>$Tsho</td>";
      $text.="<td class='hsc2'>$Tsv</td>";
      $text.="<td class='hsc2'>$era</td>";
      $text.="<td class='hsc2'>$Tip</td>";
      $text.="<td class='hsc2'>$Tha</td>";
      $text.="<td class='hsc2'>$Thra</td>";
      $text.="<td class='hsc2'>$Tbb</td>";
      $text.="<td class='hsc2'>$Tk</td>";
      $text.="<td class='hsc2'>$whip</td>";
      $text.="<td class='hsc2'>$oavg</td>";
      $text.="<td class='hsc2'>$babip</td>";
      $text.="</tr>\n";
      $text.="     <tr class='headline'>";
      $text.="<td class='hsc2_l'>Per season average</td>";
      $text.="<td class='hsc2'>&nbsp;</td>";
      $text.="<td class='hsc2'>".round($Tr/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tg/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tcg/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tsho/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tsv/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>&nbsp;</td>";
      $text.="<td class='hsc2'>".round($Tip/$Tyr,1)."</td>";
      $text.="<td class='hsc2'>".round($Tha/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Thra/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tbb/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tk/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>&nbsp;</td>";
      $text.="<td class='hsc2'>&nbsp;</td>";
      $text.="<td class='hsc2'>&nbsp;</td>";
      $text.="</tr>\n";
      $text.="    </tfoot>\n";
      $text.="   </table>\n";
      $text.="  </td></tr>\n";
      $text.=" </table>\n";
      $text.="</div>   <!-- END of Team Totals -->\n";
    }

   ##### Get Pitcher Register #####
   $query="SELECT p.player_id,p.first_name,p.last_name,throws,COUNT( year ) AS yrs,MIN(year) as strt,MAX(year) as end,SUM(w) as w,SUM(l) as l,SUM(er) as er,(SUM(ip)*3+SUM(ipf))/3 as ip,SUM(g) as g,SUM(gs) as gs,SUM(cg) as cg,SUM(sho) as sho,SUM(s) as s,SUM(ha) as ha,SUM(hra) as hra,SUM(bb) as bb,SUM(k) as k,SUM(sf) as sf,SUM(hld) as hld,SUM(ab) as ab,SUM(war) as war
  FROM players_career_pitching_stats as pcp,players as p WHERE pcp.player_id=p.player_id AND pcp.team_id=$tid AND pcp.split_id=1 GROUP BY player_id ORDER BY last_name,first_name;";
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result)>0)
    {
      $text.="<div class='textbox'>\n";
      $text.=" <table cellpadding=0 cellspacing=0 border=0 width='930px'>\n";
      $text.="  <tr class='title'><td style='padding:2px;'>Team Pitching Register (".mysqli_num_rows($result)." players)</td></tr>\n";
      $text.="  <tr><td>\n";
      $text.="   <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='100%'>\n";
      $text.="    <thead><tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2' title='Throws'>T</td><td class='hsc2'>Years</td><td class='hsc2'>From</td><td class='hsc2'>To</td><td class='hsc2'>W</td><td class='hsc2'>L</td><td class='hsc2'>WPct</td><td class='hsc2'>SV</td><td class='hsc2'>ERA</td><td class='hsc2'>G</td><td class='hsc2'>GS</td><td class='hsc2'>CG</td><td class='hsc2'>SHO</td><td class='hsc2'>IP</td><td class='hsc2'>H</td><td class='hsc2'>HR</td><td class='hsc2'>BB</td><td class='hsc2'>K</td><td class='hsc2'>HLD</td><td class='hsc2'>WHIP</td><td class='hsc2'>OAVG</td><td class='hsc2'>BABIP</td><td class='hsc2'>WAR</td></tr></thead>\n";
      $cnt=0;
      while ($row=mysqli_fetch_array($result))
       {
         $pid=$row['player_id'];
         $from=$row['strt'];
	 $to=$row['end'];
	 $yrs=$row['yrs'];
	 $hand=get_hand($row['throws']);
	 $w=$row['w'];
	 $l=$row['l'];
	 $sv=$row['s'];
	 $er=$row['er'];
	 $ip=$row['ip'];
	 $g=$row['g'];
	 $gs=$row['gs'];
	 $cg=$row['cg'];
	 $sho=$row['sho'];
	 $ha=$row['ha'];
	 $hra=$row['hra'];
	 $bb=$row['bb'];
	 $k=$row['k'];
	 $sf=$row['sf'];
	 $hld=$row['hld'];
	 $ab=$row['ab'];
	 $war=sprintf("%.1f",$row['war']);

	 if (($ip==0) && ($w==0) && ($l==0) && ($sv==0)) {continue;}
	
	 if (($w+$l)==0) {$wpct=0;}
          else {$wpct=$w/($w+$l);}
         $wpct=sprintf("%.3f",$wpct);
         if ($wpct<1) {$wpct=strstr($wpct,".");}

	 if ($ip==0) {$era=0;$whip=0;}
          else
          {
            $era=9*$er/$ip;
            $whip=($ha+$bb)/$ip;
          }
         $bip=$ab-$k-$hra+$sf;
         if ($bip==0) {$babip=0;}
          else {$babip=($ha-$hra)/$bip;}
      
         if ($ab==0) {$oavg=0;}
          else {$oavg=$ha/$ab;}
         $oavg=sprintf("%.3f",$oavg);
         if ($oavg<1) {$oavg=strstr($oavg,".");}

         $era=sprintf("%.2f",$era);
         $whip=sprintf("%.2f",$whip);
         $babip=sprintf("%.3f",$babip);
         if ($whip<1) {$whip=strstr($whip,".");}
         if ($babip<1) {$babip=strstr($babip,".");}
         $ip=sprintf("%.1f",$ip);

	 $cls='s'.($cnt%2+1);
	 $text.="    <tr class='$cls'><td class='".$cls."_l' sorttable_customkey=\"".$row['last_name'].", ".$row['first_name']."\"><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";
	 $text.="<td>$hand</td>";
	 $text.="<td>$yrs</td>";
	 $text.="<td>$from</td>";
	 $text.="<td>$to</td>";
	 $text.="<td>$w</td>";
	 $text.="<td>$l</td>";
	 $text.="<td>$wpct</td>";
	 $text.="<td>$sv</td>";
	 $text.="<td>$era</td>";
	 $text.="<td>$g</td>";
	 $text.="<td>$gs</td>";
	 $text.="<td>$cg</td>";
	 $text.="<td>$sho</td>";
	 $text.="<td>$ip</td>";
	 $text.="<td>$ha</td>";
	 $text.="<td>$hra</td>";
	 $text.="<td>$bb</td>";
	 $text.="<td>$k</td>";
	 $text.="<td>$hld</td>";
	 $text.="<td>$whip</td>";
	 $text.="<td>$oavg</td>";
	 $text.="<td>$babip</td>";
	 $text.="<td>$war</td>";
	 $text.="</tr>\n";

	 $cnt++;
       }
      $text.="    <tfoot><tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2' title='Throws'>T</td><td class='hsc2'>Years</td><td class='hsc2'>From</td><td class='hsc2'>To</td><td class='hsc2'>W</td><td class='hsc2'>L</td><td class='hsc2'>WPct</td><td class='hsc2'>SV</td><td class='hsc2'>ERA</td><td class='hsc2'>G</td><td class='hsc2'>GS</td><td class='hsc2'>CG</td><td class='hsc2'>SHO</td><td class='hsc2'>IP</td><td class='hsc2'>H</td><td class='hsc2'>HR</td><td class='hsc2'>BB</td><td class='hsc2'>K</td><td class='hsc2'>HLD</td><td class='hsc2'>WHIP</td><td class='hsc2'>OAVG</td><td class='hsc2'>BABIP</td><td class='hsc2'>WAR</td></tr></tfoot>\n";
      $text.="   </table>\n";
      $text.="  </td></tr>\n";
      $text.=" </table>\n";
      $text.="</div>   <!-- END of Batter Registry -->\n";
    }   
   
   mysqli_close($db);

   return $text;
 }

?>
