<?php
  include("html_functions.php");

  ################## PAGE INITIALIZATION #########################
  $lgid=$_SESSION['lgid'];
  $lgpath=$_SESSION['lgpath'];
  $date=new Date($_SESSION['lgdate']);
  $lgyear=$_SESSION['lgyear'];

  if (($_SESSION['user_team_id']>0)&&(!isset($_GET['team_id'])))
  {
	  if ($_SESSION['user_league_id']==$lgid) {$team_id=$_SESSION['user_team_id'];}
	  else
	  {
		  include($_SESSION['adminpath']."/dbopen.php");
		  $query="SELECT team_id FROM teams WHERE parent_team_id=".$_SESSION['user_team_id']." AND league_id=$lgid";
		  $result=mysqli_query($db,$query);
		  if (mysqli_num_rows($result))
		  {
			  $row=mysqli_fetch_array($result);
			  $team_id=$row['team_id'];
		  }
		  mysqli_close($db);
	  }
  }
  elseif (isset($_GET['team_id'])) {$team_id=$_GET['team_id'];}
  if ($team_id=="") {$team_id=-1;}
  $tyear=$_GET['year'];
	  
  ##### Get Team Names #####
  include($_SESSION['adminpath']."/dbopen.php");
  $query="SELECT team_id,name,nickname FROM teams WHERE league_id=$lgid";
  if ($team_id>0) {$query.=" AND team_id=$team_id";}
  $query.=" AND allstar_team=0 ORDER BY name,nickname LIMIT 1;";
  $result=mysqli_query($db,$query);
  while ($row=mysqli_fetch_array($result))
  {
	  $team_id=$row['team_id'];
	  $tname=$row['name']." ".$row['nickname'];
  }
  mysqli_close($db);
  
  ##### Get Title #####
  $title=$tname." History - Pitching Leaders";
  page_head($title,$_SESSION['lgpath'],"","","./jquery/excanvas.js|./jquery/jquery.min.js|./jquery/jquery.jqplot.min.js|./jquery/plugins/jqplot.categoryAxisRenderer.min.js|./jquery/plugins/jqplot.pointLabels.min.js|./jquery/plugins/jqplot.barRenderer.min.js|./jquery/plugins/jqplot.highlighter.min.js|./jquery/plugins/jqplot.cursor.min.js");
  echo " <div id='topbar'>\n";
  main_titlebar($lgid,$_SESSION['lgpath'],$title,$team_id);
  nav_toolbar("history","History");
  nav_toolbar("teams","Teams","","",$team_id,$tyear);

  ##### Show Page Content #####
  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";

  ##### Check for file #####
  echo gen_batlead($team_id,'pitching');

  ################## END OF PAGE #########################
  echo " </div>   <!-- END contentpane DIV -->\n";
  page_foot($_SESSION['lgpath']);

  exit;

##############################################################################################
# gen_batlead - Batting Leaders
##############################################################################################
function gen_batlead($tid="",$who='batting')
 {
   ##### Exit if no team_id #####
   if ($tid=="") {exit;}
   include($_SESSION['adminpath']."/dbopen.php");

   $limit=10;

   ##### Check for tables #####
   $query="SHOW TABLES LIKE 'team_history%';";
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result)<5) {return "Please load the team_history SQL tables first";}

   ##### Get basic parameters #####
   $date=new Date($_SESSION['lgdate']);
   $thisYear=$_SESSION['lgyear'];
   $lgpath=$_SESSION['lgpath'];
   $lgid=$_GET['lgid'];
   if ($lgid=="") {$lgid=$_SESSION['lgid'];}
   if ($lgid=="") {$lgid=100;}
   $text="";

   ##### Initialization #####
   if ($who=='batting')
    {
      $category=Array('avg'=>'Batting Average','obp'=>'On Base Percentage','slg'=>'Slugging Percentage','ops'=>'OPS','g'=>'Games','ab'=>'At Bats','pa'=>'Plate Appearances','r'=>'Runs','h'=>'Hits','d'=>'Doubles','t'=>'Triples','hr'=>'Home Runs','rbi'=>'Runs Batted In','bb'=>'Walks','k'=>'Strikeouts','sb'=>'Stolen Bases','cs'=>'Caught Stealing','sf'=>'Sacrifice Flies','sh'=>'Sacrifice Hits','ibb'=>'Intentional Walks','hp'=>'Hit By Pitch','gdp'=>'Ground Into Double Play','ebh'=>'Extra Base Hits','tb'=>'Total Bases','tob'=>'Times On Base','war'=>'WAR');

      $ptStat='SUM(pa)';
      #Get min PA
      $query="SELECT COUNT(year) as cnt,SUM(g) as g FROM team_history_record WHERE league_id=$lgid AND team_id=$tid GROUP BY team_id;";
      if ($_GET['showq']==1) {$text.=$query."<br/>\n";}
      $result=mysqli_query($db,$query);
      $row=mysqli_fetch_array($result);
      $tmYears=$row['cnt'];
      $tmGms=$row['g'];
      $tmPA=3.1*($tmGms/$tmYears)*min($tmYears,4.5);   ## 3.1 PA * TmG/Yr * 4.5 seasons (or total seasons played)
      $tmPA=100*floor($tmPA/100);
      $tmPA=min($tmPA,1500);

      $text.="<div class='textbox' style='border:0px;'>\n";
      $text.=" <p>NOTE: Seasonal rate stats for the current season are excluded.  3.1 PA/TmG required for inclusion in seasonal rate leaders, $tmPA PA required for inclusion in career rate leaders.<br/>+ indicates Hall of Famer</p>\n";
      $text.="</div>\n";
    }
    else
    {
      $category=Array('era'=>'Earned Run Average','w'=>'Wins','l'=>'Losses','s'=>'Saves','ip'=>'Innings Pitched','g'=>'Games','gs'=>'Games Started','gf'=>'Games Finished','cg'=>'Complete Games','sho'=>'Shutouts','qs'=>'Quality Starts','k'=>'Strikeouts','ha'=>'Hits Allowed','bb'=>'Walks Allowed','hra'=>'Home Runs Allowed','r'=>'Runs Allowed','er'=>'Earned Runs Allowed','bf'=>'Batters Faced','hld'=>'Holds','svo'=>'Save Opportunities','bs'=>'Blown Saves','bk'=>'Balks','wp'=>'Wild Pitches','rapp'=>'Relief Appearances','whip'=>'WHIP','kper9'=>'Strikeouts Per 9 IP','bbper9'=>'Walks Per 9 IP','hper9'=>'Hits Per 9 IP','rper9'=>'Runs Per 9 IP','hrper9'=>'Home Runs Per 9 IP','kperbb'=>'Strikeout to Walk Ratio','wpct'=>'Win Percentage','gmovr500'=>'Games Over .500','war'=>'WAR');

      $ptStat='SUM(ip)+SUM(ipf)/3';
      #Get min PA
      $query="SELECT COUNT(year) as cnt,SUM(g) as g FROM team_history_record WHERE league_id=$lgid AND team_id=$tid GROUP BY team_id;";
      if ($_GET['showq']==1) {$text.=$query."<br/>\n";}
      $result=mysqli_query($db,$query);
      $row=mysqli_fetch_array($result);
      $tmYears=$row['cnt'];
      $tmGms=$row['g'];
      $tmPA=1.0*($tmGms/$tmYears)*min($tmYears,6.5);   ## 1.0 IP * TmG/Yr * 6.5 seasons (or total seasons played)
      $tmPA=50*floor($tmPA/50);
      $tmPA=min($tmPA,500);

      $text.="<div class='textbox' style='border:0px;'>\n";
      $text.=" <p>NOTE: Seasonal rate stats for the current season are excluded.  1.0 IP/TmG required for inclusion in seasonal rate leaders, $tmPA IP required for inclusion in career rate leaders.<br/>+ indicates Hall of Famer</p>\n";
      $text.="</div>\n";
    }

   ##### Batting Leaders #####
   $text.="<div class='textbox'>\n";
   $text.=" <table cellpadding=0 cellspacing=0 border=0 width='935px'>\n";
   $text.="  <tr class='title'><td colspan=2 style='padding:2px;'>".ucwords($who)." Leaders</td></tr>\n";
   $text.="  <tr><td valign=top>\n";
   ##Seasonal Leaders
   foreach ($category as $cat => $title)
    {
      $title=$category[$cat];
      $text.="   <div class='tablebox'>\n";
      $text.="    <table cellpadding=0 cellspacing=0 border=0 width='445px'>\n";
      $text.="     <tr class='title'><td style='padding:2px;'>Seasonal $title</td><tr>\n";
      $text.="     <tr><td>\n";
      $text.="      <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='100%'>\n";
      $text.="       <thead><tr class='headline'><td class='hsc2_l'>Rnk</td><td class='hsc2_l'>Player</td><td class='hsc2'>Year</td>";
 	  if (($cat!='pa')&&($cat!='ip'))
 	   {
 	     $text.="<td class='hsc2'>";
 	     if ($who=='batting') {$text.='PA';} else {$text.='IP';}
 	     $text.="</td>";
 	   }
      switch ($cat)
      {
        case 'd': $text.="<td class='hsc2'>2B</td></tr></thead>\n"; break;
        case 't': $text.="<td class='hsc2'>3B</td></tr></thead>\n"; break;
        case 's': $text.="<td class='hsc2'>SV</td></tr></thead>\n"; break;
        case 'kper9': $text.="<td class='hsc2'>K/9</td></tr></thead>\n"; break;
        case 'bbper9': $text.="<td class='hsc2'>BB/9</td></tr></thead>\n"; break;
        case 'hper9': $text.="<td class='hsc2'>H/9</td></tr></thead>\n"; break;
        case 'rper9': $text.="<td class='hsc2'>R/9</td></tr></thead>\n"; break;
        case 'hrper9': $text.="<td class='hsc2'>HR/9</td></tr></thead>\n"; break;
        case 'kperbb': $text.="<td class='hsc2'>K/BB</td></tr></thead>\n"; break;
        case 'wpct': $text.="<td class='hsc2'>Win%</td></tr></thead>\n"; break;
        case 'gmovr500': $text.="<td class='hsc2'>Gm>.500</td></tr></thead>\n"; break;
        default : $text.="<td class='hsc2'>".strtoupper($cat)."</td></tr></thead>\n"; break;
      }
      switch ($cat)
       {
         case 'avg':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,SUM(pa) as pa,SUM(h)/SUM(ab) as stat FROM players_career_batting_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year HAVING (SUM(pa)/g)>=3.1 ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
	 case 'obp':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,SUM(pa) as pa,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf)) as stat FROM players_career_batting_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year HAVING (SUM(pa)/g)>=3.1 ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'slg':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,SUM(pa) as pa,(SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab) as stat FROM players_career_batting_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year HAVING (SUM(pa)/g)>=3.1 ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'ops':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,SUM(pa) as pa,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))+(SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab) as stat FROM players_career_batting_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year HAVING (SUM(pa)/g)>=3.1 ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'ebh':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,year,$ptStat as pa,SUM(d)+SUM(t)+SUM(hr) as stat FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id=$tid GROUP BY player_id,team_id,year ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'tb':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,year,$ptStat as pa,SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr) as stat FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id=$tid GROUP BY player_id,team_id,year ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'tob':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,year,$ptStat as pa,SUM(h)+SUM(bb)+SUM(hp) as stat FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id=$tid GROUP BY player_id,team_id,year ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'era':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,$ptStat as pa,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year HAVING ((SUM(ip)+SUM(ipf)/3)/g)>=1.0 ORDER BY stat,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'whip':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,$ptStat as pa,(SUM(ha)+SUM(bb))/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year HAVING ((SUM(ip)+SUM(ipf)/3)/g)>=1.0 ORDER BY stat,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'ip':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,$ptStat as pa,SUM(ip)+SUM(ipf)/3 as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'rapp':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,$ptStat as pa,SUM(pcb.g)-SUM(gs) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'kper9':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,$ptStat as pa,9*SUM(k)/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year HAVING ((SUM(ip)+SUM(ipf)/3)/g)>=1.0 ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'bbper9':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,$ptStat as pa,9*SUM(bb)/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year HAVING ((SUM(ip)+SUM(ipf)/3)/g)>=1.0 ORDER BY stat,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'hper9':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,$ptStat as pa,9*SUM(ha)/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year HAVING ((SUM(ip)+SUM(ipf)/3)/g)>=1.0 ORDER BY stat,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'rper9':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,$ptStat as pa,9*SUM(r)/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year HAVING ((SUM(ip)+SUM(ipf)/3)/g)>=1.0 ORDER BY stat,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'hrper9':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,$ptStat as pa,9*SUM(hra)/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year HAVING ((SUM(ip)+SUM(ipf)/3)/g)>=1.0 ORDER BY stat,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'kperbb':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,$ptStat as pa,SUM(k)/SUM(bb) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year HAVING ((SUM(ip)+SUM(ipf)/3)/g)>=1.0 ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'wpct':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,$ptStat as pa,SUM(pcb.w)/(SUM(pcb.w)+SUM(pcb.l)) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year HAVING ((SUM(ip)+SUM(ipf)/3)/g)>=1.0 ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'gmovr500':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,pcb.year,thr.g,$ptStat as pa,SUM(pcb.w)-SUM(pcb.l) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id,pcb.year ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
	 default   :
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,year,$ptStat as pa,SUM($cat) as stat FROM players_career_".$who."_stats WHERE league_id=$lgid AND split_id=1 AND team_id=$tid GROUP BY player_id,team_id,year ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
       }
      $query.=" ORDER BY stat ".stat_sort($cat).",pa,year";
      if ($_GET['showq']==1) {$text.=$query."<br/>\n";}
      $result=mysqli_query($db,$query);
      $cnt=0;
      while ($row=mysqli_fetch_array($result))
       {
         $cls='s'.($cnt%2+1);
         $pid=$row['player_id'];
	 $name=$row['first_name']." ".$row['last_name'];
	 $sortname=$row['last_name'].", ".$row['first_name'];
	 $text.="       <tr class='$cls'>";
	 $text.="<td class='".$cls."_l'>".($cnt+1).".</td>";
	 $text.="<td class='".$cls."_l' sorttable_customkey=\"$sortname\"><a href='./player.php?player_id=$pid'>$name</a>";
	 if ($row['hall_of_fame']==1) {$text.="+";}
	 $text.="</td>";
	 $yr=$row['year'];
	 $text.="<td><a href='./team_summary.php?team_id=$tid&year=$yr'>$yr</a></td>";
	 if (($cat!='pa')&&($cat!='ip'))
	  {
	    if ($who=='batting') {$text.="<td>".$row['pa']."</td>";}
	     else {$text.="<td>".sprintf('%.1f',$row['pa'])."</td>";}
	  }
	 $val=$row['stat'];
	 switch ($cat)
	  {
            case 'avg':
	    case 'obp':
	    case 'slg':
	    case 'ops':
              $val=sprintf("%.3f",$val);
	      if ($val<1) {$val=strstr($val,".");}
 	      break;
	    case 'war':
	    case 'ip':
              $val=sprintf("%.1f",$val);
 	      break;
	    case 'era':
	    case 'whip':
	    case 'kper9':
	    case 'bbper9':
	    case 'hper9':
	    case 'rper9':
	    case 'hrper9':
	    case 'kperbb':
              $val=sprintf("%.2f",$val);
 	      break;
	    case 'wpct':
              $val=sprintf("%.1f",100*$val);
 	      break;
	    default:
	      break;
	  }
	 $text.="<td>".$val."</td>";
	 $text.="</tr>\n";
	 $cnt++;
     }
      $text.="       <tfoot>";
      if ($cnt<10)
       {
       for($i=$cnt;$i<10;$i++)
        {
          $text.="        <tr><td colspan=5>&nbsp;</td></tr>\n";
        }  
       }
      $text.="        <tr class='headline'><td colspan=5 align='right'><a href='./leaderboards.php?view=players&scope=season&sub_league_id=ALL&listing=top100&team_id=$tid&split=regular&stat=$cat&who=ALL&pos=ALL&from=&to=&ageFrom=&ageTo=&draftFrom=&draftTo=&draft_team_id=ALL&minStat2Lbl=&minStat2dir=&minStat2=&minStat=&ovrMinPT=$tmPA'>Expanded Leaderboard</a></td></tr>\n";
      $text.="       </tfoot>\n";
      $text.="      </table>\n";
      $text.="     </td></tr>\n";
      $text.="    </table>\n";
      $text.="   </div>\n";
    }

   $text.="  </td><td valign=top>\n";
   
   ##Career Leaders
   foreach ($category as $cat => $title)
    {
      $title=$category[$cat];
      $text.="   <div class='tablebox'>\n";
      $text.="    <table cellpadding=0 cellspacing=0 border=0 width='445px'>\n";
      $text.="     <tr class='title'><td style='padding:2px;'>Career $title</td><tr>\n";
      $text.="     <tr><td>\n";
      $text.="      <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='100%'>\n";
      $text.="       <thead><tr class='headline'><td class='hsc2_l'>Rnk</td><td class='hsc2_l'>Player</td><td class='hsc2'>Years</td>";
 	  if (($cat!='pa')&&($cat!='ip'))
 	   {
 	     $text.="<td class='hsc2'>";
 	     if ($who=='batting') {$text.='PA';} else {$text.='IP';}
 	     $text.="</td>";
 	   }
      switch ($cat)
      {
        case 'd': $text.="<td class='hsc2'>2B</td></tr></thead>\n"; break;
        case 't': $text.="<td class='hsc2'>3B</td></tr></thead>\n"; break;
        case 's': $text.="<td class='hsc2'>SV</td></tr></thead>\n"; break;
        case 'kper9': $text.="<td class='hsc2'>K/9</td></tr></thead>\n"; break;
        case 'bbper9': $text.="<td class='hsc2'>BB/9</td></tr></thead>\n"; break;
        case 'hper9': $text.="<td class='hsc2'>H/9</td></tr></thead>\n"; break;
        case 'rper9': $text.="<td class='hsc2'>R/9</td></tr></thead>\n"; break;
        case 'hrper9': $text.="<td class='hsc2'>HR/9</td></tr></thead>\n"; break;
        case 'kperbb': $text.="<td class='hsc2'>K/BB</td></tr></thead>\n"; break;
        case 'wpct': $text.="<td class='hsc2'>Win%</td></tr></thead>\n"; break;
        case 'gmovr500': $text.="<td class='hsc2'>Gm>.500</td></tr></thead>\n"; break;
        default : $text.="<td class='hsc2'>".strtoupper($cat)."</td></tr></thead>\n"; break;
      }
      switch ($cat)
       {
         case 'avg':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,SUM(pa) as pa,SUM(h)/SUM(ab) as stat FROM players_career_batting_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id HAVING SUM(pa)>=$tmPA ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
	 case 'obp':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,SUM(pa) as pa,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf)) as stat FROM players_career_batting_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id HAVING SUM(pa)>=$tmPA ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'slg':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,SUM(pa) as pa,(SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab) as stat FROM players_career_batting_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id HAVING SUM(pa)>=$tmPA ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'ops':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,SUM(pa) as pa,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))+(SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab) as stat FROM players_career_batting_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id HAVING SUM(pa)>=$tmPA ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'ebh':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(year),'-',MAX(year)) as year,$ptStat as pa,SUM(d)+SUM(t)+SUM(hr) as stat FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id=$tid GROUP BY player_id,team_id ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'tb':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(year),'-',MAX(year)) as year,$ptStat as pa,SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr) as stat FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id=$tid GROUP BY player_id,team_id ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'tob':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(year),'-',MAX(year)) as year,$ptStat as pa,SUM(h)+SUM(bb)+SUM(hp) as stat FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id=$tid GROUP BY player_id,team_id ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'era':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,$ptStat as pa,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id HAVING (SUM(ip)+SUM(ipf)/3)>=$tmPA ORDER BY stat,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'ip':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,$ptStat as pa,SUM(ip)+SUM(ipf)/3 as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'rapp':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,$ptStat as pa,SUM(pcb.g)-SUM(gs) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'kper9':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,$ptStat as pa,9*SUM(k)/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id HAVING (SUM(ip)+SUM(ipf)/3)>=$tmPA ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'bbper9':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,$ptStat as pa,9*SUM(bb)/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id HAVING (SUM(ip)+SUM(ipf)/3)>=$tmPA ORDER BY stat,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'hper9':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,$ptStat as pa,9*SUM(ha)/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id HAVING (SUM(ip)+SUM(ipf)/3)>=$tmPA ORDER BY stat,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'rper9':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,$ptStat as pa,9*SUM(r)/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id HAVING (SUM(ip)+SUM(ipf)/3)>=$tmPA ORDER BY stat,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'hrper9':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,$ptStat as pa,9*SUM(hra)/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id HAVING (SUM(ip)+SUM(ipf)/3)>=$tmPA ORDER BY stat,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'kperbb':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,$ptStat as pa,SUM(k)/SUM(bb) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id HAVING (SUM(ip)+SUM(ipf)/3)>=$tmPA ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'whip':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,$ptStat as pa,(SUM(ha)+SUM(bb))/(SUM(ip)+SUM(ipf)/3) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id HAVING (SUM(ip)+SUM(ipf)/3)>=$tmPA ORDER BY stat,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
         case 'wpct':
	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(pcb.year),'-',MAX(pcb.year)) as year,thr.g,$ptStat as pa,SUM(pcb.w)/(SUM(pcb.w)+SUM(pcb.l)) as stat FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.team_id=thr.team_id AND pcb.year=thr.year AND pcb.league_id=$lgid AND split_id=1 AND pcb.team_id=$tid GROUP BY player_id,pcb.team_id HAVING (SUM(ip)+SUM(ipf)/3)>=$tmPA ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
	     case 'gmovr500':
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(year),'-',MAX(year)) as year,$ptStat as pa,SUM(w)-SUM(l) as stat FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND team_id=$tid GROUP BY player_id,team_id ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
	 default   :
  	   $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pa,stat FROM players as p,(SELECT player_id,CONCAT(MIN(year),'-',MAX(year)) as year,$ptStat as pa,SUM($cat) as stat FROM players_career_".$who."_stats WHERE league_id=$lgid AND split_id=1 AND team_id=$tid GROUP BY player_id,team_id ORDER BY stat DESC,pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
	   break;
       }
      $query.=" ORDER BY stat ".stat_sort($cat).",pa,year";
      if ($_GET['showq']==1) {$text.=$query."<br/>\n";}
      $result=mysqli_query($db,$query);
      $cnt=0;
      while ($row=mysqli_fetch_array($result))
       {
         $cls='s'.($cnt%2+1);
         $pid=$row['player_id'];
	 $name=$row['first_name']." ".$row['last_name'];
	 $sortname=$row['last_name'].", ".$row['first_name'];
	 $text.="       <tr class='$cls'>";
	 $text.="<td class='".$cls."_l'>".($cnt+1).".</td>";
	 $text.="<td class='".$cls."_l' sorttable_customkey=\"$sortname\"><a href='./player.php?player_id=$pid'>$name</a>";
	 if ($row['hall_of_fame']==1) {$text.="+";}
	 $text.="</td>";
	 $yr=$row['year'];
	 $text.="<td>$yr</td>";
	 if (($cat!='pa')&&($cat!='ip'))
	  {
	    if ($who=='batting') {$text.="<td>".$row['pa']."</td>";}
	     else {$text.="<td>".sprintf('%.1f',$row['pa'])."</td>";}
	  }
	 $val=$row['stat'];
	 switch ($cat)
	  {
            case 'avg':
	    case 'obp':
	    case 'slg':
	    case 'ops':
              $val=sprintf("%.3f",$val);
	      if ($val<1) {$val=strstr($val,".");}
 	      break;
	    case 'war':
	    case 'ip':
              $val=sprintf("%.1f",$val);
 	      break;
	    case 'era':
	    case 'whip':
	    case 'kper9':
	    case 'bbper9':
	    case 'hper9':
	    case 'rper9':
	    case 'hrper9':
	    case 'kperbb':
              $val=sprintf("%.2f",$val);
 	      break;
	    case 'wpct':
              $val=sprintf("%.1f",100*$val);
 	      break;
	    default:
	      break;
	  }
	 $text.="<td>".$val."</td>";
	 $text.="</tr>\n";
	 $cnt++;
       }
      $text.="       <tfoot>";
      if ($cnt<10)
       {
       for($i=$cnt;$i<10;$i++)
        {
          $text.="        <tr><td colspan=5>&nbsp;</td></tr>\n";
        }  
       }
      $text.="        <tr class='headline'><td colspan=5 align='right'><a href='./leaderboards.php?view=players&scope=career&sub_league_id=ALL&listing=top100&team_id=$tid&split=regular&stat=$cat&who=ALL&pos=ALL&from=&to=&ageFrom=&ageTo=&draftFrom=&draftTo=&draft_team_id=ALL&minStat2Lbl=&minStat2dir=&minStat2=&minStat=&ovrMinPT=";
      switch ($cat)
      {
      case 'avg':
      case 'obp':
      case 'slg':
      case 'ops':
      case 'era':
      case 'whip':
      case 'kper9':
      case 'bbper9':
      case 'hper9':
      case 'rper9':
      case 'hrper9':
      case 'kperbb':
      case 'wpct':
	      $text.=$tmPA;
	      break;
      }
      $text.="'>Expanded Leaderboard</a></td></tr>\n";
      $text.="       </tfoot>\n";
      $text.="      </table>\n";
      $text.="     </td></tr>\n";
      $text.="    </table>\n";
      $text.="   </div>\n";
    }

   $text.="  </td></tr>\n";
   $text.=" </table>\n";
   $text.="</div>   <!-- END of Leader Stats -->\n";

   mysqli_close($db);

   return $text;
 }

?>
