<?php
  include("html_functions.php");

  ################## PAGE INITIALIZATION #########################
  $lgid=$_SESSION['lgid'];
  $lgpath=$_SESSION['lgpath'];
  $date=new Date($_SESSION['lgdate']);
  $lgyear=$_SESSION['lgyear'];

  if (($_SESSION['user_team_id']>0)&&(!isset($_GET['team_id'])))
  {
	  if ($_SESSION['user_league_id']==$lgid) {$team_id=$_SESSION['user_team_id'];}
	  else
	  {
		  include($_SESSION['adminpath']."/dbopen.php");
		  $query="SELECT team_id FROM teams WHERE parent_team_id=".$_SESSION['user_team_id']." AND league_id=$lgid";
		  $result=mysqli_query($db,$query);
		  if (mysqli_num_rows($result))
		  {
			  $row=mysqli_fetch_array($result);
			  $team_id=$row['team_id'];
		  }
		  mysqli_close($db);
	  }
  }
  elseif (isset($_GET['team_id'])) {$team_id=$_GET['team_id'];}
  if ($team_id=="") {$team_id=-1;}
  $tyear=$_GET['year'];
	  
  ##### Get Team Names #####
  include($_SESSION['adminpath']."/dbopen.php");
  $query="SELECT team_id,name,nickname FROM teams WHERE league_id=$lgid";
  if ($team_id>0) {$query.=" AND team_id=$team_id";}
  $query.=" AND allstar_team=0 ORDER BY name,nickname LIMIT 1;";
  $result=mysqli_query($db,$query);
  while ($row=mysqli_fetch_array($result))
  {
	  $team_id=$row['team_id'];
	  $tname=$row['name']." ".$row['nickname'];
  }
  mysqli_close($db);
  
  ##### Get Title #####
  $title=$tname." History - Park History";
  page_head($title,$_SESSION['lgpath'],"","","./jquery/excanvas.js|./jquery/jquery.min.js|./jquery/jquery.jqplot.min.js|./jquery/plugins/jqplot.categoryAxisRenderer.min.js|./jquery/plugins/jqplot.pointLabels.min.js|./jquery/plugins/jqplot.barRenderer.min.js|./jquery/plugins/jqplot.highlighter.min.js|./jquery/plugins/jqplot.cursor.min.js");
  echo " <div id='topbar'>\n";
  main_titlebar($lgid,$_SESSION['lgpath'],$title,$team_id);
  nav_toolbar("history","History");
  nav_toolbar("teams","Teams","","",$team_id,$tyear);

  ##### Show Page Content #####
  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";

  ##### Check for file #####
  echo gen_park($team_id);

  ################## END OF PAGE #########################
  echo " </div>   <!-- END contentpane DIV -->\n";
  page_foot($_SESSION['lgpath']);

  exit;

##############################################################################################
# gen_park - Ballpark History Page
##############################################################################################
function gen_park($tid="")
 {
   ##### Exit if no team_id #####
   if ($tid=="") {exit;}
   include($_SESSION['adminpath']."/dbopen.php");

   ##### Check for tables #####
   $query="SHOW TABLES LIKE 'parks';";
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result)<1) {return "Please load the parks SQL table first";}

   ##### Get basic parameters #####
   $date=new Date($_SESSION['lgdate']);
   $lgyear=$_SESSION['lgyear'];
   $lgpath=$_SESSION['lgpath'];
   $lgid=$_GET['lgid'];
   if ($lgid=="") {$lgid=$_SESSION['lgid'];}
   if ($lgid=="") {$lgid=100;}
   $text="";

   ##### Check if park_factors table exists #####
   $query="SHOW TABLES LIKE 'park_factors';";
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result))
    {
      ##Get Park Factors
      $query="SELECT pf.year,pf.park_id,capacity,p.name,rpf,hrpf FROM park_factors as pf,parks as p WHERE pf.park_id=p.park_id AND team_id=$tid;";
      $result=mysqli_query($db,$query);
      if (mysqli_num_rows($result)>0)
       {
         $pfFlag=1;
	 while ($row=mysqli_fetch_array($result))
	  {
            $yr=$row['year'];
  	    $parks[$yr]['name']=$row['name'];
	    $parks[$yr]['capacity']=$row['capacity'];
	    $parks[$yr]['pkid']=$row['park_id'];
	    $rpf=$row['rpf'];
	    $hrpf=$row['hrpf'];
	    $parks[$yr]['rpf']=sprintf("%.2f",$rpf);
	    $parks[$yr]['hrpf']=sprintf("%.2f",$hrpf);

	    $Trpf+=$rpf;
	    $Thrpf+=$hrpf;
	    $parkYrs+=1;
 	  }
       }

      ## Get Attendance
      $query="SELECT $lgyear as year,attendance FROM team_financials WHERE team_id=$tid UNION SELECT year,attendance FROM team_history_financials WHERE team_id=$tid";
      $result=mysqli_query($db,$query);
      if (mysqli_num_rows($result)>0)
       {
	 while ($row=mysqli_fetch_array($result))
	  {
		  $yr=$row['year'];
		  $att=$row['attendance'];
		  $parks[$yr]['att']=$att;
	  }
       }	 

      ##Display Results
      $text.="<div class='textbox'>\n";
      $text.=" <table cellpadding=0 cellspacing=0 border=0 width='935px'>\n";
      $text.="  <tr class='title'><td style='padding:2px;'>Team Results</td></tr>\n";
      $text.="  <tr><td>\n";
      $text.="   <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='100%'>\n";
      $text.="    <thead><tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2_l'>Ballpark</td><td class='hsc2'>Attendance</td><td class='hsc2'>PFr</td><td class='hsc2'>PFhr</td>";
      $text.="</tr></thead>\n";
      $cnt=0;
      ksort($parks);
      foreach ($parks as $year => $val)
       {
         $cls='s'.($cnt%2+1);
	 $text.="    <tr class='$cls'>";
	 $text.="<td class='".$cls."_l'><a href='./team_summary.php?team_id=$tid&year=$year'>$year</a></td>";
	 $text.="<td class='".$cls."_l'><a href='./parks.php?park=".$parks[$year]['pkid']."'>".$parks[$year]['name']."</a></td>";
	 $text.="<td>".stat_format('attendance',$parks[$year]['att'])."</td>";
	 $text.="<td>".$parks[$year]['rpf']."</td>";
	 $text.="<td>".$parks[$year]['hrpf']."</td>";
	 $text.="</tr>\n";
	 $cnt++;
       }
      $text.="    <tfoot><tr class='headline'><td class='hsc2' colspan=3>&nbsp;</td><td class='hsc2'>".sprintf("%.2f",$Trpf/$parkYrs)."</td><td class='hsc2'>".sprintf("%.2f",$Thrpf/$parkYrs)."</td></tr></tfoot>\n";
      $text.="   </table>\n";
      $text.="  </td></tr>\n";
      $text.=" </table>\n";
      $text.="</div>\n";

    }
   else {$text.="<p>No park history to display</p>\n";}

   mysqli_close($db);

   return $text;
 }

?>
