<?php
  include("html_functions.php");

  ################## PAGE INITIALIZATION #########################
  $lgid=$_SESSION['lgid'];
  $lgpath=$_SESSION['lgpath'];
  $date=new Date($_SESSION['lgdate']);
  $lgyear=$_SESSION['lgyear'];

  if (($_SESSION['user_team_id']>0)&&(!isset($_GET['team_id'])))
  {
	  if ($_SESSION['user_league_id']==$lgid) {$team_id=$_SESSION['user_team_id'];}
	  else
	  {
		  include($_SESSION['adminpath']."/dbopen.php");
		  $query="SELECT team_id FROM teams WHERE parent_team_id=".$_SESSION['user_team_id']." AND league_id=$lgid";
		  $result=mysqli_query($db,$query);
		  if (mysqli_num_rows($result))
		  {
			  $row=mysqli_fetch_array($result);
			  $team_id=$row['team_id'];
		  }
		  mysqli_close($db);
	  }
  }
  elseif (isset($_GET['team_id'])) {$team_id=$_GET['team_id'];}
  if ($team_id=="") {$team_id=-1;}
  $page=$_GET['page'];
  if ($page=="") {$page='index';}
  $tyear=$_GET['year'];
  $pos=$_GET['pos'];
  if ($pos=="") {$pos=0;}
	  
  ##### Get Team Names #####
  include($_SESSION['adminpath']."/dbopen.php");
  $query="SELECT team_id,name,nickname FROM teams WHERE league_id=$lgid";
  if ($team_id>0) {$query.=" AND team_id=$team_id";}
  $query.=" AND allstar_team=0 ORDER BY name,nickname LIMIT 1;";
  $result=mysqli_query($db,$query);
  while ($row=mysqli_fetch_array($result))
  {
	  $team_id=$row['team_id'];
	  $tname=$row['name']." ".$row['nickname'];
  }
  mysqli_close($db);
  
  ##### Get Title #####
  $title=$tname." History - Overview";
  page_head($title,$_SESSION['lgpath'],"","","./jquery/excanvas.js|./jquery/jquery.min.js|./jquery/jquery.jqplot.min.js|./jquery/plugins/jqplot.categoryAxisRenderer.min.js|./jquery/plugins/jqplot.pointLabels.min.js|./jquery/plugins/jqplot.barRenderer.min.js|./jquery/plugins/jqplot.highlighter.min.js|./jquery/plugins/jqplot.cursor.min.js");
  echo " <div id='topbar'>\n";
  main_titlebar($lgid,$_SESSION['lgpath'],$title,$team_id);
  nav_toolbar("history","History");
  nav_toolbar("teams","Teams","","",$team_id,$tyear);

  ##### Show Page Content #####
  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";

  ##### Check for file #####
  echo gen_overview($team_id);

  ################## END OF PAGE #########################
  echo " </div>   <!-- END contentpane DIV -->\n";
  page_foot($_SESSION['lgpath']);

  exit;


##############################################################################################
# gen_bat - Batter Registry
##############################################################################################
function gen_overview($tid="")
 {
   ##### Exit if no team_id #####
   if ($tid=="") {exit;}
   include($_SESSION['adminpath']."/dbopen.php");

   ##### Check for tables #####
   $query="SHOW TABLES LIKE 'team_history%';";
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result)<5) {return "Please load the team_history SQL tables first";}

   ##### Get basic parameters #####
   $lgdate=$_SESSION['lgdate'];
   $lgpath=$_SESSION['lgpath'];
   $lgid=$_GET['lgid'];
   if ($lgid=="") {$lgid=$_SESSION['lgid'];}
   if ($lgid=="") {$lgid=100;}
   $text="";

   ##### Get Sub League Abbreviation
   $query="SELECT year,t.league_id,t.sub_league_id,sl.name,sl.abbr FROM team_history as t,sub_leagues as sl WHERE t.league_id=sl.league_id AND t.sub_league_id=sl.sub_league_id AND t.team_id=$tid ORDER BY year";
   if ($_GET['showq']==1) {$text.="$query<br/>\n";}
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result))
   {
	   while ($row=mysqli_fetch_array($result))
	   {
		   $slid=$row['sub_league_id'];
		   $yr=$row['year'];
		   $subleagues[$slid][$yr]['name']=$row['name'];
		   $subleagues[$slid][$yr]['abbr']=$row['abbr'];
	   }
   }


   ##### Top Container Start
   $text.="<div class='textbox' style='border:0px;width:935px;margin-top:0px;padding:0px;'>\n";
   
   ##### Get Titles and Team Record #####
   $query="SELECT t.year,t.team_id,t.sub_league_id,name,nickname,w,l,w/(w+l) as pct,w-l as gmOvr500,pos,made_playoffs,won_playoffs FROM team_history as t,team_history_record as thr WHERE t.team_id=thr.team_id AND t.team_id=$tid AND t.year=thr.year ORDER BY year";
   if ($_GET['showq']==1) {$text.="$query<br/>\n";}
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result))
   {
	   $maxW=0;
	   $maxL=0;
	   $maxPos=0;
	   $strkID=0;
	   $strkType='';
	   while ($row=mysqli_fetch_array($result))
	   {
		   $yr=$row['year'];
		   $slid=$row['sub_league_id'];

		   $seasons['slid'][$yr]=$slid;

		   $gmOvr=$row['gmOvr500'];

		   $wTot=$wTot+$row['w'];
		   $lTot=$lTot+$row['l'];

		   # Max Wins and Losses
		   if ($row['w']>$maxW)
		   {
			   $maxW=$row['w'];
			   unset($seasons['win']['maxYr']);
			   $seasons['win']['maxYr'][$yr]=1;
		   }
		   if ($row['l']>$maxL)
		   {
			   $maxL=$row['l'];
			   unset($seasons['loss']['maxYr']);
			   $seasons['loss']['maxYr'][$yr]=1;
		   }

		   # Postseason
		   if ($row['made_playoffs']==1) {$seasons['playoffs'][$yr]=1;}
		   if ($row['won_playoffs']==1) {$seasons['champions'][$yr]=1;}

		   # Winning/Losing Seasons Streaks
		   if ($gmOvr>0)   //Winning Season
		   {
			   $seasons['win']['cnt']=$seasons['win']['cnt']+1;

			   if ($strkType!='w')
			   {
				   $strkID++;
				   $strkType='w';

				   $streaks[$strkType][$strkID]['start']=$yr;
				   $streaks[$strkType][$strkID]['end']=$yr;
				   $streaks[$strkType][$strkID]['len']=$yr-$streaks[$strkType][$strkID]['start']+1;
			   }
			   else
			   {
				   $streaks[$strkType][$strkID]['end']=$yr;
				   $streaks[$strkType][$strkID]['len']=$yr-$streaks[$strkType][$strkID]['start']+1;
			   }
		   }
		   elseif ($gmOvr<0)   //Losing Season
		   {
			   $seasons['loss']['cnt']=$seasons['loss']['cnt']+1;

			   if ($strkType!='l')
			   {
				   $strkID++;
				   $strkType='l';

				   $streaks[$strkType][$strkID]['start']=$yr;
				   $streaks[$strkType][$strkID]['end']=$yr;
				   $streaks[$strkType][$strkID]['len']=$yr-$streaks[$strkType][$strkID]['start']+1;
			   }
			   else
			   {
				   $streaks[$strkType][$strkID]['end']=$yr;
				   $streaks[$strkType][$strkID]['len']=$yr-$streaks[$strkType][$strkID]['start']+1;
			   }
		   }
		   else   //.500 Season
		   {
			   $seasons['even']['cnt']=$seasons['even']['cnt']+1;
			   if (($strkType=='w')||($strkType=='l')) {$strkType='';}
		   }

		   # Standings Finish
		   $pos=$row['pos'];
		   if ($pos>$maxPos) {$maxPos=$pos;}
		   $seasons['standings'][$pos]['cnt']=$seasons['standings'][$pos]['cnt']+1;
		   $seasons['standings'][$pos]['yrs'][$yr]=1;
		   $seasons['winpct'][$yr]=stat_format('winpct',$row['pct']);
	   }

	   $cnt=0;
	   $text.="<div class='textbox' style='float:right;'>\n";
	   $text.=" <table border=0 cellpadding=4 cellspacing=0 style='width:470px;'>\n";
	   $text.="  <tr class='title2'><td colspan=3>Team History</td></tr>\n";
	   # Champs
	   $cls='s'.($cnt%2+1);
	   $text.="  <tr class='$cls'>";
	   $text.="<td class='".$cls."_l'><b>Championships:</b></td>";
	   if (isset($seasons['champions']))
	   {
		   $text.="<td>".count($seasons['champions'])."</td>";
		   $i=0;
		   $text.="<td class='".$cls."_l'>";
		   foreach ($seasons['champions'] as $yr => $val)
		   {
			   if ($i>0) {$text.=", ";}
			   $text.="<a href='./team_summary.php?league_id=$lgid&team_id=$tid&year=$yr'>$yr</a>";
			   $i++;
		   }
		   $text.="</td>";
	   }
	   else {$text.="<td colspan=2 style='text-align:center;'>None</td>";}
	   $text.="</tr>\n";
	   $cnt++;
	   # Postseason
	   $cls='s'.($cnt%2+1);
	   $text.="  <tr class='$cls'>";
	   $text.="<td class='".$cls."_l' style='border-bottom:1px dotted #666666;'><b>Postseason Appearances:</b></td>";
	   if (isset($seasons['playoffs']))
	   {
		   $text.="<td style='border-bottom:1px dotted #666666;'>".count($seasons['playoffs'])."</td>";
		   $i=0;
		   $text.="<td class='".$cls."_l' style='border-bottom:1px dotted #666666;'>";
		   foreach ($seasons['playoffs'] as $yr => $val)
		   {
			   if ($i>0) {$text.=", ";}
			   $text.="<a href='./team_summary.php?league_id=$lgid&team_id=$tid&year=$yr'>$yr</a>";
			   $i++;
		   }
		   $text.="</td>";
	   }
	   else {$text.="<td colspan=2 style='text-align:center;border-bottom:1px dotted #666666;'>None</td>";}
	   $text.="</tr>\n";
	   $cnt++;
	   # Overall Record
	   $cls='s'.($cnt%2+1);
	   $text.="  <tr class='$cls'>";
	   $text.="<td class='".$cls."_l'><b>Overall Record:</b></td>";
	   $text.="<td>".stat_format('winpct',$wTot/($wTot+$lTot))."</td>";
	   $i=0;
	   $text.="<td class='".$cls."_l'>$wTot-$lTot</td>";
	   $text.="</tr>\n";
	   $cnt++;
	   # Most Wins
	   $cls='s'.($cnt%2+1);
	   $text.="  <tr class='$cls'>";
	   $text.="<td class='".$cls."_l'><b>Most Wins:</b></td>";
	   $text.="<td>$maxW</td>";
	   $i=0;
	   $text.="<td class='".$cls."_l'>";
	   foreach ($seasons['win']['maxYr'] as $yr => $val)
	   {
		   if ($i>0) {$text.=", ";}
		   $text.="<a href='./team_summary.php?league_id=$lgid&team_id=$tid&year=$yr'>$yr</a>";
		   $i++;
	   }
	   $text.="</td>";
	   $text.="</tr>\n";
	   $cnt++;
	   # Most Losses
	   $cls='s'.($cnt%2+1);
	   $text.="  <tr class='$cls'>";
	   $text.="<td class='".$cls."_l'><b>Most Losses:</b></td>";
	   $text.="<td>$maxL</td>";
	   $i=0;
	   $text.="<td class='".$cls."_l'>";
	   foreach ($seasons['loss']['maxYr'] as $yr => $val)
	   {
		   if ($i>0) {$text.=", ";}
		   $text.="<a href='./team_summary.php?league_id=$lgid&team_id=$tid&year=$yr'>$yr</a>";
		   $i++;
	   }
	   $text.="</td>";
	   $text.="</tr>\n";
	   $cnt++;
	   # Winning Seasons
	   $cls='s'.($cnt%2+1);
	   $text.="  <tr class='$cls'>";
	   $text.="<td class='".$cls."_l'><b>Winning Seasons:</b></td>";
	   $text.="<td>".max(0,$seasons['win']['cnt'])."</td><td>&nbsp;</td>";
	   $text.="</tr>\n";
	   $cnt++;
	   # Losing Seasons
	   $cls='s'.($cnt%2+1);
	   $text.="  <tr class='$cls'>";
	   $text.="<td class='".$cls."_l'><b>Losing Seasons:</b></td>";
	   $text.="<td>".max(0,$seasons['loss']['cnt'])."</td><td>&nbsp;</td>";
	   $text.="</tr>\n";
	   $cnt++;
	   # .500 Seasons
	   $cls='s'.($cnt%2+1);
	   $text.="  <tr class='$cls'>";
	   $text.="<td class='".$cls."_l'><b>.500 Seasons:</b></td>";
	   $text.="<td>".max(0,$seasons['even']['cnt'])."</td><td>&nbsp;</td>";
	   $text.="</tr>\n";
	   $cnt++;
	   # Longest Winning Streak
	   $cls='s'.($cnt%2+1);
	   $text.="  <tr class='$cls'>";
	   $text.="<td class='".$cls."_l'><b>Longest Winning Streak:</b></td>";
	   if (isset($streaks['w']))
	   {
		   $maxLen=0;
		   foreach ($streaks['w'] as $strkID => $val)
		   {
			   if ($streaks['w'][$strkID]['len']>$maxLen) {$maxLen=$streaks['w'][$strkID]['len'];}
		   }
		   $text.="<td>$maxLen</td>";
		   $i=0;
		   $text.="<td class='".$cls."_l'>";
		   foreach ($streaks['w'] as $strkID => $val)
		   {
			   if ($streaks['w'][$strkID]['len']!=$maxLen) {continue;}
			   if ($i>0) {$text.=", ";}
			   if ($streaks['w'][$strkID]['start']==$streaks['w'][$strkID]['end']) {$text.=$streaks['w'][$strkID]['start'];}
			   else {$text.=$streaks['w'][$strkID]['start']."-".$streaks['w'][$strkID]['end'];}
			   $i++;
		   }
		   $text.="</td>";
	   }
	   else
	   {
		   $text.="<td colspan=2 style='text-align:center;'>None</td>";
	   }
	   $text.="</tr>\n";
	   $cnt++;
	   # Longest Losing Streak
	   $cls='s'.($cnt%2+1);
	   $text.="  <tr class='$cls'>";
	   $text.="<td class='".$cls."_l' style='border-bottom:1px dotted #666666;'><b>Longest Losing Streak:</b></td>";
	   if (isset($streaks['l']))
	   {
		   $maxLen=0;
		   foreach ($streaks['l'] as $strkID => $val)
		   {
			   if ($streaks['l'][$strkID]['len']>$maxLen) {$maxLen=$streaks['l'][$strkID]['len'];}
		   }
		   $text.="<td style='border-bottom:1px dotted #666666;'>$maxLen</td>";
		   $i=0;
		   $text.="<td class='".$cls."_l' style='border-bottom:1px dotted #666666;'>";
		   foreach ($streaks['l'] as $strkID => $val)
		   {
			   if ($streaks['l'][$strkID]['len']!=$maxLen) {continue;}
			   if ($i>0) {$text.=", ";}
			   if ($streaks['l'][$strkID]['start']==$streaks['l'][$strkID]['end']) {$text.=$streaks['l'][$strkID]['start'];}
			   else {$text.=$streaks['l'][$strkID]['start']."-".$streaks['l'][$strkID]['end'];}
			   $i++;
		   }
		   $text.="</td>";
	   }
	   else
	   {
		   $text.="<td colspan=2 style='text-align:center;' style='border-bottom:1px dotted #666666;'>None</td>";
	   }
	   $text.="</tr>\n";
	   $cnt++;
	   # Standings Finish
	   for ($pos=1;$pos<=$maxPos;$pos++)
	   {
		   $cls='s'.($cnt%2+1);
		   $text.="  <tr class='$cls'>";
		   $text.="<td class='".$cls."_l'><b>Finished ".ordinal_suffix($pos).":</b></td>";
		   if (isset($seasons['standings'][$pos]))
		   {
			   $text.="<td>".$seasons['standings'][$pos]['cnt']."</td>";
			   $i=0;
			   $text.="<td class='".$cls."_l'>";
			   foreach ($seasons['standings'][$pos]['yrs'] as $yr => $val)
			   {
				   if ($i>0) {$text.=", ";}
				   $text.="<span title='".$seasons['winpct'][$yr];
				   if (isset($seasons['champions'][$yr])) {$text.=", Champions";}
				   elseif (isset($seasons['playoffs'][$yr])) {$text.=", Postseason";}
				   $text.="'><a href='./team_summary.php?league_id=$lgid&team_id=$tid&year=$yr'>$yr</a></span>";
				   $i++;
			   }
			   $text.="</td>";
		   }
		   else
		   {
			   $text.="<td colspan=2 style='text-align:center;'>Never</td>";
		   }
		   $text.="</tr>\n";
		   $cnt++;
	   }
	   $text.=" </table>\n";
	   $text.="</div>\n";

   }
 
   ##### Get Award Info
   $query="SELECT mvp_award_name,pitcher_award_name,rookie_award_name,defense_award_name FROM leagues WHERE league_id=$lgid;";
   if ($_GET['showq']==1) {echo "$query<br/>\n";}
   $result=mysqli_query($db,$query);
   $row=mysqli_fetch_array($result);
   $awardName['boy']=$row['mvp_award_name'];
   $awardName['poy']=$row['pitcher_award_name'];
   $awardName['roy']=$row['rookie_award_name'];
   $awardName['gg']=$row['defense_award_name'];

   ##### Get Award Winners
   $query="SELECT p.player_id,first_name,last_name,season as year,award_id FROM players as p,(";
   $query.="(SELECT player_id,season,team_id,award_id FROM league_history as lh,players_awards as pa WHERE lh.league_id=$lgid AND pa.team_id=$tid AND lh.year=pa.season AND best_pitcher_id=player_id AND award_id=4)";
   $query.=" UNION (SELECT player_id,season,team_id,award_id FROM league_history as lh,players_awards as pa WHERE lh.league_id=$lgid AND pa.team_id=$tid AND lh.year=pa.season AND best_hitter_id=player_id AND award_id=5)";
   $query.=" UNION (SELECT player_id,season,team_id,award_id FROM league_history as lh,players_awards as pa WHERE lh.league_id=$lgid AND pa.team_id=$tid AND lh.year=pa.season AND best_rookie_id=player_id AND award_id=6)";
   $query.=") as pa WHERE p.player_id=pa.player_id ORDER BY award_id,year";
   if ($_GET['showq']==1) {$text.="$query<br/>\n";}
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result))
   {
	   while ($row=mysqli_fetch_array($result))
	   {
		   $pid=$row['player_id'];
		   $name=$row['first_name']." ".$row['last_name'];
		   $yr=$row['year'];
		   $awID=$row['award_id'];

		   $players['who'][$pid]['name']=$name;

		   switch ($awID)
		   {
		   case 4:
			   $players['poys'][$yr]['pid']=$pid;
			   break;
		   case 5:
			   $players['boys'][$yr]['pid']=$pid;
			   break;
		   case 6:
			   $players['roys'][$yr]['pid']=$pid;
			   break;
		   }
	   }
   }
   # Get Batting Stats
   $bStatArray=Array('g','pa','hr','rbi','avg','obp','slg');
   $query="SELECT pa.player_id,pa.year,award_id";
   foreach ($bStatArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
   $query.=" FROM players_career_batting_stats as pcs,(SELECT player_id,season as year,award_id FROM players_awards WHERE team_id=$tid AND award_id IN (5,6)) as pa WHERE pcs.player_id=pa.player_id AND pcs.year=pa.year AND split_id=1 AND league_id=$lgid GROUP BY award_id,player_id,year";
   if ($_GET['showq']==1) {$text.="$query<br/>\n";}
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result))
   {
	   while ($row=mysqli_fetch_array($result))
	   {
		   $pid=$row['player_id'];
		   $yr=$row['year'];

		   foreach ($bStatArray as $key => $statLbl)
		   {
			   $players[$pid][$yr][$statLbl]=stat_format($statLbl,$row[$statLbl]);
		   }
	   }
   }
   # Get Pitching Stats
   $pStatArray=Array('g','ip','w','l','s','era','k');
   $query="SELECT pa.player_id,pa.year,award_id";
   foreach ($pStatArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
   $query.=" FROM players_career_pitching_stats as pcs,(SELECT player_id,season as year,award_id FROM players_awards WHERE team_id=$tid AND award_id IN (4,6)) as pa WHERE pcs.player_id=pa.player_id AND pcs.year=pa.year AND split_id=1 AND league_id=$lgid GROUP BY award_id,player_id,year";
   if ($_GET['showq']==1) {$text.="$query<br/>\n";}
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result))
   {
	   while ($row=mysqli_fetch_array($result))
	   {
		   $pid=$row['player_id'];
		   $yr=$row['year'];

		   foreach ($pStatArray as $key => $statLbl)
		   {
			   $players[$pid][$yr][$statLbl]=stat_format($statLbl,$row[$statLbl]);
		   }
	   }
   }

   ##### Trophy Room #####
   $text.="<div class='textbox' style='border:0px;float:left;width:450px;'>\n";
   if (isset($seasons['champions']))
   {
	   foreach ($seasons['champions'] as $yr => $val)
	   {
		   $slid=$seasons['slid'][$yr];
		   $text.="<img src='".get_award_pic('trophy',$lgid,$slid,$yr)."' title='$yr' />\n";
	   }
   }
   if (isset($players['boys']))
   {
	   if (isset($seasons['champions'])) {$text.="</br>\n";}
	   foreach ($players['boys'] as $yr => $val)
	   {
		   $pid=$players['boys'][$yr]['pid'];
		   $slid=$seasons['slid'][$yr];
		   $text.="<img src='".get_award_pic('mvp',$lgid,$slid,$yr)."' title=\"$yr - ".$players['who'][$pid]['name']."\" />\n";
	   }
   }
   if (isset($players['poys']))
   {
	   if ((isset($seasons['champions']))||(isset($players['boys']))) {$text.="</br>\n";}
	   foreach ($players['poys'] as $yr => $val)
	   {
		   $pid=$players['poys'][$yr]['pid'];
		   $slid=$seasons['slid'][$yr];
		   $text.="<img src='".get_award_pic('cyyoung',$lgid,$slid,$yr)."' title=\"$yr - ".$players['who'][$pid]['name']."\" />\n";
	   }
   }
   if (isset($players['roys']))
   {
	   if ((isset($seasons['champions']))||(isset($players['boys']))||(isset($players['poys']))) {$text.="</br>\n";}
	   foreach ($players['roys'] as $yr => $val)
	   {
		   $pid=$players['roys'][$yr]['pid'];
		   $slid=$seasons['slid'][$yr];
		   $text.="<img src='".get_award_pic('roy',$lgid,$slid,$yr)."' title=\"$yr - ".$players['who'][$pid]['name']."\" />\n";
	   }
   }
   $text.="</div>\n";

   ##### Top Container Close
   $text.="</div>\n";

   ##### Award Winners Table
   $text.="<div class='textbox'>\n";
   $text.=" <table border=0 cellpadding=2 cellspacing=0 style='width:935px;'>\n";
   if (isset($players['hofers']))
   {
	   $text.="  <tr class='title2'><td colspan=3>Hall of Famers</td></tr>\n";
   }
   if ((isset($players['boys']))||(isset($players['poys']))||(isset($players['roys'])))
   {
	   $text.="  <tr class='title2'><td colspan=3>Award Winners</td></tr>\n";
	   $text.="  <tr class='headline'>";
	   $text.="<td class='hsc2' style='text-align:center;width:33%;'>".$awardName['boy']."</td>";
	   $text.="<td class='hsc2' style='text-align:center;width:33%;border-left:1px dotted #666666;'>".$awardName['poy']."</td>";
	   $text.="<td class='hsc2' style='text-align:center;width:33%;border-left:1px dotted #666666;'>".$awardName['roy']."</td>";
	   $text.="</tr>\n";

	   $text.="  <tr>\n";
	   if (isset($players['boys']))
	   {
		   $text.="   <td class='s1' style='padding:0px;vertical-align:top;'>\n";
		   $text.="    <table cellpadding=2 cellspacing=0 border=0 style='width:100%;'>\n";
		   $cnt=0;
		   foreach ($players['boys'] as $yr => $val)
		   {
			   $slid=$seasons['slid'][$yr];

			   $cls='s'.($cnt%2+1);
			   $text.="     <tr class='$cls' style='text-align:center;'>";
			   $text.="<td><a href='./team_summary.php?league_id=$lgid&team_id=$tid&year=$yr'>$yr</a> <a href='./league_summary.php?league_id=$lgid&sub_league_id=$slid&year=$yr' title=\"$yr ".$subleagues[$slid][$yr]['name']."\">".$subleagues[$slid][$yr]['abbr']."</a></td>";
			   $pid=$players['boys'][$yr]['pid'];
			   $text.="<td><a href='./player.php?player_id=$pid'>".$players['who'][$pid]['name']."</a></td>";
			   $text.="</tr><tr class='$cls' style='text-align:center;'>";
			   $text.="<td>&nbsp;</td><td>";
			   $text.=$players[$pid][$yr]['avg']."/".$players[$pid][$yr]['obp']."/".$players[$pid][$yr]['slg'];
			   $text.=", ".$players[$pid][$yr]['hr']." HR, ".$players[$pid][$yr]['rbi']." RBI";
			   $text.="</td>";
			   $text.="</tr>\n";
			   $cnt++;
		   }
		   $text.="    </table>\n";
		   $text.="   </td>\n";
	   }
	   else {$text.="   <td class='s1'>&nbsp;</td>\n";}
	   if (isset($players['poys']))
	   {
		   $text.="   <td class='s2' style='padding:0px;vertical-align:top;border-left:1px dotted #666666;'>\n";
		   $text.="    <table cellpadding=2 cellspacing=0 border=0 style='width:100%;'>\n";
		   $cnt=0;
		   foreach ($players['poys'] as $yr => $val)
		   {
			   $slid=$seasons['slid'][$yr];

			   $cls='s'.($cnt%2+1);
			   $text.="     <tr class='$cls' style='text-align:center;'>";
			   $text.="<td><a href='./team_summary.php?league_id=$lgid&team_id=$tid&year=$yr'>$yr</a> <a href='./league_summary.php?league_id=$lgid&sub_league_id=$slid&year=$yr' title=\"$yr ".$subleagues[$slid][$yr]['name']."\">".$subleagues[$slid][$yr]['abbr']."</a></td>";
			   $pid=$players['poys'][$yr]['pid'];
			   $text.="<td><a href='./player.php?player_id=$pid'>".$players['who'][$pid]['name']."</a></td>";
			   $text.="</tr><tr class='$cls' style='text-align:center;'>";
			   $text.="<td>&nbsp;</td><td>";
			   $text.=$players[$pid][$yr]['w']."-".$players[$pid][$yr]['l'];
			   if ($players[$pid][$yr]['s']>(0.25*$players[$pid][$yr]['pg'])) {$text.=", ".$players[$pid][$yr]['s']. " SV";}
			   $text.=", ".$players[$pid][$yr]['era']." ERA, ".$players[$pid][$yr]['k']." K";
			   $text.="</td>";
			   $text.="</tr>\n";
			   $cnt++;
		   }
		   $text.="    </table>\n";
		   $text.="   </td>\n";
	   }
	   else {$text.="   <td class='s2' style='border-left:1px dotted #666666;'>&nbsp;</td>\n";}
	   if (isset($players['roys']))
	   {
		   $text.="   <td class='s1' style='padding:0px;vertical-align:top;border-left:1px dotted #666666;'>\n";
		   $text.="    <table cellpadding=2 cellspacing=0 border=0 style='width:100%;'>\n";
		   $cnt=0;
		   foreach ($players['roys'] as $yr => $val)
		   {
			   $slid=$seasons['slid'][$yr];

			   $cls='s'.($cnt%2+1);
			   $text.="     <tr class='$cls' style='text-align:center;'>";
			   $text.="<td><a href='./team_summary.php?league_id=$lgid&team_id=$tid&year=$yr'>$yr</a> <a href='./league_summary.php?league_id=$lgid&sub_league_id=$slid&year=$yr' title=\"$yr ".$subleagues[$slid][$yr]['name']."\">".$subleagues[$slid][$yr]['abbr']."</a></td>";
			   $pid=$players['roys'][$yr]['pid'];
			   $text.="<td><a href='./player.php?player_id=$pid'>".$players['who'][$pid]['name']."</a></td>";
			   $text.="</tr><tr class='$cls' style='text-align:center;'>";
			   $text.="<td>&nbsp;</td><td>";

			   if ((isset($players[$pid][$yr]['pa']))&&(isset($players[$pid][$yr]['ip'])))
			   {
				   if ($players[$pid][$yr]['pa']>(2*$players[$pid][$yr]['ip'])) {$show='bat';} else {$show='pit';}
			   }
			   if (($show=='bat')||((isset($players[$pid][$yr]['pa']))&&(!isset($players[$pid][$yr]['ip']))))   //Show batting stats
			   {
				   $text.=$players[$pid][$yr]['avg']."/".$players[$pid][$yr]['obp']."/".$players[$pid][$yr]['slg'];
				   $text.=", ".$players[$pid][$yr]['hr']." HR, ".$players[$pid][$yr]['rbi']." RBI";
			   }
			   else   //Show pitching stats
			   {
				   $text.=$players[$pid][$yr]['w']."-".$players[$pid][$yr]['l'];
				   if ($players[$pid][$yr]['s']>(0.25*$players[$pid][$yr]['pg'])) {$text.=", ".$players[$pid][$yr]['s']. " SV";}
				   $text.=", ".$players[$pid][$yr]['era']." ERA, ".$players[$pid][$yr]['k']." K";
			   }
			   $text.="</td>";
			   $text.="</tr>\n";
			   $cnt++;
		   }
		   $text.="    </table>\n";
		   $text.="   </td>\n";
	   }
	   else {$text.="   <td class='s1' style='border-left:1px dotted #666666;'>&nbsp;</td>\n";}
	   $text.="  </tr>\n";
   }
   ## Gold Glovers
   $query="SELECT first_name,last_name,x.* FROM players as p,(SELECT player_id,position,MIN(season) as firstYr,COUNT(season) as cnt FROM players_awards WHERE league_id=$lgid AND team_id=$tid AND award_id=7 GROUP BY player_id,position) as x WHERE p.player_id=x.player_id ORDER BY position,cnt DESC,firstYr";
   if ($_GET['showq']==1) {$text.="$query<br/>\n";}
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result))
   {
	   if ((!isset($players['boys']))&&(!isset($players['poys']))&&(!isset($players['roys'])))
	   {
		   $text.="  <tr class='title2'><td colspan=3>Award Winners</td></tr>\n";
	   }
	   $text.="  <tr>\n";
	   $text.="   <td class='s1' colspan=3 style='padding:0px;border-top:1px dotted #666666;'>\n";
	   $text.="    <table cellpadding=2 cellspacing=0 border=0 style='width:100%;'>\n";
	   $text.="     <tr class='headline'><td class='hsc2' colspan=2 style='text-align:center;'>".$awardName['gg']."</td></tr>\n";
	   $lastPos=0;
	   $cnt=0;
	   while ($row=mysqli_fetch_array($result))
	   {
		   $pid=$row['player_id'];
		   $pos=$row['position'];

		   if ($pos!=$lastPos)
		   {
			   if ($lastPos!=0) {$text.="</td></tr>\n";}

			   if ($pos!=($lastPos+1))
			   {
				   for ($i=$lastPos+1;$i<$pos;$i++)
				   {
					   $cls='s'.($cnt%2+1);
					   $text.="     <tr class='$cls'><td class='".$cls."_l' style='width:100px;'><b>".get_pos($i).":</b></td><td class='".$cls."_l'>None</td></tr>\n";
					   $cnt++;
				   }
			   }

			   $cls='s'.($cnt%2+1);
			   $text.="     <tr class='$cls'>";
			   $text.="<td class='".$cls."_l' style='width:100px;'><b>".get_pos($pos).":</b></td><td class='".$cls."_l'>";
			   $cnt++;
		   }
		   else {$text.=", ";}

		   $fi=$row['first_name'][0];
		   $text.="<a href='./player.php?player_id=$pid' title=\"".$row['first_name']." ".$row['last_name']."\">$fi. ".$row['last_name']."</a>";
		   if ($row['cnt']>1) {$text.=" (".$row['cnt'].")";}

		   $lastPos=$pos;
	   }
	   $text.="</td></tr>\n";
	   if ($lastPos<9)
	   {
		   for ($i=$lastPos+1;$i<=9;$i++)
		   {
			   $cls='s'.($cnt%2+1);
			   $text.="     <tr class='$cls'><td class='".$cls."_l' style='width:100px;'><b>".get_pos($i).":</b></td><td class='".$cls."_l'>None</td></tr>\n";
			   $cnt++;
		   }
	   }
	   $text.="    </table>\n";
	   $text.="   </td>\n";
	   $text.="  </tr>\n";
   }
   else {$noGG=1;}
   ## All Stars
   $query="SELECT first_name,last_name,x.* FROM players as p,(SELECT player_id,MIN(season) as firstYr,COUNT(season) as cnt FROM players_awards WHERE league_id=$lgid AND team_id=$tid AND award_id=9 GROUP BY player_id) as x WHERE p.player_id=x.player_id ORDER BY cnt DESC,firstYr,last_name,first_name";
   if ($_GET['showq']==1) {$text.="$query<br/>\n";}
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result))
   {
	   if ((!isset($players['boys']))&&(!isset($players['poys']))&&(!isset($players['roys']))&&($noGG==1))
	   {
		   $text.="  <tr class='title2'><td colspan=3>Award Winners</td></tr>\n";
	   }
	   $text.="  <tr>\n";
	   $text.="   <td class='s1' colspan=3 style='padding:0px;border-top:1px dotted #666666;'>\n";
	   $text.="    <table cellpadding=2 cellspacing=0 border=0 style='width:100%;'>\n";
	   $text.="     <tr class='headline'><td class='hsc2' colspan=2 style='text-align:center;'>All-Stars</td></tr>\n";
	   $xTimes=0;
	   $cnt=0;
	   while ($row=mysqli_fetch_array($result))
	   {
		   $pid=$row['player_id'];
		   $pTimes=$row['cnt'];

		   if ($pTimes!=$xTimes)
		   {
			   if ($xTimes!=0) {$text.="</td></tr>\n";}

			   $cls='s'.($cnt%2+1);
			   $text.="     <tr class='$cls'>";
			   $text.="<td class='".$cls."_l' style='width:100px;vertical-align:top;'><b>$pTimes Time";
			   if ($pTimes!=1) {$text.="s";}
			   $text.=":</b></td><td class='".$cls."_l'>";
			   $cnt++;
		   }
		   else {$text.=", ";}

		   $fi=$row['first_name'][0];
		   $text.="<a href='./player.php?player_id=$pid' title=\"".$row['first_name']." ".$row['last_name']."\">$fi. ".$row['last_name']."</a>";

		   $xTimes=$pTimes;
	   }
	   $text.="</td></tr>\n";
	   $text.="    </table>\n";
	   $text.="   </td>\n";
	   $text.="  </tr>\n";
   }
   $text.=" </table>\n";
   $text.="</div>\n";

   ##### Loop Through Positions #####
   $posArray=Array(2,3,4,5,6,7,8,9);
   $text.="<div class='textbox'>\n";
   $text.=" <table border=0 cellpadding=2 cellspacing=0 style='width:935px;'>\n";
   $text.="  <tr class='title2'><td colspan=14>All-Time Career and Seasonal Lineup (by WAR)</tr>\n";
   $text.="  <tr class='headline'>";
   $text.="<td class='hsc2_l'>Pos</td>";
   $text.="<td class='hsc2_l'>Career</td>";
   $text.="<td class='hsc2_l'>Years</td>";
   $text.="<td class='hsc2'>Avg</td>";
   $text.="<td class='hsc2'>HR</td>";
   $text.="<td class='hsc2'>SB</td>";
   $text.="<td class='hsc2'>WAR</td>";
   $text.="<td class='hsc2_l' style='border-left:1px dotted #999999;'>Pos</td>";
   $text.="<td class='hsc2_l'>Season</td>";
   $text.="<td class='hsc2_l'>Year</td>";
   $text.="<td class='hsc2'>Avg</td>";
   $text.="<td class='hsc2'>HR</td>";
   $text.="<td class='hsc2'>SB</td>";
   $text.="<td class='hsc2'>WAR</td>";
   $text.="</tr>\n";
   foreach ($posArray as $key => $pos)
   {
	   $cls='s'.($pos%2+1);

	   $text.="  <tr class='$cls'>";
	   $text.="<td class='".$cls."_l' style='font-weight:bold;'>".get_pos($pos,1)."</td>";
	   ## Get Career Player
	   $query="SELECT z.*,CONCAT(MIN(pcs.year),'-',MAX(pcs.year)) as years,SUM(h)/SUM(ab) as avg,SUM(hr) as hr,SUM(sb) as sb,SUM(war) as war FROM players_career_batting_stats as pcs,(SELECT first_name,last_name,x.* FROM players as p,(SELECT player_id,position,ip,SUM(ip) as totalIP FROM (SELECT player_id,position,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_fielding_stats WHERE team_id=$tid AND split_id<=1 AND position>1 GROUP BY player_id,position ORDER BY player_id,ip DESC) as y GROUP BY player_id) as x WHERE p.player_id=x.player_id AND x.position=$pos) as z WHERE pcs.player_id=z.player_id AND pcs.team_id=$tid AND pcs.split_id=1 GROUP BY player_id ORDER BY war DESC LIMIT 1";
	   if ($_GET['showq']==1) {$text.="$query<br/>\n";}
	   $result=mysqli_query($db,$query);
	   if (mysqli_num_rows($result))
	   {
		   $row=mysqli_fetch_array($result);
		   $pid=$row['player_id'];

		   $text.="<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";
		   $text.="<td class='".$cls."_l'>".$row['years']."</td>";
		   $text.="<td>".stat_format('avg',$row['avg'])."</td>";
		   $text.="<td>".stat_format('hr',$row['hr'])."</td>";
		   $text.="<td>".stat_format('sb',$row['sb'])."</td>";
		   $text.="<td>".stat_format('war',$row['war'])."</td>";

	   }

   	   $text.="<td class='".$cls."_l' style='border-left:1px dotted #999999;font-weight:bold;'>".get_pos($pos,1)."</td>";

	   ## Get Season Player
	   $query="SELECT z.*,SUM(h)/SUM(ab) as avg,SUM(hr) as hr,SUM(sb) as sb,SUM(war) as war FROM players_career_batting_stats as pcs,(SELECT first_name,last_name,x.* FROM players as p,(SELECT player_id,year,position,ip,SUM(ip) as totalIP FROM (SELECT player_id,year,position,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_fielding_stats WHERE team_id=$tid AND split_id<=1 AND position>1 GROUP BY player_id,year,position ORDER BY player_id,year,ip DESC) as y GROUP BY player_id,year) as x WHERE p.player_id=x.player_id AND x.position=$pos) as z WHERE pcs.player_id=z.player_id AND pcs.team_id=$tid AND pcs.year=z.year AND pcs.split_id=1 GROUP BY player_id,year ORDER BY war DESC LIMIT 1";
	   if ($_GET['showq']==1) {$text.="$query<br/>\n";}
	   $result=mysqli_query($db,$query);
	   if (mysqli_num_rows($result))
	   {
		   $row=mysqli_fetch_array($result);
		   $pid=$row['player_id'];

		   $text.="<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";
		   $text.="<td class='".$cls."_l'>".$row['year']."</td>";
		   $text.="<td>".stat_format('avg',$row['avg'])."</td>";
		   $text.="<td>".stat_format('hr',$row['hr'])."</td>";
		   $text.="<td>".stat_format('sb',$row['sb'])."</td>";
		   $text.="<td>".stat_format('war',$row['war'])."</td>";
	   }
	   $text.="</tr>\n";
   }
   $text.=" </table>\n";
   $text.="</div>\n";

   ##### Get Pitching Staff #####
   $text.="<div class='textbox'>\n";
   $text.=" <table border=0 cellpadding=2 cellspacing=0 style='width:935px;'>\n";
   $text.="  <tr class='title2'><td colspan=14>All-Time Career and Seasonal Pitchers (by WAR)</tr>\n";
   $text.="  <tr class='headline'>";
   $text.="<td class='hsc2_l'>Pos</td>";
   $text.="<td class='hsc2_l'>Career</td>";
   $text.="<td class='hsc2_l'>Years</td>";
   $text.="<td class='hsc2'>W-L</td>";
   $text.="<td class='hsc2'>K</td>";
   $text.="<td class='hsc2'>ERA</td>";
   $text.="<td class='hsc2'>WAR</td>";
   $text.="<td class='hsc2_l' style='border-left:1px dotted #999999;'>Pos</td>";
   $text.="<td class='hsc2_l'>Season</td>";
   $text.="<td class='hsc2_l'>Year</td>";
   $text.="<td class='hsc2'>W-L</td>";
   $text.="<td class='hsc2'>K</td>";
   $text.="<td class='hsc2'>ERA</td>";
   $text.="<td class='hsc2'>WAR</td>";
   $text.="</tr>\n";
   ## Get Career Starters
   $query="SELECT first_name,last_name,x.* FROM players as p,(SELECT player_id,CONCAT(MIN(year),'-',MAX(year)) as years,CONCAT(SUM(w),'-',SUM(l)) as winloss,SUM(k) as k,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era,SUM(war) as war FROM players_career_pitching_stats WHERE team_id=$tid AND split_id=1 GROUP BY player_id HAVING SUM(g)<=(2*SUM(gs)) OR (SUM(ip)+SUM(ipf)/3)>=(4*SUM(g)) ORDER BY war DESC LIMIT 5) as x WHERE p.player_id=x.player_id ORDER BY war DESC";
   if ($_GET['showq']==1) {$text.="$query<br/>\n";}
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result))
   {
	   $cnt=0;
	   while ($row=mysqli_fetch_array($result))
	   {
		   $cls='s'.($cnt%2+1);
		   $pid=$row['player_id'];

		   $prow[$cnt]['c']="";

		   $prow[$cnt]['c'].="<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";
		   $prow[$cnt]['c'].="<td class='".$cls."_l'>".$row['years']."</td>";
		   $prow[$cnt]['c'].="<td>".$row['winloss']."</td>";
		   $prow[$cnt]['c'].="<td>".stat_format('k',$row['k'])."</td>";
		   $prow[$cnt]['c'].="<td>".stat_format('era',$row['era'])."</td>";
		   $prow[$cnt]['c'].="<td>".stat_format('war',$row['war'])."</td>";
		   $cnt++;
	   }
   }
   ## Get Seasonal Starters
$query="SELECT first_name,last_name,x.* FROM players as p,(SELECT player_id,year,CONCAT(SUM(w),'-',SUM(l)) as winloss,SUM(k) as k,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era,SUM(war) as war FROM players_career_pitching_stats WHERE team_id=$tid AND split_id=1 GROUP BY player_id,year HAVING SUM(g)<=(2*SUM(gs)) OR (SUM(ip)+SUM(ipf)/3)>=(4*SUM(g)) ORDER BY war DESC LIMIT 5) as x WHERE p.player_id=x.player_id ORDER BY war DESC";
   if ($_GET['showq']==1) {$text.="$query<br/>\n";}
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result))
   {
	   $cnt=0;
	   while ($row=mysqli_fetch_array($result))
	   {
		   $cls='s'.($cnt%2+1);
		   $pid=$row['player_id'];

		   $prow[$cnt]['s']="";

		   $prow[$cnt]['s'].="<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";
		   $prow[$cnt]['s'].="<td class='".$cls."_l'>".$row['year']."</td>";
		   $prow[$cnt]['s'].="<td>".$row['winloss']."</td>";
		   $prow[$cnt]['s'].="<td>".stat_format('k',$row['k'])."</td>";
		   $prow[$cnt]['s'].="<td>".stat_format('era',$row['era'])."</td>";
		   $prow[$cnt]['s'].="<td>".stat_format('war',$row['war'])."</td>";
		   $cnt++;
	   }
   }
   foreach ($prow as $cnt => $val)
   {
	   $cls='s'.($cnt%2+1);

	   $text.="  <tr class='$cls'>";
	   $text.="<td class='".$cls."_l' style='border-left:1px dotted #999999;font-weight:bold;'>SP</td>";
	   $text.=$prow[$cnt]['c'];
	   $text.="<td class='".$cls."_l' style='border-left:1px dotted #999999;font-weight:bold;'>SP</td>";
	   $text.=$prow[$cnt]['s'];
	   $text.="</tr>\n";
   }
   unset($prow);
   $text.="  <tr class='headline'>";
   $text.="<td class='hsc2_l'>Pos</td>";
   $text.="<td class='hsc2_l'>Career</td>";
   $text.="<td class='hsc2_l'>Years</td>";
   $text.="<td class='hsc2'>W-L, SV</td>";
   $text.="<td class='hsc2'>K</td>";
   $text.="<td class='hsc2'>ERA</td>";
   $text.="<td class='hsc2'>WAR</td>";
   $text.="<td class='hsc2_l' style='border-left:1px dotted #999999;'>Pos</td>";
   $text.="<td class='hsc2_l'>Season</td>";
   $text.="<td class='hsc2_l'>Year</td>";
   $text.="<td class='hsc2'>W-L, SV</td>";
   $text.="<td class='hsc2'>K</td>";
   $text.="<td class='hsc2'>ERA</td>";
   $text.="<td class='hsc2'>WAR</td>";
   $text.="</tr>\n";
   ## Get Career Relievers
   $query="SELECT first_name,last_name,x.* FROM players as p,(SELECT player_id,CONCAT(MIN(year),'-',MAX(year)) as years,CONCAT(SUM(w),'-',SUM(l),', ',SUM(s)) as winloss,SUM(k) as k,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era,SUM(war) as war FROM players_career_pitching_stats WHERE team_id=$tid AND split_id=1 GROUP BY player_id HAVING SUM(g)>(2*SUM(gs)) AND (SUM(ip)+SUM(ipf)/3)<(4*SUM(g)) ORDER BY war DESC LIMIT 4) as x WHERE p.player_id=x.player_id ORDER BY war DESC";
   if ($_GET['showq']==1) {$text.="$query<br/>\n";}
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result))
   {
	   $cnt=0;
	   while ($row=mysqli_fetch_array($result))
	   {
		   $cls='s'.($cnt%2+1);
		   $pid=$row['player_id'];

		   $prow[$cnt]['c']="";

		   $prow[$cnt]['c'].="<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";
		   $prow[$cnt]['c'].="<td class='".$cls."_l'>".$row['years']."</td>";
		   $prow[$cnt]['c'].="<td>".$row['winloss']."</td>";
		   $prow[$cnt]['c'].="<td>".stat_format('k',$row['k'])."</td>";
		   $prow[$cnt]['c'].="<td>".stat_format('era',$row['era'])."</td>";
		   $prow[$cnt]['c'].="<td>".stat_format('war',$row['war'])."</td>";
		   $cnt++;
	   }
   }
   ## Get Seasonal Relievers
   $query="SELECT first_name,last_name,x.* FROM players as p,(SELECT player_id,year,CONCAT(SUM(w),'-',SUM(l),', ',SUM(s)) as winloss,SUM(k) as k,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era,SUM(war) as war FROM players_career_pitching_stats WHERE team_id=$tid AND split_id=1 GROUP BY player_id,year HAVING SUM(g)>(2*SUM(gs)) AND (SUM(ip)+SUM(ipf)/3)<(4*SUM(g)) ORDER BY war DESC LIMIT 4) as x WHERE p.player_id=x.player_id ORDER BY war DESC";
   if ($_GET['showq']==1) {$text.="$query<br/>\n";}
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result))
   {
	   $cnt=0;
	   while ($row=mysqli_fetch_array($result))
	   {
		   $cls='s'.($cnt%2+1);
		   $pid=$row['player_id'];

		   $prow[$cnt]['s']="";

		   $prow[$cnt]['s'].="<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";
		   $prow[$cnt]['s'].="<td class='".$cls."_l'>".$row['year']."</td>";
		   $prow[$cnt]['s'].="<td>".$row['winloss']."</td>";
		   $prow[$cnt]['s'].="<td>".stat_format('k',$row['k'])."</td>";
		   $prow[$cnt]['s'].="<td>".stat_format('era',$row['era'])."</td>";
		   $prow[$cnt]['s'].="<td>".stat_format('war',$row['war'])."</td>";
		   $cnt++;
	   }
   }
   foreach ($prow as $cnt => $val)
   {
	   $cls='s'.($cnt%2+1);

	   $text.="  <tr class='$cls'>";
	   $text.="<td class='".$cls."_l' style='border-left:1px dotted #999999;font-weight:bold;'>RP</td>";
	   $text.=$prow[$cnt]['c'];
	   $text.="<td class='".$cls."_l' style='border-left:1px dotted #999999;font-weight:bold;'>RP</td>";
	   $text.=$prow[$cnt]['s'];
	   $text.="</tr>\n";
   }
   $text.=" </table>\n";
   $text.="</div>\n";


   mysqli_close($db);
   
   return $text;
 }

?>
