<?php
  include("html_functions.php");

  ################## PAGE INITIALIZATION #########################
  $lgid=$_SESSION['lgid'];
  $lgpath=$_SESSION['lgpath'];
  $date=new Date($_SESSION['lgdate']);
  $lgyear=$_SESSION['lgyear'];

  if (($_SESSION['user_team_id']>0)&&(!isset($_GET['team_id'])))
  {
	  if ($_SESSION['user_league_id']==$lgid) {$team_id=$_SESSION['user_team_id'];}
	  else
	  {
		  include($_SESSION['adminpath']."/dbopen.php");
		  $query="SELECT team_id FROM teams WHERE parent_team_id=".$_SESSION['user_team_id']." AND league_id=$lgid";
		  $result=mysqli_query($db,$query);
		  if (mysqli_num_rows($result))
		  {
			  $row=mysqli_fetch_array($result);
			  $team_id=$row['team_id'];
		  }
		  mysqli_close($db);
	  }
  }
  elseif (isset($_GET['team_id'])) {$team_id=$_GET['team_id'];}
  if ($team_id=="") {$team_id=-1;}
  $tyear=$_GET['year'];
  $pos=$_GET['pos'];
  if ($pos=="") {$pos=0;}
	  
  ##### Get Team Names #####
  include($_SESSION['adminpath']."/dbopen.php");
  $query="SELECT team_id,name,nickname FROM teams WHERE league_id=$lgid";
  if ($team_id>0) {$query.=" AND team_id=$team_id";}
  $query.=" AND allstar_team=0 ORDER BY name,nickname LIMIT 1;";
  $result=mysqli_query($db,$query);
  while ($row=mysqli_fetch_array($result))
  {
	  $team_id=$row['team_id'];
	  $tname=$row['name']." ".$row['nickname'];
  }
  mysqli_close($db);
  
  ##### Get Title #####
  $title=$tname." History - Fielding Registry";
  page_head($title,$_SESSION['lgpath'],"","","./jquery/excanvas.js|./jquery/jquery.min.js|./jquery/jquery.jqplot.min.js|./jquery/plugins/jqplot.categoryAxisRenderer.min.js|./jquery/plugins/jqplot.pointLabels.min.js|./jquery/plugins/jqplot.barRenderer.min.js|./jquery/plugins/jqplot.highlighter.min.js|./jquery/plugins/jqplot.cursor.min.js");
  echo " <div id='topbar'>\n";
  main_titlebar($lgid,$_SESSION['lgpath'],$title,$team_id);
  nav_toolbar("history","History");
  nav_toolbar("teams","Teams","","",$team_id,$tyear);

  ##### Show Page Content #####
  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";

  ##### Check for file #####
  echo gen_field($team_id,$pos);

  ################## END OF PAGE #########################
  echo " </div>   <!-- END contentpane DIV -->\n";
  page_foot($_SESSION['lgpath']);

  exit;

##############################################################################################
# gen_field - Fielder Registry
##############################################################################################
function gen_field($tid="",$position=0)
 {
   ##### Exit if no team_id #####
   if ($tid=="") {exit;}
   include($_SESSION['adminpath']."/dbopen.php");

   ##### Check for tables #####
   $query="SHOW TABLES LIKE 'team_history%';";
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result)<5) {return "Please load the team_history SQL tables first";}

   ##### Get basic parameters #####
   $lgdate=$_SESSION['lgdate'];
   $date=new Date($_SESSION['lgdate']);
   $lgyear=$_SESSION['lgyear'];
   $lgpath=$_SESSION['lgpath'];
   $lgid=$_GET['lgid'];
   if ($lgid=="") {$lgid=$_SESSION['lgid'];}
   if ($lgid=="") {$lgid=100;}
   $text="";

   ##### Display Position Navigation #####
   $posArray=Array('0'=>'All','1'=>'Pitcher','2'=>'Catcher','3'=>'First Baseman','4'=>'Second Baseman','5'=>'Third Baseman','6'=>'Shortstop','7'=>'Left Fielder','8'=>'Center Fielder','9'=>'Right Fielder');
   $text.="<div class='textbox'>\n";
   $text.=" <table cellpadding=0 cellspacing=0 border=0 width='930px'>\n";
   $text.="  <tr class='title2'><td style='padding:2px;' colspan=10>Position</td></tr>\n";
   $text.="  <tr style='text-align:center;'>";
   foreach ($posArray as $pos => $name)
    {
      $text.="<td>";
      if ($pos==$position) {$text.="<b>$name</b>";}
       else {$text.="<a href='./team_fielding_registry.php?team_id=$tid&pos=$pos'>$name</a>";}
      $text.="</td>";
    }
   $text.="</tr>\n";
   $text.=" </table>\n";
   $text.="</div>\n";

   ##### Get Team Totals #####
   ## From Pitching Stats
   $query="SELECT year,r,er,ha,bf,bb,k,hp,hra FROM team_history_pitching_stats WHERE team_id=$tid UNION SELECT year,r,er,ha,bf,bb,k,hp,hra FROM team_pitching_stats WHERE team_id=$tid ORDER BY year;";
   if ($_GET['showq']==1) {$text.="$query</br>\n";}
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result))
    {
      while ($row=mysqli_fetch_array($result))
       {
         $yr=$row['year'];
	 $tmStats[$yr]['r']=$row['r'];
	 $tmStats[$yr]['er']=$row['er'];
	 $tmStats[$yr]['ha']=$row['ha'];
	 $tmStats[$yr]['bf']=$row['bf'];
	 $tmStats[$yr]['bb']=$row['bb'];
	 $tmStats[$yr]['k']=$row['k'];
	 $tmStats[$yr]['hp']=$row['hp'];
	 $tmStats[$yr]['hra']=$row['hra'];
       }
    }

   ## From Fielding Stats
   $query="SELECT year,g,po,a,dp,tp,tc,e,(ip*3+ipf)/3 as inn FROM team_history_fielding_stats_stats WHERE team_id=$tid UNION SELECT '$lgyear',g,po,a,dp,tp,tc,e,(ip*3+ipf)/3 as inn FROM team_fielding_stats_stats WHERE team_id=$tid ORDER BY year;";
   if ($_GET['showq']==1) {$text.="$query</br>\n";}
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result)>0)
    {
      $text.="<div class='textbox'>\n";
      $text.=" <table cellpadding=0 cellspacing=0 border=0 width='930px'>\n";
      $text.="  <tr class='title'><td style='padding:2px;'>Team Overall Fielding Totals</td></tr>\n";
      $text.="  <tr><td>\n";
      $text.="   <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='100%'>\n";
      $text.="    <thead><tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2'>G</td><td class='hsc2'>PO</td><td class='hsc2'>A</td><td class='hsc2'>DP</td><td class='hsc2'>TP</td><td class='hsc2'>TC</td><td class='hsc2'>E</td><td class='hsc2'>Pct</td><td class='hsc2'>Inn</td><td class='hsc2'>Rng</td><td class='hsc2'>R</td><td class='hsc2'>ER</td><td class='hsc2'>UER</td><td class='hsc2'>DEff</td></tr></thead>\n";
      $cnt=0;
      while ($row=mysqli_fetch_array($result))
       {
         $yr=$row['year'];
	 $Tyr+=1;

	 $g=$row['g'];
         if (($yr==0)||($g==0)) {continue;}
	 $po=$row['po'];
	 $a=$row['a'];
	 $dp=$row['dp'];
	 $tp=$row['tp'];
	 $tc=$row['tc'];
	 $e=$row['e'];
	 $inn=$row['inn'];
	 $r=$tmStats[$yr]['r'];
	 $er=$tmStats[$yr]['er'];
	 $ha=$tmStats[$yr]['ha'];
	 $bf=$tmStats[$yr]['bf'];
	 $bb=$tmStats[$yr]['bb'];
	 $k=$tmStats[$yr]['k'];
	 $hp=$tmStats[$yr]['hp'];
	 $hra=$tmStats[$yr]['hra'];

	 $Tg+=$g;
	 $Tpo+=$po;
	 $Ta+=$a;
	 $Tdp+=$dp;
	 $Ttp+=$tp;
	 $Ttc+=$tc;
	 $Te+=$e;
	 $Tinn+=$inn;
	 $Tr+=$r;
	 $Ter+=$er;
	 $Tha+=$ha;
	 $Tbf+=$bf;
	 $Tbb+=$bb;
	 $Tk+=$k;
	 $Thp+=$hp;
	 $Thra+=$hra;

         if ($tc==0) {$pct=0;}
	  else {$pct=($po+$a)/$tc;}
	 $pct=sprintf("%.3f",$pct);
         if ($pct<1) {$pct=strstr($pct,".");}

	 if ($inn==0) {$rng=0;}
          else {$rng=9*($po+$a)/$inn;}
         $rng=sprintf("%0.2f",$rng);
	 
	 $bip=$bf-$bb-$k-$hp-$hra;
         if ($bip==0) {$deff=0;}
          else {$deff=1-(($ha+0-$e)/$bip);}
         $deff=sprintf("%.3f",$deff);
         if ($deff<1) {$deff=strstr($deff,".");}
      
	 $cls='s'.($cnt%2+1);
	 $text.="    <tr class='$cls'><td class='".$cls."_l'><a href='./team_summary.php?team_id=$tid&year=$yr'>$yr</a></td>";
	 $text.="<td>$g</td>";
	 $text.="<td>$po</td>";
	 $text.="<td>$a</td>";
	 $text.="<td>$dp</td>";
	 $text.="<td>$tp</td>";
	 $text.="<td>$tc</td>";
	 $text.="<td>$e</td>";
	 $text.="<td>$pct</td>";
	 $text.="<td>".sprintf("%.1f",$inn)."</td>";
	 $text.="<td>$rng</td>";
	 $text.="<td>$r</td>";
	 $text.="<td>$er</td>";
	 $text.="<td>".($r-$er)."</td>";
	 $text.="<td>$deff</td>";
	 $text.="</tr>\n";

	 $cnt++;
       }

      ## Show Team Totals
      if ($Ttc==0) {$pct=0;}
       else {$pct=($Tpo+$Ta)/$Ttc;}
      $pct=sprintf("%.3f",$pct);
      if ($pct<1) {$pct=strstr($pct,".");}

      if ($Tinn==0) {$rng=0;}
       else {$rng=9*($Tpo+$Ta)/$Tinn;}
      $rng=sprintf("%0.2f",$rng);
	 
      $bip=$Tbf-$Tbb-$Tk-$Thp-$Thra;
      if ($bip==0) {$deff=0;}
       else {$deff=1-(($Tha+0-$Te)/$bip);}
      $deff=sprintf("%.3f",$deff);
      if ($deff<1) {$deff=strstr($deff,".");}

      $text.="    <tfoot>\n";
      $text.="     <tr class='headline'>";
      if ($Tyr>0) {$text.="<td class='hsc2_l'>Total over $Tyr years</td>";}
       else {$text.="<td class='hsc2_l'>Total over $Tyr year</td>";}
      $text.="<td class='hsc2'>$Tg</td>";
      $text.="<td class='hsc2'>$Tpo</td>";
      $text.="<td class='hsc2'>$Ta</td>";
      $text.="<td class='hsc2'>$Tdp</td>";
      $text.="<td class='hsc2'>$Ttp</td>";
      $text.="<td class='hsc2'>$Ttc</td>";
      $text.="<td class='hsc2'>$Te</td>";
      $text.="<td class='hsc2'>$pct</td>";
      $text.="<td class='hsc2'>".sprintf("%.1f",$Tinn)."</td>";
      $text.="<td class='hsc2'>$rng</td>";
      $text.="<td class='hsc2'>$Tr</td>";
      $text.="<td class='hsc2'>$Ter</td>";
      $text.="<td class='hsc2'>".($Tr-$Ter)."</td>";
      $text.="<td class='hsc2'>$deff</td>";
      $text.="</tr>\n";
      $text.="     <tr class='headline'>";
      $text.="<td class='hsc2_l'>Per season average</td>";
      $text.="<td class='hsc2'>".round($Tg/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tpo/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Ta/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tdp/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Ttp/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Ttc/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Te/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>&nbsp;</td>";
      $text.="<td class='hsc2'>".round($Tinn/$Tyr,1)."</td>";
      $text.="<td class='hsc2'>&nbsp;</td>";
      $text.="<td class='hsc2'>".round($Tr/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Ter/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round(($Tr-$Ter)/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>&nbsp;</td>";
      $text.="</tr>\n";
      $text.="    </tfoot>\n";
      $text.="   </table>\n";
      $text.="  </td></tr>\n";
      $text.=" </table>\n";
      $text.="</div>   <!-- END of Team Totals -->\n";
    }

   ##### Display Players With Positional Games #####
   if ($position==0)
    {
      ## Get Years Played
      $query="SELECT player_id,COUNT(DISTINCT year) as yrs,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT position) as numPos FROM players_career_fielding_stats WHERE position>0 AND position<10 AND team_id=$tid GROUP BY player_id;";
      if ($_GET['showq']==1) {$text.="$query</br>\n";}
      $result=mysqli_query($db,$query);
      if (mysqli_num_rows($result))
       {
         while ($row=mysqli_fetch_array($result))
          {
	    $pid=$row['player_id'];
	    $players[$pid]['yrs']=$row['yrs'];
	    $players[$pid]['minYr']=$row['minYr'];
	    $players[$pid]['maxYr']=$row['maxYr'];
	    $players[$pid]['numPos']=$row['numPos'];
   	  }
       }
	    
      ## Get Games Played By Position
      $query="SELECT p.player_id,first_name,last_name,x.position,g FROM players as p,(SELECT player_id,position,SUM(g) as g FROM players_career_fielding_stats WHERE position>0 AND position<10 AND team_id=$tid GROUP BY player_id,position) as x WHERE p.player_id=x.player_id ORDER BY last_name,first_name,player_id,position;";
      if ($_GET['showq']==1) {$text.="$query</br>\n";}
      $result=mysqli_query($db,$query);
      if (mysqli_num_rows($result))
       {
         $text.="<div class='textbox'>\n";
	 $text.=" <table cellpadding=0 cellspacing=0 border=0 width='930px'>\n";
   	 $text.="  <tr class='title'><td style='padding:2px;'>Games Played By Position</td></tr>\n";
	 $text.="  <tr><td>\n";
   	 $text.="   <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='100%'>\n";
	 $text.="    <thead><tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2'>Years</td><td class='hsc2'>From</td><td class='hsc2'>To</td><td class='hsc2'># Pos</td><td class='hsc2'>P</td><td class='hsc2'>C</td><td class='hsc2'>1B</td><td class='hsc2'>2B</td><td class='hsc2'>3B</td><td class='hsc2'>SS</td><td class='hsc2'>LF</td><td class='hsc2'>CF</td><td class='hsc2'>RF</td></tr></thead>\n";

         $prevPid=-1;
	 $prevPos=0;
	 $cnt=0;
         while ($row=mysqli_fetch_array($result))
          {
	    $pid=$row['player_id'];
	    $pos=$row['position'];

	    if ($pid!=$prevPid)
	     {
	       $name=$row['first_name']." ".$row['last_name'];
	       $sortname=$row['last_name'].", ".$row['first_name'];
	       if ($prevPid==-1) {$text.="</tr>\n";}
	        else
	        {
 	          if ($prevPos!=9)
	           {
	             for ($i=$prevPos+1;$i<=9;$i++) {$text.="<td>&nbsp;</td>";}
		   }
		  $text.="</tr>\n";
	        }
	       $prevPos=0;
	       $cls='s'.($cnt%2+1);
	       $text.="    <tr class='$cls'><td class='".$cls."_l' sorttable_customkey=\"".$sortname."\"><a href='./player.php?player_id=$pid'>$name</a></td>";
	       $text.="<td>".$players[$pid]['yrs']."</td>";
	       $text.="<td>".$players[$pid]['minYr']."</td>";
	       $text.="<td>".$players[$pid]['maxYr']."</td>";
	       $text.="<td>".$players[$pid]['numPos']."</td>";
	       $cnt++;
	     }

	    if ($pos-$prevPos>1)
	     {
	       for ($i=$prevPos+1;$i<=($pos-1);$i++) {$text.="<td>&nbsp;</td>";}
	     }
	    $text.="<td>".$row['g']."</td>";
	    $prevPid=$pid;
	    $prevPos=$pos;
	  }
	 if ($prevPos!=9)
	  {
	    for ($i=$prevPos+1;$i<=9;$i++) {$text.="<td>&nbsp;</td>";}
	  }
	 $text.="</tr>\n";
	 $text.="    <tfoot><tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2'>Years</td><td class='hsc2'>From</td><td class='hsc2'>To</td><td class='hsc2'># Pos</td><td class='hsc2'>P</td><td class='hsc2'>C</td><td class='hsc2'>1B</td><td class='hsc2'>2B</td><td class='hsc2'>3B</td><td class='hsc2'>SS</td><td class='hsc2'>LF</td><td class='hsc2'>CF</td><td class='hsc2'>RF</td></tr></tfoot>\n";
	 $text.="   </table>\n";
	 $text.="  </td></tr>\n";
       	 $text.=" </table>\n";
       	 $text.="</div>\n";
       }

    }

   ##### Display Positional Registry #####
   if ($position!=0)
    {
      ## Get Players Used
      $query="SELECT team_id,COUNT(DISTINCT player_id) as players FROM players_career_fielding_stats WHERE team_id=$tid AND position=$position GROUP BY team_id;";
      if ($_GET['showq']==1) {$text.="$query</br>\n";}
      $result=mysqli_query($db,$query);
      if (mysqli_num_rows($result))
       {
         $row=mysqli_fetch_array($result);
	 $totPlayers=$row['players'];
       }

      $Tyr=0;
      $Tg=0;
      $Tpo=0;
      $Ta=0;
      $Tdp=0;
      $Ttp=0;
      $Ttc=0;
      $Te=0;
      $Tinn=0;
      ## Display Positional Totals
      $query="SELECT year,COUNT(DISTINCT player_id) as players,SUM(g) as g,SUM(gs) as gs,SUM(po) as po,SUM(a) as a,SUM(dp) as dp,SUM(tp) as tp,SUM(tc) as tc,SUM(e) as e,(SUM(ip)*3+SUM(ipf))/3 as inn,SUM(zr) as zr";
      if ($position==2) {$query.=",SUM(pb) as pb,SUM(sba) as sba,SUM(rto) as rto";}
      $query.=" FROM players_career_fielding_stats WHERE team_id=$tid AND position=$position GROUP BY year ORDER BY year;";
      if ($_GET['showq']==1) {$text.="$query</br>\n";}
      $result=mysqli_query($db,$query);
      if (mysqli_num_rows($result))
       {
         $text.="<div class='textbox'>\n";
	 $text.=" <table cellpadding=0 cellspacing=0 border=0 width='930px'>\n";
   	 $text.="  <tr class='title'><td style='padding:2px;'>".$posArray[$position]." Fielding Totals</td></tr>\n";
	 $text.="  <tr><td>\n";
   	 $text.="   <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='100%'>\n";
	 $text.="    <thead><tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2'>Players</td><td class='hsc2'>G</td><td class='hsc2'>GS</td><td class='hsc2'>PO</td><td class='hsc2'>A</td><td class='hsc2'>DP</td><td class='hsc2'>TP</td><td class='hsc2'>TC</td><td class='hsc2'>E</td><td class='hsc2'>Pct</td><td class='hsc2'>Inn</td><td class='hsc2'>Rng</td><td class='hsc2'>ZR</td>";
	 if ($position==2) {$text.="<td class='hsc2'>PB</td><td class='hsc2'>RSTA</td><td class='hsc2'>RTO</td><td class='hsc2'>RTO%</td>";}
	 $text.="</tr></thead>\n";
   	 $cnt=0;
	 while ($row=mysqli_fetch_array($result))
  	  {
            $yr=$row['year'];
	    $g=$row['g'];
   	    if (($yr==0)||($g==0)) {continue;}
	    $players=$row['players'];
	    $gs=$row['gs'];
	    $po=$row['po'];
   	    $a=$row['a'];
	    $dp=$row['dp'];
   	    $tp=$row['tp'];
	    $tc=$row['tc'];
   	    $e=$row['e'];
	    $inn=$row['inn'];
	    if ($position==2)
	     {
   	       $pb=$row['pb'];
   	       $sba=$row['sba'];
   	       $rto=$row['rto'];
	     }
	    $zr=$row['zr'];

	    $Tyr+=1;
   	    $Tplayers+=$players;
   	    $Tg+=$g;
   	    $Tgs+=$gs;
	    $Tpo+=$po;
   	    $Ta+=$a;
	    $Tdp+=$dp;
   	    $Ttp+=$tp;
	    $Ttc+=$tc;
   	    $Te+=$e;
	    $Tinn+=$inn;
	    $Tzr+=$zr;
	    if ($position==2)
	     {
   	       $Tpb+=$pb;
   	       $Tsba+=$sba;
   	       $Trto+=$rto;
	     }

            if ($tc==0) {$pct=0;}
  	     else {$pct=($po+$a)/$tc;}
	    $pct=sprintf("%.3f",$pct);
            if ($pct<1) {$pct=strstr($pct,".");}

	    if ($inn==0) {$rng=0;}
             else {$rng=9*($po+$a)/$inn;}
	    $rng=sprintf("%0.2f",$rng);

	    $zr=sprintf("%0.1f",$zr);

	    if ($position==2)
	     {
               if ($sba==0) {$csPct=0;}
	        else {$csPct=$rto/$sba;}
               $csPct=sprintf("%0.1f",100*$csPct);
	     }
	 
	    $cls='s'.($cnt%2+1);
   	    $text.="    <tr class='$cls'><td class='".$cls."_l'><a href='./team_summary.php?team_id=$tid&year=$yr'>$yr</a></td>";
	    $text.="<td>$players</td>";
	    $text.="<td>$g</td>";
	    $text.="<td>$gs</td>";
   	    $text.="<td>$po</td>";
	    $text.="<td>$a</td>";
   	    $text.="<td>$dp</td>";
	    $text.="<td>$tp</td>";
   	    $text.="<td>$tc</td>";
	    $text.="<td>$e</td>";
   	    $text.="<td>$pct</td>";
	    $text.="<td>".sprintf("%.1f",$inn)."</td>";
   	    $text.="<td>$rng</td>";
   	    $text.="<td>$zr</td>";
	    if ($position==2)
	     {
	       $text.="<td>$pb</td>";
	       $text.="<td>$sba</td>";
   	       $text.="<td>$rto</td>";
	       $text.="<td>$csPct</td>";
	     }
	    $text.="</tr>\n";

	    $cnt++;
   	  }

         ## Show Team Totals
         if ($Ttc==0) {$pct=0;}
          else {$pct=($Tpo+$Ta)/$Ttc;}
         $pct=sprintf("%.3f",$pct);
         if ($pct<1) {$pct=strstr($pct,".");}

         if ($Tinn==0) {$rng=0;}
          else {$rng=9*($Tpo+$Ta)/$Tinn;}
         $rng=sprintf("%0.2f",$rng);
	 
         $Tzr=sprintf("%0.2f",$Tzr);

	 if ($position==2)
	  {
  	    if ($Tsba==0) {$csPct=0;}
	     else {$csPct=$Trto/$Tsba;}
            $csPct=sprintf("%0.1f",100*$csPct);
	  }

	 $text.="    <tfoot>\n";
   	 $text.="     <tr class='headline'>";
	 if ($Tyr>0) {$text.="<td class='hsc2_l'>Total over $Tyr years</td>";}
   	  else {$text.="<td class='hsc2_l'>Total over $Tyr year</td>";}
	 $text.="<td class='hsc2'>$totPlayers</td>";
         $text.="<td class='hsc2'>$Tg</td>";
         $text.="<td class='hsc2'>$Tgs</td>";
   	 $text.="<td class='hsc2'>$Tpo</td>";
	 $text.="<td class='hsc2'>$Ta</td>";
   	 $text.="<td class='hsc2'>$Tdp</td>";
	 $text.="<td class='hsc2'>$Ttp</td>";
   	 $text.="<td class='hsc2'>$Ttc</td>";
	 $text.="<td class='hsc2'>$Te</td>";
   	 $text.="<td class='hsc2'>$pct</td>";
	 $text.="<td class='hsc2'>".sprintf("%.1f",$Tinn)."</td>";
   	 $text.="<td class='hsc2'>$rng</td>";
   	 $text.="<td class='hsc2'>$Tzr</td>";
	 if ($position==2)
	  {
     	    $text.="<td class='hsc2'>$Tpb</td>";
     	    $text.="<td class='hsc2'>$Tsba</td>";
	    $text.="<td class='hsc2'>$Trto</td>";
   	    $text.="<td class='hsc2'>$csPct</td>";
	  }
	 $text.="</tr>\n";
   	 $text.="     <tr class='headline'>";
	 $text.="<td class='hsc2_l'>Per season average</td>";
   	 $text.="<td class='hsc2'>".round($Tplayers/$Tyr,0)."</td>";
   	 $text.="<td class='hsc2'>".round($Tg/$Tyr,0)."</td>";
   	 $text.="<td class='hsc2'>".round($Tgs/$Tyr,0)."</td>";
	 $text.="<td class='hsc2'>".round($Tpo/$Tyr,0)."</td>";
   	 $text.="<td class='hsc2'>".round($Ta/$Tyr,0)."</td>";
	 $text.="<td class='hsc2'>".round($Tdp/$Tyr,0)."</td>";
   	 $text.="<td class='hsc2'>".round($Ttp/$Tyr,0)."</td>";
	 $text.="<td class='hsc2'>".round($Ttc/$Tyr,0)."</td>";
   	 $text.="<td class='hsc2'>".round($Te/$Tyr,0)."</td>";
	 $text.="<td class='hsc2'>&nbsp;</td>";
   	 $text.="<td class='hsc2'>".round($Tinn/$Tyr,1)."</td>";
	 $text.="<td class='hsc2'>&nbsp;</td>";
	 $text.="<td class='hsc2'>".round($Tzr/$Tyr,1)."</td>";
	 if ($position==2)
	  {
     	    $text.="<td class='hsc2'>".round($Tpb/$Tyr,0)."</td>";
     	    $text.="<td class='hsc2'>".round($Tsba/$Tyr,0)."</td>";
	    $text.="<td class='hsc2'>".round($Trto/$Tyr,0)."</td>";
   	    $text.="<td class='hsc2'>&nbsp;</td>";
	  }
	 $text.="</tr>\n";
   	 $text.="    </tfoot>\n";
	 $text.="   </table>\n";
   	 $text.="  </td></tr>\n";
	 $text.=" </table>\n";
   	 $text.="</div>   <!-- END of Team Totals -->\n";
       }

      ## Display Player Registry
      $query="SELECT p.player_id,first_name,last_name,bats,throws,yrs,minYr,maxYr,g,gs,po,a,dp,tp,tc,e,inn,zr";
      if ($position==2) {$query.=",pb,sba,rto";}
      $query.=" FROM players as p,(SELECT player_id,COUNT(DISTINCT year) as yrs,MIN(year) as minYr,MAX(year) as maxYr,SUM(g) as g,SUM(gs) as gs,SUM(po) as po,SUM(a) as a,SUM(dp) as dp,SUM(tp) as tp,SUM(tc) as tc,SUM(e) as e,(SUM(ip)*3+SUM(ipf))/3 as inn,SUM(zr) as zr";
      if ($position==2) {$query.=",SUM(pb) as pb,SUM(sba) as sba,SUM(rto) as rto";}
      $query.=" FROM players_career_fielding_stats WHERE team_id=$tid AND position=$position GROUP BY player_id) as x WHERE p.player_id=x.player_id ORDER BY last_name,first_name,inn DESC;";
      if ($_GET['showq']==1) {$text.="$query</br>\n";}
      $result=mysqli_query($db,$query);
      if (mysqli_num_rows($result))
       {
         $text.="<div class='textbox'>\n";
	 $text.=" <table cellpadding=0 cellspacing=0 border=0 width='930px'>\n";
   	 $text.="  <tr class='title'><td style='padding:2px;'>".$posArray[$position]." Fielding Register ($totPlayers players)</td></tr>\n";
	 $text.="  <tr><td>\n";
   	 $text.="   <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='100%'>\n";
	 $text.="    <thead><tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2' title='Bats'>B</td><td class='hsc2' title='Throws'>T</td><td class='hsc2'>Years</td><td class='hsc2'>From</td><td class='hsc2'>To</td><td class='hsc2'>G</td><td class='hsc2'>GS</td><td class='hsc2'>PO</td><td class='hsc2'>A</td><td class='hsc2'>DP</td><td class='hsc2'>TP</td><td class='hsc2'>TC</td><td class='hsc2'>E</td><td class='hsc2'>Pct</td><td class='hsc2'>Inn</td><td class='hsc2'>Rng</td><td class='hsc2'>ZR</td>";
	 if ($position==2) {$text.="<td class='hsc2'>PB</td><td class='hsc2'>RSTA</td><td class='hsc2'>RTO</td><td class='hsc2'>RTO%</td>";}
	 $text.="</tr></thead>\n";
   	 $cnt=0;
	 while ($row=mysqli_fetch_array($result))
  	  {
	    $pid=$row['player_id'];
	    $pos=$row['position'];
	    $name=$row['first_name']." ".$row['last_name'];
	    $sortname=$row['last_name'].", ".$row['first_name'];
      
	    $g=$row['g'];
	    $gs=$row['gs'];
	    $po=$row['po'];
   	    $a=$row['a'];
	    $dp=$row['dp'];
   	    $tp=$row['tp'];
	    $tc=$row['tc'];
   	    $e=$row['e'];
	    $inn=$row['inn'];
	    $zr=$row['zr'];
	    if ($position==2)
	     {
   	       $pb=$row['pb'];
   	       $sba=$row['sba'];
   	       $rto=$row['rto'];
	     }

            if ($tc==0) {$pct=0;}
  	     else {$pct=($po+$a)/$tc;}
	    $pct=sprintf("%.3f",$pct);
            if ($pct<1) {$pct=strstr($pct,".");}

	    if ($inn==0) {$rng=0;}
             else {$rng=9*($po+$a)/$inn;}
	    $rng=sprintf("%0.2f",$rng);

	    $zr=sprintf("%0.1f",$zr);

	    if ($position==2)
	     {
               if ($sba==0) {$csPct=0;}
	        else {$csPct=$rto/$sba;}
               $csPct=sprintf("%0.1f",100*$csPct);
	     }
	 
	    $cls='s'.($cnt%2+1);
	    $text.="    <tr class='$cls'><td class='".$cls."_l' sorttable_customkey=\"".$sortname."\"><a href='./player.php?player_id=$pid'>$name</a></td>";
	    $text.="<td>".get_hand($row['bats'])."</td>";
	    $text.="<td>".get_hand($row['throws'])."</td>";
	    $text.="<td>".$row['yrs']."</td>";
	    $text.="<td>".$row['minYr']."</td>";
	    $text.="<td>".$row['maxYr']."</td>";
	    $text.="<td>$g</td>";
	    $text.="<td>$gs</td>";
   	    $text.="<td>$po</td>";
	    $text.="<td>$a</td>";
   	    $text.="<td>$dp</td>";
	    $text.="<td>$tp</td>";
   	    $text.="<td>$tc</td>";
	    $text.="<td>$e</td>";
   	    $text.="<td>$pct</td>";
	    $text.="<td>".sprintf("%.1f",$inn)."</td>";
   	    $text.="<td>$rng</td>";
   	    $text.="<td>$zr</td>";
	    if ($position==2)
	     {
	       $text.="<td>$pb</td>";
	       $text.="<td>$sba</td>";
   	       $text.="<td>$rto</td>";
	       $text.="<td>$csPct</td>";
	     }
	    $text.="</tr>\n";

	    $cnt++;
   	  }
	 $text.="    <tfoot><tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2' title='Bats'>B</td><td class='hsc2' title='Throws'>T</td><td class='hsc2'>Years</td><td class='hsc2'>From</td><td class='hsc2'>To</td><td class='hsc2'>G</td><td class='hsc2'>GS</td><td class='hsc2'>PO</td><td class='hsc2'>A</td><td class='hsc2'>DP</td><td class='hsc2'>TP</td><td class='hsc2'>TC</td><td class='hsc2'>E</td><td class='hsc2'>Pct</td><td class='hsc2'>Inn</td><td class='hsc2'>Rng</td><td class='hsc2'>ZR</td>";
	 if ($position==2) {$text.="<td class='hsc2'>PB</td><td class='hsc2'>RSTA</td><td class='hsc2'>RTO</td><td class='hsc2'>RTO%</td>";}
	 $text.="</tr></tfoot>\n";
	 $text.="   </table>\n";
	 $text.="  </td></tr>\n";
       	 $text.=" </table>\n";
       	 $text.="</div>\n";
       }
    }

   mysqli_close($db);

   return $text;
 }

?>
