<?php
  include("html_functions.php");

  ################## PAGE INITIALIZATION #########################
  $lgid=$_SESSION['lgid'];
  $lgpath=$_SESSION['lgpath'];
  $date=new Date($_SESSION['lgdate']);
  $lgyear=$date->format("Y");

  if (($_SESSION['user_team_id']>0)&&(!isset($_GET['team_id'])))
  {
	  if ($_SESSION['user_league_id']==$lgid) {$team_id=$_SESSION['user_team_id'];}
	  else
	  {
		  include($_SESSION['adminpath']."/dbopen.php");
		  $query="SELECT team_id FROM teams WHERE parent_team_id=".$_SESSION['user_team_id']." AND league_id=$lgid";
		  $result=mysqli_query($db,$query);
		  if (mysqli_num_rows($result))
		  {
			  $row=mysqli_fetch_array($result);
			  $team_id=$row['team_id'];
		  }
		  mysqli_close($db);
	  }
  }
  elseif (isset($_GET['team_id'])) {$team_id=$_GET['team_id'];}
  if ($team_id=="") {$team_id=-1;}
  $page=$_GET['page'];
  if ($page=="") {$page='index';}
  $tyear=$_GET['year'];
  $pos=$_GET['pos'];
  if ($pos=="") {$pos=0;}
	  
  ##### Get Team Names #####
  include($_SESSION['adminpath']."/dbopen.php");
  $query="SELECT team_id,name,nickname FROM teams WHERE league_id=$lgid";
  if ($team_id>0) {$query.=" AND team_id=$team_id";}
  $query.=" AND allstar_team=0 ORDER BY name,nickname LIMIT 1;";
  $result=mysqli_query($db,$query);
  while ($row=mysqli_fetch_array($result))
  {
	  $team_id=$row['team_id'];
	  $tname=$row['name']." ".$row['nickname'];
  }
  mysqli_close($db);
  
  ##### Get Title #####
  $title=$tname." History - Batting Registry";
  page_head($title,$_SESSION['lgpath'],"","","./jquery/excanvas.js|./jquery/jquery.min.js|./jquery/jquery.jqplot.min.js|./jquery/plugins/jqplot.categoryAxisRenderer.min.js|./jquery/plugins/jqplot.pointLabels.min.js|./jquery/plugins/jqplot.barRenderer.min.js|./jquery/plugins/jqplot.highlighter.min.js|./jquery/plugins/jqplot.cursor.min.js");
  echo " <div id='topbar'>\n";
  main_titlebar($lgid,$_SESSION['lgpath'],$title,$team_id);
  nav_toolbar("history","History");
  nav_toolbar("teams","Teams","","",$team_id,$tyear);

  ##### Show Page Content #####
  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";

  ##### Check for file #####
  echo gen_bat($team_id);

  ################## END OF PAGE #########################
  echo " </div>   <!-- END contentpane DIV -->\n";
  page_foot($_SESSION['lgpath']);

  exit;


##############################################################################################
# gen_bat - Batter Registry
##############################################################################################
function gen_bat($tid="")
 {
   ##### Exit if no team_id #####
   if ($tid=="") {exit;}
   include($_SESSION['adminpath']."/dbopen.php");

   ##### Check for tables #####
   $query="SHOW TABLES LIKE 'team_history%';";
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result)<5) {return "Please load the team_history SQL tables first";}

   ##### Get basic parameters #####
   $lgdate=$_SESSION['lgdate'];
   $lgpath=$_SESSION['lgpath'];
   $lgid=$_GET['lgid'];
   if ($lgid=="") {$lgid=$_SESSION['lgid'];}
   if ($lgid=="") {$lgid=100;}
   $text="";
	
   ##### Get Team Totals #####
   $query="SELECT year,g,ab,h,d,t,hr,r,bb,hp,sf,k,sb,cs,pa FROM team_history_batting_stats WHERE team_id=$tid UNION SELECT year,g,ab,h,d,t,hr,r,bb,hp,sf,k,sb,cs,pa FROM team_batting_stats WHERE team_id=$tid ORDER BY year;";
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result)>0)
    {
      $text.="<div class='textbox'>\n";
      $text.=" <table cellpadding=0 cellspacing=0 border=0 width='930px'>\n";
      $text.="  <tr class='title'><td style='padding:2px;'>Team Batting Totals</td></tr>\n";
      $text.="  <tr><td>\n";
      $text.="   <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='100%'>\n";
      $text.="    <thead><tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2'>R/G</td><td class='hsc2'>R</td><td class='hsc2'>G</td><td class='hsc2'>AB</td><td class='hsc2'>H</td><td class='hsc2'>2B</td><td class='hsc2'>3B</td><td class='hsc2'>HR</td><td class='hsc2'>BB</td><td class='hsc2'>K</td><td class='hsc2'>SB</td><td class='hsc2'>CS</td><td class='hsc2'>AVG</td><td class='hsc2'>OBP</td><td class='hsc2'>SLG</td><td class='hsc2'>OPS</td></tr></thead>\n";
      $cnt=0;
      while ($row=mysqli_fetch_array($result))
       {
         $yr=$row['year'];
	 $r=$row['r'];
	 $g=$row['g'];
         if (($yr==0)||($g==0)) {continue;}
	 $ab=$row['ab'];
	 $h=$row['h'];
	 $d=$row['d'];
	 $t=$row['t'];
	 $hr=$row['hr'];
	 $bb=$row['bb'];
	 $hp=$row['hp'];
	 $sf=$row['sf'];
	 $k=$row['k'];
	 $sb=$row['sb'];
	 $cs=$row['cs'];
	 $pa=$row['pa'];

	 $Tyr+=1;
	 $Tr+=$r;
	 $Tg+=$g;
	 $Tab+=$ab;
	 $Th+=$h;
	 $Td+=$d;
	 $Tt+=$t;
	 $Thr+=$hr;
	 $Tbb+=$bb;
	 $Thp+=$hp;
	 $Tsf+=$sf;
	 $Tk+=$k;
	 $Tsb+=$sb;
	 $Tcs+=$cs;
	 $Tpa+=$pa;

	 if ($g==0) {$rpg=0;}
	  else {$rpg=$r/$g;}
	 $rpg=sprintf("%.1f",$rpg);

	 if ($ab==0) {$avg=0;$slg=0;}
          else
	  {
	    $avg=$h/$ab;
	    $slg=($h+$d+2*$t+3*$hr)/$ab;
	  }
	 if (($ab+$bb+$hp+$sf)==0) {$obp=0;}
	 else {$obp=($h+$bb+$hp)/($ab+$bb+$hp+$sf);}

 	 $ops=$obp+$slg;
         $avg=sprintf("%.3f",$avg);
	 $obp=sprintf("%.3f",$obp);
	 $slg=sprintf("%.3f",$slg);
	 $ops=sprintf("%.3f",$ops);
	 if ($avg<1) {$avg=strstr($avg,".");}
	 if ($obp<1) {$obp=strstr($obp,".");}
	 if ($slg<1) {$slg=strstr($slg,".");}
	 if ($ops<1) {$ops=strstr($ops,".");}

	 $cls='s'.($cnt%2+1);
	 $text.="    <tr class='$cls'><td class='".$cls."_l'><a href='./team_summary.php?team_id=$tid&year=$yr'>$yr</a></td>";
	 $text.="<td>$rpg</td>";
	 $text.="<td>$r</td>";
	 $text.="<td>$g</td>";
	 $text.="<td>$ab</td>";
	 $text.="<td>$h</td>";
	 $text.="<td>$d</td>";
	 $text.="<td>$t</td>";
	 $text.="<td>$hr</td>";
	 $text.="<td>$bb</td>";
	 $text.="<td>$k</td>";
	 $text.="<td>$sb</td>";
	 $text.="<td>$cs</td>";
	 $text.="<td>$avg</td>";
	 $text.="<td>$obp</td>";
	 $text.="<td>$slg</td>";
	 $text.="<td>$ops</td>";
	 $text.="</tr>\n";

	 $cnt++;
       }

      ## Show Team Totals
      if ($Tg==0) {$rpg=0;}
       else {$rpg=$Tr/$Tg;}
      $rpg=sprintf("%.1f",$rpg);

      if ($Tab==0) {$avg=0;$slg=0;}
       else
       {
	 $avg=$Th/$Tab;
	 $slg=($Th+$Td+2*$Tt+3*$Thr)/$Tab;
       }
      if (($Tab+$Tbb+$Thp+$Tsf)==0) {$obp=0;}
       else {$obp=($Th+$Tbb+$Thp)/($Tab+$Tbb+$Thp+$Tsf);}

      $ops=$obp+$slg;
      $avg=sprintf("%.3f",$avg);
      $obp=sprintf("%.3f",$obp);
      $slg=sprintf("%.3f",$slg);
      $ops=sprintf("%.3f",$ops);
      if ($avg<1) {$avg=strstr($avg,".");}
      if ($obp<1) {$obp=strstr($obp,".");}
      if ($slg<1) {$slg=strstr($slg,".");}
      if ($ops<1) {$ops=strstr($ops,".");}

      $text.="    <tfoot>\n";
      $text.="     <tr class='headline'>";
      if ($Tyr>0) {$text.="<td class='hsc2_l'>Total over $Tyr years</td>";}
       else {$text.="<td class='hsc2_l'>Total over $Tyr year</td>";}
      $text.="<td class='hsc2'>$rpg</td>";
      $text.="<td class='hsc2'>$Tr</td>";
      $text.="<td class='hsc2'>$Tg</td>";
      $text.="<td class='hsc2'>$Tab</td>";
      $text.="<td class='hsc2'>$Th</td>";
      $text.="<td class='hsc2'>$Td</td>";
      $text.="<td class='hsc2'>$Tt</td>";
      $text.="<td class='hsc2'>$Thr</td>";
      $text.="<td class='hsc2'>$Tbb</td>";
      $text.="<td class='hsc2'>$Tk</td>";
      $text.="<td class='hsc2'>$Tsb</td>";
      $text.="<td class='hsc2'>$Tcs</td>";
      $text.="<td class='hsc2'>$avg</td>";
      $text.="<td class='hsc2'>$obp</td>";
      $text.="<td class='hsc2'>$slg</td>";
      $text.="<td class='hsc2'>$ops</td>";
      $text.="</tr>\n";
      $text.="     <tr class='headline'>";
      $text.="<td class='hsc2_l'>Per season average</td>";
      $text.="<td class='hsc2'>&nbsp;</td>";
      $text.="<td class='hsc2'>".round($Tr/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tg/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tab/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Th/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Td/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tt/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Thr/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tbb/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tk/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tsb/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>".round($Tcs/$Tyr,0)."</td>";
      $text.="<td class='hsc2'>&nbsp;</td>";
      $text.="<td class='hsc2'>&nbsp;</td>";
      $text.="<td class='hsc2'>&nbsp;</td>";
      $text.="<td class='hsc2'>&nbsp;</td>";
      $text.="</tr>\n";
      $text.="    </tfoot>\n";
      $text.="   </table>\n";
      $text.="  </td></tr>\n";
      $text.=" </table>\n";
      $text.="</div>   <!-- END of Team Totals -->\n";
    }

   ##### Get Batter Register #####
   $query="SELECT p.player_id,p.first_name,p.last_name,bats,COUNT(year) AS yrs,MIN(year) as strt,MAX(year) as end,SUM(g) as g,SUM(gs) as gs,SUM(ab) as ab,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(rbi) as rbi,SUM(r) as r,SUM(bb) as bb,SUM(hp) as hp,SUM(sf) as sf,SUM(k) as k,SUM(sb) as sb,SUM(cs) as cs,SUM(pa) as pa,SUM(war) as war
  FROM players_career_batting_stats as pcb,players as p WHERE pcb.player_id=p.player_id AND pcb.team_id=$tid AND pcb.split_id=1 GROUP BY player_id ORDER BY last_name,first_name;";
   $result=mysqli_query($db,$query);
   if (mysqli_num_rows($result)>0)
    {
      $text.="<div class='textbox'>\n";
      $text.=" <table cellpadding=0 cellspacing=0 border=0 width='930px'>\n";
      $text.="  <tr class='title'><td style='padding:2px;'>Team Batting Register (".mysqli_num_rows($result)." players)</td></tr>\n";
      $text.="  <tr><td>\n";
      $text.="   <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='100%'>\n";
      $text.="    <thead><tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2' title='Bats'>B</td><td class='hsc2'>Years</td><td class='hsc2'>From</td><td class='hsc2'>To</td><td class='hsc2'>G</td><td class='hsc2'>GS</td><td class='hsc2'>AB</td><td class='hsc2'>R</td><td class='hsc2'>H</td><td class='hsc2'>2B</td><td class='hsc2'>3B</td><td class='hsc2'>HR</td><td class='hsc2'>RBI</td><td class='hsc2'>BB</td><td class='hsc2'>K</td><td class='hsc2'>SB</td><td class='hsc2'>CS</td><td class='hsc2'>AVG</td><td class='hsc2'>OBP</td><td class='hsc2'>SLG</td><td class='hsc2'>OPS</td><td class='hsc2'>WAR</td></tr></thead>\n";
      $cnt=0;
      while ($row=mysqli_fetch_array($result))
       {
         $pid=$row['player_id'];
         $from=$row['strt'];
	 $to=$row['end'];
	 $yrs=$row['yrs'];
	 $g=$row['g'];
	 $gs=$row['gs'];
	 $ab=$row['ab'];
	 $r=$row['r'];
	 $h=$row['h'];
	 $d=$row['d'];
	 $t=$row['t'];
	 $hr=$row['hr'];
	 $rbi=$row['rbi'];
	 $bb=$row['bb'];
	 $hp=$row['hp'];
	 $sf=$row['sf'];
	 $k=$row['k'];
	 $sb=$row['sb'];
	 $cs=$row['cs'];
	 $pa=$row['pa'];
	 $war=sprintf("%.1f",$row['war']);

	 if (($pa==0) && ($r==0) && ($sb==0) && ($cs==0)) {continue;}

	 if ($g==0) {$rpg=0;}
	  else {$rpg=$r/$g;}
	 $rpg=sprintf("%.1f",$rpg);

	 if ($ab==0) {$avg=0;$slg=0;}
          else
	  {
	    $avg=$h/$ab;
	    $slg=($h+$d+2*$t+3*$hr)/$ab;
	  }
	 if (($ab+$bb+$hp+$sf)==0) {$obp=0;}
	 else {$obp=($h+$bb+$hp)/($ab+$bb+$hp+$sf);}

 	 $ops=$obp+$slg;
         $avg=sprintf("%.3f",$avg);
	 $obp=sprintf("%.3f",$obp);
	 $slg=sprintf("%.3f",$slg);
	 $ops=sprintf("%.3f",$ops);
	 if ($avg<1) {$avg=strstr($avg,".");}
	 if ($obp<1) {$obp=strstr($obp,".");}
	 if ($slg<1) {$slg=strstr($slg,".");}
	 if ($ops<1) {$ops=strstr($ops,".");}

	 $cls='s'.($cnt%2+1);
	 $text.="    <tr class='$cls'><td class='".$cls."_l' sorttable_customkey=\"".$row['last_name'].", ".$row['first_name']."\"><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";
	 $text.="<td>".get_hand($row['bats'])."</td>";
	 $text.="<td>$yrs</td>";
	 $text.="<td>$from</td>";
	 $text.="<td>$to</td>";
	 $text.="<td>$g</td>";
	 $text.="<td>$gs</td>";
	 $text.="<td>$ab</td>";
	 $text.="<td>$r</td>";
	 $text.="<td>$h</td>";
	 $text.="<td>$d</td>";
	 $text.="<td>$t</td>";
	 $text.="<td>$hr</td>";
	 $text.="<td>$rbi</td>";
	 $text.="<td>$bb</td>";
	 $text.="<td>$k</td>";
	 $text.="<td>$sb</td>";
	 $text.="<td>$cs</td>";
	 $text.="<td>$avg</td>";
	 $text.="<td>$obp</td>";
	 $text.="<td>$slg</td>";
	 $text.="<td>$ops</td>";
	 $text.="<td>$war</td>";
	 $text.="</tr>\n";

	 $cnt++;
       }
      $text.="    <tfoot><tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2' title='Bats'>B</td><td class='hsc2'>Years</td><td class='hsc2'>From</td><td class='hsc2'>To</td><td class='hsc2'>G</td><td class='hsc2'>GS</td><td class='hsc2'>AB</td><td class='hsc2'>R</td><td class='hsc2'>H</td><td class='hsc2'>2B</td><td class='hsc2'>3B</td><td class='hsc2'>HR</td><td class='hsc2'>RBI</td><td class='hsc2'>BB</td><td class='hsc2'>K</td><td class='hsc2'>SB</td><td class='hsc2'>CS</td><td class='hsc2'>AVG</td><td class='hsc2'>OBP</td><td class='hsc2'>SLG</td><td class='hsc2'>OPS</td><td class='hsc2'>WAR</td></tr></tfoot>\n";
      $text.="   </table>\n";
      $text.="  </td></tr>\n";
      $text.=" </table>\n";
      $text.="</div>   <!-- END of Batter Registry -->\n";
    }   
 
   mysqli_close($db);
   
   return $text;
 }

?>
