<?php
  include("html_functions.php");

  ################## PAGE INITIALIZATION #########################
  $lgpath=$_SESSION['lgpath'];
  $lid=$_GET['league_id'];
  if ($lid!="") {$lgid=$lid;}
  if ($lgid=="") {$lgid=$_SESSION['lgid'];}
  if ($lgid=="") {$lgid=100;}
  $date=new Date($_SESSION['lgdate']);
  $lgyear=$_SESSION['lgyear'];

  ini_set("memory_limit","64M");
  
  ##### Get Settings #####
  $day=$_GET['fact'];
  if ($day=="") {$day=date('z',time());}
  $limit=$_GET['limit'];
  if ($limit=="") {$limit=25;}
  if ($limit>100) {$limit=100;}
  $showLink=$_GET['show'];

  # Title Bar
  $title="Stat of the Day";

  page_head($title,$_SESSION['lgpath']);
  echo " <div id='topbar'>\n";
  main_titlebar($lgid,$_SESSION['lgpath'],$title);
  nav_toolbar("season","Season");
  echo " </div>   <!-- END topbar DIV -->\n";
  echo " <div id='contentpane'>\n";
  
  ##### Initial Config #####
  $noResult="No matching results";
  $getTeams=0;
  $chkDay=$day%366;
  
  if ($_GET['showq']==1) {echo "$day :: $chkDay</br>\n";}

  ################## START OF PAGE CONTENT #########################
  include($_SESSION['adminpath']."/dbopen.php");

##### Queries #####
switch ($chkDay)
 {
   case 0:
     $title="Highest Three True Outcomes Per Plate Appearance (HR's, BB's, K's)";
     $title.="<br/>(Top $limit Players, Minimum 150 PA)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,team_abbr,year,pa,hr,bb,k,tto,(tto/pa) as pct FROM players as p,(SELECT player_id,team_id as team_abbr,year,SUM(pa) as pa,SUM(hr) as hr,SUM(bb) as bb,SUM(k) as k,(SUM(hr)+SUM(bb)+SUM(k)) as tto FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND (hr>0 OR bb>0 OR k>0) GROUP BY player_id,year HAVING SUM(pa)>150) as pcs WHERE p.player_id=pcs.player_id ORDER BY pct DESC,tto DESC LIMIT $limit";
     $cols="Player|Team|Year|PA|HR|BB|K|TTO|TTO%";
     $noResult="No player has recorded a HR, BB, or K";
     $getTeams=1;
     break;
   case 1:
   case 14:
   case 58:
   case 66:
   case 80:
   case 106:
   case 146:
   case 173:
   case 189:
   case 207:
   case 217:
   case 284:
     switch ($chkDay)
       {
         case 1:
           $title="Most Strikeouts Without Allowing A Walk";
	   $cols="Player|Team|Year|IP|K";
	   $noResult="No players have recorded a strikeout without allowing a walk";
	   $table='pitching';
	   $statMost='k';
	   $statNone='bb';
	   break;
	 case 14:
           $title="Most Innings Pitched Without Allowing a Stolen Base";
	   $cols="Player|Team|Year|IP|CS";
	   $noResult="No players have pitched without allowing a stolen base";
	   $table='pitching';
	   $statMost='ip';
	   $statNone='sb';
	   $statCntr='cs';
	   break;
	 case 58:
           $title="Most Innings Pitched Without Starting a Game";
	   $cols="Player|Team|Year|IP|G";
	   $noResult="No players have pitched exclusively in relief";
	   $table='pitching';
	   $statMost='ip';
	   $statNone='gs';
	   $statCntr='g';
	   break;
	 case 66:
           $title="Most Wins Without Starting a Game";
	   $cols="Player|Team|Year|IP|W";
	   $noResult="No players have won exclusively in relief";
	   $table='pitching';
	   $statMost='w';
	   $statNone='gs';
	   break;
         case 80:
           $title="Most Intentional Walks Without a Home Run";
	   $cols="Player|Team|Year|PA|IBB";
	   $noResult="No players have been walked intentionally without hitting a home run";
	   $table='batting';
	   $statMost='ibb';
	   $statNone='hr';
	   break;
         case 106:
           $title="Most Earned Runs Without Allowing An Unearned Run";
	   $cols="Player|Team|Year|IP|ER";
	   $noResult="No players have failed to allow an undearned run";
	   $table='pitching';
	   $statMost='er';
	   $statNone='uer';
	   break;
         case 146:
           $title="Most Runs Batted In Without Scoring A Run";
	   $cols="Player|Team|Year|PA|RBI";
	   $noResult="No players have failed to score a run while driving one in";
	   $table='batting';
	   $statMost='rbi';
	   $statNone='r';
	   $excP=1;
	   break;
         case 173:
           $title="Most Plate Appearances Without Hitting A Triple Or A Home Run";
	   $cols="Player|Team|Year|PA|H";
	   $noResult="No players have failed to hit either a triple or a home run";
	   $table='batting';
	   $statMost='pa';
	   $statNone='hrt';
	   $statCntr='h';
	   break;
         case 189:
           $title="Most Plate Appearances Without A Home Run";
	   $cols="Player|Team|Year|PA|H";
	   $noResult="No players have failed to hit a home run";
	   $table='batting';
	   $statMost='pa';
	   $statNone='hr';
	   $statCntr='h';
	   break;
         case 207:
           $title="Most Plate Appearances Without A Walk";
	   $cols="Player|Team|Year|PA|H";
	   $noResult="No players have failed to record a walk";
	   $table='batting';
	   $statMost='pa';
	   $statNone='bb';
	   $statCntr='h';
	   break;
         case 217:
           $title="Most Home Runs Without An Intentional Walk";
	   $cols="Player|Team|Year|PA|HR";
	   $noResult="No players have failed to record an intentional walk while also hitting a home run";
	   $table='batting';
	   $statMost='hr';
	   $statNone='ibb';
	   break;
         case 284:
           $title="Most Stolen Bases Without Being Caught";
	   $cols="Player|Team|Year|PA|SB";
	   $noResult="No players have stolen a base without being caught";
	   $table='batting';
	   $statMost='sb';
	   $statNone='cs';
	   break;
       }
     $title.="<br/>(Top $limit Players";
     if ($excP==1) {$title.=", Pitchers Excluded";}
     $title.=")";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,team_abbr,year";
     if ($table=='pitching') {$query.=",ip";}
      elseif ($table=='batting') {$query.=",pa";}
     if (($statMost!='ip')&&($statMost!='pa')) {$query.=",$statMost";}
     if ($statCntr!="") {$query.=",$statCntr";}
     $query.=" FROM players as p,(SELECT player_id,team_id as team_abbr,year,";
     if ($table=='pitching') {$query.="(SUM(ip)+SUM(ipf)/3) as ip";}
      elseif ($table=='batting') {$query.="SUM(pa) as pa";}
     if (($statMost!='ip')&&($statMost!='pa')) {$query.=",SUM($statMost) as $statMost";}
     if ($statCntr!="") {$query.=",SUM($statCntr) as $statCntr";}
     if ($statNone=='uer') {$query.=",SUM(r)-SUM(er) as uer";}
     elseif ($statNone=='gsf') {$query.=",SUM(g)-SUM(gs)+SUM(gf) as uer";}
     elseif ($statNone=='hrt') {$query.=",SUM(t)+SUM(hr) as hrt";}
      else {$query.=",SUM($statNone) as $statNone";}
     $query.=" FROM players_career_".$table."_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING";
     if (($statMost!='ip')&&($statMost!='pa')) {$query.=" SUM($statMost)>0 AND";}
     if ($statNone=='uer') {$query.=" SUM(r)-SUM(er)=0";}
     elseif ($statNone=='gsf') {$query.=" SUM(g)-SUM(gs)-SUM(gf)=0";}
     elseif ($statNone=='hrt') {$query.=" SUM(t)+SUM(hr)=0";}
      else {$query.=" SUM($statNone)=0";}
     $query.=" ORDER BY ";
     if (($statMost!='ip')&&($statMost!='pa')) {$query.="$statMost DESC,";}
     if ($table=='pitching') {$query.="ip";}
      elseif ($table=='batting') {$query.="pa";}
     $query.=" DESC) as pcs WHERE p.player_id=pcs.player_id";
     if ($excP==1) {$query.=" AND position!=1";}
     $query.=" ORDER BY ";
     if (($statMost!='ip')&&($statMost!='pa')) {$query.="$statMost DESC,";}
     if ($table=='pitching') {$query.="ip";}
      elseif ($table=='batting') {$query.="pa";}
     $query.=" DESC";
     $query.=" LIMIT $limit";
     $getTeams=1;
     break;
   case 2:
     $query="SELECT player_id,year,team_id,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY hr DESC LIMIT 5,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $hr=$row['hr'];
     $hr=floor($hr/10)*5+5;
     $title="Fewest Career Seasons Among Players Who've Hit $hr Home Runs In A Season";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,minYr,maxYr,yrs FROM players as p,(SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT year) as yrs FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN (SELECT DISTINCT player_id FROM (SELECT player_id,year,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND year!=$lgyear GROUP BY player_id,year HAVING SUM(hr)>=$hr ORDER BY hr DESC,year) as t1) GROUP BY player_id ORDER BY yrs,minYr,maxYr LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY yrs,minYr,maxYr";
     $cols="Player|First Year|Last Year|Seasons Played";
     $noResult="No seasons completed";
     break;
   case 3:
   case 61:
   case 118:
   case 163:
   case 186:
   case 244:
   case 266:
   case 288:
   case 310:
   case 322:
   case 331:
     switch ($chkDay)
      {
        case 3:
	  $mode='season';
          $statMore='hr';
	  $statThan='k';
          $title="More Home Runs Than Strikeouts";
          $noResult="No player has had more home runs than strikeouts in a $mode";
	  break;
        case 61:
	  $mode='career';
          $statMore='hr';
	  $statThan='k';
          $title="More Home Runs Than Strikeouts";
          $noResult="No player has had more home runs than strikeouts in a $mode";
	  break;
        case 118:
	  $mode='season';
          $statMore='t';
	  $statThan='sb';
          $title="More Triples Than Stolen Bases";
	  $noResult="No player has had more triples than stolen bases in a $mode";
	  break;
        case 163:
	  $mode='career';
          $statMore='bb';
	  $statThan='h';
          $title="More Walks Than Hits";
          $noResult="No player has had more walks than hits in a $mode";
	  break;
        case 186:
	  $mode='career';
          $statMore='t';
	  $statThan='hr';
          $title="More Triples Than Home Runs";
          $noResult="No player has had more triples than home runs in a $mode";
	  break;
        case 244:
	  $mode='season';
          $statMore='t';
	  $statThan='d';
          $title="More Triples Than Doubles";
	  $noResult="No player has had more triples than doubles in a $mode";
	  break;
        case 266:
	  $mode='career';
          $statMore='hr';
	  $statThan='1b';
          $title="More Home Runs Than Singles";
          $noResult="No player has had more home runs than singles in a $mode";
	  break;
        case 288:
	  $mode='season';
          $statMore='sfsh';
	  $statThan='h';
          $title="More Sacrifices Than Hits";
          $noResult="No player has had more sacrifices than hits in a $mode";
	  break;
        case 310:
	  $mode='season';
          $statMore='cs';
	  $statThan='sb';
          $title="More Caught Stealing Than Stolen Bases";
          $noResult="No player has been caught more times than he was successful stealing in a $mode";
	  break;
        case 322:
	  $mode='career';
          $statMore='rbi';
	  $statThan='h';
          $title="More RBI Than Hits";
          $noResult="No player has had more RBI than hits in a $mode";
	  break;
        case 331:
	  $mode='season';
          $statMore='bb';
	  $statThan='h';
          $title="More Walks Than Hits";
          $noResult="No player has had more Walks than hits in a $mode";
	  break;
      }
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame";
     if ($mode=='season') {$query.=",pcs.team_id as team_abbr,year";} else {$query.=",years";}
     $query.=",pa,$statMore,$statThan,diff FROM players as p,(SELECT player_id,team_id";
     if ($mode=='season') {$query.=",year";} else {$query.=",CONCAT(MIN(year),'-',MAX(year)) as years";}
     $query.=",SUM(pa) as pa,";
     switch ($statMore)
      {
        case 'sfsh':
	  $query.="SUM(sf)+SUM(sh) as $statMore";
	  break;
        default:
	  $query.="SUM($statMore) as $statMore";
	  break;
      }
     switch ($statThan)
      {
        case '1b':
	  $query.=",SUM(h)-SUM(d)-SUM(t)-SUM(hr) as $statThan";
	  break;
        default:
	  $query.=",SUM($statThan) as $statThan";
	  break;
      }
     switch ($statMore)
      {
        case 'sfsh':
	  $query.=",(SUM(sf)+SUM(sh)";
	  break;
        default:
	  $query.=",(SUM($statMore)";
	  break;
      }
     switch ($statThan)
      {
        case '1b':
	  $query.="-(SUM(h)-SUM(d)-SUM(t)-SUM(hr))) as diff";
	  break;
        default:
	  $query.="-SUM($statThan)) as diff";
	  break;
      }
     $query.=" FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id";
     if ($mode=='season') {$query.=",year";}
     switch ($statMore)
      {
        case 'sfsh':
	  $query.=" HAVING (SUM(sf)+SUM(sh)";
	  break;
        default:
	  $query.=" HAVING (SUM($statMore)";
	  break;
      }
     switch ($statThan)
      {
        case '1b':
          $query.="-(SUM(h)-SUM(d)-SUM(t)-SUM(hr)))>0";
	  break;
        default:
          $query.="-SUM($statThan))>0";
	  break;
      }
     $query.=" ORDER BY diff DESC,$statMore DESC,pa DESC LIMIT $limit) as pcs WHERE p.player_id=pcs.player_id ORDER BY diff DESC,$statMore DESC,pa DESC;";
     $cols="Player";
     if ($mode=='season') {$cols.="|Team|Year";} else {$cols.="|Years";}
     if ($statMore=='t') {$statMore='3b';}
      elseif  ($statMore=='sfsh') {$statMore='SF+SH';}
     $cols.="|PA|".strtoupper($statMore)."|".strtoupper($statThan)."|Diff";
     $getTeams=1;
     break;
   case 4:
     $title="Most Unearned Runs Allowed";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,ip,r,er,diff,era,whip FROM players as p,(SELECT player_id,team_id,year,(SUM(ip)+SUM(ipf)/3) as ip,SUM(r) as r,SUM(er) as er,SUM(r)-SUM(er) as diff,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era,9*SUM(r)/(SUM(ip)+SUM(ipf)/3) as whip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY diff DESC,r DESC LIMIT $limit) as pcs WHERE p.player_id=pcs.player_id ORDER BY diff DESC,r DESC;";
     $cols="Player|Team|Year|IP|R|ER|UER|ERA|RAA";
     $noResult="No seasons completed";
     $getTeams=1;
     break;
   case 5:
     $title="Most Runner-up Finishes Within 10 Games Of First";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
        $title.="<br/>(Individual Team Listing)";
        $query="SELECT team_id as team_name,year,w,l,pct as avg,gb,pos as stanPos FROM team_history_record WHERE league_id=$lgid AND team_id=$tid AND pos!=1 AND gb<=10 ORDER BY year;";
        $cols="Team|Year|W|L|Pct|GB|Finish";
        $getTeams=1;
      }
      else
      {
        $query="SELECT team_id as team_name,'Show Seasons' as showLink,COUNT(year) as cnt FROM team_history_record WHERE league_id=$lgid AND pos!=1 AND gb<=10 GROUP BY team_id ORDER BY cnt DESC;";
        $cols="Team|Link|Number of Finishes";
        $noResult="No team has finished within 10 games of first, but not won";
        $getTeams=1;
      }
     break;
   case 6:
     $title="Most Innings Pitched Without Appearing in the Postseason";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,ip FROM players as p,(SELECT player_id,ip FROM (SELECT player_id,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as t1 WHERE NOT EXISTS (SELECT * FROM (SELECT DISTINCT player_id FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=21) as t2 WHERE t1.player_id=t2.player_id) ORDER BY ip DESC LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY ip DESC";
     $cols="Player|IP";
     $noResult="All players have reached the postseason";
     break;
   case 7:
   case 67:
   case 91:
   case 234:
   case 316:
   case 324:
     switch ($chkDay)
      {
	case 7:
     	  $statLbl='bb';
          $query="SELECT player_id,year,SUM($statLbl) as statVal FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY statVal DESC LIMIT 25,1;";
	  $result=mysqli_query($db,$query);
     	  $row=mysqli_fetch_array($result);
	  $statVal=$row['statVal'];
     	  $statVal=floor(3*$statVal/40)*10;
	  $statVal=min($statVal,100);
	  break;
	case 67:
     	  $statLbl='r';
          $query="SELECT player_id,year,SUM($statLbl) as statVal FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY statVal DESC LIMIT 25,1;";
	  $result=mysqli_query($db,$query);
     	  $row=mysqli_fetch_array($result);
	  $statVal=$row['statVal'];
     	  $statVal=floor(3*$statVal/40)*10;
	  $statVal=min($statVal,100);
	  break;
	case 91:
     	  $statLbl='rbi';
          $query="SELECT player_id,year,SUM($statLbl) as statVal FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY statVal DESC LIMIT 25,1;";
	  $result=mysqli_query($db,$query);
     	  $row=mysqli_fetch_array($result);
	  $statVal=$row['statVal'];
     	  $statVal=floor(3*$statVal/40)*10;
	  $statVal=min($statVal,100);
	  break;
	case 234:
     	  $statLbl='sb';
          $query="SELECT player_id,year,SUM($statLbl) as statVal FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY statVal DESC LIMIT 25,1;";
	  $result=mysqli_query($db,$query);
     	  $row=mysqli_fetch_array($result);
	  $statVal=$row['statVal'];
     	  $statVal=floor($statVal/20)*5;
	  $statVal=max($statVal,5);
	  $statVal=min($statVal,30);
	  break;
	case 316:
     	  $statLbl='hr';
          $query="SELECT player_id,year,SUM($statLbl) as statVal FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY statVal DESC LIMIT 25,1;";
	  $result=mysqli_query($db,$query);
     	  $row=mysqli_fetch_array($result);
	  $statVal=$row['statVal'];
     	  $statVal=floor($statVal/10)*5;
	  $statVal=max($statVal,5);
	  $statVal=min($statVal,20);
	  break;
	case 324:
     	  $statLbl='h';
          $query="SELECT player_id,year,SUM($statLbl) as statVal FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY statVal DESC LIMIT 25,1;";
	  $result=mysqli_query($db,$query);
     	  $row=mysqli_fetch_array($result);
	  $statVal=$row['statVal'];
     	  $statVal=floor($statVal/50)*50;
	  $statVal=max($statVal,50);
	  $statVal=min($statVal,200);
	  break;
      }
     $title="Most Consecutive $statVal ".strtoupper($statLbl)." Seasons";
     $title.="<br/>(Top $limit Players)";
     $query="SET @yrCnt:=0;SET @player_id:=0;SET @year:=0;SET @strk:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,x.year-yrs+1 as strt,x.year,yrs FROM players as p,(SELECT player_id,MAX(yrCnt) as yrs,MAX(year) as year FROM (SELECT if(@player_id!=player_id,@yrCnt:=1,if(@year=year-1,@yrCnt:=@yrCnt+1,@yrCnt:=1)) as yrCnt,if(@player_id!=player_id,@strk:=1,if(@year=year-1,@strk,@strk:=@strk+1)) as strk,@player_id:=player_id as player_id,@year:=year as year,$statLbl FROM (SELECT player_id,year,SUM($statLbl) as $statLbl FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM($statLbl)>=$statVal ORDER BY player_id,year) as t1) as a GROUP BY player_id,strk) as x WHERE p.player_id=x.player_id ORDER BY yrs DESC,strt,last_name,first_name LIMIT $limit";
     $cols="Player|From|To|Seasons";
     $noResult="No players have had consecutive $statVal ".strtoupper($statLbl)." seasons";
     break;
   case 8:
     $title="Most Plate Appearances With A 1.000 OBP";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,h,bb,hp,sf,sh,pa FROM players as p,(SELECT player_id,team_id,year,SUM(h) as h,SUM(bb) as bb,SUM(hp) as hp,SUM(sf) as sf,SUM(sh) as sh,SUM(pa) as pa,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))) as obp FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY obp DESC,pa DESC,h DESC,bb DESC LIMIT $limit) as pcs WHERE p.player_id=pcs.player_id AND obp=1 ORDER BY pa DESC,h DESC,bb DESC";
     $cols="Player|Team|Year|H|BB|HP|SF|SH|PA";
     $noResult="No players with a 1.000 OBP";
     $getTeams=1;
     break;
   case 9:
     $title="Lowest Net Stolen Bases By Team";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT t1.team_id as team_name,t1.year,sb,sba,(sb-sba) as diff FROM (SELECT team_id,year,sb FROM team_history_batting_stats WHERE league_id=$lgid) as t1,(SELECT team_id,year,(sba-rto) as sba FROM team_history_fielding_stats_stats WHERE league_id=$lgid AND sba>0) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY diff LIMIT $limit";
     $cols="Team|Year|SB|SBA|Diff";
     $noResult="No historical team stolen base data found";
     $getTeams=1;
     break;
   case 10:
   case 64:
     switch ($chkDay)
      {
        case 10:
          $title="Home Run Title Winners in Descending Order of HR's";
	  $cols="Year|League|Player|HR";
	  $cat=8;
	  $statMost='hr';
	  break;
        case 64:
          $title="Batting Title Winners in Descending Order of AVG";
	  $cols="Year|League|Player|AVG";
	  $cat=18;
	  $statMost='avg';
	  break;
      }
     $title.="<br/>(Top $limit Players)";
     $query="SELECT year,sub_league_id as sl_name,p.player_id,first_name,last_name,hall_of_fame,amount as $statMost FROM players as p,players_league_leader as pll WHERE p.player_id=pll.player_id AND pll.league_id=$lgid AND place=1 AND category=$cat ORDER BY amount DESC,year";
     $noResult="No league leading stats found";
     $getSubLeagues=1;
     break;
   case 11:
     $title="Largest Drop In Wins With No Significant Drop In Innings";
     $title.="<br/>(Top $limit Players, Min 80% IP in 2nd season)";
     $query="SET @player_id:=0;SET @year:=0;SET @w:=0;SET @ip:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,year-1,w+wDrop,year,w,wDrop FROM players as p,(SELECT if(@player_id=player_id,if(@year:=year-1,if(ip>=0.8*@ip,@w-w,0),0),0) as wDrop,@player_id:=player_id as player_id,@year:=year as year,@w:=w as w,@ip:=ip as ip FROM (SELECT player_id,year,SUM(w) as w,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND year!=$lgyear GROUP BY player_id,year ORDER BY player_id,year) as t1 ORDER BY wDrop DESC,year LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY wDrop DESC,year";
     $cols="Player|Year|W|Year|W|Drop";
     $noResult="No players have played consecutive seasons while maintaining 80% of IP";
     break;
   case 12:
     $title="Highest Career Games Started/Games Finished Combinations";
     $title.="<br/>(Top $limit Players, Sorted by Lower of GS, GF)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,w,l,s,g,gs,gf,ip,era FROM players as p,(SELECT player_id,SUM(w) as w,SUM(l) as l,SUM(s) as s,SUM(g) as g,SUM(gs) as gs,SUM(gf) as gf,SUM(ip)+SUM(ipf)/3 as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era,if(SUM(gs)>SUM(gf),SUM(gf),SUM(gs)) as hide FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id ORDER BY hide DESC,w DESC,era LIMIT $limit) as pcs WHERE p.player_id=pcs.player_id ORDER BY hide DESC,w DESC,era;";
     $cols="Player|W|L|SV|G|GS|GF|IP|ERA";
     $noResult="No players have both started and finished games";
     break;
   case 13:
     $query="SELECT player_id,team_id,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,team_id ORDER BY hr DESC LIMIT 5,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $hr=$row['hr'];
     $hr=floor($hr/100)*50;
     $hr=max($hr,25);
     $hr=min($hr,200);
     $title="Most $hr Home Run Hitters By Franchise";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
        $title.="<br/>(Individual Team Listing)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,minYr,maxYr,hr FROM players as p,(SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND team_id=$tid AND split_id=1 GROUP BY player_id,team_id HAVING SUM(hr)>=$hr) as pcs WHERE p.player_id=pcs.player_id ORDER BY hr DESC,minYr;";
        $cols="Player|From|To|HR";
      }
      else
      {
	$query="SELECT team_id as team_name,'Show Players' as showLink,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,team_id,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,team_id HAVING SUM(hr)>=$hr) as t1 GROUP BY team_id ORDER BY cnt DESC;";
   	$cols="Team|Link|Number of Players";
	$noResult="No teams have had a $hr HR hitter";
        $getTeams=1;
      }
     break;
   ## case 14: Filed under case 1
   case 15:
     $title="Most Different Positions Played In A Single Season";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,positions FROM players as p,(SELECT player_id,year,COUNT(DISTINCT position) as positions FROM (SELECT player_id,team_id,year,position,(ip+ipf/3) as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1) as t WHERE ip>0 GROUP BY player_id,year ORDER BY positions DESC LIMIT $limit) as t2 WHERE p.player_id=t2.player_id ORDER BY positions DESC";
     $cols="Player|Year|Positions Played";
     $noResult="No players have played multiple positions in the same year";
     break;
   case 16:
     $awquery="SELECT mvp_award_name,pitcher_award_name FROM leagues WHERE league_id=$lgid;";
     $awresult=mysqli_query($db,$awquery);
     $row=mysqli_fetch_array($awresult);
     $awName1=$row['mvp_award_name'];
     $awName2=$row['pitcher_award_name'];
     $title="Oldest Players To Win The $awName1 or $awName2";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,last_name,hall_of_fame,first_name,paw.team_id as team_abbr,year,if(award_id=4,'$awName2','$awName1') as award,date_of_birth,(paw.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,DAYOFYEAR(date_of_birth) as dayBorn FROM players as p,((SELECT best_pitcher_id as player_id,season as year,pa.sub_league_id,award_id,team_id FROM league_history as lh,players_awards as pa WHERE lh.league_id=$lgid AND award_id=4 AND best_pitcher_id=player_id AND lh.year=pa.season) UNION (SELECT best_hitter_id as player_id,season as year,pa.sub_league_id,award_id,team_id FROM league_history as lh,players_awards as pa WHERE lh.league_id=$lgid AND award_id=5 AND best_hitter_id=player_id AND lh.year=pa.season)) as paw WHERE p.player_id=paw.player_id ORDER BY age DESC,dayBorn,year,last_name,first_name LIMIT $limit;";
     $cols="Player|Team|Year|Award|DOB|Age";
     $noResult="No players have won these awards";
     $getTeams=1;
     break;
   case 17:
   case 97:
   case 144:
   case 209:
   case 221:
     switch ($chkDay)
      {
        case 17:
	  $title="More Complete Games Than Wins";
	  $noResult="No player has had more complete games than wins over the course of a season";
	  break;
        case 97:
	  $title="As Many Shutouts As Losses";
	  $noResult="No player has had as many shutouts as losses over the course of a season";
	  break;
        case 144:
	  $title="More Walks Than Strikeouts";
	  $noResult="No player has had more walks than strikeouts over the course of a season";
	  break;
        case 209:
	  $title="More Wins Than Walks";
	  $noResult="No player has had more wins than walks over the course of a season";
	  break;
        case 221:
	  $title="More Strikeouts Than Hits Allowed";
	  $noResult="No player has had more strikeouts than hits allowed over the course of a season";
	  break;
      }
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,w,l,ip,ha,bb,k,cg,sho,diff FROM players as p,(SELECT player_id,team_id,year,SUM(ip)+SUM(ipf)/3 as ip,SUM(w) as w,SUM(l) as l,SUM(cg) as cg,SUM(sho) as sho,SUM(bb) as bb,SUM(k) as k,SUM(ha) as ha";
     switch ($chkDay)
      {
        case 17 : $query.=",(SUM(cg)-SUM(w)) as diff"; break;
        case 97 : $query.=",(SUM(sho)-SUM(l)) as diff"; break;
        case 144: $query.=",(SUM(bb)-SUM(k)) as diff"; break;
        case 209: $query.=",(SUM(w)-SUM(bb)) as diff"; break;
        case 221: $query.=",(SUM(k)-SUM(ha)) as diff"; break;
      }
     $query.=" FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year";
     switch ($chkDay)
      {
        case 17 : $query.=" HAVING (SUM(cg)-SUM(w))>0 ORDER BY diff DESC,cg DESC,w DESC"; break;
        case 97 : $query.=" HAVING SUM(sho)>=SUM(l) AND SUM(sho)>0 ORDER BY diff DESC,sho DESC,l DESC"; break;
        case 144: $query.=" HAVING (SUM(bb)-SUM(k))>0 ORDER BY diff DESC,bb DESC,k DESC"; break;
        case 209: $query.=" HAVING (SUM(w)-SUM(bb))>0 ORDER BY diff DESC,w DESC,bb DESC"; break;
        case 221: $query.=" HAVING (SUM(k)-SUM(ha))>0 ORDER BY diff DESC,k DESC,ha DESC"; break;
      }
     $query.=" LIMIT $limit) as pcs WHERE p.player_id=pcs.player_id";
     switch ($chkDay)
      {
        case 17 : $query.=" ORDER BY diff DESC,cg DESC,w DESC"; break;
        case 97 : $query.=" ORDER BY diff DESC,sho DESC,l DESC"; break;
        case 144: $query.=" ORDER BY diff DESC,bb DESC,k DESC"; break;
        case 209: $query.=" ORDER BY diff DESC,w DESC,bb DESC"; break;
        case 221: $query.=" ORDER BY diff DESC,k DESC,ha DESC"; break;
      }
     $cols="Player|Team|Year|W|L|IP|H|BB|K|CG|SHO|Diff";
     $getTeams=1;
     break;
   case 18:
   case 60:
   case 98:
   case 143:
   case 185:
   case 224:
   case 265:
   case 311:
   case 329:
     switch ($chkDay)
       {
         case 18:
           $title="Most Hits by Age";
	   $cols="Age|Player|Team|H|Year";
	   $table='batting';
	   $noResult="No hits recorded";
	   $statMost='h';
	   break;
	 case 60:
           $title="Most Stolen Bases by Age";
	   $cols="Age|Player|Team|SB|Year";
	   $table='batting';
	   $noResult="No Stolen Bases recorded";
	   $statMost='sb';
	   break;
         case 98:
           $title="Most Saves by Age";
	   $cols="Age|Player|Team|SV|Year";
	   $table='pitching';
	   $noResult="No saves recorded";
	   $statMost='s';
	   break;
         case 143:
           $title="Most Runs Batted In by Age";
	   $cols="Age|Player|Team|RBI|Year";
	   $table='batting';
	   $noResult="No RBI recorded";
	   $statMost='rbi';
	   break;
         case 185:
           $title="Most Walks by Age";
	   $cols="Age|Player|Team|BB|Year";
	   $table='batting';
	   $noResult="No walks recorded";
	   $statMost='bb';
	   break;
         case 224:
           $title="Most Home Runs by Age";
	   $cols="Age|Player|Team|HR|Year";
	   $table='batting';
	   $noResult="No home runs recorded";
	   $statMost='hr';
	   break;
         case 265:
           $title="Most Runs by Age";
	   $cols="Age|Player|Team|R|Year";
	   $table='batting';
	   $noResult="No runs recorded";
	   $statMost='r';
	   break;
         case 311:
           $title="Most Strikeouts by Age";
	   $cols="Age|Player|Team|K|Year";
	   $table='pitching';
	   $noResult="No strikeouts recorded";
	   $statMost='k';
	   break;
         case 329:
           $title="Most Wins by Age";
	   $cols="Age|Player|Team|W|Year";
	   $table='pitching';
	   $noResult="No Wins recorded";
	   $statMost='w';
	   break;
       }
     $title.="<br/>(Earliest Occurrence Shown)";
     $query="SELECT age,player_id,first_name,last_name,hall_of_fame,team_abbr,MAX($statMost) as $statMost,year FROM (SELECT p.player_id,last_name,hall_of_fame,first_name,(pcs.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,pcs.team_id as team_abbr,SUM($statMost) as $statMost,year FROM players as p,players_career_".$table."_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND pcs.split_id=1 GROUP BY player_id,year HAVING SUM($statMost)>0 ORDER BY $statMost DESC,year) as t WHERE age>0 GROUP BY age ORDER BY age;";
     $getTeams=1;
     break;
   case 19:
     $title="Highest Career Hit to Strikeout Ratio for Batters";
     $title.="<br/>(Top $limit Players, Min 100 Career Hits)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,minYr,maxYr,pa,h,k,hTokRatio as era,avg FROM players as p,(SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,SUM(pa) as pa,SUM(h) as h,SUM(k) as k,SUM(h)/SUM(k) as hTokRatio,SUM(h)/SUM(ab) as avg FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(h)>=100 ORDER BY hTokRatio DESC LIMIT $limit) as pcs WHERE p.player_id=pcs.player_id ORDER BY hTokRatio DESC";
     $cols="Player|From|To|PA|H|K|Ratio|AVG";
     $noResult="No player with 100 hits";
     $getTeams=1;
     break;
   case 20:
     $title="Longest Championship Drought";
     $query="SELECT team_id as team_name,if(year IS NULL,CONCAT('None since joining league in ',minYr),year) as lastYr,IF(drought IS NULL,$lgyear-minYr,drought) as drought FROM (SELECT t.team_id,minYr,t2.year,drought FROM (SELECT team_id,MIN(year) as minYr FROM team_history WHERE league_id=$lgid GROUP BY team_id) as t LEFT JOIN (SELECT team_id,year,MIN(drought) as drought FROM (SELECT team_id,year,$lgyear-year as drought FROM team_history WHERE league_id=$lgid AND won_playoffs=1 ORDER BY drought) as t GROUP BY team_id ORDER BY drought) as t2 ON t.team_id=t2.team_id) as t3 ORDER BY drought DESC,lastYr;";
     $cols="Team|Last Title|Drought";
     $noResult="No historical team championship data found";
     $getTeams=1;
     break;
   case 21:
   case 137:
     switch ($chkDay)
      {
        case 21:
	  $statMost='k';
          $query="SELECT player_id,year,team_id,SUM($statMost) as $statMost FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY $statMost DESC LIMIT 5,1;";
	  $result=mysqli_query($db,$query);
     	  $row=mysqli_fetch_array($result);
	  $statVal=$row[$statMost];
     	  $statVal=floor($statVal/10)*5+10;
	  $title="Most Consecutive $statVal Strikeout Seasons";
	  $title.="<br/>(Top $limit Players)";
	  break;
        case 137:
	  $statMost='w';
          $query="SELECT player_id,year,team_id,SUM($statMost) as $statMost FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY $statMost DESC LIMIT 5,1;";
	  $result=mysqli_query($db,$query);
     	  $row=mysqli_fetch_array($result);
	  $statVal=$row[$statMost];
	  $statVal=floor($statVal/2);
	  $statVal=min($statVal,15);
	  $title="Most Consecutive $statVal Win Seasons";
	  $title.="<br/>(Top $limit Players)";
	  break;
      }
     $query="SET @yrCnt:=0;SET @player_id:=0;SET @year:=0;SET @strk:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,x.year-yrs+1 as strt,x.year,yrs FROM players as p,(SELECT player_id,MAX(yrCnt) as yrs,MAX(year) as year FROM (SELECT if(@player_id!=player_id,@yrCnt:=1,if(@year=year-1,@yrCnt:=@yrCnt+1,@yrCnt:=1)) as yrCnt,if(@player_id!=player_id,@strk:=1,if(@year=year-1,@strk,@strk:=@strk+1)) as strk,@player_id:=player_id as player_id,@year:=year as year,$statMost FROM (SELECT player_id,year,SUM($statMost) as $statMost FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM($statMost)>=$statVal ORDER BY player_id,year) as t1) as a GROUP BY player_id,strk) as x WHERE p.player_id=x.player_id ORDER BY yrs DESC,strt,last_name,first_name LIMIT $limit";
     $cols="Player|From|To|Seasons";
     $noResult="No players have had consecutive $statMost ".strtoupper($statMost)." seasons";
     break;
   case 22:
     $title="Most Defensive Innings At A Position Without Starting A Game There";
     $title.="<br/>(Top $limit Players, Min 100 Career Hits)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,x.position,g,ip,ip/g as era FROM players as p,(SELECT player_id,year,position,SUM(ip)+SUM(ipf)/3 as ip,SUM(g) as g,SUM(gs) as gs FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position!=1 AND year!=$lgyear GROUP BY player_id,year,position HAVING SUM(gs)=0 ORDER BY ip DESC,year,g DESC LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY ip DESC,year,g DESC";
     $cols="Player|Year|Position|G|Inn|Inn/G";
     $noResult="No player has played a defensive position without starting a game there";
     break;
   case 23:
   case 68:
   case 115:
   case 157:
   case 214:
   case 252:
   case 306:
   case 332:
     switch ($chkDay)
      {
        case 23:
          $statLbl='h';
	  $table='batting';
	  $yrs=3;
	  $yrText="Three";
          $title="Most Hits Over A $yrText Year Span";
	  break;
        case 68:
          $statLbl='h';
          $table='batting';
	  $yrs=5;
	  $yrText="Five";
          $title="Most Hits Over A $yrText Year Span";
	  break;
        case 115:
          $statLbl='w';
          $table='pitching';
	  $yrs=5;
	  $yrText="Five";
          $title="Most Wins Over A $yrText Year Span";
	  break;
        case 157:
          $statLbl='rbi';
          $table='batting';
	  $yrs=5;
	  $yrText="Five";
          $title="Most Runs Batted In Over A $yrText Year Span";
	  break;
        case 214:
          $statLbl='w';
          $table='pitching';
	  $yrs=3;
	  $yrText="Three";
          $title="Most Wins Over A $yrText Year Span";
	  break;
        case 252:
          $statLbl='hr';
          $table='batting';
	  $yrs=3;
	  $yrText="Three";
          $title="Most Home Runs Over A $yrText Year Span";
	  break;
        case 306:
          $statLbl='hr';
          $table='batting';
	  $yrs=5;
	  $yrText="Five";
          $title="Most Home Runs Over A $yrText Year Span";
	  break;
        case 332:
          $statLbl='rbi';
          $table='batting';
	  $yrs=3;
	  $yrText="Three";
          $title="Most RBI Over A $yrText Year Span";
	  break;
      }
     $title.="<br/>(Top $limit Players)";
     $query="SET @player_id:=0;";
     if ($yrs==5) {$query.="SET @".$statLbl."0:=0;SET @".$statLbl."1:=0;";}
     $query.="SET @".$statLbl."2:=0;SET @".$statLbl."3:=0;SET @".$statLbl."4:=0;SET @".$statLbl."Tot:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,CONCAT(year-".($yrs-1).",'-',year) as yrs";
     if ($yrs==5) {$query.=",".$statLbl."0,".$statLbl."1";}
     $query.=",".$statLbl."2,".$statLbl."3,".$statLbl."4,".$statLbl."Tot FROM players as p,(SELECT player_id,year";
     if ($yrs==5) {$query.=",".$statLbl."0,".$statLbl."1";}
     $query.=",".$statLbl."2,".$statLbl."3,".$statLbl."4,".$statLbl."Tot FROM (SELECT year";
     if ($yrs==5) {$query.=",if(@player_id=player_id,@".$statLbl."0:=@".$statLbl."1,0) as ".$statLbl."0,if(@player_id=player_id,@".$statLbl."1:=@".$statLbl."2,0) as ".$statLbl."1";}
     $query.=",if(@player_id=player_id,@".$statLbl."2:=@".$statLbl."3,0) as ".$statLbl."2,if(@player_id=player_id,@".$statLbl."3:=@".$statLbl."4,0) as ".$statLbl."3,@".$statLbl."4:=".$statLbl." as ".$statLbl."4,if(@player_id=player_id,@".$statLbl."Tot:=@".$statLbl."4+@".$statLbl."3+@".$statLbl."2";
     if ($yrs==5) {$query.="+@".$statLbl."1+@".$statLbl."0";}
     $query.=",@".$statLbl."Tot:=0) as ".$statLbl."Tot,@player_id:=player_id as player_id FROM (SELECT player_id,year,SUM(".$statLbl.") as ".$statLbl." FROM players_career_".$table."_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY player_id,year) as t1) as t2 ORDER BY ".$statLbl."Tot DESC,year LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY ".$statLbl."Tot DESC,year";
     $cols="Player|Years|Year 1 ".strtoupper($statLbl)."|Year 2 ".strtoupper($statLbl)."|Year 3 ".strtoupper($statLbl);
     if ($yrs==5) {$cols.="|Year 4 ".strtoupper($statLbl)."|Year 5 ".strtoupper($statLbl);}
     $cols.="|".strtoupper($statLbl)." Tot";
     $noResult="No player has played $yrs seasons";
     break;
   case 24:
   case 25:
   case 69:
   case 72:
   case 116:
   case 117:
   case 155:
   case 158:
   case 213:
   case 215:
   case 254:
   case 255:
   case 304:
   case 305:
   case 327:
   case 328:
     switch ($chkDay)
      {
        case 24:
	  $title="Single Season Franchise Records for Stolen Bases";
	  $table='batting';
	  $mode='season';
	  $statName='sb';
     	  $noResult="No stolen bases recorded";
     	  break;
        case 25:
          $title="Career Franchise Records for Wins";
	  $table='pitching';
	  $mode='career';
	  $statName='w';
	  $noResult="No wins recorded";
	  break;
        case 69:
	  $title="Single Season Franchise Records for Hits";
	  $table='batting';
	  $mode='season';
	  $statName='h';
     	  $noResult="No hits recorded";
     	  break;
        case 72:
          $title="Career Franchise Records for Strikeouts";
	  $table='pitching';
	  $mode='career';
	  $statName='k';
	  $noResult="No strikeouts recorded";
	  break;
        case 116:
	  $title="Single Season Franchise Records for Strikeouts";
	  $table='pitching';
	  $mode='season';
	  $statName='k';
     	  $noResult="No strikeouts recorded";
     	  break;
        case 117:
          $title="Career Franchise Records for Walks";
	  $table='batting';
	  $mode='career';
	  $statName='bb';
	  $noResult="No walks recorded";
	  break;
        case 155:
	  $title="Single Season Franchise Records for Win";
	  $table='pitching';
	  $mode='season';
	  $statName='w';
     	  $noResult="No wins recorded";
     	  break;
        case 158:
          $title="Career Franchise Records for Runs";
	  $table='batting';
	  $mode='career';
	  $statName='r';
	  $noResult="No runs recorded";
	  break;
        case 213:
          $title="Career Franchise Records for RBI";
	  $table='batting';
	  $mode='career';
	  $statName='rbi';
	  $noResult="No RBI recorded";
	  break;
        case 215:
	  $title="Single Season Franchise Records for Home Runs";
	  $table='batting';
	  $mode='season';
	  $statName='hr';
     	  $noResult="No home runs recorded";
	  break;
        case 254:
	  $title="Career Franchise Records for Stolen Bases";
	  $table='batting';
	  $mode='career';
	  $statName='sb';
     	  $noResult="No stolen bases recorded";
     	  break;
        case 255:
          $title="Single Season Franchise Records for Runs";
	  $table='batting';
	  $mode='season';
	  $statName='r';
	  $noResult="No runs recorded";
	  break;
        case 304:
	  $title="Career Franchise Records for Hits";
	  $table='batting';
	  $mode='career';
	  $statName='h';
     	  $noResult="No hits recorded";
     	  break;
        case 305:
          $title="Single Season Franchise Records for RBI";
	  $table='batting';
	  $mode='season';
	  $statName='rbi';
	  $noResult="No RBI recorded";
	  break;
        case 327:
	  $title="Career Franchise Records for Home Runs";
	  $table='batting';
	  $mode='career';
	  $statName='hr';
     	  $noResult="No home runs recorded";
     	  break;
        case 328:
          $title="Single Season Franchise Records for Walks";
	  $table='batting';
	  $mode='season';
	  $statName='bb';
	  $noResult="No walks recorded";
	  break;
      }
     if ($mode=='season') {$title.="<br/>(Earliest Occurrence Shown)";}
     $query="SELECT t1.team_id as team_name,t1.player_id,first_name,last_name,hall_of_fame,";
     if ($mode=='season') {$query.="year as recYear,";}
     $query.="$statName FROM players as p,(SELECT team_id,";
     if ($mode=='season') {$query.="year,";}
     $query.="player_id,MAX($statName) as $statName FROM (SELECT player_id,team_id,";
     if ($mode=='season') {$query.="year,";}
     $query.="SUM($statName) as $statName FROM players_career_".$table."_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 GROUP BY player_id,team_id";
     if ($mode=='season') {$query.=",year";}
     $query.=" ORDER BY $statName DESC";
     if ($mode=='season') {$query.=",year";}
     $query.=") as t GROUP BY team_id) as t1 WHERE p.player_id=t1.player_id ORDER BY $statName DESC";
     if ($mode=='season') {$query.=",year";}
     $query.=";";
     $cols="Team|Player";
     if ($mode=='season') {$cols.="|Year";}
     $cols.="|".strtoupper($statName);
     $getTeams=1;
     break;
   ## case 25: Filed under case 24
   case 26:
     $title="Largest Discrepancy Between Times On Base And Runs Scored";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,pa,tob,r,diff FROM players as p,(SELECT player_id,team_id,year,SUM(pa) as pa,SUM(h)+SUM(bb)+SUM(hp) as tob,SUM(r) as r,(SUM(h)+SUM(bb)+SUM(hp)-SUM(k)) as diff FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING (SUM(h)+SUM(bb)+SUM(hp)-SUM(k))>0 ORDER BY diff DESC,tob DESC,pa DESC LIMIT $limit) as pcs WHERE p.player_id=pcs.player_id ORDER BY diff DESC,tob DESC,pa DESC;";
     $cols="Player|Team|Year|PA|TOB|R|Diff";
     $noResult="No players with more TOB than R";
     $getTeams=1;
     break;
   case 27:
     $title="Most Plate Appearances With A 1.000 AVG";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,team_abbr,year,h,bb,hp,sf,sh,pa FROM players as p,(SELECT player_id,team_id as team_abbr,year,SUM(h) as h,SUM(bb) as bb,SUM(hp) as hp,SUM(sf) as sf,SUM(sh) as sh,SUM(pa) as pa,if(SUM(ab)=0,0,SUM(h)/SUM(ab)) as avg FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING (SUM(h)/SUM(ab))=1 ORDER BY pa DESC,h DESC LIMIT $limit) as pcs WHERE p.player_id=pcs.player_id ORDER BY pa DESC,h DESC";
     $cols="Player|Team|Year|H|BB|HP|SF|SH|PA";
     $noResult="No players with a 1.000 AVG";
     $getTeams=1;
     break;
   case 28:
     $title="Winning Teams Who've Been Outscored By Their Opponents";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT thr.team_id as team_name,thr.year,w,l,pct as avg,if(pos=1,'-',gb) as gb,pos as stanPos,rf,ra,ra-rf as runDiff FROM team_history_record as thr,(SELECT thb.team_id,thb.year,thb.r as rf,thp.r as ra FROM team_history_batting_stats as thb,team_history_pitching_stats as thp WHERE thb.team_id=thp.team_id AND thb.year=thp.year AND thb.league_id=$lgid AND thb.r<thp.r) as t1 WHERE thr.team_id=t1.team_id AND thr.year=t1.year AND w>l ORDER BY w DESC, runDiff DESC,year LIMIT $limit";
     $cols="Team|Year|W|L|Pct|GB|Finish|RF|RA|Diff";
     $noResult="No fielding stats available";
     $getTeams=1;
     break;
   case 29:
     $title="Most Losses While Pitching For A Winning Team";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_abbr,year,pw,pl,pw/(pw+pl) as obp,tw,tl,pct as avg FROM players as p,(SELECT player_id,t1.team_id,t1.year,pw,pl,tw,tl,pct FROM (SELECT player_id,team_id,year,w as pw,l as pl FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1) as t1,(SELECT team_id,year,w as tw,l as tl,pct FROM team_history_record WHERE league_id=$lgid AND w>l) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY pl DESC,pct DESC,pw LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY pl DESC,pct DESC,pw";
     $cols="Player|Team|Year|Player Wins|Player Losses|Player Win Pct|Team Wins|Team Losses|Team Win Pct";
     $noResult="No historical data";
     $getTeams=1;
     break;
   case 30:
     $title="Most Years Between Stolen Bases";
     $title.="<br/>(Top $limit Players";
     if ($_GET['noP']==1) {$title.=", <a href='./statOfTheDay.php?fact=30'>Show Pitchers</a>";}
      else {$title.=", <a href='./statOfTheDay.php?fact=30&noP=1'>Hide Pitchers</a>";}
     $title.=")";
     $query="SET @sbYr:=0;SET @player_id:=-1;SET @pYr:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,year-sbYr as firstyr,year,sbYr FROM players as p,(SELECT IF(@player_id!=player_id,@sbYr:=0,@sbYr:=year-@pYr) as sbYr,@player_id:=player_id as player_id,@pYr:=year as year FROM (SELECT player_id,year,SUM(sb) as sb FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(sb)>0) as a ORDER BY player_id,year) as t WHERE p.player_id=t.player_id AND sbYr>2";
     if ($_GET['noP']==1) {$query.=" AND p.position!=1";}
     $query.=" ORDER BY sbYr DESC LIMIT $limit";
     $cols="Player|Previous|Next|Years Between";
     $noResult="No historical data";
     break;
   case 31:
     $title="Most Seasons Appeared In Without Ever Qualifying For The Batting Title";
     $title.="<br/>(Top $limit Players, 3.1 PA/Team Game for Qualification)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT year) as yrs FROM players as p,(SELECT player_id,year,pa,g,if(pa<3.1*g,0,1) as Qual FROM (SELECT player_id,pcb.year,SUM(pa) as pa,thr.g FROM players_career_batting_stats as pcb,team_history_record as thr WHERE pcb.year=thr.year AND pcb.team_id=thr.team_id AND pcb.league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY player_id,year) as t1) as t2 WHERE p.player_id=t2.player_id AND position!=1 GROUP BY player_id HAVING SUM(Qual)=0 ORDER BY yrs DESC,minYr,maxYr,last_name,first_name LIMIT $limit";
     $cols="Player|From|To|Seasons";
     $noResult="No historical data";
     break;
   case 32:
     $title="Most Defensive Innings Without Recording A Putout Or Assist";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT t.player_id,first_name,last_name,hall_of_fame,t.team_id as team_abbr,year,t.position,ip FROM players as p,(SELECT player_id,team_id,year,position,SUM(a) as a,SUM(po) as po,(SUM(ip)+SUM(ipf)/3) as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position!=10 GROUP BY player_id,year,position HAVING SUM(a)=0 AND SUM(po)=0 ORDER BY ip DESC LIMIT $limit) as t WHERE p.player_id=t.player_id ORDER BY ip DESC";
     $cols="Player|Team|Year|Pos|IP";
     $noResult="No players have gone without recording a putout or assist";
     $getTeams=1;
     break;
   case 33:
     $title="Highest SB% Among SB Title Winners";
     $query="SELECT year,sub_league_id as sl_name,t1.player_id,first_name,last_name,hall_of_fame,MAX(sb) as sb,cs,sb/(sb+cs) as sbPct FROM players as p,(SELECT player_id,pcb.team_id,sub_league_id,pcb.year,th.g,SUM(sb) as sb,SUM(cs) as cs FROM players_career_batting_stats as pcb,team_history_record as th WHERE pcb.team_id=th.team_id AND pcb.year=th.year AND pcb.league_id=$lgid AND split_id=1 GROUP BY player_id,year,sub_league_id HAVING SUM(sb)>0 ORDER BY year,sb DESC,cs) as t1 WHERE p.player_id=t1.player_id GROUP BY year,sub_league_id ORDER BY sbPct DESC,sb DESC";
     $cols="Year|League|Player|SB|CS|SB%";
     $noResult="No stolen base history";
     $getSubLeagues=1;
     break;
   case 34:
     $title="Most Relief Appearances By Team";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,SUM(g) as g,SUM(gs) as gs,(SUM(g)-SUM(gs)) as ra FROM players_career_pitching_stats WHERE league_id=$lgid AND team_id!=0 AND split_id=1 GROUP BY team_id,year HAVING SUM(gs)>0 ORDER BY ra DESC LIMIT $limit";
     $cols="Team|Year|G|GS|Relief Appearances";
     $noResult="No historical pitching stats available";
     $getTeams=1;
     break;
   case 35:
     $title="Most Years Placing in the League's Top 3";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,category,CONCAT(MIN(year),'-',MAX(year)) as yrRange,COUNT(DISTINCT year) as yrs,MAX(year)-MIN(year)+1 as yrsPoss FROM players as p,players_league_leader as pll WHERE p.player_id=pll.player_id AND pll.league_id=$lgid AND place<=3 AND category IN (3,6,7,8,9,10,11,12,18,29,32,34,38,40) GROUP BY player_id,category HAVING COUNT(DISTINCT year)>1 ORDER BY yrs DESC,yrsPoss,yrRange,last_name,first_name LIMIT $limit";
     $cols="Player|Stat|From-To|Years Placed|Year Span";
     $noResult="No league leaders history";
     break;
   case 36:
     $title="Most Different Teams to Appear As An All-Star With";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,cnt FROM players as p,(SELECT player_id,COUNT(DISTINCT team_id) as cnt FROM players_awards WHERE league_id=$lgid AND award_id=9 GROUP BY player_id HAVING COUNT(DISTINCT team_id)>1 ORDER BY cnt DESC LIMIT $limit) as t WHERE p.player_id=t.player_id ORDER BY cnt DESC;";
     $cols="Player|Teams";
     $noResult="No player has been an All-Star with more than one team";
     break;
   case 37:
   case 100:
   case 159:
   case 223:
   case 285:
   case 326:
     switch ($chkDay)
      {
        case 37:
          $table='batting';
	  $statName='sb';
	  $statWord='stolen bases';
          break;
        case 100:
          $table='pitching';
          $statName='w';
	  $statWord='wins';
          break;
        case 159:
          $table='pitching';
          $statName='k';
	  $statWord='strikeouts';
          break;
        case 223:
          $table='batting';
	  $statName='h';
	  $statWord='hits';
          break;
        case 285:
          $table='batting';
	  $statName='hr';
	  $statWord='home runs';
          break;
        case 326:
          $table='pitching';
          $statName='s';
	  $statWord='saves';
	  break;
      }
     $subquery="SELECT MIN(year) as year FROM players_career_".$table."_stats WHERE league_id=$lgid AND split_id=1 GROUP BY league_id;";
     $subresult=mysqli_query($db,$subquery);
     $row=mysqli_fetch_array($subresult);
     $firstYr=$row['year'];
     $title="Most ".ucwords($statWord)." in Debut Season";
     $title.="<br/>(Top $limit Players, Inaugural Season Ignored)";
     $query="SELECT x.player_id,p.first_name,p.last_name,hall_of_fame,x.team_abbr,year,$statName FROM players as p,(SELECT pcs.player_id,pcs.team_id as team_abbr,pcs.year,SUM($statName) as $statName FROM players_career_".$table."_stats as pcs,(SELECT player_id,MIN(year) as year FROM players_career_".$table."_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as t WHERE pcs.player_id=t.player_id AND pcs.year=t.year AND league_id=$lgid AND split_id=1 AND pcs.year!=$firstYr GROUP BY player_id ORDER BY $statName DESC LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY $statName DESC;";
     $cols="Player|Team|Year|".strtoupper($statName);
     if ($statName=='s') {$cols.="V";}
     $noResult="No $statWord recorded";
     $getTeams=1;
     break;
   case 38:
   case 133:
     switch ($chkDay)
      {
        case 38:
	  $title="Highest Career Double/Stolen Base Combinations";
          $title.="<br/>(Top $limit Players, Sorted By Lower of 2B/SB)";
          $stat1='d';
	  $stat2='sb';
	  $table='batting';
          $cols="Player|2B|".strtoupper($stat2);
	  break;
        case 133:
	  $title="Highest Career Home Run/Stolen Base Combinations";
     $title.="<br/>(Top $limit Players, Sorted By Lower of HR/SB)";
          $stat1='hr';
	  $stat2='sb';
	  $table='batting';
          $cols="Player|".strtoupper($stat1)."|".strtoupper($stat2);
	  break;
      }
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,$stat1,$stat2 FROM players as p,(SELECT player_id,SUM($stat1) as $stat1,SUM($stat2) as $stat2,if(SUM($stat1)>SUM($stat2),SUM($stat2),SUM($stat1)) as minVal FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM($stat1)>=5 AND SUM($stat2)>=5) as t WHERE p.player_id=t.player_id ORDER BY minVal DESC,$stat1 DESC,$stat2 DESC LIMIT $limit";
     $noResult="Not enough history";
     break;
   case 39:
     $title="More IBB Than UBB";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,ibb,ubb FROM players as p,(SELECT player_id,team_id,year,SUM(ibb) as ibb,SUM(bb)-SUM(ibb) as ubb FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(ibb)>(SUM(bb)-SUM(ibb)) ORDER BY ibb DESC,ubb LIMIT $limit) as pcs WHERE p.player_id=pcs.player_id ORDER BY ibb DESC,ubb;";
     $cols="Player|Team|Year|IBB|UBB";
     $noResult="No player has had more intentional walks than unintentinal walks in a season";
     $getTeams=1;
     break;
   case 40:
    case 101:
     $title="Highest Innings Per Game Ratio";
     $title.="<br/>(Top $limit Players, Min 5 Appearances)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame";
     if ($chkDay==40) {$query.=",pcs.team_id as team_abbr,year";}
     $query.=",ip,g,ipToGRatio as era FROM players as p,(SELECT player_id";
     if ($chkDay==40) {$query.=",team_id,year";}
     $query.=",SUM(ip)+SUM(ipf)/3 as ip,SUM(g) as g,(SUM(ip)+SUM(ipf)/3)/SUM(g) as ipToGRatio FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id";
     if ($chkDay==40) {$query.=",year";}
     $query.=" HAVING SUM(g)>=5 ORDER BY ipToGRatio DESC,ip DESC LIMIT $limit) as pcs WHERE p.player_id=pcs.player_id ORDER BY era DESC,ip DESC";
     $cols="Player";
     if ($chkDay==40) {$cols.="|Team|Year";}
     $cols.="|IP|G|Ratio";
     $noResult="No player has pitched in 5 games";
     $getTeams=1;
     break;
   case 41:
     $query="SELECT player_id,t1.team_id,t1.year,whip FROM (SELECT player_id,team_id,year,SUM(ip)+SUM(ipf)/3 as ip,(SUM(ha)+SUM(bb))/(SUM(ip)+SUM(ipf)/3) as whip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING ip>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.ip>=t2.g ORDER BY whip LIMIT 25,1";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $whip=$row['whip'];
     $whip=ceil($whip*10)/10;
     $whip=max($whip,1);
     $title="Number of Sub ".sprintf("%.2f",$whip)." WHIP's Per Season";
     if ($showLink==1)
      {
        $yr=$_GET['year'];
        $title.="<br/>(Players with sub ".sprintf("%.2f",$whip)." WHIP's)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_abbr,'$yr' as year,w,l,ip,era,whip FROM players as p,(SELECT player_id,t1.team_id,w,l,ip,era,whip FROM (SELECT player_id,team_id,SUM(w) as w,SUM(l) as l,SUM(ip)+SUM(ipf)/3 as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era,(SUM(ha)+SUM(bb))/(SUM(ip)+SUM(ipf)/3) as whip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND year=$yr GROUP BY player_id HAVING ((SUM(ha)+SUM(bb))/(SUM(ip)+SUM(ipf)/3))<$whip ORDER BY whip) as t1,(SELECT team_id,g FROM team_history_record WHERE league_id=$lgid AND year=$yr) as t2 WHERE t1.team_id=t2.team_id AND t1.ip>=t2.g ORDER BY whip,era,ip DESC) as x WHERE p.player_id=x.player_id ORDER BY whip,era,ip DESC;";
        $cols="Player|Team|Year|W|L|IP|ERA|WHIP";
	$noResult="No player had a sub ".sprintf("%.2f",$whip)." WHIP in $yr";
        $getTeams=1;
      }
      else
      {
	$query="SELECT year,'Show Players' as showLink,SUM(cnt) as cnt FROM (SELECT year,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,t1.team_id,t1.year,ip,whip FROM (SELECT player_id,team_id,year,SUM(ip)+SUM(ipf)/3 as ip,(SUM(ha)+SUM(bb))/(SUM(ip)+SUM(ipf)/3) as whip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING ((SUM(ha)+SUM(bb))/(SUM(ip)+SUM(ipf)/3))<$whip) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.ip>=t2.g) as x GROUP BY year UNION SELECT DISTINCT year,0 as cnt FROM team_history WHERE league_id=$lgid GROUP BY year) as x1 GROUP BY year ORDER BY year";
   	$cols="Year|Link|Number of Players";
	$noResult="No player has had a sub ".sprintf("%.2f",$whip)." WHIP in a season";
      }
     break;
   case 42:
   case 103:
     switch ($chkDay)
      {
        case 42:
	  $table='batting';
	  $statMost='hr';
	  $statWord='home runs';
	  break;
        case 103:
	  $table='pitching';
	  $statMost='w';
	  $statWord='wins';
	  break;
     }
     $title="Most ".ucwords($statWord)." With Two Different Teams";
     $title.="<br/>(Top $limit Players, Sorted by Lower ".strtoupper($statMost)." Total)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,tm1 as team_abbr,".$statMost."1,tm2 as team_abbr2,".$statMost."2,".$statMost."Tot FROM players as p,(SELECT a.player_id,a.team_id as tm1,a.".$statMost." as ".$statMost."1,b.team_id as tm2,b.".$statMost." as ".$statMost."2,a.".$statMost."+b.".$statMost." as ".$statMost."Tot,if(a.".$statMost."<b.".$statMost.",a.".$statMost.",b.".$statMost.") as min".$statMost." FROM (SELECT player_id,team_id,SUM($statMost) as $statMost FROM players_career_".$table."_stats WHERE league_id=$lgid AND team_id!=0 AND split_id=1 GROUP BY player_id,team_id HAVING SUM($statMost)>1) as a,(SELECT player_id,team_id,SUM($statMost) as $statMost FROM players_career_".$table."_stats WHERE league_id=$lgid AND team_id!=0 AND split_id=1 GROUP BY player_id,team_id HAVING SUM($statMost)>1) as b WHERE a.player_id=b.player_id AND a.team_id<b.team_id ORDER BY min".$statMost." DESC,".$statMost."Tot DESC LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY min".$statMost." DESC,".$statMost."Tot DESC";
     $cols="Player|Team|".strtoupper($statMost)."|Team|".strtoupper($statMost)."|Combined ".strtoupper($statMost);
     $noResult="No player has $statWord with two teams";
     $getTeams=1;
     break;
   case 43:
     $query="SELECT player_id,year,team_id,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY hr DESC LIMIT 5,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $hr=$row['hr'];
     $hr=floor($hr/10)*5+5;
     $title="Most $hr Home Run Seasons By Franchise";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
        $title.="<br/>(Individual Team Listing)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_name,year,hr FROM players as p,(SELECT player_id,team_id,year,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND team_id=$tid AND split_id=1 GROUP BY player_id,year HAVING SUM(hr)>=$hr ORDER BY hr DESC,year) as x WHERE p.player_id=x.player_id ORDER BY hr DESC,year";
        $cols="Player|Team|Year|HR";
	$noResult="No player had $hr home runs";
      }
      else
      {
        $title.="<br/>(Top $limit Players, Sorted by Lower HR Total)";
	$query="SELECT team_id as team_name,'Show Players' as showLink,COUNT(*) as cnt FROM (SELECT player_id,team_id,year,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,team_id,year HAVING SUM(hr)>=$hr) as x GROUP BY team_id ORDER BY cnt DESC";
   	$cols="Team|Link|Players";
	$noResult="No player has hit $hr home runs";
      }
     $getTeams=1;
     break;
   case 44:
     $title="Longest Winning Streak To Finish a Season";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,w,l,pct as avg,gb,pos as stanPos,streak FROM team_history_record WHERE league_id=$lgid AND streak>1 ORDER BY streak DESC,avg DESC,w DESC LIMIT $limit";
     $cols="Team|Year|W|L|Pct|GB|Finish|Streak";
     $noResult="No season ending win streaks of more than 1 win";
     $getTeams=1;
     break;
   case 45:
     $title="Most Home Runs in Top Three Seasons";
     $title.="<br/>(Top $limit Player)";
     $query="SET @pRowID:=0;SET @player_id:=-1;SELECT p.player_id,first_name,last_name,hall_of_fame,hr FROM players as p,(SELECT player_id,SUM(hr) as hr FROM (SELECT if(@player_id!=player_id,@pRowID:=1,@pRowID:=@pRowID+1) as pRowID,@player_id:=player_id as player_id,year,hr FROM (SELECT player_id,year,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY player_id,hr DESC,year) as t1) as t2 WHERE pRowID<=3 GROUP BY player_id ORDER BY hr DESC LIMIT $limit) as hrTb WHERE p.player_id=hrTb.player_id ORDER BY hr DESC";
     $cols="Player|HR";
     $noResult="No player has hit home runs";
     break;
   case 46:
   case 177:
     switch ($chkDay)
      {	     
	case 46:
          $statMost='r';
	  $statText='runs';
	  break;
	case 177:
          $statMost='sb';
	  $statText='stolen bases';
	  break;
      }
     $title="Most ".ucwords($statText)." Without Getting Self On Base";
     $title.="<br/>(Top $limit Players, Pitchers Excluded)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,$statMost FROM players as p,(SELECT player_id,team_id,year,SUM($statMost) as $statMost,SUM(h) as h,SUM(bb) as bb,SUM(hp) as hp FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(h)=0 AND SUM(bb)=0 AND SUM(hp)=0 AND SUM($statMost)>0) as pcs WHERE p.player_id=pcs.player_id AND p.position!=1 ORDER BY $statMost DESC,year LIMIT $limit";
     $cols="Player|Team|Year|".strtoupper($statMost);
     $noResult="No players have recorded $statText while failing to get on base under their own means";
     $getTeams=1;
     break;
   case 47:
     $query="SELECT player_id,t1.team_id,t1.year,era FROM (SELECT player_id,team_id,year,SUM(ip)+SUM(ipf)/3 as ip,(9*SUM(er))/(SUM(ip)+SUM(ipf)/3) as era FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING ip>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.ip>=t2.g ORDER BY era LIMIT 25,1";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $era=$row['era'];
     $era=ceil(($era+(2/$era))/0.5)*0.5;
     $era=max($era,1);
     $title="Most Consecutive Seasons With An ERA Below ".sprintf("%.2f",$era);
     $title.="<br/>(Top $limit Players, Min 1.0 IP/TmG)";
     $query="SET @yrCnt:=0;SET @player_id:=0;SET @year:=0;SET @strk:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,x.year-yrs+1 as strt,x.year,yrs FROM players as p,(SELECT player_id,MAX(yrCnt) as yrs,MAX(year) as year FROM (SELECT if(@player_id!=player_id,@yrCnt:=1,if(@year=year-1,@yrCnt:=@yrCnt+1,@yrCnt:=1)) as yrCnt,if(@player_id!=player_id,@strk:=1,if(@year=year-1,@strk,@strk:=@strk+1)) as strk,@player_id:=player_id as player_id,@year:=year as year,era FROM (SELECT t1.* FROM (SELECT player_id,team_id,year,(SUM(ip)+SUM(ipf)/3) as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING (SUM(ip)+SUM(ipf)/3)>0 AND (9*SUM(er)/(SUM(ip)+SUM(ipf)/3))<$era ORDER BY player_id,year) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.ip>=t2.g ORDER BY player_id,year) as combTbl) as a GROUP BY player_id,strk) as x WHERE p.player_id=x.player_id ORDER BY yrs DESC,strt,last_name,first_name LIMIT $limit";
     $cols="Player|From|To|Seasons";
     $noResult="No players have had consecutive sub $era ERA seasons";
     break;
   case 48:
     $title="Highest Career Error Rate";
     $title.="<br/>(Top $limit Players, Minimum 5 errors committed)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,e,ip,eRate as avg FROM players as p,(SELECT player_id,SUM(e) as e,(SUM(ip)+SUM(ipf)/3) as ip,(SUM(e)/(SUM(ip)+SUM(ipf)/3)) as eRate FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 GROUP BY player_id HAVING SUM(e)>=5 ORDER BY eRate DESC LIMIT $limit) as t WHERE p.player_id=t.player_id ORDER BY eRate DESC;";
     $cols="Player|E|Inn|Rate";
     $noResult="No player has recorded more strikeouts than hits allowed in a season";
     $getTeams=1;
     break;
   case 49:
     $awquery="SELECT defense_award_name FROM leagues WHERE league_id=$lgid;";
     $awresult=mysqli_query($db,$awquery);
     $row=mysqli_fetch_array($awresult);
     $awName=$row['defense_award_name'];
     $title="Most Different Teams to Win the $awName With";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,cnt FROM players as p,(SELECT player_id,COUNT(DISTINCT team_id) as cnt FROM players_awards WHERE league_id=$lgid AND award_id=7 GROUP BY player_id ORDER BY cnt DESC) as t WHERE p.player_id=t.player_id AND cnt>1 LIMIT $limit;";
     $cols="Player|Teams";
     $noResult="No player has won the $awName with more than one team";
     break;
   case 50:
     $title="Most Seasons Below .400 Winning Percentage";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
	$title.="<br/>(Individual Team Listing)";
	$query="SELECT team_id as team_name,year,w,l,pct as avg,gb,pos as stanPos FROM team_history_record WHERE league_id=$lgid AND team_id=$tid AND pct<.400 ORDER BY year;";
	$cols="Team|Year|W|L|Pct|GB|Finish";
	$noResult="No team has finished with a winning percentage below .400.";
      }
      else
      {
	$query="SELECT team_id as team_name,'Show Seasons' as showLink,COUNT(year) as cnt FROM team_history_record WHERE league_id=$lgid AND pct<.400 GROUP BY team_id ORDER BY cnt DESC;";
	$cols="Team|Link|Below .400 Seasons";
	$noResult="No team has finished with a winning percentage below .400.";
      }
     $getTeams=1;
     break;
   case 51:
     $title="Most Common First Names Among Active Players";
     if ($showLink==1)
      {
        $fname=$_GET['name'];
	$title.="<br/>(Individual Team Listing)";
	$query="SELECT position,player_id,first_name,last_name,hall_of_fame,organization_id as team_name FROM players WHERE league_id=$lgid AND retired=0 AND first_name='$fname' ORDER BY last_name,first_name;";
	$cols="Pos|Player|Team";
	$noResult="No $fname players on active rosters";
	$getTeams=1;
      }
      else
      {
        $title.="<br/>(Top $limit Names)";
        $query="SELECT first_name as fname,'Show Players' as showLink,count(player_id) as cnt FROM players WHERE league_id=$lgid AND retired=0 GROUP BY first_name ORDER BY cnt DESC,fname LIMIT $limit;";
	$cols="Name|Link|Count";
      }
     break;
   case 52:
     $title="Most Hall of Famers Drafted By Franchise";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
	$title.="<br/>(Individual Team Listing)";
	$query="SELECT position,player_id,first_name,last_name,if(draft_team_id=0,'Undrafted Free Agent',draft_team_id) as team_name FROM players WHERE hall_of_fame=1 AND draft_league_id=$lgid ORDER BY last_name,first_name;";
	$cols="Pos|Player|Team";
	$noResult="No Hall of Fame players drafted";
	$getTeams=1;
      }
      else
      {
        $query="SELECT draft_team_id as team_name,'Show Players' as showLink,COUNT(player_id) as cnt FROM players WHERE hall_of_fame=1 AND draft_league_id=$lgid GROUP BY draft_team_id ORDER BY cnt DESC";
	$cols="Team|Link|HOFers Drafted";
   	$noResult="No Hall of Famers";
	$teams[0][$lgyear]['name']='Undrafted Free Agent';
      }
     $getTeams=1;
     break;
   case 53:
     $title="Most Walks by Batter Height";
     $title.="<br/>(Earliest Occurrence Shown)";
     $query="SELECT height,player_id,first_name,last_name,hall_of_fame,team_abbr,year,MAX(bb) as bb FROM (SELECT CONCAT(floor((height/2.54)/12),'\' ',floor(mod((height/2.54),12)),'\"') as height,height as rawHt,player_id,first_name,last_name,hall_of_fame,team_abbr,bb,year FROM (SELECT p.player_id,last_name,first_name,hall_of_fame,height,pcs.team_id as team_abbr,SUM(bb) as bb,year FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND pcs.split_id=1 GROUP BY player_id,year HAVING SUM(bb)>0 ORDER BY height,bb DESC,year) as t) as x GROUP BY height ORDER BY rawHt;";
     $cols="Height|Player|Team|Year|BB";
     $noResult="No walks recorded";
     $getTeams=1;
     break;
   case 54:
   case 124:
   case 202:
   case 278:
   case 358:
     switch ($chkDay)
      {
        case 54:
	  $statMost='hr';
	  $table='batting';
          $title="Most Home Runs in Final Season";
          $noResult="No retirees with home runs recorded";
	  break;
        case 124:
          $statMost='h';
	  $table='batting';
          $title="Most Hits in Final Season";
          $noResult="No retirees with hits recorded";
	  break;
        case 202:
          $statMost='sb';
	  $table='batting';
          $title="Most Stolen Bases in Final Season";
          $noResult="No retirees with stolen bases recorded";
	  break;
        case 278:
          $statMost='k';
	  $table='pitching';
          $title="Most Strikeouts in Final Season";
          $noResult="No retirees with strikeouts recorded";
	  break;
        case 358:
          $statMost='w';
	  $table='pitching';
          $title="Most Wins in Final Season";
          $noResult="No retirees with wins recorded";
	  break;
     }	     
     $title.="<br/>(Top $limit Players)";
     $query="SELECT x.player_id,p.first_name,p.last_name,hall_of_fame,x.team_abbr,year,$statMost FROM players as p,(SELECT pcs.player_id,pcs.team_id as team_abbr,pcs.year,SUM($statMost) as $statMost FROM players_career_".$table."_stats as pcs,(SELECT player_id,MAX(year) as year FROM players_career_".$table."_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as t WHERE pcs.player_id=t.player_id AND pcs.year=t.year AND league_id=$lgid AND split_id=1 GROUP BY player_id) as x WHERE p.player_id=x.player_id AND retired=1 ORDER BY $statMost DESC LIMIT $limit;";
     $cols="Player|Team|Year|".strtoupper($statMost);
     $getTeams=1;
     break;
   case 55:
     $title="Most Players Used In A Season";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,team_id,year FROM players_career_batting_stats WHERE league_id=$lgid AND team_id!=0 AND split_id=1 UNION SELECT player_id,team_id,year FROM players_career_pitching_stats WHERE league_id=$lgid AND team_id!=0 AND split_id=1) as t GROUP BY team_id,year ORDER BY cnt DESC,year LIMIT $limit;";
     $cols="Team|Year|Players Used";
     $getTeams=1;
     break;
   case 56:
     $title="Most Innings Pitched While Recording X Wins";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT w,p.player_id,first_name,last_name,hall_of_fame,year,w,l,s,ip,wpct as avg,wRat as obp FROM players as p,(SELECT player_id,year,w,l,s,ip,w/(w+l) as wpct,w/ip as wRat FROM (SELECT player_id,year,SUM(w) as w,SUM(l) as l,SUM(s) as s,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY ip DESC,year) as a GROUP BY w ORDER BY w DESC) as x WHERE p.player_id=x.player_id ORDER BY w DESC;";
     $cols="Wins|Player|Year|W|L|SV|IP|Win%|W/IP";
     $noResult="No wins recorded";
     $getTeams=1;
     break;
   case 57:
     $title="Failing to Hit His Weight";
     $title.="<br/>(Top $limit Players, Minimum 200 PA)";
     $query="SELECT player_id,first_name,last_name,hall_of_fame,team_abbr,year,h,pa,avg,weight as wt,(.001*weight-avg) as obp FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,SUM(h) as h,SUM(pa) as pa,if(SUM(ab)=0,0,SUM(h)/SUM(ab)) as avg,weight FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id,year) as t WHERE pa>=200 ORDER BY obp DESC LIMIT $limit";
     $cols="Player|Team|Year|H|PA|AVG|Wt (lbs)|Diff";
     $noResult="No player has hit below his weight";
     $getTeams=1;
     break;
   ## case 58: Filed under case 1
   case 59:
     $title="Most Games While Recording The Final Out In All Appearances";
     $title.="<br/>(Top $limit Players, Minimum 2 Appearances)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,t.team_id as team_abbr,year,g,cg,gf,w,l,s FROM players as p,(SELECT player_id,team_id,year,SUM(g) as g,SUM(cg) as cg,SUM(gf) as gf,SUM(w) as w,SUM(l) as l,SUM(s) as s FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(g)>1 AND SUM(g)=(SUM(gf)+SUM(cg)) ORDER BY g DESC LIMIT $limit) as t WHERE p.player_id=t.player_id ORDER BY g DESC;";
     $cols="Player|Team|Year|G|CG|GF|W|L|SV";
     $noResult="No pitcher has finished all the games in which he's pitched";
     $getTeams=1;
     break;
   ## case 60: Filed under case 18
   ## case 61: Filed under case 3
   case 62:
     $title="Largest Drop in the Standings";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT t1.team_id as team_name,t1.year as year1,t1.w,t1.pos as stanPos1,t2.year as year,t2.w as w2,t2.pos as stanPos2,t2.pos-t1.pos as diff FROM team_history_record as t1,team_history_record as t2 WHERE t1.team_id=t2.team_id AND t1.league_id=t2.league_id AND t1.league_id=$lgid AND t1.year=(t2.year-1) ORDER BY diff DESC,year LIMIT $limit;";
     $cols="Team|Year 1|W's|Finish|Year 2|W's|Finish|Decline";
     $getTeams=1;
     break;
   case 63:
     $title="Teams With The Closest Balance Between Power and Speed";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,hr,sb,hr+sb as tot,abs(hr-sb) as diff FROM team_history_batting_stats WHERE league_id=$lgid AND hr>0 AND sb>0 ORDER BY diff,tot DESC,year LIMIT $limit;";
     $cols="Team|Year|HR|SB|Tot|Diff";
     $noResult="No team data found";
     $getTeams=1;
     break;
   ## case 64: Filed under case 10
   case 65:
     $title="Players With the Same Number of Wins, Losses, and Saves In Their Career";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,minYr,maxYr,w,l,s,g,gs,gf,ip,era FROM players as p,(SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,SUM(w) as w,SUM(l) as l,SUM(s) as s,SUM(g) as g,SUM(gs) as gs,SUM(gf) as gf,SUM(ip)+SUM(ipf)/3 as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(w)=SUM(l) AND SUM(l)=SUM(s) AND SUM(w)>0 ORDER BY w DESC) as pcs WHERE p.player_id=pcs.player_id ORDER BY w DESC;";
     $cols="Player|From|To|W|L|SV|G|GS|GF|IP|ERA";
     $noResult="No pitcher has recorded an identical number of wins, losses, and saves";
     break;
   ## case 66: Filed under case 1
   ## case 67: Filed under case 7
   ## case 68: Filed under case 23
   ## case 69: Filed under case 24
   case 70:
     $title="Players with 10 L's and 10 SV's in a Season";
     $title.="<br/>(Top $limit Players, Sorted by Lower of L/SV)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,team_abbr,year,w,l,s,bs,hide FROM players as p,(SELECT player_id,team_id as team_abbr,year,SUM(w) as w,SUM(l) as l,SUM(s) as s,SUM(bs) as bs,if(SUM(l)>SUM(s),SUM(s),SUM(l)) as hide FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(l)>=10 AND SUM(s)>=10 ORDER BY hide DESC,year LIMIT $limit) as pcs WHERE p.player_id=pcs.player_id ORDER BY hide DESC,year";
     $cols="Player|Team|Year|W|L|SV|BS";
     $noResult="No players with 10 L's and 10 SV's in the same season";
     $getTeams=1;
     break;
   case 71:
     $query="SELECT player_id,year,team_id,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY w DESC LIMIT 25,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $w=$row['w'];
     if ($w>20) {$w=20;}
      else {$w=floor($w/5)*5;}
     $title="Most Players with $w or More Wins";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT * FROM (SELECT pcs.team_id as team_name,pcs.year,count(player_id) as cnt,SUM(w) as w FROM players_career_pitching_stats as pcs,team_history as th WHERE pcs.team_id=th.team_id AND pcs.year=th.year AND pcs.league_id=$lgid AND split_id=1 AND w>=$w GROUP BY pcs.team_id,year ORDER BY cnt DESC,w DESC,year) as t WHERE cnt>1 LIMIT $limit;";
     $cols="Team|Year|Number of Players|Wins Among Them";
     $noResult="No teams with players with $w+ W's in any season";
     $getTeams=1;
     break;
   ## case 72: Filed under case 24
   case 73:
     $title="Most Teams Played For In the Postseason";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,teams FROM players as p,((SELECT player_id,COUNT(DISTINCT team_id) as teams FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=21 GROUP BY player_id) UNION (SELECT player_id,COUNT(DISTINCT team_id) as teams FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=21 GROUP BY player_id) ORDER BY teams DESC LIMIT $limit) as t WHERE p.player_id=t.player_id AND teams>1 ORDER BY teams DESC,last_name,first_name;";
     $cols="Player|Teams";
     $noResult="No players have played for more than one team";
     break;
   case 74:
     $title="Largest Single Season Increase In Home Runs";
     $title.="<br/>(Top $limit Players, Maximum 100% Increase In Games Played)";
     $query="SET @player_id:=0;SET @year:=0;SET @incr:=0;SET @hr:=0;SET @tid:=0;SET @gms:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,prevYr as year,prevTid as team_abbr,g1,prevHR,year as year2,x.team_id as team_abbr2,g2,hr,incr FROM players as p,(SELECT if((@player_id!=player_id)OR(@gms<(0.5*g)),@incr:=0,if(@year!=year-1,@incr:=0,@incr:=hr-@hr)) as incr,@player_id:=player_id as player_id,@year as prevYr,@tid as prevTid,@gms as g1,@hr as prevHR,@year:=year as year,@gms:=g as g2,@hr:=hr as hr,@tid:=team_id as team_id FROM (SELECT player_id,team_id,year,SUM(hr) as hr,SUM(g) as g FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY player_id,year) as t1 ORDER BY incr DESC LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY incr DESC;";
     $cols="Player|Year 1|Team|G|HR|Year 2|Team|G|HR|Increase";
     $noResult="No home runs hit";
     $getTeams=1;
     break;
   case 75:
     $query="SELECT player_id,year,team_id,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY w DESC LIMIT 25,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $w=$row['w'];
     if ($w>20) {$w=20;}
      else {$w=floor($w/5)*5;}
     $title="Most $w Win Seasons";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT * FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,COUNT(year) as years FROM players as p,(SELECT player_id,year,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND w>0 GROUP BY player_id,year HAVING SUM(w)>=$w) as pcs WHERE p.player_id=pcs.player_id GROUP BY player_id ORDER BY years DESC,last_name,first_name) as t WHERE years>0 LIMIT $limit";
     $cols="Player|Seasons";
     $noResult="No player has had a $w win season";
     break;
   case 76:
     $subquery="SELECT MIN(year) as year FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY league_id;";
     $subresult=mysqli_query($db,$subquery);
     $row=mysqli_fetch_array($subresult);
     $firstYr=$row['year'];
     $title="Most Wins By A Player Who Pitched In Just One Season";
     $title.="<br/>(Top $limit Players, Current and Inaugural Seasons Ignored)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,mYr,w FROM players as p,(SELECT player_id,MAX(year) as mYr,COUNT(DISTINCT year) as yrs,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(w)>0) as t1 WHERE p.player_id=t1.player_id AND yrs=1 AND mYr!=$lgyear AND mYr!=$firstYr ORDER BY w DESC,last_name,first_name LIMIT $limit";
     $cols="Player|Year|W";
     $noResult="No player has pitched in just one season excluding the current and inaugural ones";
     break;
   case 77:
   case 174:
     switch ($chkDay)
      {
        case 77:
	  $statMost='hr';
	  $table='batting';
	  $statText='home runs';
	  break;
        case 174:
	  $statMost='w';
	  $table='pitching';
	  $statText='wins';
	  break;
      }
     $title="Most Career ".ucwords($statText)." By A Player Who Maxed Out At X In A Season";
     $query="SELECT max$statMost,p.player_id,first_name,last_name,hall_of_fame,minYr,maxYr,car$statMost FROM players as p,(SELECT max$statMost,player_id,minYr,maxYr,car$statMost FROM (SELECT pcb.player_id,MIN(year) as minYr,MAX(year) as maxYr,SUM(pcb.$statMost) as car$statMost,max$statMost FROM players_career_".$table."_stats as pcb,(SELECT player_id,MAX($statMost) as max$statMost FROM (SELECT player_id,year,SUM($statMost) as $statMost FROM players_career_".$table."_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM($statMost)>0) as t1 GROUP BY player_id) as t2 WHERE pcb.player_id=t2.player_id AND pcb.league_id=$lgid AND split_id=1 GROUP BY player_id ORDER BY max$statMost DESC,car$statMost DESC,minYr) as t3 GROUP BY max$statMost) as x WHERE p.player_id=x.player_id ORDER BY max$statMost DESC";
     $cols="Max ".strtoupper($statMost)."|Player|From|To|Career ".strtoupper($statMost);
     $noResult="No $statText hit";
     break;
   case 78:
     $title="Players Who Played For Most Championship Winners";
     if ($showLink==1)
      {
        $pid=$_GET['player_id'];
        $title.="<br/>(Individual Player Listing)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_name,year FROM players as p,(SELECT t1.player_id,t1.team_id,t1.year FROM (SELECT player_id,team_id,year FROM (SELECT player_id,team_id,year FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND player_id=$pid UNION SELECT player_id,team_id,year FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND player_id=$pid) as a GROUP BY player_id,team_id,year) as t1,(SELECT team_id,year FROM team_history WHERE league_id=$lgid AND won_playoffs=1) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY year) as x WHERE p.player_id=x.player_id";
	$cols="Player|Team|Year";
	$noResult="No seasons completed";
		  $getTeams=1;
      }
      else
      {
        $title.="<br/>(Top $limit Players)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,'Show Teams' as showLink,minYr,maxYr,tms,yrs FROM players as p,(SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT team_id) as tms,COUNT(DISTINCT year) as yrs FROM (SELECT t1.player_id,t1.team_id,t1.year FROM (SELECT player_id,team_id,year FROM (SELECT player_id,team_id,year FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 UNION SELECT player_id,team_id,year FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1) as a GROUP BY player_id,team_id,year) as t1,(SELECT team_id,year FROM team_history WHERE league_id=$lgid AND won_playoffs=1) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year) as t3 GROUP BY player_id ORDER BY yrs DESC,maxYr LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY yrs DESC,maxYr";
	$cols="Player|Link|First Title|Last Title|Franchises|Championships";
	$noResult="No seasons completed";
      }
     break;
   case 79:
     $title="Highest Career Times On Base Per Plate Appearance";
     $title.="<br/>(Top $limit Players, Min 500 Career PA)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,minYr,maxYr,h,bb,hp,tob,pa,tobPerPA as avg FROM players as p,(SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,SUM(h) as h,SUM(bb) as bb,SUM(hp) as hp,(SUM(h)+SUM(bb)+SUM(hp)) as tob,SUM(pa) as pa,(SUM(h)+SUM(bb)+SUM(hp))/SUM(pa) as tobPerPA FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(pa)>=500 ORDER BY tobPerPA DESC,tob DESC LIMIT $limit) as pcs WHERE p.player_id=pcs.player_id ORDER BY tobPerPA DESC,tob DESC;";
     $cols="Player|From|To|H|BB|HP|TOB|PA|TOB/PA";
     $noResult="No batting data found";
     break;
   ## case 80: Filed under case 1
   case 81:
     $title="More Strikeouts Than Times On Base";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,minYr,maxYr,k,tob,diff FROM players as p,(SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,SUM(k) as k,(SUM(h)+SUM(bb)+SUM(hp)) as tob,SUM(k)-(SUM(h)+SUM(bb)+SUM(hp)) as diff FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(k)>(SUM(h)+SUM(bb)+SUM(hp)) ORDER BY k DESC,TOB DESC,diff DESC LIMIT $limit) as pcb WHERE p.player_id=pcb.player_id ORDER BY k DESC,TOB DESC,diff DESC";
     $cols="Player|From|To|K|TOB|Diff";
     $noResult="No player has had more strikeouts than times on base";
     break;
   case 82:
     $title="Highest Percentage of Team Wins from One Pitcher";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT tots.team_id as team_name,year,tw,tots.player_id,first_name,last_name,hall_of_fame,w,pct FROM players as p,(SELECT t1.team_id,t1.year,tw,player_id,w,w/tw as pct FROM (SELECT player_id,team_id,year,MAX(w) as w FROM (SELECT player_id,team_id,year,w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 ORDER BY w DESC) as x GROUP BY team_id,year) as t1,(SELECT team_id,year,w as tw FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY pct DESC,w DESC,tw DESC,year LIMIT $limit) as tots WHERE p.player_id=tots.player_id ORDER BY pct DESC,w DESC,tw DESC,year";
     $cols="Team|Year|Team Wins|Player|Wins|Pct of Team";
     $noResult="No player has recorded any wins";
     $getTeams=1;
     break;
   case 83:
     $title="Most Seasons With Exactly 1 Home Run Hit";
     $title.="<br/>(Top $limit Players, Pitchers Excluded)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,yrs FROM players as p,(SELECT player_id,COUNT(DISTINCT year) as yrs FROM (SELECT player_id,year,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(hr)=1) as t1 GROUP BY player_id ORDER BY yrs DESC) as t2 WHERE p.player_id=t2.player_id AND position!=1 ORDER BY yrs DESC LIMIT $limit";
     $cols="Player|1 HR Seasons";
     $noResult="No player has hit exactly 1 home run in a season";
     break;
   case 84:
     $title="Players With Home Runs As Their Only Hits";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,minYr,maxYr,h,hr,pa FROM players as p,(SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,SUM(h) as h,SUM(hr) as hr,SUM(pa) as pa FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(h)=SUM(hr) AND SUM(h)>0 ORDER BY hr DESC,pa DESC LIMIT $limit) as pcb WHERE p.player_id=pcb.player_id ORDER BY hr DESC,pa DESC;";
     $cols="Player|From|To|H|HR|PA";
     $noResult="No player has hit only home runs";
     break;
   case 85:
     $title="Cumulative Franchise Pythagorean Difference";
     $title.="<br/>(Using pythagenpat exponent for pythagorean record)";
     $query="SELECT team_id as team_name,MIN(year) as minYr,MAX(year) as maxYr,COUNT(year) as yrs,SUM(w) as w,SUM(l) as l,SUM(w)/SUM(g) as avg,SUM(rf) as rf,SUM(ra) as ra,SUM(pw) as pw,SUM(pl) as pl,(POW(SUM(rf),POW((SUM(rf)+SUM(ra))/SUM(g),.287))/(POW(SUM(rf),POW((SUM(rf)+SUM(ra))/SUM(g),.287))+POW(SUM(ra),POW((SUM(rf)+SUM(ra))/SUM(g),.287)))) as obp,SUM(pdiff) as pdiff,SUM(pos) as plus,SUM(neg) as neg,SUM(pdiff)/COUNT(year) as era FROM (SELECT team_id,year,g,w,l,rf,ra,ppct,ROUND(g*ppct) as pw,g-ROUND(g*ppct) as pl,w-ROUND(g*ppct) as pdiff,if(w-ROUND(g*ppct)>0,1,0) as pos,if(w-ROUND(g*ppct)<0,1,0) as neg FROM (SELECT thr.team_id,thr.year,g,w,l,rf,ra,(POW(rf,POW((rf+ra)/g,.287))/(POW(rf,POW((rf+ra)/g,.287))+POW(ra,POW((rf+ra)/g,.287)))) as ppct FROM team_history_record as thr,(SELECT thb.team_id,thb.year,thb.r as rf,thp.r as ra FROM team_history_batting_stats as thb,team_history_pitching_stats as thp WHERE thb.team_id=thp.team_id AND thb.year=thp.year AND thb.league_id=$lgid) as t1 WHERE thr.team_id=t1.team_id AND thr.year=t1.year) as t2) as x GROUP BY team_id ORDER BY pdiff DESC,w DESC,rf DESC";
     $cols="Team|From|To|Yrs|W|L|Pct|RF|RA|PythW|PythL|Pyth Pct|Diff|+Yrs|-Yrs|Diff/Yr";
     $noResult="No historical team runs data";
     $getTeams=1;
     break;
   case 86:
     $title="Most Years Between Wins";
     $title.="<br/>(Top $limit Players)";
     $query="SET @wYr:=0;SET @player_id:=-1;SET @pYr:=0;SELECT p.player_id,first_name,last_name,year-wYr as firstyr,year,wYr FROM players as p,(SELECT IF(@player_id!=player_id,@wYr:=0,@wYr:=year-@pYr) as wYr,@player_id:=player_id as player_id,@pYr:=year as year FROM (SELECT player_id,year,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(w)>0) as a ORDER BY player_id,year) as t WHERE p.player_id=t.player_id AND wYr>2 ORDER BY wYr DESC LIMIT $limit;";
     $cols="Player|Last Win|Next Win|Years Between";
     $noResult="No player has had more than 2 years between wins";
     break;
   case 87:
     $title="Worst Records To Make The Postseason";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT th.team_id as team_name,th.year,w,l,pct as winPct,pos as stanPos,won_playoffs FROM team_history as th,team_history_record as thr WHERE th.team_id=thr.team_id AND th.year=thr.year AND th.league_id=thr.league_id AND th.league_id=$lgid AND made_playoffs=1 ORDER BY pct LIMIT $limit;";
     $cols="Team|Year|W|L|Pct|Pos|Champion";
     $noResult="No postseason play";
     $getTeams=1;
     break;
   case 88:
     $title="Lowest Career Runner Thrown Out Percentage";
     $title.="<br/>(Top $limit Players, Minimum 10 Attempts Against)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,sba,rto,csPct as pct,Inn as ip FROM players as p,(SELECT player_id,SUM(sba) as sba,SUM(rto) as rto,SUM(rto)/SUM(sba) as csPct,SUM(ip)+SUM(ipf)/3 as Inn FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position=2 GROUP BY player_id HAVING SUM(sba)>=10 ORDER BY csPct,sba DESC,Inn DESC LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY csPct,sba DESC,Inn DESC;";
     $cols="Player|SBA|RTO|CS%|Inn";
     $noResult="No player has had more than 10 SBA";
     break;
   case 89:
     $awquery="SELECT defense_award_name FROM leagues WHERE league_id=$lgid;";
     $awresult=mysqli_query($db,$awquery);
     $row=mysqli_fetch_array($awresult);
     $awName=$row['defense_award_name'];
     $title="Top $limit Oldest $awName Winners";
     $query="SELECT p.player_id,last_name,first_name,paw.team_id as team_abbr,paw.position,year,date_of_birth,(paw.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,DAYOFYEAR(date_of_birth) as dayBorn FROM players as p,players_awards as paw WHERE p.player_id=paw.player_id AND paw.league_id=$lgid AND award_id=7 ORDER BY age DESC,dayBorn,year,last_name,first_name LIMIT $limit;";
     $cols="Player|Team|Pos|Year|DOB|Age";
     $noResult="No players have won the $awName";
     $getTeams=1;
     break;
   case 90:
     $title="Most Plate Appearances Without a Hit";
     $title.="<br/>(Top $limit Players, Pitchers Excluded)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,team_abbr,year,pa,bb,hp,sf,sh FROM players as p,(SELECT player_id,team_id as team_abbr,year,SUM(pa) as pa,SUM(h) as h,SUM(bb) as bb,SUM(hp) as hp,SUM(sf) as sf,SUM(sh) as sh FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(h)=0 AND SUM(pa)>0) as x WHERE p.player_id=x.player_id AND p.position!=1 ORDER BY pa DESC,year LIMIT $limit";
     $cols="Player|Team|Year|PA|BB|HP|SF|SH";
     $noResult="No players without a hit";
     $getTeams=1;
     break;
   ## case 91: Filed under case 7
   case 92:
     $title="Highest Percentage of Wins Saved";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,w,s,s/w as pct FROM team_history_pitching_stats WHERE league_id=$lgid AND split_id=0 AND w>0 ORDER BY pct DESC,s DESC LIMIT $limit";
     $cols="Team|Year|W|SV|Pct";
     $noResult="No teams have recorded any saves";
     $getTeams=1;
     break;
   case 93:
     $title="Lowest Ratio of Walks to Hit Batsmen";
     $title.="<br/>(Top $limit Players, Minimum 10 Career HP)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,minYr,maxYr,ip,bb,hp,era FROM players as p,(SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,(SUM(ip)+SUM(ipf)/3) as ip,SUM(bb) as bb,SUM(hp) as hp,SUM(bb)/SUM(hp) as era FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(hp)>10 ORDER BY era LIMIT $limit) as t WHERE p.player_id=t.player_id ORDER BY era;";
     $cols="Player|From|To|IP|BB|HP|Ratio";
     $noResult="No players have hit batsmen";
     break;
   case 94:
     $title="Most Years Placing in the League's Top 10";
     $title.="<br/>(Top $limit Players, Stats Include H, 2B, 3B, HR, SB, RBI, R, BB, AVG, W, SV, IP, K, ERA)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,category,minYr,maxYr,yrs,yrsPoss FROM players as p,(SELECT player_id,category,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT year) as yrs,MAX(year)-MIN(year)+1 as yrsPoss FROM players_league_leader WHERE league_id=$lgid AND place<=10 AND category IN (3,6,7,8,9,10,11,12,18,29,32,34,38,40) GROUP BY player_id,category HAVING COUNT(DISTINCT year)>1 ORDER BY yrs DESC,yrsPoss LIMIT $limit) as pll WHERE  p.player_id=pll.player_id ORDER BY yrs DESC,yrsPoss;";
     $cols="Player|Stat|First|Last|Years Placed|Out Of X Years";
     $noResult="No players have finished in the league's top 10 more than once";
     break;
   case 95:
     $title="Most Wins While Pitching For A Losing Team";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_abbr,year,pw,pl,pw/(pw+pl) as obp,tw,tl,pct as avg,pos as stanPos,pw/(pw+pl)-pct as slg FROM players as p,(SELECT player_id,t1.team_id,t1.year,pw,pl,tw,tl,pct,pos FROM (SELECT player_id,team_id,year,w as pw,l as pl FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1) as t1,(SELECT team_id,year,w as tw,l as tl,pct,pos FROM team_history_record WHERE league_id=$lgid AND w<l) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY pw DESC,pct,pl LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY pw DESC,pct,pl";
     $cols="Player|Team|Year|W|L|WPct|Team W|Team L|Pct|Finish|Pct Diff";
     $noResult="No pitcher or team history available";
     $getTeams=1;
     break;
   case 96:
     $title="Most All-Star Players";
     $query="SELECT * FROM (SELECT team_id as team_name,COUNT(player_id) as cnt FROM players_awards WHERE league_id=$lgid AND award_id=9 AND team_id!=0 GROUP BY team_id ORDER BY cnt DESC,year,team_id) as t WHERE cnt>1;";
     $cols="Team|Number of Players";
     $getTeams=1;
     break;
   ## case 97: Filed under case 17
   ## case 98: Filed under case 18
   case 99:
     $title="Highest Career Win/Save Combinations";
     $title.="<br/>(Top $limit Players, Sorted By Lower of W/SV)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,w,l,s,minVal as hide FROM players as p,(SELECT player_id,SUM(w) as w,SUM(l) as l,SUM(s) as s,if(SUM(w)>SUM(s),SUM(s),SUM(w)) as minVal FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(w)>=5 AND SUM(s)>=5 ORDER BY minVal DESC,w DESC,s DESC LIMIT $limit) as t WHERE p.player_id=t.player_id ORDER BY minVal DESC,w DESC,s";
     $cols="Player|W|L|S";
     $noResult="No runs";
     break;
   ## case 100: Filed under case 37
   ## case 101: Filed under case 40
   case 102:
     $query="SELECT player_id,t1.team_id,t1.year,kPerIP FROM (SELECT player_id,team_id,year,SUM(ip)+SUM(ipf)/3 as ip,SUM(k)/(SUM(ip)+SUM(ipf)/3) as kPerIP FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING ip>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.ip>=t2.g ORDER BY kPerIP DESC LIMIT 25,1";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $kPerIP=$row['kPerIP'];
     $kPerIP=floor($kPerIP*10)/10;
     $kPerIP=min($kPerIP,1);
     $title="Number of Pitchers With More Than ".sprintf("%.2f",$kPerIP)." K/IP Per Season";
     if ($showLink==1)
      {
        $yr=$_GET['year'];
        $title.="<br/>(Pitchers With More Than ".sprintf("%.2f",$kPerIP)." K/IP)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_abbr,'$yr' as year,w,l,ip,k,era,whip,kPerIP as kper9 FROM players as p,(SELECT player_id,t1.team_id,w,l,ip,era,whip,k,kPerIP FROM (SELECT player_id,team_id,SUM(w) as w,SUM(l) as l,SUM(ip)+SUM(ipf)/3 as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era,(SUM(ha)+SUM(bb))/(SUM(ip)+SUM(ipf)/3) as whip,SUM(k) as k,SUM(k)/(SUM(ip)+SUM(ipf)/3) as kPerIP FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND year=$yr GROUP BY player_id HAVING ((SUM(k))/(SUM(ip)+SUM(ipf)/3))>=$kPerIP ORDER BY kPerIP DESC) as t1,(SELECT team_id,g FROM team_history_record WHERE league_id=$lgid AND year=$yr) as t2 WHERE t1.team_id=t2.team_id AND t1.ip>=t2.g ORDER BY kPerIP DESC,era,ip DESC) as x WHERE p.player_id=x.player_id ORDER BY kPerIP DESC,era,ip DESC;";
        $cols="Player|Team|Year|W|L|IP|K|ERA|WHIP|K/IP";
	$noResult="No player had more than ".sprintf("%.2f",$kPerIP)." K/IP in $yr";
        $getTeams=1;
      }
      else
      {
	$query="SELECT year,'Show Players' as showLink,SUM(cnt) as cnt FROM (SELECT year,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,t1.team_id,t1.year,ip,kPerIP FROM (SELECT player_id,team_id,year,SUM(ip)+SUM(ipf)/3 as ip,SUM(k)/(SUM(ip)+SUM(ipf)/3) as kPerIP FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING ((SUM(k))/(SUM(ip)+SUM(ipf)/3))>=$kPerIP) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.ip>=t2.g) as x GROUP BY year UNION SELECT DISTINCT year,0 as cnt FROM team_history WHERE league_id=$lgid GROUP BY year) as x1 GROUP BY year ORDER BY year";
   	$cols="Year|Link|Number of Players";
	$noResult="No player has had more than ".sprintf("%.2f",$kPerIP)." K/IP in a season";
      }
     break;
   ## case 103: Filed under case 42
   case 104:
     $title="Most .300 Hitting Seasons By Franchise";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
        $title.="<br/>(Individual Team Listing)";
        $query="SELECT x.player_id,first_name,last_name,hall_of_fame,x.team_id as team_name,year,avg FROM players as p,(SELECT player_id,t1.team_id,t1.year,avg FROM (SELECT player_id,team_id,year,SUM(pa) as pa,SUM(h)/SUM(ab) as avg FROM players_career_batting_stats WHERE league_id=$lgid AND team_id=$tid AND split_id=1 GROUP BY player_id,team_id,year HAVING SUM(ab)>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid AND team_id=$tid) as t2 WHERE t1.year=t2.year AND t1.pa>=(3.1*t2.g) AND avg>=.300) as x WHERE p.player_id=x.player_id ORDER BY avg DESC,year,last_name,first_name";
        $cols="Player|Team|Year|AVG";
      }
      else
      {
	$query="SELECT t.team_id as team_name,'Show Players' as showLink,cnt FROM teams as t,(SELECT team_id,COUNT(*) as cnt FROM (SELECT player_id,t1.team_id,t1.year,avg FROM (SELECT player_id,team_id,year,SUM(pa) as pa,SUM(h)/SUM(ab) as avg FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,team_id,year HAVING SUM(ab)>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.pa>=(3.1*t2.g) AND avg>=.300) as x GROUP BY team_id) as x1 WHERE t.team_id=x1.team_id ORDER BY cnt DESC,name,nickname";
   	$cols="Team|Link|Number of Players";
	$noResult="No teams have had a .300 hitting batter";
      }
     $getTeams=1;
     break;
   case 105:
     $title="Highest Number Of Runs Scored Relative to League";
     $title.="<br/>(Top $limit Teams, SD is number of standard deviations better than league average)";
     $query="SELECT team_id as team_name,ths.year,r,rAvg,rStd,((r-rAvg)/rStd) as SDscore FROM team_history_batting_stats as ths,(SELECT year,league_id,sub_league_id,AVG(r) as rAvg,STDDEV_POP(r) as rStd FROM team_history_batting_stats WHERE league_id=$lgid GROUP BY year,league_id,sub_league_id) as lgBat WHERE ths.league_id=lgBat.league_id AND ths.sub_league_id=lgBat.sub_league_id AND ths.year=lgBat.year ORDER BY SDscore DESC LIMIT $limit";
     $cols="Team|Year|R|Lg R Avg|Lg R Std|SD";
     $noResult="No seasons completed";
     $getTeams=1;
     break;
   ## case 106: Filed under case 1
   case 107:
     $title="Lowest Attendance Relative To League";
     $title.="<br/>(Bottom $limit Teams)";
     $query="SELECT team_id as team_name,thf.year,attendance,lgavg as attAvg,lgstd as attStd,(attendance-lgavg)/lgstd as SDscore FROM team_history_financials as thf,(SELECT year,AVG(attendance) as lgavg,STDDEV(attendance) as lgstd FROM team_history_financials WHERE league_id=$lgid GROUP BY year) as t1 WHERE thf.year=t1.year AND attendance>0 AND thf.league_id=$lgid ORDER BY SDscore LIMIT $limit";
     $cols="Team|Year|Attendance|Lg Avg Att|Lg Att Std|SD";
     $getTeams=1;
     break;
   case 108:
   case 232:
   case 340:
     switch ($chkDay)
      {
        case 108:
	  $statMost='hr';
          $query="SELECT player_id,year,team_id,SUM($statMost) as statVal FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY hr DESC LIMIT 5,1;";
	  $result=mysqli_query($db,$query);
     	  $row=mysqli_fetch_array($result);
	  $statVal=$row['statVal'];
     	  $statVal=floor($statVal/10)*5;
	  $title="Fewest Home Runs In Second Highest Season By A Player Who Only Once Had $statVal+ HR";
	  break;
        case 232:
	  $statMost='rbi';
          $query="SELECT player_id,year,team_id,SUM($statMost) as statVal FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY statVal DESC LIMIT 25,1;";
	  $result=mysqli_query($db,$query);
     	  $row=mysqli_fetch_array($result);
	  $statVal=$row['statVal'];
     	  $statVal=floor(3*$statVal/40)*10;
	  $statVal=min($statVal,100);
	  $title="Fewest RBI In Second Highest Season By A Player Who Only Once Had $statVal+ RBI";
	  break;
        case 340:
	  $statMost='r';
          $query="SELECT player_id,year,team_id,SUM($statMost) as statVal FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY statVal DESC LIMIT 25,1;";
	  $result=mysqli_query($db,$query);
     	  $row=mysqli_fetch_array($result);
	  $statVal=$row['statVal'];
     	  $statVal=floor(3*$statVal/40)*10;
	  $statVal=min($statVal,100);
	  $title="Fewest Runs In Second Highest Season By A Player Who Only Once Had $statVal+ Runs";
	  $statMost='r';
	  break;
      }
     $title.="<br/>(Top $limit Players)";
     $query.="SELECT p.player_id,first_name,last_name,hall_of_fame,yrMax,maxHR,year,$statMost,".$statMost."Diff as diff FROM players as p,(SELECT t2.player_id,t3.year as yrMax,maxHR,t2.year,$statMost,maxHR-$statMost as ".$statMost."Diff FROM (SELECT player_id,year,MAX($statMost) as $statMost FROM (SELECT player_id,year,SUM($statMost) as $statMost FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND year!=$lgyear GROUP BY player_id,year HAVING SUM($statMost)<$statVal AND SUM($statMost)>0 ORDER BY $statMost DESC,player_id,year) as t1 GROUP BY player_id) as t2,(SELECT player_id,year,$statMost as maxHR FROM (SELECT player_id,year,SUM($statMost) as $statMost FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM($statMost)>=$statVal) as t GROUP BY player_id HAVING COUNT(*)=1) as t3 WHERE t2.player_id=t3.player_id ORDER BY $statMost,".$statMost."Diff DESC,year LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY $statMost,".$statMost."Diff DESC,year";
     $cols="Player|Max ".strtoupper($statMost)." Year|Max ".strtoupper($statMost)."|Year 2nd Highest|2nd Highest ".strtoupper($statMost)."|".strtoupper($statMost)." Diff";
     $noResult="No ".strtoupper($statMost)."'s hit";
     break;
   case 109:
     $title="Highest Double Play Rate (DP/Inn)";
     $title.="<br/>(Top $limit Players, Minimum 180 Defensive Innings)";
     $query="SELECT p.player_id,first_name,last_name,t.team_id as team_abbr,year,dp,ip,dp/ip as avg FROM players as p,(SELECT player_id,team_id,year,(SUM(ip)+SUM(ipf)/3) as ip,SUM(dp) as dp FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 GROUP BY player_id,year) as t WHERE p.player_id=t.player_id AND ip>180 ORDER BY avg DESC,dp DESC LIMIT $limit";
     $cols="Player|Team|Year|DP|Inn|Rate";
     $noResult="No players have turned double plays";
     $getTeams=1;
     break;
   case 110:
     $title="Longest Postseason Drought";
     $query="SELECT team_id as team_name,year as year1,IF(drought IS NULL,999,drought) as drought FROM (SELECT t.team_id,name,nickname,t2.year,drought FROM teams as t LEFT JOIN (SELECT team_id,year,MIN(drought) as drought FROM (SELECT team_id,year,$lgyear-year as drought FROM team_history WHERE league_id=$lgid AND made_playoffs=1 ORDER BY drought) as t GROUP BY team_id ORDER BY drought) as t2 ON t.team_id=t2.team_id WHERE t.league_id=$lgid AND allstar_team=0) as t3 ORDER BY drought DESC,name,nickname";
     $cols="Team|Year|Drought";
     $noResult="Not enough seasons played";
     $getTeams=1;
     break;
   case 111:
     $title="Players With A Hit In Their Only At-Bat";
     $query="SELECT player_id,first_name,last_name,team_abbr,year,h,d,t,hr,bb,pa FROM (SELECT p.player_id,first_name,last_name,pcs.team_id as team_abbr,year,SUM(ab) as ab,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(bb) as bb,SUM(pa) as pa FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id) as t WHERE t.ab=1 AND t.h=1 ORDER BY pa DESC,last_name,first_name";
     $cols="Player|Team|Year|H|2B|3B|HR|BB|PA";
     $noResult="No player has had a hit in his only at-bat";
     $getTeams=1;
     break;
   case 112:
     $title="Most Games Played Without A Stolen Base";
     $title.="<br/>(Top $limit Players, Pitchers Excluded)";
     $query="SELECT player_id,first_name,last_name,hall_of_fame,yrs,g,sb,cs FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,CONCAT(MIN(year),'-',MAX(year)) as yrs,SUM(g) as g,SUM(sb) as sb,SUM(cs) as cs FROM players_career_batting_stats as pcs,players as p WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 AND p.position!=1 GROUP BY player_id ORDER BY g DESC,cs DESC) as t WHERE sb=0 LIMIT $limit";
     $cols="Player|Years|G|SB|CS";
     $noResult="No players without a stolen base in their career";
     break;
   case 113:
   case 184:
   case 250:
   case 272:
     switch ($chkDay)
      {
	case 113:
     	  $table='batting';
     	  $statLbl='rbi';
	  break;
	case 184:
     	  $table='batting';
     	  $statLbl='hr';
	  break;
	case 250:
     	  $table='pitching';
     	  $statLbl='w';
	  break;
	case 272:
     	  $table='pitching';
     	  $statLbl='k';
	  break;
      }
     $query="SELECT player_id,year,SUM($statLbl) as statVal FROM players_career_".$table."_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY statVal DESC LIMIT 25,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $statVal=$row['statVal'];
     switch ($chkDay)
      {
        case 113:
          $statVal=floor(3*$statVal/40)*10;
	  $statVal=min($statVal,100);
	  break;
        case 184:
          $statVal=floor(5*$statVal/10);
	  $statVal=min($statVal,25);
	  break;
        case 250:
          $statVal=floor($statVal/2);
	  $statVal=min($statVal,15);
	  break;
        case 272:
          $statVal=floor($statVal/50)*25;
	  $statVal=min($statVal,150);
	  break;
      }
     $title="Most Consecutive $statVal ".strtoupper($statLbl)." Seasons To Start A Career";
     $title.="<br/>(Top $limit Players)";
     $query="SET @player_id:=-1;SET @qual:=1;SELECT p.player_id,first_name,last_name,hall_of_fame,minYr,yrs FROM players as p,(SELECT player_id,MIN(year) as minYr,SUM(qual) as yrs FROM (SELECT if((@player_id!=player_id)&&($statLbl>=$statVal),@qual:=1,if($statLbl<$statVal,@qual:=0,@qual)) as qual,@player_id:=player_id as player_id,year,$statLbl FROM (SELECT player_id,year,SUM($statLbl) as $statLbl FROM players_career_".$table."_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY player_id,year) as t1) as t2 GROUP BY player_id HAVING SUM(qual)>1 ORDER BY yrs DESC,minYr LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY yrs DESC,minYr";
     $cols="Player|Debut|Seasons";
     $noResult="No players have had consecutive $statVal ".strtoupper($statLbl)." seasons to start a career";
     break;
   case 114:
     $title="Smallest Difference Between OBP and AVG Among Batting Title Winners";
     $title.="<br/>(Top $limit Players, Pitchers Excluded)";
//     $query="SELECT year,sub_league_id as sl_name,t1.player_id,first_name,last_name,hall_of_fame,MAX(avg) as avg,obp,obp-avg as diff FROM players as p,(SELECT player_id,pcb.team_id,sub_league_id,pcb.year,th.g,SUM(h)/SUM(ab) as avg,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf)) as obp,SUM(pa) as pa FROM players_career_batting_stats as pcb,team_history_record as th WHERE pcb.team_id=th.team_id AND pcb.year=th.year AND pcb.league_id=$lgid AND split_id=1 GROUP BY player_id,year,sub_league_id HAVING SUM(pa)>=3.1*th.g ORDER BY year,avg DESC) as t1 WHERE p.player_id=t1.player_id GROUP BY year,sub_league_id ORDER BY diff LIMIT $limit";

     $query="SELECT year,sub_league_id as sl_name,x.player_id,first_name,last_name,hall_of_fame,avg,obp,obp-avg as diff FROM players as p,(SELECT pll.player_id,SUM(h)/SUM(ab) as avg,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf)) as obp,pll.year,pll.sub_league_id FROM (SELECT player_id,sub_league_id,year FROM players_league_leader WHERE league_id=$lgid AND place=1 AND category=18) as pll,players_career_batting_stats as pcb,team_history as th WHERE th.sub_league_id=pll.sub_league_id AND th.league_id=$lgid AND pcb.league_id=$lgid AND pll.player_id=pcb.player_id AND pll.year=pcb.year AND pll.year=th.year AND split_id=1 GROUP BY player_id,year,sub_league_id ORDER BY year,sub_league_id) as x WHERE p.player_id=x.player_id ORDER BY diff LIMIT $limit";
     $cols="Year|League|Player|AVG|OBP|Diff";
     $noResult="No batting title winners recorded";
     $getSubLeagues=1;
     break;
   ## case 115: Filed under case 23
   ## case 116: Filed under case 24
   ## case 117: Filed under case 24
   ## case 118: Filed under case 3
   case 119:
     $title="Highest Percentage of Team Runs Scored By One Batter";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT tots.team_id as team_name,year,tr,tots.player_id,first_name,last_name,hall_of_fame,r,pct FROM players as p,(SELECT t1.team_id,t1.year,tr,player_id,r,r/tr as pct FROM (SELECT player_id,team_id,year,MAX(r) as r FROM (SELECT player_id,team_id,year,r FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 ORDER BY r DESC) as x GROUP BY team_id,year) as t1,(SELECT team_id,year,r as tr FROM team_history_batting_stats WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY pct DESC,r DESC,tr DESC,year LIMIT $limit) as tots WHERE p.player_id=tots.player_id ORDER BY pct DESC,r DESC,tr DESC,year";
     $cols="Team|Year|Team Runs|Player|R|Pct";
     $noResult="No player has score any runs";
     $getTeams=1;
     break;
   case 120:
     $title="Highest Percentage of Hits As Home Runs";
     $title.="<br/>(Top $limit Players, Minimum 200 career hits)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,pa,h/ab as avg,hr,h,hr/h as pct FROM players as p,(SELECT player_id,SUM(pa) as pa,SUM(ab) as ab,SUM(hr) as hr,SUM(h) as h FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as t WHERE p.player_id=t.player_id AND h>200 ORDER BY pct DESC LIMIT $limit";
     $cols="Player|PA|AVG|HR|H|Pct";
     $noResult="No players have hit home runs";
     break;
   case 121:
     $title="Youngest Player To Lead The League";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,last_name,first_name,hall_of_fame,date_of_birth,year,category,(pll.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,DAYOFYEAR(date_of_birth) as dayBorn FROM players as p,players_league_leader as pll WHERE p.player_id=pll.player_id AND pll.league_id=$lgid AND place<=1 AND category IN (3,6,7,8,9,10,11,12,18,29,32,34,38,40) ORDER BY age,dayBorn DESC,year,category,last_name,first_name LIMIT $limit";
     $cols="Player|Birthday|Year|Stat|Age";
     $noResult="No league leaders recorded";
     break;
   case 122:
     $title="Most Holds Without Starting Or Finishing A Game";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,t.team_id as team_abbr,year,ip,hld,era FROM players as p,(SELECT player_id,team_id,year,(SUM(ip)+SUM(ipf)/3) as ip,SUM(hld) as hld,SUM(gs) as gs,SUM(gf) as gf,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year) as t WHERE p.player_id=t.player_id AND hld>0 AND gs=0 AND gf=0 ORDER BY hld DESC,year LIMIT $limit;";
     $cols="Player|Team|Year|IP|HLD|ERA";
     $noResult="No pitcher has recorded a hold without starting or finishing a game";
     $getTeams=1;
     break;
   case 123:
     $awquery="SELECT pitcher_award_name FROM leagues WHERE league_id=$lgid;";
     $awresult=mysqli_query($db,$awquery);
     $row=mysqli_fetch_array($awresult);
     $poyName=$row['pitcher_award_name'];
     $title="Most Losses The Season Before Winning The $poyName";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,g,gs,w,l,ip FROM players as p,(SELECT t1.player_id,t2.year,g,gs,w,l,ip FROM (SELECT player_id,year FROM players_awards WHERE league_id=$lgid AND award_id=4) as t1,(SELECT player_id,year,SUM(w) as w,SUM(l) as l,SUM(g) as g,SUM(gs) as gs,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year) as t2 WHERE t1.player_id=t2.player_id AND (t2.year=t1.year-1) ORDER BY l DESC,w LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY l DESC,w";
     $cols="Player|Year|G|GS|W|L|IP";
     $noResult="No pitcher has won the $poyName";
     break;
   case 125:
     $title="Largest Improvement in Team Wins";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT t1.team_id as team_name,t1.year as year1,t1.w,t1.pos as stanPos1,t2.year as year,t2.w as w2,t2.pos as stanPos2,t2.w-t1.w as diff FROM team_history_record as t1,team_history_record as t2 WHERE t1.team_id=t2.team_id AND t1.league_id=t2.league_id AND t1.league_id=$lgid AND t1.year=(t2.year-1) ORDER BY diff DESC,year LIMIT $limit;";
     $cols="Team|Year 1|W's|Finish|Year 2|W's|Finish|Improvement";
     $getTeams=1;
     break;
   case 126:
     $title="Most Strikeouts by Pitcher Height";
     $title.="<br/>(Earliest Occurrence Shown)";
     $query="SELECT height,player_id,first_name,last_name,hall_of_fame,team_abbr,year,MAX(k) as k FROM (SELECT CONCAT(floor((height)/12),'\' ',floor(mod((height),12)),'\"') as height,height as rawHt,player_id,first_name,last_name,hall_of_fame,team_abbr,k,year FROM (SELECT p.player_id,last_name,first_name,hall_of_fame,floor(height*0.393700787) as height,pcs.team_id as team_abbr,SUM(k) as k,year FROM players as p,players_career_pitching_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND pcs.split_id=1 GROUP BY player_id,year ORDER BY height,k DESC,year) as t) as x GROUP BY rawHt ORDER BY rawHt;";
     $cols="Height|Player|Team|Year|K";
     $noResult="No strikeouts recorded";
     $getTeams=1;
     break;
   case 127:
     $title="Postseason Teams Closest To Extinction: Fewest Players Still Active";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
        $yr=$_GET['year'];
        $title.="<br/>(Remaining Active Players)";
        $query="SELECT if(position=1,role,position) as position,player_id,first_name,last_name,hall_of_fame,organization_id as team_name FROM players WHERE retired=0 AND player_id IN (SELECT player_id FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND year=$yr AND team_id=$tid UNION SELECT player_id FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND year=$yr AND team_id=$tid)";
        $cols="Pos|Player|Current Organization";
      }
      else
      {
        $title.="<br/>(Top $limit Teams)";
        $query="SELECT team_name,t1.year,won_playoffs,'Show Players' as showLink,cnt FROM team_history as t1,(SELECT team_id as team_name,year,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,team_id,year FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND year!=$lgyear AND player_id IN (SELECT player_id FROM players WHERE retired=0) UNION SELECT player_id,team_id,year FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND year!=$lgyear AND player_id IN (SELECT player_id FROM players WHERE retired=0)) as t GROUP BY team_id,year ORDER BY cnt,year) as t2 WHERE t1.team_id=t2.team_name AND t1.year=t2.year AND made_playoffs=1 LIMIT $limit";
        $cols="Team|Year|Link|Remaining Active Players";
      }
     $getTeams=1;
     break;
   case 128:
     $title="Most Common Birthday";
     if ($showLink==1)
      {
        $bday=$_GET['bday'];
        $title.="<br/>(Players born on $bday)";
        $query="SELECT if(position=1,role,position) as position,player_id,first_name,last_name,hall_of_fame,date_of_birth FROM players WHERE date_of_birth LIKE '%-$bday' ORDER BY date_of_birth,last_name,first_name;";
        $cols="Pos|Player|Birthday";
      }
      else
      {
        $title.="<br/>(Top $limit Birthdays)";
        $query="SELECT MONTH(date_of_birth) as bmonth,DAY(date_of_birth) as bday,'Show Players' as showLink,COUNT(DISTINCT player_id) as players FROM players GROUP BY bmonth,bday ORDER BY players DESC,bmonth,bday LIMIT $limit";
        $cols="Month-Day|Link|Count";
      }
     break;
   case 129:
     $title="Percentage Of Draftees Who've Reached the Majors (with any team)";
     $query="SELECT a.draft_team_id as team_name,pCnt,dCnt,pCnt/dCnt as pct FROM (SELECT draft_team_id,COUNT(DISTINCT player_id) as dCnt FROM players WHERE draft_league_id=$lgid AND draft_team_id!=0 GROUP BY draft_team_id) as a,(SELECT draft_team_id,COUNT(DISTINCT p.player_id) as pCnt FROM players as p,(SELECT team_id,year,player_id FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 UNION SELECT team_id,year,player_id FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1) as pcs WHERE p.player_id=pcs.player_id AND draft_team_id!=0 GROUP BY draft_team_id) as b WHERE a.draft_team_id=b.draft_team_id ORDER BY pct DESC,dCnt DESC";
     $cols="Team|Players to Reach Majors|Players Drafted|Pct";
     $noResult="No draft history";
     $getTeams=1;
     break;
   case 130:
     $title="Percentage of Players With X Hits Divided In Groups of 100 Hits";
     if ($showLink==1)
      {
        $bucket=$_GET['bucket'];
        switch ($bucket)
	 {
 	   case -1: $min=0;$max=0;  break;
 	   case 0 : $min=1;$max=99; break;
 	   default: $min=100*$bucket;$max=100*$bucket+99; break;
	 }
        $title.="<br/>(Players with $min-$max Hits)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,g,pa,h,d,t,hr,bb,sb,avg FROM players as p,(SELECT player_id,SUM(g) as g,SUM(pa) as pa,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(bb) as bb,SUM(sb) as sb,if(SUM(ab)=0,0,SUM(h)/SUM(ab)) as avg FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(h)>=$min AND SUM(h)<=$max) as x WHERE p.player_id=x.player_id ORDER BY h DESC,avg DESC";
        $cols="Player|G|PA|H|2B|3B|HR|BB|SB|AVG";
      }
      else
      {
        $query="SELECT bucket as hide,if(bucket=-1,0,if(bucket=0,CONCAT('1-',100-1),CONCAT(bucket*100,'-',bucket*100+100-1))) as bucket,'Show Players' as showLink,COUNT(DISTINCT player_id) as players,COUNT(DISTINCT player_id)/(SELECT COUNT(DISTINCT player_id) FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1) as longPct FROM (SELECT if(h=0,-1,FLOOR(h/100)) as bucket,player_id,h FROM (SELECT player_id,SUM(h) as h FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id ORDER BY h DESC) as t1) as t2 GROUP BY bucket ORDER BY hide DESC";
        $cols="Bucket|Link|Players|Pct";
      }
     break;
   case 131:
     $title="Seasons Most Out of Line With Team History";
     $title.="<br/>(Top $limit Teams, SD is number of standard deviations different from average)";
     $query="SELECT thr.team_id as team_name,year,pos as stanPos,w,l,thr.pct as ops,gb,pctavg as avg,pctstd as obp,ABS((pct-pctavg)/pctstd) as SDscore FROM (SELECT * FROM team_history_record WHERE league_id=$lgid) as thr,(SELECT team_id,COUNT(DISTINCT year) as yrs,AVG(pct) as pctavg,STDDEV(pct) as pctstd FROM team_history_record WHERE league_id=$lgid GROUP BY team_id ORDER BY pctstd,pctavg DESC) as t1 WHERE thr.team_id=t1.team_id ORDER BY SDScore DESC LIMIT $limit";
     $cols="Team|Year|Finish|W|L|Pct|GB|Avg Pct|Pct StDev|SD";
     $noResult="Not enough seasons";
     $getTeams=1;
     break;
   case 132:
     $title="Largest Drop In Home Runs With No Significant Drop In Plate Appearances";
     $title.="<br/>(Top $limit Players, Min 80% PA in 2nd season)";
     $query="SET @player_id:=0;SET @year:=0;SET @hr:=0;SET @pa:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,year-1,hr+hrDrop,year,hr,hrDrop FROM players as p,(SELECT if(@player_id=player_id,if(@year:=year-1,if(pa>=0.8*@pa,@hr-hr,0),0),0) as hrDrop,@player_id:=player_id as player_id,@year:=year as year,@hr:=hr as hr,@pa:=pa as pa FROM (SELECT player_id,year,SUM(hr) as hr,SUM(pa) as pa FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY player_id,year) as t1 ORDER BY hrDrop DESC,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|Year|HR|Year|HR|Diff";
     $noResult="Not enough seasons";
     break;
   case 134:
     $title="Lowest Batting Average While Hitting X Home Runs";
		 $title.="<br/>(First Occurrence)";
		 $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_abbr,year,hr,avg FROM players as p,(SELECT hr,player_id,team_id,year,avg FROM (SELECT player_id,team_id,year,SUM(hr) as hr,SUM(h)/SUM(ab) as avg FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(hr)>0 ORDER BY hr DESC,avg,year) as t GROUP BY hr ORDER BY hr DESC) as x WHERE p.player_id=x.player_id ORDER BY hr DESC;";
     $cols="Player|Team|Year|HR|AVG";
     $noResult="No players have hit home runs";
     $getTeams=1;
     break;
   case 135:
     $title="Most Hits Without A Single";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT * FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr FROM players_career_batting_stats as pcs,players as p WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY pcs.player_id,year ORDER BY h DESC,hr DESC,t DESC,d DESC) as t WHERE h=(d+t+hr) LIMIT $limit;";
     $cols="Player|Team|Year|H|2B|3B|HR";
     $noResult="No player has managed a hit without a single";
     $getTeams=1;
     break;
   case 136:
     $title="Number Of Pitchers With Less Than .5 K/IP By Season";
     if ($showLink==1)
      {
        $year=$_GET['year'];
        $title.="<br/>($year)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_abbr,w,l,s,ip,era,k,pct as avg FROM players as p,(SELECT player_id,t1.team_id,t1.year,w,l,s,ip,era,k,pct FROM (SELECT player_id,team_id,year,SUM(w) as w,SUM(l) as l,SUM(s) as s,SUM(ip)+SUM(ipf)/3 as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era,SUM(k) as k,SUM(k)/(SUM(ip)+SUM(ipf)/3) as pct FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND year=$year GROUP BY player_id HAVING ip>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.ip>=t2.g AND pct<.5) as x WHERE p.player_id=x.player_id ORDER BY avg,ip DESC";
	$cols="Player|Team|W|L|SV|IP|ERA|K|K/IP";
	$getTeams=1;
      }
      else
      {
        $query="SELECT year,'Show Players' as showLink,SUM(cnt) as cnt FROM (SELECT year,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,t1.team_id,t1.year,ip,pct FROM (SELECT player_id,team_id,year,SUM(ip)+SUM(ipf)/3 as ip,SUM(k)/(SUM(ip)+SUM(ipf)/3) as pct FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING ip>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.ip>=t2.g AND pct<.5) as x GROUP BY year UNION SELECT DISTINCT year,0 as cnt FROM team_history WHERE league_id=$lgid GROUP BY year) as x1 GROUP BY year ORDER BY year";
        $cols="Year|Link|Players";
      }
     break;
   ## case 137: Filed under case 21
   case 138:
     $title="Most Plate Appearances With 0 Home Runs and 0 Stolen Bases in a Season";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT player_id,first_name,last_name,hall_of_fame,team_abbr,year,pa FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,SUM(pa) as pa,SUM(hr) as hr,SUM(sb) as sb FROM players_career_batting_stats as pcs,players as p WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY pa DESC) as t WHERE hr=0 AND sb=0 LIMIT $limit";
     $cols="Player|Team|Year|PA";
     $noResult="No players with 0 HR and 0 SB in any season";
     $getTeams=1;
     break;
   case 139:
     $title="Lowest Percentage of Team Losses By Team's Losingest Pitcher";
     $title.="<br/>(Top $limit Players, ties ignored)";
     $query="SELECT tots.team_id as team_name,year,tl,tots.player_id,first_name,last_name,hall_of_fame,l,pct FROM players as p,(SELECT t1.team_id,t1.year,tl,player_id,l,l/tl as pct FROM (SELECT player_id,team_id,year,MAX(l) as l FROM (SELECT player_id,team_id,year,l FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 ORDER BY l DESC) as x GROUP BY team_id,year) as t1,(SELECT team_id,year,w as tw,l as tl FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY pct,l DESC,tl DESC,year LIMIT $limit) as tots WHERE p.player_id=tots.player_id";
     $cols="Team|Year|L|Player|L|Pct";
     $noResult="No historical data";
     $getTeams=1;
     break;
   case 140:
     $title="Luckiest Teams Based on Pythagorean Record";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,pos as stanPos,w,l,pct as avg,gb,rf,ra,ROUND(g*ppct) as pw,g-ROUND(g*ppct) as pl,ppct as obp,w-ROUND(g*ppct) as pdiff FROM (SELECT thr.team_id,thr.year,pos,g,w,l,pct,gb,rf,ra,(POW(rf,POW((rf+ra)/g,.287))/(POW(rf,POW((rf+ra)/g,.287))+POW(ra,POW((rf+ra)/g,.287)))) as ppct FROM team_history_record as thr,(SELECT thb.team_id,thb.year,thb.r as rf,thp.r as ra FROM team_history_batting_stats as thb,team_history_pitching_stats as thp WHERE thb.team_id=thp.team_id AND thb.year=thp.year AND thb.league_id=$lgid) as t1 WHERE thr.team_id=t1.team_id AND thr.year=t1.year AND rf>0 AND ra>0) as t2 ORDER BY pdiff DESC LIMIT $limit";
     $cols="Team|Year|Finish|W|L|Pct|GB|RF|RA|PythW|PythL|Pyth Pct|PDiff";
     $noResult="No historical data";
     $getTeams=1;
     break;
   case 141:
     $title="Most Years Between Triples";
     $title.="<br/>(Top $limit Players)";
     $query="SET @tYr:=0;SET @player_id:=-1;SET @pYr:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,year-tYr as firstyr,year,tYr FROM players as p,(SELECT IF(@player_id!=player_id,@tYr:=0,@tYr:=year-@pYr) as tYr,@player_id:=player_id as player_id,@pYr:=year as year FROM (SELECT player_id,year,SUM(t) as t FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(t)>0) as a ORDER BY player_id,year) as t WHERE p.player_id=t.player_id AND tYr>2 ORDER BY tYr DESC LIMIT $limit";
     $cols="Player|Last Triple|Next Triple|Years";
     $noResult="No historical data";
     break;
   case 142:
     $title="Most Seasons Appeared In Prior To First Home Run";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT x.player_id,first_name,last_name,hall_of_fame,debut,firstHR,firstHR-debut as yrs,seasons FROM players as p,(SELECT a.player_id,COUNT(DISTINCT year) as seasons,MIN(b.year) as debut,firstHR FROM (SELECT player_id,MIN(year) as firstHR FROM (SELECT player_id,year,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(hr)>0 ORDER BY player_id,year) as t1 GROUP BY player_id) as a,(SELECT player_id,year,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year) as b WHERE a.player_id=b.player_id AND b.year<firstHR GROUP BY player_id) as x WHERE p.player_id=x.player_id AND position!=1 ORDER BY seasons DESC,yrs DESC,last_name,first_name LIMIT $limit";
     $cols="Player|Debut|First Home Run|Years|Seasons";
     $noResult="No historical data";
     break;
   ## case 143: Filed under case 18
   ## case 144: Filed under case 17
   case 145:
     $title="Most Seasons Appeared In Prior To First Win";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT x.player_id,first_name,last_name,hall_of_fame,debut,firstW,firstW-debut as yrs,seasons FROM players as p,(SELECT a.player_id,COUNT(DISTINCT year) as seasons,MIN(b.year) as debut,firstW FROM (SELECT player_id,MIN(year) as firstW FROM (SELECT player_id,year,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(w)>0 ORDER BY player_id,year) as t1 GROUP BY player_id) as a,(SELECT player_id,year,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year) as b WHERE a.player_id=b.player_id AND b.year<firstW GROUP BY player_id) as x WHERE p.player_id=x.player_id ORDER BY seasons DESC,yrs DESC,last_name,first_name LIMIT $limit";
     $cols="Player|Debut|First Win|Years|Seasons";
     $noResult="No historical data";
     break;
   ## case 146: Filed under case 1
   case 147:
     $title="Most Frustrated Playoff Teams";
     $query="SELECT team_id as team_name,won,made,won/made as pct FROM (SELECT t1.team_id,made,if(won IS NULL,0,won) as won FROM (SELECT team_id,COUNT(DISTINCT year) as made FROM team_history WHERE league_id=$lgid AND made_playoffs=1 GROUP BY team_id) as t1 LEFT JOIN (SELECT team_id,COUNT(DISTINCT year) as won FROM team_history WHERE league_id=$lgid AND won_playoffs=1 GROUP BY team_id) as t2 ON t1.team_id=t2.team_id) as x ORDER BY pct,made DESC,won;";
     $cols="Team|Won Championship|Made Playoffs|Pct";
     $noResult="No team history";
     $getTeams=1;
     break;
   case 148:
     $title="Largest Changes In League Leading Stats";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT sub_league_id as sl_name,category,year1,x2.player_id as player_id2,first_name2,last_name2,amt1,year2,player_id2 as player_id,first_name,last_name,amt2,pct FROM players as p,(SELECT sub_league_id,category,year1,p.player_id,first_name as first_name2,last_name as last_name2,amt1,year2,player_id2,amt2,pct FROM players as p,(SELECT a.sub_league_id,a.category,a.year as year1,a.player_id,a.amount as amt1,b.year as year2,b.player_id as player_id2,b.amount as amt2,ABS((b.amount-a.amount)/a.amount) as pct FROM players_league_leader as a,players_league_leader as b WHERE a.player_id<b.player_id AND a.league_id=$lgid AND b.league_id=$lgid AND a.sub_league_id=b.sub_league_id AND a.year=b.year-1 AND a.category=b.category AND a.category IN (3,6,7,8,9,10,11,12,18,29,32,34,38,40) AND a.place=1 AND b.place=1 ORDER BY pct DESC LIMIT $limit) as x1 WHERE p.player_id=x1.player_id) as x2 WHERE p.player_id=x2.player_id2";
     $cols="League|Stat|Year|Player|Value|Year|Player|Value|Pct Diff";
     $noResult="No recorded league leaders";
     $getSubLeagues=1;
     break;
   case 149:
     $title="Fewest Runs Scored Per Game By A Division Winner";
     $query="SELECT thb.team_id as team_name,thb.year,w,l,pct as avg,r,r/thr.g as era FROM team_history_batting_stats as thb,team_history_record as thr WHERE thb.team_id=thr.team_id AND thb.year=thr.year AND pos=1 AND thb.league_id=$lgid AND r>0 ORDER BY era,r LIMIT $limit";
     $cols="Team|Year|W|L|Pct|R|R/G";
     $noResult="No team history";
     $getTeams=1;
     break;
   case 150:
     $title="Most Saves While Finishing All Games In Which A Player Appeared";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,SUM(w) as w,SUM(l) as l,SUM(s) as s,SUM(g) as g,SUM(ip)+SUM(ipf)/3 as ip FROM players as p,players_career_pitching_stats as pcb WHERE p.player_id=pcb.player_id AND pcb.league_id=$lgid AND pcb.split_id=1 GROUP BY player_id,year HAVING SUM(gf)=SUM(g) AND SUM(s)>0 ORDER BY s DESC,g DESC,ip DESC LIMIT $limit";
     $cols="Player|Year|W|L|SV|G|IP";
     $noResult="No player has exclusively finished games in a season";
     break;
   case 151:
     $title="More Home Runs In The Postseason Than The Regular Season";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_abbr,year,hr,phr FROM players as p,(SELECT t1.player_id,team_id,t1.year,hr,phr FROM (SELECT player_id,team_id,year,SUM(hr) as phr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=21 GROUP BY player_id,team_id,year) as t1,(SELECT player_id,year,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year) as t2 WHERE t1.player_id=t2.player_id AND t1.year=t2.year AND phr>hr ORDER BY phr DESC,hr,year) as x WHERE p.player_id=x.player_id LIMIT $limit";
     $cols="Player|Team|Year|Reg HR|PS HR";
     $noResult="No player has had more home runs in the postseason";
     break;
   case 152:
     $title="Most Defensive Innings At Catcher Without Throwing Out A Runner";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT t.player_id,first_name,last_name,hall_of_fame,t.team_id as team_abbr,year,sba,rto,ip FROM players as p,(SELECT player_id,team_id,year,SUM(sba) as sba,SUM(rto) as rto,(SUM(ip)+SUM(ipf)/3) as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position=2 GROUP BY player_id,year) as t WHERE p.player_id=t.player_id AND rto=0 AND sba>0 ORDER BY ip DESC,sba DESC LIMIT $limit";
     $cols="Player|Team|Year|SBA|RTO|IP";
     $noResult="No catchers have gone without throwing out a runner";
     $getTeams=1;
     break;
   case 153:
     $title="Most Consecutive Seasons Playing The Same Position For The Same Team";
     $title.="<br/>(Top $limit Players by Seasons, Then Innings)";
     $query="SET @player_id:=-1;SET @team_id:=-1;SET @position:=-1;SET @year:=-1;SET @strk:=0;SET @strkID:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_name,x.position,minYr,maxYr,inn as fip,yrs FROM players as p,(SELECT strkID,max(strk) as yrs,player_id,team_id,position,MIN(year) as minYr,MAX(year) as maxYr,SUM(inn) as inn FROM (SELECT if((@player_id!=player_id),@strkID:=1,if(((@team_id!=team_id)||(@position!=position)||(@year!=(year-1))),@strkID:=@strkID+1,@strkID)) as strkID,if(((@player_id!=player_id)||(@team_id!=team_id)||(@position!=position)||(@year!=(year-1))),@strk:=1,@strk:=@strk+1) as strk,@player_id:=player_id as player_id,@team_id:=team_id as team_id,@position:=position as position,@year:=year as year,inn FROM (SELECT player_id,team_id,position,year,ip+ipf/3 as inn FROM `players_career_fielding_stats` WHERE league_id=$lgid AND split_id<=1 AND position>1 AND position<10 ORDER BY player_id,team_id,position,year) as t1) as t2 GROUP BY player_id,strkID ORDER BY yrs DESC,inn DESC LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|Team|Position|Start|End|Inn|Seasons";
     $noResult="No fielding data stored";
     $getTeams=1;
     break;
   case 154:
     $awquery="SELECT mvp_award_name,pitcher_award_name,rookie_award_name,defense_award_name FROM leagues WHERE league_id=$lgid;";
     $awresult=mysqli_query($db,$awquery);
     $row=mysqli_fetch_array($awresult);
     $awName1=$row['mvp_award_name'];
     $awName2=$row['pitcher_award_name'];
     $awName3=$row['rookie_award_name'];
     $awName4=$row['defense_award_name'];
     $title="Players To Win A $awName4, End Of Season Award, And Be An All-Star In The Same Season";
     $title.="<br/>(EOS Awards: $awName1, $awName2, $awName3)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,team_name,year,if(award_id=4,'$awName2',if(award_id=5,'$awName1','$awName3')) as award,x.position FROM players as p,(SELECT t1.player_id,t1.team_id as team_name,award_id,position,t1.year FROM (SELECT player_id,team_id,position,year FROM players_awards WHERE league_id=$lgid AND award_id=7) as t1,(SELECT player_id,year FROM players_awards WHERE league_id=$lgid AND award_id=9) as t2,(SELECT player_id,year,award_id FROM players_awards WHERE league_id=$lgid AND award_id IN (4,5,6) GROUP BY player_id) as t3 WHERE t1.player_id=t2.player_id AND t1.player_id=t3.player_id AND t2.player_id=t3.player_id AND t1.year=t2.year AND t1.year=t3.year AND t2.year=t3.year) as x WHERE p.player_id=x.player_id ORDER BY year,last_name,first_name";
     $cols="Player|Team|Year|EOS Award|$awName4";
     $noResult="No player has won all three honors in the same season";
     $getTeams=1;
     break;
   ## case 155: Filed under case 24
   case 156:
     $title="Fewest Career Games Played By An All-Star";
     $title.="<br/>(Top $limit Players, Pitchers Excluded)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,yrs,g FROM players as p,(SELECT t1.player_id,yrs,g FROM (SELECT player_id,COUNT(DISTINCT year) as yrs,SUM(g) as g FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as t1,(SELECT DISTINCT player_id FROM players_awards WHERE league_id=$lgid AND award_id=9) as t2 WHERE t1.player_id=t2.player_id ORDER BY g,yrs) as x WHERE p.player_id=x.player_id AND p.position!=1 LIMIT $limit";
     $cols="Player|Seasons Played|G";
     $noResult="No all-stars recorded";
     break;
   ## case 157: Filed under case 23
   ## case 158: Filed under case 24
   ## case 159: Filed under case 37
   case 160:
     $query="SELECT player_id,year,team_id,SUM(h) as h FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY h DESC LIMIT 25,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $h=$row['h'];
     if ($h>200) {$h=200;}
      else {$h=floor($h/20)*20;}
     $title="Most Players with $h or More Hits";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT * FROM (SELECT pcs.team_id as team_name,pcs.year,count(player_id) as cnt FROM players_career_batting_stats as pcs,team_history as th WHERE pcs.team_id=th.team_id AND pcs.year=th.year AND pcs.league_id=$lgid AND split_id=1 AND h>=$h GROUP BY pcs.team_id,year ORDER BY cnt DESC,year,team_name) as t WHERE cnt>0 LIMIT $limit;";
     $cols="Team|Year|Number of Players";
     $noResult="No teams with players with $h hits in any season";
     $getTeams=1;
     break;
   case 161:
     $title="Identical 2B's, 3B's, and HR's in a season";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,pcb.team_id as team_abbr,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(ab) as ab,SUM(h)/SUM(ab) as avg FROM players_career_batting_stats as pcb,players as p WHERE p.player_id=pcb.player_id AND pcb.league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(d)=SUM(t) AND SUM(d)=SUM(hr) AND SUM(d)>1 ORDER BY hr DESC,ab DESC,year LIMIT $limit";
     $cols="Player|Year|Team|H|2B|3B|HR|AB|AVG";
     $getTeams=1;
     $noResult="No player has had an identical number of 2B's, 3B's, and HR's with more than 1 of each.";
     break;
   case 162:
     $title="Most Batters Faced Per Game";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,CONCAT(MIN(year),'-',MAX(year)) as years,SUM(bf) as bf,SUM(g) as g,SUM(bf)/SUM(g) as era FROM players_career_pitching_stats as pcb,players as p WHERE p.player_id=pcb.player_id AND pcb.league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(g)>=5 ORDER BY era DESC LIMIT $limit";
     $cols="Player|Years|BF|G|BF/G";
     $noResult="No pitching stats";
     break;
   ## case 163: Filed under case 3
   case 164:
     $title="Number of .500+ SLG's Per Season";
     if ($showLink==1)
      {
        $year=$_GET['year'];
        $title.="<br/>($year)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_name,pa,h,d,t,hr,sb,bb,avg,slg FROM players as p,(SELECT player_id,t1.team_id,pa,h,d,t,hr,sb,bb,avg,slg FROM (SELECT player_id,team_id,year,SUM(pa) as pa,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(sb) as sb,SUM(bb) as bb,SUM(h)/SUM(ab) as avg,((SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab)) as slg FROM players_career_batting_stats WHERE league_id=$lgid AND year=$year AND split_id=1 GROUP BY player_id,year HAVING SUM(ab)>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid AND year=$year) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.pa>=(3.1*t2.g) AND slg>=.500) as x WHERE p.player_id=x.player_id ORDER BY slg DESC,last_name,first_name";
	$cols="Player|Team|PA|H|2B|3B|HR|SB|BB|AVG|SLG";
	$getTeams=1;
      }
      else
      {
        $query="SELECT year,'Show Players' as showLink,SUM(cnt) as cnt FROM (SELECT year,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,t1.team_id,t1.year,slg FROM (SELECT player_id,team_id,year,SUM(pa) as pa,((SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab)) as slg FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(ab)>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.pa>=(3.1*t2.g) AND slg>=.500) as x GROUP BY year UNION SELECT DISTINCT year,0 as cnt FROM team_history WHERE league_id=$lgid GROUP BY year) as x1 GROUP BY year ORDER BY year";
        $cols="Year|Link|Players";
      }
     $noResult="No batting stats";
     break;
   case 165:
     $awquery="SELECT defense_award_name FROM leagues WHERE league_id=$lgid;";
     $awresult=mysqli_query($db,$awquery);
     $row=mysqli_fetch_array($awresult);
     $awName=$row['defense_award_name'];
     $title="Most Consecutive Times Winning The $awName";
     $title.="<br/>(Top $limit Players, Position Indicated is First In Streak)";
     $query="SET @player_id:=0;SET @year:=0;SET @strk:=0;SET @strk_id:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,x.position,year as minYr,year+strk-1 as maxYr,strk as yrs FROM players as p,(SELECT strk_id,player_id,year,MAX(strk) as strk,position FROM (SELECT if(@player_id=player_id,if(@year=year-1,@strk_id:=@strk_id,@strk_id:=@strk_id+1),@strk_id:=1) as strk_id,if(@player_id=player_id,if(@year=year-1,@strk:=@strk+1,@strk:=1),@strk:=1) as strk,@player_id:=player_id as player_id,@year:=year as year,position FROM players_awards WHERE league_id=$lgid AND award_id=7 ORDER BY player_id,year) as t1 GROUP BY player_id,strk_id ORDER BY strk DESC,year,position,player_id LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|Position|First Year|Last Year|Years";
     $noResult="No awards history";
     $getTeams=1;
     break;
   case 166:
     $title="Most Plate Appearances With 0 Home Runs in a Career";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT player_id,first_name,last_name,hall_of_fame,years,pa FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,CONCAT(MIN(year),'-',MAX(year)) as years,SUM(pa) as pa,SUM(hr) as hr FROM players_career_batting_stats as pcs,players as p WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id ORDER BY pa DESC) as t WHERE hr=0 LIMIT $limit";
     $cols="Player|Years|PA";
     $noResult="No players with 0 HR";
     $getTeams=1;
     break;
   case 167:
     $title="Most 20 HR/20 SB Seasons";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,COUNT(DISTINCT year) as years FROM players as p,(SELECT player_id,team_id,year FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(hr)>=20 AND SUM(sb)>=20) as pcs WHERE p.player_id=pcs.player_id GROUP BY player_id ORDER BY years DESC LIMIT $limit";
     $cols="Player|20/20 Seasons";
     $noResult="No players have had a 20/20 season.";
     $getTeams=1;
     break;
   case 168:
     $title="Most Teams Played For";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,CONCAT(MIN(minYr),'-',MAX(maxYr)) as years,teams FROM players as p,((SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT team_id) as teams FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) UNION (SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT team_id) as teams FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) ORDER BY teams DESC LIMIT $limit) as t WHERE p.player_id=t.player_id AND teams>1 GROUP BY player_id ORDER BY teams DESC,last_name,first_name;";
     $cols="Player|Years|Teams";
     $noResult="No players have played for more than one team";
     break;
   case 169:
     $title="Most Hall of Famers On A Team";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
        $year=$_GET['year'];
        $title.="<br/>($year)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_name,year,position FROM players as p,(SELECT team_id,year,player_id FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN (SELECT player_id FROM players WHERE hall_of_fame=1) AND team_id=$tid AND year=$year UNION SELECT team_id,year,player_id FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN (SELECT player_id FROM players WHERE hall_of_fame=1) AND team_id=$tid AND year=$year) as x WHERE p.player_id=x.player_id ORDER BY position,last_name,first_name";
	$cols="Player|Team|Year|Position";
      }
      else
      {
        $title.="<br/>(Top $limit Teams)";
	$query="SELECT team_id as team_name,'Show Players' as showLink,year,COUNT(DISTINCT player_id) as cnt FROM (SELECT team_id,year,player_id FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN (SELECT player_id FROM players WHERE hall_of_fame=1) UNION SELECT team_id,year,player_id FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN (SELECT player_id FROM players WHERE hall_of_fame=1)) as t WHERE team_id!=0 GROUP BY team_id,year ORDER BY cnt DESC LIMIT $limit";
   	$cols="Team|Link|Year|Hall of Famers";
	$noResult="No Hall of Famers.";
      }
     $getTeams=1;
     break;
   case 170:
     $title="More Than 1 RBI Per Game Played";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,pcb.team_id as team_name,year,rbi,g,rbiPerG as era FROM players as p,(SELECT player_id,team_id,year,SUM(rbi) as rbi,SUM(g) as g,SUM(rbi)/SUM(g) as rbiPerG FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(rbi)>SUM(g) ORDER BY rbi DESC,rbiPerG DESC LIMIT $limit) as pcb WHERE p.player_id=pcb.player_id";
     $cols="Player|Team|Year|RBI|G|RBI/G";
     $noResult="No players have had more than 1 RBI per game";
     $getTeams=1;
     break;
   case 171:
     $title="Most Hits By A Player Who Played One Season";
     $title.="<br/>(Top $limit Players, Current and Inaugural Seasons Ignored)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,mYr,h FROM players as p,(SELECT player_id,MAX(year) as mYr,COUNT(DISTINCT year) as yrs,SUM(h) as h FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as t1 WHERE p.player_id=t1.player_id AND yrs=1 AND mYr!=$lgyear AND mYr!=(SELECT MIN(year) FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1) AND h>0 ORDER BY h DESC LIMIT $limit";
     $cols="Player|Year|H";
     $noResult="Not enough history";
     break;
   case 172:
     $title="Largest Difference Between Personal WinPct and Team WinPct";
     $title.="<br/>(Top $limit Players, Current and Inaugural Seasons Ignored)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,pw,pl,ppct as avg,year,x.team_id as team_name,tw,tl,tpct as obp,pctDiff as slg FROM players as p,(SELECT t1.player_id,t1.team_id,t1.year,t1.w as pw,t1.l as pl,t1.wpct as ppct,t2.w as tw,t2.l as tl,t2.pct as tpct,t1.wpct-t2.pct as pctDiff FROM (SELECT player_id,team_id,year,w,l,w/(w+l) as wpct,ip+ipf/3 as ip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,team_id,year HAVING (w+l)>0) as t1,(SELECT team_id,year,w,l,pct FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.ip>=(t2.w+t2.l) ORDER BY pctDiff DESC LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|W|L|Pct|Year|Team|W|L|Pct|Diff";
     $noResult="Not enough history";
		 $getTeams=1;
     break;
   ## case 173: Filed under case 1
   ## case 174: Filed under case 77
   case 175:
     $title="Largest Single Season Improvement In Earned Run Average";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year1 as year,team1 as team_abbr,era1 as era,year2,team2 as team_abbr2,era2 as whip,eraDiff as kper9 FROM players as p,(SELECT a.player_id,a.team_id as team1,a.year as year1,a.era as era1,b.team_id as team2,b.year as year2,b.era as era2,a.era-b.era as eraDiff FROM (SELECT * FROM (SELECT player_id,pcs.team_id,pcs.year,SUM(ip)+SUM(ipf)/3 as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era,thr.g as tg FROM players_career_pitching_stats as pcs,team_history_record as thr WHERE pcs.team_id=thr.team_id AND pcs.year=thr.year AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(ip)+SUM(ipf)>=0 ORDER BY era DESC) as t0 WHERE ip>=tg) as a,(SELECT * FROM (SELECT player_id,pcs.team_id,pcs.year,SUM(ip)+SUM(ipf)/3 as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era,thr.g as tg FROM players_career_pitching_stats as pcs,team_history_record as thr WHERE pcs.team_id=thr.team_id AND pcs.year=thr.year AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(ip)+SUM(ipf)>=0 ORDER BY era DESC) as t1 WHERE ip>=tg) as b WHERE a.player_id=b.player_id AND a.year=b.year-1 ORDER BY eraDiff DESC LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|Year|Team|ERA|Year|Team|ERA|Diff";
     $noResult="Not enough history";
     $getTeams=1;
     break;
   case 176:
     $title="Most Career Walks By A Player With Initials B. B.";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT a.player_id,first_name,last_name,hall_of_fame,type,bb FROM (SELECT player_id,first_name,last_name,hall_of_fame FROM players WHERE first_name LIKE 'B%' AND last_name LIKE 'B%') as a,(SELECT player_id,'Batting' as type,SUM(bb) as bb FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(bb)>0 UNION SELECT player_id,'Pitching' as type,SUM(bb) as bb FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(bb)>0) as b WHERE a.player_id=b.player_id ORDER BY bb DESC LIMIT $limit";
     $cols="Player|Type|BB";
     $noResult="No players with initials B.B.";
     break;
   ## case 177: Filed under case 46
   case 178:
     $query="SELECT sub_league_id FROM sub_leagues WHERE league_id=$lgid;";
     $result=mysqli_query($db,$query);
     if (mysqli_num_rows($result)>1)
      {
	$query="SELECT year,sub_league_id as sl_name,SUM(r) as r,SUM(g) as g,SUM(r)/SUM(g) as era FROM team_history_batting_stats WHERE league_id=$lgid GROUP BY sub_league_id,year ORDER BY era DESC LIMIT $limit";
	$cols="Year|League|R|G|R/G";
	$getSubLeagues=1;
      }
      else
      {
	$query="SELECT year,SUM(r),SUM(g),SUM(r)/SUM(g) as era FROM team_history_batting_stats WHERE league_id=$lgid GROUP BY league_id,year ORDER BY era DESC LIMIT $limit";
	$cols="Year|R|G|R/G";
      }
     $title="Highest Run Scoring Environments";
     $title.="<br/>(Top $limit Years)";
     $noResult="No historical data";
     break;
   case 179:
     $title="Longest Losing Streak To Finish a Season";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,w,l,pos as stanPos,gb,streak FROM team_history_record WHERE league_id=$lgid AND streak<-1 ORDER BY streak LIMIT $limit";
     $cols="Team|Year|W|L|Finish|GB|Streak";
     $noResult="No losing streaks of more than 1 game recorded";
     $getTeams=1;
     break;
   case 180:
     $title="Wins Title Winners In Descending Order of W's";
     $query="SELECT year,sub_league_id as sl_name,p.player_id,first_name,last_name,hall_of_fame,amount as w FROM players as p,players_league_leader as pll WHERE p.player_id=pll.player_id AND pll.league_id=$lgid AND place=1 AND category=29 ORDER BY amount DESC,year";
     $cols="Year|League|Player|Wins";
     $noResult="No league leading stats recorded";
     $getSubLeagues=1;
     break;
   case 181:
     $title="Fewest Relievers Used In A Season";
     $title.="<br/>(Top $limit Teams, Where Relievers Are Any Pitcher With A Relief Appearance)";
     $query="SELECT team_id as team_name,year,COUNT(DISTINCT player_id) as players FROM (SELECT player_id,team_id,year,SUM(g) as g,SUM(gs) as gs FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 GROUP BY player_id,team_id,year HAVING (SUM(g)-SUM(gs))>0) as t1 GROUP BY team_id,year ORDER BY players,year LIMIT $limit";
     $cols="Team|Year|Relievers Used";
     $noResult="No historical data";
     $getTeams=1;
     break;
   case 182:
     $title="Most Games Started At Two Defensive Positions";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,position1,minYr1,maxYr1,g1,gs1,inn1 as ip1,innPerG1 as era,position2,minYr2,maxYr2,g2,gs2,inn2 as ip2,innPerG2 as whip FROM players as p,(SELECT a.player_id,a.position as position1,a.minYr as minYr1,a.maxYr as maxYr1,a.g as g1,a.gs as gs1,a.inn as inn1,a.innPerG as innPerG1,b.position as position2,b.minYr as minYr2,b.maxYr as maxYr2,b.g as g2,b.gs as gs2,b.inn as inn2,b.innPerG as innPerG2,if(a.gs>b.gs,b.gs,a.gs) as hide FROM (SELECT player_id,position,MIN(year) as minYr,MAX(year) as maxYr,SUM(g) as g,SUM(gs) as gs,SUM(ip)+SUM(ipf)/3 as inn,(SUM(ip)+SUM(ipf)/3)/SUM(g) as innPerG FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position>1 AND position<10 GROUP BY player_id,position HAVING SUM(g)>=162) as a,(SELECT player_id,position,MIN(year) as minYr,MAX(year) as maxYr,SUM(g) as g,SUM(gs) as gs,SUM(ip)+SUM(ipf)/3 as inn,(SUM(ip)+SUM(ipf)/3)/SUM(g) as innPerG FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position>1 AND position<10 GROUP BY player_id,position HAVING SUM(g)>=162) as b WHERE a.player_id=b.player_id AND a.position<b.position ORDER BY hide DESC LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|Position|From|To|G|GS|Inn|Inn/G|Position|From|To|G|GS|Inn|Inn/G";
     $noResult="No historical fielding data";
     break;
   case 183:
     $title="Most All-Star Appearances Without Appearing in the Postseason";
     $title.="<br/>(Top $limit Players)";
		 $query="SELECT p.player_id,first_name,last_name,hall_of_fame,yrs FROM players as p,(SELECT player_id,yrs FROM (SELECT player_id,COUNT(DISTINCT year) as yrs FROM players_awards WHERE league_id=$lgid AND award_id=9 GROUP BY player_id) as t1 WHERE NOT EXISTS (SELECT player_id FROM (SELECT DISTINCT player_id FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=21 UNION SELECT DISTINCT player_id FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=21) as t2 WHERE t1.player_id=t2.player_id) ORDER BY yrs DESC LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|All-Star Appearances";
     $noResult="Unable to determine (either no all-star players, no postseason, or no history of them).";
     break;
   ## case 184: Filed under case 113
   ## case 185: Filed under case 18
   ## case 186: Filed under case 3
   case 187:
     $title="Most Seasons Pitched In With No Decisions";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,yrs,g,ip FROM players as p,(SELECT player_id,COUNT(DISTINCT year) as yrs,SUM(g) as g,SUM(ip) as ip FROM (SELECT player_id,year,SUM(g) as g,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(w)=0 AND SUM(l)=0) as t1 GROUP BY player_id HAVING COUNT(DISTINCT year)>1 ORDER BY yrs DESC,ip DESC,g DESC LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|Years|G|IP";
     $noResult="No pitchers have had more than 1 season without a decision";
     break;
   case 188:
     $title="Most Years With One Team";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT * FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_name,COUNT(year) as years FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY pcs.player_id,pcs.team_id ORDER BY years DESC) as t WHERE years>0 ORDER BY years DESC,last_name,first_name LIMIT $limit;";
     $cols="Player|Team|Years";
     $noResult="No player has played more than one season with any team";
     $getTeams=1;
     break;
   ## case 189: Filed under case 1
   case 190:
     $title="Highest Percentage of Team Losses From One Pitcher";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT tots.team_id as team_name,year,tl,tots.player_id,first_name,last_name,hall_of_fame,l,pct FROM players as p,(SELECT t1.team_id,t1.year,tl,player_id,l,l/tl as pct FROM (SELECT player_id,team_id,year,MAX(l) as l FROM (SELECT player_id,team_id,year,l FROM `players_career_pitching_stats` WHERE league_id=$lgid AND split_id=1 ORDER BY l DESC) as x GROUP BY team_id,year) as t1,(SELECT team_id,year,l as tl FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY pct DESC,l DESC,tl DESC,year LIMIT $limit) as tots WHERE p.player_id=tots.player_id ORDER BY pct DESC,l DESC,tl DESC,year";
     $cols="Team|Year|L|Player|L|Pct";
     $noResult="No historical data";
     $getTeams=1;
     break;
   case 191:
     $query="SELECT sub_league_id FROM sub_leagues WHERE league_id=$lgid;";
     $result=mysqli_query($db,$query);
     if (mysqli_num_rows($result)>1)
      {
        $title="Largest Difference In Run Scoring Between Leagues";
	$query="SELECT t1.year,t1.sub_league_id as sl_name1,r1,rPerG1 as era,t2.sub_league_id as sl_name2,r2,rPerG2 as whip,ABS(rPerG1-rPerG2) as rDiff FROM (SELECT sub_league_id,year,SUM(r) as r1,SUM(g) as g1,SUM(r)/SUM(g) as rPerG1 FROM team_history_batting_stats WHERE league_id=$lgid GROUP BY sub_league_id,year ORDER BY rPerG1 DESC) as t1,(SELECT sub_league_id,year,SUM(r) as r2,SUM(g) as g2,SUM(r)/SUM(g) as rPerG2 FROM team_history_batting_stats WHERE league_id=$lgid GROUP BY sub_league_id,year ORDER BY rPerG2 DESC) as t2 WHERE t1.year=t2.year AND t1.sub_league_id<t2.sub_league_id ORDER BY rDiff DESC LIMIT $limit";
	$cols="Year|League|R|R/G|League|R|R/G|Diff";
	$getSubLeagues=1;
      }
      else
      {
        $title="Highest League Run Scoring Environments";
	$query="SELECT year,SUM(r),SUM(g),SUM(r)/SUM(g) as era FROM team_history_batting_stats WHERE league_id=$lgid GROUP BY league_id,year ORDER BY era DESC LIMIT $limit";
	$cols="Year|R|G|R/G";
      }
     $title.="<br/>(Top $limit Years)";
     $noResult="No historical data";
     break;
   case 192:
     $title="Most Seasons Appeared In Since Last Win";
     $title.="<br/>(Top $limit Players, Active Players Only)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,lastW,w,(SELECT COUNT(DISTINCT year) FROM players_career_pitching_stats WHERE player_id=t1.player_id AND year>lastW AND league_id=$lgid AND split_id=1 GROUP BY player_id) as yrsSince FROM players as p,(SELECT player_id,MAX(year) as lastW,(SELECT SUM(w) as w FROM players_career_pitching_stats WHERE player_id=t.player_id AND year=t.year AND league_id=$lgid AND split_id=1 GROUP BY player_id,year) as w FROM (SELECT player_id,year,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(w)>0 ORDER BY player_id,year DESC) as t GROUP BY player_id) as t1 WHERE p.player_id=t1.player_id AND retired=0 ORDER BY yrsSince DESC,w,last_name,first_name LIMIT $limit";
     $cols="Player|Last Win|Wins That Year|Years Since";
     $noResult="No historical data";
     break;
   case 193:
     $title="Most Games Played Without A Home Run";
     $title.="<br/>(Top $limit Players, Pitchers Excluded)";
     $query="SELECT player_id,first_name,last_name,hall_of_fame,g FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,SUM(g) as g,SUM(hr) as hr FROM players_career_batting_stats as pcs,players as p WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 AND p.position!=1 GROUP BY player_id ORDER BY g DESC) as t WHERE hr=0 LIMIT $limit";
     $cols="Player|G";
     $noResult="No players without a home run in their career";
     break;
   case 194:
     $query="SELECT player_id,year,team_id,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY hr DESC LIMIT 100,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $hr=$row['hr'];
     if ($hr>20) {$hr=20;}
      else {$hr=floor($hr/5)*5;}
     $title="Most Players with $hr or More Home Runs";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT * FROM (SELECT pcs.team_id as team_name,pcs.year,COUNT(player_id) as cnt FROM players_career_batting_stats as pcs,team_history as th WHERE pcs.team_id=th.team_id AND pcs.year=th.year AND pcs.league_id=$lgid AND split_id=1 AND hr>=$hr GROUP BY pcs.team_id,year ORDER BY cnt DESC,year,team_name) as t WHERE cnt>1 LIMIT $limit;";
     $cols="Team|Year|Number of Players";
     $noResult="No teams with players with $hr+ HR's in any season";
     $getTeams=1;
     break;
   case 195:
     $title="Farthest Finish Out of First Place";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,w,l,pct,pos as stanPos,gb FROM team_history_record WHERE league_id=$lgid AND gb!=0 ORDER BY gb DESC,w,year LIMIT $limit";
     $cols="Team|Year|W|L|Pct|Pos|GB";
     $noResult="No seasons completed";
     $getTeams=1;
     break;
   case 196:
     $title="Most Consecutive All-Star Appearances";
     $title.="<br/>(Top $limit Players)";
     $query="SET @player_id:=0;SET @year:=0;SET @strk:=0;SET @strk_id:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,year as minYr,year+strk-1 as maxYr,strk as yrs FROM players as p,(SELECT strk_id,player_id,year,MAX(strk) as strk FROM (SELECT if(@player_id=player_id,if(@year=year-1,@strk_id:=@strk_id,@strk_id:=@strk_id+1),@strk_id:=1) as strk_id,if(@player_id=player_id,if(@year=year-1,@strk:=@strk+1,@strk:=1),@strk:=1) as strk,@player_id:=player_id as player_id,@year:=year as year FROM players_awards WHERE league_id=$lgid AND award_id=9 ORDER BY player_id,year) as t1 GROUP BY player_id,strk_id ORDER BY strk DESC,year,player_id LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|Start|Finish|Years";
     $noResult="No players have had consecutive All-Star appearances";
     $getTeams=1;
     break;
   case 197:
     $title="All Players with 30 HR/30 SB Seasons";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,team_abbr,year,hr,sb FROM players as p,(SELECT player_id,team_id as team_abbr,year,SUM(hr) as hr,SUM(sb) as sb,if(SUM(hr)<SUM(sb),SUM(hr),SUM(sb)) as minStat FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(hr)>=30 AND SUM(sb)>=30) as pcs WHERE p.player_id=pcs.player_id ORDER BY minStat DESC,hr DESC,sb DESC";
     $cols="Player|Team|Year|HR|SB";
     $noResult="No players have had a 30/30 season.";
     $getTeams=1;
     break;
   case 198:
     $awquery="SELECT defense_award_name FROM leagues WHERE league_id=$lgid;";
     $awresult=mysqli_query($db,$awquery);
     $row=mysqli_fetch_array($awresult);
     $awName=$row['defense_award_name'];
     $title="Players Who Have Won the $awName at Multiple Positions";
     $query="SELECT t.player_id,first_name,last_name,hall_of_fame,cnt,yrcnt FROM players as p,(SELECT player_id,COUNT(DISTINCT year) as yrcnt,COUNT(DISTINCT position) as cnt FROM players_awards WHERE league_id=$lgid AND award_id=7 GROUP BY player_id ORDER BY cnt DESC,yrcnt DESC) as t WHERE p.player_id=t.player_id AND cnt>1;";
     $cols="Player|Positions|Times Won";
     $noResult="No players have won the $awName at multiple positions";
     break;
   case 199:
     $title="Highest Percentage of Runs Allowed From Home Runs";
     $title.="<br/>(Top $limit Players, Minimum 50 IP)";
     $query="SELECT * FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,(SUM(ip)+SUM(ipf)/3) as ip,SUM(hra) as hra,SUM(r) as r,1-(SUM(r)-SUM(hra))/SUM(r) as pct FROM players_career_pitching_stats as pcs,players as p WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY pct DESC) as t WHERE ip>=50 LIMIT $limit";
     $cols="Player|Team|Year|IP|HR|R|Pct";
     $noResult="No players have allowed a home run";
     $getTeams=1;
     break;
   case 200:
     $title="Most Home Runs by Batter Weight";
     $title.="<br/>(Earliest Occurrence Shown)";
     $query="SELECT weight,player_id,first_name,last_name,hall_of_fame,team_abbr,year,MAX(hr) as hr FROM (SELECT CONCAT(floor(weight/5)*5,'-',floor(weight/5)*5+5-1) as weight,wtSort,player_id,first_name,last_name,hall_of_fame,team_abbr,hr,year FROM (SELECT p.player_id,last_name,first_name,hall_of_fame,weight,floor(weight/5)*5 as wtSort,pcs.team_id as team_abbr,SUM(hr) as hr,year FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND pcs.split_id=1 GROUP BY player_id,year ORDER BY wtSort,hr DESC,year) as t) as x GROUP BY weight ORDER BY wtSort;";
     $cols="Weight|Player|Team|Year|HR";
     $noResult="No home runs hit";
     $getTeams=1;
     break;
   case 201:
     $title="Most .600+ Seasons";
     $query="SELECT team_id as team_name,COUNT(year) as cnt FROM team_history_record WHERE league_id=$lgid AND pct>=.600 AND team_id!=0 GROUP BY team_id ORDER BY cnt DESC;";
     $cols="Team|.600 Seasons";
     $noResult="No team has finished with a winning percentage of .600 or better.";
     $getTeams=1;
     break;
   ## case 202: Filed under case 54
   case 203:
     $title="Percentage of Players With X Home Runs Divided In Groups of 20 Home Runs";
     if ($showLink==1)
      {
        $bucket=$_GET['bucket'];
        switch ($bucket)
	 {
 	   case -1: $min=0;$max=0;  break;
 	   case 0 : $min=1;$max=19; break;
 	   default: $min=20*$bucket;$max=20*$bucket+19; break;
	 }
        $title.="<br/>(Players with $min-$max Home Runs)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,g,pa,h,d,t,hr,bb,sb,avg,slg FROM players as p,(SELECT player_id,SUM(g) as g,SUM(pa) as pa,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(bb) as bb,SUM(sb) as sb,if(SUM(ab)=0,0,SUM(h)/SUM(ab)) as avg,if(SUM(ab)=0,0,(SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab)) as slg FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(hr)>=$min AND SUM(hr)<=$max) as x WHERE p.player_id=x.player_id ORDER BY h DESC,avg DESC";
        $cols="Player|G|PA|H|2B|3B|HR|BB|SB|AVG|SLG";
      }
      else
      {
        $query="SELECT bucket as hide,if(bucket=-1,0,if(bucket=0,CONCAT('1-',20-1),CONCAT(bucket*20,'-',bucket*20+20-1))) as bucket,'Show Players' as showLink,COUNT(DISTINCT player_id) as players,COUNT(DISTINCT player_id)/(SELECT COUNT(DISTINCT player_id) FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1) as longPct FROM (SELECT if(hr=0,-1,FLOOR(hr/20)) as bucket,player_id,hr FROM (SELECT player_id,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id ORDER BY hr DESC) as t1) as t2 GROUP BY bucket ORDER BY hide DESC";
        $cols="Bucket|Link|Players|Pct";
      }
     break;
   case 204:
     $query="SELECT COUNT(DISTINCT year) as yrs FROM players_career_batting_stats WHERE league_id=$lgid AND split_id =1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $lgYrs=$row['yrs'];
     switch ($lgYrs)
      {
        case 1: $yrs=1; break;
	case 2:
   	case 3: $yrs=2; break;
	case 4: $yrs=3; break;
	case 5: $yrs=4; break;
	default: $yrs=5; break;
      }
     $title="Teams With The Most Players To Have Played Exclusively For Them";
     if ($showLink==1)
      {
        $team_id=$_GET['team_id'];
        $title.="<br/>(Minimum $yrs Years Service, Individual Team Listing)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,t1.team_id as team_name,minYr as year1,maxYr as year,yrs FROM players as p,(SELECT player_id,team_id,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT year) as yrs,COUNT(DISTINCT team_id) as teams FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 GROUP BY player_id HAVING COUNT(DISTINCT team_id)=1 AND COUNT(DISTINCT year)>=$yrs) as t1 WHERE p.player_id=t1.player_id AND t1.team_id=$team_id ORDER BY yrs DESC,maxYr,last_name";
        $cols="Player|Team|First Year|Final Year|Seasons";
      }
      else
      {
        $title.="<br/>(Minimum $yrs Years Service)";
	$query="SELECT team_id as team_name,'Show Players' as showLink,COUNT(DISTINCT player_id) as players FROM (SELECT player_id,team_id,COUNT(DISTINCT year) as yrs,COUNT(DISTINCT team_id) as teams FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 GROUP BY player_id HAVING COUNT(DISTINCT team_id)=1 AND COUNT(DISTINCT year)>=$yrs) as t1 GROUP BY team_id ORDER BY players DESC";
	$cols="Team|Link|Exclusive Players";
	$noResult="No team has had a player play exclusively for them for $yrs seasons";
      }
     $getTeams=1;
     break;
	 case 205:
		 $title="Highest ERA While Recording X Wins";
		 $title.="<br/>(First Occurrence)";
		 $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_abbr,year,w,ip,era FROM players as p,(SELECT w,player_id,team_id,year,ip,era FROM (SELECT player_id,team_id,year,SUM(w) as w,SUM(ip)+SUM(ipf)/3 as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(w)>0 ORDER BY w DESC,era DESC,year) as t GROUP BY w ORDER BY w DESC) as x WHERE p.player_id=x.player_id ORDER BY w DESC;";
		 $cols="Player|Team|Year|W|IP|ERA";
		 $noResult="No players have won any games";
		 $getTeams=1;
		 break;
	 case 206:
     $title="Highest Percentage of Players On Active Roster Drafted By Organization";
     if ($showLink==1)
      {
        $team_id=$_GET['team_id'];
        $title.="<br/>(Individual Team Listing)";
        $query="SELECT position,player_id,first_name,last_name,hall_of_fame,team_id as team_name,draft_year,draft_round,draft_pick FROM players WHERE team_id=$team_id AND draft_team_id=$team_id ORDER BY last_name,first_name;";
        $cols="Pos|Player|Team|Year Drafted|Round|Pick";
      }
      else
      {
        $query="SELECT team_id as team_name,'Show Players' as showLink,dftCnt,pCnt,dftCnt/pCnt as dPct FROM (SELECT draft_team_id,COUNT(DISTINCT player_id) as dftCnt FROM players WHERE team_id=draft_team_id AND draft_team_id!=0 AND draft_league_id=$lgid GROUP BY draft_team_id) as a,(SELECT team_id,COUNT(DISTINCT player_id) as pCnt FROM players WHERE league_id=$lgid GROUP BY organization_id) as b WHERE a.draft_team_id=b.team_id ORDER BY dPct DESC,pCnt DESC";
	$cols="Team|Drafted Players|Total Players|Pct";
      }
     $noResult="No draft history recorded";
     $getTeams=1;
     break;
   ## case 207: Filed under case 1
   case 208:
     $title="Most Consecutive Seasons Without A Losing Season";
     $title.="<br/>(Top $limit Teams)";
     $query="SET @yrCnt:=0;SET @team_id:=0;SET @year:=0;SET @strk:=0;SELECT t.team_id as team_name,x.year-yrs+1 as strt,x.year as end,yrs FROM team_history as t,(SELECT team_id,MAX(yrCnt) as yrs,MAX(year) as year FROM (SELECT if(pct<.5,@yrCnt:=0,if(@team_id!=team_id,@yrCnt:=1,@yrCnt:=@yrCnt+1)) as yrCnt,if(@team_id!=team_id,@strk:=1,if(@yrCnt<2,@strk:=@strk+1,@strk)) as strk,@team_id:=team_id as team_id,@year:=year as year,pct FROM `team_history_record` WHERE league_id=$lgid ORDER BY team_id,year) as a WHERE yrCnt!=0 GROUP BY team_id,strk) as x WHERE t.team_id=x.team_id AND t.year=x.year AND yrs>0 ORDER BY yrs DESC,strt LIMIT $limit";
     $cols="Team|Start|End|Years";
     $noResult="No team has had consecutive seasons with a winning record";
     $getTeams=1;
     break;
   ## case 209: Filed under case 17
   case 210:
     $title="Highest Career Three True Outcome Totals (HR's, BB's, K's)";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,pa,hr,bb,k,tto,(tto/pa) as pct FROM players as p,(SELECT player_id,SUM(pa) as pa,SUM(hr) as hr,SUM(bb) as bb,SUM(k) as k,(SUM(hr)+SUM(bb)+SUM(k)) as tto FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND (hr>0 OR bb>0 OR k>0) GROUP BY player_id) as pcs WHERE p.player_id=pcs.player_id ORDER BY tto DESC,hr DESC,bb DESC LIMIT $limit";
     $cols="Player|PA|HR|BB|K|TTO|TTO%";
     $noResult="No players has recorded a HR, BB, or K";
     break;
   case 211:
     $title="Highest Percentage of Team Runs Knocked In By One Batter";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT tots.team_id as team_name,year,tr,tots.player_id,first_name,last_name,hall_of_fame,rbi,pct FROM players as p,(SELECT t1.team_id,t1.year,tr,player_id,rbi,rbi/tr as pct FROM (SELECT player_id,team_id,year,MAX(rbi) as rbi FROM (SELECT player_id,team_id,year,rbi FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 ORDER BY rbi DESC) as x GROUP BY team_id,year) as t1,(SELECT team_id,year,r as tr FROM team_history_batting_stats WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY pct DESC,rbi DESC,tr DESC,year LIMIT $limit) as tots WHERE p.player_id=tots.player_id";
     $cols="Team|Year|Team Runs|Player|RBI|Pct";
     $noResult="No player has recorded any runs batted in";
     $getTeams=1;
     break;
   case 212:
     $title="Oldest Player To Lead The League";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,last_name,first_name,hall_of_fame,date_of_birth,year,category,(pll.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,DAYOFYEAR(date_of_birth) as dayBorn FROM players as p,players_league_leader as pll WHERE p.player_id=pll.player_id AND pll.league_id=$lgid AND place<=1 AND category IN (3,6,7,8,9,10,11,12,18,29,32,34,38,40) ORDER BY age DESC,dayBorn,year,category,last_name,first_name LIMIT $limit";
     $cols="Player|Birthday|Year|Cateogry|Age";
     $noResult="No league leaders history";
     $getTeams=1;
     break;
   ## case 213: Filed under case 24
   ## case 214: Filed under case 23
   ## case 215: Filed under case 24
   case 216:
     $title="Largest Difference Between OBP And AVG";
     $title.="<br/>(Top $limit Players, Minimum 200 PA)";
     $query="SELECT * FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,SUM(h) as h,SUM(bb) as bb,if(SUM(ab)=0,0,(SUM(h)/SUM(ab))) as avg,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))) as obp,(if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf)))-if(SUM(ab)=0,0,(SUM(h)/SUM(ab)))) as avg_diff,SUM(pa) as pa FROM players_career_batting_stats as pcs,players as p WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY pcs.player_id,year ORDER BY avg_diff DESC) as t WHERE pa>200 AND avg_diff>0 LIMIT $limit;";
     $cols="Player|Team|Year|H|BB|AVG|OBP|Diff|PA";
     $noResult="No seasons completed";
     $getTeams=1;
     break;
   ## case 217: Filed under case 1
   case 218:
     $title="Most Consistent Teams By Winning Percentage";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,COUNT(DISTINCT year) as yrs,AVG(pct) as avg,STDDEV(pct) as obp FROM team_history_record WHERE league_id=$lgid GROUP BY team_id ORDER BY obp,avg DESC LIMIT $limit";
     $cols="Team|Years|Avg Win Pct|Win Pct StdDev";
     $noResult="No seasons completed";
     $getTeams=1;
     break;
   case 219:
     $title="Most Innings In The Outfield With More Assists Than Putouts";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,t.team_id as team_abbr,year,a,po,ip FROM players as p,(SELECT player_id,year,team_id,SUM(a) as a,SUM(po) as po,(SUM(ip)+SUM(ipf)/3) as ip FROM `players_career_fielding_stats` WHERE league_id=$lgid AND split_id<=1 AND position IN (7,8,9) GROUP BY player_id,year HAVING SUM(a)>SUM(po) ORDER BY ip DESC,a DESC,po LIMIT $limit) as t WHERE p.player_id=t.player_id";
     $cols="Player|Team|Year|A|PO|Inn";
     $noResult="No players have had more assists than putouts as an outfielder";
     $getTeams=1;
     break;
   case 220:
     $title="Highest Percentage of RBI from Home Runs";
     $title.="<br/>(Top $limit Players, Minimum 20 RBI)";
     $query="SELECT * FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,SUM(hr) as hr,SUM(rbi) as rbi,1-(SUM(rbi)-SUM(hr))/SUM(rbi) as pct FROM players_career_batting_stats as pcs,players as p WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id,year) as t WHERE rbi>=20 ORDER BY pct DESC LIMIT $limit;";
     $cols="Player|Team|Year|HR|RBI|Pct";
     $noResult="No player has had 20 RBI";
     $getTeams=1;
     break;
   ## case 221: Filed under case 17
   case 222:
     $title="Players With At Least 10 GIDP And 10 SB's In The Same Season";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT * FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,SUM(gdp) as gdp,SUM(sb) as sb,SUM(cs) as cs FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id,year) as t WHERE gdp>=10 AND sb>=10 ORDER BY gdp DESC,sb DESC LIMIT $limit";
     $cols="Player|Team|Year|GIDP|SB|CS";
     $noResult="No players have had a 10 GIDP and 10 SB in the same season.";
     $getTeams=1;
     break;
   ## case 223: Filed under case 37
   ## case 224: Filed under case 18
   case 225:
     $title="Most All-Stars Drafted By Franchise";
		 if ($showLink==1)
		 {
			 $tid=$_GET['team_id'];
			 $title.="<br/>(Individual Team Listing)";
			 $query="SELECT p.player_id,first_name,last_name,hall_of_fame,draft_team_id as team_name,draft_year,draft_round,draft_pick,COUNT(DISTINCT pa.year) as years FROM players as p,players_awards as pa WHERE p.player_id=pa.player_id AND pa.league_id=$lgid AND award_id=9 AND draft_team_id=$tid AND draft_year!=0 GROUP BY player_id ORDER BY years DESC,draft_year,last_name,first_name";
			 $cols="Player|Drafted By|Draft Year|Round|Pick|All-Star Appearances";
			 $getTeams=1;
		 }
		 else
		 {
			 $query="SELECT draft_team_id as team_name,'Show Players' as showLink,COUNT(DISTINCT p.player_id) as cnt FROM players as p,players_awards as pa WHERE p.player_id=pa.player_id AND pa.league_id=$lgid AND award_id=9 AND draft_team_id!=0 AND draft_year!=0 GROUP BY draft_team_id ORDER BY cnt DESC";
			 $cols="Team|Link|All-Stars Drafted";
		 }
		 $noResult="No All-Stars Drafted";
     $teams[0][$lgyear]['name']='Undrafted Free Agent';
     $getTeams=1;
     break;
   case 226:
     $title="Lowest IP Per G ratio";
     $title.="<br/>(Top $limit Players, Minimum 50 Appearances)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,CONCAT(MIN(year),'-',MAX(year)) as years,SUM(ip)+SUM(ipf)/3 as ip,SUM(g) as g,(SUM(ip)+SUM(ipf)/3)/SUM(g) as avg FROM players as p,players_career_pitching_stats as pcb WHERE p.player_id=pcb.player_id AND pcb.league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(g)>=50 ORDER BY avg,ip DESC LIMIT $limit";
     $cols="Player|Years|IP|G|IP/G";
     $noResult="No player has had 50 appearances";
     break;
   case 227:
     $title="Number of 1.000+ OPS's Per Season";
     if ($showLink==1)
      {
        $year=$_GET['year'];
        $title.="<br/>($year)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_name,pa,h,d,t,hr,sb,bb,avg,ops FROM players as p,(SELECT player_id,t1.team_id,pa,h,d,t,hr,sb,bb,avg,ops FROM (SELECT player_id,team_id,year,SUM(pa) as pa,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(sb) as sb,SUM(bb) as bb,SUM(h)/SUM(ab) as avg,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))+((SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab))) as ops FROM players_career_batting_stats WHERE league_id=$lgid AND year=$year AND split_id=1 GROUP BY player_id,year HAVING SUM(ab)>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid AND year=$year) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.pa>=(3.1*t2.g) AND ops>=1.000) as x WHERE p.player_id=x.player_id ORDER BY ops DESC,last_name,first_name";
	$cols="Player|Team|PA|H|2B|3B|HR|SB|BB|AVG|OPS";
	$getTeams=1;
      }
      else
      {
        $query="SELECT year,'Show Players' as showLink,SUM(cnt) as cnt FROM (SELECT year,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,t1.team_id,t1.year,ops FROM (SELECT player_id,team_id,year,SUM(pa) as pa,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))+((SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab))) as ops FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(ab)>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.pa>=(3.1*t2.g) AND ops>=1.000) as x GROUP BY year UNION SELECT DISTINCT year,0 as cnt FROM team_history WHERE league_id=$lgid GROUP BY year) as x1 GROUP BY year ORDER BY year";
        $cols="Year|Link|Players";
      }
     $noResult="No batting stats";
     break;
   case 228:
     $title="Largest Percentage Increase In Attendance";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT t1.team_id as team_name,t1.year,t1.attendance,t2.year as year1,t2.attendance as attendance1,t2.attendance/t1.attendance as era FROM team_history_financials as t1,team_history_financials as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year-1 AND t1.league_id=$lgid AND t1.attendance>0 AND t2.attendance>0 ORDER BY era DESC LIMIT $limit";
     $cols="Team|Year|Attendance|Year|Attendance|Pct Increase";
     $noResult="Not enough historical attendance data";
     $getTeams=1;
     break;
   case 229:
     $query="SELECT player_id,year,team_id,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY w DESC LIMIT 25,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $w=$row['w'];
     if ($w>20) {$w=20;}
      else {$w=floor($w/5)*5;}
     $title="Most $w Win Seasons By Franchise";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
        $title.="<br/>(Individual Team Listing)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,x.team_id as team_name,w,l,ip,era FROM players as p,(SELECT player_id,team_id,year,SUM(w) as w,SUM(l) as l,SUM(ip)+SUM(ipf)/3 as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND team_id=$tid GROUP BY player_id,team_id,year HAVING SUM(w)>=$w) as x WHERE p.player_id=x.player_id ORDER BY w DESC,l,era";
        $cols="Player|Year|Team|W|L|IP|ERA";
      }
      else
      {
	$query="SELECT t.team_id as team_name,'Show Players' as showLink,cnt FROM teams as t,(SELECT team_id,COUNT(*) as cnt FROM (SELECT player_id,team_id,year,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,team_id,year HAVING SUM(w)>=$w) as x GROUP BY team_id) as x1 WHERE t.team_id=x1.team_id ORDER BY cnt DESC,name,nickname";
   	$cols="Team|Link|Number of Players";
      }
     $noResult="No teams have had a $w win pitcher";
     $getTeams=1;
     break;
	 case 230:
		 $query="SELECT MIN(year) as yr FROM players_awards WHERE league_id=$lgid AND award_id=9;";
		 $result=mysqli_query($db,$query);
		 $row=mysqli_fetch_array($result);
		 $firstAS=$row['yr'];
		 $title="Most Career Wins Without Being An All-Star";
		 if ($firstAS=="")
		 {
			 $firstAS=$lgyear+1;
			 $noResult="No All-Star Games Played";
		 }
		 else
		 {
			 $title.="<br/>(Top $limit Players, Wins Since First All-Star Game in $firstAS)";
			 $noResult="No player has won at least 5 games and not made the All-Star team at some point";
		 }
		 $query="SELECT p.player_id,first_name,last_name,hall_of_fame,yrs,w,l,s,ip,era FROM players as p,(SELECT player_id,CONCAT(minYr,'-',maxYr) as yrs,w,l,s,ip,era FROM (SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,SUM(w) as w,SUM(l) as l,SUM(s) as s,SUM(ip)+SUM(ipf)/3 as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND year>=$firstAS GROUP BY player_id HAVING SUM(w)>5) as t1 WHERE NOT EXISTS (SELECT player_id FROM (SELECT DISTINCT player_id FROM players_awards WHERE league_id=$lgid AND award_id=9) as t2 WHERE t1.player_id=t2.player_id) ORDER BY w DESC LIMIT $limit) as x WHERE p.player_id=x.player_id";
		 $cols="Player|Years|W|L|SV|IP|ERA";
		 break;
   case 231:
     $title="Lowest Number Of Runs Allowed Relative To League";
     $title.="<br/>(Top $limit Teams, SD is number of standard deviations better than league average)";
     $query="SELECT team_id as team_name,ths.year,r,rAvg,rStd,((rAvg-r)/rStd) as SDscore FROM team_history_pitching_stats as ths,(SELECT year,league_id,sub_league_id,AVG(r) as rAvg,STDDEV_POP(r) as rStd FROM team_history_pitching_stats WHERE league_id=$lgid GROUP BY year,league_id,sub_league_id) as lgBat WHERE ths.league_id=lgBat.league_id AND ths.sub_league_id=lgBat.sub_league_id AND ths.year=lgBat.year AND ths.r>0 ORDER BY SDscore DESC LIMIT $limit";
     $cols="Team|Year|RA|Lg RA Avg|Lg RA Std|SD";
     $noResult="No seasons completed";
     $getTeams=1;
     break;
   ## case 232: Filed under case 108
   case 233:
     $title="Highest Attendance Relative To League";
     $title.="<br/>(Top $limit Teams, SD is number of standard deviations better than league average)";
     $query="SELECT team_id as team_name,thf.year,attendance,lgavg as attAvg,lgstd as attStd,(attendance-lgavg)/lgstd as SDscore FROM team_history_financials as thf,(SELECT year,AVG(attendance) as lgavg,STDDEV(attendance) as lgstd FROM team_history_financials WHERE league_id=$lgid GROUP BY year) as t1 WHERE thf.year=t1.year AND thf.league_id=$lgid AND attendance>0 ORDER BY SDscore DESC LIMIT $limit";
     $cols="Team|Year|Attendance|Lg Att Avg|Lg Att Std|SD";
     $noResult="No seasons completed";
     $getTeams=1;
     break;
   ## case 234: Filed under case 7
   case 235:
		 $title="Most Offense Heavy Team Relative To League";
		 $title.="<br/>(Top $limit Teams, SD is number of standard deviations better than league average)";
		 $query="SELECT t1.team_id as team_name,t1.year,t1.r,t1.rAvg,t1.rStd,t1.SDscore,t2.r as ra,t2.rAvg as raAvg,t2.rStd as raStd,t2.SDscore as raSDscore,(t1.SDscore-t2.SDscore) as totSDscore FROM (SELECT team_id,ths.year,r,rAvg,rStd,((rAvg-r)/rStd) as SDscore FROM team_history_pitching_stats as ths,(SELECT year,league_id,sub_league_id,AVG(r) as rAvg,STDDEV_POP(r) as rStd FROM team_history_pitching_stats WHERE league_id=$lgid GROUP BY year,league_id,sub_league_id) as lgBat WHERE ths.league_id=lgBat.league_id AND ths.sub_league_id=lgBat.sub_league_id AND ths.year=lgBat.year) as t2,(SELECT team_id,ths.year,r,rAvg,rStd,((r-rAvg)/rStd) as SDscore FROM team_history_batting_stats as ths,(SELECT year,league_id,sub_league_id,AVG(r) as rAvg,STDDEV_POP(r) as rStd FROM team_history_batting_stats WHERE league_id=$lgid GROUP BY year,league_id,sub_league_id) as lgBat WHERE ths.league_id=lgBat.league_id AND ths.sub_league_id=lgBat.sub_league_id AND ths.year=lgBat.year) as t1 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY totSDscore DESC LIMIT $limit";
		 $cols="Team|Year|R|R Avg|R Std|R SD|RA|RA Avg|RA Std|RA SD|Net SD";
		 $noResult="No seasons completed";
		 $getTeams=1;
		 break;
   case 236:
     $title="If Nice Guys Finish Last... Most Hit Batsmen By Pitchers, With Team Finish";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT thr.team_id as team_name,thr.year,thr.w,thr.l,pct as winPct,pos as stanPos,hp FROM team_history_record as thr,team_history_pitching_stats as ths WHERE thr.team_id=ths.team_id AND thr.year=ths.year AND ths.league_id=$lgid ORDER BY hp DESC LIMIT $limit";
     $cols="Team|Year|W|L|Pct|Pos|HP";
     $noResult="No team history";
     $getTeams=1;
     break;
   case 237:
     $title="Highest OBP Among HR Title Winners";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT year,sub_league_id as sl_name,t1.player_id,first_name,last_name,hall_of_fame,MAX(hr) as hr,obp FROM players as p,(SELECT player_id,pcb.team_id,sub_league_id,pcb.year,th.g,SUM(hr) as hr,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf)) as obp FROM players_career_batting_stats as pcb,team_history_record as th WHERE pcb.team_id=th.team_id AND pcb.year=th.year AND pcb.league_id=$lgid AND split_id=1 GROUP BY player_id,year,sub_league_id ORDER BY year,hr DESC) as t1 WHERE p.player_id=t1.player_id GROUP BY year,sub_league_id ORDER BY obp DESC LIMIT $limit";
     $cols="Year|League|Player|HR|OBP";
     $noResult="No historical seasons";
     $getSubLeagues=1;
     break;
   case 238:
     $title="Largest Variance In Wins Between Teams Within A League";
     $title.="<br/>(Top $limit Seasons)";
     $query="SELECT year,sub_league_id as sl_name,COUNT(DISTINCT team_id) as teams,STDDEV(w) as rStd FROM team_history_record WHERE league_id=$lgid GROUP BY year,sub_league_id ORDER BY rStd DESC LIMIT $limit";
     $cols="Year|League|# Teams|Win Variance";
     $noResult="No historical seasons";
     $getSubLeagues=1;
     break;
   case 239:
		 $query="SELECT player_id,SUM(h) as h FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id ORDER BY h DESC LIMIT 25,1;";
		 $result=mysqli_query($db,$query);
		 $row=mysqli_fetch_array($result);
		 $h=$row['h'];
		 if ($h>1000) {$h=floor($h/1000)*1000;}
	 	  else {$h=floor($h/100)*100;}
     $title="Lowest Percentage of Home Runs Among $h Hit Men";
     $title.="<br/>(Top $limit Players)";
		 $query="SELECT p.player_id,first_name,last_name,hall_of_fame,yrs,ab,h,s,d,t,hr,avg,hrPct as pct FROM players as p,(SELECT player_id,yrs,ab,h,s,d,t,hr,h/ab as avg,hr/h as hrPct FROM (SELECT player_id,CONCAT(MIN(year),'-',MAX(year)) as yrs,SUM(h) as h,SUM(h)-SUM(d)-SUM(t)-SUM(hr) as s,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(ab) as ab FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(h)>=$h) as t ORDER BY hrPct LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY hrPct";
     $cols="Player|Years|AB|H|1B|2B|3B|HR|AVG|HR Pct";
     $noResult="No posteason stats recorded";
     break;
   case 240:
     $awquery="SELECT pitcher_award_name FROM leagues WHERE league_id=$lgid;";
     $awresult=mysqli_query($db,$awquery);
     $row=mysqli_fetch_array($awresult);
     $poyName=$row['pitcher_award_name'];
     $title="Most Losses The Season After Winning The $poyName";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,g,gs,w,l,ip FROM players as p,(SELECT t1.player_id,t2.year,g,gs,w,l,ip FROM (SELECT player_id,year FROM players_awards WHERE league_id=$lgid AND award_id=4) as t1,(SELECT player_id,year,SUM(w) as w,SUM(l) as l,SUM(g) as g,SUM(gs) as gs,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year) as t2 WHERE t1.player_id=t2.player_id AND (t2.year=t1.year+1) ORDER BY l DESC,w LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY l DESC,w";
     $cols="Player|Year|G|GS|W|L|IP";
     $noResult="No $poyName history recorded";
     $getTeams=1;
     break;
   case 241:
     $awquery="SELECT defense_award_name FROM leagues WHERE league_id=$lgid;";
     $awresult=mysqli_query($db,$awquery);
     $row=mysqli_fetch_array($awresult);
     $awName=$row['defense_award_name'];
     $title="Most Defensive Innings Without Winning The $awName";
     $title.="<br/>(Top $limit Players)";
		 $query="SELECT p.player_id,first_name,last_name,hall_of_fame,years,yrs,ip FROM players as p,(SELECT player_id,CONCAT(minYr,'-',maxYr) as years,yrs,ip FROM (SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT year) as yrs,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position!=10 GROUP BY player_id) as t1 WHERE NOT EXISTS (SELECT player_id FROM (SELECT DISTINCT player_id FROM players_awards WHERE league_id=$lgid AND award_id=7) as t2 WHERE t1.player_id=t2.player_id) ORDER BY ip DESC LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY ip DESC";
     $cols="Player|Years|Seasons Played|Inn";
     break;
   case 242:
     $title="Lowest ERA's By Middle Relievers";
     $title.="<br/>(Top $limit Players, Min .25 IP/tG, Max 10% GS, Max 25% GF)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,w,l,s,ip,era,g,gs,gf FROM players as p,(SELECT player_id,t1.year,era,t1.w,t1.l,t1.s,t1.g,t1.ip,t1.gs,t1.gf FROM team_history_record as thr,(SELECT player_id,team_id,year,SUM(w) as w,SUM(l) as l,SUM(s) as s,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era,SUM(g) as g,SUM(gs) as gs,SUM(gf) as gf,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year) as t1 WHERE thr.team_id=t1.team_id AND thr.year=t1.year AND t1.gs/t1.g<=0.10 AND t1.gf/t1.g<=0.25 AND t1.ip/thr.g>=.25 ORDER BY era,ip DESC LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY era,ip";
     $cols="Player|Year|W|L|SV|IP|ERA|G|GS|GF";
     break;
   case 243:
     $title="Most Innings With 0.00 ERA";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT * FROM (SELECT p.player_id,first_name,hall_of_fame,last_name,pcs.team_id as team_abbr,year,(SUM(ip)+SUM(ipf)/3) as ip,if((SUM(ip)+SUM(ipf)/3)=0,999,9*SUM(er)/(SUM(ip)+SUM(ipf)/3)) as era FROM players_career_pitching_stats as pcs,players as p WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 AND (ipf>0 OR ip>0) GROUP BY player_id,year ORDER BY ip DESC) as t WHERE era=0 LIMIT $limit";
     $cols="Player|Team|Year|IP|ERA";
     $noResult="No players with 0.00 ERA in any season";
     $getTeams=1;
     break;
   case 245:
     $title="Longest Road To The Majors";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,draft_year,draft_team_id as team_name,year,t.team_id as team_name2,(year-draft_year) as yrs FROM players as p,(SELECT player_id,team_id,MIN(year) as year FROM (SELECT player_id,team_id,MIN(year) as year FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,team_id UNION SELECT player_id,team_id,MIN(year) as year FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,team_id ORDER BY player_id) as t1 GROUP BY player_id) as t WHERE p.player_id=t.player_id AND draft_year!=0 AND draft_league_id=$lgid ORDER BY yrs DESC,draft_year,last_name LIMIT $limit;";
     $cols="Player|Drafted|By|Debuted|With|Years";
     $noResult="No player has entered this league via the draft";
     $getTeams=1;
     break;
   case 246:
     $title="Lowest Percentage of Team Wins By Team's Winningest Pitcher";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT tots.team_id as team_name,year,tw,tots.player_id,first_name,last_name,hall_of_fame,w,pct FROM players as p,(SELECT t1.team_id,t1.year,tw,player_id,w,w/tw as pct FROM (SELECT player_id,team_id,year,MAX(w) as w FROM (SELECT player_id,team_id,year,w FROM `players_career_pitching_stats` WHERE league_id=$lgid AND split_id=1 ORDER BY w DESC) as x GROUP BY team_id,year) as t1,(SELECT team_id,year,w as tw FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY pct,w DESC,tw DESC,year LIMIT $limit) as tots WHERE p.player_id=tots.player_id ORDER BY pct,w DESC,tw DESC,year";
     $cols="Team|Year|Tm W|Player|W|Pct";
     $noResult="No historical seasons";
     $getTeams=1;
     break;
   case 247:
     $title="Worst Record While Outscoring The Opposition";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT thr.team_id as team_name,thr.year,w,l,pct as avg,pos as stanPos,rf,ra,rf-ra as runDiff FROM team_history_record as thr,(SELECT thb.team_id,thb.year,thb.r as rf,thp.r as ra FROM team_history_batting_stats as thb,team_history_pitching_stats as thp WHERE thb.team_id=thp.team_id AND thb.year=thp.year AND thb.league_id=$lgid AND thb.r>thp.r) as t1 WHERE thr.team_id=t1.team_id AND thr.year=t1.year ORDER BY pct,rf DESC,year LIMIT $limit";
     $cols="Team|Year|W|L|Pct|Finish|RF|RA|RDiff";
     $noResult="No historical seasons";
     $getTeams=1;
     break;
   case 248:
     $title="Most Years Between Home Runs";
     $title.="<br/>(Top $limit Players)";
     $query="SET @hrYr:=0;SET @player_id:=-1;SET @pYr:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,year-hrYr as firstyr,year,hrYr FROM players as p,(SELECT IF(@player_id!=player_id,@hrYr:=0,@hrYr:=year-@pYr) as hrYr,@player_id:=player_id as player_id,@pYr:=year as year FROM (SELECT player_id,year,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(hr)>0) as a ORDER BY player_id,year) as t WHERE p.player_id=t.player_id AND hrYr>2 ORDER BY hrYr DESC LIMIT $limit";
     $cols="Player|First HR|Next HR|Years";
     $noResult="No player has had more than 2 seasons between home runs";
     break;
   case 249:
     $title="Most Games Played Without Appearing in the Postseason";
     $title.="<br/>(Top $limit Players)";
		 $query="SELECT p.player_id,first_name,last_name,hall_of_fame,yrs,seas,g FROM players as p,(SELECT player_id,CONCAT(minYr,'-',maxYr) as yrs,seas,g FROM (SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT year) as seas,SUM(g) as g FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as t1 WHERE NOT EXISTS (SELECT player_id FROM (SELECT DISTINCT player_id FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=21) as t2 WHERE t1.player_id=t2.player_id) ORDER BY g DESC,yrs DESC LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY g DESC,yrs DESC";
     $cols="Player|Years|Seasons|Games";
     $noResult="All players have reached the postseason";
     break;
   case 251:
     $title="Highest Hit to Strikeout Ratio";
     $title.="<br/>(Top $limit Players, Min 100 k's)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,years,ip,ha,k,era,hTokRatio as whip FROM players as p,(SELECT player_id,CONCAT(MIN(year),'-',MAX(year)) as years,SUM(ip)+SUM(ipf)/3 as ip,SUM(ha) as ha,SUM(k) as k,SUM(ha)/SUM(k) as hTokRatio,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(k)>=100 ORDER BY hTokRatio DESC LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|Years|IP|HA|K|ERA|H/K Ratio";
     $noResult="All players have reached the postseason";
     break;
   case 253:
     $title="Highest Career Total of Runs Scored and Runs Driven In";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,r,rbi,tot FROM players as p,(SELECT player_id,SUM(r) as r,SUM(rbi) as rbi,(SUM(r)+SUM(rbi)) as tot FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id ORDER BY tot DESC,rbi DESC LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY tot DESC,rbi DESC;";
     $cols="Player|R|RBI|Tot";
     $noResult="No team data found";
     break;
   case 256:
     $query="SELECT player_id,team_id,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,team_id ORDER BY w DESC LIMIT 25,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $w=$row['w'];
     if ($w>100)
      {
        $w=floor($w/100)*50;
      }
      else
      {
        $w=floor($w/10)*5;
      }
     $title="Most $w Win Pitchers By Franchise";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
        $title.="<br/>(Individual Team Listing)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_name,years,w,l,s,ip,era FROM players as p,(SELECT player_id,team_id,CONCAT(MIN(year),'-',MAX(year)) as years,SUM(w) as w,SUM(l) as l,SUM(s) as s,SUM(ip)+SUM(ipf)/3 as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND team_id=$tid GROUP BY player_id,team_id HAVING SUM(w)>=$w) as x WHERE p.player_id=x.player_id ORDER BY w DESC";
        $cols="Player|Team|Years|W|L|SV|IP|ERA";
      }
      else
      {
	$query="SELECT team_id as team_name,'Show Players' as showLink,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,team_id,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 GROUP BY player_id,team_id HAVING SUM(w)>=$w) as t1 GROUP BY team_id ORDER BY cnt DESC";
   	$cols="Team|Link|Number of Players";
	$noResult="No teams have had a $w pitcher";
      }
     $getTeams=1;
     break;
   case 257:
     $query="SELECT player_id,year,team_id,SUM(rbi) as rbi FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY rbi DESC LIMIT 25,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $rbi=$row['rbi'];
     if ($rbi>100) {$rbi=100;}
      else {$rbi=floor($rbi/10)*10;}
     $title="Most $rbi RBI Seasons";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT * FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,COUNT(year) as years FROM players as p,(SELECT player_id,year,SUM(rbi) as rbi FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND rbi>0 GROUP BY player_id,year) as pcs WHERE p.player_id=pcs.player_id AND rbi>=$rbi GROUP BY player_id ORDER BY years DESC,last_name,first_name) as t WHERE years>1 LIMIT $limit";
     $cols="Player|Seasons";
     $noResult="No player has had more than one $rbi RBI season";
     break;
   case 258:
     $title="Higher AVG than OBP";
     $title.="<br/>(Top $limit Players, Pitchers Excluded)";
     $query="SELECT * FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,if(SUM(ab)=0,0,(SUM(h)/SUM(ab))) as avg,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))) as obp,(if(SUM(ab)=0,0,(SUM(h)/SUM(ab)))-if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf)))) as avg_diff,SUM(pa) as pa FROM players_career_batting_stats as pcs,players as p WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 AND p.position!=1 GROUP BY pcs.player_id,year ORDER BY avg_diff DESC) as t WHERE avg_diff>0 LIMIT $limit;";
     $cols="Player|Team|Year|AVG|OBP|Diff|PA";
     $noResult="No seasons completed";
     $getTeams=1;
     break;
   case 259:
     $title="Most Seasons Playing In All Games";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,COUNT(DISTINCT year) as yrs FROM players as p,(SELECT player_id,t1.team_id,t1.year,t1.g,t2.g as tg FROM (SELECT player_id,team_id,year,SUM(g) as g FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.g>=t2.g) as x WHERE p.player_id=x.player_id GROUP BY player_id ORDER BY yrs DESC,last_name,first_name LIMIT $limit";
     $cols="Player|Seasons";
     $noResult="No player has played every game of the season";
     break;
   case 260:
     $query="SELECT MAX(year) as maxYr,MIN(year) as minYr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $minYr=$row['minYr'];
     $maxYr=$row['maxYr'];
     $title="Most RBI By A Player Who Appeared As A Batter In Just One Season";
     $title.="<br/>(Top $limit Players, Current and Inaugural Seasons Ignored)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,mYr,rbi FROM players as p,(SELECT player_id,MAX(year) as mYr,COUNT(DISTINCT year) as yrs,SUM(rbi) as rbi FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as t1 WHERE p.player_id=t1.player_id AND yrs=1 AND mYr!=$maxYr AND mYr!=$minYr AND rbi>0 ORDER BY rbi DESC LIMIT $limit";
     $cols="Player|Year|RBI";
     $noResult="No player has played every game of the season";
     break;
   case 261:
     $title="Most Consistent Teams By Wins";
     $query="SELECT team_id as team_name,COUNT(DISTINCT year) as yrs,AVG(w) as era,STDDEV(w) as whip FROM team_history_record WHERE league_id=$lgid GROUP BY team_id ORDER BY whip,era DESC";
     $cols="Team|Years|Avg Wins|Win Deviation";
     $noResult="No seasons completed";
     $getTeams=1;
     break;
   case 262:
   case 352:
     switch ($chkDay)
      {
        case 262:
	  $statMost='w';
	  $table='pitching';
	  $statText='wins';
	  break;
        case 352:
	  $statMost='hr';
	  $table='batting';
	  $statText='home runs';
	  break;
      }
     $title="Number of Players to Max Out At X ".ucwords($statText)." In A Season";
     if ($showLink==1)
      {
        $statVal=$_GET['bucket'];
	$title.="<br/>(Players To Max Out At $statVal ".strtoupper($statMost)."'s)";
	switch ($statMost)
	 {
	   case 'w':
             $query="SELECT p.player_id,first_name,last_name,hall_of_fame,years,maxw,w,l,s,ip,era FROM players as p,(SELECT player_id,CONCAT(MIN(year),'-',MAX(year)) as years,MAX(w) as maxw,SUM(w) as w,SUM(l) as l,SUM(s) as s,SUM(ip) as ip,9*SUM(er)/SUM(ip) as era FROM (SELECT player_id,year,SUM(w) as w,SUM(l) as l,SUM(s) as s,SUM(ip)+SUM(ipf)/3 as ip,SUM(er) as er FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(w)>0) as t1 GROUP BY player_id HAVING MAX(w)=$statVal ORDER BY w DESC) as x WHERE p.player_id=x.player_id";
			 $cols="Player|Years|Max W|W|L|SV|IP|ERA";
	     break;
	   case 'hr':
             $query="SELECT p.player_id,first_name,last_name,hall_of_fame,years,maxhr,g,ab,h,d,t,hr,sb,bb,h/ab as avg,(h+d+2*t+3*hr)/ab as slg FROM players as p,(SELECT player_id,CONCAT(MIN(year),'-',MAX(year)) as years,MAX(hr) as maxhr,SUM(g) as g,SUM(ab) as ab,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(sb) as sb,SUM(bb) as bb FROM (SELECT player_id,year,SUM(g) as g,SUM(ab) as ab,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(sb) as sb,SUM(bb) as bb FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(hr)>0) as t1 GROUP BY player_id HAVING MAX(hr)=$statVal ORDER BY hr DESC) as x WHERE p.player_id=x.player_id";
			 $cols="Player|Years|Max HR|G|AB|H|2B|3B|HR|SB|BB|AVG|SLG";
	     break;
	 }
      }
      else
      {
        $query="SELECT max$statMost,max$statMost as hide,'Show Players' as showLink,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,MAX($statMost) as max$statMost FROM (SELECT player_id,year,SUM($statMost) as $statMost FROM players_career_".$table."_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM($statMost)>0) as t1 GROUP BY player_id) as t2 GROUP BY max$statMost ORDER BY max$statMost DESC";
	$cols="Max ".strtoupper($statMost)."|Link|Number of Players";
      }
     $noResult="No $statText history";
     break;
 case 263:
		 $query="SELECT player_id,year,team_id,SUM(rbi) as rbi FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY rbi DESC LIMIT 25,1;";
		 $result=mysqli_query($db,$query);
		 $row=mysqli_fetch_array($result);
		 $rbi=$row['rbi'];
		 if ($rbi>100) {$rbi=100;}
		 else {$rbi=floor($rbi/10)*10;}
		 $title="Worst $rbi RBI Seasons By OBP";
		 $title.="<br/>(Top $limit Players)";
		 $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_abbr,year,rbi,avg,obp,slg,obp+slg as ops FROM players AS p,(SELECT player_id,team_id,year,SUM(h)/SUM(ab) AS avg,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf)) as obp,(SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab) AS slg,SUM(rbi) AS rbi FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(rbi)>=$rbi ORDER BY obp,rbi DESC LIMIT $limit) AS x WHERE p.player_id = x.player_id ORDER BY obp,rbi DESC";
		 $cols="Player|Team|Year|RBI|AVG|OBP|SLG|OPS";
		 $noResult="No $rbi seasons";
		 $getTeams=1;
		 break;

   case 264:
     $title="Most Innings Without a Decision";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_abbr,year,ip FROM players as p,(SELECT player_id,team_id,year,(SUM(ip)+SUM(ipf)/3) as ip,SUM(w) as w,SUM(l) as l FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND (ipf>0 OR ip>0) GROUP BY player_id,year HAVING SUM(w)=0 AND SUM(l)=0 ORDER BY ip DESC LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|Team|Year|IP";
     $noResult="No players without a decision";
     $getTeams=1;
     break;
   ## case 265: Filed under case 18
   ## case 266: Filed under case 3
   case 267:
     $query="SELECT player_id,year,team_id,SUM(rbi) as rbi FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY rbi DESC LIMIT 25,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $rbi=$row['rbi'];
     if ($rbi>100) {$rbi=100;}
      else {$rbi=floor($rbi/10)*10;}
     $title="Lowest Ratio of Hits to RBI for Players With $rbi+ RBI";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,h,sf,rbi,h/rbi as rat FROM players as p,(SELECT player_id,year,SUM(h) as h,SUM(sf) as sf,SUM(rbi) as rbi FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(rbi)>=$rbi) as t1 WHERE p.player_id=t1.player_id ORDER BY rat LIMIT $limit";
     $cols="Player|Year|H|SF|RBI|H/RBI";
     $noResult="No player with $rbi+ RBI";
     break;
   case 268:
     $title="ERA Title Winners in Ascending Order of ERA";
     $query="SELECT year,sub_league_id,p.player_id,first_name,last_name,hall_of_fame,amount as era FROM players as p,players_league_leader as pll WHERE p.player_id=pll.player_id AND pll.league_id=$lgid AND place=1 AND category=40 ORDER BY amount,year";
     $cols="Year|League|Player|ERA";
     $noResult="No league leaders history";
     $getSubLeagues=1;
     break;
   case 269:
     $title="Most Relievers Used In A Season";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,COUNT(DISTINCT player_id) as players FROM (SELECT player_id,team_id,year,SUM(g) as g,SUM(gs) as gs FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 GROUP BY player_id,team_id,year HAVING (SUM(g)-SUM(gs))>0) as t1 GROUP BY team_id,year ORDER BY players DESC,year LIMIT $limit";
     $cols="Team|Year|Relievers";
     $noResult="No league leaders history";
     $getTeams=1;
     break;
   case 270:
     $title="Most Career Games Pitched Without a Win";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,g,ip,w,l,s FROM players as p,(SELECT player_id,SUM(g) as g,(SUM(ip)+SUM(ipf)/3) as ip,SUM(w) as w,SUM(l) as l,SUM(s) as s FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND (ipf>0 OR ip>0 OR g>0) GROUP BY player_id HAVING SUM(w)=0 ORDER BY g DESC LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY g DESC";
     $cols="Player|G|IP|W|L|SV";
     $noResult="No players without a decision";
     break;
   case 271:
     $title=".500 Pitchers On .500 Teams";
     $title.="<br/>(Top $limit Players by Wins)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_name,year,pw as w,pl as l FROM players as p,(SELECT player_id,t.team_id,t.year,pw,pl FROM (SELECT player_id,team_id,year,SUM(w) as pw,SUM(l) as pl FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,team_id,year HAVING SUM(w)=SUM(l) AND SUM(w)>0) as t1,(SELECT team_id,year,w,l FROM team_history_record WHERE league_id=$lgid AND w=l) as t WHERE t1.team_id=t.team_id AND t1.year=t.year) as x WHERE p.player_id=x.player_id ORDER BY w DESC,year,last_name,first_name LIMIT $limit";
     $cols="Player|Team|Year|W|L";
     $noResult="No player has had a .500 record in a season during which his team did, too.";
     $getTeams=1;
     break;
   ## case 272: Filed under case 113
	 case 273:
		 $query="SELECT player_id,year,team_id,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY w DESC LIMIT 25,1;";
		 $result=mysqli_query($db,$query);
		 $row=mysqli_fetch_array($result);
		 $w=$row['w'];
		 if ($w>20) {$w=20;}
		 else {$w=floor($w/5)*5;}
		 $title="Fewest Career Seasons Among Pitchers Who've Won $w Games In A Season";
		 $title.="<br/>(Top $limit Players)";
		 $query="SELECT p.player_id,first_name,last_name,hall_of_fame,yrs,w,seas FROM players as p,(SELECT player_id,yrs,w,seas FROM (SELECT player_id,CONCAT(MIN(year),'-',MAX(year)) as yrs,SUM(w) as w,COUNT(DISTINCT year) as seas FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as t1 WHERE EXISTS (SELECT player_id FROM (SELECT DISTINCT player_id FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(w)>=$w) as t2 WHERE t1.player_id=t2.player_id) ORDER BY seas,yrs LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY seas,yrs";
		 $cols="Player|Years|Career W|Seasons";
		 $noResult="No player has had $w wins in a season";
		 break;
   case 274:
     $awquery="SELECT defense_award_name FROM leagues WHERE league_id=$lgid;";
     $awresult=mysqli_query($db,$awquery);
     $row=mysqli_fetch_array($awresult);
     $awName=$row['defense_award_name'];
     $title="Most Players to Win the $awName By Team";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,team_name,year,x.position FROM players as p,(SELECT player_id,team_id as team_name,year,position FROM players_awards WHERE league_id=$lgid AND award_id=7 AND team_id=$tid) as x WHERE p.player_id=x.player_id ORDER BY year,position,last_name";
	$cols="Player|Team|Year|Position";
      }
      else
      {
        $title.="<br/>(Includes repeat honorees)";
        $query="SELECT team_id as team_name,'Show Players' as showLink,COUNT(player_id) as cnt FROM players_awards WHERE league_id=$lgid AND award_id=7 AND team_id!=0 GROUP BY team_id ORDER BY cnt DESC,year,team_id;";
	$cols="Team|Link|Number of Players";
      }
     $getTeams=1;
     break;
   case 275:
     $title="Most Career Stolen Bases by Batter Weight";
     $title.="<br/>(Earliest Occurrence Shown)";
     $query="SELECT weightSort as hide,weight,player_id,first_name,last_name,hall_of_fame,team_abbr,MAX(sb) as sb FROM (SELECT weight as weightSort,CONCAT(floor(weight/5)*5,'-',floor(weight/5)*5+5-1) as weight,player_id,first_name,last_name,hall_of_fame,team_abbr,sb FROM (SELECT p.player_id,last_name,first_name,hall_of_fame,weight,pcs.team_id as team_abbr,SUM(sb) as sb FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND pcs.split_id=1 GROUP BY player_id HAVING SUM(sb)>0 ORDER BY weight,sb DESC) as t) as x GROUP BY weight ORDER BY hide;";
     $cols="Weight|Player|Team|SB";
     $noResult="No bases stolen";
     $getTeams=1;
     break;
   case 276:
     $title="Most Nations Represented On The Active Roster";
     $query="SELECT team_id as team_name,COUNT(DISTINCT nation_id) as cnt FROM players WHERE league_id=$lgid GROUP BY team_id ORDER BY cnt DESC;";
     $cols="Team|Nations Represented";
     $getTeams=1;
     break;
   case 277:
     $title="Largest Decline in Team Wins";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT t1.team_id as team_name,t1.year as year1,t1.w,t1.pos as stanPos1,t2.year as year,t2.w as w2,t2.pos as stanPos2,t1.w-t2.w as diff FROM team_history_record as t1,team_history_record as t2 WHERE t1.team_id=t2.team_id AND t1.league_id=t2.league_id AND t1.league_id=$lgid AND t1.year=(t2.year-1) ORDER BY diff DESC,year LIMIT $limit;";
     $cols="Team|Year 1|W's|Finish|Year 2|W's|Finish|Decline";
     $getTeams=1;
     break;
   ## case 278: Filed under case 54
   case 279:
	 $query="SELECT COUNT(DISTINCT year) as yrs FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1;";
		 $result=mysqli_query($db,$query);
		 $row=mysqli_fetch_array($result);
		 $yrs=$row['yrs'];
		 $yrs=floor($yrs/2);
		 $yrs=min($yrs,10);
	 $title="Teams With The Most Position Players To Have Played $yrs Years With Them";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
		  $title.="<br/>(Individual Team Listing)";
        $query="SELECT p.player_id,last_name,first_name,hall_of_fame,x.team_id as team_name,minYr,maxYr,yrs FROM players as p,(SELECT player_id,team_id,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT year) as yrs FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id=$tid GROUP BY player_id,team_id HAVING COUNT(DISTINCT year)>=$yrs) as x WHERE p.player_id=x.player_id ORDER BY yrs DESC,minYr,last_name";
	$cols="Player|Team|First Year|Final Year|Seasons";
	$noResult="No players with 4 years of service";
      }
      else
      {
	$query="SELECT team_id as team_name,'Show Players' as showLink,COUNT(DISTINCT player_id) as players FROM (SELECT player_id,team_id,COUNT(DISTINCT year) as yrs,COUNT(DISTINCT team_id) as teams FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 GROUP BY player_id,team_id HAVING COUNT(DISTINCT year)>=$yrs) as t1 GROUP BY team_id ORDER BY players DESC";
	$cols="Team|Link|Players";
	$noResult="No team has had a player with $yrs years of service";
      }
     $getTeams=1;
     break;
   case 280:
     $title="Highest Percentage of Players In Organization Drafted By Organization";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
        $query="SELECT player_id,first_name,last_name,team_id as team_name,draft_year,draft_round,draft_pick FROM players WHERE draft_team_id=$tid ORDER BY draft_year,draft_round,draft_pick;";
	$cols="Player|Team|Year Drafted|Round|Pick";
	$noResult="No draft history";
      }
      else
      {
	$query="SELECT team_id as team_name,dftCnt,pCnt,dPct FROM teams as t,(SELECT organization_id,dftCnt,pCnt,dftCnt/pCnt as dPct FROM (SELECT draft_team_id,COUNT(DISTINCT player_id) as dftCnt FROM players WHERE organization_id=draft_team_id AND draft_team_id!=0 AND draft_league_id=$lgid GROUP BY draft_team_id) as a,(SELECT organization_id,COUNT(DISTINCT player_id) as pCnt FROM players WHERE organization_id!=0 GROUP BY organization_id) as b WHERE a.draft_team_id=b.organization_id ORDER BY dPct DESC,pCnt DESC) as x WHERE t.team_id=x.organization_id";
	$cols="Team|Draftees|Players|Pct";
	$noResult="No draft history";
      }
     $getTeams=1;
     break;
   case 281:
     $title="Fewest Innings Pitched While Recording X Wins";
     $query="SELECT w,p.player_id,first_name,last_name,hall_of_fame,year,w,l,s,ip,wpct as avg,wRat as ops FROM players as p,(SELECT player_id,year,w,l,s,ip,w/(w+l) as wpct,w/ip as wRat FROM (SELECT player_id,year,SUM(w) as w,SUM(l) as l,SUM(s) as s,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY ip,year) as a WHERE ip>0 GROUP BY w ORDER BY w DESC) as x WHERE p.player_id=x.player_id ORDER BY w DESC";
     $cols="W|Player|Year|W|L|SV|IP|WPct|W/IP";
     $noResult="No seasons completed";
     break;
   case 282:
     $title="Highest Career OPS";
     $title.="<br/>(Top $limit Players, Pitchers Excluded";
     if ($_GET['rem']==1) {$title.=", 1.000 AVG's Hidden (<a href='./statOfTheDay.php?fact=282'>Show</a>)";}
      else {$title.=", No PA Limit, <a href='./statOfTheDay.php?fact=282&rem=1'>Remove 1.000 AVG's</a>";}
     $title.=")";
     $query="SELECT * FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(bb) as bb,SUM(pa) as pa,if(SUM(ab)=0,0,(SUM(h)/SUM(ab))) as avg,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))) as obp,if(SUM(ab)=0,0,((SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab))) as slg,(if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf)))+if(SUM(ab)=0,0,((SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab)))) as ops FROM players_career_batting_stats as pcs,players as p WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 AND p.position!=1 GROUP BY pcs.player_id";
     if ($_GET['rem']==1) {$query.=" HAVING SUM(h)/SUM(ab)<1";}
     $query.=" ORDER BY ops DESC,pa DESC,hr DESC,t DESC,d DESC) as t LIMIT $limit;";
     $cols="Player|H|2B|3B|HR|BB|PA|AVG|OBP|SLG|OPS";
     $noResult="No seasons completed";
     break;
   case 283:
     $title="Most 2nd Place Finishes";
     $query="SELECT team_id as team_name,COUNT(year) as cnt FROM team_history_record WHERE league_id=$lgid AND pos=2 GROUP BY team_id ORDER BY cnt DESC;";
     $cols="Team|2nd Place Finishes";
     $noResult="No seasons completed";
     $getTeams=1;
     break;
   ## case 284: Filed under case 1
   ## case 285: Filed under case 37
   case 286:
     $title="Most Players On the All-Star Team";
     if ($showLink==1)
      {
        $tid=$_GET['team_id'];
	$yr=$_GET['year'];
        $title.="<br/>(Team Listing)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,team_name,year FROM players as p,(SELECT player_id,team_id as team_name,year FROM players_awards WHERE league_id=$lgid AND award_id=9 AND team_id=$tid AND year=$yr) as x WHERE p.player_id=x.player_id ORDER BY position,last_name,first_name;";
        $cols="Player|Team|Year";
      }
      else
      {
        $title.="<br/>(Top $limit Teams)";
        $query="SELECT team_id as team_name,year,'Show Players' as showLink,COUNT(DISTINCT player_id) as cnt FROM players_awards WHERE league_id=$lgid AND award_id=9 AND team_id!=0 GROUP BY team_id,year ORDER BY cnt DESC,year,team_id LIMIT $limit;";
        $cols="Team|Year|Link|Number of Players";
      }
     $getTeams=1;
     break;
   case 287:
     $query="SELECT player_id,year,team_id,SUM(bb) as bb FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY bb DESC LIMIT 100,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $bb=$row['bb'];
     if ($bb>70) {$bb=70;}
      else {$bb=floor($bb/10)*10;}
     $title="Most Players with $bb or More Walks";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT * FROM (SELECT pcs.team_id as team_name,pcs.year,count(player_id) as cnt FROM players_career_batting_stats as pcs,team_history as th WHERE pcs.team_id=th.team_id AND pcs.year=th.year AND pcs.league_id=$lgid AND split_id=1 AND bb>=$bb GROUP BY pcs.team_id,year ORDER BY cnt DESC,year,team_name) as t WHERE cnt>1 LIMIT $limit;";
     $cols="Team|Year|Number of Players";
     $noResult="No teams with players with $bb+ BB's in any season";
     $getTeams=1;
     break;
   ## case 288: Filed under case 3
   case 289:
     $title="Fewest Batters Faced Per Game";
     $title.="<br/>(Top $limit Players, Minimum 5 Career Games)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,SUM(bf) as bf,SUM(g) as g,SUM(bf)/SUM(g) as era FROM players as p,players_career_pitching_stats as pcb WHERE p.player_id=pcb.player_id AND pcb.league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(bf)>0 AND SUM(g)>=5 ORDER BY era LIMIT $limit";
     $cols="Player|BF|G|BF/G";
     $noResult="No ";
     break;
   case 290:
     $title="Pitchers With the Same Number of Games Started, Games Finished, and Appearances That Were Neither a Start Or Finish";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,pcb.team_id as team_abbr,year,SUM(w) as w,SUM(l) as l,SUM(s) as s,SUM(g) as g,SUM(gs) as gs,SUM(gf) as gf,SUM(ip)+SUM(ipf)/3 as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era FROM players as p,players_career_pitching_stats as pcb WHERE p.player_id=pcb.player_id AND pcb.league_id=$lgid AND pcb.split_id=1 GROUP BY player_id,year HAVING SUM(gf)=SUM(gs) AND SUM(g)-SUM(gs)-SUM(gf)=SUM(gf) ORDER BY w DESC,l,ip DESC LIMIT $limit";
     $cols="Player|Team|Year|W|L|SV|G|GS|GF|IP|ERA";
     $noResult="No player has had identical appearances in all three categories";
		 $getTeams=1;
     break;
   case 291:
     $title="Number of .300+ Batters Per Season";
     if ($showLink==1)
      {
        $year=$_GET['year'];
        $title.="<br/>($year)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_name,pa,h,d,t,hr,sb,bb,avg,ops FROM players as p,(SELECT player_id,t1.team_id,pa,h,d,t,hr,sb,bb,avg,ops FROM (SELECT player_id,team_id,year,SUM(pa) as pa,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(sb) as sb,SUM(bb) as bb,SUM(h)/SUM(ab) as avg,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))+((SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab))) as ops FROM players_career_batting_stats WHERE league_id=$lgid AND year=$year AND split_id=1 GROUP BY player_id,year HAVING SUM(ab)>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid AND year=$year) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.pa>=(3.1*t2.g) AND avg>=0.300) as x WHERE p.player_id=x.player_id ORDER BY avg DESC,last_name,first_name";
	$cols="Player|Team|PA|H|2B|3B|HR|SB|BB|AVG|OPS";
	$getTeams=1;
      }
      else
      {
        $query="SELECT year,'Show Players' as showLink,SUM(cnt) as cnt FROM (SELECT year,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,t1.team_id,t1.year,avg FROM (SELECT player_id,team_id,year,SUM(pa) as pa,if(SUM(ab)=0,0,SUM(h)/SUM(ab)) as avg FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(ab)>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.pa>=(3.1*t2.g) AND avg>=0.300) as x GROUP BY year UNION SELECT DISTINCT year,0 as cnt FROM team_history WHERE league_id=$lgid GROUP BY year) as x1 GROUP BY year ORDER BY year";
        $cols="Year|Link|Players";
      }
     $noResult="No batting stats";
     break;
	 case 292:
		 $title="Most Pitching Heavy Team Relative To League";
		 $title.="<br/>(Top $limit Teams, SD is number of standard deviations better than league average)";
		 $query="SELECT t1.team_id as team_name,t1.year,t1.r,t1.rAvg,t1.rStd,t1.SDscore,t2.r as ra,t2.rAvg as raAvg,t2.rStd as raStd,t2.SDscore as raSDscore,(t2.SDscore-t1.SDscore) as totSDscore FROM (SELECT team_id,ths.year,r,rAvg,rStd,((rAvg-r)/rStd) as SDscore FROM team_history_pitching_stats as ths,(SELECT year,league_id,sub_league_id,AVG(r) as rAvg,STDDEV_POP(r) as rStd FROM team_history_pitching_stats WHERE league_id=$lgid GROUP BY year,league_id,sub_league_id) as lgBat WHERE ths.league_id=lgBat.league_id AND ths.sub_league_id=lgBat.sub_league_id AND ths.year=lgBat.year AND ths.r>0) as t2,(SELECT team_id,ths.year,r,rAvg,rStd,((r-rAvg)/rStd) as SDscore FROM team_history_batting_stats as ths,(SELECT year,league_id,sub_league_id,AVG(r) as rAvg,STDDEV_POP(r) as rStd FROM team_history_batting_stats WHERE league_id=$lgid GROUP BY year,league_id,sub_league_id) as lgBat WHERE ths.league_id=lgBat.league_id AND ths.sub_league_id=lgBat.sub_league_id AND ths.year=lgBat.year) as t1 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY totSDscore DESC LIMIT $limit";
		 $cols="Team|Year|R|R Avg|R Std|R SD|RA|RA Avg|RA Std|RA SD|Net SD";
		 $noResult="No seasons completed";
		 $getTeams=1;
		 break;
	 case 293:
     $title="Most Players Used to Field a Position";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,position,COUNT(player_id) as players FROM (SELECT player_id,team_id,year,position,(ip+ipf/3) as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position!=1 AND position!=10 AND team_id!=0) as t WHERE ip>0 GROUP BY team_id,year,position ORDER BY players DESC LIMIT $limit";
     $cols="Team|Year|Position|Players Used";
     $noResult="No players have gone without turning a double play";
     $getTeams=1;
     break;
   case 294:
     $title="Most Defensive Innings Without Turning A Double Play At A Middle Infield Position";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT t.player_id,first_name,last_name,hall_of_fame,t.team_id as team_abbr,year,t.position,a,po,ip FROM players as p,(SELECT player_id,team_id,year,position,SUM(a) as a,SUM(po) as po,SUM(dp) as dp,(SUM(ip)+SUM(ipf)/3) as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position IN (4,6) GROUP BY player_id,year,position) as t WHERE p.player_id=t.player_id AND dp=0 ORDER BY ip DESC LIMIT $limit";
     $cols="Player|Team|Year|Pos|A|PO|IP";
     $noResult="No players have gone without turning a double play";
     $getTeams=1;
     break;
   case 295:
     $title="Highest Ratio of Wild Pitches to Walks";
     $title.="<br/>(Top $limit Players, Minimum 10 Career WP)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,ip,wp,bb,wp/bb as avg FROM players as p,(SELECT player_id,(SUM(ip)+SUM(ipf)/3) as ip,SUM(bb) as bb,SUM(wp) as wp FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as t WHERE p.player_id=t.player_id AND wp>10 ORDER BY avg DESC LIMIT $limit";
     $cols="Player|IP|WP|BB|Ratio";
     $noResult="No players have thrown wild pitches";
     break;
   case 296:
     $title="Fewest Starting Pitchers Used In A Season";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT t.team_id as team_name,t.year,COUNT(DISTINCT player_id) as players FROM team_history as t,(SELECT player_id,team_id,year,SUM(g) as g,SUM(gs) as gs FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 GROUP BY player_id,team_id,year HAVING SUM(gs)>0) as t1 WHERE t.team_id=t1.team_id AND t.year=t1.year GROUP BY t.team_id,year ORDER BY players,year LIMIT $limit";
     $cols="Team|Year|Starters Used";
     $noResult="No players have gone without turning a double play";
     $getTeams=1;
     break;
   case 297:
     $title="Most Years Placing in the League's Top 5";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,category,CONCAT(MIN(year),'-',MAX(year)) as yrRange,COUNT(DISTINCT year) as yrs FROM players as p,players_league_leader as pll WHERE p.player_id=pll.player_id AND pll.league_id=$lgid AND place<=5 AND category IN (3,6,7,8,9,10,11,12,18,29,32,34,38,40) GROUP BY player_id,category HAVING COUNT(DISTINCT year)>1 ORDER BY yrs DESC,yrRange,last_name,first_name LIMIT $limit";
     $cols="Player|Stat|Year Range|Top 5 Finishes";
     $noResult="No league leaders history";
     break;
   case 298:
     $title="Most Consecutive Seasons With A .300 Batting Average";
     $title.="<br/>(Top $limit Players, Minimum 3.1 PA/TmG)";
     $query="SET @yrCnt:=0;SET @player_id:=0;SET @year:=0;SET @strk:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,x.year-yrs+1 as strt,x.year,yrs FROM players as p,(SELECT player_id,MAX(yrCnt) as yrs,MAX(year) as year FROM (SELECT if(@player_id!=player_id,@yrCnt:=1,if(@year=t1.year-1,@yrCnt:=@yrCnt+1,@yrCnt:=1)) as yrCnt,if(@player_id!=player_id,@strk:=1,if(@year=t1.year-1,@strk,@strk:=@strk+1)) as strk,@player_id:=player_id as player_id,@year:=t1.year as year,avg FROM (SELECT player_id,team_id,year,SUM(pa) as pa,SUM(h)/SUM(ab) as avg FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(ab)>0 AND (SUM(h)/SUM(ab))>0.300 ORDER BY player_id,year) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.pa>=3.1*t2.g) as a GROUP BY player_id,strk) as x WHERE p.player_id=x.player_id ORDER BY yrs DESC,strt,last_name,first_name LIMIT $limit";
     $cols="Player|From|To|Seasons";
     $noResult="No players have had consecutive .300 AVG seasons";
     break;
   case 299:
     $title="Most Seasons Between All-Star Appearances";
     $title.="<br/>(Top $limit Players)";
     $query="SET @asYr:=0;SET @player_id:=-1;SET @pYr:=0;SELECT p.player_id,first_name,last_name,hall_of_fame,year-asYr as firstyr,year,asYr FROM players as p,(SELECT IF(@player_id!=player_id,@asYr:=0,@asYr:=year-@pYr) as asYr,@player_id:=player_id as player_id,@pYr:=year as year FROM players_awards WHERE league_id=$lgid AND award_id=9 ORDER BY player_id,year) as t WHERE p.player_id=t.player_id AND asYr>2 ORDER BY asYr DESC,firstyr,last_name,first_name LIMIT $limit";
     $cols="Player|First Appearance|Next Appearance|Seasons Between";
     $noResult="No player has waited more than 2 seasons between All-Star appearances.";
     break;
   case 300:
     $title="Players With Triples As Their Only Hits";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,SUM(h) as h,SUM(t) as t,SUM(pa) as pa,SUM(h)/SUM(ab) as avg FROM players as p,players_career_batting_stats as pcb WHERE p.player_id=pcb.player_id AND pcb.league_id=$lgid AND pcb.split_id=1 GROUP BY player_id HAVING SUM(h)=SUM(t) AND SUM(h)>0 ORDER BY t DESC,pa DESC LIMIT $limit";
     $cols="Player|H|3B|PA|AVG";
     $noResult="No player has only hit triples.";
     break;
   case 301:
     $title="Unluckiest Teams Based on Pythagorean Record";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,w,l,pct as avg,pos as stanPos,gb,rf,ra,ppct as obp,ROUND(g*ppct) as pw,g-ROUND(g*ppct) as pl,w-ROUND(g*ppct) as pdiff,gb+(w-ROUND(g*ppct))as hide FROM (SELECT thr.team_id,thr.year,pos,g,w,l,pct,gb,rf,ra,(POW(rf,POW((rf+ra)/g,.287))/(POW(rf,POW((rf+ra)/g,.287))+POW(ra,POW((rf+ra)/g,.287)))) as ppct FROM team_history_record as thr,(SELECT thb.team_id,thb.year,thb.r as rf,thp.r as ra FROM team_history_batting_stats as thb,team_history_pitching_stats as thp WHERE thb.team_id=thp.team_id AND thb.year=thp.year AND thb.league_id=$lgid) as t1 WHERE thr.team_id=t1.team_id AND thr.year=t1.year) as t2 ORDER BY pdiff,hide LIMIT $limit";
     $cols="Team|Year|W|L|Pct|Pos|GB|RF|RA|PythPct|PythW|PythL|PDiff";
     $noResult="Not enough team history";
     $getTeams=1;
     break;
   case 302:
     $query="SELECT MAX(year) as maxYr,MIN(year) as minYr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $minYr=$row['minYr'];
     $maxYr=$row['maxYr'];
     $title="Fewest Starts By A Team's Most Used Starter";
     $title.="<br/>(Top $limit Players, Ties Not Displayed)";
     $query="SELECT x.team_id as team_name,year,p.player_id,first_name,last_name,hall_of_fame,gs,g,gPct as pct FROM players as p,(SELECT t1.team_id,t1.year,player_id,gs,g,gs/g as gPct FROM (SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t1,(SELECT team_id,year,player_id,MAX(gs) as gs FROM (SELECT player_id,team_id,year,SUM(gs) as gs FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND year!=$maxYr AND team_id!=0 GROUP BY player_id,team_id,year ORDER BY gs DESC) as t2 GROUP BY team_id,year) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY gPct,gs,year LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY gPct,gs,year";
     $cols="Team|Year|Player|GS|Team G|Pct";
     $noResult="Not enough history";
     $getTeams=1;
     break;
   case 303:
     $title="Most Seasons Appeared In Without Ever Qualifying For The ERA Title";
     $title.="<br/>(Top $limit Teams, Min 50% GS)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT year) as yrs FROM players as p,(SELECT player_id,year,g,gs,ip,tg,if(ip<tg,0,1) as Qual FROM (SELECT player_id,pcb.year,SUM(pcb.g) as g,SUM(gs) as gs,SUM(ip)+SUM(ipf)/3 as ip,thr.g as tg FROM players_career_pitching_stats as pcb,team_history_record as thr WHERE pcb.year=thr.year AND pcb.team_id=thr.team_id AND pcb.league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY player_id,year) as t1) as t2 WHERE p.player_id=t2.player_id AND gs>=0.5*g GROUP BY player_id HAVING SUM(Qual)=0 ORDER BY yrs DESC,minYr,maxYr,last_name,first_name LIMIT $limit";
     $cols="Player|Debut Year|Final Year|Seasons";
     $noResult="Not enough team history";
     break;
   ## case 304: Filed under case 24
   ## case 305: Filed under case 24
   ## case 306: Filed under case 23
   case 307:
     $title="Closest Divisions";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT year,sub_league_id as sl_name,division_id,COUNT(DISTINCT team_id) as teams,AVG(gb) as ip,STD(gb) as era FROM team_history_record WHERE league_id=$lgid GROUP BY year,sub_league_id,division_id ORDER BY era,ip,teams DESC LIMIT $limit";
     $cols="Year|League|Division|Teams|Avg GB|STD GB";
     $noResult="Not enough team history";
		 $getSubLeagues=1;
		 $getDivisions=1;
     break;
   case 308:
     $title="Most No-Decisions In a Season";
     $title.="<br/>(Top $limit Players, Min 50% GS)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,g,gs,w,l,nd,ip,ipPerG as whip,era FROM players as p,(SELECT player_id,year,g,gs,w,l,gs-w-l as nd,ip,ip/g as ipPerG,9*er/ip as era FROM (SELECT player_id,year,SUM(g) as g,SUM(gs) as gs,SUM(w) as w,SUM(l) as l,SUM(ip)+SUM(ipf)/3 as ip,SUM(er) as er FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(gs)/SUM(g)>=0.5) as t1 ORDER BY nd DESC,ip DESC,era LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|Year|G|GS|W|L|ND|IP|IP/G|ERA";
     $noResult="No players without a decision";
     break;
   case 309:
     $title="Most Innings Without a No-Decision";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,team_abbr,year,g,w,l,ip FROM players as p,(SELECT player_id,team_id as team_abbr,year,(SUM(ip)+SUM(ipf)/3) as ip,SUM(g) as g,SUM(w) as w,SUM(l) as l FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND (ipf>0 OR ip>0) GROUP BY player_id,year HAVING SUM(w)+SUM(l)=SUM(g) ORDER BY ip DESC, w DESC LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|Team|Year|G|W|L|IP";
     $noResult="No players without a decision";
     $getTeams=1;
     break;
   ## case 310: Filed under case 3
   ## case 311: Filed under case 18
   case 312:
     $title="Highest Ratio of Strikeouts Per Batter Faced";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,year,k,bf,k/bf as era FROM players as p,(SELECT player_id,year,SUM(bf) as bf,SUM(k) as k FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(k)>0) as t1 WHERE p.player_id=t1.player_id ORDER BY era DESC LIMIT $limit";
     $cols="Player|Year|K|BF|K/BF";
     $noResult="No pitching history";
     break;
   case 313:
     $awquery="SELECT rookie_award_name FROM leagues WHERE league_id=$lgid;";
     $awresult=mysqli_query($db,$awquery);
     $row=mysqli_fetch_array($awresult);
     $awName=$row['rookie_award_name'];
     $title="Players With The Most Rookie of the Month Awards Who Did Not Win $awName";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT paw.player_id,first_name,last_name,hall_of_fame,paw.team_id as team_abbr,year,COUNT(DISTINCT month) as cnt FROM players as p,players_awards as paw WHERE p.player_id=paw.player_id AND paw.league_id=$lgid AND award_id=3 AND paw.player_id NOT IN (SELECT player_id FROM players_awards WHERE league_id=$lgid AND award_id=6) GROUP BY player_id,year ORDER BY cnt DESC,year,last_name,first_name LIMIT $limit;";
     $cols="Player|Team|Year|Times Rookie of the Month";
     $noResult="No players has won Rookie of the Month and not won $awName";
     $getTeams=1;
     break;
   case 314:
     $title="Most Games Played Without A Triple";
     $title.="<br/>(Top $limit Players, Pitchers Excluded)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,g,ab,h,d,hr,sb,bb,h/ab as avg FROM players as p,(SELECT player_id,SUM(g) as g,SUM(ab) as ab,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(sb) as sb,SUM(bb) as bb FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(t)=0 ORDER BY g DESC,ab DESC) as x WHERE p.player_id=x.player_id AND p.position!=1 LIMIT $limit";
     $cols="Player|G|AB|H|2B|HR|SB|BB|AVG";
     $noResult="No players without a triple in their career";
     break;
   case 315:
     $title="Players with 10 W's and 10 SV's in a Season";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,team_abbr,year,w,s FROM players as p,(SELECT player_id,team_id as team_abbr,year,SUM(w) as w,SUM(s) as s FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year) as pcs WHERE p.player_id=pcs.player_id AND w>=10 AND s>=10 ORDER BY w DESC,s DESC LIMIT $limit";
     $cols="Player|Team|Year|W|SV";
     $noResult="No players with 10 W's and 10 SV's in the same season";
     $getTeams=1;
     break;
   ## case 316: Filed under case 7
   case 317:
     $title="Most Players With At Least 100 Plate Appearances";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT team_id as team_name,year,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,team_id,year,SUM(pa) as pa FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 GROUP BY player_id,team_id,year) as t1 WHERE pa>=100 GROUP BY team_id,year ORDER BY cnt DESC,year LIMIT $limit";
     $cols="Team|Year|Players";
     $noResult="No players with 100 PA in a season for a team";
     $getTeams=1;
     break;
   case 318:
     $title="Fewest Wins By a Division Winner";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,w FROM team_history_record WHERE league_id=$lgid AND pos=1 ORDER BY w LIMIT $limit";
     $cols="Team|Year|Wins";
     $noResult="Not enough history";
     $getTeams=1;
     break;
   case 319:
     $title="Fewest Relief Appearances By Team";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,SUM(g) as g,SUM(gs) as gs,SUM(g)-SUM(gs) as ra FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 GROUP BY team_id,year ORDER BY ra LIMIT $limit";
     $cols="Team|Year|G|GS|Relief Appearances";
     $noResult="Not enough history";
     $getTeams=1;
     break;
   case 320:
     $title="Most Years Leading The League";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,category,CONCAT(MIN(year),'-',MAX(year)) as yrRange,COUNT(DISTINCT year) as yrs FROM players as p,players_league_leader as pll WHERE p.player_id=pll.player_id AND pll.league_id=$lgid AND place=1 AND category IN (3,6,7,8,9,10,11,12,18,29,32,34,38,40) GROUP BY player_id,category HAVING COUNT(DISTINCT year)>1 ORDER BY yrs DESC,yrRange,last_name,first_name";
     $cols="Player|Stat|Year Range|Years Won";
     $noResult="No player has been a repeat league leader in any major statistic";
     break;
   case 321:
     $title="Players With A Win In Their Only Pitching Appearance";
     $query="SELECT player_id,first_name,last_name,team_abbr,year,ip,ha,k,bb,era FROM (SELECT p.player_id,first_name,last_name,pcs.team_id as team_abbr,year,SUM(g) as g,SUM(w) as w,(SUM(ip)+SUM(ipf)/3) as ip,SUM(k) as k,SUM(ha) as ha,SUM(bb) as bb,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era FROM players as p,players_career_pitching_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id) as t WHERE t.g=1 AND t.w=1 ORDER BY ip DESC,k DESC,ha,last_name,first_name";
     $cols="Player|Team|Year|IP|HA|K|BB|ERA";
     $noResult="No player has had a win in his only game";
     $getTeams=1;
     break;
   ## case 322: Filed under case 3
   case 323:
     $title="Most Career Hits Without An Extra Base Hit";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,pa,h,d,t,hr,h/ab as avg FROM players as p,(SELECT player_id,SUM(pa) as pa,SUM(ab) as ab,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(d)+SUM(t)+SUM(hr)=0 ORDER BY h DESC,hr DESC,t DESC,d DESC) as x WHERE p.player_id=x.player_id AND h=(h-d-t-hr) LIMIT $limit;";
     $cols="Player|PA|H|2B|3B|HR|AVG";
     $noResult="No player has managed a hit without an extra base hit";
     $getTeams=1;
     break;
   ## case 324: Filed under case 7
   case 325:
     $title="Largest Number of Games Behind In Season Prior To Winning Division";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT thr.team_id as team_name,thr.year as year1,thr.pos as stanPos,gb,t.year,t.pos as stanPos1 FROM team_history_record as thr,(SELECT team_id,year,pos FROM team_history_record WHERE league_id=$lgid AND pos=1) as t WHERE thr.team_id=t.team_id AND thr.year=t.year-1 AND gb!=0 ORDER BY gb DESC LIMIT $limit";
     $cols="Team|Year|Finish|GB|Year|Finish";
     $noResult="Not enough history";
     $getTeams=1;
     break;
   ## case 326: Filed under case 37
   ## case 327: Filed under case 24
   ## case 328: Filed under case 24
   ## case 329: Filed under case 18
   case 330:
     $query="SELECT player_id,year,team_id,SUM(r) as r FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY r DESC LIMIT 25,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $r=$row['r'];
     if ($r>100) {$r=100;}
      else {$r=floor($r/10)*10;}
     $query="SELECT player_id,year,team_id,SUM(rbi) as rbi FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY rbi DESC LIMIT 25,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $rbi=$row['rbi'];
     if ($rbi>100) {$rbi=100;}
      else {$rbi=floor($rbi/10)*10;}
     $query="SELECT player_id,year,team_id,SUM(bb) as bb FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY bb DESC LIMIT 25,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $bb=$row['bb'];
     if ($bb>100) {$bb=100;}
      else {$bb=floor($bb/10)*10;}
     $title="All Players with $r Runs, $rbi RBI, and $bb Walks in a Season";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,pcs.team_id as team_abbr,year,r,rbi,bb FROM players as p,(SELECT player_id,team_id,year,SUM(r) as r,SUM(rbi) as rbi,SUM(bb) as bb,SUM(r)+SUM(rbi)+SUM(bb) as hide FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(r)>=$r AND SUM(rbi)>=$rbi AND SUM(bb)>=$bb ORDER BY hide DESC,year,r DESC) as pcs WHERE p.player_id=pcs.player_id";
     $cols="Player|Team|Year|R|RBI|BB";
     $noResult="No players have had a $r/$rbi/$bb season.";
     $getTeams=1;
     break;
   ## case 331: Filed under case 3
   ## case 332: Filed under case 23
   case 333:
     $title="Top $limit Oldest All-Stars";
     $query="SELECT p.player_id,last_name,first_name,hall_of_fame,paw.team_id as team_abbr,year,date_of_birth,(paw.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,DAYOFYEAR(date_of_birth) as dayBorn FROM players as p,players_awards as paw WHERE p.player_id=paw.player_id AND paw.league_id=$lgid AND award_id=9 ORDER BY age DESC,dayBorn,year,last_name,first_name LIMIT $limit;";
     $cols="Player|Team|Year|DOB|Age";
     $noResult="No players have been All-Stars";
     $getTeams=1;
     break;
   case 334:
     $query="SELECT player_id,year,team_id,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY hr DESC LIMIT 100,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $hr=$row['hr'];
     if ($hr>20) {$hr=20;}
      else {$hr=floor($hr/5)*5;}
     $query="SELECT player_id,year,team_id,SUM(bb) as bb FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY bb DESC LIMIT 100,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $bb=$row['bb'];
     if ($bb>70) {$bb=70;}
      else {$bb=floor($bb/10)*10;}
     $title="Most Players with $hr+ Home Runs And $bb+ Walks";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT * FROM (SELECT pcs.team_id as team_name,pcs.year,COUNT(player_id) as cnt FROM players_career_batting_stats as pcs,team_history as th WHERE pcs.team_id=th.team_id AND pcs.year=th.year AND pcs.league_id=$lgid AND split_id=1 AND hr>=$hr AND bb>=$bb GROUP BY pcs.team_id,year ORDER BY cnt DESC,year,team_name) as t WHERE cnt>1 LIMIT $limit;";
     $cols="Team|Year|Number of Players";
     $noResult="No teams with players with $hr+ HR's and $bb+ BB's in any season";
     $getTeams=1;
     break;
   case 335:
     $awquery="SELECT mvp_award_name,pitcher_award_name,rookie_award_name FROM leagues WHERE league_id=$lgid;";
     $awresult=mysqli_query($db,$awquery);
     $row=mysqli_fetch_array($awresult);
     $awName1=$row['mvp_award_name'];
     $awName2=$row['pitcher_award_name'];
     $awName3=$row['rookie_award_name'];
     $title="Teams To Sweep The End Of Season Awards";
     $title.="<br/>(Win $awName1, $awName2, and $awName3)";
     $query="SELECT t1.team_id as team_name,t1.year FROM (SELECT team_id,year,award_id FROM players_awards WHERE league_id=$lgid AND award_id IN (4,5,6)) as t1,(SELECT team_id,year,award_id FROM players_awards WHERE league_id=$lgid AND award_id IN (4,5,6)) as t2,(SELECT team_id,year,award_id FROM players_awards WHERE league_id=$lgid AND team_id!=0 AND award_id IN (4,5,6)) as t3 WHERE t1.team_id=t2.team_id AND t1.team_id=t3.team_id AND t2.team_id=t3.team_id AND t1.year=t2.year AND t1.year=t3.year AND t2.year=t3.year AND t1.award_id=4 AND t2.award_id=5 AND t3.award_id=6";
     $cols="Team|Year";
     $noResult="No team has won all three awards in the same season";
     $getTeams=1;
     break;
   case 336:
     $title="Most Batters Faced Per Game";
     $title.="<br/>(Top $limit Players, Min 10 Appearances)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_abbr,year,w,l,s,ip,era,bf,g,bfPerG as whip FROM players as p,(SELECT player_id,team_id,year,SUM(ip)+SUM(ipf)/3 as ip,SUM(w) as w,SUM(l) as l,SUM(s) as s,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era,SUM(bf) as bf,SUM(g) as g,SUM(bf)/SUM(g) as bfPerG FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(g)>=10 ORDER BY bfPerG DESC LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Player|Team|Year|W|L|SV|IP|ERA|BF|G|BF/G";
     $noResult="No team has won all three awards in the same season";
     $getTeams=1;
     break;
   case 337:
     $title="Number of .400+ OBP's Per Season";
     if ($showLink==1)
      {
        $year=$_GET['year'];
        $title.="<br/>($year)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_name,pa,h,d,t,hr,sb,bb,avg,obp FROM players as p,(SELECT player_id,t1.team_id,pa,h,d,t,hr,sb,bb,avg,obp FROM (SELECT player_id,team_id,year,SUM(pa) as pa,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(sb) as sb,SUM(bb) as bb,SUM(h)/SUM(ab) as avg,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))) as obp FROM players_career_batting_stats WHERE league_id=$lgid AND year=$year AND split_id=1 GROUP BY player_id,year HAVING SUM(ab)>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid AND year=$year) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.pa>=(3.1*t2.g) AND obp>=.400) as x WHERE p.player_id=x.player_id ORDER BY obp DESC,last_name,first_name";
	$cols="Player|Team|PA|H|2B|3B|HR|SB|BB|AVG|OBP";
	$getTeams=1;
      }
      else
      {
        $query="SELECT year,'Show Players' as showLink,SUM(cnt) as cnt FROM (SELECT year,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,t1.team_id,t1.year,obp FROM (SELECT player_id,team_id,year,SUM(pa) as pa,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))) as obp FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(ab)>0) as t1,(SELECT team_id,year,g FROM team_history_record WHERE league_id=$lgid) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year AND t1.pa>=(3.1*t2.g) AND obp>=.400) as x GROUP BY year UNION SELECT DISTINCT year,0 as cnt FROM team_history WHERE league_id=$lgid GROUP BY year) as x1 GROUP BY year ORDER BY year";
        $cols="Year|Link|Players";
      }
     $noResult="No batting stats";
     break;
	 case 338:
		 $query="SELECT player_id,SUM(h) as h FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id ORDER BY h DESC LIMIT 25,1;";
		 $result=mysqli_query($db,$query);
		 $row=mysqli_fetch_array($result);
		 $h=$row['h'];
		 if ($h>1000) {$h=floor($h/1000)*1000;}
		 else {$h=floor($h/100)*100;}
		 $title="Highest Percentage of Singles Among $h Hit Men";
		 $title.="<br/>(Top $limit Players)";
		 $query="SELECT p.player_id,first_name,last_name,hall_of_fame,yrs,ab,h,s,d,t,hr,avg,sPct as pct FROM players as p,(SELECT player_id,yrs,ab,h,s,d,t,hr,h/ab as avg,s/h as sPct FROM (SELECT player_id,CONCAT(MIN(year),'-',MAX(year)) as yrs,SUM(h) as h,SUM(h)-SUM(d)-SUM(t)-SUM(hr) as s,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(ab) as ab FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(h)>=$h) as t ORDER BY sPct DESC LIMIT $limit) as x WHERE p.player_id=x.player_id";
		 $cols="Player|Years|AB|H|1B|2B|3B|HR|AVG|1B Pct";
		 $noResult="No posteason stats recorded";
		 break;
	 case 339:
     $title="Highest Runs Scored/Runs Allowed Combination Relative To League";
     $title.="<br/>(Top $limit Teams, SD is number of standard deviations better than league average)";
     $query="SELECT t1.team_id as team_name,t1.year,t1.r,t1.rAvg,t1.rStd,t1.SDscore,t2.r as ra,t2.rAvg as raAvg,t2.rStd as raStd,t2.SDscore as raSDscore,(t1.SDscore+t2.SDscore) as totSDscore FROM (SELECT team_id,ths.year,r,rAvg,rStd,((rAvg-r)/rStd) as SDscore FROM team_history_pitching_stats as ths,(SELECT year,league_id,sub_league_id,AVG(r) as rAvg,STDDEV_POP(r) as rStd FROM team_history_pitching_stats WHERE league_id=$lgid GROUP BY year,league_id,sub_league_id) as lgBat WHERE ths.league_id=lgBat.league_id AND ths.sub_league_id=lgBat.sub_league_id AND ths.year=lgBat.year) as t2,(SELECT team_id,ths.year,r,rAvg,rStd,((r-rAvg)/rStd) as SDscore FROM team_history_batting_stats as ths,(SELECT year,league_id,sub_league_id,AVG(r) as rAvg,STDDEV_POP(r) as rStd FROM team_history_batting_stats WHERE league_id=$lgid GROUP BY year,league_id,sub_league_id) as lgBat WHERE ths.league_id=lgBat.league_id AND ths.sub_league_id=lgBat.sub_league_id AND ths.year=lgBat.year) as t1 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY totSDscore DESC LIMIT $limit";
     $cols="Team|Year|R|R Avg|R Std|R SD|RA|RA Avg|RA Std|RA SD|Tot SD";
     $noResult="No seasons completed";
     $getTeams=1;
     break;
   ## case 340: Filed under case 108
   case 341:
     $title="Most Consistent Attendance Figures";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,COUNT(DISTINCT year) as yrs,AVG(attendance) as attAvg,STDDEV(attendance) as attStd FROM team_history_financials WHERE league_id=$lgid GROUP BY team_id ORDER BY attStd,attAvg DESC";
     $cols="Team|Years|Avg Attendance|Attendance STD";
     $noResult="No historical attendance figures";
		 $getTeams=1;
     break;
   case 342:
     $title="Largest Team Run Differentials";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT t1.team_id as team_name,t1.year,rf,ra,abs(rf-ra) as diff,if(rf>ra,'+',if(ra>rf,'-','')) as name FROM (SELECT team_id,year,r as rf FROM team_history_batting_stats WHERE league_id=$lgid AND split_id=0) as t1,(SELECT team_id,year,r as ra FROM team_history_pitching_stats WHERE league_id=$lgid AND split_id=0) as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY diff DESC LIMIT $limit";
     $cols="Team|Year|RF|RA|Diff|+/-";
     $noResult="No games played";
     $getTeams=1;
     break;
   case 343:
     $query="SELECT player_id,year,team_id,SUM(k) as k FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year ORDER BY k DESC LIMIT 25,1;";
     $result=mysqli_query($db,$query);
     $row=mysqli_fetch_array($result);
     $k=$row['k'];
     if ($k>200) {$k=200;}
      else {$k=floor($k/50)*50;}
     $title="Most $k Strikeout Seasons";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT * FROM (SELECT p.player_id,first_name,last_name,hall_of_fame,COUNT(year) as years FROM players as p,(SELECT player_id,year,SUM(k) as k FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND k>0 GROUP BY player_id,year) as pcs WHERE p.player_id=pcs.player_id AND k>=$k GROUP BY player_id ORDER BY years DESC,last_name,first_name) as t WHERE years>0 LIMIT $limit";
     $cols="Player|Seasons";
     $noResult="No player has had a $k strikeout season";
     break;
   case 344:
     $title="Most Seasons Appeared In";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,strt,fini,years FROM players as p,(SELECT player_id,MIN(year) as strt,MAX(year) as fini,COUNT(DISTINCT year) as years FROM (SELECT player_id,year FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 UNION SELECT player_id,year FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1) as t GROUP BY player_id ORDER BY years DESC,strt LIMIT $limit) as t2 WHERE p.player_id=t2.player_id ORDER BY years DESC,strt,last_name,first_name";
     $cols="Player|Debut|Most Recent|Years Played";
     $noResult="No games played yet";
     break;
   case 345:
     $title="More Than One Run Scored Per Game Played";
     $title.="<br/>(Top $limit Players, Minimum 3 Games Played)";
     $query="SELECT p.player_id,first_name,last_name,pcb.team_id as team_abbr,year,SUM(r) as r,SUM(g) as g,SUM(r)/SUM(g) as era FROM players as p,players_career_batting_stats as pcb WHERE p.player_id=pcb.player_id AND pcb.league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(r)>SUM(g) AND SUM(g)>2 ORDER BY era DESC,r DESC LIMIT $limit";
     $cols="Player|Team|Year|R|G|R/G";
     $noResult="No games played yet";
		 $getTeams=1;
     break;
   case 346:
     $title="Most Home Runs By A Player Who Played One Season";
     $title.="<br/>(Top $limit Players, Current and Inaugural Seasons Ignored)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,mYr,hr FROM players as p,(SELECT player_id,MAX(year) as mYr,COUNT(DISTINCT year) as yrs,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as t1 WHERE p.player_id=t1.player_id AND yrs=1 AND mYr!=$lgyear AND mYr!=(SELECT MIN(year) FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1) AND hr>0 ORDER BY hr DESC LIMIT $limit";
     $cols="Player|Year|HR";
     $noResult="Not enough history";
     break;
   case 347:
     $title="Most Losses By League Wins Leader";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT year,sub_league_id as sl_name,t1.player_id,first_name,last_name,hall_of_fame,MAX(w) as w,l FROM players as p,(SELECT player_id,pcb.team_id,sub_league_id,pcb.year,th.g,SUM(pcb.w) as w,SUM(pcb.l) as l FROM players_career_pitching_stats as pcb,team_history_record as th WHERE pcb.team_id=th.team_id AND pcb.year=th.year AND pcb.league_id=$lgid AND split_id=1 GROUP BY player_id,year,sub_league_id ORDER BY year,w DESC,l) as t1 WHERE p.player_id=t1.player_id GROUP BY year,sub_league_id ORDER BY l DESC,w DESC LIMIT $limit";
     $cols="Year|League|Player|W|L";
     $noResult="No historical wins leaders";
     $getSubLeagues=1;
     break;
   case 348:
     $title="Most Starting Pitchers Used In A Season";
     $title.="<br/>(Top $limit Teams)";
     $query="SELECT team_id as team_name,year,COUNT(DISTINCT player_id) as players FROM (SELECT player_id,team_id,year,SUM(g) as g,SUM(gs) as gs FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 GROUP BY player_id,team_id,year HAVING SUM(gs)>0) as t1 GROUP BY team_id,year ORDER BY players DESC,year LIMIT $limit";
     $cols="Team|Year|Starters";
     $noResult="Not enough history";
     $getTeams=1;
     break;
   case 349:
     $title="Most Postseasons Played In";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,CONCAT(MIN(year),'-',MAX(year)) as yrs,COUNT(DISTINCT year) as yrCnt  FROM players as p,players_career_batting_stats as pcb WHERE p.player_id=pcb.player_id AND pcb.league_id=$lgid AND split_id=21 GROUP BY player_id ORDER BY yrCnt DESC,yrs LIMIT $limit";
     $cols="Player|Years|Postseasons";
     $noResult="No historical postseason stats";
     break;
	 case 350:
		 $title="Most Seasons Appeared In Since Last Home Run";
		 $title.="<br/>(Top $limit Players, Active Players Only)";
		 $query="SELECT p.player_id,first_name,last_name,hall_of_fame,lastHR,hr,(SELECT COUNT(DISTINCT year) FROM players_career_batting_stats WHERE player_id=t1.player_id AND year>lastHR AND league_id=$lgid AND split_id=1 GROUP BY player_id) as yrsSince FROM players as p,(SELECT player_id,MAX(year) as lastHR,(SELECT SUM(hr) as hr FROM players_career_batting_stats WHERE player_id=t.player_id AND year=t.year AND league_id=$lgid AND split_id=1 GROUP BY player_id,year) as hr FROM (SELECT player_id,year,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(hr)>0 ORDER BY player_id,year DESC) as t GROUP BY player_id) as t1 WHERE p.player_id=t1.player_id AND p.position!=1 AND retired=0 ORDER BY yrsSince DESC,hr,last_name,first_name LIMIT $limit";
		 $cols="Player|Last HR|HR That Year|Seasons Since";
		 $noResult="No historical postseason stats";
		 break;
	 case 351:
		 $title="Largest Percentage Decline in Attendance";
		 $title.="<br/>(Top $limit Teams)";
		 $query="SELECT t1.team_id as team_name,t1.year as year1,t1.attendance,t2.year,t2.attendance as attendance1,t2.attendance/t1.attendance as pct FROM team_history_financials as t1,team_history_financials as t2 WHERE t1.team_id=t2.team_id AND t1.year=t2.year-1 AND t1.league_id=$lgid AND t1.attendance>0 AND t2.attendance>0 ORDER BY pct LIMIT $limit";
		 $cols="Team|Year|Attendance|Year|Attendance|Pct Of Previous";
		 $noResult="No historical attendance data";
		 $getTeams=1;
		 break;
		 ## case 352: Filed under case 262
   case 353:
     $title="Most Plate Appearances In A Season While Hitting .500 Or Better";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT p.player_id,first_name,last_name,hall_of_fame,x.team_id as team_abbr,year,h,ab,pa,avg FROM players as p,(SELECT player_id,team_id,year,SUM(h) as h,SUM(ab) as ab,SUM(pa) as pa,SUM(h)/SUM(ab) as avg FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year HAVING SUM(ab)>0 AND (SUM(h)/SUM(ab))>=.500 ORDER BY pa DESC,h DESC,year LIMIT $limit) as x WHERE p.player_id=x.player_id ORDER BY pa DESC,h DESC,year";
     $cols="Player|Team|Year|H|AB|PA|AVG";
     $noResult="No player has hit over .500 in any amount of PA's";
     $getTeams=1;
     break;
   case 354:
     $title="Most Different Batters Hit By Pitch";
     $title.="<br/>(Top $limit Teams)";
		 $query="SELECT team_id as team_name,year,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,team_id,year FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 AND hp>0) as t1 GROUP BY team_id,year ORDER BY cnt DESC LIMIT $limit";		 
     $cols="Team|Year|Players Hit";
     $noResult="Not enough history";
     $getTeams=1;
     break;
   case 355:
     $title="Fewest Plate Appearances By A Team's Most Used Batter";
     $title.="<br/>(Top $limit Players)";
     $query="SELECT x.team_id as team_name,year,p.player_id,first_name,last_name,hall_of_fame,pa FROM players as p,(SELECT team_id,year,player_id,MAX(pa) as pa FROM (SELECT player_id,team_id,year,SUM(pa) as pa FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND year!=$lgyear AND team_id!=0 GROUP BY player_id,team_id,year ORDER BY pa DESC) as t1 GROUP BY team_id,year ORDER BY pa,year LIMIT $limit) as x WHERE p.player_id=x.player_id";
     $cols="Team|Year|Player|PA";
     $noResult="Not enough history";
     $getTeams=1;
     break;
	 case 356:
		 $title="Most Career Home Runs By A Player With Initials H.R.";
		 $title.="<br/>(Top $limit Players)";
		 $query="SELECT a.player_id,first_name,last_name,hall_of_fame,hr FROM (SELECT player_id,first_name,last_name,hall_of_fame FROM players WHERE first_name LIKE 'H%' AND last_name LIKE 'R%') as a,(SELECT player_id,SUM(hr) as hr FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(hr)>0) as b WHERE a.player_id=b.player_id ORDER BY hr DESC LIMIT $limit";
		 $cols="Player|HR";
		 $noResult="No players with initials H.R. have hit any home runs";
		 break;
	 case 357:
		 $awquery="SELECT mvp_award_name FROM leagues WHERE league_id=$lgid;";
		 $awresult=mysqli_query($db,$awquery);
		 $row=mysqli_fetch_array($awresult);
		 $awName1=$row['mvp_award_name'];
		 $title="Fewest RBI Among $awName1 Winners";
		 $title.="<br/>(Top $limit Players)";
		 $query="SELECT p.player_id,first_name,last_name,hall_of_fame,sub_league_id as sl_name,year,g,ab,r,h,d,t,hr,sb,bb,rbi,h/ab as avg FROM players as p,(SELECT t1.player_id,sub_league_id,t1.year,g,ab,r,h,d,t,hr,sb,bb,rbi FROM (SELECT player_id,year,SUM(g) as g,SUM(ab) as ab,SUM(r) as r,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(sb) as sb,SUM(bb) as bb,SUM(rbi) as rbi FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id,year) as t1,(SELECT player_id,sub_league_id,year FROM players_awards WHERE league_id=$lgid AND award_id=5) as t2 WHERE t1.player_id=t2.player_id AND t1.year=t2.year ORDER BY rbi,year) as x WHERE p.player_id=x.player_id AND p.position!=1 LIMIT $limit";
		 $cols="Player|League|Year|G|AB|R|H|2B|3B|HR|SB|BB|RBI|AVG";
		 $noResult="No awards history";
		 $getSubLeagues=1;
		 break;
		 ## case 358: Filed under case 54
   case 359:
     $title="Most Career Home Runs by Batter Weight";
     $title.="<br/>(Earliest Occurrence Shown)";
     $query="SELECT weightSort as hide,weight,player_id,first_name,last_name,hall_of_fame,team_abbr,MAX(hr) as hr FROM (SELECT weight as weightSort,CONCAT(floor(weight/5)*5,'-',floor(weight/5)*5+5-1) as weight,player_id,first_name,last_name,hall_of_fame,team_abbr,hr FROM (SELECT p.player_id,last_name,first_name,hall_of_fame,weight,pcs.team_id as team_abbr,SUM(hr) as hr FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND pcs.split_id=1 GROUP BY player_id HAVING SUM(hr)>0 ORDER BY weight,hr DESC) as t) as x GROUP BY weight ORDER BY hide;";
     $cols="Weight|Player|Team|HR";
     $noResult="No home runs hit";
     $getTeams=1;
     break;
   case 360:
     $title="Most Common Last Names Among Active Players";
     if ($showLink==1)
      {
        $lastName=$_GET['lname'];
        $title.="<br/>(Players With $lastName As Their Last Name)";
	$query="SELECT player_id,first_name,last_name,hall_of_fame,organization_id as team_name,position,date_of_birth FROM players WHERE league_id=$lgid AND retired=0 AND last_name LIKE '$lastName' ORDER BY date_of_birth,first_name";
	$cols="Player|Team|Pos|Birthday";
		  $getTeams=1;
      }
      else
      {
        $title.="<br/>(Top $limit Names)";
	$query="SELECT last_name as lname,'Show Players' as showLink,count(player_id) as cnt FROM players WHERE league_id=$lgid AND retired=0 GROUP BY last_name ORDER BY cnt DESC,lname LIMIT $limit;";
	$cols="Name|Link|Count";
      }
     break;
   case 361:
     $title="Most Players Used In Franchise History";
     $query="SELECT team_id as team_name,COUNT(DISTINCT player_id) as cnt FROM (SELECT player_id,team_id FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 UNION SELECT player_id,team_id FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0) as t GROUP BY team_id ORDER BY cnt DESC;";
     $cols="Team|Players Used";
     $getTeams=1;
     break;
   case 362:
     $title="Most .500+ Seasons";
     $query="SELECT team_id as team_name,COUNT(year) as cnt FROM team_history_record WHERE league_id=$lgid AND pct>=.500 GROUP BY team_id ORDER BY cnt DESC;";
     $cols="Team|.500 Seasons";
     $getTeams=1;
     break;
   case 363:
     $title="Percentage Of Players Who've Played For A Franchise That Were Drafted By Them";
     $query="SELECT team_id as team_name,d,nond,cnt,d/cnt as pct FROM (SELECT team_id,SUM(IF(team_id=draft_team_id,1,0)) as d,SUM(if(team_id!=draft_team_id,1,0)) as nond,COUNT(*) as cnt FROM (SELECT pcs.team_id,p.player_id,draft_team_id FROM players as p,(SELECT team_id,year,player_id FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0 UNION SELECT team_id,year,player_id FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND team_id!=0) as pcs WHERE p.player_id=pcs.player_id GROUP BY player_id,team_id) as t1 GROUP BY team_id) as x ORDER BY pct DESC";
     $cols="Team|Drafted Players|Non-drafted Players|Total Players|Pct Drafted";
     $getTeams=1;
     break;
   case 364:
     $title="Percentage of Players With X Wins Divided In Groups of 5 Wins";
     if ($showLink==1)
      {
        $bucket=$_GET['bucket'];
        switch ($bucket)
	 {
 	   case -1: $min=0;$max=0;  break;
 	   case 0 : $min=1;$max=4; break;
 	   default: $min=5*$bucket;$max=5*$bucket+4; break;
	 }
        $title.="<br/>(Players with $min-$max Wins)";
        $query="SELECT p.player_id,first_name,last_name,hall_of_fame,w,l,s,ip,era FROM players as p,(SELECT player_id,SUM(w) as w,SUM(l) as l,SUM(s) as s,SUM(ip)+SUM(ipf)/3 as ip,9*SUM(er)/(SUM(ip)+SUM(ipf)/3) as era FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(w)>=$min AND SUM(w)<=$max) as x WHERE p.player_id=x.player_id ORDER BY w DESC,era";
        $cols="Player|W|L|SV|IP|ERA";
      }
      else
      {
        $query="SELECT bucket as hide,if(bucket=-1,0,if(bucket=0,CONCAT('1-',5-1),CONCAT(bucket*5,'-',bucket*5+5-1))) as bucket,'Show Players' as showLink,COUNT(DISTINCT player_id) as players,COUNT(DISTINCT player_id)/(SELECT COUNT(DISTINCT player_id) FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1) as longPct FROM (SELECT if(w=0,-1,FLOOR(w/5)) as bucket,player_id,w FROM (SELECT player_id,SUM(w) as w FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id ORDER BY w DESC) as t1) as t2 GROUP BY bucket ORDER BY hide DESC";
        $cols="Bucket|Link|Players|Pct";
      }
     break;
   case 365:
     $title="Number of Players With Each Uniform Number";
     if ($showLink==1)
      {
        $uni=$_GET['uni'];
        $title.="<br/>(Active Players With Uniform Number $uni)";
        $query="SELECT player_id,first_name,last_name,hall_of_fame,team_id as team_name,position FROM players WHERE league_id=$lgid AND `Uniform Number`=$uni ORDER BY last_name,first_name";
        $cols="Player|Team|Pos";
		  $getTeams=1;
      }
      else
      {
        $title.="<br/>(Active Players Only)";
        $query="SELECT `Uniform Number` as uni,'Show Players' as showLink,COUNT(DISTINCT player_id) as cnt FROM players WHERE league_id=$lgid GROUP BY `Uniform Number` ORDER BY uni";
        $cols="Uniform Number|Link|Players";
      }
     break;
 }

##### Get Team Names/Abbreviations #####
if ($getTeams==1)
 {
//   $tquery="SELECT team_id,year,name,nickname,abbr FROM team_history WHERE league_id=$lgid UNION SELECT team_id,'$lgyear' as year,name,nickname,abbr FROM teams WHERE league_id=$lgid AND allstar_team=0 ORDER BY year,team_id;";
   $tquery="SELECT team_id,year,name,nickname,abbr FROM team_history WHERE league_id=$lgid UNION SELECT team_id,'$lgyear' as year,name,nickname,abbr FROM teams WHERE allstar_team=0 ORDER BY year,team_id;";
   $tresult=mysqli_query($db,$tquery);
   while ($row=mysqli_fetch_array($tresult))
    {
      $tid=$row['team_id'];
      $yr=$row['year'];
      $teams[$tid][$yr]['name']=$row['name']." ".$row['nickname'];
      $teams[$tid][$yr]['city']=$row['name'];
      $teams[$tid][$yr]['abbr']=$row['abbr'];
    }

 }
unset($yr);
##### Get SubLeague Names/Abbreviations #####
if ($getSubLeagues==1)
 {
   $slquery="SELECT * FROM sub_leagues WHERE league_id=$lgid;";
   $slresult=mysqli_query($db,$slquery);
   while ($row=mysqli_fetch_array($slresult))
    {
      $slid=$row['sub_league_id'];
      $subleagues[$slid]['name']=$row['name'];
      $subleagues[$slid]['abbr']=$row['abbr'];
    }
 }
##### Get SubLeague Names/Abbreviations #####
if ($getDivisions==1)
 {
   $slquery="SELECT * FROM divisions WHERE league_id=$lgid;";
   $slresult=mysqli_query($db,$slquery);
   while ($row=mysqli_fetch_array($slresult))
    {
      $divid=$row['division_id'];
      $slid=$row['sub_league_id'];
      $divisions[$divid][$slid]['name']=$row['name'];
    }
 }

echo "<div class='textbox'>\n";
##### Execute Query #####
$e=explode(";",$query);
for ($i=0;$i<count($e);$i++)
 {
   if ($e[$i]=="") {continue;}
   $query=$e[$i].";";
   if ($_GET['showq']==1) {echo $query."<br/>\n";}
   $result=mysqli_query($db,$query);
 }
$nRows=mysqli_num_rows($result);

##### Display Results #####
echo " <table cellpadding=0 cellspacing=0 border=0>\n";
echo "  <tr class='title2'><td style='padding:2px'>$title</td></tr>\n";
echo "  <tr><td>\n";
if (!mysqli_num_rows($result)) {echo $noResult;}
 else
 {
   $cnt=0;
   echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='935px'>\n";
   ## Display Column Headers
   $eCols=explode("|",$cols);
   $nCols=count($eCols);
   echo "    <thead><tr class='headline'>";
   foreach ($eCols as $key => $lbl)
    {
      switch ($lbl)
       {
         case 'Player':
         case 'Pitcher':
         case 'Catcher':
	 case 'Team':
	 case 'Current Organization':
		   case 'Drafted By':
	 case 'By':
	 case 'With':
	 case 'Name':
	 case 'Height':
	 case 'Weight':
		   case 'League':
		   case 'Division':
	 case 'Bucket':
	 case 'Uniform Number':
	 case 'Month-Day':
 	   echo "<td class='hsc2_l'>$lbl</td>";
	   break;
	 default:
 	   echo "<td class='hsc2'>$lbl</td>";
	   break;
       }
    }
   echo "</tr></thead>\n";

   ## Display Data
   while ($row=mysqli_fetch_array($result))
    {
      $pid=$row['player_id'];
      $yr=$row['year'];
      $cls='s'.($cnt%2+1);
      $cnt++;

      echo "    <tr class='$cls'>";

      $numF=mysqli_num_fields($result);
      for ($i=0;$i<$numF;$i++)
       {
				$fieldInfo = mysqli_fetch_field_direct( $result, $i);
				$fieldName = $fieldInfo->name;
         switch ($fieldName)
	  {
            case 'player_id':
	      $name=$row['first_name']." ".$row['last_name'];
	      $sortname=$row['last_name'].", ".$row['first_name'];
	      $hof=$row['hall_of_fame'];
	      echo "<td class='".$cls."_l' sorttable_customkey=\"".$sortname."\"><a href='./player.php?player_id=$pid'>$name</a>";
	      if ($hof==1) {echo "+";$hofFlag=1;}
	      echo "</td>";
	      break;
            case 'player_id2':
	      $name=$row['first_name2']." ".$row['last_name2'];
	      $sortname=$row['last_name2'].", ".$row['first_name2'];
	      $hof=$row['hall_of_fame'];
	      echo "<td class='".$cls."_l' sorttable_customkey=\"".$sortname."\"><a href='./player.php?player_id=$pid'>$name</a>";
	      if ($hof==1) {echo "+";$hofFlag=1;}
	      echo "</td>";
	      break;
	    case 'first_name':
	    case 'last_name':
	    case 'hall_of_fame':
	    case 'first_name2':
	    case 'last_name2':
	    case 'hall_of_fame2':
	    case 'dayBorn':
	    case 'hide':
	    case 'bday':
	      break;
            case 'fname':
            case 'lname':
            case 'nname':
            case 'bucket':
  	    case 'uni':
	      $val=$row[$fieldName];
	      echo "<td class='".$cls."_l'>$val</td>";
	      break;
  	    case 'bmonth':
	      $val=$row[$fieldName];
              $moArray=array("January","February","March","April","May","June","July","August","September","October","November","December");
	      $val=$moArray[$val-1]." ".$row['bday'];
	      echo "<td class='".$cls."_l' sorttable_customkey=\"".($row['bmonth']*100+$row['bday'])."\">$val</td>";
	      break;
            case 'height':
	      $val=$row[$fieldName];
              $e=explode("'",$val);
	      $in=$e[1];
	      $in=substr($in,1,strlen($in)-2);
	      $in=12*$e[0]+$in;
	      echo "<td class='".$cls."_l' sorttable_customkey=\"".$in."\">$val</td>";
	      break;
            case 'weight':
			  $val=$row[$fieldName];
              $e=explode("-",$val);
			  echo "<td class='".$cls."_l' sorttable_customkey=\"".$e[0]."\">$val lbs</td>";
	      break;
            case 'wt':
	      $val=$row[$fieldName];
	      echo "<td>$val lbs</td>";
	      break;
            case 'team_name':
	    case 'team_name2':
	      $tid=$row[$fieldName];
              if (!is_numeric($tid)) {echo "<td class='".$cls."_l'>$tid</td>"; break;}
	      if (isset($yr))
	       {
	         $name=$teams[$tid][$yr]['name'];
	         if (($name=="")||($name==" ")) {$name=$teams[$tid][$lgyear]['name'];}
		 if ($tid==0) {echo "<td class='".$cls."_l'>$name</td>";}
		  else {echo "<td class='".$cls."_l'><a href='./team_summary.php?team_id=$tid&year=$yr'>$name</a></td>";}
	       }
	       else
	       {
	         $name=$teams[$tid][$lgyear]['name'];
		 if ($tid==0) {echo "<td class='".$cls."_l'>$name</td>";}
		  else {echo "<td class='".$cls."_l'><a href='./team_hist.php?team_id=$tid'>$name</a></td>";}
	       }
	      break;
            case 'team_abbr':
              $tid=$row[$fieldName];
	      if (isset($yr))
	       {
	         $name=$teams[$tid][$yr]['abbr'];
	         if (($name=="")||($name==" ")) {$name=$teams[$tid][$lgyear]['abbr'];}
		 if ($tid==0) {echo "<td class='".$cls."_l'>$name</td>";}
	          else {echo "<td class='".$cls."_l'><a href='./team_summary.php?team_id=$tid&year=$yr'>$name</a></td>";}
	       }
	       else
	       {
	         $name=$teams[$tid][$lgyear]['abbr'];
		 if ($tid==0) {echo "<td class='".$cls."_l'>$name</td>";}
	          else {echo "<td class='".$cls."_l'><a href='./team_hist.php?team_id=$tid'>$name</a></td>";}
	       }
	      break;
            case 'team_abbr2':
	      $tid=$row[$fieldName];
	      $yr=$row['year2'];
	      if (isset($yr))
	       {
	         $name=$teams[$tid][$yr]['abbr'];
	         if (($name=="")||($name==" ")) {$name=$teams[$tid][$lgyear]['abbr'];}
		 if ($tid==0) {echo "<td class='".$cls."_l'>$name</td>";}
	          else {echo "<td class='".$cls."_l'><a href='./team_summary.php?team_id=$tid&year=$yr'>$name</a></td>";}
	       }
	       else
	       {
	         $name=$teams[$tid][$lgyear]['abbr'];
		 if ($tid==0) {echo "<td class='".$cls."_l'>$name</td>";}
	          else {echo "<td class='".$cls."_l'><a href='./team_hist.php?team_id=$tid'>$name</a></td>";}
	       }
	      break;
	    case 'sl_name':
	    case 'sl_name1':
	    case 'sl_name2':
	      $val=$row[$fieldName];
              $val=$subleagues[$val]['name'];
	      echo "<td class='".$cls."_l'>$val</td>";
	      break;
	    case 'sl_abbr':
	      $val=$row[$fieldName];
              $val=$subleagues[$val]['abbr'];
	      echo "<td class='".$cls."_l'>$val</td>";
	      break;
	    case 'division_id':
	      $slid=$row['sl_name'];
	      $val=$row[$fieldName];
              $val=$divisions[$val][$slid]['name'];
	      echo "<td class='".$cls."_l'>$val</td>";
	      break;
  	    case 'draft_year':
	      $val=$row[$fieldName];
	      if ($val==0) {$valText='Inaugural';} else {$valText=$val;}
	      echo "<td sorttable_customkey=\"$val\">$valText</td>";
	      break;
	    case 'avg':
	    case 'obp':
	    case 'slg':
            case 'ops':
            case 'wOBA':
            case 'avg_diff':
            case 'winPct':
	      $val=$row[$fieldName];
  	      $val=sprintf("%.3f",$val);
              if ($val<1) {$val=strstr($val,".");}
	      echo "<td>$val</td>";
	      break;
 	    case 'era':
 	    case 'era1':
 	    case 'eraDiff':
	    case 'whip':
            case 'kper9':
            case 'bbper9':
            case 'hper9':
            case 'kperbb':
	    case 'rng':
	    case 'SDscore':
	    case 'raSDscore':
	    case 'totSDscore':
	    case 'rDiff':
	      $val=$row[$fieldName];
  	      $val=sprintf("%.2f",$val);
	      echo "<td>$val</td>";
	      break;
	    case 'ip':
	    case 'ip1':
	    case 'ip2':
	    case 'fip':
	    case 'rAvg':
	    case 'rStd':
	    case 'raAvg':
	    case 'raStd':
	      $val=$row[$fieldName];
  	      $val=sprintf("%.1f",$val);
              if (($val<1)&&($val!=0)) {$val=strstr($val,".");}
	      echo "<td>$val</td>";
	      break;
	    case 'rtoPct':
	    case 'pct':
	      $val=$row[$fieldName];
	      $val=sprintf("%.1f",100*$val);
	      if ($val==0) {$val="0.0";}
	       elseif ($val<1) {$val=strstr($val,".");}
	      echo "<td>$val</td>";
	      break;
	    case 'longPct':
	      $val=$row[$fieldName];
	      $val=sprintf("%.2f",100*$val);
	      if ($val==0) {$val="0.0";}
	      echo "<td>$val</td>";
	      break;
            case 'stanPos':
            case 'stanPos1':
            case 'stanPos2':
	      $val=$row[$fieldName];
 	      $val=ordinal_suffix($val,1);
	      echo "<td sorttable_customkey=\"".$row[$fieldName]."\">$val</td>";
	      break;
            case 'position':
            case 'position1':
            case 'position2':
	      $val=$row[$fieldName];
 	      $valText=get_pos($val,1);
	      echo "<td sorttable_customkey=\"".$val."\">$valText</td>";
	      break;
            case 'award_id':
	      $val=$row[$fieldName];
 	      $val=get_award($val);
	      echo "<td>$val</td>";
	      break;
	    case 'made_playoffs':
	    case 'won_playoffs':
	      $val=$row[$fieldName];
  	      if ($val==1) {$val="X";} else {$val="";}
	      echo "<td>$val</td>";
	      break;
            case 'category':
	      $val=$row[$fieldName];
	      switch ($val)
	       {
	         case 3: $val="H"; break;
	         case 6: $val="2B"; break;
	         case 7: $val="3B"; break;
	         case 8: $val="HR"; break;
	         case 9: $val="SB"; break;
	         case 10: $val="RBI"; break;
	         case 11: $val="R"; break;
	         case 12: $val="BB"; break;
	         case 18: $val="AVG"; break;
	         case 29: $val="W"; break;
	         case 32: $val="SV"; break;
	         case 34: $val="IP"; break;
	         case 38: $val="K"; break;
	         case 40: $val="ERA"; break;
	       }
	      echo "<td>$val</td>";
	      break;
            case 'amt1':
            case 'amt2':
	      $val=$row[$fieldName];
              $cat=$row['category'];
	      if ($cat>0)
	       {
	         switch ($cat)
	          {
	            case 18: $val=sprintf("%.3f",$val); if ($val<1) {$val=strstr($val,".");} break;
	            case 34: $val=sprintf("%.1f",$val); if (($val<1)&&($val!=0)) {$val=strstr($val,".");} break;
	            case 40: $val=sprintf("%.2f",$val); break;
		  }
	       }
	      echo "<td>$val</td>";
	      break;
		  case 'attendance':
		  case 'attendance1':
            case 'attAvg':
            case 'attStd':
	      $val=$row[$fieldName];
	      $val=number_format($val,0,".",",");
	      echo "<td>$val</td>";
	      break;
            case 'showLink':
	      $val=$row[$fieldName];
	      echo "<td class='$cls'><a href='./statOfTheDay.php?fact=$chkDay&show=1";
              switch ($chkDay)
	       {
	         case 5:
	         case 13:
	         case 43:
	         case 50:
	         case 52:
	         case 104:
	         case 204:
	         case 206:
			   case 225:
	         case 229:
	         case 256:
	         case 274:
	         case 279:
	         case 280:
		   echo "&team_id=".$row['team_name'];
		   break;
	         case 41:
	         case 102:
	         case 136:
	         case 164:
			   case 227:
			   case 291:
	         case 337:
		   echo "&year=".$row['year'];
		   break;
			   case 51:
				   echo "&name=".$row['fname'];
				   break;	      
			   case 78:
				   echo "&player_id=".$row['player_id'];
				   break;	      
			   case 127:
	         case 169:
	         case 286:
		   echo "&team_id=".$row['team_name']."&year=".$row['year'];
		   break;
	         case 128:
		   echo "&bday=".sprintf("%02d",$row['bmonth'])."-".sprintf("%02d",$row['bday']);
		   break;
	         case 130:
	         case 203:
	         case 262:
	         case 352:
	         case 364:
		   echo "&bucket=".$row['hide'];
		   break;
	         case 360:
		   echo "&lname=".$row['lname'];
		   break;
	         case 365:
		   echo "&uni=".$row['uni'];
		   break;
	       }
	      echo "'>$val</a></td>";
	      break;
            default:
	      $val=$row[$fieldName];
	      echo "<td>$val</td>";
	      break;
	  }
       }
      echo "</tr>\n";
    }
   echo "   </table>\n";
 }
echo "  <td></tr>\n";
echo " </table>\n";
echo "</div>\n";

echo "<div class='textbox' style='border:0;width=935px;'>\n";
echo " <table cellpadding=2 cellspacing=0 border=0>\n";
echo "  <tr><td><a href='./statOfTheDay.php?fact=$chkDay'>Permalink to this Stat of the Day</a></td></tr>\n";
echo "  <tr><td><a href='./sotdIndex.php'>Stat of the Day Index</a></td></tr>\n";
echo " </tr></table>\n";
echo "</div>\n";

##### Birthdays #####
$lgday=$date->format("d");
$lgmo=$date->format("m");
$query="SELECT player_id,first_name,last_name,hall_of_fame,organization_id,position,age,date_of_birth,retired FROM players WHERE MONTH(date_of_birth)=$lgmo AND DAY(date_of_birth)=$lgday AND player_id IN (SELECT DISTINCT player_id FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 UNION SELECT DISTINCT player_id FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1) ORDER BY age,last_name,first_name;";
$result=mysqli_query($db,$query);

echo "<div class='textbox'>\n";
if ($_GET['showq']==1) {echo $query;}
echo " <table cellpadding=0 cellspacing=0 border=0>\n";
echo "  <tr class='title2'><td style='padding:2px'>Today's Birthdays</td></tr>\n";
echo "  <tr><td>\n";
## Display
if (!mysqli_num_rows($result)) {echo "No players born on this date.";}
 else
 {
   $cnt=0;
   echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='465px'>\n";
   ## Display Column Headers
   echo "    <thead><tr class='headline'><td class='hsc2'>Pos</td><td class='hsc2_l'>Player</td><td class='hsc2_l'>Team</td><td class='hsc2'>Age</td><td class='hsc2'>Birthday</td></tr></thead>\n";
   ## Display Data
   while ($row=mysqli_fetch_array($result))
    {
      $pid=$row['player_id'];
      $yr=$row['year'];
      $cls='s'.($cnt%2+1);
      $cnt++;

      echo "    <tr class='$cls'>";
      echo "<td>".get_pos($row['position'],1)."</td>";
      $name=$row['first_name']." ".$row['last_name'];
      $hof=$row['hall_of_fame'];
      echo "<td class='".$cls."_l' sorttable_customkey=\"".$row['last_name'].", ".$row['first_name']."\"><a href='./player.php?player_id=$pid'>$name</a>";
      if ($hof==1) {echo "+";$hofFlag=1;}
      echo "</td>";
      $tid=$row['organization_id'];
      $ret=$row['retired'];
      if (!isset($teams[$tid]))
       {
         $tquery="SELECT team_id,'$lgyear' as year,name,nickname,abbr FROM teams WHERE allstar_team=0 ORDER BY year,team_id;";
         $tresult=mysqli_query($db,$tquery);
	 while ($trow=mysqli_fetch_array($tresult))
     	  {
  	    $team_id=$trow['team_id'];
	    $yr=$trow['year'];
      	    $teams[$team_id][$yr]['name']=$trow['name']." ".$trow['nickname'];
	    $teams[$team_id][$yr]['city']=$trow['name'];
      	    $teams[$team_id][$yr]['abbr']=$trow['abbr'];
	  }
       }
      if ($ret==1) {$tname="Retired";}
       elseif ($tid==0) {$tname="Free Agent";}
       else {$tname="<a href='$lgpath/teams/team_$tid.html'>".$teams[$tid][$lgyear]['abbr']."</a>";}
      echo "<td class='".$cls."_l'>$tname</td>";
      echo "<td>".$row['age']."</td>";
      unset($dob);
      $dob=new Date($row['date_of_birth']);
      $dispDob=$dob->format("F j, Y");
      echo "<td>".$dispDob."</td>";
      echo "</tr>\n";
    }
   echo "   </table>\n";
 }
echo "  </td></tr>\n";
echo " </table>\n";
echo "</div>\n";

if ($hofFlag==1) 
 {
   echo "<div class='textbox' style='border:0;width=935px;'>\n";
   echo " <table cellpadding=2 cellspacing=0 border=0>\n";
   echo "  <tr><td>+ indicates Hall of Famer</td></tr>\n";
   echo " </tr></table>\n";
   echo "</div>\n";
 }

  mysqli_close($db);

  ################## END OF PAGE #########################
  echo " </div>   <!-- END contentpane DIV -->\n";
  page_foot($_SESSION['lgpath']);

?>
