<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgpath=$_SESSION['lgpath'];

  $date=new Date($_SESSION['lgdate']);

  $lgyear=$date->format("Y");



  $scope=$_GET['scope'];

  if ((($lgyear%400)==0) || ((($lgyear%100)!=0) && (($lgyear%4)==0)))

  {

	  $monthDays=Array("1"=>31,"2"=>29,"3"=>31,"4"=>30,"5"=>31,"6"=>30,"7"=>31,"8"=>31,"9"=>30,"10"=>31,"11"=>30,"12"=>31);

  }

  else

  {

	  $monthDays=Array("1"=>31,"2"=>28,"3"=>31,"4"=>30,"5"=>31,"6"=>30,"7"=>31,"8"=>31,"9"=>30,"10"=>31,"11"=>30,"12"=>31);

  }

  $frDay=$_GET['frDay'];

  if ($frDay=="") {$frDay="1/1";$minDay=1;}

  else

  {

	  $e=explode("/",$frDay);

       	  $mo=$e[0];

	  if ($mo[0]==0) {$mo=substr($mo,1);}

       	  if ($mo<1) {$mo=1;}

	  if ($mo>12) {$mo=12;}

       	  $dy=$e[1];

	  if ($dy[0]==0) {$dy=substr($dy,1);}

       	  if ($dy<1) {$dy=1;}

	  if ($dy>$monthDays[$mo]) {$dy=$monthDays[$mo];}

       	  $frDay=$mo."/".$dy;

	  unset($tmpdate);

       	  $tmpdate=new Date($frDay."/".$lgyear);

	  $minDay=$tmpdate->format("z");

  }

  $toDay=$_GET['toDay'];

  if ($toDay=="") {$toDay=$date->format("m/d");$maxDay=1;}

  else

  {

	  $e=explode("/",$toDay);

       	  $mo=$e[0];

	  if ($mo[0]==0) {$mo=substr($mo,1);}

       	  if ($mo<1) {$mo=1;}

	  if ($mo>12) {$mo=12;}

       	  $dy=$e[1];

	  if ($dy[0]==0) {$dy=substr($dy,1);}

       	  if ($dy<1) {$dy=1;}

	  if ($dy>$monthDays[$mo]) {$dy=$monthDays[$mo];}

       	  $toDay=$mo."/".$dy;

	  unset($tmpdate);

       	  $tmpdate=new Date($toDay."/".$lgyear);

	  $maxDay=$tmpdate->format("z")+1;

  }

  if ($minDay==$maxDay) {$minDay-=2;}

  if ($minDay>$maxDay)

  {

       	  $tmp=$frDay;

	  $frDay=$toDay;

       	  $toDay=$tmp;

	  $tmp=$minDay;

       	  $minDay=$maxDay;

	  $maxDay=$minDay;

  }



  # Title Bar

  $title="Standings";



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  nav_toolbar("season","Season");

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";





  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");

  

  ##### Check that regular season has begun

  $gp[0]=0;

  $gp[2]=0;

  $query="SELECT game_type,COUNT(game_id) as g FROM games WHERE league_id=".$lgid." AND played=1 GROUP BY game_type;";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  while ($row=mysqli_fetch_array($result))

  {

	  $gtype=$row['game_type'];

	  $gp[$gtype]=$row['g'];

  }

  if (($gp[0]==0)&&($gp[2]!=0)&&(($scope=='Season')||($scope==''))) {$scope="ST";}

  if ($scope=="") {$scope="Season";}



  if ($scope=='ST') {$title="Spring Training ";}

  if ($scope=='Season') {$title="Regular Season ";}

  $title.="Standings";

  if ($scope=='LastSim') {$title.=" Over The Last Sim";}	

  if ($scope=='dRange') {$title.=" From $frDay to $toDay";}



  ##### Filters

  echo "<div class='textbox'>\n";

  echo " <table cellspacing=0 cellpadding=2 border=0>\n";

  echo "  <tr class='title'><td colspan=12>Filters</td></tr>\n";

  echo "  <form method='get' action='standings.php' class='inline'>\n";

  echo "   <tr>\n";

  ## Show Scope Filter

  echo "    <td><b>Scope:</b></td>\n";

  if ($gp[2]!=0)

  {

       	  echo "    <td><input type='radio' name='scope' value='ST' id='ST'";

	  if ($scope=='ST') {echo " checked='checked'";}

       	  echo "></td><td valign=top><label for='ST'>Spring Training</label></td>\n";

  }

  echo "    <td><input type='radio' name='scope' value='LastSim' id='LastSim'";

  if ($scope=='LastSim') {echo " checked='checked'";}

  echo "></td><td valign=top><label for='LastSim'>Last Sim</label></td>\n";

  if ($gp[0]!=0)

  {

	  echo "    <td><input type='radio' name='scope' value='Season' id='Season'";

       	  if ($scope=='Season') {echo " checked='checked'";}

	  echo "></td><td valign=top><label for='Season'>Season</label></td>\n";

  }

  echo "        <td><input type='radio' name='scope' value='dRange' id='dRange'";

  if ($scope=='dRange') {echo " checked='checked'";}

  echo "></td>";

  echo "        <td valign=top><label for='dRange'>Date Range (MM/DD)</label></td>\n";

  echo "        <td><table><tr><td>From</td><td><INPUT type='text' size=5 maxlength=5 name='frDay' value='$frDay' onchange=\"document.getElementById('dRange').checked=true;\"></td><td>To</td><td><INPUT type='text' size=5 maxlength=5 name='toDay' value='$toDay' onchange=\"document.getElementById('dRange').checked=true;\"></td></tr></table></td>";

  ## Close Form

  echo "    <td align='right'>\n";

  echo "     <input type='submit' class='submitButton' value='Go' />\n";

  echo "    </td>\n";

  echo "   </tr>\n";

  echo "  </form>\n";

  echo " </table>\n";

  echo "</div>\n";

  

  if (($gp[0]==0)&&($gp[2]==0))

  {

	  echo "<div class='textbox' style='border:0;'>No games played yet</div>\n";

	  mysqli_close($db);

	

	  ################## END OF PAGE #########################

	  echo " </div>   <!-- END contentpane DIV -->\n";

	  page_foot($_SESSION['lgpath']);

	  exit;

  }



  ##### Get Playoff Odds Configuration

  $query="SHOW TABLES LIKE 'ootp_sql_admin';";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)) 

  {

	  # Get Settings

	  $query="SELECT setting,value FROM ootp_sql_admin WHERE scope IN ('ALL',$lgid) AND module IN ('admin','Last Sim') AND setting IN ('pythMeth','pythExp','nPOTeams')";

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $setting=$row['setting'];

			  $val=$row['value'];



			  switch ($setting)

			  {

			  case 'pythMeth'     : $pythMeth=$val;     break;

			  case 'pythExp'      : $pythExp=$val;      break;

			  case 'nPOTeams'     : $nPOTeams=$val;     break;

			  }

		  }

	  }

  }

  mysqli_close($db);



  $simLen=get_sim_length($_SESSION['adminpath'],$lgid);



  switch ($pythMeth)

  {

  case 'Pythagorean Win Pct (Pythagenpat)': $pythMeth='pythPat';break;

  case 'Actual Win Pct': $pythMeth='record'; break;

  default: $pythMeth='pythExp';break;

  }

  if ($pythMeth=="") {$pythMeth='pythExp';}

  if ($pythExp=="") {$pythExp=1.82;}



  include($_SESSION['adminpath']."/dbopen.php");



  ## Get Season Completion Percentage

  $query="SELECT played,COUNT(game_id) as g FROM games WHERE league_id=$lgid AND game_type=0 GROUP BY played;";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  if ($result)

  {

	  while ($row=mysqli_fetch_array($result))

	  {

		  switch ($row['played'])

		  {

		  case 0: $unPlayGm=$row['g']; break;

		  case 1: $playGm=$row['g']; break;

		  }

	  }

	  $seaCompPct=$playGm/($unPlayGm+$playGm);

  }



  ##### Get League Structure Names #####

  $query="SELECT sl.sub_league_id,sl.name as slname,sl.abbr,division_id,d.name as divname FROM sub_leagues as sl,divisions as d WHERE sl.league_id=d.league_id AND sl.sub_league_id=d.sub_league_id AND sl.league_id=$lgid;";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  while ($row=mysqli_fetch_array($result))

  {

	  $slid=$row['sub_league_id'];

    	  $divID=$row['division_id'];

	  $cmpID=$slid."::".$divID;

    	  $subleagues[$slid]['name']=$row['slname'];

    	  $subleagues[$slid]['abbr']=$row['abbr'];

	  $divisions[$cmpID]['name']=$row['divname'];

    	  $subleagues[$slid]['divCnt']=$subleagues[$slid]['divCnt']+1;

  }
  
  if ($nPOTeams==0)
  {
	  $nPOTeams=0;
	  foreach ($subleagues as $slid => $val)
	  {
		  $nPOTeams=max($nPOTeams,$subleagues[$slid]['divCnt']);
	  }
	  
  }



  ##### Get Team Records #####

  $query="SELECT t.name,t.nickname,t.sub_league_id,tr.division_id,game_id,dte,tid,sum(ra) as ra,sum(rf) as rf,sum(loss) as l,sum(win) as w,SUM(win)/(SUM(win)+SUM(loss)) as wpct";

  $query.=" FROM (";

  $query.="SELECT game_id,games.date as dte,away_team as tid,runs1 as ra,runs0 as rf,(runs1>runs0) as loss,(runs0>runs1) as win";

  $query.=" FROM games";

  $query.=" WHERE played=1 AND league_id=$lgid";

  if ($scope=='ST') {$query.=" AND game_type=2";}

  elseif ($scope=="LastSim") {$query.=" AND DATEDIFF('".$date->format("Y-m-d")."',games.date)<".$simLen;}

  elseif ($scope=="dRange") {$query.=" AND games.date>='$lgyear-$frDay' AND games.date<='$lgyear-$toDay'";}

  else {$query.=" AND game_type=0";}

  $query.=" UNION";

  $query.=" SELECT game_id,games.date as dte,home_team as tid,runs0 as ra,runs1 as rf,(runs0>runs1) as loss,(runs1>runs0) as win";

  $query.=" FROM games";

  $query.=" WHERE played=1 AND league_id=$lgid";

  if ($scope=='ST') {$query.=" AND game_type=2";}

  elseif ($scope=="LastSim") {$query.=" AND DATEDIFF('".$date->format("Y-m-d")."',games.date)<".$simLen;}

  elseif ($scope=="dRange") {$query.=" AND games.date>='$lgyear-$frDay' AND games.date<='$lgyear-$toDay'";}

  else {$query.=" AND game_type=0";}

  $query.=") as x,";

  $query.="teams as t,team_relations as tr";

  $query.=" WHERE x.tid=t.team_id AND x.tid=tr.team_id AND t.team_id=tr.team_id";

  $query.=" GROUP BY tid ORDER BY sub_league_id,division_id,wpct DESC, w DESC;";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  while ($row=mysqli_fetch_array($result))

  {

	  $tid=$row['tid'];

    	  $teams[$tid]['name']=$row['name']." ".$row['nickname'];

	  $teams[$tid]['slid']=$row['sub_league_id'];

    	  $teams[$tid]['divID']=$row['division_id'];

	  $teams[$tid]['rf']=$row['rf'];

    	  $teams[$tid]['ra']=$row['ra'];

	  $teams[$tid]['w']=$row['w'];

    	  $teams[$tid]['l']=$row['l'];

	  $teams[$tid]['g']=$row['w']+$row['l'];

    	  $teams[$tid]['winPct']=$row['wpct'];

    

	  switch ($pythMeth)

	  {

 	  case 'pythPat':

		  $pythExp=pow(($row['rf']+$row['ra'])/$teams[$tid]['g'],0.287);

      		  $pythPct=pow($row['rf'],$pythExp)/(pow($row['rf'],$pythExp)+pow($row['ra'],$pythExp));

		  break;

 	  case 'pythExp':

		  $pythPct=pow($row['rf'],$pythExp)/(pow($row['rf'],$pythExp)+pow($row['ra'],$pythExp));

      		  break;

	  case 'record':

 	  default:

		  $pythPct=$teams[$tid]['winPct'];

      		  break;

	  }

    	  $teams[$tid]['pythPct']=$pythPct;

	  $teams[$tid]['pythW']=round($teams[$tid]['g']*$teams[$tid]['pythPct'],0);

    	  $teams[$tid]['pythL']=$teams[$tid]['g']-$teams[$tid]['pythW'];

	  $teams[$tid]['pythDiff']=$row['w']-$teams[$tid]['pythW'];

  }



  $prevSL=-1;

  $prevDIV=-1;

  $prevTID=-1;

  foreach ($teams as $tid => $val)

  {

	  $slid=$teams[$tid]['slid'];

    	  $divID=$teams[$tid]['divID'];

	  if (($prevSL!=$slid) || ($prevDIV!=$divID))

   	  {

		  $teams[$tid]['gb']="-";

		  $maxW=$teams[$tid]['w'];

		  $maxL=$teams[$tid]['l'];

   	  }

	  else

   	  {

		  $tW=$teams[$tid]['w'];

		  $tL=$teams[$tid]['l'];

		  $gb=(($maxW-$tW) + ($tL-$maxL))/2;

		  $gb=sprintf("%.1f",$gb);

		  if ($gb==0)

		  {

			  $teams[$tid]['gb']="-";

			  $wcArray[$slid][$prevTID]=round($teams[$prevTID]['winPct'],0)+($teams[$prevTID]['w']/10000);

			  $wcDivWinners[$slid]=$wcDivWinners[$slid]+1;

		  }

		  elseif ($gb<1) {$teams[$tid]['gb']=strstr($gb,".");}

		  else {$teams[$tid]['gb']=$gb;}

	

		  $wcArray[$slid][$tid]=round($teams[$tid]['winPct'],4)+($teams[$tid]['w']/10000);

   	  }



	  $prevSL=$slid;

	  $prevDIV=$divID;

	  $prevTID=$tid;

  }



  ##### Display Results #####

  $rownum=0;

  $prevSL=-1;

  $prevDiv=-1;

  $slCnt=0;

  $divCnt=0;

  foreach ($teams as $tid => $val)

  {

    	  $cls='s'.($rownum%2+1);

	  $sl=$teams[$tid]['slid'];

    	  if ($sl!=$prevSL)

	  {

		  $divCnt=0;

	 	  if ($slCnt>0)

		  {

			  #Close last division

	      		  echo "   </table>\n";

			  echo "  </td>\n";

			  echo " </tr>\n";

			  #Dispaly last sub_league's wild card

			  if (($nPOTeams-$subleagues[$prevSL]['divCnt'])>0)

			  {

				  echo " <tr>\n";

				  echo "  <td style='padding-left:12px;padding-right:12px;'>\n";

				  echo "   <table cellspacing=0 cellpadding=1 class='lpo' width='100%' style='margin-bottom:12px;'>\n";

				  echo "    <tr class='title'>\n";

				  echo "     <td colspan=17>".$subleagues[$prevSL]['abbr']." Wild Card</td>\n";

				  echo "    </tr>\n";

				  echo "    <tr class='headline'><td class='hsc2_l' width='300px'>Team</td><td class='hsc2'>W</td><td class='hsc2'>L</td><td class='hsc2'>Pct</td><td class='hsc2'>WC GB</td><td class='hsc2'>RF</td><td class='hsc2'>RA</td><td class='hsc2'>PRec</td><td class='hsc2'>PPct</td><td class='hsc2'>Diff</td></tr>\n";

				  arsort($wcArray[$prevSL]);

				  $wcRowCnt=0;

				  foreach ($wcArray[$prevSL] as $wcTid => $pval)

				  {

					  $wcCls='s'.($wcRowCnt%2+1);

					  $wcRowCnt++;



					  #Determine WC GB

					  if (($subleagues[$prevSL]['divCnt']+$wcRowCnt-$wcDivWinners[$prevSL])<=$nPOTeams)

					  {

						  $subleagues[$prevSL]['wcWin']=$teams[$wcTid]['w'];

						  $subleagues[$prevSL]['wcLoss']=$teams[$wcTid]['l'];

						  $wcGB="-";

					  }

					  else

					  {

						  $wcGB=(($subleagues[$prevSL]['wcWin']-$teams[$wcTid]['w'])+($teams[$wcTid]['l']-$subleagues[$prevSL]['wcLoss']))/2;

					  }

	 				  if ($wcGB==0) {$wcGB="-";}	  

					  else {$wcGB=sprintf("%.1f",$wcGB);}

					  if ($wcGB==.5) {$wcGB=strstr($wcGB,".");}

					  $teams[$wcTid]['wcgb']=$wcGB;



					  #Display WC Row

					  echo "    <tr class='$wcCls'>";

					  echo "<td class='".$wcCls."_l'><a href='$lgpath/teams/team_$wcTid.html'>".$teams[$wcTid]['name']."</a></td>";

					  echo "<td>".$teams[$wcTid]['w']."</td>";

					  echo "<td>".$teams[$wcTid]['l']."</td>";

					  if ($teams[$wcTid]['winPct']>=1) {$winPctx=sprintf("%.3f",$teams[$wcTid]['winPct']);}

					  else {$winPctx=strstr(sprintf("%.3f",$teams[$wcTid]['winPct']),".");}

					  echo "<td>".$winPctx."</td>";

					  echo "<td>".$teams[$wcTid]['wcgb']."</td>";

					  echo "<td>".$teams[$wcTid]['rf']."</td>";

					  echo "<td>".$teams[$wcTid]['ra']."</td>";

					  echo "<td>".$teams[$wcTid]['pythW']."-".$teams[$wcTid]['pythL']."</td>";

					  if ($teams[$wcTid]['pythPct']>=1) {$pythPctx=sprintf("%.3f",$teams[$wcTid]['pythPct']);}

					  else {$pythPctx=strstr(sprintf("%.3f",$teams[$wcTid]['pythPct']),".");}

					  echo "<td>".$pythPctx."</td>";

					  echo "<td>".$teams[$wcTid]['pythDiff']."</td>";

					  echo "</tr>\n";

				  }

				  echo "   </table>\n";

				  echo "  </td>\n";

				  echo " </tr>\n";

			  }

			  #Close last sub-league

			  echo "</table>\n";

		  }

		  echo "<table class='textbox' cellspacing=0 cellpadding=1 class='lpo' width='100%' style='margin-top:12px;'>\n";

		  echo " <tr class='title'>\n";

		  if ($subleagues[$sl]['name']=="") {echo "  <td colspan=1>".$_SESSION['lgname']."</td>\n";}

		  else {echo "  <td colspan=1>".$subleagues[$sl]['name']."</td>\n";}

	 	  echo " </tr>\n";

		  $slCnt+=1;

   	  }

	  $div=$teams[$tid]['divID'];

    	  $cmpID=$sl."::".$div;

	  if (($div!=$prevDiv)||($sl!=$prevSL))

   	  {

		  if (($divCnt>0) && ($sl==$prevSL))

		  {

			  echo "   </table>\n";

	      		  echo "  </td>\n";

			  echo " </tr>\n";

		  }

		  echo " <tr>\n";

		  echo "  <td style='";

		  if ($divCnt==0) {echo "padding-top:12px;";}

		  echo "padding-left:12px;padding-right:12px;'>\n";

		  echo "   <table cellspacing=0 cellpadding=1 class='lpo' width='100%' style='margin-bottom:12px;'>\n";

		  echo "    <tr class='title'>\n";

		  if ($divisions[$cmpID]['name']=="") {echo "     <td colspan=17>".$subleagues[$sl]['abbr']."</td>\n";}

		  else {echo "     <td colspan=17>".$divisions[$cmpID]['name']."</td>\n";}

	 	  echo "    </tr>\n";

		  echo "    <tr class='headline'><td class='hsc2_l' width='300px'>Team</td><td class='hsc2'>W</td><td class='hsc2'>L</td><td class='hsc2'>Pct</td><td class='hsc2'>GB</td><td class='hsc2'>RF</td><td class='hsc2'>RA</td><td class='hsc2'>PRec</td><td class='hsc2'>PPct</td><td class='hsc2'>Diff</td></tr>\n";

	 	  $divCnt+=1;

	  }

    	  echo "    <tr class='$cls'>";

	  echo "<td class='".$cls."_l'><a href='$lgpath/teams/team_$tid.html'>".$teams[$tid]['name']."</a></td>";

    	  echo "<td>".$teams[$tid]['w']."</td>";

	  echo "<td>".$teams[$tid]['l']."</td>";

    	  if ($teams[$tid]['winPct']>=1) {$winPctx=sprintf("%.3f",$teams[$tid]['winPct']);}

	  else {$winPctx=strstr(sprintf("%.3f",$teams[$tid]['winPct']),".");}

    	  echo "<td>".$winPctx."</td>";

	  echo "<td>".$teams[$tid]['gb']."</td>";

    	  echo "<td>".$teams[$tid]['rf']."</td>";

	  echo "<td>".$teams[$tid]['ra']."</td>";

    	  echo "<td>".$teams[$tid]['pythW']."-".$teams[$tid]['pythL']."</td>";

	  if ($teams[$tid]['pythPct']>=1) {$pythPctx=sprintf("%.3f",$teams[$tid]['pythPct']);}

   	  else {$pythPctx=strstr(sprintf("%.3f",$teams[$tid]['pythPct']),".");}

	  echo "<td>".$pythPctx."</td>";

    	  echo "<td>".$teams[$tid]['pythDiff']."</td>";

	  echo "</tr>\n";

    	  $prevSL=$sl;

	  $prevDiv=$div;

    	  $rownum++;

  }

  #Close last division

  echo "   </table>\n";

  echo "  </td>\n";

  echo " </tr>\n";

  #Dispaly last sub_league's wild card

  if (($nPOTeams-$subleagues[$prevSL]['divCnt'])>0)

  {

	  echo " <tr>\n";

	  echo "  <td style='padding-left:12px;padding-right:12px;'>\n";

	  echo "   <table cellspacing=0 cellpadding=1 class='lpo' width='100%' style='margin-bottom:12px;'>\n";

	  echo "    <tr class='title'>\n";

	  echo "     <td colspan=17>".$subleagues[$prevSL]['abbr']." Wild Card</td>\n";

	  echo "    </tr>\n";

	  echo "    <tr class='headline'><td class='hsc2_l' width='300px'>Team</td><td class='hsc2'>W</td><td class='hsc2'>L</td><td class='hsc2'>Pct</td><td class='hsc2'>WC GB</td><td class='hsc2'>RF</td><td class='hsc2'>RA</td><td class='hsc2'>PRec</td><td class='hsc2'>PPct</td><td class='hsc2'>Diff</td></tr>\n";

	  arsort($wcArray[$prevSL]);

	  $wcRowCnt=0;

	  foreach ($wcArray[$prevSL] as $wcTid => $pval)

	  {

		  $wcCls='s'.($wcRowCnt%2+1);

		  $wcRowCnt++;



		  #Determine WC GB

		  if (($subleagues[$prevSL]['divCnt']+$wcRowCnt-$wcDivWinners[$prevSL])<=$nPOTeams)

		  {

			  $subleagues[$prevSL]['wcWin']=$teams[$wcTid]['w'];

			  $subleagues[$prevSL]['wcLoss']=$teams[$wcTid]['l'];

			  $wcGB="-";

		  }

		  else

		  {

			  $wcGB=(($subleagues[$prevSL]['wcWin']-$teams[$wcTid]['w'])+($teams[$wcTid]['l']-$subleagues[$prevSL]['wcLoss']))/2;

		  }

		  if ($wcGB==0) {$wcGB="-";}	  

		  else {$wcGB=sprintf("%.1f",$wcGB);}

		  if ($wcGB==.5) {$wcGB=strstr($wcGB,".");}

		  $teams[$wcTid]['wcgb']=$wcGB;



		  #Display WC Row

		  echo "    <tr class='$wcCls'>";

		  echo "<td class='".$wcCls."_l'><a href='$lgpath/teams/team_$wcTid.html'>".$teams[$wcTid]['name']."</a></td>";

		  echo "<td>".$teams[$wcTid]['w']."</td>";

		  echo "<td>".$teams[$wcTid]['l']."</td>";

		  if ($teams[$wcTid]['winPct']>=1) {$winPctx=sprintf("%.3f",$teams[$wcTid]['winPct']);}

		  else {$winPctx=strstr(sprintf("%.3f",$teams[$wcTid]['winPct']),".");}

		  echo "<td>".$winPctx."</td>";

		  echo "<td>".$teams[$wcTid]['wcgb']."</td>";

		  echo "<td>".$teams[$wcTid]['rf']."</td>";

		  echo "<td>".$teams[$wcTid]['ra']."</td>";

		  echo "<td>".$teams[$wcTid]['pythW']."-".$teams[$wcTid]['pythL']."</td>";

		  if ($teams[$wcTid]['pythPct']>=1) {$pythPctx=sprintf("%.3f",$teams[$wcTid]['pythPct']);}

		  else {$pythPctx=strstr(sprintf("%.3f",$teams[$wcTid]['pythPct']),".");}

		  echo "<td>".$pythPctx."</td>";

		  echo "<td>".$teams[$wcTid]['pythDiff']."</td>";

		  echo "</tr>\n";

	  }

	  echo "   </table>\n";

	  echo "  </td>\n";

	  echo " </tr>\n";

  }

  #CLose last sub-league

  echo "</table>\n";



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);





?>

