<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgpath=$_SESSION['lgpath'];

  $date=new Date($_SESSION['lgdate']);

  $lgyear=$date->format("Y");

  

  $view=$_GET['view'];

  $stat=$_GET['stat'];

  $startYr=$_GET['from'];

  $endYr=$_GET['to'];

  if ($startYr>$endYr)

  {

	  $tmpYr=$endYr;

	  $endYr=$startYr;

	  $startYr=$tmpYr;

  }

  $sub_league_id=$_GET['sub_league_id'];

  if ($sub_league_id=="") {$sub_league_id="ALL";}

  $team_id=$_GET['team_id'];

  if ($team_id=="") {$team_id="ALL";}

  $pos=$_GET['pos'];

  switch ($stat)

  {

  case 'fgs':

  case 'po':

  case 'a':

  case 'dp':

  case 'tp':

  case 'tc':

  case 'e':

  case 'fip':

  case 'pct':

  case 'rng':

  case 'pb':

  case 'sba':

  case 'rto':

  case 'rtoPct':

	  break;

  default:

	  $disablePosFilt=1;

	  $pos="ALL";

	  break;

  }



  $statArray=array('batters'=>'Batters','ab'=>'AB','h'=>'H','d'=>'2B','t'=>'3B','hr'=>'HR','rbi'=>'RBI','r'=>'R','sb'=>'SB','cs'=>'CS','bb'=>'BB','k'=>'K','sf'=>'SF','sh'=>'SH','ibb'=>'IBB','hp'=>'HBP','gdp'=>'GIDP','pa'=>'PA','outs'=>'Outs','ebh'=>'EBH','tb'=>'TB','tob'=>'TOB','tto'=>'TTO','pitches_seen'=>'Pitches Seen','pipa'=>'PS/PA','abhr'=>'AB/HR','pahr'=>'PA/HR','bbk'=>'BB/K','avg'=>'AVG','obp'=>'OBP','slg'=>'SLG','ops'=>'OPS','iso'=>'ISO','bbabip'=>'BABIP','wOBA'=>'wOBA','war'=>'WAR','pwrspd'=>'PwrSpd','rc'=>'RC','rc27'=>'RC/27','pitchers'=>'Pitchers','w'=>'W','l'=>'L','s'=>'SV','ip'=>'IP','g'=>'G','gs'=>'GS','gf'=>'GF','cg'=>'CG','sho'=>'SHO','qs'=>'QS','pk'=>'K','pbb'=>'BB','ha'=>'HA','hra'=>'HR','pr'=>'R','er'=>'ER','hld'=>'HLD','svo'=>'SVO','bs'=>'BS','da'=>'2BA','ta'=>'3BA','bk'=>'BK','wp'=>'WP','hp'=>'HP','bf'=>'BF','gb'=>'GB','fb'=>'FB','ptto'=>'TTO','pi'=>'Pitches Thrown','era'=>'ERA','whip'=>'WHIP','pwar'=>'WAR','kper9'=>'K/9IP','bbper9'=>'BB/9IP','hper9'=>'H/9IP','rper9'=>'R/9IP','hrper9'=>'HR/9IP','kperbb'=>'K/BB','gbPct'=>'GB%','babip'=>'BABIP','wpct'=>'Win %','gmovr500'=>'Gms Over .500','fielders'=>'Fielding','fgs'=>'GS','po'=>'PO','a'=>'A','dp'=>'DP','tp'=>'TP','tc'=>'TC','e'=>'E','fip'=>'Inn','pct'=>'Pct','rng'=>'Range','pb'=>'PB','sba'=>'RSTA','rto'=>'RTO','rtoPct'=>'RTO%');



  ##### Get Max/Min Years #####

  include($_SESSION['adminpath']."/dbopen.php");

  if (($minYr==0)||($maxYr==0))

  {

	  $query="SELECT MAX(year) as maxYr,MIN(year) as minYr FROM ";

	  if ($view=='teams') {$query.="team_history_batting_stats";}

	  else {$query.="players_career_batting_stats";}

	  $query.=" WHERE league_id=$lgid;";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $row=mysqli_fetch_array($result);			

	  $minYr=$row['minYr'];

	  $maxYr=$row['maxYr'];

  }

  if ($startYr=="") {$startYr=$minYr;}

  if ($endYr=="") {$endYr=$maxYr;}

  mysqli_close($db);



  # Title Bar

  $title='Progressive Leaderboards';



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  nav_toolbar("history","History");

  echo " </div>   <!-- END topbar DIV -->\n";



  if ($view=='players')

  {

	  echo "<script type='text/javascript'>\n";

	  echo " function updPosFilt(toElem,statLbl) {\n";

	  echo "   switch (statLbl)\n";

	  echo "   {\n";

	  echo "     case 'fgs':\n";

	  echo "     case 'po':\n";

	  echo "     case 'a':\n";

	  echo "     case 'dp':\n";

	  echo "     case 'tp':\n";

	  echo "     case 'tc':\n";

	  echo "     case 'e':\n";

	  echo "     case 'fip':\n";

	  echo "     case 'pct':\n";

	  echo "     case 'rng':\n";

	  echo "     case 'pb':\n";

	  echo "     case 'sba':\n";

	  echo "     case 'rto':\n";

	  echo "     case 'rtoPct':\n";

	  echo "        toElem.disabled=\"\";\n";

	  echo "        break;\n";

	  echo "     default: toElem.disabled=\"disabled\"; break;\n";

	  echo "   }\n";

	  echo " }\n";

	  echo "</script>\n";

  }



  echo " <div id='contentpane'>\n";



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");



  ##### Display Filters #####

  echo " <div class='textbox'>\n";

  echo "  <form method='get' action='progLeaders.php' style='clear:left;'>\n";

  echo "  <table cellspacing=0 cellpadding=2 border=0>\n";

  echo "   <tr class='title'><td colspan=12>Filters</td></tr>\n";

  echo "   <tr>\n";



  ## Show Type Selection

  echo "     <td style='border-bottom:1px solid gray;'><label><b>View:</b></label></td>";

  echo "     <td style='border-bottom:1px solid gray;'><input type='radio' name='view' value='players' id='players'";

  if ($view=='players') {echo " checked='checked'";}

  echo " onclick=\"window.location='./progLeaders.php?view=players'\"></td>";

  echo "     <td style='border-bottom:1px solid gray;'><label for='players'>Players</label></td>";

  echo "     <td style='border-bottom:1px solid gray;'><input type='radio' name='view' value='teams' id='teams'";

  if ($view=='teams') {echo " checked='checked'";}

  echo " onclick=\"window.location='./progLeaders.php?view=teams'\"></td>";

  echo "     <td style='border-bottom:1px solid gray;'><label for='teams'>Teams</label></td>";

  echo "     <td style='border-bottom:1px solid gray;'><input type='radio' id='standard' onclick=\"window.location='./leaderboards.php";

  if ($view!="") {echo "?view=$view";}

  echo "'\"></td>";

  echo "     <td style='border-bottom:1px solid gray;'><label for='standard'>Standard</label></td>";



  if ($view!="")

  {

	  echo "    <td style='border-bottom:1px solid gray;' colspan=2>&nbsp;</td>\n";

	  echo "   </tr>\n";

	  echo "   <tr>\n";



	  ## Get Subleagues

	  $query="SELECT sub_league_id,name FROM sub_leagues WHERE league_id=$lgid ORDER BY sub_league_id;";

	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))

	  {

		  $slid=$row['sub_league_id'];

		  $subleagues[$slid]['name']=$row['name'];

	  }



	  ## Show Subleague Filter

	  echo "    <td colspan=2 style='text-align:right;'><b>League:</b></td>\n";

	  echo "    <td";

	  if ($view=='teams') {echo " colspan=4";}

	  echo ">\n";

	  echo "     <select name='sub_league_id' id='sub_league_id' onchange=\"if(this[this.selectedIndex].value!='All') {document.getElementById('team_id').selectedIndex=0;}\">\n";

	  echo "      <option value='ALL'>All</option>\n";

	  foreach ($subleagues as $slid => $val)

	  {

		  echo "      <option value='$slid'";

		  if (($sub_league_id==$slid) && ($sub_league_id!="ALL")) {echo " selected";}

		  echo ">".$subleagues[$slid]['name']."</option>\n";

	  }

	  echo "     </select>\n";

	  echo "    </td>\n";



	  if ($view=='players')

	  {

		  ## Get Current Teams

		  $query="SELECT team_id,name,nickname,level,sub_league_id FROM teams WHERE league_id=$lgid AND allstar_team=0 ORDER BY name,nickname;";

		  $result=mysqli_query($db,$query);

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  $slid=$row['sub_league_id'];

			  $teams[$tid]['name']=$row['name']." ".$row['nickname'];

			  $teams[$tid]['level']=$row['level'];

			  $teams[$tid]['city']=$row['name'];

			  $teams[$tid]['slid']=$slid;

			  $subleagues[$slid]['teams']=$subleagues[$slid]['teams'].",$tid";

			  $LGtmList.=",$tid";

		  }

		  $LGtmList=trim($LGtmList,",");

		  foreach ($subleagues as $slid => $val) {$subleagues[$slid]['teams']=trim($subleagues[$slid]['teams'],",");}

  

		  ## Show Team Filter

		  echo "    <td colspan=2 style='text-align:right;'><b>Team:</b></td>\n";

		  echo "    <td>\n";

		  echo "     <select name='team_id' id='team_id' onchange=\"if(this[this.selectedIndex].value!='All') {document.getElementById('sub_league_id').selectedIndex=0;}\">\n";

		  echo "      <option value='ALL'>All</option>\n";

		  foreach ($teams as $tid => $val)

		  {

			  echo "      <option value='$tid'";

			  if ($team_id==$tid) {echo " selected";}

			  echo ">".$teams[$tid]['name']."</option>\n";

		  }

		  echo "     </select>\n";

		  echo "    </td>\n";

	  }



	  echo "   </tr>\n";

	  echo "   <tr>\n";



	  ## Year Filter

	  echo "    <td colspan=2 style='text-align:right;'><b>Year From:</b></td>\n";

	  echo "    <td>\n";

	  echo "     <select name='from' id='from'>\n";

	  for ($i=$minYr;$i<=$maxYr;$i++)

	  {

		  echo "      <option value='$i'";

		  if ($startYr==$i) {echo " selected";}

		  echo ">$i</option>\n";

	  }

	  echo "     </select>\n";

	  echo "    </td>\n";

	  echo "    <td colspan=2 style='text-align:right;'><b>To:</b></td>\n";

	  echo "    <td>\n";

	  echo "     <select name='to' id='to'>\n";

	  for ($i=$minYr;$i<=$maxYr;$i++)

	  {

		  echo "      <option value='$i'";

		  if ($endYr==$i) {echo " selected";}

		  echo ">$i</option>\n";

	  }

	  echo "     </select>\n";

	  echo "    </td>\n";

		

	  echo "   </tr>\n";

	  echo "   <tr>\n";



	  ## Stat Filter

	  echo "    <td colspan=2 style='text-align:right;'><b>Stat:</b></td>\n";

	  echo "    <td>\n";

	  echo "     <select name='stat' id='stat'";

	  if ($view=='players') {echo " onchange=\"updPosFilt(document.getElementById('pos'),this[selectedIndex].value);\"";}

	  echo ">\n";

	  foreach ($statArray as $key => $val)

	  {

		  if (($key=='batters')||($key=='pitchers')||($key=='fielders')||($key=='career')) {echo "      <optgroup label='$val'>\n";}

		  else

		  {

			  echo "      <option value='$key'";

			  if ($stat==$key) {echo " selected";}

			  echo ">$val</option>\n";

		  }

	  }

	  echo "     </select>\n";

	  echo "    </td>\n";



	  if ($view=='players')

	  {

		  ## Show Position Filter

		  echo "    <td>&nbsp;</td>\n";

		  echo "    <td style='text-align:right;'><b>Pos:</b></td>\n";

		  echo "    <td>\n";

		  echo "     <select name='pos' id='pos'";

		  if ($disablePosFilt==1) {echo " disabled='disabled'";}

		  echo ">\n";

		  $posArray=Array("ALL"=>"All","1"=>"P","2"=>"C","3"=>"1B","4"=>"2B","5"=>"3B","6"=>"SS","7"=>"LF","8"=>"CF","9"=>"RF","IF"=>"IF","CI"=>"CI","MI"=>"MI","OF"=>"OF");

		  foreach ($posArray as $key => $val)

		  {

			  echo "      <option value='$key'";

			  if ($pos==$key) {echo " selected";}

			  echo ">$val</option>\n";

		  }

		  echo "     </select>\n";

		  echo "    </td>\n";



		  echo "   </tr>\n";

		  echo "   <tr>\n";

		  echo "    <td colspan=5>&nbsp;</td>\n";



		  ## Submission button

		  echo "    <td><input type='submit' value='Go'></input></td>\n";

	  }

	  else

	  {

		  echo "    <td colspan=2>&nbsp;</td>\n";



		  ## Submission button

		  echo "    <td><input type='submit' value='Go'></input></td>\n";

	  }

  }		



  ##### Close Form #####

  echo "   </tr>\n";

  echo "  </table>\n";

  echo "  </form>\n";

  echo " </div>\n";



  if ($stat=="")		## Close out page

  {

	  mysqli_close($db);

	

	  ################## END OF PAGE #########################

	  echo " </div>   <!-- END contentpane DIV -->\n";

	  page_foot($_SESSION['lgpath']);

	  exit;

  }



  if (($minYr=="")||($maxYr==""))		## Close out page

  {

	  mysqli_close($db);



	  echo " <div class='textbox' style='border:0px;'>No history yet</div>\n";

	

	  ################## END OF PAGE #########################

	  echo " </div>   <!-- END contentpane DIV -->\n";

	  page_foot($_SESSION['lgpath']);

	  exit;

  }



  ## Get Stat Calculation

  $statCalc=stat_query($stat);



  ## Determine Sort Order

  switch ($stat)

  {

  case 'abhr':

  case 'pahr':

  case 'era':

  case 'whip':

  case 'bbper9':	   

  case 'hper9':	   

  case 'rper9':	   

  case 'hrper9':	   

  case 'babip':

	  $orderClause="ASC";

	  break;

  default:

	  $orderClause="DESC";

	  break;			

  }

  

  ##### Display results #####

  if ($view=='players')

  {

      	  ## Get Team List

	  $tQuery="";

  	  if ($sub_league_id!="ALL") {$tQuery=" AND team_id IN (".$subleagues[$sub_league_id]['teams'].")";}

	  if ($team_id!="ALL") {$tQuery=" AND team_id=$team_id";}

	    

	  ## Start Table

	  echo "<div class='textbox'>\n";

  	  echo " <table cellpadding=0 cellspacing=0 border=0>\n";

	  echo "  <tr class='title2'><td>";

	  if ($sub_league_id!="ALL") {echo $subleagues[$sub_league_id]['name']." ";}

	  if ($team_id!="ALL") {echo $teams[$team_id]['name']." ";}

	  if ($pos!="ALL") {echo $posArray[$pos]." ";}

  	  echo "Progressive ";

	  if ($stat!="") {echo $statArray[$stat]." ";}

  	  echo "Leaders From $startYr to $endYr";

	  echo "<br/>(*=Active Player, +=Hall of Famer)";

  	  echo "</td></tr>\n";

	  echo "  <tr><td>\n";

  	  echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='935px'>\n";

	  echo "    <thead><tr class='headline'><td class='hsc2_l'>Year</td>";

  	  echo "<td class='hsc2_l' style='border-left:1px solid black;'>Career</td>";

	  echo "<td class='hsc2'>".stat_text($stat,2)."</td>";

  	  echo "<td class='hsc2_l' style='border-left:1px solid black;'>Seasonal</td>";

	  echo "<td class='hsc2'>".stat_text($stat,2)."</td>";

  	  echo "<td class='hsc2_l' style='border-left:1px solid black;'>Active</td>";

	  echo "<td class='hsc2'>".stat_text($stat,2)."</td>";

  	  echo "<td class='hsc2_l' style='border-left:1px solid black;'>Yearly</td>";

	  echo "<td class='hsc2'>".stat_text($stat,2)."</td>";

  	  echo "</tr></thead>\n";

	  

	  ## Get SQL Table

	  $posFilter="";

  	  $split="AND split_id=1";

	  switch ($stat)

	  {

	  case 'ab':

	  case 'h':

	  case 'd':

	  case 't':

	  case 'hr':

	  case 'rbi':

	  case 'r':

	  case 'sb':

	  case 'cs':

	  case 'bb':

	  case 'k':

	  case 'sf':

	  case 'sh':

	  case 'ibb':

	  case 'hp':

	  case 'gdp':

	  case 'pa':

	  case 'outs':

	  case 'ebh':

	  case 'tb':

	  case 'tob':

	  case 'tto':

	  case 'pitches_seen':

	  case 'pipa':

	  case 'abhr':

	  case 'pahr':

	  case 'bbk':

	  case 'avg':

	  case 'obp':

	  case 'slg':

	  case 'ops':

	  case 'iso':

	  case 'bbabip':

	  case 'wOBA':

	  case 'war':

	  case 'pwrspd':

	  case 'rc':

	  case 'rc27':

		  $table='players_career_batting_stats';

		  $statType='bStat';

		  break;

	  case 'fgs':

	  case 'po':

	  case 'a':

	  case 'dp':

	  case 'tp':

	  case 'tc':

	  case 'e':

	  case 'fip':

	  case 'pct':

	  case 'rng':

	  case 'pb':

	  case 'sba':

	  case 'rto':

	  case 'rtoPct':

		  $table='players_career_fielding_stats';

		  $statType='fStat';

		  if ($pos!="ALL") 

		  {

			  switch ($pos)

			  {

			  case 'IF':

				  $posFilter=" AND position IN (3,4,5,6)";

				  break;

			  case 'CI':

				  $posFilter=" AND position IN (3,5)";

				  break;

			  case 'MI':

				  $posFilter=" AND position IN (4,6)";

				  break;

			  case 'OF':

				  $posFilter=" AND position IN (7,8,9)";

				  break;

			  default:

				  $posFilter=" AND position=$pos";

				  break;

			  }

		  }

		  $split="AND split_id IN (0,1)";

		  break;

	  default:

		  $table='players_career_pitching_stats';

		  $statType='pStat';

		  break;

	  }

  

	  ## Get Seasonal Games Played for Rate Stats

	  switch ($stat)

  	  {

	  case 'pipa':

	  case 'abhr':

	  case 'pahr':

	  case 'bbk':

	  case 'avg':

	  case 'obp':

	  case 'slg':

	  case 'ops':

	  case 'iso':

	  case 'bbabip':

	  case 'wOBA':

	  case 'pwrspd':

	  case 'rc':

	  case 'rc27':

	  case 'era':

	  case 'whip':

	  case 'kper9':

	  case 'bbper9':

	  case 'hper9':

	  case 'rper9':

	  case 'hrper9':

	  case 'kperbb':

	  case 'gbPct':

	  case 'babip':

	  case 'wpct':

	  case 'gmovr500':

	  case 'pct':

	  case 'rng':

	  case 'rtoPct':

		  $query="SELECT year,ROUND(AVG(g)) as g FROM team_history_record WHERE league_id=$lgid GROUP BY year ORDER BY year";

		  $result=mysqli_query($db,$query);

		  while ($row=mysqli_fetch_array($result))

		  {

			  $yr=$row['year'];

			  $g=$row['g'];

			  $years[$yr]['g']=$g;

		  }

		  $years[$lgyear]['g']=$g;

		  $ptCond=1;

		  break;

	  }

    

	  ## Configure Years

	  if ($minYr<$startYr) {$minYr=$startYr;}

	  if ($endYr<$maxYr) {$maxYr=$endYr;}

	  

	  ## Generate Table	

	  $cnt=0;

  	  $cumG=0;

	  $minCarPT=0;

  	  $minSeaPT=0;

	  $ptCarCond="";

  	  $ptSeaCond="";

	  $rowTitle="";

  	  for ($i=$minYr;$i<=$maxYr;$i++)

	  {

  		  ## Determine Min PT

		  if ($ptCond==1)

  		  {

			  if ($years[$i]['g']==0) {$years[$i]['g']=30;}

	  		  $cumG+=$years[$i]['g'];

			  switch ($statType)

  			  {

			  case 'bStat':

				  $minSeaPT=floor(3.1*$years[$i]['g']);

				  $minCarPT=floor(3.1*$cumG);

				  if (($i-$minYr+1)>=4)

				  {

					  if ($minCarPT>3000) {$minCarPT=3000;}

					  else

					  {

						  $minCarPT=floor($minCarPT/500)*500;

						  $minCarPT=max($minCarPT,200);

					  }

				  }

				  $ptLbl='PA';

				  $ptCarCond=" HAVING SUM(pa)>=$minCarPT";

				  $ptSeaCond=" HAVING SUM(pa)>=$minSeaPT";

				  break;

			  case 'pStat':

				  $minSeaPT=1.0*$years[$i]['g'];

				  $minCarPT=1.0*$cumG;

				  if (($i-$minYr+1)>=7)

				  {

					  if ($minCarPT>1000) {$minCarPT=1000;}

					  else

					  {

						  $minCarPT=floor($minCarPT/250)*250;

						  $minCarPT=max($minCarPT,100);

					  }

				  }

				  $ptLbl='IP';

				  $ptCarCond=" HAVING (SUM(ip)+SUM(ipf)/3)>=$minCarPT";

				  $ptSeaCond=" HAVING (SUM(ip)+SUM(ipf)/3)>=$minSeaPT";

				  break;

			  case 'fStat':

				  $minSeaPT=floor(3.1*$years[$i]['g']);

				  $minCarPT=floor(3.1*$cumG);

				  if (($i-$minYr+1)>=4)

				  {

					  if ($minCarPT>3000) {$minCarPT=3000;}

					  else

					  {

						  $minCarPT=floor($minCarPT/500)*500;

						  $minCarPT=max($minCarPT,200);

					  }

				  }

				  $ptLbl='Inn';

				  $ptCarCond=" HAVING (SUM(ip)+SUM(ipf)/3)>=$minCarPT";

				  $ptSeaCond=" HAVING (SUM(ip)+SUM(ipf)/3)>=$minSeaPT";

				  break;

			  }

  			  $rowTitle=" title='Min $ptLbl Career: $minCarPT\nMin $ptLbl Season: $minSeaPT'";

		  }



  		  ## Start Row

		  $cls='s'.($cnt%2+1);

  		  echo "    <tr class='$cls'>";

		  echo "<td class='".$cls."_l' valign='top'$rowTitle>$i</td>";

    

		  ##Career

		  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,x1.stat FROM players as p,(SELECT player_id,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid $split AND year<=$i AND year>=$minYr$tQuery$posFilter GROUP BY player_id$ptCarCond ORDER BY stat $orderClause LIMIT 1) as x1,(SELECT player_id,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid $split AND year<=$i AND year>=$minYr$tQuery$posFilter GROUP BY player_id$ptCarCond ORDER BY stat $orderClause LIMIT 6) as x2 WHERE p.player_id=x2.player_id AND x1.stat=x2.stat;";

  		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

  		  $rCnt=mysqli_num_rows($result);

		  $pCnt=0;

  		  echo "<td class='".$cls."_l' style='border-left:1px solid black;' valign='top'>";

		  while ($row=mysqli_fetch_array($result))

  		  {

			  $pCnt++;

  			  if (($rCnt>5)&&($pCnt>4))

			  {

  				  echo "And others...";

				  break;

  			  }

			  $pid=$row['player_id'];

  			  $name=$row['first_name']." ".$row['last_name'];

			  $hof=$row['hall_of_fame'];

  			  $statVal=$row['stat'];

			  $active=$row['retired'];

  			  echo "<a href='./player.php?player_id=$pid'>$name</a>";

			  if ($hof==1) {echo "+";}

  			  if ($active==0) {echo "*";}

			  if ($pCnt<$rCnt) {echo "<br/>";}

		  }

  		  echo "</td>";

		  if ($rCnt==0) {$statVal="-";} else {$statVal=stat_format($stat,$statVal);}

	  	  echo "<td valign='top'>$statVal</td>";

  

		  ##Seasonal

		  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,x2.year,x1.stat FROM players as p,(SELECT player_id,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid $split AND year<=$i AND year>=$minYr$tQuery$posFilter GROUP BY player_id,year$ptSeaCond ORDER BY stat $orderClause LIMIT 1) as x1,(SELECT player_id,year,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid $split AND year<=$i AND year>=$minYr$tQuery$posFilter GROUP BY player_id,year$ptSeaCond ORDER BY stat $orderClause LIMIT 6) as x2 WHERE p.player_id=x2.player_id AND x1.stat=x2.stat ORDER BY year";

  		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

  		  $rCnt=mysqli_num_rows($result);

		  $pCnt=0;

  		  echo "<td class='".$cls."_l' style='border-left:1px solid black;' valign='top'>";

		  $pText="";

  		  while ($row=mysqli_fetch_array($result))

		  {

  			  $pCnt++;

			  if (($rCnt>5)&&($pCnt>4))

  			  {

				  echo "And others...";

  				  break;

			  }

  			  $pid=$row['player_id'];

			  $name=$row['first_name']." ".$row['last_name'];

  			  $hof=$row['hall_of_fame'];

			  $statVal=$row['stat'];

  			  $active=$row['retired'];

			  $pText.="<a href='./player.php?player_id=$pid'>$name</a>";

  			  if ($hof==1) {$pText.="+";}

			  if ($active==0) {$pText.="*";}

	  		  if ($pCnt<$rCnt) {$pText.="<br/>";}

		  }

  		  if ($pText=="") 

		  {

  			  $pText=$prevPText;

			  $statVal=$prevSeaStat;

  		  }

		  else

  		  {

			  $prevPText=$pText;

  			  $prevSeaStat=$statVal;

		  }

  		  echo $pText;

		  echo "</td>";

		  if (($rCnt==0)&&($pText=="")) {$statVal="-";} else {$statVal=stat_format($stat,$statVal);}

	  	  echo "<td valign='top'>$statVal</td>";

  

		  ##Active

		  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,x1.stat FROM players as p,(SELECT player_id,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid $split AND year<=$i AND year>=$minYr$tQuery$posFilter GROUP BY player_id HAVING MAX(year)=$i".str_replace(" HAVING "," AND ",$ptCarCond)." ORDER BY stat $orderClause LIMIT 1) as x1,(SELECT player_id,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid $split AND year<=$i AND year>=$minYr$tQuery$posFilter GROUP BY player_id HAVING MAX(year)=$i".str_replace(" HAVING "," AND ",$ptCarCond)." ORDER BY stat $orderClause LIMIT 6) as x2 WHERE p.player_id=x2.player_id AND x1.stat=x2.stat";

  		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

  		  $rCnt=mysqli_num_rows($result);

		  $pCnt=0;

  		  echo "<td class='".$cls."_l' style='border-left:1px solid black;' valign='top'>";

		  while ($row=mysqli_fetch_array($result))

  		  {

			  $pCnt++;

  			  if (($rCnt>5)&&($pCnt>4))

			  {

  				  echo "And others...";

				  break;

  			  }

			  $pid=$row['player_id'];

  			  $name=$row['first_name']." ".$row['last_name'];

			  $hof=$row['hall_of_fame'];

  			  $statVal=$row['stat'];

			  $active=$row['retired'];

  			  echo "<a href='./player.php?player_id=$pid'>$name</a>";

			  if ($hof==1) {echo "+";}

  			  if ($active==0) {echo "*";}

				  if ($pCnt<$rCnt) {echo "<br/>";}



		  }

  		  echo "</td>";

		  if ($rCnt==0) {$statVal="-";} else {$statVal=stat_format($stat,$statVal);}

  		  echo "<td valign='top'>$statVal</td>";

	  

		  ##Yearly

		  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,x1.stat FROM players as p,(SELECT player_id,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid $split AND year=$i$tQuery$posFilter GROUP BY player_id,year$ptSeaCond ORDER BY stat $orderClause LIMIT 1) as x1,(SELECT player_id,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid $split AND year=$i$tQuery$posFilter GROUP BY player_id,year$ptSeaCond ORDER BY stat $orderClause LIMIT 6) as x2 WHERE p.player_id=x2.player_id AND x1.stat=x2.stat";

  		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

  		  $rCnt=mysqli_num_rows($result);

		  $pCnt=0;

  		  echo "<td class='".$cls."_l' style='border-left:1px solid black;' valign='top'>";

		  while ($row=mysqli_fetch_array($result))

  		  {

			  $pCnt++;

  			  if (($rCnt>5)&&($pCnt>4))

			  {

  				  echo "And others...";

				  break;

  			  }

			  $pid=$row['player_id'];

  			  $name=$row['first_name']." ".$row['last_name'];

			  $hof=$row['hall_of_fame'];

  			  $statVal=$row['stat'];

			  $active=$row['retired'];

  			  echo "<a href='./player.php?player_id=$pid'>$name</a>";

			  if ($hof==1) {echo "+";}

  			  if ($active==0) {echo "*";}

			  if ($pCnt<$rCnt) {echo "<br/>";}

		  }

		  echo "</td>";

		  if ($rCnt==0) {$statVal="-";} else {$statVal=stat_format($stat,$statVal);}

	  	  echo "<td valign='top'>$statVal</td>";

  

		  #End row

		  echo "</tr>\n";

  		  $cnt++;

	  }

	  

	  ## Close Table

	  echo "   </table>\n";



	  echo "  <td></tr>\n";

  	  echo " </table>\n";

	  echo "</div>\n";

  }   ## End Players View

  

  ##### Display results #####

  if ($view=='teams')

  {

  	  ## Get Team List

	  $slQuery="";

  	  if ($sub_league_id!="ALL") {$slQuery=" AND sub_league_id=$sub_league_id";}

	  

	  ## Start Table

	  echo "<div class='textbox'>\n";

  	  echo " <table cellpadding=0 cellspacing=0 border=0>\n";

	  echo "  <tr class='title2'><td>";

  	  if ($sub_league_id!="ALL") {echo $subleagues[$sub_league_id]['name']." ";}

	  echo "Team Progressive ";

  	  if ($stat!="") {echo stat_text($stat,2)." ";}

	  echo "Leaders From $startYr to $endYr";

  	  echo "</td></tr>\n";

	  echo "  <tr><td>\n";

  	  echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' width='935px'>\n";

	  echo "    <thead><tr class='headline'><td class='hsc2_l'>Year</td>";

  	  echo "<td class='hsc2_l' style='border-left:1px solid black;'>Career</td>";

	  echo "<td class='hsc2'>".stat_text($stat,2)."</td>";

  	  echo "<td class='hsc2_l' style='border-left:1px solid black;'>Seasonal</td>";

	  echo "<td class='hsc2'>".stat_text($stat,2)."</td>";

  	  echo "<td class='hsc2_l' style='border-left:1px solid black;'>Active</td>";

	  echo "<td class='hsc2'>".stat_text($stat,2)."</td>";

  	  echo "<td class='hsc2_l' style='border-left:1px solid black;'>Yearly</td>";

	  echo "<td class='hsc2'>".stat_text($stat,2)."</td>";

  	  echo "</tr></thead>\n";

  

	  ## Get SQL Table

	  switch ($stat)

  	  {

	  case 'ab':

	  case 'h':

	  case 'd':

	  case 't':

	  case 'hr':

	  case 'rbi':

	  case 'r':

	  case 'sb':

	  case 'cs':

	  case 'bb':

	  case 'k':

	  case 'sf':

	  case 'sh':

	  case 'ibb':

	  case 'hp':

	  case 'gdp':

	  case 'pa':

	  case 'outs':

	  case 'ebh':

	  case 'tb':

	  case 'tob':

	  case 'tto':

	  case 'pitches_seen':

	  case 'pipa':

	  case 'abhr':

	  case 'pahr':

	  case 'bbk':

	  case 'avg':

	  case 'obp':

	  case 'slg':

	  case 'ops':

	  case 'iso':

	  case 'bbabip':

	  case 'wOBA':

	  case 'war':

	  case 'pwrspd':

	  case 'rc':

	  case 'rc27':

		  $table='team_history_batting_stats';

		  break;

	  case 'fgs':

	  case 'po':

	  case 'a':

	  case 'dp':

	  case 'tp':

	  case 'tc':

	  case 'e':

	  case 'fip':

	  case 'pct':

	  case 'rng':

	  case 'pb':

	  case 'sba':

	  case 'rto':

	  case 'rtoPct':

		  $table='team_history_fielding_stats_stats';

		  break;

	  default:

		  $table='team_history_pitching_stats';

		  break;

  	  }

  

	  ## Configure Years

	  if ($minYr<$startYr) {$minYr=$startYr;}

	  if ($endYr<$maxYr) {$maxYr=$endYr;}

	  

	  ## Generate Table	

	  $cnt=0;

  	  for ($i=$minYr;$i<=$maxYr;$i++)

	  {

  		  ## Start Row

		  $cls='s'.($cnt%2+1);

  		  echo "    <tr class='$cls'>";

		  echo "<td class='".$cls."_l' valign='top'>$i</td>";

    

		  ##Career

		  $query="SELECT t.team_id,name,nickname,x1.stat FROM team_history as t,(SELECT team_id,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid AND year<=$i AND year>=$minYr$slQuery GROUP BY team_id ORDER BY stat $orderClause LIMIT 1) as x1,(SELECT team_id,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid AND year<=$i AND year>=$minYr$slQuery GROUP BY team_id ORDER BY stat $orderClause LIMIT 6) as x2 WHERE t.team_id=x2.team_id AND t.year=$i AND x1.stat=x2.stat;";

  		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

  		  $rCnt=mysqli_num_rows($result);

		  $pCnt=0;

  		  echo "<td class='".$cls."_l' style='border-left:1px solid black;' valign='top'>";

		  while ($row=mysqli_fetch_array($result))

  		  {

			  $pCnt++;

  			  if (($rCnt>5)&&($pCnt>4))

			  {

  				  echo "And others...";

				  break;

  			  }

			  $tid=$row['team_id'];

  			  $name=$row['name']." ".$row['nickname'];

			  $statVal=$row['stat'];

  			  echo "<a href='./team_hist.php?team_id=$tid'>$name</a>";

			  if ($pCnt<$rCnt) {echo "<br/>";}

		  }

		  echo "</td>";

		  if ($rCnt==0) {$statVal="-";} else {$statVal=stat_format($stat,$statVal);}

	  	  echo "<td valign='top'>$statVal</td>";

		  

		  ##Seasonal

		  $query="SELECT t.team_id,name,nickname,x2.year,x1.stat FROM team_history as t,(SELECT team_id,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid AND year<=$i AND year>=$minYr$slQuery GROUP BY team_id,year ORDER BY stat $orderClause LIMIT 1) as x1,(SELECT team_id,year,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid AND year<=$i AND year>=$minYr$slQuery GROUP BY team_id,year ORDER BY stat $orderClause LIMIT 6) as x2 WHERE t.team_id=x2.team_id AND t.year=x2.year AND x1.stat=x2.stat;";

  		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

  		  $rCnt=mysqli_num_rows($result);

		  $pCnt=0;

  		  echo "<td class='".$cls."_l' style='border-left:1px solid black;' valign='top'>";

		  while ($row=mysqli_fetch_array($result))

  		  {

			  $pCnt++;

  			  if (($rCnt>5)&&($pCnt>4))

			  {

  				  echo "And others...";

				  break;

  			  }

			  $tid=$row['team_id'];

  			  $name=$row['name']." ".$row['nickname'];

			  $yr=$row['year'];

  			  $statVal=$row['stat'];

			  echo "<a href='./team_summary.php?team_id=$tid&year=$yr'>$name</a>";

  			  if ($pCnt<$rCnt) {echo "<br/>";}

		  }

		  echo "</td>";

		  if ($rCnt==0) {$statVal="-";} else {$statVal=stat_format($stat,$statVal);}

	  	  echo "<td valign='top'>$statVal</td>";

	  

		  ##Active

		  $query="SELECT t.team_id,name,nickname,x1.stat FROM team_history as t,(SELECT team_id,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid AND year<=$i AND year>=$minYr$slQuery GROUP BY team_id HAVING MAX(year)=$i ORDER BY stat $orderClause LIMIT 1) as x1,(SELECT team_id,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid AND year<=$i AND year>=$minYr$slQuery GROUP BY team_id HAVING MAX(year)=$i ORDER BY stat $orderClause LIMIT 6) as x2 WHERE t.team_id=x2.team_id AND t.year=$i AND x1.stat=x2.stat;";

  		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

  		  $rCnt=mysqli_num_rows($result);

		  $pCnt=0;

  		  echo "<td class='".$cls."_l' style='border-left:1px solid black;' valign='top'>";

		  while ($row=mysqli_fetch_array($result))

  		  {

			  $pCnt++;

  			  if (($rCnt>5)&&($pCnt>4))

			  {

  				  echo "And others...";

				  break;

  			  }

			  $tid=$row['team_id'];

  			  $name=$row['name']." ".$row['nickname'];

			  $statVal=$row['stat'];

  			  echo "<a href='./team_hist.php?team_id=$tid'>$name</a>";

			  if ($pCnt<$rCnt) {echo "<br/>";}

		  }

		  echo "</td>";

		  if ($rCnt==0) {$statVal="-";} else {$statVal=stat_format($stat,$statVal);}

	  	  echo "<td valign='top'>$statVal</td>";

	  

		  ##Yearly

		  $query="SELECT t.team_id,name,nickname,x2.year,x1.stat FROM team_history as t,(SELECT team_id,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid AND year=$i$slQuery GROUP BY team_id,year ORDER BY stat $orderClause LIMIT 1) as x1,(SELECT team_id,year,";

  		  $query.=$statCalc;

		  $query.=" as stat FROM $table WHERE league_id=$lgid AND year=$i$slQuery GROUP BY team_id,year ORDER BY stat $orderClause LIMIT 6) as x2 WHERE t.team_id=x2.team_id AND t.year=x2.year AND x1.stat=x2.stat;";

  		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

  		  $rCnt=mysqli_num_rows($result);

		  $pCnt=0;

  		  echo "<td class='".$cls."_l' style='border-left:1px solid black;' valign='top'>";

		  while ($row=mysqli_fetch_array($result))

  		  {

			  $pCnt++;

  			  if (($rCnt>5)&&($pCnt>4))

			  {

  				  echo "And others...";

				  break;

  			  }

			  $tid=$row['team_id'];

  			  $name=$row['name']." ".$row['nickname'];

			  $yr=$row['year'];

  			  $statVal=$row['stat'];

			  echo "<a href='./team_summary.php?team_id=$tid&year=$yr'>$name</a>";

  			  if ($pCnt<$rCnt) {echo "<br/>";}

		  }

		  echo "</td>";

		  if ($rCnt==0) {$statVal="-";} else {$statVal=stat_format($stat,$statVal);}

	  	  echo "<td valign='top'>$statVal</td>";

  

		  #End row

		  echo "</tr>\n";

  		  $cnt++;

	  }

  

	  ## Close Table

	  echo "   </table>\n";



	  echo "  <td></tr>\n";

  	  echo " </table>\n";

	  echo "</div>\n";

  }   ## End Teams View



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);





?>

