<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgpath=$_SESSION['lgpath'];

  $lgdate=$_SESSION['lgdate'];



  $seriesID=$_GET['seriesID'];

  $round=$_GET['round'];

  

  ##### Get Old League Date if Needed #####

  if ($_SESSION['hideScores']==1)

  {

	  $simLen=get_sim_length($_SESSION['adminpath'],$lgid);

  }



  # Title Bar

  if ($seriesID=="") {$title='Playoff Summary';} else {$title='Playoff Series Detail';}



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  nav_toolbar("season","Season");

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");



  ##### Get League Info #####

  $query="SELECT sub_league_id,name FROM sub_leagues WHERE league_id=$lgid ORDER BY sub_league_id;";

  $result=mysqli_query($db,$query);

  while ($row=mysqli_fetch_array($result))			    

  {

	  $slid=$row['sub_league_id'];

    	  $subleagues[$slid]['name']=$row['name'];

  }



  ## Get Playoff Structure

  $query="SELECT * FROM league_playoffs WHERE league_id=$lgid;";

  $result=mysqli_query($db,$query);

  $row=mysqli_fetch_array($result);

  foreach ($row as $field => $val)

  {

	  $playoffConfig[$field]=$val;

  }



  ## Results Toggle

  echo "<div class='textbox' style='border:0;'>\n";

  echo "    <form method='post' action='admin_login_functions.php'>\n";

  echo "     <input type='hidden' name='formName' value='toggleResults'>\n";

  echo "     <input type='hidden' name='user_id' value='".$_SESSION['user_id']."'>\n";

  echo "     <label for='hideScores'>Hide Results</label>\n";

  echo "     <input type='checkbox' name='hideScores' id='hideScores' value=1 ";

  if ($_SESSION['hideScores']==1) {echo "checked";}

  echo " onclick='this.form.submit();' />\n";

  echo "    </form>\n";

  echo "</div>\n";



  ##### Generate View #####

  if ($seriesID=="")     ## Playoff Summary

  {

	  ## Get Team Info

	  $query="SELECT t.team_id,abbr,name,nickname,sub_league_id,logo_file_name,w,l,pos FROM teams as t,team_record as tr WHERE t.league_id=$lgid and t.team_id=tr.team_id;";

	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))			    

	  {

		  $tid=$row['team_id'];

		  $tname=$row['name']." ".$row['nickname'];

		  $teams[$tid]['name']=$tname;

		  $teams[$tid]['city']=$row['name'];

		  $teams[$tid]['abbr']=$row['abbr'];

		  $teams[$tid]['logo']=urlencode($row['logo_file_name']);

		  $teams[$tid]['slid']=$row['sub_league_id'];

		  $teams[$tid]['w']=$row['w'];

		  $teams[$tid]['l']=$row['l'];

		  $teams[$tid]['pos']=$row['pos'];

	  }

	

	  ## Get Games and Series

	  $query="SELECT game_id,home_team,away_team,date,played,runs0,runs1";

	  if ($_SESSION['hideScores']==1)

	  {

		  $query.=",IF(DATEDIFF('$lgdate',games.date)<$simLen,1,0) as hidden";

	  }

	  $query.=" FROM games WHERE game_type=3 and league_id=$lgid ORDER BY date,time;";

       	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))

      	  {

		  $gid=$row['game_id'];

	    	  $hid=$row['home_team'];

		  $aid=$row['away_team'];

	    	  $minTID=min($aid,$hid);

		  $maxTID=max($aid,$hid);

	    	  $serID=$minTID.":".$maxTID;

	    

		  $runs0=$row['runs0'];

		  $runs1=$row['runs1'];

		  $played=$row['played'];



		  $hidden=$row['hidden'];

	    

		  if (!isset($teams[$hid][$serID]))

		  {

		 	  $teams[$hid][$serID]=1;

			  $teams[$aid][$serID]=1;

		 	  $series[$serID][$hid]['w']=0;

			  $series[$serID][$aid]['w']=0;

		 	  $rnd=$teams[$hid]['rnd']+1;

			  $teams[$hid]['rnd']=$rnd;

		 	  $teams[$aid]['rnd']=$rnd;

			  $series[$serID]['rnd']=$rnd;

		 	  $series[$serID]['slid']=$teams[$hid]['slid'];

			  $rounds[$rnd]['fnd']=1;

		  }

		  else {$rnd=$teams[$hid]['rnd'];}

	    

		  if ($played==1)

		  {

			  if ($runs1>$runs0)

			  {

				  if ($hidden==1) {$series[$serID][$hid]['hW']=$series[$serID][$hid]['hW']+1;}

				  else {$series[$serID][$hid]['w']=$series[$serID][$hid]['w']+1;}

			  }

			  else

			  {

				  if ($hidden==1) {$series[$serID][$aid]['hW']=$series[$serID][$aid]['hW']+1;}

				  else {$series[$serID][$aid]['w']=$series[$serID][$aid]['w']+1;}

			  }



			  if (($hidden!=1)||($rnd==1)) {$series[$serID]['begun']=1;}



			  if ($hidden!=1)

			  {

				  $rounds[$rnd]['pcnt']=$rounds[$rnd]['pcnt']+1;

			  }

		  }

		  elseif (($_SESSION['hideScores']!=1)||($rnd==1)) {$series[$serID]['begun']=1;}



		  $rounds[$rnd]['totGms']=$rounds[$rnd]['totGms']+1;

		  if ($rounds[$rnd]['pcnt']==$rounds[$rnd]['totGms']) {$rounds[$rnd]['complete']=1;} else {$rounds[$rnd]['complete']=0;}

	  }

       

	  if (!isset($rounds)) 

	  {

		  echo "<div class='textbox' style='border:0px;float:left;clear:both;'>No playoff games scheduled</div>\n";

		  mysqli_close($db);

		

		  ################## END OF PAGE #########################

		  echo " </div>   <!-- END contentpane DIV -->\n";

		  page_foot($_SESSION['lgpath']);

		  exit;

	  }







	  krsort($rounds);



	  foreach ($rounds as $rnd => $val)

	  {

		  ## Determine if Round Complete

		  $prevRnd=$rnd-1;

		  $prevRndComplete=$rounds[$prevRnd]['complete'];

		  $rndComplete=$rounds[$rnd]['complete'];



      		  ## Begin Round Display

		  echo "<div class='textbox'>\n";

	     	  echo " <table cellpadding=0 cellspacing=0 border=0 width='935px'>\n";

		  $fldName="round_names".($rnd-1);

	    	  echo "  <tr class='title2'><td colspan=3 style='padding:2px;'>".$playoffConfig[$fldName]."</td></tr>\n";

		  echo "  <tr>\n";

     

		  ## Check for Max Round

		  $fldName='max_round';

	    	  if ($playoffConfig[$fldName]==$rnd)   ## In World Series

		  {

		 	  echo "   <td colspan=3 align='center'>\n";

			  foreach ($series as $serID => $val)

			  {

				  if ($series[$serID]['rnd']!=$rnd) {continue;}



				  ## Get Teams

				  $e=explode(":",$serID);

		      		  $aid=$e[0];

				  $hid=$e[1];



				  $hW=$teams[$hid]['w'];

		      		  $hPos=$teams[$hid]['pos'];

				  $aW=$teams[$aid]['w'];

		      		  $aPos=$teams[$aid]['pos'];

		      

				  if ($aPos==$hPos)

				  {

			   		  if ($aW>$hW) {$who='a';}

					  else {$who='h';}

		     		  }

				  elseif ($aPos>$hPos) {$who='a';}

		     		  else {$who='h';}

				  if ($who=='a')

				  {

			   		  $tmp=$hid;

					  $hid=$aid;

					  $aid=$tmp;

		     		  }

		      

				  ## Show Each Series

				  echo "     <table cellpadding=2 cellspacing=0 style='border:1px black solid;width:400px;margin:10px;'>\n";

		      		  echo "      <tr class='headline'>\n";

				  echo "       <td class='hsc2_l' colspan=4>\n";

				  if (($series[$serID]['begun']==1)||($prevRndComplete==1)) {echo "        ".$teams[$aid]['abbr']." vs. ".$teams[$hid]['abbr']."\n";}

				  else {echo "        <span title=\"".$teams[$aid]['abbr']."\">???</span> vs. <span title=\"".$teams[$hid]['abbr']."\">???</span>\n";}

				  echo "       </td>\n";

		      		  echo "      </tr>\n";

				  echo "      <tr>\n";

				  if (($series[$serID]['begun']==1)||($prevRndComplete==1))

				  {

					  echo "       <td style='padding:1px;width:44px;border-right:1px solid #999999;'><img src='$lgpath/images/team_logos/".$teams[$aid]['logo']."' width=40 height=40></td>\n";

					  echo "       <td class='sl' width=175><a href='$lgpath/teams/team_$aid.html'>".$teams[$aid]['name']."</a></td>\n";

					  echo "       <td class='sl' width=175 style='text-align:right;padding-right:5px;'>".ordinal_suffix($teams[$aid]['pos'])." place, ".$teams[$aid]['w']."-".$teams[$aid]['l']."</td>\n";

				  }

				  else

				  {

					  echo "       <td style='padding:1px;width:44px;border-right:1px solid #999999;'><img src='./images/unknown_team.png' width=40 height=40></td>\n";

					  echo "       <td class='sl' width=350 title=\"".$teams[$aid]['name'].", ".ordinal_suffix($teams[$aid]['pos'])." place, ".$teams[$aid]['w']."-".$teams[$aid]['l']."\" colspan=2>???</td>\n";

				  }

				  echo "       <td class='icgb' width=50>";

				  if (($_SESSION['hideScores']==1)&&($rndComplete!=1)) {echo "<span title='".($series[$serID][$aid]['w']+$series[$serID][$aid]['hW'])."'>".$series[$serID][$aid]['w']."<sup>?</sup></span>";}

				  else {echo $series[$serID][$aid]['w'];}

				  echo "</td>\n";

				  echo "      </tr>\n";

				  echo "      <tr>\n";

				  if (($series[$serID]['begun']==1)||($prevRndComplete==1))

				  {

					  echo "       <td style='padding:1px;width:44px;border-right:1px solid #999999;'><img src='$lgpath/images/team_logos/".$teams[$hid]['logo']."' width=40 height=40></td>\n";

					  echo "       <td class='sl' width=175><a href='$lgpath/teams/team_$hid.html'>".$teams[$hid]['name']."</a></td>\n";

					  echo "       <td class='sl' width=175 style='text-align:right;padding-right:5px;'>".ordinal_suffix($teams[$hid]['pos'])." place, ".$teams[$hid]['w']."-".$teams[$hid]['l']."</td>\n";

				  }

				  else

				  {

					  echo "       <td style='padding:1px;width:44px;border-right:1px solid #999999;'><img src='./images/unknown_team.png' width=40 height=40></td>\n";

					  echo "       <td class='sl' width=350 title=\"".$teams[$hid]['name'].", ".ordinal_suffix($teams[$hid]['pos'])." place, ".$teams[$hid]['w']."-".$teams[$hid]['l']."\" colspan=2>???</td>\n";

				  }

				  echo "       <td class='icgb' width=50 style='border-top-width:1px; border-top-style:solid; border-top-color:#999999;'>";

				  if (($_SESSION['hideScores']==1)&&($rndComplete!=1)) {echo "<span title='".($series[$serID][$hid]['w']+$series[$serID][$hid]['hW'])."'>".$series[$serID][$hid]['w']."<sup>?</sup></span>";}

				  else {echo $series[$serID][$hid]['w'];}

				  echo "</td>\n";

		      		  echo "      </tr>\n";

				  echo "      <tr>\n";

		      		  echo "       <td class='sl' colspan=4 style='text-align:right;padding-right:5px;border-top-width:1px; border-top-style:solid; border-top-color:#999999;'>--> <a href='./playoffs.php?seriesID=$serID&round=$rnd'>Series Detail</a>, <a href='./matchups.php?team_id1=$hid&team_id2=$aid'>Season Series</a></td>\n";

				  echo "      </tr>\n";

		      		  echo "     </table>\n";

			  }

		 	  echo "</td>\n";    

		  }

	   	  else    ## Sub-league playoff round

		  {

		 	  $slCnt=0;

			  foreach ($subleagues as $slid => $val)

			  {

				  ## Structure Adjustment

				  if (($slCnt!=0)&&(($slCnt%2)==0))

		     		  {

					  echo "  </tr>\n";

			   		  echo "  <tr>\n";

				  }

		      		  if (($slCnt!=0)&&(($slCnt%2)==1))

				  {

			   		  echo "   <td>&nbsp;</td>\n";

				  }

		      

				  ## Begin League Display

				  echo "   <td>\n";

		      		  echo "    <div class='boxscores'>\n";

				  echo "     <table cellpadding=2 cellspacing=0 border=0 style='border:0;margin:0;width:100%;'><tr class='title'><td>".$subleagues[$slid]['name']."</td></tr></table>\n";



				  foreach ($series as $serID => $val)

		     		  {

					  if ($series[$serID]['rnd']!=$rnd) {continue;}

				   	  if ($series[$serID]['slid']!=$slid) {continue;}

				   

					  ## Get Teams

					  $e=explode(":",$serID);

			   		  $aid=$e[0];

					  $hid=$e[1];



					  $hW=$teams[$hid]['w'];

			   		  $hPos=$teams[$hid]['pos'];

					  $aW=$teams[$aid]['w'];

			   		  $aPos=$teams[$aid]['pos'];

			      

					  if ($aPos==$hPos)

					  {

						  if ($aW>$hW) {$who='a';}

						  else {$who='h';}

			  		  }

					  elseif ($aPos>$hPos) {$who='a';}

			  		  else {$who='h';}

					  if ($who=='a')

					  {

						  $tmp=$hid;

						  $hid=$aid;

						  $aid=$tmp;

			  		  }

			      

					  ## Show Each Series

					  echo "     <table cellpadding=2 cellspacing=0 style='border:1px black solid;width:400px;margin:10px;'>\n";

			   		  echo "      <tr class='headline'>\n";

					  echo "       <td class='hsc2_l' colspan=4>\n";

					  if (($series[$serID]['begun']==1)||($prevRndComplete==1)) {echo "        ".$teams[$aid]['abbr']." vs. ".$teams[$hid]['abbr']."\n";}

					  else {echo "        <span title=\"".$teams[$aid]['abbr']."\">???</span> vs. <span title=\"".$teams[$hid]['abbr']."\">???</span>\n";}

					  echo "       </td>\n";

			   		  echo "      </tr>\n";

					  echo "      <tr>\n";

					  if (($series[$serID]['begun']==1)||($prevRndComplete==1))

					  {

						  echo "       <td style='padding:1px;width:44px;border-right:1px solid #999999;'><img src='$lgpath/images/team_logos/".$teams[$aid]['logo']."' width=40 height=40></td>\n";

						  echo "       <td class='sl' width=175><a href='$lgpath/teams/team_$aid.html'>".$teams[$aid]['name']."</a></td>\n";

						  echo "       <td class='sl' width=175 style='text-align:right;padding-right:5px;'>".ordinal_suffix($teams[$aid]['pos'])." place, ".$teams[$aid]['w']."-".$teams[$aid]['l']."</td>\n";

					  }

					  else

					  {

						  echo "       <td style='padding:1px;width:44px;border-right:1px solid #999999;'><img src='./images/unknown_team.png' width=40 height=40></td>\n";

						  echo "       <td class='sl' width=350 title=\"".$teams[$aid]['name'].", ".ordinal_suffix($teams[$aid]['pos'])." place, ".$teams[$aid]['w']."-".$teams[$aid]['l']."\" colspan=2>???</td>\n";

					  }

					  echo "       <td class='icgb' width=50>";

					  if (($_SESSION['hideScores']==1)&&($rndComplete!=1)) {echo "<span title='".($series[$serID][$aid]['w']+$series[$serID][$aid]['hW'])."'>".$series[$serID][$aid]['w']."<sup>?</sup></span>";}

					  else {echo $series[$serID][$aid]['w'];}

					  echo "</td>\n";

					  echo "      </tr>\n";

					  echo "      <tr>\n";

					  if (($series[$serID]['begun']==1)||($prevRndComplete==1))

					  {

						  echo "       <td style='padding:1px;width:44px;border-right:1px solid #999999;'><img src='$lgpath/images/team_logos/".$teams[$hid]['logo']."' width=40 height=40></td>\n";

						  echo "       <td class='sl' width=175><a href='$lgpath/teams/team_$hid.html'>".$teams[$hid]['name']."</a></td>\n";

						  echo "       <td class='sl' width=175 style='text-align:right;padding-right:5px;'>".ordinal_suffix($teams[$hid]['pos'])." place, ".$teams[$hid]['w']."-".$teams[$hid]['l']."</td>\n";

					  }

					  else

					  {

						  echo "       <td style='padding:1px;width:44px;border-right:1px solid #999999;'><img src='./images/unknown_team.png' width=40 height=40></td>\n";

						  echo "       <td class='sl' width=350 title=\"".$teams[$hid]['name'].", ".ordinal_suffix($teams[$hid]['pos'])." place, ".$teams[$hid]['w']."-".$teams[$hid]['l']."\" colspan=2>???</td>\n";

					  }

					  echo "       <td class='icgb' width=50 style='border-top-width:1px; border-top-style:solid; border-top-color:#999999;'>";

					  if (($_SESSION['hideScores']==1)&&($rndComplete!=1)) {echo "<span title='".($series[$serID][$hid]['w']+$series[$serID][$hid]['hW'])."'>".$series[$serID][$hid]['w']."<sup>?</sup></span>";}

					  else {echo $series[$serID][$hid]['w'];}

					  echo "</td>\n";

					  echo "      </tr>\n";

					  echo "      <tr>\n";

			   		  echo "       <td class='sl' colspan=4 style='text-align:right;padding-right:5px;border-top-width:1px; border-top-style:solid; border-top-color:#999999;'>--> <a href='./playoffs.php?seriesID=$serID&round=$rnd'>Series Detail</a>, <a href='./matchups.php?team_id1=$hid&team_id2=$aid'>Season Series</a></td>\n";

					  echo "      </tr>\n";

			   		  echo "     </table>\n";

				  }



		      		  ## End League Display

				  echo "    </div>\n";

		      		  echo "   </td>\n";

				  $slCnt++;

			  }

			  if (($slCnt!=0)&&(($slCnt%2)==1))

		 	  {

				  echo "   <td colspan=2>&nbsp;</td>\n";

			  }

		  }

	    

		  ## End Round Display

		  echo "  </tr>\n";

	    	  echo " </table>\n";

		  echo "</div>\n";

      	  }

  }

  else                   ##### Series Detail ################################################################

  {

	  if (($seriesID=="")||($round=="")) 

	  {

		  echo "$seriesID::$round<br/>\n";



		  mysqli_close($db);

		

		  ################## END OF PAGE #########################

		  echo " </div>   <!-- END contentpane DIV -->\n";

		  page_foot($_SESSION['lgpath']);

		  exit;

	  }



	  ## Get Teams

	  $e=explode(":",$seriesID);

       	  $aid=$e[0];

	  $hid=$e[1];

       

	  ## Get Team Info

	  $query="SELECT t.team_id,abbr,name,nickname,sub_league_id,logo_file_name,w,l,pos,text_color_id,background_color_id FROM teams as t,team_record as tr WHERE t.league_id=$lgid and t.team_id=tr.team_id AND t.team_id IN ($aid,$hid);";

       	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))			    

      	  {

		  $tid=$row['team_id'];

	    	  $tname=$row['name']." ".$row['nickname'];

		  $teams[$tid]['name']=$tname;

	    	  $teams[$tid]['city']=$row['name'];

		  $teams[$tid]['abbr']=$row['abbr'];

	    	  $teams[$tid]['logo']=urlencode($row['logo_file_name']);

		  $teams[$tid]['slid']=$row['sub_league_id'];

	    	  $teams[$tid]['w']=$row['w'];

		  $teams[$tid]['l']=$row['l'];

	    	  $teams[$tid]['pos']=$row['pos'];

		  $teams[$tid]['text_color_id']=$row['text_color_id'];

	    	  $teams[$tid]['background_color_id']=$row['background_color_id'];

	  }

       

	  ## Get Games

	  $pcnt=0;

	  $pTot=0;

	  $gList="";

	  $gHList="";

	  $query="SELECT game_id,home_team,away_team,date,time,played,innings,runs0,runs1,hits0,hits1,errors0,errors1,winning_pitcher,losing_pitcher,save_pitcher";

	  if ($_SESSION['hideScores']==1)

	  {

		  $query.=",IF(DATEDIFF('$lgdate',games.date)<$simLen,1,0) as hidden";

	  }

	  $query.=" FROM games WHERE game_type=3 and league_id=$lgid AND ((home_team=$hid AND away_team=$aid) OR (home_team=$aid AND away_team=$hid)) ORDER BY date,time;";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $gid=$row['game_id'];

			  $hid=$row['home_team'];

			  $aid=$row['away_team'];

			  $minTID=min($aid,$hid);

			  $maxTID=max($aid,$hid);

			  $serID=$minTID.":".$maxTID;

	  

			  $runs0=$row['runs0'];

			  $runs1=$row['runs1'];

			  $played=$row['played'];



			  $games[$gid]['hid']=$hid;

			  $games[$gid]['aid']=$aid;

			  $games[$gid]['played']=$played;

			  $games[$gid]['runs0']=$runs0;

			  $games[$gid]['runs1']=$runs1;

			  $games[$gid]['innings']=$row['innings'];

			  $games[$gid]['date']=$row['date'];

			  $games[$gid]['time']=$row['time'];

			  $games[$gid]['hits0']=$row['hits0'];

			  $games[$gid]['hits1']=$row['hits1'];

			  $games[$gid]['errors0']=$row['errors0'];

			  $games[$gid]['errors1']=$row['errors1'];

			  $hidden=$row['hidden'];

			  $games[$gid]['hidden']=$hidden;



			  if (!isset($teams[$hid][$serID]))

			  {

				  $teams[$hid][$serID]=1;

				  $teams[$aid][$serID]=1;

				  $series[$serID][$hid]['w']=0;

				  $series[$serID][$aid]['w']=0;

				  $rnd=$teams[$hid]['rnd']+1;

				  $teams[$hid]['rnd']=$rnd;

				  $teams[$aid]['rnd']=$rnd;

				  $series[$serID]['rnd']=$rnd;

				  $series[$serID]['slid']=$teams[$hid]['slid'];

				  $rounds[$rnd]=1;

			  }



			  if ($played==1)

			  {

				  if ($runs1>$runs0)

				  {

					  if ($hidden==1) {$series[$serID][$hid]['hW']=$series[$serID][$hid]['hW']+1;}

					  else {$series[$serID][$hid]['w']=$series[$serID][$hid]['w']+1;$pcnt+=1;}

				  }

				  else

				  {

					  if ($hidden==1) {$series[$serID][$aid]['hW']=$series[$serID][$aid]['hW']+1;}

					  else {$series[$serID][$aid]['w']=$series[$serID][$aid]['w']+1;$pcnt+=1;}

				  }

				  $gList.=",$gid";

				  if ($hidden!=1) {$gHList.=",$gid";}



				  $pTot++;

			  }

	

			  $wp=$row['winning_pitcher'];

			  $lp=$row['losing_pitcher'];

			  $sp=$row['save_pitcher'];

			  $games[$gid]['winning_pitcher']=$wp;

			  $games[$gid]['losing_pitcher']=$lp;

			  $games[$gid]['save_pitcher']=$sp;



			  $players[$wp]['fnd']=1;

			  $players[$lp]['fnd']=1;

			  $players[$sp]['fnd']=1;

		  }

	  }

	  else

	  {

		  echo "<p>The ".$teams[$team_id1]['name']." do not play the ".$teams[$team_id2]['name']." this postseason.</p>";



		  mysqli_close($db);

	

		  ################## END OF PAGE #########################

		  echo " </div>   <!-- END contentpane DIV -->\n";

		  page_foot($_SESSION['lgpath']);

		  exit;

	  }



	  $gList=trim($gList,",");

	  $gHList=trim($gHList,",");

	  $totGms=count($games);

	  if ($gHList=="") {$gHlist=-999;}

       

	  ## Begin Round Display

	  echo "<div class='textbox'>\n";

       	  echo " <table cellpadding=0 cellspacing=0 border=0 width='935px'>\n";

	  $fldName="round_names".($round-1);

       	  echo "  <tr class='title2'><td colspan=7 style='padding:2px;'>".$playoffConfig[$fldName]."</td></tr>\n";

	  echo "  <tr>\n";

       	  echo "   <td style='width:110px;background-color:".$teams[$aid]['background_color_id'].";' align='left'><img src='$lgpath/images/team_logos/".str_replace(".png","_110.png",$teams[$aid]['logo'])."' width=110 height=110></td>\n";

	  echo "   <td style='width:280px;background-color:".$teams[$aid]['background_color_id'].";' align='center'><a href='$lgpath/teams/team_$aid.html' style='font-size:2em;color:".$teams[$aid]['text_color_id'].";'>".$teams[$aid]['name']."</a><br/><span style='font-size:1em;color:".$teams[$aid]['text_color_id'].";'>".ordinal_suffix($teams[$aid]['pos'])." place, ".$teams[$aid]['w']."-".$teams[$aid]['l']."</span></td>\n";

	  echo "   <td style='width:50px;font-size:3em;background-color:".$teams[$aid]['background_color_id'].";color:".$teams[$aid]['text_color_id'].";' align='center'>";

	  if (($_SESSION['hideScores']==1)&&($pcnt<$totGms)) {echo "<span title='".($series[$serID][$aid]['w']+$series[$serID][$aid]['hW'])."'>".$series[$serID][$aid]['w']."<sup>?</sup></span>";}

	  else {echo $series[$serID][$aid]['w'];}

	  echo "</td>\n";

       	  echo "   <td style='width:55px;' align='center' class='icgb'>vs.</td>\n";

	  echo "   <td style='width:50px;font-size:3em;background-color:".$teams[$hid]['background_color_id'].";color:".$teams[$hid]['text_color_id'].";' align='center'>";

	  if (($_SESSION['hideScores']==1)&&($pcnt<$totGms)) {echo "<span title='".($series[$serID][$hid]['w']+$series[$serID][$hid]['hW'])."'>".$series[$serID][$hid]['w']."<sup>?</sup></span>";}

	  else {echo $series[$serID][$hid]['w'];}

	  echo "</td>\n";

       	  echo "   <td style='width:280px;background-color:".$teams[$hid]['background_color_id'].";' align='center'><a href='$lgpath/teams/team_$hid.html' style='font-size:2em;color:".$teams[$hid]['text_color_id'].";'>".$teams[$hid]['name']."</a><br/><span style='font-size:1em;color:".$teams[$hid]['text_color_id'].";'>".ordinal_suffix($teams[$hid]['pos'])." place, ".$teams[$hid]['w']."-".$teams[$hid]['l']."</span></td>\n";

	  echo "   <td style='width:110px;background-color:".$teams[$hid]['background_color_id'].";' align='right'><img src='$lgpath/images/team_logos/".str_replace(".png","_110.png",$teams[$hid]['logo'])."' width=110 height=110></td>\n";

       	  echo "  </tr>\n";

	  echo "  <tr><td style='border-top:1px solid grey;text-align:center;' colspan=7><a href='./matchups.php?team_id1=$hid&team_id2=$aid'>Season Series</a></td></tr>\n";

       	  echo " </table>\n";

	  echo "</div>\n";

	

	  if ($pTot>0)

	  {

		  ##### Get Home Runs #####

		  $query="SELECT player_id,team_id,game_id,hr FROM players_game_batting WHERE hr>0 AND game_id IN ($gList)";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

		  {

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];

				  $tid=$row['team_id'];

				  $gid=$row['game_id'];

				  $hr=$row['hr'];



				  $players[$pid]['fnd']=1;



				  $games[$gid]['hrs'][$tid][$pid]=$hr;

			  }

		  }

	

		  ##### Get Player Names #####

		  if (isset($players))

		  {

			  foreach ($players as $pid => $val) {$pList.=",$pid";}

			  $pList=trim($pList,",");	

	

			  $query="SELECT player_id,first_name,last_name FROM players WHERE player_id IN ($pList)";

			  if ($_GET['showq']==1) {echo "$query<br/>\n";}

			  $result=mysqli_query($db,$query);

			  if (mysqli_num_rows($result))

			  {

				  while ($row=mysqli_fetch_array($result))

				  {

					  $pid=$row['player_id'];

					  $fi=$row['first_name'];

					  $fi=$fi[0];

					  $name=$fi.". ".$row['last_name'];

					  $players[$pid]['name']=$name;

				  }

			  }

		  }

	

		  ##### Get Inning-by-Inning Scores #####

		  $query="SELECT game_id,team,inning,score FROM games_score WHERE game_id IN ($gList) ORDER BY game_id,team,inning";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

		  {

			  $prevGid=-1;

			  while ($row=mysqli_fetch_array($result))

			  {

				  $gid=$row['game_id'];

				  $tid=$row['team'];

				  $inn=$row['inning'];



				  $score=$row['score'];



				  if ($inn<=($games[$gid]['innings']-12)) {continue;}



				  if ($tid==0)

				  {

					  if ($prevGid!=$gid) {$innText[$gid]['inn']="<td class='hc' width=18>&#160;</td>";}

					  $innText[$gid]['inn'].="<td class='hc' width=15>$inn</td>";

				  }

				  elseif (($games[$gid]['runs1']>$games[$gid]['runs0'])&&($row['inning']>8)&&($row['inning']==$games[$gid]['innings'])&&($score==0)) {$score="X";}



				  $hidden=$games[$gid]['hidden'];

				  $innText[$gid][$tid]=$innText[$gid][$tid]."<td class='ic' width=15>";

				  if ($hidden==1) {$innText[$gid][$tid]=$innText[$gid][$tid]."<span title='$score'>?</span>";}

				  else {$innText[$gid][$tid]=$innText[$gid][$tid]."$score";}

				  $innText[$gid][$tid]=$innText[$gid][$tid]."</td>";



				  $prevGid=$gid;

			  }

		  }

	

		  ##### Get Games w/ Great Ind Performances #####

		  # Batting Performances

		  $query="SELECT game_id,pgb.player_id,pgb.team_id,first_name,last_name,h,d,t,hr,rbi,sb FROM players_game_batting as pgb,players as p WHERE pgb.player_id=p.player_id AND pgb.league_id=".$lgid." AND (hr>2 OR h>4 OR rbi>5 or sb>2 OR ((h-d-t-hr)>0 AND d>0 AND t>0 AND hr>0)) AND game_id IN ($gList);";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  while ($row=mysqli_fetch_array($result))

		  {

			  $gid=$row['game_id'];

			  $pid=$row['player_id'];

			  $tid=$row['team_id'];

			  $fi=$row['first_name'];

			  $fi=$fi[0];

			  $name=$fi.". ".$row['last_name'];

			  $h=$row['h'];

			  $d=$row['d'];

			  $t=$row['t'];

			  $hr=$row['hr'];

			  $s=$h-$d-$t-$hr;

			  $rbi=$row['rbi'];

			  $sb=$row['sb'];

			  $hidden=$games[$gid]['hidden'];



			  if ($hr>2) 

			  {

				  if ($hidden==1) {$games[$gid]['note']="<span title=\"$name belts $hr HR's\">???</span>";}

				  else {$games[$gid]['note']=$games[$gid]['note'].", <a href='./player.php?player_id=$pid'>$name</a> belts $hr HR's";}

			  }

			  if ($h>4)

			  {

				  if ($hidden==1) {$games[$gid]['note']="<span title=\"$name knocks $h hits\">???</span>";}

				  else {$games[$gid]['note']=$games[$gid]['note'].", <a href='./player.php?player_id=$pid'>$name</a> knocks $h hits";}

			  }

			  if ($rbi>5)

			  {

				  if ($hidden==1) {$games[$gid]['note']="<span title=\"$name plates $rbi\">???</span>";}

				  else {$games[$gid]['note']=$games[$gid]['note'].", <a href='./player.php?player_id=$pid'>$name</a> plates $rbi";}

			  }

			  if ($sb>2)

			  {

				  if ($hidden==1) {$games[$gid]['note']="<span title=\"$name steals $sb bases\">???</span>";}

				  else {$games[$gid]['note']=$games[$gid]['note'].", <a href='./player.php?player_id=$pid'>$name</a> steals $sb bases";}

			  }

			  if (($s>0)&&($d>0)&&($t>0)&&($hr>0))

			  {

				  if ($hidden==1) {$games[$gid]['note']="<span title=\"$name hits for the cycle\">???</span>";}

				  else {$games[$gid]['note']=$games[$gid]['note'].", <a href='./player.php?player_id=$pid'>$name</a> hits for the cycle";}

			  }

		  }

	  

		  # Pitching Performances

		  $query="SELECT game_id,pgp.player_id,pgp.team_id,first_name,last_name,k,(ip*3+ipf)/3 as ip,ha,cg,sho FROM players_game_pitching_stats as pgp,players as p WHERE pgp.player_id=p.player_id AND pgp.league_id=".$lgid." AND (k>9 OR ((ip*3+ipf)/3)>9 OR (ha=0 AND ((ip*3+ipf)/3)>7) OR (ha<3 AND cg=1 AND sho=1)) AND game_id IN ($gList);";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  while ($row=mysqli_fetch_array($result))

		  {

			  $gid=$row['game_id'];

			  $pid=$row['player_id'];

			  $tid=$row['team_id'];

			  $fi=$row['first_name'];

			  $fi=$fi[0];

			  $name=$fi.". ".$row['last_name'];

			  $k=$row['k'];

			  $ip=$row['ip'];

			  $ha=$row['ha'];

			  $cg=$row['cg'];

			  $sho=$row['sho'];

			  $hidden=$games[$gid]['hidden'];



			  if (floor($ip)==$ip) {$dispIP=round($ip,0);} else {$dispIP=round(floor($ip),0)." ".round((3*($ip-floor($ip))),0)."/3";}



			  if ($k>9)

			  {

				  if ($hidden==1) {$games[$gid]['note']="<span title=\"$name strikes out $k\">???</span>";}

				  else {$games[$gid]['note']=$games[$gid]['note'].", <a href='./player.php?player_id=$pid'>$name</a> strikes out $k";}

			  }

			  if ($ip>9)

			  {

				  if ($hidden==1) {$games[$gid]['note']="<span title=\"$name goes ".$dispIP." innings\">???</span>";}

				  else {$games[$gid]['note']=$games[$gid]['note'].", <a href='./player.php?player_id=$pid'>$name</a> goes ".$dispIP." innings";}

			  }

			  if (($ha==0)&&($ip>7))

			  {

				  if ($cg==1) 

				  {

					  if ($hidden==1) {$games[$gid]['note']="<span title=\"$name pitches a no-hitter\">???</span>";}

					  else {$games[$gid]['note']=$games[$gid]['note'].", <a href='./player.php?player_id=$pid'>$name</a> pitches a no-hitter";}

				  }

				  else 

				  {

					  if ($hidden==1) {$games[$gid]['note']="<span title=\"$name fails to allow a hit\">???</span>";}

					  else {$games[$gid]['note']=$games[$gid]['note'].", <a href='./player.php?player_id=$pid'>$name</a> fails to allow a hit";}

				  }

			  }

			  if (($ha<3)&&($cg==1)&&($sho==1)&&($ha!=0))

			  {

				  if ($hidden==1) {$games[$gid]['note']="<span title=\"$name pitches a $ha-hit shutout\">???</span>";}

				  else {$games[$gid]['note']=$games[$gid]['note'].", <a href='./player.php?player_id=$pid'>$name</a> pitches a $ha-hit shutout";}

			  }

		  }

	  }



	  ## Get Team Situational Records

	  $query="SELECT game_id,home_team,away_team,runs0,runs1 FROM games WHERE game_type=0 AND league_id=$lgid AND played=1 AND (home_team=$hid OR home_team=$aid OR away_team=$hid OR away_team=$aid);";

       	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))

      	  {

		  $hid=$row['home_team'];

	    	  $aid=$row['away_team'];

		  if ($row['runs0']>$row['runs1'])

	   	  {

			  $teams[$aid]['rw']=$teams[$aid]['rw']+1;

		 	  $teams[$hid]['hl']=$teams[$hid]['hl']+1;

		  }

	   	  else

		  {

		 	  $teams[$aid]['rl']=$teams[$aid]['rl']+1;

			  $teams[$hid]['hw']=$teams[$hid]['hw']+1;

	   	  }

	  }

       

	  echo "<div>\n";



	  ## Display Games

	  echo " <div id='first' class='boxscores'><table cellpadding=2 cellspacing=0 border=0 style='border:0;margin:0;width:100%;'><tr class='title'><td>Box Scores</td></tr></table>\n";

	  $gCnt=0;

	  foreach ($games as $gid => $val)

	  {

	   	  $played=$games[$gid]['played'];

		  if ($played==1)   ## Played Games

	   	  {

			  $hid=$games[$gid]['hid'];

			  $hname=$teams[$hid]['name'];

			  $aid=$games[$gid]['aid'];

			  $aname=$teams[$aid]['name'];

			  $inns=$games[$gid]['innings'];

			  $hidden=$games[$gid]['hidden'];



			  # Progressive Standings

			  $gCnt++;

			  if ($gCnt==$totGms) {$finTxt="wins";} else {$finTxt="leads";}

			  if ($games[$gid]['runs0']>$games[$gid]['runs1']) {$pWins[$aid]=$pWins[$aid]+1;}

			  else {$pWins[$hid]=$pWins[$hid]+1;}



			  if ($pWins[$aid]>$pWins[$hid])

			  {

				  if ($hidden==1)

				  {

					  $standText="<span style='text-align:right;width=100%;padding-right:10px;float:right;' title='".$teams[$aid]['city']." $finTxt series ".$pWins[$aid]." to ".max(0,$pWins[$hid])."'>???</span>";

				  }

				  else

				  {

					  $standText="<span style='text-align:right;width=100%;padding-right:10px;float:right;'><a href='$lgpath/teams/team_$aid.html'>".$teams[$aid]['city']."</a> $finTxt series ".$pWins[$aid]." to ".max(0,$pWins[$hid])."</span>";

				  }

			  }

			  elseif ($pWins[$aid]<$pWins[$hid]) 

			  {

				  if ($hidden==1)

				  {

					  $standText="<span style='text-align:right;width=100%;padding-right:10px;float:right;' title='".$teams[$hid]['city']." $finTxt series ".$pWins[$hid]." to ".max(0,$pWins[$aid])."'>???</span>";

				  }

				  else

				  {

					  $standText="<span style='text-align:right;width=100%;padding-right:10px;float:right;'><a href='$lgpath/teams/team_$hid.html'>".$teams[$hid]['city']."</a> $finTxt series ".$pWins[$hid]." to ".max(0,$pWins[$aid])."</span>";

				  }

			  }

			  else 

			  {

				  if ($hidden==1)

				  {

					  $standText="<span style='text-align:right;width=100%;padding-right:10px;float:right;' title='";

					  $standText.="Series tied at ".max(0,$pWins[$hid])." game";

					  if ($pWins[$hid]>1) {$standText.="s";}

					  $standText.=" each";

					  $standText.="'>???</span>";

				  }

				  else

				  {

					  $standText="<span style='text-align:right;width=100%;padding-right:10px;float:right;'>";

					  $standText.="Series tied at ".max(0,$pWins[$hid])." game";

					  if ($pWins[$hid]>1) {$standText.="s";}

					  $standText.=" each";

					  $standText.="</span>";

				  }

			  }



			  # Inning-by-Inning

			  $inntxt=$innText[$gid]['inn'];

			  $ainn=$innText[$gid][0];

			  $hinn=$innText[$gid][1];



			  for ($i=0;$i<(12-$inns);$i++)

			  {

				  $inntxt.="<td class='hc' width=15>&#160;</td>";

				  $ainn.="<td class='ic' width=15>&#160;</td>";

				  $hinn.="<td class='ic' width=15>&#160;</td>";

			  }

			  $inntxt.="<td class='hc' width=15>R</td><td class='hc' width=15>H</td><td class='hc' width=15>E</td>";



			  if ($hidden==1)

			  {

				  $games[$gid]['runs0']="<span title='".$games[$gid]['runs0']."'>?</span>";

				  $games[$gid]['runs1']="<span title='".$games[$gid]['runs1']."'>?</span>";

				  $games[$gid]['hits0']="<span title='".$games[$gid]['hits0']."'>?</span>";

				  $games[$gid]['hits1']="<span title='".$games[$gid]['hits1']."'>?</span>";

				  $games[$gid]['errors0']="<span title='".$games[$gid]['errors0']."'>?</span>";

				  $games[$gid]['errors1']="<span title='".$games[$gid]['errors1']."'>?</span>";

			  }

			  $ainn.="<td class='icgb' width=15>".$games[$gid]['runs0']."</td><td class='ic' width=15>".$games[$gid]['hits0']."</td><td class='ic' width=15>".$games[$gid]['errors0']."</td>";

			  $hinn.="<td class='icgb' width=15>".$games[$gid]['runs1']."</td><td class='ic' width=15>".$games[$gid]['hits1']."</td><td class='ic' width=15>".$games[$gid]['errors1']."</td>";

		

			  # Pitchers

			  $wp=$games[$gid]['winning_pitcher'];

			  $lp=$games[$gid]['losing_pitcher'];

			  $sp=$games[$gid]['save_pitcher'];



			  $ptxt="W: <a href='./player.php?player_id=$wp'>".$players[$wp]['name']."</a> L: <a href='./player.php?player_id=$lp'>".$players[$lp]['name']."</a>";

			  if ($sp!=0) {$ptxt.=" S: <a href='./player.php?player_id=$sp'>".$players[$sp]['name']."</a>";}

			  if ($hidden==1)

			  {

				  $ptxt="<span title=\"W: ".$players[$wp]['name']." L: ".$players[$lp]['name'];

				  if ($sp!=0) {$ptxt.=" S: ".$players[$sp]['name'];}

				  $ptxt.="\">W: ?? L: ?? S: ??</span>";

			  }



			  # HR Text

			  unset($hrtxt);

			  if (isset($games[$gid]['hrs'][$aid]))

			  {

				  $hrtxt[$aid]=$teams[$aid]['abbr'].": ";

				  $hrCnt=0;

				  foreach ($games[$gid]['hrs'][$aid] as $pid => $hr)

				  {

					  if ($hrCnt>0) {$hrtxt[$aid].=", ";}

					  if ($hidden==1) {$hrtxt[$aid].=$players[$pid]['name'];}

					  else {$hrtxt[$aid].="<a href='./player.php?player_id=$pid'>".$players[$pid]['name']."</a>";}

					  if ($hr>1) {$hrtxt[$aid].=" ($hr)";}

					  $hrCnt++;

				  }

			  }

			  if (isset($games[$gid]['hrs'][$hid]))

			  {

				  $hrtxt[$hid]=$teams[$hid]['abbr'].": ";

				  $hrCnt=0;

				  foreach ($games[$gid]['hrs'][$hid] as $pid => $hr)

				  {

					  if ($hrCnt>0) {$hrtxt[$hid].=", ";}

					  if ($hidden==1) {$hrtxt[$hid].=$players[$pid]['name'];}

					  else {$hrtxt[$hid].="<a href='./player.php?player_id=$pid'>".$players[$pid]['name']."</a>";}

					  if ($hr>1) {$hrtxt[$hid].=" ($hr)";}

					  $hrCnt++;

				  }

			  }

			  if ((isset($games[$gid]['hrs'][$aid]))||(isset($games[$gid]['hrs'][$hid])))

			  {

				  if ($hidden==1) {$hrNote="HR - <span title=\"".$hrtxt[$aid]." ".$hrtxt[$hid]."\">???</span>";}

				  else {$hrNote="HR - ".$hrtxt[$aid]." ".$hrtxt[$hid];}

			  }

			  else

			  {

				  if ($hidden==1) {$hrNote="HR - <span title=\"None\">???</span>";}

				  else {$hrNote="";}

			  }



			  # Game Note

			  if (isset($games[$gid]['note']))

			  {

				  $gnote=$games[$gid]['note'];

				  $gnote=trim($gnote,", ");

				  $gnote="<br />Notes: ".$gnote;

			  }

			  else {$gnote="";}

			

			  unset($gdate);

			  $gDate=new Date($games[$gid]['date']);

			  echo " <table cellspacing=0 cellpadding=0 style='border:0px;width:430px;margin:10px;'>\n";

			  echo "  <tr>\n";

			  echo "   <td class='hl'>\n";

			  if ($games[$gid]['type']==3) {echo "    Postseason: ";}

			  echo "    ".$gDate->format("M j, Y");

			  echo ": <a href='$lgpath/box_scores/game_box_$gid.html'>Box Score</a>";

			  echo " | <a href='$lgpath/game_logs/log_$gid.html'>Game Log</a>";

			  echo " | <a href='./matchups.php?team_id1=$hid&team_id2=$aid'>Season Series</a>";

			  echo "   </td>\n";

			  echo "  </tr>\n";

			  echo "  <tr>\n";

			  echo "   <td>\n";

			  echo "    <table cellpadding=0 cellspacing=0 style='border:1px black solid;width:430px;margin-top:2px;margin-left:0px;'>\n";

			  echo "     <tr>\n";

			  echo "      <td style='padding:1px;width:44px;border-right:1px solid #999999;'>\n";

			  echo "       <img src='$lgpath/images/team_logos/".str_replace(".png","_40.png",$teams[$aid]['logo'])."' width=40 height=40><br>\n";

			  echo "       <img src='$lgpath/images/team_logos/".str_replace(".png","_40.png",$teams[$hid]['logo'])."' width=40 height=40>\n";

			  echo "      </td>\n";

			  echo "      <td valign='top' style='padding:0px;margin:0px'>\n";

			  echo "       <table cellspacing=0 cellpadding=1 style='width:100%;margin:0px;border:0px'>\n";

			  echo "        <tr>$inntxt</tr>\n";

			  echo "        <tr><td class='gl'><a href='$lgpath/teams/team_$aid.html'>".$teams[$aid]['city']."</a></td>";

			  echo "$ainn</tr>\n";

			  echo "        <tr><td class='gl'><a href='$lgpath/teams/team_$hid.html'>".$teams[$hid]['city']."</a></td>";

			  echo "$hinn</tr>\n";

			  echo "        <tr><td colspan=16 class='gl' style='padding:6px 4px 4px 4px;'>".$ptxt."<br />".$hrNote.$gnote."<br />$standText</td></tr>\n";

			  echo "       </table>\n";

			  echo "      </td>\n";

			  echo "     </tr>\n";

			  echo "    </table>\n";

			  echo "   </td>\n";

			  echo "  </tr>\n";

			  echo " </table>\n";

		  }

	   	  else  ## Unplayed Games

		  {

		 	  $hid=$games[$gid]['hid'];

			  $hname=$teams[$hid]['name'];

		 	  $aid=$games[$gid]['aid'];

			  $aname=$teams[$aid]['name'];

		   

			  unset($date);

			  $date=new Date($games[$gid]['date']." ".$games[$gid]['time']);

		 	  echo "<table cellspacing=0 cellpadding=0 style='border:0px;width:430px;margin:10px;'>\n";

			  echo " <tr>\n";

		 	  echo "   <td class='hl'>\n    ";

			  if ($games[$gid]['type']==3) {echo "Postseason: ";}

		 	  echo $date->format("M j, Y")."\n";

			  echo "  </td>\n";

		 	  echo " </tr>\n";

			  echo " <tr>\n";

		 	  echo "  <td>\n";

			  echo "    <table cellpadding=0 cellspacing=0 style='border:1px black solid;width:430px;margin-top:2px;margin-left:0px;'>\n";

		 	  echo "     <tr>\n";

			  echo "      <td style='padding:1px;width:44px;border-right:1px solid #999999;'>\n";

		 	  echo "       <img src='$lgpath/images/team_logos/".str_replace(".png","_40.png",$teams[$aid]['logo'])."' width=40 height=40><br>\n";

			  echo "       <img src='$lgpath/images/team_logos/".str_replace(".png","_40.png",$teams[$hid]['logo'])."' width=40 height=40>\n";

		 	  echo "      </td>\n";

			  echo "        <td valign='top' style='padding:0px;margin:0px'>\n";

		 	  echo "       <table cellspacing=0 cellpadding=1 style='width:386px;margin:0px;border:0px'>\n";

		    

			  echo "        <tr><td class='hl' colspan=2>".$date->format("g:i a")."</td></tr>\n";

			  echo "        <tr><td class='gl' width=175><a href='$lgpath/teams/team_$aid.html'>$aname</a></td>\n";

		 	  echo "            <td class='gl' width=175>".$teams[$aid]['w']."-".$teams[$aid]['l'].", On Road: ".$teams[$aid]['rw']."-".$teams[$aid]['rl']."</td></tr>\n";

			  echo "        <tr><td class='gl' width=175><a href='$lgpath/teams/team_$hid.html'>$hname</a></td>\n";

		 	  echo "            <td class='gl' width=175>".$teams[$hid]['w']."-".$teams[$hid]['l'].", At Home: ".$teams[$hid]['hw']."-".$teams[$hid]['hl']."</td></tr>\n";

			  echo "        <tr><td class='gl' colspan=2 style='padding:6px 4px 4px 4px;'>&nbsp;<br />&nbsp;</td></tr>\n";

		 	  echo "       </table>\n";

			  echo "      </td>\n";

		 	  echo "     </tr>\n";

			  echo "    </table>\n";

		 	  echo "   </td>\n";

			  echo "  </tr>\n";

		 	  echo " </table>\n";

		  }

      	  }

	  echo " </div>\n";



	  if ($pcnt==0)

	  {

	    	  echo "</div>\n";

		  mysqli_close($db);

		

		  ################## END OF PAGE #########################

		  echo " </div>   <!-- END contentpane DIV -->\n";

		  page_foot($_SESSION['lgpath']);

		  exit;

      	  }

       

	  ## Get Top Players

	  echo "<div class='textbox' style='clear:right;margin-left:10px;'>\n";

	  echo " <table cellpadding=0 cellspacing=0 border=0 width=460>\n";

       	  echo "  <tr class='title'><td style='padding:2px;'>Top Performers</td></tr>\n";

	  echo "  <tr>\n";

       	  echo "   <td>\n";

       

	  echo " <div class='tablebox'>\n";

	  echo "  <table cellpadding=0 cellspacing=0 border=0>\n";

       	  echo "   <tr class='title'><td style='padding:2px;'>Batters</td></tr>\n";

	  echo "   <tr><td>\n";

	  $query="SELECT p.player_id,first_name,last_name,t.* FROM players as p,(SELECT player_id,team_id,sum(h) as h,sum(hr) as hr,sum(rbi) as rbi,sum(r) as r,sum(sb) as sb,(sum(h)/sum(ab)) as avg,(sum(h)+sum(bb)+sum(hp))/(sum(ab)+sum(bb)+sum(hp)+sum(sf)) as obp,(sum(h)+sum(d)+2*sum(t)+3*sum(hr))/sum(ab) as slg,if(SUM(pa)<(2*$pTot),-99,0.47*(sum(h)-sum(d)-sum(t)-sum(hr)) + .78*sum(d) + 1.09*sum(t) + 1.4*sum(hr) + .33*(sum(bb)-sum(hp)) + .3*sum(sb) - .52*sum(cs) - .26*(sum(ab)-sum(h)-sum(gdp)) - .72*sum(gdp)) as lw FROM players_game_batting WHERE game_id IN ($gHList) GROUP BY player_id ORDER BY lw DESC LIMIT 5) as t WHERE p.player_id=t.player_id ORDER BY last_name,first_name";

	  $result=mysqli_query($db,$query);

       	  echo "   <table class='sortable' width=440>\n";

	  echo "    <thead><tr class='headline'>\n";

       	  echo "     <td class='hsc2_l'>Player</td>";

	  echo "<td class='hsc2'>AVG</td>";

       	  echo "<td class='hsc2'>R</td>";

	  echo "<td class='hsc2'>H</td>";

       	  echo "<td class='hsc2'>HR</td>";

	  echo "<td class='hsc2'>RBI</td>";

       	  echo "<td class='hsc2'>SB</td>";

	  echo "<td class='hsc2'>OPS</td>";

       	  echo "</tr></thead>\n";

	  $rownum=0;

       	  while ($row=mysqli_fetch_array($result))

	  {

	    	  $cls='s'.($rownum%2+1);

		  $tid=$row['team_id'];

	    	  echo "    <tr class='$cls'>";

		  echo "<td class='".$cls."_l'><a href='./player.php?player_id=".$row['player_id']."'>".$row['first_name']." ".$row['last_name']."</a>, <a href='".$lgpath."/teams/team_".$tid.".html'>".$teams[$tid]['abbr']."</a></td>";

	    	  echo "<td>".strstr(sprintf("%.3f",$row['avg']),".")."</td>";

		  echo "<td>".$row['r']."</td>";

	    	  echo "<td>".$row['h']."</td>";

		  echo "<td>".$row['hr']."</td>";

	    	  echo "<td>".$row['rbi']."</td>";

		  echo "<td>".$row['sb']."</td>";

	    	  $ops=sprintf("%.3f",$row['obp']+$row['slg']);

		  if ($ops<1) {$ops=strstr($ops,".");}      

	    	  echo "<td>".$ops."</td>";

		  echo "</tr>\n";

	    	  $rownum++;

	  }

       	  echo "   </table>\n";

	  echo "   </td></tr>\n";

       	  echo "  </table>\n";

	  echo " </div>\n";



	  echo " </td></tr><tr><td>\n";



	  echo " <div class='tablebox'>\n";

       	  echo "  <table cellpadding=0 cellspacing=0 border=0>\n";

	  echo "   <tr class='title'><td style='padding:2px;'>Pitchers</td></tr>\n";

       	  echo "   <tr><td>\n";

	  $query="SELECT p.player_id,first_name,last_name,t.* FROM players as p,(SELECT player_id,team_id,((SUM(ip)*3+SUM(ipf))/3) as ip,sum(w) as w,sum(l) as l,sum(s) as sv,sum(k) as k,9*sum(er)/((SUM(ip)*3+SUM(ipf))/3) as era,(sum(bb)+sum(ha)+sum(hp))/((SUM(ip)*3+SUM(ipf))/3) as whip,sum(ha)/sum(ab) as oavg,(((sum(ha)+sum(bb)+sum(hp))*(0.89*(1.255*(sum(ha)-sum(hra))+4*sum(hra))+0.56*(sum(bb)+sum(hp)-sum(iw))))/(sum(bf)*((SUM(ip)*3+SUM(ipf))/3)))*9*0.75 as erc,if(SUM(ip)<($pTot-1),-99,3*((SUM(ip)*3+SUM(ipf))/3)+4*sum(w)-4*sum(l)+5*sum(s)+sum(k)-2*sum(ha)-2*sum(bb)) as score FROM players_game_pitching_stats WHERE game_id IN ($gHList) GROUP BY player_id ORDER BY score DESC LIMIT 5) as t WHERE p.player_id=t.player_id ORDER BY last_name,first_name";

	  $result=mysqli_query($db,$query);

	  echo "   <table class='sortable' width=440>\n";

       	  echo "    <thead><tr class='headline'>\n";

	  echo "     <td class='hsc2_l'>Player</td>";

       	  echo "<td class='hsc2'>W</td>";

	  echo "<td class='hsc2'>L</td>";

       	  echo "<td class='hsc2'>SV</td>";

	  echo "<td class='hsc2'>IP</td>";

       	  echo "<td class='hsc2'>ERA</td>";

	  echo "<td class='hsc2'>K</td>";

       	  echo "<td class='hsc2'>WHIP</td>";

	  echo "<td class='hsc2'>OAVG</td>";

       	  echo "</tr></thead>\n";

	  $rownum=0;

       	  while ($row=mysqli_fetch_array($result))

	  {

	    	  $cls='s'.($rownum%2+1);

		  $tid=$row['team_id'];

	    	  echo "    <tr class='$cls'>";

		  echo "<td class='".$cls."_l'><a href='./player.php?player_id=".$row['player_id']."'>".$row['first_name']." ".$row['last_name']."</a>, <a href='".$lgpath."/teams/team_".$tid.".html'>".$teams[$tid]['abbr']."</a></td>";

	    	  echo "<td>".$row['w']."</td>";

		  echo "<td>".$row['l']."</td>";

	    	  echo "<td>".$row['sv']."</td>";

		  echo "<td>".sprintf("%.1f",$row['ip'])."</td>";

	    	  echo "<td>".sprintf("%.2f",$row['era'])."</td>";

		  echo "<td>".$row['k']."</td>";

	    	  echo "<td>".sprintf("%.2f",$row['whip'])."</td>";

		  $oavg=sprintf("%.3f",$row['oavg']);

	    	  if ($oavg<1) {$oavg=strstr($oavg,".");}

		  echo "<td>".$oavg."</td>";

	    	  echo "</tr>\n";

		  $rownum++;

      	  }

	  echo "   </table>\n";

       	  echo "   </td></tr>\n";

	  echo "  </table>\n";

       	  echo " </div>\n";

       

	  echo "   </td>\n";

	  echo "  </tr>\n";						 

       	  echo " </table>\n";

       

	  echo "</div>\n";

	  echo "</div>\n";

       

	  ## Display Team Batting Stats

	  foreach ($e as $key => $tid)

      	  {

		  ##### Get Batter Stats #####

		  $Tg=0;

		  $Tab=0;

	    	  $Th=0;

		  $Td=0;

	    	  $Tt=0;

		  $Thr=0;

	    	  $Trbi=0;

		  $Tr=0;

	    	  $Tsb=0;

		  $Tcs=0;

	    	  $Tbb=0;

		  $Thbp=0;

	    	  $Tsf=0;

		  $Tgidp=0;

	    	  $Tk=0;

	    

		  $query="SELECT p.player_id,p.first_name,p.last_name,SUM(g) as g,sum(ab) as ab,sum(h) as h,sum(d) as d,sum(t) as t,sum(hr) as hr,sum(rbi) as rbi,sum(r) as r,sum(sb) as sb,sum(cs) as cs,sum(bb) as bb,sum(hp) as hbp,sum(sf) as sf,sum(gdp) as gidp,sum(k) as k FROM players_game_batting as pgb,players as p WHERE p.player_id=pgb.player_id AND pgb.team_id=$tid AND game_id IN ($gHList) GROUP BY player_id ORDER BY last_name,first_name;";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  echo " <div class='textbox' style='width:935px;'>\n";

		  echo "  <table cellpadding=0 cellspacing=0 border=0><tr class='title'><td style='padding:2px;'>".$teams[$tid]['name']." Batting Stats</td></tr><tr><td>\n";

	    	  echo "   <table class='sortable' cellpadding=2 cellspacing=0 border=0 style='width:935px;'>\n";

		  echo "    <thead><tr class='headline'>\n";

	    	  echo "     <td class='hsc2_l'>Player</td><td class='hsc2'>G</td><td class='hsc2'>AB</td><td class='hsc2'>R</td><td class='hsc2'>H</td><td class='hsc2'>2B</td><td class='hsc2'>3B</td><td class='hsc2'>HR</td><td class='hsc2'>RBI</td><td class='hsc2'>BB</td><td class='hsc2'>K</td><td class='hsc2'>SB</td><td class='hsc2'>CS</td><td class='hsc2'>AVG</td><td class='hsc2'>OBP</td><td class='hsc2'>SLG</td><td class='hsc2'>OPS</td>\n";

		  echo "    </tr></thead>\n";

	    	  $rownum=0;

		  $prevTID="";

	    	  while ($row=mysqli_fetch_array($result))

		  {

		 	  $g=$row['g'];

			  $ab=$row['ab'];

		 	  $h=$row['h'];

			  $d=$row['d'];

		 	  $t=$row['t'];

			  $hr=$row['hr'];

		 	  $rbi=$row['rbi'];

			  $r=$row['r'];

		 	  $sb=$row['sb'];

			  $cs=$row['cs'];

		 	  $bb=$row['bb'];

			  $hbp=$row['hbp'];

		 	  $sf=$row['sf'];

			  $gidp=$row['gidp'];

		 	  $k=$row['k'];

			  $Tg+=$g;

		 	  $Tab+=$ab;

			  $Th+=$h;

		 	  $Td+=$d;

			  $Tt+=$t;

		 	  $Thr+=$hr;

			  $Trbi+=$rbi;

		 	  $Tr+=$r;

			  $Tsb+=$sb;

		 	  $Tcs+=$cs;

			  $Tbb+=$bb;

		 	  $Thbp+=$hbp;

			  $Tsf+=$sf;

		 	  $Tgidp+=$gidp;

			  $Tk+=$k;



			  $rcls=$rownum%2+1;

		 	  echo "    <tr class='s".$rcls."'>";

			  echo "<td class='s".$rcls."_l'><a href='./player.php?player_id=".$row['player_id']."'>".$row['first_name']." ".$row['last_name']."</a></td>";

		 	  echo "<td>".$g."</td>";

			  echo "<td>".$ab."</td>";

		 	  echo "<td>".$r."</td>";

			  echo "<td>".$h."</td>";

		 	  echo "<td>".$d."</td>";

			  echo "<td>".$t."</td>";   

		 	  echo "<td>".$hr."</td>";

			  echo "<td>".$rbi."</td>";

		 	  echo "<td>".$bb."</td>";

			  echo "<td>".$k."</td>";

		 	  echo "<td>".$sb."</td>";

			  echo "<td>".$cs."</td>";

		 	  if ($ab==0)

			  {

		      		  $avg=round(0,3);

				  $slg=round(0,3);

			  }

			  else

			  {

				  $avg=$h/$ab;

		      		  $slg=($h+$d+2*$t+3*$hr)/$ab;

			  }

		 	  if (($ab+$bb+$hbp+$sf)==0) {$obp=0;}

			  else {$obp=($h+$bb+$hbp)/($ab+$bb+$hbp+$sf);}

			  $ops=$obp+$slg;

			  if ($avg<1) {$avg=strstr(sprintf("%.3f",$avg),".");}

			  else {$avg=sprintf("%.3f",$avg);}

			  if ($obp<1) {$obp=strstr(sprintf("%.3f",$obp),".");}

			  else {$obp=sprintf("%.3f",$obp);}

			  if ($slg<1) {$slg=strstr(sprintf("%.3f",$slg),".");}

			  else {$slg=sprintf("%.3f",$slg);}

			  if ($ops<1) {$ops=strstr(sprintf("%.3f",$ops),".");}

			  else {$ops=sprintf("%.3f",$ops);}

			  echo "<td>".$avg."</td>";

			  echo "<td>".$obp."</td>";

		 	  echo "<td>".$slg."</td>";

			  echo "<td>".$ops."</td>";

		 	  echo "</tr>\n";

			  $rownum++;

	   	  }

	    

		  ## Display Team Totals

		  echo "    <tfoot><tr class='headline'>";

	    	  echo "<td class='hsc2_l'>Totals</td>";

		  echo "<td class='hsc2'>".$Tg."</td>";

	    	  echo "<td class='hsc2'>".$Tab."</td>";

		  echo "<td class='hsc2'>".$Tr."</td>";

	    	  echo "<td class='hsc2'>".$Th."</td>";

		  echo "<td class='hsc2'>".$Td."</td>";

	    	  echo "<td class='hsc2'>".$Tt."</td>";

		  echo "<td class='hsc2'>".$Thr."</td>";

	    	  echo "<td class='hsc2'>".$Trbi."</td>";

		  echo "<td class='hsc2'>".$Tbb."</td>";

	    	  echo "<td class='hsc2'>".$Tk."</td>";

		  echo "<td class='hsc2'>".$Tsb."</td>";

	    	  echo "<td class='hsc2'>".$Tcs."</td>";

		  if ($Tab==0)

	   	  {

			  $avg=round(0,3);

		 	  $slg=round(0,3);

		  }

	   	  else

		  {

		 	  $avg=$Th/$Tab;

			  $slg=($Th+$Td+2*$Tt+3*$Thr)/$Tab;

	   	  }

		  $pa=$Tab+$Tbb+$Thbp+$Tsf;

	    	  if ($pa==0) {$obp=0;}

		  else {$obp=($Th+$Tbb+$Thbp)/$pa;}

	    	  $ops=$obp+$slg;

		  if ($avg<1) {$avg=strstr(sprintf("%.3f",$avg),".");}

	   	  else {$avg=sprintf("%.3f",$avg);}

		  if ($obp<1) {$obp=strstr(sprintf("%.3f",$obp),".");}

		  else {$obp=sprintf("%.3f",$obp);}

		  if ($slg<1) {$slg=strstr(sprintf("%.3f",$slg),".");}

		  else {$slg=sprintf("%.3f",$slg);}

	    	  if ($ops<1) {$ops=strstr(sprintf("%.3f",$ops),".");}

		  else {$ops=sprintf("%.3f",$ops);}

	    	  echo "<td class='hsc2'>".$avg."</td>";

		  echo "<td class='hsc2'>".$obp."</td>";

	    	  echo "<td class='hsc2'>".$slg."</td>";

		  echo "<td class='hsc2'>".$ops."</td>";

	    	  echo "</tr></tfoot>\n";

   

		  echo "   </table>\n";

	    	  echo "  </td></tr></table>\n";

		  echo " </div>   <!-- END batter stats DIV -->\n";

      	  }

       

	  ## Display Team Pitching Stats

	  foreach ($e as $key => $tid)

	  {

	    	  $Tg=0;

		  $Tgs=0;

	    	  $Tip=0;

		  $Tw=0;

	    	  $Tl=0;

		  $Tsv=0;

	    	  $Tr=0;

		  $Ter=0;

	    	  $Tk=0;

		  $Tha=0;

	    	  $Tbba=0;

		  $Thra=0;

	    	  $Tcg=0;

		  $Tsho=0;

	    	  $Tab=0;

		  $Tsf=0;

	    

		  ## Get Pitcher Stats

		  $query="SELECT p.first_name,p.last_name,x.* FROM players as p,(SELECT player_id,sum(g) as g,sum(gs) as gs,((sum(IP)*3+sum(ipf))/3) as ip,sum(w) as w,sum(l) as l,sum(s) as sv,sum(r) as r,sum(er) as er,sum(k) as k,sum(ha) as ha,sum(bb) as bba,sum(hra) as hra,sum(cg) as cg,sum(sho) as sho,sum(ab) as ab,sum(sf) as sf FROM players_game_pitching_stats WHERE team_id=$tid AND game_id IN ($gHList) GROUP BY player_id) as x WHERE p.player_id=x.player_id ORDER BY last_name,first_name;";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  echo " <div class='textbox' style='width:935px;'>\n";

	    	  echo "  <table cellpadding=0 cellspacing=0 border=0><tr class='title'><td style='padding:2px;'>".$teams[$tid]['name']." Pitching Stats</td></tr><tr><td>\n";

		  echo "   <table class='sortable' cellpadding=2 cellspacing=0 border=0 style='width:935px;'>\n";

	    	  echo "    <thead><tr class='headline'>\n";

		  echo "     <td class='hsc2_l'>Player</td><td class='hsc2'>W</td><td class='hsc2'>L</td><td class='hsc2'>SV</td><td class='hsc2'>CG</td><td class='hsc2'>SHO</td><td class='hsc2'>ERA</td><td class='hsc2'>G</td><td class='hsc2'>GS</td><td class='hsc2'>IP</td><td class='hsc2'>HA</td><td class='hsc2'>R</td><td class='hsc2'>ER</td><td class='hsc2'>HR</td><td class='hsc2'>BB</td><td class='hsc2'>K</td><td class='hsc2'>WHIP</td><td class='hsc2'>OAVG</td><td class='hsc2'>BABIP</td>\n";

	    	  echo "    </tr></thead>\n";

		  $rownum=0;

	    	  while ($row=mysqli_fetch_array($result))

		  {

		 	  $rcls=$rownum%2+1;

		 

			  $g=$row['g'];

			  $gs=$row['gs'];

		 	  $ip=$row['ip'];

			  $w=$row['w'];

		 	  $l=$row['l'];

			  $sv=$row['sv'];

		 	  $r=$row['r'];

			  $er=$row['er'];

		 	  $k=$row['k'];

			  $ha=$row['ha'];

		 	  $bba=$row['bba'];

			  $hra=$row['hra'];

		 	  $cg=$row['cg'];

			  $sho=$row['sho'];

		 	  $ab=$row['ab'];

			  $sf=$row['sf'];

		 	  $Tg+=$g;

			  $Tgs+=$gs;

		 	  $Tip+=$ip;

			  $Tw+=$w;

		 	  $Tl+=$l;

			  $Tsv+=$sv;

		 	  $Tr+=$r;

			  $Ter+=$er;

		 	  $Tk+=$k;

			  $Tha+=$ha;

		 	  $Tbba+=$bba;

			  $Thra+=$hra;

		 	  $Tcg+=$cg;

			  $Tsho+=$sho;

		 	  $Tab+=$ab;

			  $Tsf+=$sf;

		 

			  echo "    <tr class='s".$rcls."'>";

			  echo "<td class='s".$rcls."_l'><a href='./player.php?player_id=".$row['player_id']."'>".$row['first_name']." ".$row['last_name']."</a></td>";

		 	  echo "<td>".$w."</td>";

			  echo "<td>".$l."</td>";

		 	  echo "<td>".$sv."</td>";

			  echo "<td>".$cg."</td>";

		 	  echo "<td>".$sho."</td>";

			  if ($ip==0) {$era=0;$whip=0;}

			  else 

			  {

		      		  $era=$er*9/$ip;

				  $whip=($ha+$bba)/$ip;

			  }

			  $era=sprintf("%.2f",$era);

		 	  echo "<td>".$era."</td>";

			  echo "<td>".$g."</td>";

		 	  echo "<td>".$gs."</td>";

			  $ip=sprintf("%.1f",$ip);

		 	  if ($ip<1) {$ip=strstr($ip,".");}

			  echo "<td>".$ip."</td>";

		 	  echo "<td>".$ha."</td>";

			  echo "<td>".$r."</td>";

		 	  echo "<td>".$er."</td>";

			  echo "<td>".$hra."</td>";

		 	  echo "<td>".$bba."</td>";

			  echo "<td>".$k."</td>";

		 	  $whip=sprintf("%.2f",$whip);

			  if ($whip<1) {$whip=strstr($whip,".");}

		 	  echo "<td>".$whip."</td>";

			  if ($ab==0) {$oavg=0;}

			  else {$oavg=$ha/$ab;}

			  if ($oavg<1) {$oavg=strstr(sprintf("%.3f",$oavg),".");}

			  else {$oavg=sprintf("%.3f",$oavg);}

			  echo "<td>".$oavg."</td>";

			  $bip=$ab-$k-$hra+$sf;

		 	  if ($bip==0) {$babip=0;}

			  else {$babip=($ha-$hra)/$bip;}

			  if ($babip<1) {$babip=strstr(sprintf("%.3f",$babip),".");}

			  else {$babip=sprintf("%.3f",$babip);}

		 	  echo "<td>".$babip."</td>";

			  echo "</tr>\n";

		 	  $rownum++;

		  }

	    

		  ## Display Team Totals

		  echo "    <tfoot><tr class='headline'>";

	    	  echo "<td class='hsc2_l'>Totals</td>";

		  echo "<td class='hsc2'>".$Tw."</td>";

	    	  echo "<td class='hsc2'>".$Tl."</td>";

		  echo "<td class='hsc2'>".$Tsv."</td>";

	    	  echo "<td class='hsc2'>".$Tcg."</td>";

		  echo "<td class='hsc2'>".$Tsho."</td>";

	    	  if ($Tip==0) {$era=0;$whip=0;}

		  else 

	   	  {

			  $era=$Ter*9/$Tip;

		 	  $whip=($Tha+$Tbba)/$Tip;

		  }

	    	  $era=sprintf("%.2f",$era);

		  echo "<td class='hsc2'>".$era."</td>";

	    	  echo "<td class='hsc2'>".$Tg."</td>";

		  echo "<td class='hsc2'>".$Tgs."</td>";

	    	  $ip=sprintf("%.1f",$Tip);

		  if ($ip<1) {$ip=strstr($ip,".");}

	    	  echo "<td class='hsc2'>".$ip."</td>";

		  echo "<td class='hsc2'>".$Tha."</td>";

	    	  echo "<td class='hsc2'>".$Tr."</td>";

		  echo "<td class='hsc2'>".$Ter."</td>";

	    	  echo "<td class='hsc2'>".$Thra."</td>";

		  echo "<td class='hsc2'>".$Tbba."</td>";

	    	  echo "<td class='hsc2'>".$Tk."</td>";

		  $whip=sprintf("%.2f",$whip);

	    	  if ($whip<1) {$whip=strstr($whip,".");}

		  echo "<td class='hsc2'>".$whip."</td>";

	    	  if ($Tab==0) {$oavg=0;}

		  else {$oavg=$Tha/$Tab;}

	    	  if ($oavg<1) {$oavg=strstr(sprintf("%.3f",$oavg),".");}

		  else {$oavg=sprintf("%.3f",$oavg);}

	    	  echo "<td class='hsc2'>".$oavg."</td>";

		  $bip=$Tab-$Tk-$Thra+$Tsf;

	    	  if ($bip==0) {$babip=0;}

		  else {$babip=($Tha-$Thra)/$bip;}

	    	  if ($babip<1) {$babip=strstr(sprintf("%.3f",$babip),".");}

		  else {$babip=sprintf("%.3f",$babip);}

	    	  echo "<td class='hsc2'>".$babip."</td>";

		  echo "</tr></tfoot>\n";

	    

		  echo "   </table>\n";

		  echo "  </td></tr></table>\n";

	    	  echo " </div>   <!-- END pitcher stats DIV -->\n";

	  }

  }



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);





?>

