<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgdate=$_SESSION['lgdate'];

  $lgpath=$_SESSION['lgpath'];

  $regen=$_GET['regen'];

  if ($regen!=1) {$regen=0;}



  # Title Bar

  $title=$_SESSION['lgname']." Playoff Odds Report";



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  nav_toolbar("season","Season");

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";





  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");



  ##### Check that regular season has begun

  $query="SELECT COUNT(game_id) as g FROM games WHERE league_id=".$lgid." AND played=1 AND game_type=0;";

  $result=mysqli_query($db,$query);

  $row=mysqli_fetch_array($result);

  $gp=$row['g'];



  if ($gp==0)

  {

	  echo "No games played";

	  mysqli_close($db);

	

	  ################## END OF PAGE #########################

	  echo " </div>   <!-- END contentpane DIV -->\n";

	  page_foot($_SESSION['lgpath']);

	  exit;

  }



  ##### Get Playoff Odds Configuration

  $query="SHOW TABLES LIKE 'ootp_sql_admin';";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)) 

  {

	  # Get Settings

	  $query="SELECT setting,value FROM ootp_sql_admin WHERE scope IN ('ALL',$lgid) AND module IN ('admin','Last Sim') AND setting IN ('nSeasons','pythMeth','pythExp','nPOTeams')";

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $setting=$row['setting'];

			  $value=$row['value'];



			  switch ($setting)

			  {

			  case 'nSeasons': $seasons=$value;  break;

			  case 'pythMeth': $pythMeth=$value; break;

			  case 'pythExp' : $pythExp=$value;  break;

			  case 'nPOTeams': $nPOTeams=$value; break;

			  }

		  }

	  }

  }



  switch ($pythMeth)

  {

  case 'Pythagorean Win Pct (Pythagenpat)': $pythMeth='pythPat';break;

  case 'Actual Win Pct': $pythMeth='record'; break;

  default: $pythMeth='pythExp';break;

  }

  if ($pythMeth=="") {$pythMeth='pythExp';}

  if ($seasons=="") {$seasons=10;}

  if ($pythExp=="") {$pythExp=1.82;}



  ## Get Season Completion Percentage

  $query="SELECT played,COUNT(game_id) as g FROM games WHERE league_id=$lgid AND game_type=0 GROUP BY played;";

  $result=mysqli_query($db,$query);

  if ($result)

  {

	  while ($row=mysqli_fetch_array($result))

	  {

		  switch ($row['played'])

		  {

		  case 0: $unPlayGm=$row['g']; break;

		  case 1: $playGm=$row['g']; break;

		  }

	  }

	  $seaCompPct=$playGm/($unPlayGm+$playGm);

  }

  
  if ($seaCompPct<.05) {$pythRegress=90;}
  elseif ($seaCompPct<.1) {$pythRegress=75;}
  elseif ($seaCompPct<.2) {$pythRegress=50;}
  elseif ($seaCompPct<.3) {$pythRegress=25;}
  elseif ($seaCompPct<.4) {$pythRegress=10;}
  else {$pythRegress=0;}



  ##### Check for table

  $query="SHOW TABLES LIKE 'ootp_sql_podds';";

  $result=mysqli_query($db,$query);

  if (!mysqli_num_rows($result)) 

  {

    	  $query="CREATE TABLE ootp_sql_podds (league_id INT, team_id INT, league_date DATE, w SMALLINT, l SMALLINT, gb DOUBLE, rf INT, ra INT, pythW INT, pythL INT, pythPct DOUBLE, totW INT, totL INT, maxW SMALLINT, minW SMALLINT, DivWin DOUBLE, WCWin DOUBLE, TotPO DOUBLE, oppPct DOUBLE, seasons INT, PRIMARY KEY (league_id, team_id, league_date));";

	  mysqli_query($db,$query);

    	  $regen=1;

  }



  ##### Get League Structure #####

  $query="SELECT t.team_id,t.name as city,t.nickname,trec.gb,t.sub_league_id,tr.division_id FROM teams as t,team_relations as tr,team_record as trec WHERE t.league_id=$lgid AND t.team_id=tr.team_id AND t.team_id=trec.team_id AND tr.team_id=trec.team_id ORDER BY t.sub_league_id,tr.division_id,trec.w DESC;";

  $result=mysqli_query($db,$query);

  while ($row=mysqli_fetch_array($result))

  {

	  $tid=$row['team_id'];

    	  $teams[$tid]['id']=$tid;

	  $teams[$tid]['name']=$row['city']." ".$row['nickname'];

    	  $slID=$row['sub_league_id'];

	  $subleagues[$slID]['id']=$slID;

    	  $subleagues[$slID]['nTeams']=$subleagues[$slID]['nTeams']+1;

	  $divID=$row['sub_league_id'].":-:".$row['division_id'];

    	  $divisions[$divID]['id']=$divID;

	  if ($row['gb']==0) {$gb="-";}

   	  else {$gb=sprintf("%.1f",$row['gb']);}

	  if ($row['gb']==.5) {$gb=strstr($gb,".");}

    	  $teams[$tid]['gb']=$gb;

	  $teams[$tid]['subleague']=$slID;

    	  $teams[$tid]['division']=$divID;

	  $teams[$tid]['DivWin']=0;

    	  $teams[$tid]['WCWin']=0;

	  $teams[$tid]['TotPO']=0;

    	  $teams[$tid]['totW']=0;

	  $teams[$tid]['totL']=0;

  }



  ##### Get Wild Cards #####

  $query="SELECT num_wild_cards FROM league_playoffs WHERE league_id=$lgid;";

  $result=mysqli_query($db,$query);

  $row=mysqli_fetch_array($result);

  $numWC=$row['num_wild_cards'];



  ##### Get Number of Divisions Per League #####

  $query="SELECT sub_league_id,COUNT(division_id) as cnt FROM divisions WHERE league_id=$lgid GROUP BY sub_league_id;";

  $result=mysqli_query($db,$query);

  while ($row=mysqli_fetch_array($result))

  {

	  $slID=$row['sub_league_id'];

    	  $subleagues[$slID]['nDivs']=$row['cnt'];

	  if ($numWC!=0)

   	  {

		  if (($row['cnt']%2)==0) {$subleagues[$slID]['nWCs']=2;}

		  else {$subleagues[$slID]['nWCs']=1;}

	  }

   	  else {$subleagues[$slID]['nWCs']=0;}

	  if ($nPOTeams!="") {$subleagues[$slID]['nWCs']=$nPOTeams-$row['cnt'];}

    	  $maxWC=$subleagues[$slID]['nTeams']-$row['cnt'];

	  $subleagues[$slID]['nWCs']=min($subleagues[$slID]['nWCs'],$maxWC);

  }



  ##### Check for saved results #####

  if ($regen!=1)

  {

	  $query="SELECT * FROM ootp_sql_podds WHERE league_id=$lgid AND league_date='$lgdate';";

    	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

    	  if (!mysqli_num_rows($result)) {$regen=1;}

	  else

   	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

	      		  $w=$row['w'];

			  $l=$row['l'];

	      		  $teams[$tid]['w']=$w;

			  $teams[$tid]['l']=$l;

	      		  if ($w+$l==0) {$teams[$tid]['winPct']=0;} else {$teams[$tid]['winPct']=$w/($w+$l);}

			  if ($row['gb']==0) {$gb="-";}

			  else {$gb=sprintf("%.1f",$row['gb']);}

			  if ($row['gb']==.5) {$gb=strstr($gb,".");}

			  $teams[$tid]['gb']=$gb;

	      		  $teams[$tid]['rf']=$row['rf'];

			  $teams[$tid]['ra']=$row['ra'];

	      		  $teams[$tid]['pythW']=$row['pythW'];

			  $teams[$tid]['pythL']=$row['pythL'];

	      		  $teams[$tid]['actPythPct']=$row['pythPct'];

			  $teams[$tid]['pythDiff']=$w-$row['pythW'];

	      		  $teams[$tid]['totW']=$row['totW'];

			  $teams[$tid]['totL']=$row['totL'];

	      		  $teams[$tid]['maxW']=$row['maxW'];

			  $teams[$tid]['minW']=$row['minW'];

	      		  $teams[$tid]['DivWin']=$row['DivWin'];

			  $teams[$tid]['WCWin']=$row['WCWin'];

	      		  $teams[$tid]['TotPO']=$row['TotPO'];

			  $teams[$tid]['oppPct']=$row['oppPct'];

	      		  $seasons=$row['seasons'];

		  }

   	  }

  }



  ##### Generate Results #####

  if ($regen==1)

  {

	  ##### Get Team Records #####

	  $query="SELECT game_id,dte,tid,sum(ra) as ra,sum(rf) as rf,sum(loss) as l,sum(win) as w FROM (SELECT game_id,games.date as dte,away_team as tid,runs1 as ra,runs0 as rf,(runs1>runs0) as loss,(runs0>runs1) as win FROM games WHERE played=1 AND league_id=".$lgid." AND game_type=0 UNION SELECT game_id,games.date as dte,home_team as tid,runs0 as ra,runs1 as rf,(runs0>runs1) as loss,(runs1>runs0) as win FROM games WHERE played=1 AND league_id=".$lgid." AND game_type=0) as t GROUP by tid;";

	  $result=mysqli_query($db,$query);

    	  while ($row=mysqli_fetch_array($result))

	  {

	 	  $tid=$row['tid'];

		  $teams[$tid]['rf']=$row['rf'];

	 	  $teams[$tid]['ra']=$row['ra'];

		  $teams[$tid]['w']=$row['w'];

	 	  $teams[$tid]['l']=$row['l'];

		  $teams[$tid]['g']=$row['w']+$row['l'];

	 	  $teams[$tid]['winPct']=$row['w']/$teams[$tid]['g'];

		  $teams[$tid]['minW']=1000;

	 	  switch ($pythMeth)

		  {

      		  case 'pythPat':

			  $pythExp=pow(($row['rf']+$row['ra'])/$teams[$tid]['g'],0.287);

	    		  $pythPct=pow($row['rf'],$pythExp)/(pow($row['rf'],$pythExp)+pow($row['ra'],$pythExp));

			  break;

      		  case 'pythExp':

			  $pythPct=pow($row['rf'],$pythExp)/(pow($row['rf'],$pythExp)+pow($row['ra'],$pythExp));

	    		  break;

		  case 'record':

      		  default:

			  $pythPct=$teams[$tid]['winPct'];

	    		  break;

		  }

	 	  $teams[$tid]['actPythPct']=$pythPct;

		  $pythPct=0.5+(($pythPct-0.5)*(1-$pythRegress/100));

	 	  $teams[$tid]['pythPct']=$pythPct;

		  $teams[$tid]['pythW']=round($teams[$tid]['g']*$teams[$tid]['pythPct'],0);

	 	  $teams[$tid]['pythL']=$teams[$tid]['g']-$teams[$tid]['pythW'];

		  $teams[$tid]['pythDiff']=$row['w']-$teams[$tid]['pythW'];

   	  }

    

	  ##### Get Remainder of Schedule #####

	  $query="SELECT game_id,home_team,away_team FROM games WHERE league_id=".$lgid." AND played=0 AND game_type=0;";

    	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))

   	  {

		  $gid=$row['game_id'];

	 	  $home[$gid]=$row['home_team'];

		  $away[$gid]=$row['away_team'];

   	  }

    

	  ##### Loop Through Seasons #####

	  $randmax=getrandmax();

    	  for ($j=0;$j<$seasons;$j++)

	  {

	 	  ## Initialize seasonal record

		  foreach ($teams as $tid => $val)

		  {

			  $teams[$tid]['simW']=$teams[$tid]['w'];

	      		  $teams[$tid]['simL']=$teams[$tid]['l'];

			  $teams[$tid]['simDiv']=0;

	      		  $teams[$tid]['simWC']=0;

			  $teams[$tid]['simPO']=0;

		  }

	 

		  ## Loop through remainder of season

		  if (isset($home))

		  {

			  foreach ($home as $key => $val)

	     		  {

				  $rand=rand(0,$randmax)/$randmax;

		   		  $htid=$val;

				  $atid=$away[$key];

		   		  $hpct=log5WinPct($teams[$htid]['pythPct'],$teams[$atid]['pythPct']);

				  if ($j==0)

		  		  {

					  $teams[$htid]['oppPct']=$teams[$htid]['oppPct']+$teams[$atid]['pythPct'];

					  $teams[$atid]['oppPct']=$teams[$atid]['oppPct']+$teams[$htid]['pythPct'];

					  $teams[$htid]['opps']=$teams[$htid]['opps']+1;

					  $teams[$atid]['opps']=$teams[$atid]['opps']+1;

				  }

		   		  if ($rand<=$hpct)

				  {

					  $teams[$htid]['simW']+=1;

					  $teams[$atid]['simL']+=1;

		  		  }

				  else

		  		  {

					  $teams[$atid]['simW']+=1;

					  $teams[$htid]['simL']+=1;

				  }

	     		  }

		  }

	 

		  ## Get Win Totals

		  foreach ($teams as $tid => $val)

		  {

			  if ($teams[$tid]['maxW']<$teams[$tid]['simW']) {$teams[$tid]['maxW']=$teams[$tid]['simW'];}

	      		  if ($teams[$tid]['minW']>$teams[$tid]['simW']) {$teams[$tid]['minW']=$teams[$tid]['simW'];}

			  $teams[$tid]['totW']=$teams[$tid]['totW']+$teams[$tid]['simW'];

	      		  $teams[$tid]['totL']=$teams[$tid]['totL']+$teams[$tid]['simL'];

		  }

	 

		  ## Find Division Max Wins

		  foreach ($divisions as $keyD => $val)

		  {

			  $divisions[$keyD]['maxW']=0;

	      		  $divisions[$keyD]['nWin']=0;

			  foreach ($teams as $keyT => $val)

	     		  {

				  if (($teams[$keyT]['division']==$keyD) && ($teams[$keyT]['simW']>$divisions[$keyD]['maxW']))

		  		  {

					  $divisions[$keyD]['maxW']=$teams[$keyT]['simW']; 

		  		  }

			  }

		  }

	    

		  ## Assign Division Winners

		  foreach ($teams as $keyT => $val)

		  {

			  $keyD=$teams[$keyT]['division'];

	      		  if ($teams[$keyT]['simW']==$divisions[$keyD]['maxW'])

			  {

		   		  $teams[$keyT]['simDiv']=1;

				  $divisions[$keyD]['nWin']+=1;

	     		  }

		  }

	 	  foreach ($teams as $keyT => $val)

		  {

	      		  $keyD=$teams[$keyT]['division'];

			  $teams[$keyT]['simDiv']=$teams[$keyT]['simDiv']/$divisions[$keyD]['nWin'];

		  }

	 

		  ## Loop Through Number of Wild Cards for each SubLeague

		  foreach ($subleagues as $keySL => $val)

		  {

			  $subleagues[$keySL]['simWC']=0;



			  if ($_GET['showq']==1 ) {echo "$keySL::".$subleagues[$keySL]['simWC']."::".$subleagues[$keySL]['nWCs']."<br/>\n";}

		      	  for ($i=0;$subleagues[$keySL]['simWC']<$subleagues[$keySL]['nWCs'];$i++)

			  {

				  $subleagues[$keySL]['maxW']=0;

				  $subleagues[$keySL]['nWin']=0;

		   		  $subleagues[$keySL]['simWC']=0;

		   

				  ## Get Wild Card Max Wins

				  foreach ($teams as $keyT => $val)

		  		  {

					  if ($teams[$keyT]['subleague']==$keySL) {$subleagues[$keySL]['simWC']=$subleagues[$keySL]['simWC']+$teams[$keyT]['simWC'];}

					  if (($teams[$keyT]['subleague']==$keySL) && ($teams[$keyT]['simW']>$subleagues[$keySL]['maxW']) && ($teams[$keyT]['simDiv']<1) && ($teams[$keyT]['simPO']<1))

					  {

						  $subleagues[$keySL]['maxW']=$teams[$keyT]['simW'];

					  }

		  		  }

		   

				  ## Assign Subleague WC Winners

				  foreach ($teams as $keyT => $val)

		  		  {

					  $teams[$keyT]['slWC']=0;

					  if (($teams[$keyT]['subleague']==$keySL) && ($teams[$keyT]['simW']==$subleagues[$keySL]['maxW']) && ($teams[$keyT]['simDiv']<1) && ($teams[$keyT]['simPO']<1))

					  {

			     			  $teams[$keyT]['slWC']=1;

						  $subleagues[$keySL]['nWin']+=1;

		       			  }

				  }

		   		  foreach ($teams as $keyT => $val)

				  {

					  if (($teams[$keyT]['subleague']==$keySL) && ($teams[$keyT]['simW']==$subleagues[$keySL]['maxW']) && ($teams[$keyT]['simDiv']<1) && ($teams[$keyT]['simPO']<1))

					  {

			     			  $teams[$keyT]['simWC']=min(1-$teams[$keyT]['simDiv'],$teams[$keyT]['simWC']+$teams[$keyT]['slWC']/$subleagues[$keySL]['nWin']);

						  $subleagues[$keySL]['simWC']=$subleagues[$keySL]['simWC']+$teams[$keyT]['simWC'];

			     			  $teams[$keyT]['simPO']=$teams[$keyT]['simDiv']+$teams[$keyT]['simWC'];

					  }

				  }

	     		  }    #END of wild card count loop

		  }    #END of wild card subleague loop



		  ## Store Division/Wildcard Winners In Totals

		  foreach ($teams as $keyT => $val)

		  {

	      		  $teams[$keyT]['DivWin']=$teams[$keyT]['DivWin']+$teams[$keyT]['simDiv'];

			  $teams[$keyT]['WCWin']=$teams[$keyT]['WCWin']+$teams[$keyT]['simWC'];

	      		  $teams[$keyT]['TotPO']=$teams[$keyT]['TotPO']+$teams[$keyT]['simDiv']+$teams[$keyT]['simWC'];

		  }

   

	  }    ## END of seasons for loop

	

	  ##### Get Division Titles #####

	  foreach ($teams as $keyT => $val)

	  {

	 	  $teams[$keyT]['DivWin']=sprintf("%.1f",100*$teams[$keyT]['DivWin']/$seasons);

		  $teams[$keyT]['WCWin']=sprintf("%.1f",100*$teams[$keyT]['WCWin']/$seasons);

	 	  $teams[$keyT]['TotPO']=sprintf("%.1f",100*$teams[$keyT]['TotPO']/$seasons);

		  if ($teams[$keyT]['opps']!=0) {$teams[$keyT]['oppPct']=$teams[$keyT]['oppPct']/$teams[$keyT]['opps'];} else {$teams[$keyT]['oppPct']=0;}

   	  }

    

	  ##### Save off Results #####

	  $query="DELETE FROM ootp_sql_podds WHERE league_id=$lgid AND league_date='$lgdate';";

    	  mysqli_query($db,$query);

	  foreach ($teams as $keyT => $val)

   	  {

		  $query="INSERT INTO ootp_sql_podds (league_id,team_id,league_date,w,l,gb,rf,ra,pythW,pythL,pythPct,totW,totL,maxW,minW,DivWin,WCWin,TotPO,oppPct,seasons) VALUES ($lgid,$keyT";

	 	  $query.=",'$lgdate'";

		  $query.=",".$teams[$keyT]['w'];

	 	  $query.=",".$teams[$keyT]['l'];

		  if ($teams[$keyT]['gb']=="-") {$query.=",0";} else {$query.=",".$teams[$keyT]['gb'];}

	 	  $query.=",".$teams[$keyT]['rf'];

		  $query.=",".$teams[$keyT]['ra'];

	 	  $query.=",".$teams[$keyT]['pythW'];

		  $query.=",".$teams[$keyT]['pythL'];

	 	  $query.=",".$teams[$keyT]['pythPct'];

		  $query.=",".$teams[$keyT]['totW'];

	 	  $query.=",".$teams[$keyT]['totL'];

		  $query.=",".$teams[$keyT]['maxW'];

	 	  $query.=",".$teams[$keyT]['minW'];

		  $query.=",".$teams[$keyT]['DivWin'];

	 	  $query.=",".$teams[$keyT]['WCWin'];

		  $query.=",".$teams[$keyT]['TotPO'];

	 	  $query.=",".$teams[$keyT]['oppPct'];

		  $query.=",$seasons);";

	 	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  mysqli_query($db,$query);

   	  }

  }   ## END of if (regen)



  ##### Display Results #####

  switch ($pythMeth)

  {

  case 'pythPat':

 	  $pythText="pythagorean record (Exp = ((r + ra)/g)^0.287 )";

	  break;

  case 'pythExp':

	  $pythText="pythagorean record (Exp = $pythExp)";

 	  break;

  case 'record':

  default:

	  $pythText="team winning percentage";

  }



  echo "<div class='textbox' style='width:100%;'>\n";

  echo " <table cellpadding=2 cellspacing=0 border=0 width='100%'><tr class='title'><td>Simulated $seasons seasons using $pythText to estimate success</td></tr></table>\n";

  echo "</div>\n";



  $query="SELECT t.team_id,t.name as city,t.nickname,t.sub_league_id,tr.division_id,sl.name as slname,sl.abbr as slabbr,dv.name as dname FROM teams as t,team_relations as tr,team_record as trec,sub_leagues as sl,divisions as dv WHERE t.league_id=$lgid AND t.team_id=tr.team_id AND t.team_id=trec.team_id AND tr.team_id=trec.team_id AND t.league_id=sl.league_id AND t.sub_league_id=sl.sub_league_id AND t.league_id=dv.league_id AND t.sub_league_id=dv.sub_league_id AND tr.league_id=sl.league_id AND tr.sub_league_id=sl.sub_league_id AND tr.league_id=dv.league_id AND tr.sub_league_id=dv.sub_league_id AND tr.division_id=dv.division_id ORDER BY t.sub_league_id,tr.division_id,trec.pct DESC,trec.w DESC;";

  $result=mysqli_query($db,$query);

  $rownum=0;

  $prevSL=-1;

  $prevDiv=-1;

  $slCnt=0;

  $divCnt=0;

  while ($row=mysqli_fetch_array($result))

  {

	  $sl=$row['sub_league_id'];

    	  if ($sl!=$prevSL)

	  {

		  $divCnt=0;

	 	  if ($slCnt>0)

		  {

	      		  ## Generate Wild Card Section

			  if ($subleagues[$prevSL]['nWCs']>0)

	     		  {

				  echo "   </table>\n";

		   		  echo "  </td>\n";

				  echo " </tr>\n";



				  $wcQuery="SELECT t.team_id,t.name as city,t.nickname,t.sub_league_id,tr.division_id,sl.abbr as slabbr,dv.name as dname FROM teams as t,team_relations as tr,team_record as trec,sub_leagues as sl,divisions as dv WHERE t.league_id=$lgid AND t.team_id=tr.team_id AND t.team_id=trec.team_id AND tr.team_id=trec.team_id AND t.league_id=sl.league_id AND t.sub_league_id=sl.sub_league_id AND t.league_id=dv.league_id AND t.sub_league_id=dv.sub_league_id AND tr.league_id=sl.league_id AND tr.sub_league_id=sl.sub_league_id AND tr.league_id=dv.league_id AND tr.sub_league_id=dv.sub_league_id AND tr.division_id=dv.division_id AND trec.pos!=1 AND t.sub_league_id=$prevSL ORDER BY t.sub_league_id,trec.pct DESC,trec.w DESC";

		   		  $wcResult=mysqli_query($db,$wcQuery);

				  $wcRownum=0;

		   		  while ($wcRow=mysqli_fetch_array($wcResult))

				  {

					  $tid=$wcRow['team_id'];

					  $cls='s'.($wcRownum%2+1);



					  if ($wcRownum==0)

		       			  {

						  echo " <tr>\n";

			     			  echo "  <td style='padding-left:12px;padding-right:12px;'>\n";

						  echo "   <table cellspacing=0 cellpadding=1 class='lpo' width='100%' style='margin-bottom:12px;'>\n";

			     			  echo "    <tr class='title'>\n";

						  echo "     <td colspan=19>".$wcRow['slabbr']." Wild Card</td>\n";

			     			  echo "    </tr>\n";

						  echo "    <tr class='headline'><td class='hsc2_l'>Team</td><td class='hsc2'>W</td><td class='hsc2'>L</td><td class='hsc2'>Pct</td><td class='hsc2'>WC GB</td><td class='hsc2'>RF</td><td class='hsc2'>RA</td><td class='hsc2'>PRec</td><td class='hsc2'>PPct</td><td class='hsc2'>Diff</td><td class='hsc2'>AvgW</td><td class='hsc2'>AvgL</td><td class='hsc2'>Avg%</td><td class='hsc2'>MaxW</td><td class='hsc2'>MinW</td><td class='hsc2'>Div%</td><td class='hsc2'>WC%</td><td class='hsc2'>PSOdds%</td><td class='hsc2' title='Estimated winning percentage of remaining opponents'>Opp%</td></tr>\n";



						  $wcWins=$teams[$tid]['w'];

			     			  $wcLoss=$teams[$tid]['l'];

					  }



					  if ($wcRownum<$subleagues[$prevSL]['nWCs'])

		       			  {

						  $wcWins=$teams[$tid]['w'];

			     			  $wcLoss=$teams[$tid]['l'];

						  $wcGB="-";

		       			  }

					  else

		       			  {

						  $wcGB=(($wcWins-$teams[$tid]['w'])+($teams[$tid]['l']-$wcLoss))/2;

		       			  }



	 				  if ($wcGB==0) {$wcGB="-";}	  

					  else {$wcGB=sprintf("%.1f",$wcGB);}

					  if ($wcGB==.5) {$wcGB=strstr($wcGB,".");}

					  $teams[$tid]['wcGB']=$wcGB;

			

					  echo "    <tr class='$cls'>";

					  echo "<td class='".$cls."_l'><a href='$lgpath/teams/team_$tid.html'>".$teams[$tid]['name']."</a></td>";

					  echo "<td>".$teams[$tid]['w']."</td>";

					  echo "<td>".$teams[$tid]['l']."</td>";

					  if ($teams[$tid]['winPct']>=1) {$winPctx=sprintf("%.3f",$teams[$tid]['winPct']);}

					  else {$winPctx=strstr(sprintf("%.3f",$teams[$tid]['winPct']),".");}

					  echo "<td>".$winPctx."</td>";

					  echo "<td>".$teams[$tid]['wcGB']."</td>";

					  echo "<td>".$teams[$tid]['rf']."</td>";

					  echo "<td>".$teams[$tid]['ra']."</td>";

					  echo "<td>".$teams[$tid]['pythW']."-".$teams[$tid]['pythL']."</td>";

					  if ($teams[$tid]['actPythPct']>=1) {$pythPctx=sprintf("%.3f",$teams[$tid]['actPythPct']);}

		       			  else {$pythPctx=strstr(sprintf("%.3f",$teams[$tid]['actPythPct']),".");}

					  echo "<td>".$pythPctx."</td>";

					  echo "<td>".$teams[$tid]['pythDiff']."</td>";

					  echo "<td>".sprintf("%0.1f",($teams[$tid]['totW']/$seasons))."</td>";

					  echo "<td>".sprintf("%0.1f",($teams[$tid]['totL']/$seasons))."</td>";

					  $avgWinPct=$teams[$tid]['totW']/($teams[$tid]['totW']+$teams[$tid]['totL']);

					  echo "<td>".strstr(sprintf("%0.3f",$avgWinPct),".")."</td>";

					  echo "<td>".$teams[$tid]['maxW']."</td>";

					  echo "<td>".$teams[$tid]['minW']."</td>";

					  echo "<td>".sprintf("%.1f",$teams[$tid]['DivWin'])."</td>";

					  echo "<td>".sprintf("%.1f",$teams[$tid]['WCWin'])."</td>";

					  echo "<td>".sprintf("%.1f",$teams[$tid]['TotPO'])."</td>";

					  if ($teams[$tid]['oppPct']>=1) {$oppPct=sprintf("%.3f",$teams[$tid]['oppPct']);}

					  else {$oppPct=strstr(sprintf("%.3f",$teams[$tid]['oppPct']),".");}

					  echo "<td>".$oppPct."</td>";

					  echo "</tr>\n";



					  $wcRownum++;

		  		  }

			  }

	       

			  ## Close Table

			  echo "   </table>\n";

	       		  echo "  </td>\n";

			  echo " </tr>\n";

	       		  echo "</table>\n";

		  }

	  	  echo "<table class='textbox' cellspacing=0 cellpadding=1 class='lpo' width='100%' style='margin-top:12px;'>\n";

		  echo " <tr class='title'>\n";

	  	  echo "  <td colspan=1>".$row['slname']."</td>\n";

		  echo " </tr>\n";

	  	  $slCnt+=1;

		  $prevDiv=-1;

   	  }

     

	  $tid=$row['team_id'];

	  $teams[$tid]['name']=$row['city']." ".$row['nickname'];



	  $div=$row['division_id'];

     	  if ($div!=$prevDiv)

	  {

	  	  $rownum=0;

		  if (($divCnt>0) && ($sl==$prevSL))

		  {

			  echo "   </table>\n";

	      		  echo "  </td>\n";

			  echo " </tr>\n";

		  }

		  echo " <tr>\n";

		  echo "  <td style='";

		  if ($divCnt==0) {echo "padding-top:12px;";}

		  echo "padding-left:12px;padding-right:12px;'>\n";

		  echo "   <table cellspacing=0 cellpadding=1 class='lpo' width='100%' style='margin-bottom:12px;'>\n";

		  echo "    <tr class='title'>\n";

		  if ($row['dname']=="") {echo "     <td colspan=19>".$row['slabbr']."</td>\n";}

		  else {echo "     <td colspan=19>".$row['dname']."</td>\n";}

	 	  echo "    </tr>\n";

		  echo "    <tr class='headline'><td class='hsc2_l'>Team</td><td class='hsc2'>W</td><td class='hsc2'>L</td><td class='hsc2'>Pct</td><td class='hsc2'>GB</td><td class='hsc2'>RF</td><td class='hsc2'>RA</td><td class='hsc2'>PRec</td><td class='hsc2'>PPct</td><td class='hsc2'>Diff</td><td class='hsc2'>AvgW</td><td class='hsc2'>AvgL</td><td class='hsc2'>Avg%</td><td class='hsc2'>MaxW</td><td class='hsc2'>MinW</td><td class='hsc2'>Div%</td><td class='hsc2'>WC%</td><td class='hsc2'>PSOdds%</td><td class='hsc2' title='Estimated winning percentage of remaining opponents'>Opp%</td></tr>\n";

	 	  $divCnt+=1;

	  }

    	  $cls='s'.($rownum%2+1);

	  echo "    <tr class='$cls'>";

    	  echo "<td class='".$cls."_l'><a href='$lgpath/teams/team_$tid.html'>".$teams[$tid]['name']."</a></td>";

	  echo "<td>".$teams[$tid]['w']."</td>";

    	  echo "<td>".$teams[$tid]['l']."</td>";

	  if ($teams[$tid]['winPct']>=1) {$winPctx=sprintf("%.3f",$teams[$tid]['winPct']);}

   	  else {$winPctx=strstr(sprintf("%.3f",$teams[$tid]['winPct']),".");}

	  echo "<td>".$winPctx."</td>";

    	  echo "<td>".$teams[$tid]['gb']."</td>";

	  echo "<td>".$teams[$tid]['rf']."</td>";

    	  echo "<td>".$teams[$tid]['ra']."</td>";

	  echo "<td>".$teams[$tid]['pythW']."-".$teams[$tid]['pythL']."</td>";

    	  if ($teams[$tid]['actPythPct']>=1) {$pythPctx=sprintf("%.3f",$teams[$tid]['actPythPct']);}

	  else {$pythPctx=strstr(sprintf("%.3f",$teams[$tid]['actPythPct']),".");}

    	  echo "<td>".$pythPctx."</td>";

	  echo "<td>".$teams[$tid]['pythDiff']."</td>";

    	  echo "<td>".sprintf("%0.1f",($teams[$tid]['totW']/$seasons))."</td>";

	  echo "<td>".sprintf("%0.1f",($teams[$tid]['totL']/$seasons))."</td>";

    	  $avgWinPct=$teams[$tid]['totW']/($teams[$tid]['totW']+$teams[$tid]['totL']);

	  echo "<td>".strstr(sprintf("%0.3f",$avgWinPct),".")."</td>";

    	  echo "<td>".$teams[$tid]['maxW']."</td>";

	  echo "<td>".$teams[$tid]['minW']."</td>";

    	  echo "<td>".sprintf("%.1f",$teams[$tid]['DivWin'])."</td>";

	  echo "<td>".sprintf("%.1f",$teams[$tid]['WCWin'])."</td>";

    	  echo "<td>".sprintf("%.1f",$teams[$tid]['TotPO'])."</td>";

	  if ($teams[$tid]['oppPct']>=1) {$oppPct=sprintf("%.3f",$teams[$tid]['oppPct']);}

   	  else {$oppPct=strstr(sprintf("%.3f",$teams[$tid]['oppPct']),".");}

	  echo "<td>".$oppPct."</td>";

    	  echo "</tr>\n";

	  $prevSL=$sl;

    	  $prevDiv=$div;

	  $rownum++;

  }



  ## Generate Wild Card Section

  if ($subleagues[$prevSL]['nWCs']>0)

  {

	  echo "   </table>\n";

    	  echo "  </td>\n";

	  echo " </tr>\n";

    

	  $wcQuery="SELECT t.team_id,t.name as city,t.nickname,t.sub_league_id,tr.division_id,sl.abbr as slabbr,dv.name as dname FROM teams as t,team_relations as tr,team_record as trec,sub_leagues as sl,divisions as dv WHERE t.league_id=$lgid AND t.team_id=tr.team_id AND t.team_id=trec.team_id AND tr.team_id=trec.team_id AND t.league_id=sl.league_id AND t.sub_league_id=sl.sub_league_id AND t.league_id=dv.league_id AND t.sub_league_id=dv.sub_league_id AND tr.league_id=sl.league_id AND tr.sub_league_id=sl.sub_league_id AND tr.league_id=dv.league_id AND tr.sub_league_id=dv.sub_league_id AND tr.division_id=dv.division_id AND trec.pos!=1 AND t.sub_league_id=$prevSL ORDER BY t.sub_league_id,trec.pct DESC,trec.w DESC";

	  $wcResult=mysqli_query($db,$wcQuery);

    	  $wcRownum=0;

	  while ($wcRow=mysqli_fetch_array($wcResult))

   	  {

		  $tid=$wcRow['team_id'];

	 	  $cls='s'.($wcRownum%2+1);

	 

		  if ($wcRownum==0)

		  {

	      		  echo " <tr>\n";

			  echo "  <td style='padding-left:12px;padding-right:12px;'>\n";

	      		  echo "   <table cellspacing=0 cellpadding=1 class='lpo' width='100%' style='margin-bottom:12px;'>\n";

			  echo "    <tr class='title'>\n";

	      		  echo "     <td colspan=19>".$wcRow['slabbr']." Wild Card</td>\n";

			  echo "    </tr>\n";

	      		  echo "    <tr class='headline'><td class='hsc2_l'>Team</td><td class='hsc2'>W</td><td class='hsc2'>L</td><td class='hsc2'>Pct</td><td class='hsc2'>WC GB</td><td class='hsc2'>RF</td><td class='hsc2'>RA</td><td class='hsc2'>PRec</td><td class='hsc2'>PPct</td><td class='hsc2'>Diff</td><td class='hsc2'>AvgW</td><td class='hsc2'>AvgL</td><td class='hsc2'>Avg%</td><td class='hsc2'>MaxW</td><td class='hsc2'>MinW</td><td class='hsc2'>Div%</td><td class='hsc2'>WC%</td><td class='hsc2'>PSOdds%</td><td class='hsc2' title='Estimated winning percentage of remaining opponents'>Opp%</td></tr>\n";

	      

			  $wcWins=$teams[$tid]['w'];

			  $wcLoss=$teams[$tid]['l'];

		  }

	 

		  if ($wcRownum<$subleagues[$prevSL]['nWCs'])

		  {

	      		  $wcWins=$teams[$tid]['w'];

			  $wcLoss=$teams[$tid]['l'];

	      		  $wcGB="-";

		  }

		  else

		  {

	      		  $wcGB=(($wcWins-$teams[$tid]['w'])+($teams[$tid]['l']-$wcLoss))/2;

		  }



		  if ($wcGB==0) {$wcGB="-";}	  

		  else {$wcGB=sprintf("%.1f",$wcGB);}

		  if ($wcGB==.5) {$wcGB=strstr($wcGB,".");}

		  $teams[$tid]['wcGB']=$wcGB;



		  echo "    <tr class='$cls'>";

	 	  echo "<td class='".$cls."_l'><a href='$lgpath/teams/team_$tid.html'>".$teams[$tid]['name']."</a></td>";

		  echo "<td>".$teams[$tid]['w']."</td>";

	 	  echo "<td>".$teams[$tid]['l']."</td>";

		  if ($teams[$tid]['winPct']>=1) {$winPctx=sprintf("%.3f",$teams[$tid]['winPct']);}

		  else {$winPctx=strstr(sprintf("%.3f",$teams[$tid]['winPct']),".");}

		  echo "<td>".$winPctx."</td>";

	 	  echo "<td>".$teams[$tid]['wcGB']."</td>";

		  echo "<td>".$teams[$tid]['rf']."</td>";

	 	  echo "<td>".$teams[$tid]['ra']."</td>";

		  echo "<td>".$teams[$tid]['pythW']."-".$teams[$tid]['pythL']."</td>";

	 	  if ($teams[$tid]['actPythPct']>=1) {$pythPctx=sprintf("%.3f",$teams[$tid]['actPythPct']);}

		  else {$pythPctx=strstr(sprintf("%.3f",$teams[$tid]['actPythPct']),".");}

		  echo "<td>".$pythPctx."</td>";

		  echo "<td>".$teams[$tid]['pythDiff']."</td>";

	 	  echo "<td>".sprintf("%0.1f",($teams[$tid]['totW']/$seasons))."</td>";

		  echo "<td>".sprintf("%0.1f",($teams[$tid]['totL']/$seasons))."</td>";

	 	  $avgWinPct=$teams[$tid]['totW']/($teams[$tid]['totW']+$teams[$tid]['totL']);

		  echo "<td>".strstr(sprintf("%0.3f",$avgWinPct),".")."</td>";

	 	  echo "<td>".$teams[$tid]['maxW']."</td>";

		  echo "<td>".$teams[$tid]['minW']."</td>";

	 	  echo "<td>".sprintf("%.1f",$teams[$tid]['DivWin'])."</td>";

		  echo "<td>".sprintf("%.1f",$teams[$tid]['WCWin'])."</td>";

	 	  echo "<td>".sprintf("%.1f",$teams[$tid]['TotPO'])."</td>";

		  if ($teams[$tid]['oppPct']>=1) {$oppPct=sprintf("%.3f",$teams[$tid]['oppPct']);}

		  else {$oppPct=strstr(sprintf("%.3f",$teams[$tid]['oppPct']),".");}

		  echo "<td>".$oppPct."</td>";

	 	  echo "</tr>\n";

	 

		  $wcRownum++;

	  }

  }



  echo "   </table>\n";

  echo "  </td>\n";

  echo " </tr>\n";

  echo "</table>\n";

  



  mysqli_close($db);







  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);





?>

