<?php
  include("html_functions.php");

  ################## PAGE INITIALIZATION #########################
  $lgid=$_SESSION['lgid'];
  $lgpath=$_SESSION['lgpath'];
  $date=new Date($_SESSION['lgdate']);
  $lgyear=$date->format("Y");

  if ($_POST['showq']==1) {$_GET['showq']=1;}

  $view=$_GET['view'];
  if ($view=="") {$view=$_POST['view'];}
  foreach ($_POST as $key => $val) {$settings[$key]=$val;}
  if (!isset($settings['display'])) {$settings['display']='overall';}
  if (!isset($settings['ageBool'])) {$settings['ageBool']='upto';}
  $pageLimit=200;
  $page=$settings['page'];
  if ($page=="") {$page=0;}

  # Title bar
  $title="Player Search";

  page_head($title,$_SESSION['lgpath']);
  echo " <div id='topbar'>\n";
  main_titlebar($lgid,$_SESSION['lgpath'],$title);
  nav_toolbar('front_office',"Front Office");
  echo " </div>   <!-- END topbar DIV -->\n";
  echo " <div id='contentpane'>\n";

  ################## START OF PAGE CONTENT #########################
  include($_SESSION['adminpath']."/dbopen.php");
  
  ##### Display Filters #####
  echo " <div class='textbox'>\n";
  echo "  <form method='post' action='playerSearch.php' style='clear:left;'>\n";
  echo "  <table cellspacing=0 cellpadding=2 border=0>\n";
  echo "   <tr class='title'><td colspan=10>Filters</td></tr>\n";
  echo "   <tr>\n";
  
  ##### Show Type Selection #####
  echo "     <td style='border-bottom:1px solid gray;'>";
  if ($_GET['showq']==1) {echo "<input type='hidden' name='showq' value=1 />\n";}
  echo "      <table cellpadding=2 cellspacing=0 border=0 width='100%'><tr>\n";
  echo "       <td><label><b>Search for:</b></label></td>";
  echo "       <td><input type='radio' name='view' value='batters' id='batters'";
  if ($view=='batters') {echo " checked='checked'";}
  echo "onclick=\"window.location='./playerSearch.php?view=batters'\"></td>";
  echo "       <td><label for='batters'>Batters</label></td>";
  echo "       <td><input type='radio' name='view' value='pitchers' id='pitchers'";
  if ($view=='pitchers') {echo " checked='checked'";}
  echo "onclick=\"window.location='./playerSearch.php?view=pitchers'\"></td>";
  echo "       <td><label for='pitchers'>Pitchers</label></td>";
  
  if ($view!="")
  {
       	  echo "       <td><label for='display'>Display:</label></td>";
	  echo "    <td>\n";
       	  echo "     <select name='display'>\n";
	  echo "      <option value='overall'";
       	  if ($settings['display']=="overall") {echo " selected";}
	  echo ">Ratings</option>\n";
       	  echo "      <option value='talent'";
	  if ($settings['display']=="talent") {echo " selected";}
       	  echo ">Potential</option>\n";
	  echo "     </select>\n";
       	  echo "    </td>\n";
	  if ($view=='batters') {echo "    <td width='250px'>&nbsp;</td>\n";} else {echo "    <td width='400px'>&nbsp;</td>\n";}
       	  echo "    <td><a href='./playerSearch.php?view=$view'>Reset</a></td>\n";
  }

  echo "      </tr></table>\n";
  echo "     </td>\n";
  
  ##### Get Ratings Scales #####
  $query="SHOW TABLES LIKE 'ootp_sql_admin';";
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result)) 
  {
	  $query="SELECT setting,value FROM ootp_sql_admin WHERE scope='ALL' AND module='admin' AND setting IN ('Ratings','Talents','Others','scoutsOn');";
       	  $result=mysqli_query($db,$query);
	  if (mysqli_num_rows($result)) 
      	  {
		  while ($row=mysqli_fetch_array($result))
	   	  {
			  $field=$row['setting'];
		 	  $val=$row['value'];
			  $val=stripslashes($val);
		 	  switch ($field)
			  {
	      		  case 'Ratings'     : $settings['Ratings']=$val;      break;
			  case 'Talents'     : $settings['Talents']=$val;      break;
			  case 'Others'      : $settings['Others']=$val;       break;	
			  case 'scoutsOn'    : $scoutsOn=$val;     break;	
			  }
		  }
      	  }
	  else {$view="";}
  }
  else {$view="";}
	  
  switch ($settings['Ratings'])
  {
  case '1-5'  : $ratMin=1;  $ratMax=5;   break;
  case '2-8'  : $ratMin=2;  $ratMax=8;   break;
  case '1-10' : $ratMin=1;  $ratMax=10;  break;
  case '1-20' : $ratMin=1;  $ratMax=20;  break;
  case '20-80': $ratMin=20; $ratMax=80;  break;
  case '1-100': $ratMin=1;  $ratMax=100; break;
  default     : $ratMin=0;  $ratMax=0;   break;
  }
  switch ($settings['Talents'])
  {
  case '1-5'  : $talMin=1;  $talMax=5;   break;
  case '2-8'  : $talMin=2;  $talMax=8;   break;
  case '1-10' : $talMin=1;  $talMax=10;  break;
  case '1-20' : $talMin=1;  $talMax=20;  break;
  case '20-80': $talMin=20; $talMax=80;  break;
  case '1-100': $talMin=1;  $talMax=100; break;
  default     : $talMin=0;  $talMax=0;   break;
  }
  switch ($settings['Others'])
  {
  case '1-5'  : $othMin=1;  $othMax=5;   break;
  case '2-8'  : $othMin=2;  $othMax=8;   break;
  case '1-10' : $othMin=1;  $othMax=10;  break;
  case '1-20' : $othMin=1;  $othMax=20;  break;
  case '20-80': $othMin=20; $othMax=80;  break;
  case '1-100': $othMin=1;  $othMax=100; break;
  default     : $othMin=0;  $othMax=0;   break;
  }


##### Show View Specific Filters #####
switch ($view)
 {
   case 'batters':
     echo "    <td style='border-bottom:1px solid gray;' colspan=2>&nbsp;</td>\n";
     ## Start New Row
     echo "   </tr>\n";
     echo "   <tr>\n";

     ## Show League Filter
     echo "    <td>\n";
     echo "     <table cellpadding=2 cellspacing=0 border=0><tr>\n";
     echo "     <td><label><b>Restrict results to:</b></label></td>\n";
     echo "     <td>\n";
     echo "     <select name='resRestrict'>\n";
     echo "      <option value='ALL'";
     if ($settings['resRestrict']=='ALL') {echo " selected";}
     echo ">All players</option>\n";
     echo "      <option value='-1'";
     if ($settings['resRestrict']=='-1') {echo " selected";}
     echo ">Free Agents</option>\n";

     $query="SELECT league_id,name,abbr,parent_league_id,if(parent_league_id=0,league_id,parent_league_id) as lgOrder,if(league_level=8,1.5,league_level) as league_level FROM leagues ORDER BY lgOrder,league_level";
     $result=mysqli_query($db,$query);
     if (mysqli_num_rows($result)) 
     {
	     while ($row=mysqli_fetch_array($result))
	     {
		     $league_id=$row['league_id'];
		     $parent_league_id=$row['parent_league_id'];

		     $leagues[$league_id]['name']=$row['name'];
		     $leagues[$league_id]['abbr']=$row['abbr'];
		     $leagues[$league_id]['league_level']=$row['league_level'];
		     $leagues[$league_id]['affLg']=$row['lgOrder'];
		     $leagues[$league_id]['feedLg']=$row['lgOrder'];

		     if (($row['league_level']!=9)&&($row['league_level']!=10))
		     {
			     $affLg=$row['lgOrder'];
			     $leagues[$affLg]['affCnt']=$leagues[$affLg]['affCnt']+1;
			     $leagues[$affLg]['lgList']=$leagues[$affLg]['lgList'].",$league_id";
		     }

		     if (($row['league_level']==9)||($row['league_level']==10))
		     {
			     $feedLg=$row['lgOrder'];
			     $leagues[$feedLg]['feedCnt']=$leagues[$feedLg]['feedCnt']+1;
			     $leagues[$feedLg]['lgFeedList']=$leagues[$feedLg]['lgFeedList'].",$league_id";
		     }
	     }
     }

     $prevLgID=-1;
     foreach ($leagues as $league_id => $val)
     {
	     $affLg=$leagues[$league_id]['affLg'];
	     $feedLg=$leagues[$league_id]['feedLg'];

	     if ($prevLgID!=$affLg)
	     {
		     echo "      <optgroup label='".$leagues[$league_id]['name']."' />\n";

		     if ($leagues[$league_id]['affCnt']>1)
		     {
			     $leagues[$affLg]['lgList']=trim($leagues[$affLg]['lgList'],",");

			     echo "      <option value='Aff-$league_id'";
			     if ($settings['resRestrict']=="Aff-$league_id") {echo " selected";}
			     echo ">".$leagues[$league_id]['abbr']." & Affiliates</option>\n";
		     }

		     if ($leagues[$league_id]['feedCnt']>1)
		     {
			     $leagues[$feedLg]['lgFeedList']=trim($leagues[$feedLg]['lgFeedList'],",");

			     echo "      <option value='Feed-$league_id'";
			     if ($settings['resRestrict']=="Feed-$league_id") {echo " selected";}
			     echo ">".$leagues[$league_id]['abbr']." Feeders</option>\n";
		     }
	     }

	     echo "      <option value='$league_id'";
	     if ($settings['resRestrict']==$league_id) {echo " selected";}
	     echo ">".$leagues[$league_id]['abbr']."</option>\n";

	     $prevLgID=$affLg;
     }

     echo "     </select>\n";
     echo "     </td>\n";
     echo "     </tr></table>\n";
     echo "    </td>\n";


     ## Start New Row
     echo "   </tr>\n";
     echo "   <tr>\n";

     ## Show Age Filter
     echo "    <td>\n";
     echo "     <table cellpadding=2 cellspacing=0 border=0><tr>\n";
     echo "      <td><label><b>Age:<b></label></td>\n";
     echo "      <td><input type='radio' name='ageBool' value='upto' id='upto'";
     if ($settings['ageBool']=='upto') {echo " checked='checked'";}
     echo "></td><td valign=top><label for='upto'>Through</label></td>\n";
     echo "      <td><input type='radio' name='ageBool' value='after' id='after'";
     if ($settings['ageBool']=='after') {echo " checked='checked'";}
     echo "></td><td valign=top><label for='after'>After</label></td>\n";
     echo "      <td><input type='radio' name='ageBool' value='equal' id='equal'";
     if ($settings['ageBool']=='equal') {echo " checked='checked'";}
     echo " onclick=\"document.getElementById('Seasonal').checked=true;\"></td><td valign=top><label for='equal'>Equal</label></td>\n";
     echo "      <td width='80px'>&nbsp;</td>\n";
     echo "      <td>\n";
     echo "       <select name='age'>\n";
     echo "        <option value='All'>All</option>\n";
     for ($i=15;$i<=45;$i++)
      {
        echo "        <option value='$i'";
        if ($i==$settings['age']) {echo " selected";}
        echo ">".$i."</option>\n";
      }
     echo "       </select>\n";
     echo "      </td>\n";
     echo "     </tr></table>\n";
     echo "    </td>\n";

     ## Start New Row
     echo "   </tr>\n";
     echo "   <tr>\n";
     echo "    <td>\n";
     echo "     <table cellpadding=2 cellspacing=0 border=0><tr>\n";

     ## Show Batting Ratings
     $batArray=Array("contact"=>"Contact","gap"=>"Gap","power"=>"Power","eye"=>"Eye","strikeouts"=>"Strikeouts");
     echo "    <td valign='top'>\n";
     echo "     <table cellpadding=2 cellspacing=0 border=0>\n";
     echo "      <tr class='title'><td colspan=5>Batting Ratings</td></tr>\n";
     echo "      <tr class='headline'><td class='hsc2_l'>&nbsp;</td><td class='hsc2_l' colspan=2>Rating</td><td class='hsc2_l' colspan=2>Potential</td></tr>\n";
     foreach ($batArray as $rat => $lbl)
      {
        echo "      <tr>\n";
	echo "       <td>$lbl</td>\n";
	echo "       <td>\n";
	$name=$rat."RatKey";
	echo "        <select name='$name'>\n";
	echo "         <option value='after'";
	if ($settings[$name]=='after') {echo " selected";}
	echo ">>=</option>\n";
	echo "         <option value='upto'";
	if ($settings[$name]=='upto') {echo " selected";}
	echo "><=</option>\n";
	echo "         <option value='equal'";
	if ($settings[$name]=='equal') {echo " selected";}
	echo ">=</option>\n";
	echo "        </select>\n";
	echo "       </td>\n";
	echo "       <td>\n";
	$name=$rat."Rat";
	echo "        <select name='$name'>\n";
	for ($i=$ratMin;$i<=$ratMax;$i++)
	 {
	   echo "         <option value='$i'";
	   if ($settings[$name]==$i) {echo " selected";}
	   echo ">$i</option>\n";
	 }
	echo "        </select>\n";
	echo "       </td>\n";
	echo "       <td>\n";
	$name=$rat."TalKey";
	echo "        <select name='$name'>\n";
	echo "         <option value='after'";
	if ($settings[$name]=='after') {echo " selected";}
	echo ">>=</option>\n";
	echo "         <option value='upto'";
	if ($settings[$name]=='upto') {echo " selected";}
	echo "><=</option>\n";
	echo "         <option value='equal'";
	if ($settings[$name]=='equal') {echo " selected";}
	echo ">=</option>\n";
	echo "        </select>\n";
	echo "       </td>\n";
	echo "       <td>\n";
	$name=$rat."Tal";
	echo "        <select name='$name'>\n";
	for ($i=$talMin;$i<=$talMax;$i++)
	 {
	   echo "         <option value='$i'";
	   if ($settings[$name]==$i) {echo " selected";}
	   echo ">$i</option>\n";
	 }
	echo "        </select>\n";
	echo "       </td>\n";
	echo "      </tr>\n";
      }
     echo "     </table>\n";
     echo "    </td>\n";

     ## Show Fielding Ratings
     $fldArray=Array("pos2"=>"Catcher","pos3"=>"First Base","pos4"=>"Second Base","pos5"=>"Third Base","pos6"=>"Shortstop","pos7"=>"Left Field","pos8"=>"Center Field","pos9"=>"Right Field","catcher_arm"=>"Catcher Arm","infield_arm"=>"Infield Arm","outfield_arm"=>"Outfield Arm");
     echo "    <td valign='top'>\n";
     echo "     <table cellpadding=2 cellspacing=0 border=0>\n";
     echo "      <tr class='title'><td colspan=4>Fielding Ratings</td></tr>\n";
     echo "      <tr class='headline'><td class='hsc2_l'>&nbsp;</td><td class='hsc2_l'>Operator</td><td class='hsc2_l'>Rating</td></tr>\n";
     foreach ($fldArray as $rat => $lbl)
      {
        echo "      <tr>\n";
	echo "       <td>$lbl</td>\n";
	echo "       <td>\n";
	$name=$rat."Key";
	echo "        <select name='$name'>\n";
	echo "         <option value='after'";
	if ($settings[$name]=='after') {echo " selected";}
	echo ">>=</option>\n";
	echo "         <option value='upto'";
	if ($settings[$name]=='upto') {echo " selected";}
	echo "><=</option>\n";
	echo "         <option value='equal'";
	if ($settings[$name]=='equal') {echo " selected";}
	echo ">=</option>\n";
	echo "        </select>\n";
	echo "       </td>\n";
	echo "       <td>\n";
	$name=$rat."Rat";
	echo "        <select name='$name'>\n";
	echo "         <option value='0'>None</option>\n";
	for ($i=$othMin;$i<=$othMax;$i++)
	 {
	   echo "         <option value='$i'";
	   if ($settings[$name]==$i) {echo " selected";}
	   echo ">$i</option>\n";
	 }
	echo "        </select>\n";
	echo "       </td>\n";
	echo "      </tr>\n";
      }
     echo "     </table>\n";
     echo "    </td>\n";

     ## Show Running Ratings
     $runArray=Array("speed"=>"Speed","stealing"=>"Stealing","baserunning"=>"Baserunning");
     echo "    <td valign='top'>\n";
     echo "     <table cellpadding=2 cellspacing=0 border=0>\n";
     echo "      <tr class='title'><td colspan=4>Running Ratings</td></tr>\n";
     echo "      <tr class='headline'><td class='hsc2_l'>&nbsp;</td><td class='hsc2_l'>Operator</td><td class='hsc2_l'>Rating</td></tr>\n";
     foreach ($runArray as $rat => $lbl)
      {
        echo "      <tr>\n";
	echo "       <td>$lbl</td>\n";
	echo "       <td>\n";
	$name=$rat."Key";
	echo "        <select name='$name'>\n";
	echo "         <option value='after'";
	if ($settings[$name]=='after') {echo " selected";}
	echo ">>=</option>\n";
	echo "         <option value='upto'";
	if ($settings[$name]=='upto') {echo " selected";}
	echo "><=</option>\n";
	echo "         <option value='equal'";
	if ($settings[$name]=='equal') {echo " selected";}
	echo ">=</option>\n";
	echo "        </select>\n";
	echo "       </td>\n";
	echo "       <td>\n";
	$name=$rat."Rat";
	echo "        <select name='$name'>\n";
	echo "         <option value='0'>None</option>\n";
	for ($i=$othMin;$i<=$othMax;$i++)
	 {
	   echo "         <option value='$i'";
	   if ($settings[$name]==$i) {echo " selected";}
	   echo ">$i</option>\n";
	 }
	echo "        </select>\n";
	echo "       </td>\n";
	echo "      </tr>\n";
      }
     echo "     </table>\n";
     echo "    </td>\n";

     echo "     </tr></table>\n";
     echo "    </td>\n";
     break;
   case 'pitchers':
     echo "    <td style='border-bottom:1px solid gray;' colspan=2>&nbsp;</td>\n";
     ## Start New Row
     echo "   </tr>\n";
     echo "   <tr>\n";

     ## Show League Filter
     echo "    <td>\n";
     echo "     <table cellpadding=2 cellspacing=0 border=0><tr>\n";
     echo "     <td><label><b>Restrict results to:</b></label></td>\n";
     echo "     <td>\n";
     echo "     <select name='resRestrict'>\n";
     echo "      <option value='ALL'";
     if ($settings['resRestrict']=='ALL') {echo " selected";}
     echo ">All players</option>\n";
     echo "      <option value='-1'";
     if ($settings['resRestrict']=='-1') {echo " selected";}
     echo ">Free Agents</option>\n";

     $query="SELECT league_id,name,abbr,parent_league_id,if(parent_league_id=0,league_id,parent_league_id) as lgOrder,if(league_level=8,1.5,league_level) as league_level FROM leagues ORDER BY lgOrder,league_level";
     $result=mysqli_query($db,$query);
     if (mysqli_num_rows($result)) 
     {
	     while ($row=mysqli_fetch_array($result))
	     {
		     $league_id=$row['league_id'];
		     $parent_league_id=$row['parent_league_id'];

		     $leagues[$league_id]['name']=$row['name'];
		     $leagues[$league_id]['abbr']=$row['abbr'];
		     $leagues[$league_id]['league_level']=$row['league_level'];
		     $leagues[$league_id]['affLg']=$row['lgOrder'];
		     $leagues[$league_id]['feedLg']=$row['lgOrder'];

		     if (($row['league_level']!=9)&&($row['league_level']!=10))
		     {
			     $affLg=$row['lgOrder'];
			     $leagues[$affLg]['affCnt']=$leagues[$affLg]['affCnt']+1;
			     $leagues[$affLg]['lgList']=$leagues[$affLg]['lgList'].",$league_id";
		     }

		     if (($row['league_level']==9)||($row['league_level']==10))
		     {
			     $leagues[$league_id]['feedLg']=$row['lgOrder'];
			     $feedLg=$row['lgOrder'];
			     $leagues[$feedLg]['feedCnt']=$leagues[$feedLg]['feedCnt']+1;
			     $leagues[$feedLg]['lgFeedList']=$leagues[$feedLg]['lgFeedList'].",$league_id";
		     }
	     }
     }

     $prevLgID=-1;
     foreach ($leagues as $league_id => $val)
     {
	     $affLg=$leagues[$league_id]['affLg'];
	     $feedLg=$leagues[$league_id]['feedLg'];

	     if ($prevLgID!=$affLg)
	     {
		     echo "      <optgroup label='".$leagues[$league_id]['name']."' />\n";

		     if ($leagues[$league_id]['affCnt']>1)
		     {
			     $leagues[$affLg]['lgList']=trim($leagues[$affLg]['lgList'],",");

			     echo "      <option value='Aff-$league_id'";
			     if ($settings['resRestrict']=="Aff-$league_id") {echo " selected";}
			     echo ">".$leagues[$league_id]['abbr']." & Affiliates</option>\n";
		     }

		     if ($leagues[$league_id]['feedCnt']>1)
		     {
			     $leagues[$feedLg]['lgFeedList']=trim($leagues[$feedLg]['lgFeedList'],",");

			     echo "      <option value='Feed-$league_id'";
			     if ($settings['resRestrict']=="Feed-$league_id") {echo " selected";}
			     echo ">".$leagues[$league_id]['abbr']." Feeders</option>\n";
		     }
	     }

	     echo "      <option value='$league_id'";
	     if ($settings['resRestrict']==$league_id) {echo " selected";}
	     echo ">".$leagues[$league_id]['abbr']."</option>\n";

	     $prevLgID=$affLg;
     }

     echo "     </select>\n";
     echo "     </td>\n";
     echo "     </tr></table>\n";
     echo "    </td>\n";


     ## Start New Row
     echo "   </tr>\n";
     echo "   <tr>\n";

     ## Show Age Filter
     echo "    <td>\n";
     echo "     <table cellpadding=2 cellspacing=0 border=0><tr>\n";
     echo "      <td><label><b>Age:<b></label></td>\n";
     echo "      <td><input type='radio' name='ageBool' value='upto' id='upto'";
     if ($settings['ageBool']=='upto') {echo " checked='checked'";}
     echo "></td><td valign=top><label for='upto'>Through</label></td>\n";
     echo "      <td><input type='radio' name='ageBool' value='after' id='after'";
     if ($settings['ageBool']=='after') {echo " checked='checked'";}
     echo "></td><td valign=top><label for='after'>After</label></td>\n";
     echo "      <td><input type='radio' name='ageBool' value='equal' id='equal'";
     if ($settings['ageBool']=='equal') {echo " checked='checked'";}
     echo " onclick=\"document.getElementById('Seasonal').checked=true;\"></td><td valign=top><label for='equal'>Equal</label></td>\n";
     echo "      <td width='80px'>&nbsp;</td>\n";
     echo "      <td>\n";
     echo "       <select name='age'>\n";
     echo "        <option value='All'>All</option>\n";
     for ($i=15;$i<=45;$i++)
      {
        echo "        <option value='$i'";
        if ($i==$settings['age']) {echo " selected";}
        echo ">".$i."</option>\n";
      }
     echo "       </select>\n";
     echo "      </td>\n";
     echo "     </tr></table>\n";
     echo "    </td>\n";

     ## Start New Row
     echo "   </tr>\n";
     echo "   <tr>\n";
     echo "    <td>\n";
     echo "     <table cellpadding=2 cellspacing=0 border=0><tr>\n";

     ## Show Pitching Ratings
     $pitArray=Array("stuff"=>"Stuff","control"=>"Control","movement"=>"Movement");
     echo "    <td valign='top'>\n";
     echo "     <table cellpadding=2 cellspacing=0 border=0>\n";
     echo "      <tr class='title'><td colspan=5>Pitching Ratings</td></tr>\n";
     echo "      <tr class='headline'><td class='hsc2_l'>&nbsp;</td><td class='hsc2_l' colspan=2>Rating</td><td class='hsc2_l' colspan=2>Potential</td></tr>\n";
     foreach ($pitArray as $rat => $lbl)
      {
        echo "      <tr>\n";
	echo "       <td>$lbl</td>\n";
	echo "       <td>\n";
	$name=$rat."RatKey";
	echo "        <select name='$name'>\n";
	echo "         <option value='after'";
	if ($settings[$name]=='after') {echo " selected";}
	echo ">>=</option>\n";
	echo "         <option value='upto'";
	if ($settings[$name]=='upto') {echo " selected";}
	echo "><=</option>\n";
	echo "         <option value='equal'";
	if ($settings[$name]=='equal') {echo " selected";}
	echo ">=</option>\n";
	echo "        </select>\n";
	echo "       </td>\n";
	echo "       <td>\n";
	$name=$rat."Rat";
	echo "        <select name='$name'>\n";
	for ($i=$ratMin;$i<=$ratMax;$i++)
	 {
	   echo "         <option value='$i'";
	   if ($settings[$name]==$i) {echo " selected";}
	   echo ">$i</option>\n";
	 }
	echo "        </select>\n";
	echo "       </td>\n";
	echo "       <td>\n";
	$name=$rat."TalKey";
	echo "        <select name='$name'>\n";
	echo "         <option value='after'";
	if ($settings[$name]=='after') {echo " selected";}
	echo ">>=</option>\n";
	echo "         <option value='upto'";
	if ($settings[$name]=='upto') {echo " selected";}
	echo "><=</option>\n";
	echo "         <option value='equal'";
	if ($settings[$name]=='equal') {echo " selected";}
	echo ">=</option>\n";
	echo "        </select>\n";
	echo "       </td>\n";
	echo "       <td>\n";
	$name=$rat."Tal";
	echo "        <select name='$name'>\n";
	for ($i=$talMin;$i<=$talMax;$i++)
	 {
	   echo "         <option value='$i'";
	   if ($settings[$name]==$i) {echo " selected";}
	   echo ">$i</option>\n";
	 }
	echo "        </select>\n";
	echo "       </td>\n";
	echo "      </tr>\n";
      }
     echo "     </table>\n";
     echo "    </td>\n";

     ## Show Pitch Ratings
     $pitchArray=Array("fastball"=>"Fastball","slider"=>"Slider","curveball"=>"Curveball","screwball"=>"Screwball","forkball"=>"Forkball","changeup"=>"Changeup","Sinker"=>"Sinker","splitter"=>"Splitter","knuckleball"=>"Knuckleball","cutter"=>"Cutter","circlechange"=>"Circle Change","knucklecurve"=>"Knuckle Curve");
     echo "    <td valign='top'>\n";
     echo "     <table cellpadding=2 cellspacing=0 border=0>\n";
     echo "      <tr class='title'><td colspan=5>Pitch Ratings</td></tr>\n";
     echo "      <tr class='headline'><td class='hsc2_l'>&nbsp;</td><td class='hsc2_l' colspan=2>Rating</td><td class='hsc2_l' colspan=2>Potential</td></tr>\n";
     foreach ($pitchArray as $rat => $lbl)
      {
        echo "      <tr>\n";
	echo "       <td>$lbl</td>\n";
	echo "       <td>\n";
	$name=$rat."RatKey";
	echo "        <select name='$name'>\n";
	echo "         <option value='after'";
	if ($settings[$name]=='after') {echo " selected";}
	echo ">>=</option>\n";
	echo "         <option value='upto'";
	if ($settings[$name]=='upto') {echo " selected";}
	echo "><=</option>\n";
	echo "         <option value='equal'";
	if ($settings[$name]=='equal') {echo " selected";}
	echo ">=</option>\n";
	echo "        </select>\n";
	echo "       </td>\n";
	echo "       <td>\n";
	$name=$rat."Rat";
	echo "        <select name='$name'>\n";
	echo "         <option value='0'>None</option>\n";
	for ($i=$ratMin;$i<=$ratMax;$i++)
	 {
	   echo "         <option value='$i'";
	   if ($settings[$name]==$i) {echo " selected";}
	   echo ">$i</option>\n";
	 }
	echo "        </select>\n";
	echo "       </td>\n";
	echo "       <td>\n";
	$name=$rat."TalKey";
	echo "        <select name='$name'>\n";
	echo "         <option value='after'";
	if ($settings[$name]=='after') {echo " selected";}
	echo ">>=</option>\n";
	echo "         <option value='upto'";
	if ($settings[$name]=='upto') {echo " selected";}
	echo "><=</option>\n";
	echo "         <option value='equal'";
	if ($settings[$name]=='equal') {echo " selected";}
	echo ">=</option>\n";
	echo "        </select>\n";
	echo "       </td>\n";
	echo "       <td>\n";
	$name=$rat."Tal";
	echo "        <select name='$name'>\n";
	echo "         <option value='0'>None</option>\n";
	for ($i=$talMin;$i<=$talMax;$i++)
	 {
	   echo "         <option value='$i'";
	   if ($settings[$name]==$i) {echo " selected";}
	   echo ">$i</option>\n";
	 }
	echo "        </select>\n";
	echo "       </td>\n";
	echo "      </tr>\n";
      }
     echo "     </table>\n";
     echo "    </td>\n";


     ## Show Misc Ratings
     echo "    <td valign='top'>\n";
     echo "     <table cellpadding=2 cellspacing=0 border=0>\n";
     echo "      <tr class='title'><td colspan=3>Misc Ratings</td></tr>\n";
     echo "      <tr class='headline'><td class='hsc2_l'>&nbsp;</td><td class='hsc2_l' colspan=2>Rating</td></tr>\n";
     echo "      <tr>\n";
     echo "       <td>Velocity</td>\n";
     echo "       <td>\n";
     $name="velocityKey";
     echo "        <select name='$name'>\n";
     echo "         <option value='after'";
     if ($settings[$name]=='after') {echo " selected";}
     echo ">>=</option>\n";
     echo "         <option value='upto'";
     if ($settings[$name]=='upto') {echo " selected";}
     echo "><=</option>\n";
     echo "         <option value='equal'";
     if ($settings[$name]=='equal') {echo " selected";}
     echo ">=</option>\n";
     echo "        </select>\n";
     echo "       </td>\n";
     echo "       <td>\n";
     $name="velocityRat";
     echo "        <select name='$name'>\n";
     for ($i=1;$i<=20;$i++)
      {
        echo "         <option value='$i'";
	if ($settings[$name]==$i) {echo " selected";}
	echo ">".get_velocity($i)."</option>\n";
      }
     echo "        </select>\n";
     echo "       </td>\n";
     echo "      </tr>\n";
     echo "      <tr>\n";
     echo "       <td>Stamina</td>\n";
     echo "       <td>\n";
     $name="staminaKey";
     echo "        <select name='$name'>\n";
     echo "         <option value='after'";
     if ($settings[$name]=='after') {echo " selected";}
     echo ">>=</option>\n";
     echo "         <option value='upto'";
     if ($settings[$name]=='upto') {echo " selected";}
     echo "><=</option>\n";
     echo "         <option value='equal'";
     if ($settings[$name]=='equal') {echo " selected";}
     echo ">=</option>\n";
     echo "        </select>\n";
     echo "       </td>\n";
     echo "       <td>\n";
     $name="staminaRat";
     echo "        <select name='$name'>\n";
     for ($i=$othMin;$i<=$othMax;$i++)
      {
        echo "         <option value='$i'";
	if ($settings[$name]==$i) {echo " selected";}
	echo ">$i</option>\n";
      }
     echo "        </select>\n";
     echo "       </td>\n";
     echo "      </tr>\n";

     echo "      <tr>\n";
     echo "       <td>Number of Pitches</td>\n";
     echo "       <td>\n";
     $name="pcountKey";
     echo "        <select name='$name'>\n";
     echo "         <option value='after'";
     if ($settings[$name]=='after') {echo " selected";}
     echo ">>=</option>\n";
     echo "         <option value='upto'";
     if ($settings[$name]=='upto') {echo " selected";}
     echo "><=</option>\n";
     echo "         <option value='equal'";
     if ($settings[$name]=='equal') {echo " selected";}
     echo ">=</option>\n";
     echo "        </select>\n";
     echo "       </td>\n";
     echo "       <td>\n";
     $name="pcountRat";
     echo "        <select name='$name'>\n";
     for ($i=1;$i<=12;$i++)
      {
        echo "         <option value='$i'";
        if ($settings[$name]==$i) {echo " selected";}
        echo ">$i</option>\n";
      }
     echo "        </select>\n";
     echo "       </td>\n";
     echo "      </tr>\n";
     echo "      <tr>\n";
     echo "       <td>Ground Ball Pct</td>\n";
     echo "       <td>\n";
     $name="ground_flyKey";
     echo "        <select name='$name'>\n";
     echo "         <option value='after'";
     if ($settings[$name]=='after') {echo " selected";}
     echo ">>=</option>\n";
     echo "         <option value='upto'";
     if ($settings[$name]=='upto') {echo " selected";}
     echo "><=</option>\n";
     echo "         <option value='equal'";
     if ($settings[$name]=='equal') {echo " selected";}
     echo ">=</option>\n";
     echo "        </select>\n";
     echo "       </td>\n";
     echo "       <td>\n";
     $name="ground_flyRat";
     echo "        <select name='$name'>\n";
     for ($i=1;$i<=100;$i++)
      {
        echo "         <option value='$i'";
        if ($settings[$name]==$i) {echo " selected";}
        echo ">$i</option>\n";
      }
     echo "        </select>\n";
     echo "       </td>\n";
     echo "      </tr>\n";
     echo "     </table>\n";
     echo "    </td>\n";



     echo "     </tr></table>\n";
     echo "    </td>\n";
     break;
 }

##### Close Form #####
if ($view!="")
 {
   echo "   </tr>\n";
   echo "   <tr>\n";
   ## Submission button
   echo "    <td><input type='submit' value='Go'></input></td>\n";
 }
echo "   </tr>\n";
echo "  </table>\n";
echo "  </form>\n";
echo " </div>\n";

if (!isset($_POST['view'])) {$view="";}


  $query="";

  switch ($view)
  {
  case 'batters':
	  $ratArray=Array('batting_ratings_overall_contact','batting_ratings_overall_gap','batting_ratings_overall_power','batting_ratings_overall_eye','batting_ratings_overall_strikeouts','batting_ratings_talent_contact','batting_ratings_talent_gap','batting_ratings_talent_power','batting_ratings_talent_eye','batting_ratings_talent_strikeouts');
	  $runArray=Array('running_ratings_speed','running_ratings_stealing','running_ratings_baserunning');
	  $fldArray=Array('fielding_rating_pos2','fielding_rating_pos3','fielding_rating_pos4','fielding_rating_pos5','fielding_rating_pos6','fielding_rating_pos7','fielding_rating_pos8','fielding_rating_pos9','fielding_ratings_catcher_arm','fielding_ratings_infield_arm','fielding_ratings_outfield_arm');

	  $query="SELECT * FROM (SELECT y.*";
	  foreach ($fldArray as $key => $ratLbl)
	  {
		  # Get scale
		  $ratScale=get_scale($ratLbl);
		  $scale=$settings[$ratScale];
		  # Add to query
		  $query.=",";
		  $query.=ratings_query($ratLbl,$scale);
		  $query.=" as $ratLbl";
	  }
	  $query.=" FROM players_fielding";
	  if ($scoutsOn==1) {$query.="_scouted";}
	  $query.=" as pf,(";
	  $query.="SELECT first_name,last_name,age,position,role,team_id,organization_id";
	  if ($scoutsOn!=1)
	  {
		  foreach ($runArray as $key => $ratLbl) {$query.=",$ratLbl";}
	  }
	  $query.=",x.* FROM (";
	  $query.="SELECT player_id,first_name,last_name,team_id,organization_id,position,role,($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age";
	  if ($scoutsOn!=1)
	  {
		  foreach ($runArray as $key => $ratLbl)
		  {
			  # Get scale
			  $ratScale=get_scale($ratLbl);
			  $scale=$settings[$ratScale];
			  # Add to query
			  $query.=",";
			  $query.=ratings_query($ratLbl,$scale);
			  $query.=" as $ratLbl";
		  }
	  }
	  $query.=" FROM players";
	  if ($settings['age']!="All")
	  {
		  $query.=" WHERE ($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01'))";
		  switch ($settings['ageBool'])
		  {
       		  case 'upto' : $query.="<="; break;
		  case 'after': $query.=">="; break;
       		  case 'equal': $query.="=";  break;
		  }
	  	  $query.=$settings['age'];
	  }
	  if ($settings['resRestrict']!='ALL')
	  {
		  if ($settings['age']!="All") {$query.=" AND";} else {$query.=" WHERE";}
		  $query.=" league_id";
		  if ($settings['resRestrict']==-1)
		  {
			  $query.="=0";
		  }
		  elseif (is_numeric($settings['resRestrict']))
		  {
			  $query.="=".$settings['resRestrict'];
		  }
		  else
		  {
			  $e=explode("-",$settings['resRestrict']);
			  $affLg=$e[1];
			  switch ($e[0]) 
			  {
			  case 'Aff':
				  $query.=" IN (".$leagues[$affLg]['lgList'].")";
				  break;
			  case 'Feed':
				  $query.=" IN (".$leagues[$affLg]['lgFeedList'].")";
				  break;
			  }

		  }
	  }
	  $query.=") as p,(";
	  $query.="SELECT player_id";
	  foreach ($ratArray as $key => $ratLbl)
	  {
		  # Get scale
		  $ratScale=get_scale($ratLbl);
		  $scale=$settings[$ratScale];

		  # Add to query
		  $query.=",";
		  $query.=ratings_query($ratLbl,$scale);
		  $query.=" as $ratLbl";
	  }
	  if ($scoutsOn==1)
	  {
		  foreach ($runArray as $key => $ratLbl)
		  {
			  # Get scale
			  $ratScale=get_scale($ratLbl);
			  $scale=$settings[$ratScale];
	
			  # Add to query
			  $query.=",";
			  $query.=ratings_query($ratLbl,$scale);
			  $query.=" as $ratLbl";
		  }
	  }
	  $query.=" FROM players_batting";
	  if ($scoutsOn==1) {$query.="_scouted";}
	  $query.=") as x WHERE p.player_id=x.player_id";
	  foreach ($ratArray as $key => $ratLbl)
	  {
		  # Get scale
		  $ratScale=get_scale($ratLbl);
		  $scale=$settings[$ratScale];

		  $e=explode("_",$ratLbl);
		  $tmp=$e[3];
		  if ($e[2]=='talent') {$tmp=$tmp."Tal";}
		  else {$tmp=$tmp."Rat";}
		  $ratKey=$tmp."Key";

		  if (($ratScale=='Ratings')&&($settings[$ratKey]=='after')&&($ratMin==$settings[$tmp])) {continue;}
		  if (($ratScale=='Ratings')&&($settings[$ratKey]=='upto')&&($ratMax==$settings[$tmp])) {continue;}
		  if (($ratScale=='Talents')&&($settings[$ratKey]=='after')&&($talMin==$settings[$tmp])) {continue;}
		  if (($ratScale=='Talents')&&($settings[$ratKey]=='upto')&&($talMax==$settings[$tmp])) {continue;}
		  if (($ratScale=='Others')&&($settings[$ratKey]=='after')&&($othMin==$settings[$tmp])) {continue;}
		  if (($ratScale=='Others')&&($settings[$ratKey]=='upto')&&($othMax==$settings[$tmp])) {continue;}

		  # Add to query
		  $query.=" AND $ratLbl";
		  switch ($settings[$ratKey])
		  {
		  case 'after': $query.=">="; break;
		  case 'upto' : $query.="<="; break;
		  case 'equal': $query.="=";  break;
		  }
		  $query.=$settings[$tmp];
	  }
	  foreach ($runArray as $key => $ratLbl)
	  {
		  $e=explode("_",$ratLbl);
		  $tmp=$e[2];
		  $ratKey=$tmp."Key";
		  $tmp.="Rat";

		  if (($settings[$ratKey]=='after')&&(($othMin==$settings[$tmp])||($settings[$tmp]==0))) {continue;}
		  if (($settings[$ratKey]=='upto')&&(($othMax==$settings[$tmp])||($settings[$tmp]==0))) {continue;}

		  # Add to query
		  $query.=" AND $ratLbl";
		  switch ($settings[$ratKey])
		  {
		  case 'after': $query.=">="; break;
		  case 'upto' : $query.="<="; break;
		  case 'equal': $query.="=";  break;
		  }
		  $query.=$settings[$tmp];
	  }
	  $query.=") as y WHERE pf.player_id=y.player_id) as yy WHERE 1";
	  foreach ($fldArray as $key => $ratLbl)
	  {
		  # Get scale
		  $ratScale=get_scale($ratLbl);
		  $scale=$settings[$ratScale];

		  $e=explode("_",$ratLbl);
		  $tmp=$e[2];
		  $ratKey=$tmp."Key";
		  $tmp.="Rat";

		  if ($e[3]=='arm')
		  {
			  $tmp=$e[2]."_arm";
			  $ratKey=$tmp."Key";
			  $tmp.="Rat";
		  }

		  if (($settings[$ratKey]=='after')&&(($othMin==$settings[$tmp])||($settings[$tmp]==0))) {continue;}
		  if (($settings[$ratKey]=='upto')&&(($othMax==$settings[$tmp])||($settings[$tmp]==0))) {continue;}

		  # Add to query
		  $query.=" AND $ratLbl";
		  switch ($settings[$ratKey])
		  {
		  case 'after': $query.=">="; break;
		  case 'upto' : $query.="<="; break;
		  case 'equal': $query.="=";  break;
		  }
		  $query.=$settings[$tmp];
	  }
	  $query.=" ORDER BY batting_ratings_".$settings['display']."_contact DESC,batting_ratings_".$settings['display']."_power DESC,batting_ratings_".$settings['display']."_eye DESC,last_name,first_name";
	  break;
  case 'pitchers':
	  $ratArray=Array('pitching_ratings_overall_stuff','pitching_ratings_overall_control','pitching_ratings_overall_movement','pitching_ratings_talent_stuff','pitching_ratings_talent_control','pitching_ratings_talent_movement','pitching_ratings_misc_velocity','pitching_ratings_misc_stamina','pitching_ratings_pitches_fastball','pitching_ratings_pitches_slider','pitching_ratings_pitches_curveball','pitching_ratings_pitches_screwball','pitching_ratings_pitches_forkball','pitching_ratings_pitches_changeup','pitching_ratings_pitches_sinker','pitching_ratings_pitches_splitter','pitching_ratings_pitches_knuckleball','pitching_ratings_pitches_cutter','pitching_ratings_pitches_circlechange','pitching_ratings_pitches_knucklecurve','pitching_ratings_pitches_talent_fastball','pitching_ratings_pitches_talent_slider','pitching_ratings_pitches_talent_curveball','pitching_ratings_pitches_talent_screwball','pitching_ratings_pitches_talent_forkball','pitching_ratings_pitches_talent_changeup','pitching_ratings_pitches_talent_sinker','pitching_ratings_pitches_talent_splitter','pitching_ratings_pitches_talent_knuckleball','pitching_ratings_pitches_talent_cutter','pitching_ratings_pitches_talent_circlechange','pitching_ratings_pitches_talent_knucklecurve','pitching_ratings_misc_ground_fly');

	  $query="SELECT xx.* FROM (";
	  $query.="SELECT first_name,last_name,team_id,organization_id,position,role,age,x.*";
	  if (!((($settings['pcountRat']==1)&&($settings['pcountKey']=="after"))||(($settings['pcountRat']==12)&&($settings['pcountKey']!="upto"))))
	  {
		  $query.=",if(pitching_ratings_pitches_fastball>0,1,0)+if(pitching_ratings_pitches_slider>0,1,0)+if(pitching_ratings_pitches_curveball>0,1,0)+if(pitching_ratings_pitches_screwball>0,1,0)+if(pitching_ratings_pitches_forkball>0,1,0)+if(pitching_ratings_pitches_changeup>0,1,0)+if(pitching_ratings_pitches_sinker>0,1,0)+if(pitching_ratings_pitches_splitter>0,1,0)+if(pitching_ratings_pitches_knuckleball>0,1,0)+if(pitching_ratings_pitches_cutter>0,1,0)+if(pitching_ratings_pitches_circlechange>0,1,0)+if(pitching_ratings_pitches_knucklecurve>0,1,0) as pcount";
	  }
	  $query.=" FROM (SELECT player_id,first_name,last_name,team_id,organization_id,position,role,($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age FROM players";
	  if ($settings['age']!="All")
	  {
		  $query.=" WHERE ($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01'))";
		  switch ($settings['ageBool'])
		  {
       		  case 'upto' : $query.="<="; break;
		  case 'after': $query.=">="; break;
       		  case 'equal': $query.="=";  break;
		  }
	  	  $query.=$settings['age'];
	  }
	  if ($settings['resRestrict']!='ALL')
	  {
		  if ($settings['age']!="All") {$query.=" AND";} else {$query.=" WHERE";}
		  $query.=" league_id";
		  if ($settings['resRestrict']==-1)
		  {
			  $query.="=0";
		  }
		  elseif (is_numeric($settings['resRestrict']))
		  {
			  $query.="=".$settings['resRestrict'];
		  }
		  else
		  {
			  $e=explode("-",$settings['resRestrict']);
			  $affLg=$e[1];
			  switch ($e[0]) 
			  {
			  case 'Aff':
				  $query.=" IN (".$leagues[$affLg]['lgList'].")";
				  break;
			  case 'Feed':
				  $query.=" IN (".$leagues[$affLg]['lgFeedList'].")";
				  break;
			  }
		  }
	  }
	  $query.=") as p,(";
	  $query.="SELECT player_id";
	  foreach ($ratArray as $key => $ratLbl)
	  {
		  # Get scale
		  $ratScale=get_scale($ratLbl);
		  $scale=$settings[$ratScale];

		  # Add to query
		  $query.=",";
		  $query.=ratings_query($ratLbl,$scale);
		  $query.=" as $ratLbl";
	  }
	  $query.=" FROM players_pitching";
	  if ($scoutsOn==1) {$query.="_scouted";}
	  $query.=") as x WHERE p.player_id=x.player_id";
	  foreach ($ratArray as $key => $ratLbl)
	  {
		  # Get scale
		  $ratScale=get_scale($ratLbl);
		  $scale=$settings[$ratScale];

		  $e=explode("_",$ratLbl);
		  switch ($ratLbl)
		  {
		  case 'pitching_ratings_overall_stuff':
 		  case 'pitching_ratings_overall_control':
		  case 'pitching_ratings_overall_movement':
		  case 'pitching_ratings_pitches_fastball':
 		  case 'pitching_ratings_pitches_slider':
		  case 'pitching_ratings_pitches_curveball':
 		  case 'pitching_ratings_pitches_screwball':
		  case 'pitching_ratings_pitches_forkball':
 		  case 'pitching_ratings_pitches_changeup':
		  case 'pitching_ratings_pitches_sinker':
 		  case 'pitching_ratings_pitches_splitter':
		  case 'pitching_ratings_pitches_knuckleball':
 		  case 'pitching_ratings_pitches_cutter':
		  case 'pitching_ratings_pitches_circlechange':
		  case 'pitching_ratings_pitches_knucklecurve':
			  $tmp=$e[3]."Rat";
			  $ratKey=$tmp."Key";
			  break;
		  case 'pitching_ratings_talent_stuff':
 		  case 'pitching_ratings_talent_control':
		  case 'pitching_ratings_talent_movement':
			  $tmp=$e[3]."Tal";
			  $ratKey=$tmp."Key";
			  break;
		  case 'pitching_ratings_pitches_talent_fastball':
 		  case 'pitching_ratings_pitches_talent_slider':
		  case 'pitching_ratings_pitches_talent_curveball':
 		  case 'pitching_ratings_pitches_talent_screwball':
		  case 'pitching_ratings_pitches_talent_forkball':
 		  case 'pitching_ratings_pitches_talent_changeup':
		  case 'pitching_ratings_pitches_talent_sinker':
 		  case 'pitching_ratings_pitches_talent_splitter':
		  case 'pitching_ratings_pitches_talent_knuckleball':
 		  case 'pitching_ratings_pitches_talent_cutter':
		  case 'pitching_ratings_pitches_talent_circlechange':
 		  case 'pitching_ratings_pitches_talent_knucklecurve':
			  $tmp=$e[4]."Tal";
			  $ratKey=$tmp."Key";
			  break;
		  case 'pitching_ratings_misc_stamina':
		  case 'pitching_ratings_misc_velocity':
			  $tmp=$e[3]."Rat";
			  $ratKey=$e[3]."Key";
			  break;
		  case 'pitching_ratings_misc_ground_fly':
			  $tmp="ground_flyRat";
			  $ratKey="ground_flyKey";
			  break;
		  }

		  if ($settings[$tmp]==0) {continue;}
		  if (($ratScale=='Ratings')&&($settings[$ratKey]=='after')&&($ratMin==$settings[$tmp])) {continue;}
		  if (($ratScale=='Ratings')&&($settings[$ratKey]=='upto')&&($ratMax==$settings[$tmp])) {continue;}
		  if (($ratScale=='Talents')&&($settings[$ratKey]=='after')&&($talMin==$settings[$tmp])) {continue;}
		  if (($ratScale=='Talents')&&($settings[$ratKey]=='upto')&&($talMax==$settings[$tmp])) {continue;}
		  if (($ratScale=='Others')&&($settings[$ratKey]=='after')&&($othMin==$settings[$tmp])) {continue;}
		  if (($ratScale=='Others')&&($settings[$ratKey]=='upto')&&($othMax==$settings[$tmp])) {continue;}

		  # Add to query
		  $query.=" AND $ratLbl";
		  switch ($settings[$ratKey])
		  {
		  case 'after': $query.=">="; break;
		  case 'upto' : $query.="<="; break;
		  case 'equal': $query.="=";  break;
		  }
		  $query.=$settings[$tmp];
	  }
	  $query.=") as xx";
	  if (!((($settings['pcountRat']==1)&&($settings['pcountKey']=="after"))||(($settings['pcountRat']==12)&&($settings['pcountKey']!="upto"))))
	  {
		  $query.=" WHERE pcount";
		  switch ($settings['pcountKey'])
		  {
		  case 'after': $query.=">="; break;
		  case 'upto' : $query.="<="; break;
		  case 'equal': $query.="=";  break;
		  }
		  $query.=$settings['pcountRat'];
	  }
	  $query.=" ORDER BY pitching_ratings_".$settings['display']."_stuff DESC,pitching_ratings_".$settings['display']."_control DESC,pitching_ratings_".$settings['display']."_movement DESC,last_name,first_name";
	  break;
  }

  ##### Exit if no query
  if ($query=="")
  {
	  mysqli_close($db);
	
	  ################## END OF PAGE #########################
	  echo " </div>   <!-- END contentpane DIV -->\n";
	  page_foot($_SESSION['lgpath']);
	  exit;
  }


  ## Get Pages
  $cntQuery="SELECT COUNT(DISTINCT player_id) as cnt FROM ($query) as xx";
  if ($_GET['showq']==1) {echo "$cntQuery<br/>\n";}
  $cntResult=mysqli_query($db,$cntQuery);
  $row=mysqli_fetch_array($cntResult);
  $totCnt=$row['cnt'];
  $pgCnt=ceil($totCnt/$pageLimit);

  ## Run Query
  $query.=" LIMIT ".($page*$pageLimit).",$pageLimit";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))
  {
	  # Get Teams
	  $tmQuery="SELECT team_id,t.abbr,level,if(parent_team_id=0,team_id,parent_team_id) as parent_team_id,t.league_id,lg.abbr as lg_abbr FROM teams as t,leagues as lg WHERE t.league_id=lg.league_id AND allstar_team=0";
	  if ($_GET['showq']==1) {echo "$tmQuery<br/>\n";}
	  $tmResult=mysqli_query($db,$tmQuery);
	  if (mysqli_num_rows($tmResult))
	  {
		  while ($tmRow=mysqli_fetch_array($tmResult))
		  {
			  $tid=$tmRow['team_id'];
			  $teams[$tid]['abbr']=$tmRow['abbr'];
			  $teams[$tid]['level_id']=$tmRow['level'];
			  $teams[$tid]['parent_team_id']=$tmRow['parent_team_id'];
			  $teams[$tid]['league_id']=$tmRow['league_id'];
			  $teams[$tid]['lg_abbr']=$tmRow['lg_abbr'];
		  }
	  }

	  # Display Results
	  echo "<div class='textbox' style='width:100%;'>   <!-- open ratings table -->\n";
	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open ratings table -->\n";
	  echo "  <tr class='title2'><td style='text-align:left;'>";
	  if (is_numeric($who)) {echo get_pos($who);}
	  else {echo ucwords($who);}
	  echo " Player Search Results";
	  if ($settings['display']=='talent') {echo " (Potential Ratings)";}
	  else {echo " (Overall Ratings)";}
	  if ($scoutsOn==1) {echo " - Ratings scouted by StatsLab";}
	  echo "</td>\n";
	  if ($pgCnt>1)
	  {
		  echo "   <td style='text-align:right;vertical-align:top;margin-bottom:0px;padding-bottom:0px;'>\n";
		  echo "    <table border=0 cellpadding=0 cellspacing=0 style='float:right;'>\n";
		  echo "     <tr class='title2'><td>Page</td>\n";
		  echo "     <td>\n";
		  echo "      <form action='./playerSearch.php' method='POST'>\n";
		  foreach ($settings as $name => $value)
		  {
			  echo "       <input type='hidden' name='$name' value='$value' >\n";
		  }
		  echo "       <select name='page' onchange='this.form.submit()' style='float:right;clear:none;'>\n";
		  for ($i=0;$i<$pgCnt;$i++)
		  {
			  echo "        <option value='$i'";
			  if ($page==$i) {echo " selected='selected'";}
			  echo ">".($i+1)."</option>\n";
		  }
		  echo "       </select>\n";
		  echo "      </form>\n";
		  echo "     </td>\n";
		  echo "     <td style='text-align:left;'>of $pgCnt</td></tr>\n";
		  echo "    </table>\n";
		  echo "   </td>\n";
	  }
	  else {echo "   <td>&nbsp;</td>\n";}
	  echo "  </tr>\n";
	  echo "  <tr><td colspan=2 style='padding:0px;'>\n";
	  echo "   <table border=0 cellpadding=2 cellspacing=0 width='100%' class='sortable'>\n";
	  echo "    <thead><tr class='headline'>";
	  echo "<td class='hsc2_l'>Player</td>";
	  echo "<td class='hsc2_l'>Tm</td>";
	  if (!is_numeric($settings['resRestrict'])) {echo "<td class='hsc2_l'>Lg</td>";}
	  echo "<td class='hsc2_l'>Lvl</td>";
	  echo "<td class='hsc2'>Age</td>";
	  echo "<td class='hsc2'>Pos</td>";
	  foreach ($ratArray as $key => $ratLbl) 
	  {
		  $e=explode("_",$ratLbl);
		  if (($view=='batters')&&($e[2]!=$settings['display'])) {continue;}
		  elseif (($view=='pitchers')&&($settings['display']=='overall')&&(($e[2]=='talent')||($e[3]=='talent'))) {continue;}
		  elseif (($view=='pitchers')&&($settings['display']=='talent')&&(($e[2]=='overall')||(($e[2]=='pitches')&&($e[3]!='talent')))) {continue;}
		  echo "<td class='hsc2'>".stat_text($ratLbl,2)."</td>";
	  }
	  if ($view=='batters')
	  {
		  foreach ($runArray as $key => $ratLbl) {echo "<td class='hsc2'>".stat_text($ratLbl,2)."</td>";}
		  foreach ($fldArray as $key => $ratLbl) {echo "<td class='hsc2'>".stat_text($ratLbl,2)."</td>";}
	  }
	  echo "</tr></thead>\n";

	  $rowCnt=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $pid=$row['player_id'];
		  $tid=$row['team_id'];
		  $pos=$row['position'];
		  if ($pos==1) {$pos=$row['role'];}

		  $cls='s'.($rowCnt%2+1);

		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' sorttable_customkey='".$row['last_name'].",".$row['first_name']."'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a>";
		  if (isset($players[$pid]['status'])) {echo "<sup>".$players[$pid]['status']."</sup>";}
		  echo"</td>";
		  if ($tid!=0)
		  {
			  $ptid=$teams[$tid]['parent_team_id'];
			  echo "<td class='".$cls."_l' sorttable_customkey='".$teams[$ptid]['abbr'].$teams[$tid]['level_id']."'><a href='".$_SESSION['lgpath']."/teams/team_$tid.html'>".$teams[$tid]['abbr']."</a></td>";
			  if (!is_numeric($settings['resRestrict'])) {echo "<td class='".$cls."_l' sorttable_customkey='".$teams[$tid]['league_id']."'><a href='".$_SESSION['lgpath']."/leagues/league_".$teams[$tid]['league_id']."_home.html'>".$teams[$tid]['lg_abbr']."</a></td>";}
			  echo "<td class='".$cls."_l' sorttable_customkey='";
			  if (isset($players[$pid]['rsv'])) {echo $teams[$tid]['level_id']+0.1;} else {echo $teams[$tid]['level_id']+0.1;}
			  echo "'>".get_level($teams[$tid]['level_id'])."</td>";
		  }
		  else 
		  {
			  echo "<td class='".$cls."_l'>FA</td>\n";
			  if (!is_numeric($settings['resRestrict'])) {echo "<td class='".$cls."_l'>-</td>\n";}
			  echo "<td class='".$cls."_l'>-</td>\n";
		  }
		  echo "<td>".$row['age']."</td>";
		  echo "<td sorttable_customkey='$pos'>".get_pos($pos,1)."</td>";
		  foreach ($ratArray as $key => $ratLbl)
		  {
			  $e=explode("_",$ratLbl);
			  if (($view=='batters')&&($e[2]!=$settings['display'])) {continue;}
			  elseif (($view=='pitchers')&&($settings['display']=='overall')&&(($e[2]=='talent')||($e[3]=='talent'))) {continue;}
			  elseif (($view=='pitchers')&&($settings['display']=='talent')&&(($e[2]=='overall')||(($e[2]=='pitches')&&($e[3]!='talent')))) {continue;}

			  switch ($ratLbl)
			  {
			  case 'pitching_ratings_misc_velocity':
			  case 'pitching_ratings_misc_ground_fly':
				  echo "<td sorttable_customkey='".$row[$ratLbl]."'>".stat_format($ratLbl,$row[$ratLbl])."</td>";
				  break;
			  default:
				  echo "<td>".$row[$ratLbl]."</td>";
				  break;
			  }
		  }
		  if ($view=='batters')
		  {
			  foreach ($runArray as $key => $ratLbl) {echo "<td>".$row[$ratLbl]."</td>";}
			  foreach ($fldArray as $key => $ratLbl) {echo "<td>".$row[$ratLbl]."</td>";}
		  }
		  echo "</tr>\n";
		  $rowCnt++;
	  }

	  echo "   </table>\n";
	  echo "  </td></tr>\n";
	  echo " </table>   <!-- close ratings table -->\n";
	  echo "</div>   <!-- close ratings table -->\n";
  }
  elseif ($view!="")
  {
	  echo "No players match search criteria";
  }
























  mysqli_close($db);

  ################## END OF PAGE #########################
  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);


?>
