<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgpath=$_SESSION['lgpath'];

  $date=new Date($_SESSION['lgdate']);

  $lgyear=$date->format("Y");



  include($_SESSION['adminpath']."/dbopen.php");



  # Get Ratings Config

  $query="SELECT setting,value FROM ootp_sql_admin WHERE scope='ALL' AND setting IN ('Ratings','Talents','Others','scoutsOn','devEnable')";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

	  while ($row=mysqli_fetch_array($result))

	  {

		  $setting=$row['setting'];

		  $settings[$setting]=$row['value'];

	  }

  }

  $title='Player Ratings';

  if (is_numeric($_GET['player_id']))

  {

	  $player_id=$_GET['player_id'];

	  $query="SELECT player_id,position,role,first_name,last_name,organization_id,team_id FROM players WHERE player_id=$player_id";

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  if ($row['position']==1) {$players[$pid]['position']=$row['role'];}

			  else {$players[$pid]['position']=$row['position'];}

			  $players[$pid]['org_id']=$row['organization_id'];

			  $players[$pid]['tid']=$row['team_id'];

			  $players[$pid]['name']=$row['first_name']." ".$row['last_name'];

		  }



		  $query="SELECT team_id,name,nickname,abbr,level FROM teams WHERE team_id=".$players[$pid]['org_id']." OR parent_team_id=".$players[$pid]['org_id'];

		  $result=mysqli_query($db,$query);

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  $teams[$tid]['name']=$row['name']." ".$row['nickname'];

			  $teams[$tid]['name']=$row['abbr'];

			  $teams[$tid]['level']=$row['level'];

		  }

		  $teams[0]['abbr']='FA';

	  }

	  else {$player_id="";}

	  if ($player_id!="")

	  {

		  $title.=" - ".get_pos($players[$player_id]['position'],1)." ".$players[$player_id]['name'];

		  $tid=$players[$player_id]['org_id'];

		  $title.=" (".$teams[$tid]['abbr'].")";

	  }

  }



  mysqli_close($db);





  # Title bar

  page_head($title,$_SESSION['lgpath'],"","","./jquery/excanvas.js|./jquery/jquery.min.js|./jquery/jquery.jqplot.min.js|./jquery/plugins/jqplot.highlighter.min.js|./jquery/plugins/jqplot.cursor.min.js|./jquery/plugins/jqplot.dateAxisRenderer.min.js|./jquery/plugins/jqplot.canvasTextRenderer.min.js|./jquery/plugins/jqplot.canvasAxisLabelRenderer.min.js");

   echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  nav_toolbar('front_office',"Front Office");

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ## Close if unselected

  if ($player_id=="")

  {

	  echo "<p>No player selected</p>\n";

	  ################## END OF PAGE #########################

	  echo " </div>   <!-- END contentpane DIV -->\n";

	  page_foot($_SESSION['lgpath']);

	  exit;

  }



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");



  ## Player Ratings



  ## Primary Ratings Graphs

  $minDate=$_SESSION['lgdate'];



  #Batting Ratings

  $ratArray=Array("contact","gap","power","eye","strikeouts");

  foreach ($ratArray as $key => $ratLbl)

  {

	  $query="SELECT dev_date,rating,old_value,new_value FROM players_development WHERE player_id=$player_id AND rating IN ('batting_ratings_overall_".$ratLbl."','batting_ratings_talent_".$ratLbl."') ORDER BY dev_date,rating";

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $devDt=$row['dev_date'];

			  $rating=$row['rating'];

			  $oldValue=$row['old_value'];

			  $newValue=$row['new_value'];



			  $e=explode("-",$devDt);

			  $prevDay=$e[0]."-".$e[1]."-".($e[2]-1);

			  if ($prevDay<$minDate) {$minDate=$prevDay;}



			  $ratings[$rating][$prevDay]=$oldValue;

			  $ratings[$rating][$devDt]=$newValue;

		  }

		  $scale=get_scale('batting_ratings_overall_'.$ratLbl);

		  $scales['batting_ratings_overall_'.$ratLbl]=$_SESSION[$scale];

		  $scale=get_scale('batting_ratings_talent_'.$ratLbl);

		  $scales['batting_ratings_talent_'.$ratLbl]=$_SESSION[$scale];



		  echo "  <div id='".$ratLbl."_chartdiv' style='height:200px;width:600px;margin-left:auto;margin-right:auto;'></div>\n";



		  echo "  <script class='code' type='text/javascript'>\n";

		  echo "   <!--\n";

		  echo "    $(document).ready(function(){\n";

		  echo "     var line1=[";

		  $cnt=0;

		  $rating='batting_ratings_overall_'.$ratLbl;

		  foreach ($ratings[$rating] as $dvDate => $value) 

		  {

			  if ($cnt>0) {echo ", ";}

			  echo "['$dvDate 0:00am', $value]";

			  $cnt++;

		  }

		  echo "];\n";

		  echo "     var line2=[";

		  $cnt=0;

		  $rating='batting_ratings_talent_'.$ratLbl;

		  foreach ($ratings[$rating] as $dvDate => $value) 

		  {

			  if ($cnt>0) {echo ", ";}

			  echo "['$dvDate 0:00am', $value]";

			  $cnt++;

		  }

		  echo "];\n";

		  echo "     var plot1=$.jqplot('".$ratLbl."_chartdiv', [line1, line2], {\n";

		  echo "       title:'".ucwords($ratLbl)."',\n";

		  echo "       axes: {\n";

		  $e=explode("-",$minDate);

		  $minDate=$e[0]."-".$e[1]."-".($e[2]-1);

		  $e=explode("-",$_SESSION['lgdate']);

		  $maxDate=$e[0]."-".$e[1]."-".($e[2]+1);

		  echo "              xaxis: {renderer:$.jqplot.DateAxisRenderer, tickOptions:{formatString:'%b %#d, %y'}, min:'$minDate 0:00AM', max:'$maxDate 0:00AM', tickInterval: '1 day'},\n";

		  $rating='batting_ratings_overall_'.$ratLbl;

		  $ratScale=$scales[$rating];

		  switch ($scales[$rating])

		  {

		  case 'hidden':

		  case '1-5': $xMin=0; $xMax=6; $xTick=1; break;

		  case '1-10': $xMin=0; $xMax=11; $xTick=2; break;

		  case '1-20': $xMin=0; $xMax=21; $xTick=3; break;

		  case '2-8': $xMin=0; $xMax=10; $xTick=2; break;

		  case '20-80': $xMin=0; $xMax=100; $xTick=20; break;

		  case '1-100': $xMin=0; $xMax=100; $xTick=20; break;

		  }

		  $rating='batting_ratings_talent_'.$ratLbl;

		  $talScale=$scales[$rating];

		  if ($ratScale!=$talScale)

		  {

			  echo "              yaxis: {label: 'Overall', labelRenderer: $.jqplot.CanvasAxisLabelRenderer, min: $xMin, max: $xMax, tickInterval: $xTick}\n";

			  switch ($scales[$rating])

			  {

			  case 'hidden':

			  case '1-5': $xMin=0; $xMax=6; $xTick=1; break;

			  case '1-10': $xMin=0; $xMax=11; $xTick=2; break;

			  case '1-20': $xMin=0; $xMax=21; $xTick=3; break;

			  case '2-8': $xMin=0; $xMax=10; $xTick=2; break;

			  case '20-80': $xMin=0; $xMax=100; $xTick=20; break;

			  case '1-100': $xMin=0; $xMax=100; $xTick=20; break;

			  }

			  echo "             ,y2axis: {label: 'Potential', labelRenderer: $.jqplot.CanvasAxisLabelRenderer, min: $xMin, max: $xMax, tickInterval: $xTick, tickOptions: {showGridline: false} }\n";

		  }

		  else

		  {

			  echo "              yaxis: {min: $xMin, max: $xMax, tickInterval: $xTick}\n";

		  }

		  echo "         },\n";

		  echo "       series: [\n";

		  echo "            {label: 'Overall', showLabel: true}";

		  echo "           ,{label: 'Potential', showLabel: true";

		  if ($ratScale!=$talScale) {echo ", yaxis: 'y2axis'";}

		  echo "}";

		  echo "         ],\n";

		  echo "       highlighter: {show: true},\n";

		  echo "       cursor: {show: true, zoom: true, tooltipLocation:'sw'},\n";

		  echo "       legend: { show:true, location: 'e', placement: 'outsideGrid' }\n";

		  echo "     });\n";

		  echo "    });\n";

		  echo "   -->\n";

		  echo "  </script>\n";

	  }

  }



  #Stuff

  #Movement

  #Control



  #Pitches



  ## Full development history



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);





?>

