<?php
  include("html_functions.php");

  ################## PAGE INITIALIZATION #########################
  $lgid=$_SESSION['lgid'];
  $pid=$_GET['player_id'];
  if (!is_numeric($pid)) {$pid="";}

  $lgpath=$_SESSION['lgpath'];
  $lgyear=$_SESSION['lgyear'];

  if ($pid!="") 
  {
	  include($_SESSION['adminpath']."/dbopen.php");

	  ## Get team info
	  $query="SELECT * FROM (SELECT t.team_id,t.year,name,nickname,abbr,level_id FROM team_history as t,team_history_pitching_stats as ths WHERE t.team_id=ths.team_id AND t.year=ths.year UNION SELECT team_id,'$lgyear' as year,name,nickname,abbr,level as level_id FROM teams WHERE allstar_team=0) as t GROUP BY team_id,year ORDER BY team_id,year";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  if (mysqli_num_rows($result))
	  {
		  $prevTid=-1;
		  while ($row=mysqli_fetch_array($result))
		  {
			  $tid=$row['team_id'];
			  $yr=$row['year'];
			  $teams[$tid][$yr]['level_id']=$row['level_id'];
			  $teams[$tid][$yr]['name']=$row['name']." ".$row['nickname'];
			  $teams[$tid][$yr]['abbr']=$row['abbr'];
			  if ($prevTid!=$tid) {$teams[$tid]['ingname']=$row['name']." ".$row['nickname'];}
			  $prevTid=$tid;
		  }
	  }

	  ## Get player info
	  $query="SELECT first_name,last_name,nick_name,date_of_birth,($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as ageNow,uniform_number,weight,height,bats,throws,draft_year,draft_round,draft_supplemental,draft_pick,draft_team_id,retired,team_id,organization_id,hall_of_fame,inducted,injury_is_injured,injury_dtd_injury,injury_dl_left,injury_left,dtd_injury_effect FROM players as p WHERE player_id=$pid;";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  if (mysqli_num_rows($result)==0) {$pid="";$title='Player Page';}
      	  else
	  {
	    	  $row=mysqli_fetch_array($result);
		  $name=$row['first_name']." ".$row['last_name'];
	    	  $uni=$row['uniform_number'];
		  $bday=new Date($row['date_of_birth']);
		  $ageNow=$row['ageNow'];
	    	  $title="Player Report for #$uni $name";
		  $nickname=$row['nick_name'];
	    	  $height=$row['height'];
		  $weight=$row['weight'];
	    	  $bats=$row['bats'];
		  $throws=$row['throws'];
	    	  $retired=$row['retired'];
		  $pTmID=$row['team_id'];
	    	  $pOrgID=$row['organization_id'];
		  $dateOfBirth=new Date($row['date_of_birth']);
	    	  $draft_year=$row['draft_year'];
		  if ($draft_year==0) {$draft_year='inaugural';}
		  $draft_round=$row['draft_round'];
		  $draft_supp=$row['draft_supplemental'];
		  $draft_pick=$row['draft_pick'];
	    	  $draft_team_id=$row['draft_team_id'];
		  $hof=$row['hall_of_fame'];
	    	  $inducted=$row['inducted'];
		
		  $pstatus='Free Agent';
  		  if ($pOrgID!=0)
		  {
  			  $pstatus="Currently with <a href='$lgpath/teams/team_$pTmID.html'>".$teams[$pTmID][$lgyear]['name']."</a>";
			  if (($teams[$pTmID][$lgyear]['level_id']!=1)&&($teams[$pTmID][$lgyear]['level_id']!=8))
  			  {
				  $pstatus.=" (<a href='$lgpath/teams/team_$pOrgID.html'>".$teams[$pOrgID][$lgyear]['abbr']."</a> ".get_level($teams[$pTmID][$lgyear]['level_id']).")";
  			  }
		  }
	
		  ## Get Roster Status
		  $query="SELECT player_id,is_active,is_on_secondary,is_on_dl,is_on_dl60 FROM players_roster_status WHERE player_id=$pid";
		  if ($_GET['showq']==1) {echo "$query<br/>\n";}
		  $result=mysqli_query($db,$query);
		  $sRow=mysqli_fetch_array($result);

		  if ($row['injury_is_injured']==1)
		  {
  			  $pstatus.=" <span style='float:right;color:#AA0000;'>";
			  $pstatus.="<b>INJ:</b> ";
  			  if ($row['injury_dtd_injury']==1)
			  {
  				  $pstatus.="DTD: ";
				  $pstatus.=(100-$row['dtd_injury_effect'])."% ";
  			  }
			  else {$pstatus.="Out: ";}
			  if ($sRow['is_on_dl']==1)
			  {
				  if ($row['injury_dl_left']>0) {$pstatus.=$row['injury_dl_left'];} else {$pstatus.="0";}
				  $pstatus.=" day";
				  if ($row['injury_dl_left']!=1) {$pstatus.="s";}
				  $pstatus.=" remaining on ";
				  if ($sRow['is_on_dl60']==1) {$pstatus.="60-day ";}
				  $pstatus.="DL";
			  }
			  else {$pstatus.="Not on DL";}
			  $pstatus.=", ".$row['injury_left']." day";
			  if ($row['injury_left']!=1) {$pstatus.="s";}
			  $pstatus.=" remaining injured";
  			  $pstatus.="</span>";
		  }
  		  if ($retired==1) {$pstatus='Retired';}
	  }

	  mysqli_close($db);
  }
  else {$title='Player Page';}

  # Title Bar
  page_head($title,$_SESSION['lgpath']);
  echo " <div id='topbar'>\n";
  main_titlebar($lgid,$_SESSION['lgpath'],$title);
  nav_toolbar("history","History");
  nav_toolbar("players");
  echo " </div>   <!-- END topbar DIV -->\n";
  echo " <div id='contentpane'>\n";

  if ($pid=="")
  {
	  echo "Please select a player";
	  echo " </div>   <!-- END contentpane DIV -->\n";
	  page_foot($_SESSION['lgpath']);
	  exit;
  }

  ################## START OF PAGE CONTENT #########################
  include($_SESSION['adminpath']."/dbopen.php");

  ##### Get Average Games Played Per Team
  $query="SELECT ROUND(AVG(gCnt)) as g FROM (SELECT t1.team_id,t1.gCnt+t2.gCnt as gCnt FROM (SELECT home_team as team_id,COUNT(DISTINCT game_id) as gCnt FROM games WHERE league_id=$lgid AND game_type=0 GROUP BY home_team) as t1,(SELECT away_team as team_id,COUNT(DISTINCT game_id) as gCnt FROM games WHERE league_id=$lgid AND game_type=0 GROUP BY away_team) as t2 WHERE t1.team_id=t2.team_id GROUP BY team_id) as x";
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  $row=mysqli_fetch_array($result);
	  $avgG=$row['g'];
  }
  else {$avgG=162;}

  ##### Get Minimum Career PT For Rank Inclusion
  $query="SELECT year,SUM(g)/COUNT(DISTINCT team_id) as avgG FROM team_history_record WHERE league_id=$lgid AND year>=($year-10) GROUP BY year ORDER BY year;";
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  $tgame=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $yr=$row['year'];
		  $g=$row['avgG'];
		  $tgame+=$g;
	  }
	  $minCarPA=min(ceil(3.1*$tgame),2000);
	  $minCarPA=floor($minCarPA);
	  $minCarIP=min(1.0*$tgame,1000);
	  $minCarIP=floor($minCarIP);
  }
  else
  {
	  $minCarPA=1999;
	  $minCarIP=999;
  }


  ##### Player Demographics
  echo "<div class='textbox'>   <!-- open player demographics -->\n";
  echo " <table cellpadding=2 cellspacing=0 border=0 width='935px'>   <!-- open player demographics -->\n";
  echo "  <tr class='title'><td colspan=5>Player Demographics</td></tr>\n";
  echo "  <tr class='s2'><td rowspan=6 width='94px'>";
  $htmlpath=$_SESSION['htmlroot'].$_SESSION['htmlpath'];
  $imgpath=$lgpath."/images/person_pictures/player_".$pid.".png";            ## Check for photo by player ID
  $ch = curl_init($imgpath);
  curl_setopt($ch, CURLOPT_NOBODY, true);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_FILETIME, true); 
  curl_exec($ch);
  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
  if ($retcode==200) {echo "<img src='$imgpath'>";}
  else
  {
	  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".png";   ## Check for capitalized name PNG
	  $ch = curl_init($imgpath);
	  curl_setopt($ch, CURLOPT_NOBODY, true);
	  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	  curl_setopt($ch, CURLOPT_FILETIME, true); 
	  curl_exec($ch);
	  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
	  if ($retcode==200) {echo "<img src='$imgpath'>";}
	  else
	  {
		  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".png";   ## Check for lowercase name PNG
		  $ch = curl_init($imgpath);
		  curl_setopt($ch, CURLOPT_NOBODY, true);
		  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		  curl_setopt($ch, CURLOPT_FILETIME, true); 
		  curl_exec($ch);
		  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
		  if ($retcode==200) {echo "<img src='$imgpath'>";}
		  else
		  {
			  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".jpg";   ## Check for capitalized name JPG
			  $ch = curl_init($imgpath);
			  curl_setopt($ch, CURLOPT_NOBODY, true);
			  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			  curl_setopt($ch, CURLOPT_FILETIME, true); 
			  curl_exec($ch);
			  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
			  if ($retcode==200) {echo "<img src='$imgpath'>";}
			  else
			  {
				  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".jpg";   ## Check for lowercase name JPG
				  $ch = curl_init($imgpath);
				  curl_setopt($ch, CURLOPT_NOBODY, true);
				  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				  curl_setopt($ch, CURLOPT_FILETIME, true); 
				  curl_exec($ch);
				  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
				  if ($retcode==200) {echo "<img src='$imgpath'>";}
				  else
				  {
					  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".bmp";   ## Check for capitalized name BMP
					  $ch = curl_init($imgpath);
					  curl_setopt($ch, CURLOPT_NOBODY, true);
					  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					  curl_setopt($ch, CURLOPT_FILETIME, true); 
					  curl_exec($ch);
					  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
					  if ($retcode==200) {echo "<img src='$imgpath'>";}
					  else
					  {
						  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".bmp";   ## Check for lowercase name bmp
						  $ch = curl_init($imgpath);
						  curl_setopt($ch, CURLOPT_NOBODY, true);
						  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
						  curl_setopt($ch, CURLOPT_FILETIME, true); 
						  curl_exec($ch);
						  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
						  if ($retcode==200) {echo "<img src='$imgpath'>";}
						  else
						  {
							  echo "<img src='$lgpath/images/person_pictures/default_player_photo.png'>";   ## Show default
						  }
					  }
				  }
			  }
		  }
	  }
  }
  echo "</td><td><b>Name:</b></td><td class='s2_l' width='500px'><a href='$lgpath/players/player_$pid.html'>$name</a></td><td><b>Height:</b></td><td class='s2_l'>".cm_to_ft_in($height)."</td></tr>\n";
  echo "  <tr class='s1'><td><b>Nickname:</b></td><td class='s1_l'>$nickname</td><td><b>Weight:</b></td><td class='s1_l'>$weight lbs</td></tr>\n";
  echo "  <tr class='s2'><td><b>Date of Birth:</b></td><td class='s2_l'>".$dateOfBirth->format("F j, Y")."</td><td><b>Bats:</b></td><td class='s2_l'>".get_hand($bats)."</td></tr>\n";
  echo "  <tr class='s1'><td><b>Drafted:</b></td><td class='s1_l'>";
  if ($draft_team_id==0) {echo "&nbsp;";}
  else
  {
	  echo "Drafted by the ";
       	  if ($draft_year==0) {echo $teams[$draft_team_id]['ingname'];} else {echo $teams[$draft_team_id][$draft_year]['name'];}
	  echo " with the ".ordinal_suffix($draft_pick,1)." pick in the ";
	  if ($draft_supp==1) {echo "Supplemental ";}
	  echo ordinal_suffix($draft_round,1)." round of the ";
       	  if ($draft_year==0) {echo "<a href='./draft_history.php?year=inaug'>inaugural ";} else {echo "<a href='./draft_history.php?year=$draft_year'>$draft_year";}
	  echo " draft</a>";
  }
  echo "</td><td><b>Throws:</b></td><td class='s1_l'>".get_hand($throws)."</td></tr>\n";
  echo "  <tr class='s2'><td><b>Current Status:</b></td><td class='s2_l' colspan=3>".$pstatus."</td></tr>\n";
  ## Get enabled pages
  $query="SHOW TABLES LIKE 'ootp_sql_admin';";
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result)) 
  {
       	  $query="SELECT setting,MAX(value) as value FROM ootp_sql_admin WHERE scope IN ('ALL',$lgid) AND (setting LIKE '%nable' OR setting='addDisable') GROUP BY setting;";
	  $result=mysqli_query($db,$query);
       	  if (mysqli_num_rows($result)) 
	  {
	    	  while ($row=mysqli_fetch_array($result))
		  {
		 	  $field=$row['setting'];
			  $val=$row['value'];
		 	  $val=stripslashes($val);
			  switch ($field)
			  {
			  case 'devEnable' : $devEnable=$val;     break;
			  case 'tbEnable'  : $tbEnable=$val;      break;
	      		  case 'addDisable': $addDisable=$val;    break;
			  case 'finEnable' : $finEnable=$val;     break;
			  }
		  }
      	  }
  }
  echo "  <tr class='s1'><td><b>Links:</b></td><td class='s1_l'>";
  if ($devEnable==1) {echo "<a href='./development.php?player_id=$pid'>Development History</a>";}
  $query="SELECT player_id FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND year=$lgyear UNION SELECT player_id FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND year=$lgyear;";
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
       	  if ($devEnable==1) {echo ", ";}
	  echo "<a href='./playerStats.php?player_id=$pid&scope=Season'>$lgyear Game Logs</a>";
       	  $played=1;
  }
  if (($retired!=1)&&($finEnable==1))
  {
	  if (($devEnable==1)||($played==1)) {echo ", ";}
       	  echo "<a href='./payroll.php?player=$pid'>Contract Info</a>";
	  $ctrct=1;
  }
  if (($retired!=1)&&($tbEnable==1)&&($pOrgID==$_SESSION['user_organization_id']))
  {
	  $query="SELECT trade_status FROM players_roster_status WHERE player_id=$pid;";
       	  $result=mysqli_query($db,$query);
	  $row=mysqli_fetch_array($result);
       	  $tstatus=$row['trade_status'];

	  if ($tstatus==2)
      	  {
		  if (($devEnable==1)||($played==1)||($ctrct==1)) {echo ", ";}
	    	  echo "<a href='./tradeBlockAdmin.php?player=$pid'>Configure Trade Block</a>";
		  echo " (<a href='./tradeBlockAdmin.php?player=$pid&remove=1'";
	    	  if ($addDisable==1) {echo " onclick=\"return confirm('Are you sure you\\'d like to remove ".str_replace("\'","\\'",addslashes($name))." from the trade block?\\nThis action cannot be undone until the next sim.')\"";}
		  echo">Remove</a>)";
      	  }
	  elseif ($addDisable!=1)
      	  {
		  if (($devEnable==1)||($played==1)||($ctrct==1)) {echo ", ";}
	    	  echo "<a href='./tradeBlockAdmin.php?player=$pid'>Add to Trade Block</a>";
	  }
  }
  echo "</td><td>&nbsp;</td><td>&nbsp;</td></tr>\n";
  echo " </table>   <!-- close player demographics -->\n";
  echo "</div>   <!-- close player demographics -->\n";

  ##### Player Awards
  $query="(SELECT pa.team_id,award_id,lh.year,position,month,award_id as sort_id FROM league_history as lh,players_awards as pa WHERE best_pitcher_id=pa.player_id AND pa.player_id=$pid AND award_id=4 AND lh.league_id=$lgid AND lh.year=pa.season)";
  $query.=" UNION (SELECT pa.team_id,award_id,lh.year,position,month,award_id as sort_id FROM league_history as lh,players_awards as pa WHERE best_hitter_id=pa.player_id AND pa.player_id=$pid AND award_id=5 AND lh.league_id=$lgid AND lh.year=pa.season)";
  $query.=" UNION (SELECT pa.team_id,award_id,lh.year,position,month,award_id as sort_id FROM league_history as lh,players_awards as pa WHERE best_rookie_id=pa.player_id AND pa.player_id=$pid AND award_id=6 AND lh.league_id=$lgid AND lh.year=pa.season)";
  $query.=" UNION (SELECT team_id,award_id,season as year,position,month,award_id as sort_id FROM players_awards WHERE player_id=$pid AND award_id IN (7,9,11,13,15) AND league_id=$lgid)";
  $query.=" UNION (SELECT team_id,award_id,year,position,if(day>1,month+1,month) as month,(20+award_id) as sort_id FROM players_awards WHERE player_id=$pid AND award_id IN (1,2,3) AND league_id=$lgid)";
  $query.=" ORDER BY sort_id,year,month";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result)>0)
  {
	  ## Get Award Names
	  $awQuery="SELECT mvp_award_name,pitcher_award_name,rookie_award_name,defense_award_name FROM leagues WHERE league_id=$lgid;";
	  $awResult=mysqli_query($db,$awQuery);
	  $row=mysqli_fetch_array($awResult);
	  for ($i=1;$i<=3;$i++) {$awardName[$i]=get_award($i);}
	  $awardName[5]=$row['mvp_award_name'];
	  $awardName[4]=$row['pitcher_award_name'];
	  $awardName[6]=$row['rookie_award_name'];
	  $awardName[7]=$row['defense_award_name'];

	  echo "<div class='textbox'>   <!-- open Awards -->\n";
	  echo " <table cellpadding=2 cellspacing=0 border=0 style='width:935px;'>   <!-- open Awards -->\n";
	  echo "  <tr class='title'><td colspan=3>Honors and Awards</td></tr>\n";
	  echo "  <tr class='headline'><td class='hsc2_l'>Award</td><td class='hsc2_l'>Years</td><td class='hsc2'>Times Won</td></tr>\n";
	  if ($hof==1)
      	  {
	    	  echo "  <tr class='s2_l'><td>Hall of Fame</td><td colspan=2>$inducted</td></tr>\n";
	  }
	  $prevAwID=-1;
	  $rowCnt=-1;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $awID=$row['award_id'];
		  $yr=$row['year'];
		  $pos=$row['position'];
		  $tid=$row['team_id'];

		  if (!isset($awardName[$awID])) {$awardName[$awID]=get_award($awID);}

		  if ($awID!=$prevAwID)
		  {
			  if ($rowCnt>=0)
			  {
				  echo "</td>";
				  echo "<td>".$awCnt[$prevAwID]."</td>";
				  echo "</tr>\n";
			  }

			  $rowCnt++;
			  $cls='s'.($rowCnt%2+1);
			  echo "  <tr class='$cls'>";
			  echo "<td class='".$cls."_l'>".$awardName[$awID]."</td>";
			  echo "<td class='".$cls."_l'>";
		  }
		  else {echo ", ";}

		  if ($awID<4) {echo ($row['month']-1)."/".substr($yr,2);}
		  else {echo $yr;}

		  if ($awID==7)
		  {
			  $award[$awID][$yr][$tid][$pos]=1;
			  $award[$awID]['pos'][$pos]=$award[$awID]['pos'][$pos]+1;
		  }
		  elseif ($awID>=4)
		  {
			  $award[$awID][$yr][$tid]=1;
			  $award[$awID]['team'][$tid]=$award[$awID]['team'][$tid]+1;
		  }
	
		  $awCnt[$awID]=$awCnt[$awID]+1;
		  $prevAwID=$awID;
	  }
	  echo "</td>";
	  echo "<td>".$awCnt[$prevAwID]."</td>";
	  echo "</tr>\n";
	  echo " </table>   <!-- close Awards -->\n";
	  echo "</div>   <!-- close Awards -->\n";
  }
  elseif ($hof==1)
  {
	  echo "<div class='textbox'>   <!-- open Awards -->\n";
	  echo " <table cellpadding=2 cellspacing=0 border=0 style='width:935px;'>   <!-- open Awards -->\n";
	  echo "  <tr class='title'><td colspan=3>Honors and Awards</td></tr>\n";
	  echo "  <tr class='headline'><td class='hsc2_l'>Award</td><td class='hsc2_l'>Years</td><td class='hsc2'>Times Won</td></tr>\n";
	  if ($hof==1)
      	  {
	    	  echo "  <tr class='s2_l'><td>Hall of Fame</td><td colspan=2>$inducted</td></tr>\n";
	  }
	  echo " </table>   <!-- close Awards -->\n";
	  echo "</div>   <!-- close Awards -->\n";
  }


  ##### Get League Leader Stats #####
  $query="SELECT year,category FROM players_league_leader WHERE player_id=$pid AND league_id=$lgid AND place=1 ORDER BY category, year;";
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  while ($row=mysqli_fetch_array($result))
      	  {	   
		  $yr=$row['year'];
	    	  $cat=$row['category'];
		  $catName=get_ll_cat($cat,1);
	    	  if ($cat>26) {$catType='p';} else {$catType='b';}
		  $ll[$yr][$catType][$catName]=1;
      	  }
  }

  ##### Check for win shares
  $query="SHOW TABLES LIKE 'players_win_shares';";
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result)) {$showWS=1;} else {$showWS=0;}

  ##### Get team completion percentage
  $calcProj=0;
  $query="SELECT played,COUNT(DISTINCT game_id) as gm FROM games WHERE (home_team=$pTmID OR away_team=$pTmID) AND game_type=0 GROUP BY played";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result)>0)
  {
	  while ($row=mysqli_fetch_array($result))
	  {
		  $ply=$row['played'];
		  $gmPlayed[$ply]=$row['gm'];
	  }
	  $totTmGm=$gmPlayed[1]+$gmPlayed[0];
	  if ($gmPlayed[0]==0) {$seaCompPct=1;} else {$seaCompPct=$gmPlayed[1]/$totTmGm;}
  }
  else {$seaCompPct=0;}
  if ($_GET['showq']==1) {echo "\$seaCompPct==$seaCompPct;<br/>\n";}

  ##### Pitching Stats
  $statArray=Array("g","gs","w","l","s","era","ip","ha","r","er","hra","bb","k","hp","hld","cg","sho","whip","babip","war","erc","fip");
  $query="";
  if ($showWS==1) {$query="SELECT y.*,pws FROM (";}
  $query.="SELECT year,team_id,stint";
  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
  $query.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 GROUP BY year,team_id";
  if ($showWS==1) {$query.=") as y LEFT JOIN (SELECT year,team_id,SUM(pws) as pws FROM players_win_shares WHERE player_id=$pid GROUP BY year,team_id) as pwsTBL ON y.year=pwsTBL.year AND y.team_id=pwsTBL.team_id";}
  $query.=" ORDER BY year,stint";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result)>0)
  {
	  ## Get ERA+
	  $query="SELECT y1.player_id,y1.team_id,y1.year,y1.ip,y1.era,y2.sub_league_id,y2.rpf,y2.lgERA,if(((y1.ip=0) OR (y1.era=0)),0,100*rpf*y2.lgERA/y1.era) as eraPlus,rpfAdj FROM (SELECT player_id,team_id,year,SUM(ip)+SUM(ipf)/3 as ip,if(SUM(ip)+SUM(ipf)/3=0,0,9*SUM(er)/(SUM(ip)+SUM(ipf)/3)) as era FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND player_id=$pid GROUP BY player_id,team_id,year ORDER BY player_id,year,team_id) as y1,(SELECT t1.team_id,lg1.sub_league_id,t1.year,if(rpf IS NULL,1,rpf) as rpf,if(rpf IS NULL,0,1) as rpfAdj,era as lgERA FROM (SELECT t.team_id,t.year,sub_league_id,rpf FROM team_history as t LEFT JOIN park_factors as pf ON t.team_id=pf.team_id AND t.league_id=pf.league_id AND t.year=pf.year WHERE t.league_id=$lgid UNION SELECT t.team_id,'$lgyear' as year,sub_league_id,rpf FROM teams as t LEFT JOIN park_factors as pf ON t.team_id=pf.team_id AND t.league_id=pf.league_id WHERE t.league_id=$lgid AND pf.year=$lgyear) as t1,(SELECT sub_league_id,year,if(SUM(ip)+SUM(ipf)/3=0,0,9*SUM(er)/(SUM(ip)+SUM(ipf)/3)) as era FROM team_history_pitching_stats WHERE league_id=$lgid GROUP BY sub_league_id,year UNION SELECT tr.sub_league_id,'$lgyear' as year,if(SUM(ip)+SUM(ipf)/3=0,0,9*SUM(er)/(SUM(ip)+SUM(ipf)/3)) as era FROM team_pitching_stats as tps,team_relations as tr WHERE tps.team_id=tr.team_id AND tps.league_id=$lgid GROUP BY sub_league_id) as lg1 WHERE t1.sub_league_id=lg1.sub_league_id AND t1.year=lg1.year) as y2 WHERE y1.team_id=y2.team_id AND y1.year=y2.year";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $eraResult=mysqli_query($db,$query);
	  while ($eraRow=mysqli_fetch_array($eraResult))
	  {
		  $tid=$eraRow['team_id'];
		  $yr=$eraRow['year'];
		  $ip=$eraRow['ip'];
		  $eraPlus=$eraRow['eraPlus'];
		  $product=$ip*$eraPlus;

		  $pERAplus[$tid][$yr]['eraPlus']=round($eraPlus);

		  # Get team ERA+
		  if (isset($tmERAplus[$tid]['product']))
		  {
			  $tmERAplus[$tid]['product']+=$product;
			  $tmERAplus[$tid]['ip']+=$ip;
		  }
		  else 
		  {
			  $tmERAplus[$tid]['product']=$product;
			  $tmERAplus[$tid]['ip']=$ip;
		  }
		  if ($tmERAplus[$tid]['ip']==0) {$tmERAplus[$tid]['eraPlus']=0;}
		  else {$tmERAplus[$tid]['eraPlus']=round($tmERAplus[$tid]['product']/$tmERAplus[$tid]['ip']);}

		  # Get year ERA+
		  if (isset($yrERAplus[$yr]['product']))
		  {
			  $yrERAplus[$yr]['product']+=$product;
			  $yrERAplus[$yr]['ip']+=$ip;
		  }
		  else 
		  {
			  $yrERAplus[$yr]['product']=$product;
			  $yrERAplus[$yr]['ip']=$ip;
		  }
		  if ($yrERAplus[$yr]['ip']==0) {$yrERAplus[$yr]['eraPlus']=0;}
		  else {$yrERAplus[$yr]['eraPlus']=round($yrERAplus[$yr]['product']/$yrERAplus[$yr]['ip']);}

		  # Get career ERA+
		  if (isset($ERAplus['product']))
		  {
			  $ERAplus['product']+=$product;
			  $ERAplus['ip']+=$ip;
		  }
		  else 
		  {
			  $ERAplus['product']=$product;
			  $ERAplus['ip']=$ip;
		  }
		  if ($ERAplus['ip']==0) {$ERAplus['eraPlus']=0;}
		  else {$ERAplus['eraPlus']=round($ERAplus['product']/$ERAplus['ip']);}
	  }

	  ## Display Pitching Stats
	  echo "<div class='textbox'>   <!-- open pitching stats -->\n";
	  echo " <table cellpadding=0 cellspacing=0 border=0>   <!-- open pitching stats -->\n";
	  echo "  <tr class='title'><td style='padding:2px;'>Pitching Stats</td></tr>\n";
	  echo "  <tr><td>\n";
	  echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' style='width:935px;'>\n";
	  echo "    <thead><tr class='headline'><td class='hsc2_l'>Year/Team</td><td class='hsc2'>Age</td>";
	  foreach ($statArray as $key => $statLbl) {echo "<td class='hsc2' title='".stat_text($statLbl)."'>".stat_text($statLbl,2)."</td>";}
	  echo "<td class='hsc2'>ERA+</td>";
	  if ($showWS==1) {echo "<td class='hsc2' title='Pitching Win Shares'>WS</td>";}
	  echo "</tr></thead>\n";
	  $rowCnt=0;
	  $prevYr=-1;
	  $multiRow=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $yr=$row['year'];
		  $tid=$row['team_id'];

		  if (($yr==$lgyear)&&($row['g']>0)&&($seaCompPct>0)&&($seaCompPct<1)) {$calcProj=1;}
	
		  if (($multiRow==1)&&($yr!=$prevYr))
		  {
			  $yrQuery="";
			  if ($showWS==1) {$yrQuery="SELECT y.*,pws FROM (";}
			  $yrQuery.="SELECT year";
			  foreach ($statArray as $key => $statLbl) {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
			  $yrQuery.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 AND year=$prevYr GROUP BY year";
			  if ($showWS==1) {$yrQuery.=") as y LEFT JOIN (SELECT year,SUM(pws) as pws FROM players_win_shares WHERE player_id=$pid AND year=$prevYr GROUP BY year) as pwsTBL ON y.year=pwsTBL.year";}
			  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
			  $yrResult=mysqli_query($db,$yrQuery);
			  $yrRow=mysqli_fetch_array($yrResult);

			  $cls='s';
			  if ((isset($award[4][$prevYr]))||(isset($award[6][$prevYr]))) {$cls='b';}
			  $cls.=($rowCnt%2+1);
			  echo "    <tr class='$cls'>";
			  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - Tot";
			  if (isset($award[9][$prevYr])) {echo " (AS)";}
			  echo "</td>\n";
			  echo "<td>$age</td>\n";
			  foreach ($statArray as $key => $statLbl) 
			  {
				  echo "<td";
				  if ($ll[$prevYr]['p'][$statLbl]==1) {echo " style='text-decoration:underline;'";}
				  echo ">".stat_format($statLbl,$yrRow[$statLbl])."</td>";
			  }
			  echo "<td>".$yrERAplus[$prevYr]['eraPlus']."</td>";
			  if ($showWS==1) 
			  {
				  echo "<td>";
				  if ($yrRow['pws']=="") {echo '&nbsp;';} else {echo stat_format('pws',$yrRow['pws']);}
				  echo "</td>";
			  }
			  echo "</tr>\n";

			  $rowCnt++;
			  $multiRow=0;
		  }
		  elseif ($yr==$prevYr) {$multiRow=1;}

		  unset($yrDate);
	    	  $age=$ageNow+$yr-$lgyear;

		  $cls='s';
		  if ((isset($award[4][$yr][$tid]))||(isset($award[6][$yr][$tid]))) {$cls='b';}
		  $cls.=($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'><a href='./team_summary.php?team_id=$tid&year=$yr'>$yr - ".$teams[$tid][$yr]['abbr']."</a>";
		  if (isset($award[9][$yr][$tid])) {echo " (AS)";}
		  echo "</td>\n";
		  echo "<td>$age</td>\n";
		  foreach ($statArray as $key => $statLbl)
		  {
			  echo "<td";
			  if ($ll[$yr]['p'][$statLbl]==1) {echo " style='text-decoration:underline;'";}
			  echo ">".stat_format($statLbl,$row[$statLbl])."</td>";
		  }
		  echo "<td>".$pERAplus[$tid][$yr]['eraPlus']."</td>";
		  if ($showWS==1) 
		  {
			  echo "<td>";
			  if ($row['pws']=="") {echo '&nbsp;';} else {echo stat_format('pws',$row['pws']);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;

		  $prevYr=$yr;
	  }
	  if ($multiRow==1)
	  {
		  $yrQuery="";
		  if ($showWS==1) {$yrQuery="SELECT y.*,pws FROM (";}
		  $yrQuery.="SELECT year";
		  foreach ($statArray as $key => $statLbl) {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
		  $yrQuery.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 AND year=$prevYr GROUP BY year";
		  if ($showWS==1) {$yrQuery.=") as y LEFT JOIN (SELECT year,SUM(pws) as pws FROM players_win_shares WHERE player_id=$pid AND year=$prevYr GROUP BY year) as pwsTBL ON y.year=pwsTBL.year";}
		  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
		  $yrResult=mysqli_query($db,$yrQuery);
		  $yrRow=mysqli_fetch_array($yrResult);

		  $cls='s';
		  if ((isset($award[4][$prevYr]))||(isset($award[6][$prevYr]))) {$cls='b';}
		  $cls.=($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - Tot";
		  if (isset($award[9][$prevYr])) {echo " (AS)";}
		  echo "</td>\n";
		  echo "<td>$age</td>\n";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td";
			  if ($ll[$prevYr]['p'][$statLbl]==1) {echo " style='text-decoration:underline;'";}
		    	  echo ">".stat_format($statLbl,$yrRow[$statLbl])."</td>";
		  }
		  echo "<td>".$yrERAplus[$prevYr]['eraPlus']."</td>";
		  if ($showWS==1) 
		  {
			  echo "<td>";
			  if ($yrRow['pws']=="") {echo '&nbsp;';} else {echo stat_format('pws',$yrRow['pws']);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
	  }
	  echo "    <tfoot>\n";
	  ## Projected Totals
	  if ($calcProj==1)
	  {
		  $query="";
		  $query.="SELECT y.year,y.team_id";
		  foreach ($statArray as $key => $statLbl)
		  {
			  switch ($statLbl)
			  {
			  case 'era':
			  case 'whip':
			  case 'babip':
			  case 'erc':
			  case 'fip':
				  $query.=",$statLbl";
				  break;
			  default:
				  $query.=",$totTmGm*($statLbl/g)*(g/".$gmPlayed[1].") as $statLbl";
				  break;
			  }
		  }
		  if ($showWS==1) {$query.=",$totTmGm*(pws/g)*(g/".$gmPlayed[1].") as pws";}
		  $query.=" FROM (";
		  $query.="SELECT year,team_id";
		  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
		  $query.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 AND year=$lgyear GROUP BY year) as y";
		  if ($showWS==1) {$query.=" LEFT JOIN (SELECT year,team_id,SUM(pws) as pws FROM players_win_shares WHERE player_id=$pid GROUP BY year) as pwsTBL ON y.year=pwsTBL.year";}
		  if ($_GET['showq']==1) {echo "$query<br/>\n";}
		  $result=mysqli_query($db,$query);
		  $row=mysqli_fetch_array($result);
		  $cls='s'.($rowCnt%2+1);
		  echo "    <tr class='$cls' style='font-style:italic;'>";
		  echo "<td class='".$cls."_l' colspan=2 title='$lgyear Projected Totals' style='border-top:1px solid black;'>$lgyear Proj.</td>";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td style='border-top:1px solid black;'>";
			  switch ($statLbl)
			  {
			  case 'era':
			  case 'ip':
			  case 'whip':
			  case 'babip':
			  case 'erc':
			  case 'fip':
				  echo stat_format($statLbl,$row[$statLbl])."</td>";
				  break;
			  default:
				  echo stat_format($statLbl,$row[$statLbl],0)."</td>";
				  break;
			  }
		  }
		  echo "<td style='border-top:1px solid black;'>".$yrERAplus[$lgyear]['eraPlus']."</td>";
		  if ($showWS==1) 
		  {
			  echo "<td style='border-top:1px solid black;'>";
			  if ($row['pws']=="") {echo '&nbsp;';} else {echo stat_format('pws',$row['pws']);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;
	  }
	  ## Per Team
	  $query="";
	  if ($showWS==1) {$query.="SELECT y.*,pws FROM (";}
	  $query.="SELECT team_id,MIN(year) as minYr,COUNT(DISTINCT year) as yrs";
	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
	  $query.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 GROUP BY team_id";
	  if ($showWS==1) {$query.=") as y LEFT JOIN (SELECT team_id,SUM(pws) as pws FROM players_win_shares WHERE player_id=$pid GROUP BY team_id) as pwsTBL ON y.team_id=pwsTBL.team_id";}
	  $query.=" ORDER BY minYr,yrs";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  $tmCnt=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $tid=$row['team_id'];

		  $cls='s'.($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' colspan=2 title='".$row['yrs']." season(s)'";
		  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
		  echo ">w/ ".$teams[$tid][$yr]['abbr'];
		  if ((isset($award[4]['team'][$tid]))&&(isset($award[9]['team'][$tid])))
		  {
			  echo " (".$award[4]['team'][$tid]."xPOY, ".$award[9]['team'][$tid]."xAS)";
		  }
		  elseif (isset($award[4]['team'][$tid])) {echo " (".$award[4]['team'][$tid]."xPOY)";}
		  elseif (isset($award[9]['team'][$tid])) {echo " (".$award[9]['team'][$tid]."xAS)";}
		  echo "</td>";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td";
			  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
			  echo ">".stat_format($statLbl,$row[$statLbl])."</td>";
		  }
		  echo "<td";
		  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
		  echo ">".$tmERAplus[$tid]['eraPlus']."</td>";
		  if ($showWS==1) 
		  {
			  echo "<td";
			  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
			  echo ">";
			  if ($row['pws']=="") {echo '&nbsp;';} else {echo stat_format('pws',$row['pws']);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;
		  $tmCnt++;
	  }
	  ## Career Totals
	  $query="";
	  if ($showWS==1) {$query.="SELECT y.*,pws FROM (";}
	  $query.="SELECT player_id,COUNT(DISTINCT year) as yrs";
	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
	  $query.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 GROUP BY player_id";
	  if ($showWS==1) {$query.=") as y LEFT JOIN (SELECT player_id,SUM(pws) as pws FROM players_win_shares WHERE player_id=$pid GROUP BY player_id) as pwsTBL ON y.player_id=pwsTBL.player_id";}
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  while ($row=mysqli_fetch_array($result))
	  {
		  #Per162
		  $pavgG=round($avgG*68/162,0);
	 	  $avgRatio=($row['gs']+$row['g'])/$pavgG;
		  $cls='s'.($rowCnt%2+1);
		  echo "    <tr class='$cls' style='font-style:italic;'>";
		  echo "<td class='".$cls."_l' colspan=2 style='border-bottom:1px solid black;'>Per $avgG games</td>";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td style='border-bottom:1px solid black;'>";
			  switch ($statLbl)
			  {
			  case 'era':
			  case 'whip':
			  case 'babip':
			  case 'erc':
			  case 'fip':
				  echo stat_format($statLbl,$row[$statLbl]);
				  break;
			  case 'ip':
			  case 'war':
				  echo stat_format($statLbl,$row[$statLbl]/$avgRatio);
				  break;
			  default:
				  echo stat_format($statLbl,round($row[$statLbl]/$avgRatio,0));
				  break;
			  }
			  echo "</td>";
		  }
		  echo "<td style='border-bottom:1px solid black;'>".$ERAplus['eraPlus']."</td>";
		  if ($showWS==1) 
		  {
			  echo "<td style='border-bottom:1px solid black;'>";
			  if ($row['pws']=="") {echo '&nbsp;';} else {echo stat_format('pws',$row['pws']/$avgRatio);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;
		  #Career
		  $cls='b'.($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' colspan=2 title='$tmCnt team(s), ".$row['yrs']." season(s)'>Totals</td>";
		  foreach ($statArray as $key => $statLbl) {echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";}
		  echo "<td>".$ERAplus['eraPlus']."</td>";
		  if ($showWS==1) 
		  {
			  echo "<td>";
			  if ($row['pws']=="") {echo '&nbsp;';} else {echo stat_format('pws',$row['pws']);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
	  }
	  echo "    </tfoot>\n";
	  echo "   </table>\n";
	  echo "  </td></tr>\n";
	  echo " </table>   <!-- close pitching stats -->\n";
	  echo "</div>   <!-- close pitching stats -->\n";

	  ### Expanded Pitching Stats
	  $statArray=Array("bf","pi","rper9","hper9","kper9","bbper9","hrper9","kperbb","qs","qsPct","cgPct","gf","gb","fb","gbPct","wp","bk","bs","svPct","svo");
	  $query="SELECT year,team_id";
	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
	  $query.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 GROUP BY year,team_id ORDER BY year";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  echo "<div class='textbox'>   <!-- open expanded pitching stats -->\n";
	  echo " <table cellpadding=0 cellspacing=0 border=0>   <!-- open expanded pitching stats -->\n";
	  echo "  <tr class='title'><td style='padding:2px;'>Expanded Pitching Stats</td></tr>\n";
	  echo "  <tr><td>\n";
	  echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' style='width:935px;'>\n";
	  echo "    <thead><tr class='headline'><td class='hsc2_l'>Year/Team</td><td class='hsc2'>Age</td>";
	  foreach ($statArray as $key => $statLbl) {echo "<td class='hsc2' title='".stat_text($statLbl)."'>".stat_text($statLbl,2)."</td>";}
	  echo "</tr></thead>\n";
	  $rowCnt=0;
	  $prevYr=-1;
	  $multiRow=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $yr=$row['year'];
		  $tid=$row['team_id'];

		  if (($multiRow==1)&&($yr!=$prevYr))
		  {
			  $yrQuery="SELECT year";
			  foreach ($statArray as $key => $statLbl) {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
			  $yrQuery.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 AND year=$prevYr GROUP BY year";
			  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
			  $yrResult=mysqli_query($db,$yrQuery);
			  $yrRow=mysqli_fetch_array($yrResult);

			  $cls='s';
			  if ((isset($award[4][$prevYr]))||(isset($award[6][$prevYr]))) {$cls='b';}
			  $cls.=($rowCnt%2+1);
			  echo "    <tr class='$cls'>";
			  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - Tot";
			  if (isset($award[9][$prevYr])) {echo " (AS)";}
			  echo "</td>\n";
			  echo "<td>$age</td>\n";
			  foreach ($statArray as $key => $statLbl) 
			  {
				  echo "<td";
				  if ($ll[$prevYr]['p'][$statLbl]==1) {echo " style='text-decoration:underline;'";}
				  echo ">".stat_format($statLbl,$yrRow[$statLbl])."</td>";
			  }
			  echo "</tr>\n";

			  $rowCnt++;
			  $multiRow=0;
		  }
		  elseif ($yr==$prevYr) {$multiRow=1;}

		  unset($yrDate);
		  $age=$ageNow+$yr-$lgyear;

		  $cls='s';
		  if ((isset($award[4][$yr][$tid]))||(isset($award[6][$yr][$tid]))) {$cls='b';}
		  $cls.=($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'><a href='./team_summary.php?team_id=$tid&year=$yr'>$yr - ".$teams[$tid][$yr]['abbr']."</a>";
		  if (isset($award[9][$yr][$tid])) {echo " (AS)";}
		  echo "</td>\n";
		  echo "<td>$age</td>\n";
		  foreach ($statArray as $key => $statLbl)
		  {
			  echo "<td";
			  if ($ll[$yr]['p'][$statLbl]==1) {echo " style='text-decoration:underline;'";}
		    	  echo ">".stat_format($statLbl,$row[$statLbl])."</td>";}
		  echo "</tr>\n";
		  $rowCnt++;

		  $prevYr=$yr;
	  }
	  if ($multiRow==1)
	  {
		  $yrQuery="SELECT year";
		  foreach ($statArray as $key => $statLbl) {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
		  $yrQuery.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 AND year=$prevYr GROUP BY year";
		  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
		  $yrResult=mysqli_query($db,$yrQuery);
		  $yrRow=mysqli_fetch_array($yrResult);

		  $cls='s';
		  if ((isset($award[4][$prevYr]))||(isset($award[6][$prevYr]))) {$cls='b';}
		  $cls.=($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - Tot";
		  if (isset($award[9][$prevYr])) {echo " (AS)";}
		  echo "</td>\n";
		  echo "<td>$age</td>\n";
		  foreach ($statArray as $key => $statLbl)
		  {
			  echo "<td";
			  if ($ll[$prevYr]['p'][$statLbl]==1) {echo " style='text-decoration:underline;'";}
		    	  echo ">".stat_format($statLbl,$yrRow[$statLbl])."</td>";
		  }
		  echo "</tr>\n";
	  }
	  echo "    <tfoot>\n";
	  ## Per Team
	  $query="SELECT team_id,MIN(year) as minYr,COUNT(DISTINCT year) as yrs";
	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
	  $query.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 GROUP BY team_id ORDER BY minYr,yrs";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  $tmCnt=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $tid=$row['team_id'];

		  $cls='s'.($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' colspan=2 title='".$row['yrs']." season(s)'";
		  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
		  echo ">w/ ".$teams[$tid][$yr]['abbr'];
		  if ((isset($award[4]['team'][$tid]))&&(isset($award[9]['team'][$tid])))
		  {
			  echo " (".$award[4]['team'][$tid]."xPOY, ".$award[9]['team'][$tid]."xAS)";
		  }
		  elseif (isset($award[4]['team'][$tid])) {echo " (".$award[4]['team'][$tid]."xPOY)";}
		  elseif (isset($award[9]['team'][$tid])) {echo " (".$award[9]['team'][$tid]."xAS)";}
		  echo "</td>";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td";
			  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
			  echo ">".stat_format($statLbl,$row[$statLbl])."</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;
		  $tmCnt++;
	  }
	  ## Career Totals
	  $query="SELECT COUNT(DISTINCT year) as yrs";
	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
	  $query.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 GROUP BY player_id";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  while ($row=mysqli_fetch_array($result))
	  {
		  #Per162
		  $cls='s'.($rowCnt%2+1);
		  echo "    <tr class='$cls' style='font-style:italic;'>";
		  echo "<td class='".$cls."_l' colspan=2 style='border-bottom:1px solid black;'>Per $avgG games</td>";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td style='border-bottom:1px solid black;'>";
			  switch ($statLbl)
			  {
			  case 'bf':
			  case 'pi':
			  case 'qs':
			  case 'gf':
			  case 'gb':
			  case 'fb':
			  case 'wp':
			  case 'bk':
			  case 'bs':
			  case 'svo':
				  echo stat_format($statLbl,round($row[$statLbl]/$avgRatio,0));
				  break;
			  default:
				  echo stat_format($statLbl,$row[$statLbl]);
				  break;
			  }
			  echo "</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;
		  #Career
		  $cls='b'.($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' colspan=2 title='$tmCnt team(s), ".$row['yrs']." season(s)'>Totals</td>";
		  foreach ($statArray as $key => $statLbl) {echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";}
		  echo "</tr>\n";
	  }
	  echo "    </tfoot>\n";
	  echo "   </table>\n";
	  echo "  </td></tr>\n";
	  echo " </table>   <!-- close expanded pitching stats -->\n";
	  echo "</div>   <!-- close expanded pitching stats -->\n";

	  ## Postseason Pitching Stats
	  $statArray=Array("g","gs","w","l","s","era","ip","ha","r","er","hra","bb","k","hp","hld","cg","sho","whip","babip","erc","fip");

	  $query="";
	  $query.="SELECT year,team_id";
	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
	  $query.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=21 GROUP BY year,team_id";
	  $query.=" ORDER BY year";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  if (mysqli_num_rows($result))
	  {
		  echo "<div class='textbox'>   <!-- open postseason pitching stats -->\n";
		  echo " <table cellpadding=0 cellspacing=0 border=0>   <!-- open postseason pitching stats -->\n";
		  echo "  <tr class='title'><td style='padding:2px;'>Postseason Pitching Stats</td></tr>\n";
		  echo "  <tr><td>\n";
		  echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' style='width:935px;'>\n";
		  echo "    <thead><tr class='headline'><td class='hsc2_l'>Year/Team</td><td class='hsc2'>Age</td>";
		  foreach ($statArray as $key => $statLbl) {echo "<td class='hsc2' title='".stat_text($statLbl)."'>".stat_text($statLbl,2)."</td>";}
		  echo "</tr></thead>\n";
	
		  $rowCnt=0;
		  $prevYr=-1;
		  $multiRow=0;
		  while ($row=mysqli_fetch_array($result))
		  {
			  $yr=$row['year'];
			  $tid=$row['team_id'];
	
			  if (($multiRow==1)&&($yr!=$prevYr))
			  {
				  $yrQuery="";
				  $yrQuery.="SELECT year";
				  foreach ($statArray as $key => $statLbl) {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
				  $yrQuery.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=21 AND year=$prevYr GROUP BY year";
				  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
				  $yrResult=mysqli_query($db,$yrQuery);
				  $yrRow=mysqli_fetch_array($yrResult);

				  $cls='s'.($rowCnt%2+1);
				  echo "    <tr class='$cls'>";
				  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - Tot</td>\n";
				  echo "<td>$age</td>\n";
				  foreach ($statArray as $key => $statLbl) 
				  {
					  echo "<td>".stat_format($statLbl,$yrRow[$statLbl])."</td>";
				  }
				  echo "</tr>\n";

				  $rowCnt++;
				  $multiRow=0;
			  }
			  elseif ($yr==$prevYr) {$multiRow=1;}
		
			  unset($yrDate);
			  $age=$ageNow+$yr-$lgyear;

			  $cls='s'.($rowCnt%2+1);
			  echo "    <tr class='$cls'>";
			  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'><a href='./team_summary.php?team_id=$tid&year=$yr'>$yr - ".$teams[$tid][$yr]['abbr']."</a></td>\n";
			  echo "<td>$age</td>\n";
			  foreach ($statArray as $key => $statLbl)
			  {
				  echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";
			  }
			  echo "</tr>\n";
			  $rowCnt++;
	
			  $prevYr=$yr;
		  }
		  if ($multiRow==1)
		  {
			  $yrQuery="";
			  $yrQuery.="SELECT year";
			  foreach ($statArray as $key => $statLbl) {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
			  $yrQuery.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=21 AND year=$prevYr GROUP BY year";
			  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
			  $yrResult=mysqli_query($db,$yrQuery);
			  $yrRow=mysqli_fetch_array($yrResult);
	
			  $cls='s'.($rowCnt%2+1);
			  echo "    <tr class='$cls'>";
			  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - Tot</td>\n";
			  echo "<td>$age</td>\n";
			  foreach ($statArray as $key => $statLbl) 
			  {
				  echo "<td>".stat_format($statLbl,$yrRow[$statLbl])."</td>";
			  }
			  echo "</tr>\n";
		  }
		  echo "    <tfoot>\n";
		  ## Per Team
		  $query="";
		  $query.="SELECT team_id,MIN(year) as minYr,COUNT(DISTINCT year) as yrs";
		  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
		  $query.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=21 GROUP BY team_id";
		  $query.=" ORDER BY minYr,yrs";
		  if ($_GET['showq']==1) {echo "$query<br/>\n";}
		  $result=mysqli_query($db,$query);
		  $tmCnt=0;
		  while ($row=mysqli_fetch_array($result))
		  {
			  $tid=$row['team_id'];

			  $cls='s'.($rowCnt%2+1);
			  echo "    <tr class='$cls'>";
			  echo "<td class='".$cls."_l' colspan=2 title='".$row['yrs']." season(s)'";
			  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
			  echo ">w/ ".$teams[$tid][$yr]['abbr'];
			  echo "</td>";
			  foreach ($statArray as $key => $statLbl) 
			  {
				  echo "<td";
				  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
				  echo ">".stat_format($statLbl,$row[$statLbl])."</td>";
			  }
			  echo "</tr>\n";
			  $rowCnt++;
			  $tmCnt++;
		  }
		  ## Career Totals
		  $query="";
		  $query.="SELECT player_id,COUNT(DISTINCT year) as yrs";
		  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
		  $query.=" FROM players_career_pitching_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=21 GROUP BY player_id";
		  if ($_GET['showq']==1) {echo "$query<br/>\n";}
		  $result=mysqli_query($db,$query);
		  while ($row=mysqli_fetch_array($result))
		  {
			  #Per162
			  $pavgG=round($avgG*68/162,0);
			  $avgRatio=($row['gs']+$row['g'])/$pavgG;
			  $cls='s'.($rowCnt%2+1);
			  echo "    <tr class='$cls' style='font-style:italic;'>";
			  echo "<td class='".$cls."_l' colspan=2 style='border-bottom:1px solid black;'>Per $avgG games</td>";
			  foreach ($statArray as $key => $statLbl) 
			  {
				  echo "<td style='border-bottom:1px solid black;'>";
				  switch ($statLbl)
				  {
				  case 'era':
				  case 'whip':
				  case 'babip':
				  case 'erc':
				  case 'fip':
					  echo stat_format($statLbl,$row[$statLbl]);
					  break;
				  case 'ip':
					  echo stat_format($statLbl,$row[$statLbl]/$avgRatio);
					  break;
				  default:
					  echo stat_format($statLbl,round($row[$statLbl]/$avgRatio,0));
					  break;
				  }
				  echo "</td>";
			  }
			  echo "</tr>\n";
			  $rowCnt++;
			  #Career
			  $cls='b'.($rowCnt%2+1);
			  echo "    <tr class='$cls'>";
			  echo "<td class='".$cls."_l' colspan=2 title='$tmCnt team(s), ".$row['yrs']." season(s)'>Totals</td>";
			  foreach ($statArray as $key => $statLbl) {echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";}
			  echo "</tr>\n";
		  }
		  echo "    </tfoot>\n";
		  echo "   </table>\n";
		  echo "  </td></tr>\n";
		  echo " </table>   <!-- close postseason pitching stats -->\n";
		  echo "</div>   <!-- close postseason pitching stats -->\n";
	  }

  }



  ##### Batting Stats
  $calcProj=0;
  $statArray=Array("g","ab","h","d","t","hr","rbi","r","bb","hp","sh","sf","k","sb","cs","avg","obp","slg","ops","war","wOBA");
  $query="";
  if ($showWS==1) {$query.="SELECT y.*,ows,fwsTot,wsTot FROM (";}
  $query.="SELECT year,team_id,stint";
  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
  $query.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 GROUP BY year,team_id";
  if ($showWS==1) {$query.=") as y LEFT JOIN (SELECT year,team_id,SUM(ows) as ows,SUM(fwsTot) as fwsTot,SUM(wsTot) as wsTot FROM players_win_shares WHERE player_id=$pid GROUP BY year,team_id) as owsTBL ON y.year=owsTBL.year AND y.team_id=owsTBL.team_id";}
  $query.=" ORDER BY year,stint";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result)>0)
  {
	  ## Get OPS+
	  $query="SELECT y1.player_id,y1.team_id,y1.year,y1.pa,y1.obp,y1.slg,y2.sub_league_id,y2.rpf,y2.lgOBP,y2.lgSLG,if(y1.pa=0,0,100*(y1.obp/(y2.lgOBP*rpf)+y1.slg/(y2.lgSLG*rpf)-1)) as opsPlus,rpfAdj FROM (SELECT player_id,team_id,year,SUM(pa) as pa,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))) as obp,if (SUM(ab)=0,0,(SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab)) as slg FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND player_id=$pid GROUP BY player_id,team_id,year) as y1,(SELECT t1.team_id,lg1.sub_league_id,t1.year,if(rpf IS NULL,1,rpf) as rpf,obp as lgOBP,slg as lgSLG,if(rpf IS NULL,0,1) as rpfAdj FROM (SELECT t.team_id,t.year,sub_league_id,rpf FROM team_history as t LEFT JOIN park_factors as pf ON t.team_id=pf.team_id AND t.league_id=pf.league_id AND t.year=pf.year WHERE t.league_id=$lgid UNION SELECT t.team_id,'$lgyear' as year,sub_league_id,rpf FROM teams as t LEFT JOIN park_factors as pf ON t.team_id=pf.team_id AND t.league_id=pf.league_id WHERE t.league_id=$lgid AND pf.year=$lgyear) as t1,(SELECT sub_league_id,year,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))) as obp,if (SUM(ab)=0,0,(SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab)) as slg FROM team_history_batting_stats WHERE league_id=$lgid GROUP BY sub_league_id,year UNION SELECT tr.sub_league_id,'$lgyear' as year,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))) as obp,if (SUM(ab)=0,0,(SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab)) as slg FROM team_batting_stats as tps,team_relations as tr WHERE tps.team_id=tr.team_id AND tps.league_id=$lgid GROUP BY sub_league_id) as lg1 WHERE t1.sub_league_id=lg1.sub_league_id AND t1.year=lg1.year) as y2 WHERE y1.team_id=y2.team_id AND y1.year=y2.year";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $opsResult=mysqli_query($db,$query);
	  while ($opsRow=mysqli_fetch_array($opsResult))
	  {
		  $tid=$opsRow['team_id'];
		  $yr=$opsRow['year'];
		  $pa=$opsRow['pa'];
		  $opsPlus=$opsRow['opsPlus'];
		  $product=$pa*$opsPlus;

		  $pOPSplus[$tid][$yr]['opsPlus']=round($opsPlus);

		  # Get team OPS+
		  if (isset($tmOPSplus[$tid]['product']))
		  {
			  $tmOPSplus[$tid]['product']+=$product;
			  $tmOPSplus[$tid]['pa']+=$pa;
		  }
		  else 
		  {
			  $tmOPSplus[$tid]['product']=$product;
			  $tmOPSplus[$tid]['pa']=$pa;
		  }
		  if ($tmOPSplus[$tid]['pa']==0) {$tmOPSplus[$tid]['opsPlus']=0;}
		  else {$tmOPSplus[$tid]['opsPlus']=round($tmOPSplus[$tid]['product']/$tmOPSplus[$tid]['pa']);}

		  # Get year OPS+
		  if (isset($yrOPSplus[$yr]['product']))
		  {
			  $yrOPSplus[$yr]['product']+=$product;
			  $yrOPSplus[$yr]['pa']+=$pa;
		  }
		  else 
		  {
			  $yrOPSplus[$yr]['product']=$product;
			  $yrOPSplus[$yr]['pa']=$pa;
		  }
		  if ($yrOPSplus[$yr]['pa']==0) {$yrOPSplus[$yr]['opsPlus']=0;}
		  else {$yrOPSplus[$yr]['opsPlus']=round($yrOPSplus[$yr]['product']/$yrOPSplus[$yr]['pa']);}

		  # Get career OPS+
		  if (isset($OPSplus['product']))
		  {
			  $OPSplus['product']+=$product;
			  $OPSplus['pa']+=$pa;
		  }
		  else 
		  {
			  $OPSplus['product']=$product;
			  $OPSplus['pa']=$pa;
		  }
		  if ($OPSplus['pa']==0) {$OPSplus['opsPlus']=0;}
		  else {$OPSplus['opsPlus']=round($OPSplus['product']/$OPSplus['pa']);}
	  }

	  ## Display Batting Stats
	  echo "<div class='textbox'>   <!-- open batting stats -->\n";
	  echo " <table cellpadding=0 cellspacing=0 border=0>   <!-- open batting stats -->\n";
	  echo "  <tr class='title'><td style='padding:2px;'>Batting Stats</td></tr>\n";
	  echo "  <tr><td>\n";
	  echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' style='width:935px;'>\n";
	  echo "    <thead><tr class='headline'><td class='hsc2_l'>Year/Team</td><td class='hsc2'>Age</td>";
	  foreach ($statArray as $key => $statLbl) {echo "<td class='hsc2' title='".stat_text($statLbl)."'>".stat_text($statLbl,2)."</td>";}
	  echo "<td class='hsc2'>OPS+</td>";
	  if ($showWS==1)
	  {
		  echo "<td class='hsc2' title='Batting Win Shares'>bWS</td>";
		  echo "<td class='hsc2' title='Fielding Win Shares'>fWS</td>";
		  echo "<td class='hsc2' title='Total Win Shares'>tWS</td>";
	  }
	  echo "</tr></thead>\n";
	  $rowCnt=0;
	  $prevYr=-1;
	  $multiRow=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $yr=$row['year'];
		  $tid=$row['team_id'];

		  if (($yr==$lgyear)&&($row['g']>0)&&($seaCompPct>0)&&($seaCompPct<1)) {$calcProj=1;}

		  if (($multiRow==1)&&($yr!=$prevYr))
		  {
			  $yrQuery="";
			  if ($showWS==1) {$yrQuery="SELECT y.*,ows,fwsTot,wsTot FROM (";}
			  $yrQuery.="SELECT year";
			  foreach ($statArray as $key => $statLbl) {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
			  $yrQuery.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 AND year=$prevYr GROUP BY year";
			  if ($showWS==1) {$yrQuery.=") as y LEFT JOIN (SELECT year,SUM(ows) as ows,SUM(fwsTot) as fwsTot,SUM(wsTot) as wsTot FROM players_win_shares WHERE player_id=$pid AND year=$prevYr GROUP BY year) as owsTBL ON y.year=owsTBL.year";}
			  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
			  $yrResult=mysqli_query($db,$yrQuery);
			  $yrRow=mysqli_fetch_array($yrResult);

			  $cls='s';
			  if ((isset($award[5][$prevYr]))||(isset($award[6][$prevYr]))) {$cls='b';}
			  $cls.=($rowCnt%2+1);
			  echo "    <tr class='$cls'>";
			  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - Tot";
			  if (isset($award[9][$prevYr])) {echo " (AS)";}
			  echo "</td>\n";
			  echo "<td>$age</td>\n";
			  foreach ($statArray as $key => $statLbl)
			  {
				  echo "<td";
				  if ($ll[$prevYr]['b'][$statLbl]==1) {echo " style='text-decoration:underline;'";}
				  echo ">".stat_format($statLbl,$yrRow[$statLbl])."</td>";
			  }
			  echo "<td>".$yrOPSplus[$prevYr]['opsPlus']."</td>";
			  if ($showWS==1) 
			  {
				  echo "<td>";
				  if ($yrRow['ows']=="") {echo '&nbsp;';} else {echo stat_format('ows',$yrRow['ows']);}
				  echo "</td>";
				  echo "<td>";
				  if ($yrRow['fwsTot']=="") {echo '&nbsp;';} else {echo stat_format('fwsTot',$yrRow['fwsTot']);}
				  echo "</td>";
				  echo "<td>";
				  if ($yrRow['wsTot']=="") {echo '&nbsp;';} else {echo stat_format('wsTot',$yrRow['wsTot']);}
				  echo "</td>";
			  }
			  echo "</tr>\n";

			  $rowCnt++;
			  $multiRow=0;
		  }
		  elseif ($yr==$prevYr) {$multiRow=1;}

		  unset($yrDate);
		  $age=$ageNow+$yr-$lgyear;

		  $cls='s';
		  if ((isset($award[5][$yr][$tid]))||(isset($award[6][$yr][$tid]))) {$cls='b';}
		  $cls.=($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'><a href='./team_summary.php?team_id=$tid&year=$yr'>$yr - ".$teams[$tid][$yr]['abbr']."</a>";
		  if (isset($award[9][$yr][$tid])) {echo " (AS)";}
		  echo "</td>\n";
		  echo "<td>$age</td>\n";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td";
			  if ($ll[$yr]['b'][$statLbl]==1) {echo " style='text-decoration:underline;'";}
			  echo ">".stat_format($statLbl,$row[$statLbl])."</td>";
		  }
		  echo "<td>".$pOPSplus[$tid][$yr]['opsPlus']."</td>";
		  if ($showWS==1) 
		  {
			  echo "<td>";
			  if ($row['ows']=="") {echo '&nbsp;';} else {echo stat_format('ows',$row['ows']);}
			  echo "</td>";
			  echo "<td>";
			  if ($row['fwsTot']=="") {echo '&nbsp;';} else {echo stat_format('fwsTot',$row['fwsTot']);}
			  echo "</td>";
			  echo "<td>";
			  if ($row['wsTot']=="") {echo '&nbsp;';} else {echo stat_format('wsTot',$row['wsTot']);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;

		  $prevYr=$yr;
	  }
	  if ($multiRow==1)
	  {
		  $yrQuery="";
		  if ($showWS==1) {$yrQuery="SELECT y.*,ows,fwsTot,wsTot FROM (";}
		  $yrQuery.="SELECT year";
		  foreach ($statArray as $key => $statLbl) {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
		  $yrQuery.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 AND year=$prevYr GROUP BY year";
		  if ($showWS==1) {$yrQuery.=") as y LEFT JOIN (SELECT year,SUM(ows) as ows,SUM(fwsTot) as fwsTot,SUM(wsTot) as wsTot FROM players_win_shares WHERE player_id=$pid AND year=$prevYr GROUP BY year) as owsTBL ON y.year=owsTBL.year";}
		  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
		  $yrResult=mysqli_query($db,$yrQuery);
		  $yrRow=mysqli_fetch_array($yrResult);

		  $cls='s';
		  if ((isset($award[5][$prevYr]))||(isset($award[6][$prevYr]))) {$cls='b';}
		  $cls.=($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - Tot";
		  if (isset($award[9][$prevYr])) {echo " (AS)";}
		  echo "</td>\n";
		  echo "<td>$age</td>\n";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td";
			  if ($ll[$prevYr]['b'][$statLbl]==1) {echo " style='text-decoration:underline;'";}
			  echo ">".stat_format($statLbl,$yrRow[$statLbl])."</td>";
		  }
		  echo "<td>".$yrOPSplus[$prevYr]['opsPlus']."</td>";
		  if ($showWS==1) 
		  {
			  echo "<td>";
			  if ($yrRow['ows']=="") {echo '&nbsp;';} else {echo stat_format('ows',$yrRow['ows']);}
			  echo "</td>";
			  echo "<td>";
			  if ($yrRow['fwsTot']=="") {echo '&nbsp;';} else {echo stat_format('fwsTot',$yrRow['fwsTot']);}
			  echo "</td>";
			  echo "<td>";
			  if ($yrRow['fwsTot']=="") {echo '&nbsp;';} else {echo stat_format('fwsTot',$yrRow['fwsTot']);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
	  }
	  echo "    <tfoot>\n";
	  ## Projected Totals
	  if ($calcProj==1)
	  {
		  $query="";
		  $query.="SELECT y.year,y.team_id";
		  foreach ($statArray as $key => $statLbl)
		  {
			  switch ($statLbl)
			  {
			  case 'avg':
			  case 'obp':
			  case 'slg':
			  case 'ops':
			  case 'wOBA':
				  $query.=",$statLbl";
				  break;
			  default:
				  $query.=",$totTmGm*($statLbl/g)*(g/".$gmPlayed[1].") as $statLbl";
				  break;
			  }
		  }
		  if ($showWS==1) {$query.=",$totTmGm*(ows/g)*(g/".$gmPlayed[1].") as ows,$totTmGm*(fwsTot/g)*(g/".$gmPlayed[1].") as fwsTot,$totTmGm*(wsTot/g)*(g/".$gmPlayed[1].") as wsTot";}
		  $query.=" FROM (";
		  $query.="SELECT year,team_id";
		  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
		  $query.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 AND year=$lgyear GROUP BY year) as y";
		  if ($showWS==1) {$query.=" LEFT JOIN (SELECT year,team_id,SUM(ows) as ows,SUM(fwsTot) as fwsTot,SUM(wsTot) as wsTot FROM players_win_shares WHERE player_id=$pid GROUP BY year) as owsTBL ON y.year=owsTBL.year";}
		  if ($_GET['showq']==1) {echo "$query<br/>\n";}
		  $result=mysqli_query($db,$query);
		  $row=mysqli_fetch_array($result);
		  $cls='s'.($rowCnt%2+1);
		  echo "    <tr class='$cls' style='font-style:italic;'>";
		  echo "<td class='".$cls."_l' colspan=2 title='$lgyear Projected Totals' style='border-top:1px solid black;'>$lgyear Proj.</td>";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td style='border-top:1px solid black;'>";
			  switch ($statLbl)
			  {
			  case 'avg':
			  case 'obp':
			  case 'slg':
			  case 'ops':
			  case 'wOBA':
				  echo stat_format($statLbl,$row[$statLbl])."</td>";
				  break;
			  default:
				  echo stat_format($statLbl,$row[$statLbl],0)."</td>";
				  break;
			  }
		  }
		  echo "<td style='border-top:1px solid black;'>".$yrOPSplus[$lgyear]['opsPlus']."</td>";
		  if ($showWS==1) 
		  {
			  echo "<td style='border-top:1px solid black;'>";
			  if ($row['ows']=="") {echo '&nbsp;';} else {echo stat_format('ows',$row['ows']);}
			  echo "</td>";
			  echo "<td style='border-top:1px solid black;'>";
			  if ($row['fwsTot']=="") {echo '&nbsp;';} else {echo stat_format('fwsTot',$row['fwsTot']);}
			  echo "</td>";
			  echo "<td style='border-top:1px solid black;'>";
			  if ($row['wsTot']=="") {echo '&nbsp;';} else {echo stat_format('wsTot',$row['wsTot']);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;
	  }
	  ## Per Team
	  $query="";
	  if ($showWS==1) {$query.="SELECT y.*,ows,fwsTot,wsTot FROM (";}
	  $query.="SELECT team_id,MIN(year) as minYr,COUNT(DISTINCT year) as yrs";
	  foreach ($statArray as $key => $statLbl)
	  {
		  if ($statLbl=='pahr') {$query.=",".stat_query($statLbl,"","",.00001)." as $statLbl";}
		  else {$query.=",".stat_query($statLbl)." as $statLbl";}
	  }
	  $query.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 GROUP BY team_id";
	  if ($showWS==1) {$query.=") as y LEFT JOIN (SELECT team_id,SUM(ows) as ows,SUM(fwsTot) as fwsTot,SUM(wsTot) as wsTot FROM players_win_shares WHERE player_id=$pid GROUP BY team_id) as owsTBL ON y.team_id=owsTBL.team_id";}
	  $query.=" ORDER BY minYr,yrs";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  $tmCnt=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $tid=$row['team_id'];

		  $cls='s'.($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' colspan=2 title='".$row['yrs']." season(s)'";
		  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
		  echo ">w/ ".$teams[$tid][$yr]['abbr'];
		  if ((isset($award[5]['team'][$tid]))&&(isset($award[9]['team'][$tid])))
		  {
			  echo " (".$award[5]['team'][$tid]."xBOY, ".$award[9]['team'][$tid]."xAS)";
		  }
		  elseif (isset($award[5]['team'][$tid])) {echo " (".$award[5]['team'][$tid]."xBOY)";}
		  elseif (isset($award[9]['team'][$tid])) {echo " (".$award[9]['team'][$tid]."xAS)";}
		  echo "</td>";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td";
			  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
			  echo ">".stat_format($statLbl,$row[$statLbl])."</td>";
		  }
		  echo "<td";
		  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
		  echo ">".$tmOPSplus[$tid]['opsPlus']."</td>";
		  if ($showWS==1) 
		  {
			  echo "<td";
			  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
			  echo ">";
			  if ($row['ows']=="") {echo '&nbsp;';} else {echo stat_format('ows',$row['ows']);}
			  echo "</td>";
			  echo "<td";
			  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
			  echo ">";
			  if ($row['fwsTot']=="") {echo '&nbsp;';} else {echo stat_format('fwsTot',$row['fwsTot']);}
			  echo "</td>";
			  echo "<td";
			  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
			  echo ">";
			  if ($row['wsTot']=="") {echo '&nbsp;';} else {echo stat_format('wsTot',$row['wsTot']);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;
		  $tmCnt++;
	  }
	  ## Career Totals
	  $query="";
	  if ($showWS==1) {$query.="SELECT y.*,ows,pws,fwsTot,wsTot FROM (";}
	  $query.="SELECT player_id,COUNT(DISTINCT year) as yrs";
	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
	  $query.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 GROUP BY player_id";
	  if ($showWS==1) {$query.=") as y LEFT JOIN (SELECT player_id,SUM(ows) as ows,SUM(pws) as pws,SUM(fwsTot) as fwsTot,SUM(wsTot) as wsTot FROM players_win_shares WHERE player_id=$pid GROUP BY player_id) as owsTBL ON y.player_id=owsTBL.player_id";}
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  while ($row=mysqli_fetch_array($result))
	  {
		  #Per162
	 	  $avgRatio=$row['g']/$avgG;
		  $cls='s'.($rowCnt%2+1);
		  echo "    <tr class='$cls' style='font-style:italic;'>";
		  echo "<td class='".$cls."_l' colspan=2 style='border-bottom:1px solid black;'>Per $avgG games</td>";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td style='border-bottom:1px solid black;'>";
			  switch ($statLbl)
			  {
			  case 'avg':
			  case 'obp':
			  case 'slg':
			  case 'ops':
			  case 'wOBA':
				  echo stat_format($statLbl,$row[$statLbl]);
				  break;
			  case 'war':
				  echo stat_format($statLbl,$row[$statLbl]/$avgRatio);
				  break;
			  default:
				  echo stat_format($statLbl,round($row[$statLbl]/$avgRatio,0));
				  break;
			  }
			  echo "</td>";
		  }
		  echo "<td style='border-bottom:1px solid black;'>".$OPSplus['opsPlus']."</td>";
		  if ($showWS==1) 
		  {
			  echo "<td style='border-bottom:1px solid black;'>";
			  if ($row['ows']=="") {echo '&nbsp;';} else {echo stat_format('ows',$row['ows']/$avgRatio);}
			  echo "</td>";
			  echo "<td style='border-bottom:1px solid black;'>";
			  if ($row['fwsTot']=="") {echo '&nbsp;';} else {echo stat_format('fwsTot',$row['fwsTot']/$avgRatio);}
			  echo "</td>";
			  echo "<td style='border-bottom:1px solid black;' title='Batting & Fielding contributions only'>";
			  if ($row['wsTot']=="") {echo '&nbsp;';} else {echo stat_format('wsTot',($row['wsTot']-$row['pws'])/$avgRatio);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;
		  #Career
		  $cls='b'.($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' colspan=2 title='$tmCnt team(s), ".$row['yrs']." season(s)'>Totals</td>";
		  foreach ($statArray as $key => $statLbl) {echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";}
		  echo "<td>".$OPSplus['opsPlus']."</td>";
		  if ($showWS==1) 
		  {
			  echo "<td>";
			  if ($row['ows']=="") {echo '&nbsp;';} else {echo stat_format('ows',$row['ows']);}
			  echo "</td>";
			  echo "<td>";
			  if ($row['fwsTot']=="") {echo '&nbsp;';} else {echo stat_format('fwsTot',$row['fwsTot']);}
			  echo "</td>";
			  echo "<td>";
			  if ($row['wsTot']=="") {echo '&nbsp;';} else {echo stat_format('wsTot',$row['wsTot']);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
	  }
	  echo "    </tfoot>\n";
	  echo "   </table>\n";
	  echo "  </td></tr>\n";
	  echo " </table>   <!-- close batting stats -->\n";
	  echo "</div>   <!-- close batting stats -->\n";

	  ### Expanded Batting Stats
	  $statArray=Array("pa","outs","ebh","tb","ibb","pitches_seen","pipa","pahr","bbk","gdp","pwrspd","sbPct","rc","rc27","bbabip","iso");
	  $query="SELECT year,team_id";
	  foreach ($statArray as $key => $statLbl)
	  {
		  if ($statLbl=='pahr') {$query.=",".stat_query($statLbl,"","",.00001)." as $statLbl";}
		  else {$query.=",".stat_query($statLbl)." as $statLbl";}
	  }
	  $query.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 GROUP BY year,team_id ORDER BY year";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  echo "<div class='textbox'>   <!-- open expanded batting stats -->\n";
	  echo " <table cellpadding=0 cellspacing=0 border=0>   <!-- open expanded batting stats -->\n";
	  echo "  <tr class='title'><td style='padding:2px;'>Expanded Batting Stats</td></tr>\n";
	  echo "  <tr><td>\n";
	  echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' style='width:935px;'>\n";
	  echo "    <thead><tr class='headline'><td class='hsc2_l'>Year/Team</td><td class='hsc2'>Age</td>";
	  foreach ($statArray as $key => $statLbl) {echo "<td class='hsc2' title='".stat_text($statLbl)."'>".stat_text($statLbl,2)."</td>";}
	  echo "</tr></thead>\n";
	  $rowCnt=0;
	  $prevYr=-1;
	  $multiRow=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $yr=$row['year'];
		  $tid=$row['team_id'];

		  if (($multiRow==1)&&($yr!=$prevYr))
		  {
			  $yrQuery="SELECT year";
			  foreach ($statArray as $key => $statLbl)
			  {
				  if ($statLbl=='pahr') {$yrQuery.=",".stat_query($statLbl,"","",.00001)." as $statLbl";}
				  else {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
			  }
			  $yrQuery.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 AND year=$prevYr GROUP BY year";
			  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
			  $yrResult=mysqli_query($db,$yrQuery);
			  $yrRow=mysqli_fetch_array($yrResult);

			  $cls='s';
			  if ((isset($award[5][$prevYr]))||(isset($award[6][$prevYr]))) {$cls='b';}
			  $cls.=($rowCnt%2+1);
			  echo "    <tr class='$cls'>";
			  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - Tot";
			  if (isset($award[9][$prevYr])) {echo " (AS)";}
			  echo "</td>\n";
			  echo "<td>$age</td>\n";
			  foreach ($statArray as $key => $statLbl) 
			  {
				  echo "<td";
				  if ($ll[$prevYr]['b'][$statLbl]==1) {echo " style='text-decoration:underline;'";}
				  echo ">".stat_format($statLbl,$yrRow[$statLbl])."</td>";
			  }
			  echo "</tr>\n";

			  $rowCnt++;
			  $multiRow=0;
		  }
		  elseif ($yr==$prevYr) {$multiRow=1;}

		  unset($yrDate);
		  $age=$ageNow+$yr-$lgyear;

		  $cls='s';
		  if ((isset($award[5][$yr][$tid]))||(isset($award[6][$yr][$tid]))) {$cls='b';}
		  $cls.=($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'><a href='./team_summary.php?team_id=$tid&year=$yr'>$yr - ".$teams[$tid][$yr]['abbr']."</a>";
		  if (isset($award[9][$yr][$tid])) {echo " (AS)";}
		  echo "</td>\n";
		  echo "<td>$age</td>\n";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td";
			  if ($ll[$yr]['b'][$statLbl]==1) {echo " style='text-decoration:underline;'";}
			  echo ">".stat_format($statLbl,$row[$statLbl])."</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;

		  $prevYr=$yr;
	  }
	  if ($multiRow==1)
	  {
		  $yrQuery="SELECT year";
		  foreach ($statArray as $key => $statLbl)
		  {
			  if ($statLbl=='pahr') {$yrQuery.=",".stat_query($statLbl,"","",.00001)." as $statLbl";}
			  else {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
		  }
		  $yrQuery.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 AND year=$prevYr GROUP BY year";
		  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
		  $yrResult=mysqli_query($db,$yrQuery);
		  $yrRow=mysqli_fetch_array($yrResult);

		  $cls='s';
		  if ((isset($award[5][$prevYr]))||(isset($award[6][$prevYr]))) {$cls='b';}
		  $cls.=($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - Tot";
		  if (isset($award[9][$prevYr])) {echo " (AS)";}
		  echo "</td>\n";
		  echo "<td>$age</td>\n";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td";
			  if ($ll[$prevYr]['b'][$statLbl]==1) {echo " style='text-decoration:underline;'";}
			  echo ">".stat_format($statLbl,$yrRow[$statLbl])."</td>";
		  }
		  echo "</tr>\n";
	  }
	  echo "    <tfoot>\n";
	  ## Per Team
	  $query="SELECT team_id,MIN(year) as minYr,COUNT(DISTINCT year) as yrs";
	  foreach ($statArray as $key => $statLbl)
	  {
		  if ($statLbl=='pahr') {$query.=",".stat_query($statLbl,"","",.00001)." as $statLbl";}
		  else {$query.=",".stat_query($statLbl)." as $statLbl";}
	  }
	  $query.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 GROUP BY team_id ORDER BY minYr,yrs";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  $tmCnt=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $tid=$row['team_id'];

		  $cls='s'.($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' colspan=2 title='".$row['yrs']." season(s)'";
		  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
		  echo ">w/ ".$teams[$tid][$yr]['abbr'];
		  if ((isset($award[5]['team'][$tid]))&&(isset($award[9]['team'][$tid])))
		  {
			  echo " (".$award[5]['team'][$tid]."xBOY, ".$award[9]['team'][$tid]."xAS)";
		  }
		  elseif (isset($award[5]['team'][$tid])) {echo " (".$award[5]['team'][$tid]."xBOY)";}
		  elseif (isset($award[9]['team'][$tid])) {echo " (".$award[9]['team'][$tid]."xAS)";}
		  echo "</td>";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td";
			  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
			  echo ">".stat_format($statLbl,$row[$statLbl])."</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;
		  $tmCnt++;
	  }
	  ## Career Totals
	  $query="SELECT COUNT(DISTINCT year) as yrs";
	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
	  $query.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=1 GROUP BY player_id";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  while ($row=mysqli_fetch_array($result))
	  {
		  #Per162
		  $cls='s'.($rowCnt%2+1);
		  echo "    <tr class='$cls' style='font-style:italic;'>";
		  echo "<td class='".$cls."_l' colspan=2 style='border-bottom:1px solid black;'>Per $avgG games</td>";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  echo "<td style='border-bottom:1px solid black;'>";
			  switch ($statLbl)
			  {
			  case 'pipa':
			  case 'pahr':
			  case 'bbk':
			  case 'sbPct':
			  case 'rc27':
			  case 'bbabip':
			  case 'iso':
				  echo stat_format($statLbl,$row[$statLbl]);
				  break;
			  case 'rc':
			  case 'pwrspd':
				  echo stat_format($statLbl,$row[$statLbl]/$avgRatio);
				  break;
			  default:
				  echo stat_format($statLbl,round($row[$statLbl]/$avgRatio,0));
				  break;
			  }
			  echo "</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;
		  #Career
		  $cls='b'.($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' colspan=2 title='$tmCnt team(s), ".$row['yrs']." season(s)'>Totals</td>";
		  foreach ($statArray as $key => $statLbl) {echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";}
		  echo "</tr>\n";
	  }
	  echo "    </tfoot>\n";
	  echo "   </table>\n";
	  echo "  </td></tr>\n";
	  echo " </table>   <!-- close expanded batting stats -->\n";
	  echo "</div>   <!-- close expanded batting stats -->\n";

	  ## Postseason Batting Stats
	  $statArray=Array("g","ab","h","d","t","hr","rbi","r","bb","hp","sh","sf","k","sb","cs","avg","obp","slg","ops","wOBA");
	  $query="";
	  $query.="SELECT year,team_id";
	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
	  $query.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=21 GROUP BY year,team_id";
	  $query.=" ORDER BY year";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  if (mysqli_num_rows($result)>0)
	  {
		  echo "<div class='textbox'>   <!-- open postseason batting stats -->\n";
		  echo " <table cellpadding=0 cellspacing=0 border=0>   <!-- open postseason batting stats -->\n";
		  echo "  <tr class='title'><td style='padding:2px;'>Postseason Batting Stats</td></tr>\n";
		  echo "  <tr><td>\n";
		  echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' style='width:935px;'>\n";
		  echo "    <thead><tr class='headline'><td class='hsc2_l'>Year/Team</td><td class='hsc2'>Age</td>";
		  foreach ($statArray as $key => $statLbl) {echo "<td class='hsc2' title='".stat_text($statLbl)."'>".stat_text($statLbl,2)."</td>";}
		  echo "</tr></thead>\n";
		  $rowCnt=0;
		  $prevYr=-1;
		  $multiRow=0;
		  while ($row=mysqli_fetch_array($result))
		  {
			  $yr=$row['year'];
			  $tid=$row['team_id'];

			  if (($multiRow==1)&&($yr!=$prevYr))
			  {
				  $yrQuery="";
				  $yrQuery.="SELECT year";
				  foreach ($statArray as $key => $statLbl) {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
				  $yrQuery.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=21 AND year=$prevYr GROUP BY year";
				  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
				  $yrResult=mysqli_query($db,$yrQuery);
				  $yrRow=mysqli_fetch_array($yrResult);

				  $cls='s'.($rowCnt%2+1);
				  echo "    <tr class='$cls'>";
				  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - Tot</td>\n";
				  echo "<td>$age</td>\n";
				  foreach ($statArray as $key => $statLbl)
				  {
					  echo "<td>".stat_format($statLbl,$yrRow[$statLbl])."</td>";
				  }
				  echo "</tr>\n";

				  $rowCnt++;
				  $multiRow=0;
			  }
			  elseif ($yr==$prevYr) {$multiRow=1;}
		
			  unset($yrDate);
			  $age=$ageNow+$yr-$lgyear;

			  $cls='s'.($rowCnt%2+1);
			  echo "    <tr class='$cls'>";
			  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'><a href='./team_summary.php?team_id=$tid&year=$yr'>$yr - ".$teams[$tid][$yr]['abbr']."</a></td>\n";
			  echo "<td>$age</td>\n";
			  foreach ($statArray as $key => $statLbl) 
			  {
				  echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";
			  }
			  echo "</tr>\n";
			  $rowCnt++;

			  $prevYr=$yr;
		  }
		  if ($multiRow==1)
		  {
			  $yrQuery="";
			  $yrQuery.="SELECT year";
			  foreach ($statArray as $key => $statLbl) {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
			  $yrQuery.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=21 AND year=$prevYr GROUP BY year";
			  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
			  $yrResult=mysqli_query($db,$yrQuery);
			  $yrRow=mysqli_fetch_array($yrResult);

			  $cls='s'.($rowCnt%2+1);
			  echo "    <tr class='$cls'>";
			  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - Tot</td>\n";
			  echo "<td>$age</td>\n";
			  foreach ($statArray as $key => $statLbl) 
			  {
				  echo "<td>".stat_format($statLbl,$yrRow[$statLbl])."</td>";
			  }
			  echo "</tr>\n";
		  }
		  echo "    <tfoot>\n";
		  ## Per Team
		  $query="";
		  $query.="SELECT team_id,MIN(year) as minYr,COUNT(DISTINCT year) as yrs";
		  foreach ($statArray as $key => $statLbl)
		  {
			  if ($statLbl=='pahr') {$query.=",".stat_query($statLbl,"","",.00001)." as $statLbl";}
			  else {$query.=",".stat_query($statLbl)." as $statLbl";}
		  }
		  $query.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=21 GROUP BY team_id";
		  $query.=" ORDER BY minYr,yrs";
		  if ($_GET['showq']==1) {echo "$query<br/>\n";}
		  $result=mysqli_query($db,$query);
		  $tmCnt=0;
		  while ($row=mysqli_fetch_array($result))
		  {
			  $tid=$row['team_id'];

			  $cls='s'.($rowCnt%2+1);
			  echo "    <tr class='$cls'>";
			  echo "<td class='".$cls."_l' colspan=2 title='".$row['yrs']." season(s)'";
			  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
			  echo ">w/ ".$teams[$tid][$yr]['abbr'];
			  echo "</td>";
			  foreach ($statArray as $key => $statLbl) 
			  {
				  echo "<td";
				  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
				  echo ">".stat_format($statLbl,$row[$statLbl])."</td>";
			  }
			  echo "</tr>\n";
			  $rowCnt++;
			  $tmCnt++;
		  }
		  ## Career Totals
		  $query="";
		  $query.="SELECT player_id,COUNT(DISTINCT year) as yrs";
		  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
		  $query.=" FROM players_career_batting_stats WHERE player_id=$pid AND league_id=$lgid AND split_id=21 GROUP BY player_id";
		  if ($_GET['showq']==1) {echo "$query<br/>\n";}
		  $result=mysqli_query($db,$query);
		  while ($row=mysqli_fetch_array($result))
		  {
			  #Per162
			  $avgRatio=$row['g']/$avgG;
			  $cls='s'.($rowCnt%2+1);
			  echo "    <tr class='$cls' style='font-style:italic;'>";
			  echo "<td class='".$cls."_l' colspan=2 style='border-bottom:1px solid black;'>Per $avgG games</td>";
			  foreach ($statArray as $key => $statLbl) 
			  {
				  echo "<td style='border-bottom:1px solid black;'>";
				  switch ($statLbl)
				  {
				  case 'avg':
				  case 'obp':
				  case 'slg':
				  case 'ops':
				  case 'wOBA':
					  echo stat_format($statLbl,$row[$statLbl]);
					  break;
				  default:
					  echo stat_format($statLbl,round($row[$statLbl]/$avgRatio,0));
					  break;
				  }
				  echo "</td>";
			  }
			  echo "</tr>\n";
			  $rowCnt++;
			  #Career
			  $cls='b'.($rowCnt%2+1);
			  echo "    <tr class='$cls'>";
			  echo "<td class='".$cls."_l' colspan=2 title='$tmCnt team(s), ".$row['yrs']." season(s)'>Totals</td>";
			  foreach ($statArray as $key => $statLbl) {echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";}
			  echo "</tr>\n";
		  }
		  echo "    </tfoot>\n";
		  echo "   </table>\n";
		  echo "  </td></tr>\n";
		  echo " </table>   <!-- close postseason batting stats -->\n";
		  echo "</div>   <!-- close postseason batting stats -->\n";
	  }
  } 

  ##### Fielding Stats
  $statArray=Array("g","gs","po","a","dp","tc","e","fpct","inn","rng","zr","pb","sba","rto","rtoPct");
  $query="";
  if ($showWS==1) 
  {
	  $query.="SELECT y.*";
	  for ($j=2;$j<=9;$j++) {$query.=",fws$j";}
	  $query.=" FROM (";
  }
  $query.="SELECT year,team_id,position";
  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
  $query.=" FROM players_career_fielding_stats WHERE player_id=$pid AND league_id=$lgid AND split_id<=1 GROUP BY year,team_id,position";
  if ($showWS==1) 
  {
	  $query.=") as y LEFT JOIN (SELECT year,team_id";
	  for ($j=2;$j<=9;$j++) {$query.=",SUM(fws$j) as fws$j";}
	  $query.=" FROM players_win_shares WHERE player_id=$pid GROUP BY year,team_id) as fwsTBL ON y.year=fwsTBL.year AND y.team_id=fwsTBL.team_id";
  }
  $query.=" ORDER BY year,position";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result)>0)
  {
	  echo "<div class='textbox'>   <!-- open fielding stats -->\n";
	  echo " <table cellpadding=0 cellspacing=0 border=0>   <!-- open fielding stats -->\n";
	  echo "  <tr class='title'><td style='padding:2px;'>Fielding Stats</td></tr>\n";
	  echo "  <tr><td>\n";
	  echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' style='width:935px;'>\n";
	  echo "    <thead><tr class='headline'><td class='hsc2_l'>Year/Team</td><td class='hsc2'>Age</td><td class='hsc2'>Pos</td>";
	  foreach ($statArray as $key => $statLbl) {echo "<td class='hsc2' title='".stat_text($statLbl)."'>".stat_text($statLbl,2)."</td>";}
	  if ($showWS==1) {echo "<td class='hsc2' title='Fielding Win Shares'>WS</td>";}
	  echo "</tr></thead>\n";
	  $rowCnt=0;
	  $prevYr=-1;
	  $prevPos=-1;
	  $multiRow=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $yr=$row['year'];
		  $tid=$row['team_id'];
		  $pos=$row['position'];

		  if (($multiRow==1)&&(($yr!=$prevYr)||($pos!=$prevPos)))
		  {
			  $yrQuery="";
			  if (($showWS==1)&&($prevPos!=1)) {$yrQuery.="SELECT y.*,fws$prevPos FROM (";}
			  $yrQuery.="SELECT player_id,year,position";
			  foreach ($statArray as $key => $statLbl) {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
			  $yrQuery.=" FROM players_career_fielding_stats WHERE player_id=$pid AND league_id=$lgid AND split_id<=1 AND year=$prevYr AND position=$prevPos GROUP BY year,position";
			  if (($showWS==1)&&($prevPos!=1)) {$yrQuery.=") as y LEFT JOIN (SELECT player_id,SUM(fws$prevPos) as fws$prevPos FROM players_win_shares WHERE player_id=$pid AND year=$prevYr GROUP BY player_id) as fwsTBL ON y.player_id=fwsTBL.player_id";}
			  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
			  $yrResult=mysqli_query($db,$yrQuery);
			  $yrRow=mysqli_fetch_array($yrResult);

			  $cls='s';
			  if (isset($award[7][$prevYr][$tid][$prevPos])) {$cls='b';}
			  $cls.=($rowCnt%2+1);
			  echo "    <tr class='$cls'>";
			  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - ".get_pos($prevPos,1)." Tot";
			  if (isset($award[9][$prevYr])) {echo " (AS)";}
			  echo "</td>\n";
			  echo "<td>$age</td>\n";
			  echo "<td sorttable_customkey='$prevPos'>".get_pos($prevPos,1)."</td>";
			  foreach ($statArray as $key => $statLbl) 
			  {
				  if (($pos!=2)&&(($statLbl=='pb')||($statLbl=='sba')||($statLbl=='rto')||($statLbl=='rtoPct'))) {echo "<td>&nbsp;</td>";}
				  else {echo "<td>".stat_format($statLbl,$yrRow[$statLbl])."</td>";}
			  }
			  if ($showWS==1) 
			  {
				  echo "<td>";
				  if ($yrRow['fws'.$prevPos]=="") {echo '&nbsp;';} else {echo stat_format('fws'.$prevPos,$yrRow['fws'.$prevPos]);}
				  echo "</td>";
			  }
			  echo "</tr>\n";

			  $rowCnt++;
			  $multiRow=0;
		  }
		  elseif (($yr==$prevYr)&&($prevPos==$pos)) {$multiRow=1;}

		  unset($yrDate);
		  $age=$ageNow+$yr-$lgyear;

		  $cls='s';
		  if (isset($award[7][$yr][$tid][$pos])) {$cls='b';}
		  $cls.=($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'><a href='./team_summary.php?team_id=$tid&year=$yr'>$yr - ".$teams[$tid][$yr]['abbr']."</a></td>\n";
		  echo "<td>$age</td>\n";
		  echo "<td sorttable_customkey='$pos'>".get_pos($pos,1)."</td>";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  if (($pos!=2)&&(($statLbl=='pb')||($statLbl=='sba')||($statLbl=='rto')||($statLbl=='rtoPct'))) {echo "<td>&nbsp;</td>";}
			  else {echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";}
		  }
		  if ($showWS==1) 
		  {
			  echo "<td>";
			  if ($row['fws'.$pos]=="") {echo '&nbsp;';} else {echo stat_format('fws'.$pos,$row['fws'.$pos]);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;

		  $prevYr=$yr;
		  $prevPos=$pos;
	  }
	  if ($multiRow==1)
	  {
		  $yrQuery="";
		  if (($showWS==1)&&($prevPos!=1)) {$yrQuery.="SELECT y.*,fws$prevPos FROM (";}
		  $yrQuery.="SELECT player_id,year,position";
		  foreach ($statArray as $key => $statLbl) {$yrQuery.=",".stat_query($statLbl)." as $statLbl";}
		  $yrQuery.=" FROM players_career_fielding_stats WHERE player_id=$pid AND league_id=$lgid AND split_id<=1 AND year=$prevYr AND position=$prevPos GROUP BY year,position";
		  if (($showWS==1)&&($prevPos!=1)) {$yrQuery.=") as y LEFT JOIN (SELECT player_id,SUM(fws$prevPos) as fws$prevPos FROM players_win_shares WHERE player_id=$pid AND year=$prevYr GROUP BY player_id) as fwsTBL ON y.player_id=fwsTBL.player_id";}
		  if ($_GET['showq']==1) {echo "$yrQuery<br/>\n";}
		  $yrResult=mysqli_query($db,$yrQuery);
		  $yrRow=mysqli_fetch_array($yrResult);

		  $cls='s';
		  if (isset($award[7][$prevYr][$tid][$prevPos])) {$cls='b';}
		  $cls.=($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' sorttable_customkey='$rowCnt'>$prevYr - ".get_pos($prevPos,1)." Tot";
		  if (isset($award[9][$prevYr])) {echo " (AS)";}
		  echo "</td>\n";
		  echo "<td>$age</td>\n";
		  echo "<td sorttable_customkey='$prevPos'>".get_pos($prevPos,1)."</td>";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  if (($pos!=2)&&(($statLbl=='pb')||($statLbl=='sba')||($statLbl=='rto')||($statLbl=='rtoPct'))) {echo "<td>&nbsp;</td>";}
			  else {echo "<td>".stat_format($statLbl,$yrRow[$statLbl])."</td>";}
		  }
		  if ($showWS==1) 
		  {
			  echo "<td>";
			  if ($yrRow['fws'.$prevPos]=="") {echo '&nbsp;';} else {echo stat_format('fws'.$prevPos,$yrRow['fws'.$prevPos]);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
	  }
	  echo "    <tfoot>\n";
	  ## Per Position
	  $query="";
	  if ($showWS==1) 
	  {
		  $query.="SELECT y.*";
		  for ($j=2;$j<=9;$j++) {$query.=",fws$j";}
		  $query.=" FROM (";
	  }
	  $query.="SELECT player_id,position,MIN(year) as minYr,COUNT(DISTINCT year) as yrs";
	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}
	  $query.=" FROM players_career_fielding_stats WHERE player_id=$pid AND league_id=$lgid AND split_id<=1 GROUP BY position";
	  if ($showWS==1) 
	  {
		  $query.=") as y LEFT JOIN (SELECT player_id";
		  for ($j=2;$j<=9;$j++) {$query.=",SUM(fws$j) as fws$j";}
		  $query.=" FROM players_win_shares WHERE player_id=$pid GROUP BY player_id) as fwsTBL ON y.player_id=fwsTBL.player_id";
	  }
	  $query.=" ORDER BY position";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  $tmCnt=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $pos=$row['position'];

		  $cls='s';
		  if (isset($award[7]['pos'][$pos])) {$cls='b';}
		  $cls.=($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' title='".$row['yrs']." season(s)'";
		  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
		  echo ">".get_pos($pos)."</td>";
		  echo "<td colspan=2";
		  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
		  echo ">";
		  if (isset($award[7]['pos'][$pos])) 
		  {
			  echo $award[7]['pos'][$pos]." Award";
			  if ($award[7]['pos'][$pos]>1) {echo "s";}
		  }
		  else {echo "&nbsp;";}
		  echo "</td>";
		  foreach ($statArray as $key => $statLbl) 
		  {
			  if (($pos!=2)&&(($statLbl=='pb')||($statLbl=='sba')||($statLbl=='rto')||($statLbl=='rtoPct'))) 
			  {
				  echo "<td";
				  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
				  echo ">&nbsp;</td>";
			  }
			  else
			  {
				  echo "<td";
				  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
				  echo ">".stat_format($statLbl,$row[$statLbl])."</td>";
			  }
		  }
		  if ($showWS==1) 
		  {
			  echo "<td";
			  if ($tmCnt==0) {echo " style='border-top:1px solid black;'";}
			  echo ">";
			  if ($row['fws'.$pos]=="") {echo '&nbsp;';} else {echo stat_format('fws'.$pos,$row['fws'.$pos]);}
			  echo "</td>";
		  }
		  echo "</tr>\n";
		  $rowCnt++;
		  $tmCnt++;
	  }
	  echo "    </tfoot>\n";
	  echo "   </table>\n";
	  echo "  </td></tr>\n";
	  echo " </table>   <!-- close fielding stats -->\n";
	  echo "</div>   <!-- close fielding stats -->\n";
  }

  ##### Leaderboard Appearances
  $query="SELECT year,category,place,amount FROM players_league_leader WHERE player_id=$pid AND league_id=$lgid ORDER BY category, year;";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  echo "<div class='textbox'>   <!-- open leaderboards -->\n";
	  echo " <table cellpadding=2 cellspacing=0 border=0 style='width:935px;'>   <!-- open leaderboards -->\n";
	  echo "  <tr class='title'><td>Leaderboard Appearances</td></tr>\n";
	  echo "  <tr><td>\n";
       	  echo "   <div style='padding:10px 0px 10px 10px;'>\n";
	  echo "    <table cellpadding=0 cellspacing=0 border=0 width='920px'>\n";
       	  echo "     <tr>\n";

	  $rowCnt=0;
       	  $prevCat=-1;
	  while ($row=mysqli_fetch_array($result))
      	  {
		  $yr=$row['year'];
	    	  $place=$row['place'];
		  $val=$row['amount'];
	    	  $cat=$row['category'];
		  $catName=get_ll_cat($cat);
		  $statLbl=get_ll_cat($cat,1);

		  if ($prevCat!=$cat)
	   	  {
			  if ($rowCnt>0)
		 	  {
				  echo "       </table>\n";
		       		  echo "      </td>\n";
			  }
		  	  if ((($rowCnt%5)==0) && ($rowCnt>0))
			  {
		       		  echo "     </tr>\n";
				  echo "     <tr><td colspan=5>&nbsp;</td></tr>\n";
		       		  echo "     <tr>\n";
			  }
		  	  echo "      <td valign='top'>\n";
			  echo "       <table cellpadding=2 cellspacing=0 width='168px' style='border:1px solid black;'>\n";
		  	  echo "        <tr class='title'><td>Year</td><td style='text-align:right;' title='".stat_text($statLbl)."'>$catName</td><td style='text-align:right;'>Rank</td></tr>\n";
			  $catCnt=0;
		  	  $rowCnt++;
		  }

		  $val=stat_format($statLbl,$val);
		  
		  if ($place==1) {$cls='b'.($catCnt%2+1);}
		  else {$cls='s'.($catCnt%2+1);}
    		  echo "        <tr class='$cls'><td class='".$cls."_l'>$yr</td><td>$val</td><td>$place</td></tr>\n";

		  $prevCat=$cat;
	    	  $catCnt++;
	  }

	  echo "      </table>\n";
       	  echo "     </td>\n";

	  if (($rowCnt%5)!=0)
      	  {
		  for ($i=0;$i<(5-($rowCnt%5));$i++)
	   	  {
			  echo "      <td valign='top'>\n";
		 	  echo "       <table cellpadding=2 cellspacing=0 width='168px'>\n";
			  echo "        <tr><td>&nbsp;</td></tr>\n";
		 	  echo "       </table>\n";
			  echo "      </td>\n";
	   	  }
	  }

	  echo "     </tr>\n";
       	  echo "    </table>\n";
	  echo "   </div>\n";
       	  echo "  </td></tr>\n";
	  echo " </table>   <!-- close leaderboards -->\n";
	  echo "</div>   <!-- close leaderboards -->\n";
  }

  ##### Open Container Div
  echo "<div class='textbox' style='padding:0px;margin:0px;border:0px;'>   <!-- container for metrics/SS Scores -->\n";

  ##### Career Metrics
  echo "<div class='textbox'>   <!-- open career metrics -->\n";
  echo " <table cellpadding=2 cellspacing=0 border=0 style='width:250px;'>   <!-- open career metrics -->\n";
  echo "  <tr class='title'><td colspan=2>Career Metrics</td></tr>\n";
  $rowCnt=0;
  ## Ink Scores
  $query="SELECT player_id,SUM(bink) as bink,SUM(gink) as gink FROM (SELECT player_id,category,place,if(place=1,1,0) as bink,if(place<11,1,0) as gink FROM players_league_leader WHERE league_id=$lgid AND category IN (0,2,7,27,28,56) AND player_id=$pid UNION SELECT player_id,category,place,if(place=1,2,0) as bink,if(place<11,2,0) as gink FROM players_league_leader WHERE league_id=$lgid AND category IN (6,9,12,46,47,54) AND player_id=$pid UNION SELECT player_id,category,place,if(place=1,3,0) as bink,if(place<11,3,0) as gink FROM players_league_leader WHERE league_id=$lgid AND category IN (3,11,20,31,32,34) AND player_id=$pid UNION SELECT player_id,category,place,if(place=1,4,0) as bink,if(place<11,4,0) as gink FROM players_league_leader WHERE league_id=$lgid AND category IN (8,10,18,29,38,40) AND player_id=$pid) as t GROUP BY player_id";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  $row=mysqli_fetch_array($result);
	  $cls='s'.($rowCnt%2+1);
	  echo "  <tr class='$cls'><td class='".$cls."_l'>Black Ink</td><td>".$row['bink']."</td></tr>\n";
	  $rowCnt++;
	  $cls='s'.($rowCnt%2+1);
	  echo "  <tr class='$cls'><td class='".$cls."_l'>Gray Ink</td><td>".$row['gink']."</td></tr>\n";
	  $rowCnt++;
  }
  else
  {
	  $cls='s'.($rowCnt%2+1);
	  echo "  <tr class='$cls'><td class='".$cls."_l'>Black Ink</td><td>0</td></tr>\n";
	  $rowCnt++;
	  $cls='s'.($rowCnt%2+1);
	  echo "  <tr class='$cls'><td class='".$cls."_l'>Gray Ink</td><td>0</td></tr>\n";
	  $rowCnt++;
  }
  ## Batting HOF Standards
  $query="SELECT x.player_id,if(h<1500,0,FLOOR((if(h>3000,3000,h)-1500)/150))+if(r<900,0,FLOOR((if(r>1700,1700,r)-900)/100))+if(rbi<800,0,FLOOR((if(rbi>1600,1600,rbi)-800)/100))+FLOOR(hr/200)+if(ebh<300,0,FLOOR((if(ebh>1300,1300,ebh)-300)/200))+if(bb<300,0,FLOOR((if(bb>1300,1300,bb)-300)/200))+FLOOR(if(sb>500,500,sb)/100)+if(pa>=$minCarPA,if(avg<.275,0,FLOOR((if(avg>.320,.320,avg)-.275)/.005)),0)+if(pa>=$minCarPA,if(avg>=.300,1,0),0)+if(pa>=$minCarPA,if(rRate>=.500,1,0),0)+if(pa>=$minCarPA,if(rRate>=.644,1,0),0)+if(pa>=$minCarPA,if(rbiRate>=.500,1,0),0)+if(pa>=$minCarPA,if(rbiRate>=.600,1,0),0)+if(pa>=$minCarPA,if(slg<.300,0,FLOOR((if(slg>.550,.550,slg)-.300)/.025)),0)+if(pa>=$minCarPA,if(obp<.300,0,FLOOR((if(obp>.400,.400,obp)-.300)/.010)),0)+if(pa>=$minCarPA,if(hrPct>=.10,1,0),0)+if(pa>=$minCarPA,if(hrPct>=.20,1,0),0)+if(((position IS NULL) OR (pa>ip)),0,if(position=2,20,if(position=6,16,if(position=4,14,if(position=5,13,if(position=8,12,if(position=9,6,if(position=7,3,1)))))))) as hofStandards FROM (SELECT t1.*,position,ip FROM (SELECT player_id,SUM(g) as g,SUM(pa) as pa,SUM(ab) as ab,SUM(h) as h,SUM(r) as r,SUM(rbi) as rbi,SUM(hr) as hr,SUM(d)+SUM(t)+SUM(hr) as ebh,SUM(bb) as bb,SUM(sb) as sb,if(SUM(ab)=0,0,SUM(h)/SUM(ab)) as avg,if(SUM(g)=0,0,SUM(r)/SUM(g)) as rRate,if(SUM(g)=0,0,SUM(rbi)/SUM(g)) as rbiRate,if(SUM(ab)=0,0,(SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab)) as slg,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))) as obp,if(SUM(h)=0,0,SUM(hr)/SUM(h)) as hrPct FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND player_id=$pid GROUP BY player_id) as t1 LEFT JOIN (SELECT player_id,position,ip,SUM(ip) as totalIP FROM (SELECT player_id,position,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position>1 AND player_id=$pid GROUP BY player_id,position ORDER BY player_id,ip DESC) as y GROUP BY player_id) as t2 ON t1.player_id=t2.player_id) as x";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  $row=mysqli_fetch_array($result);
	  if ($row['hofStandards']>0)
	  {
		  $cls='s'.($rowCnt%2+1);
		  echo "  <tr class='$cls' title='$minCarPA PA needed for rate stats'><td class='".$cls."_l'>HOF Standards (batting)</td><td>".$row['hofStandards']."</td></tr>\n";
		  $rowCnt++;
	  }
  }
  ## Pitching HOF Standards
  $query="SELECT x.player_id,if(w<100,0,FLOOR((if(w>350,350,w)-100)/10))+if(gm500<0,0,FLOOR(if(gm500>200,200,gm500)/20))+if(k<1000,0,FLOOR((if(k>3000,3000,k)-1000)/200))+if(ip<1000,0,FLOOR((if(ip>6000,6000,ip)-1000)/1000))+if(cg<200,0,FLOOR((if(cg>700,700,cg)-200)/100))+FLOOR(if(sho>150,150,sho)/30)+if(ip>=$minCarIP,if(winPct<.500,0,FLOOR((if(winPct>.700,.700,winPct)-.500)/.013)),0)+if(ip>=$minCarIP,if(era>4.00,0,FLOOR((4.00-if(era<2.00,2.00,era))/.20)),0)+if(ip>=$minCarIP,if(bbper9>4.00,0,FLOOR((4.00-if(bbper9<1.00,1.00,bbper9))/.30)),0)+if(ip>=$minCarIP,if(hper9>10.00,0,FLOOR((10.00-if(hper9<7.00,7.00,hper9))/.30)),0) as hofStandards FROM (SELECT player_id,SUM(w) as w,SUM(w)-SUM(l) as gm500,SUM(k) as k,SUM(ip)+SUM(ipf)/3 as ip,SUM(cg) as cg,SUM(sho) as sho,if(SUM(w)+SUM(l)=0,0,SUM(w)/(SUM(w)+SUM(l))) as winPct,if(SUM(ip)+SUM(ipf)/3=0,0,9*SUM(er)/(SUM(ip)+SUM(ipf)/3)) as era,if(SUM(ip)+SUM(ipf)/3=0,0,9*SUM(bb)/(SUM(ip)+SUM(ipf)/3)) as bbper9,if(SUM(ip)+SUM(ipf)/3=0,0,9*SUM(ha)/(SUM(ip)+SUM(ipf)/3)) as hper9 FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND player_id=$pid GROUP BY player_id) as x";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  $row=mysqli_fetch_array($result);
	  if ($row['hofStandards']>0)
	  {
		  $cls='s'.($rowCnt%2+1);
		  echo "  <tr class='$cls' title='$minCarIP IP needed for rate stats'><td class='".$cls."_l'>HOF Standards (pitching)</td><td>".$row['hofStandards']."</td></tr>\n";
		  $rowCnt++;
	  }
  }
  echo " </table>   <!-- close career metrics -->\n";
  echo "</div>   <!-- close career metrics -->\n";


  ##### Similarity Scores
  ## Pitching
  $query="SELECT first_name,last_name,hall_of_fame,player_id2 as player_id,x.ss FROM players,(SELECT p1.player_id as player_id1,p2.player_id as player_id2,1000-ABS(p1.w-p2.w)-FLOOR(ABS(p1.l-p2.l)/2)-if(((p1.role='RP')AND(p2.role='RP')),IF(FLOOR(ABS(p1.winPct-p2.winPct)/.004)>FLOOR(1.5*ABS(p1.w-p2.w)+FLOOR(ABS(p1.l-p2.l)/2)),FLOOR(1.5*ABS(p1.w-p2.w)+FLOOR(ABS(p1.l-p2.l)/2)),FLOOR(ABS(p1.winPct-p2.winPct)/.004)),IF(ABS(p1.winPct-p2.winPct)>.2,100,FLOOR(ABS(p1.winPct-p2.winPct)/.002)))-IF(ABS(p1.era-p2.era)>2,100,FLOOR(ABS(p1.era-p2.era)/.02))-FLOOR(ABS(p1.g-p2.g)/10)-FLOOR(ABS(p1.gs-p2.gs)/20)-FLOOR(ABS(p1.cg-p2.cg)/20)-FLOOR(ABS(p1.ip-p2.ip)/50)-FLOOR(ABS(p1.ha-p2.ha)/50)-FLOOR(ABS(p1.k-p2.k)/30)-FLOOR(ABS(p1.bb-p2.bb)/10)-FLOOR(ABS(p1.sho-p2.sho)/5)-FLOOR(ABS(p1.s-p2.s)/3)-if(((p1.role='SP')AND(p2.role='SP')AND(p1.throws!=p2.throws)),10,0)-if((((p1.role='RP')OR(p2.role='RP'))AND(p1.throws!=p2.throws)),25,0) as ss FROM (SELECT p.player_id,throws,SUM(w) as w,SUM(l) as l,if(SUM(w)+SUM(l)=0,0,SUM(w)/(SUM(w)+SUM(l))) as winPct,if((SUM(ip)+SUM(ipf)/3)=0,0,9*SUM(er)/(SUM(ip)+SUM(ipf)/3)) as era,SUM(g) as g,SUM(gs) as gs,SUM(cg) as cg,SUM(ip)+SUM(ipf)/3 as ip,SUM(ha) as ha,SUM(k) as k,SUM(bb) as bb,SUM(sho) as sho,SUM(s) as s,IF((((g-gs)>gs) AND (((SUM(ip)+SUM(ipf)/3)/SUM(g))<4) ),'RP','SP') as role FROM players as p,players_career_pitching_stats as pcs WHERE p.player_id=pcs.player_id AND p.player_id=$pid AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(IP)>=100) as p1,(SELECT p.player_id,throws,SUM(w) as w,SUM(l) as l,if(SUM(w)+SUM(l)=0,0,SUM(w)/(SUM(w)+SUM(l))) as winPct,if((SUM(ip)+SUM(ipf)/3)=0,0,9*SUM(er)/(SUM(ip)+SUM(ipf)/3)) as era,SUM(g) as g,SUM(gs) as gs,SUM(cg) as cg,SUM(ip)+SUM(ipf)/3 as ip,SUM(ha) as ha,SUM(k) as k,SUM(bb) as bb,SUM(sho) as sho,SUM(s) as s,IF((((g-gs)>gs) AND (((SUM(ip)+SUM(ipf)/3)/SUM(g))<4) ),'RP','SP') as role FROM players as p,players_career_pitching_stats as pcs WHERE p.player_id=pcs.player_id AND p.player_id!=$pid AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id HAVING SUM(IP)>=100) as p2 WHERE p1.player_id!=p2.player_id ORDER BY ss DESC LIMIT 10) as x WHERE players.player_id=x.player_id2 ORDER BY ss DESC";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  echo "<div class='textbox' style='float:left;clear:right;margin-left:10px;'>   <!-- open similarity scores -->\n";
	  echo " <table cellpadding=2 cellspacing=0 border=0 style='width:250px;'>   <!-- open similarity scores -->\n";
	  echo "  <tr class='title'><td colspan=2 title='Minimum 100 IP'>Similar Pitchers</td></tr>\n";
	  echo "  <tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2'>Score</td></tr>\n";
	  $rowCnt=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $player_id=$row['player_id'];
		  $cls='s'.($rowCnt%2+1);
		  echo "  <tr class='$cls'>";
		  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$player_id'>".$row['first_name']." ".$row['last_name'];
		  if ($row['hall_of_fame']==1) {echo "<sup>HOF</sup>";}
		  echo "</td>";
		  echo "<td>".$row['ss']."</td>";
		  echo "</tr>\n";
		  $rowCnt++;
	  }
	  echo " </table>   <!-- close similarity scores -->\n";
	  echo "</div>   <!-- close similarity scores -->\n";
  }
  ## Batting
  $query="SELECT player_id2 as player_id,first_name,last_name,hall_of_fame,position2,ss-12*ABS(if(((x.position IS NULL) OR (pa1>ip) OR (x.position=1)),0,if(x.position=2,20,if(x.position=6,16,if(x.position=4,14,if(x.position=5,13,if(x.position=8,12,if(x.position=9,6,if(x.position=7,3,1))))))))-if(((position2 IS NULL) OR (pa2>ip2) OR (position2=1)),0,if(position2=2,20,if(position2=6,16,if(position2=4,14,if(position2=5,13,if(position2=8,12,if(position2=9,6,if(position2=7,3,1))))))))) as ss FROM players,(SELECT pss.*,pfs.position as position2,pfs.ip as ip2 FROM (SELECT p1.player_id as player_id1,p1.position,p1.ip,p2.player_id as player_id2,p1.pa as pa1,p2.pa as pa2,1000-(ABS(p1.g-p2.g)/20)-(ABS(p1.ab-p2.ab)/75)-(ABS(p1.r-p2.r)/10)-(ABS(p1.h-p2.h)/15)-(ABS(p1.d-p2.d)/5)-(ABS(p1.t-p2.t)/4)-(ABS(p1.hr-p2.hr)/2)-(ABS(p1.rbi-p2.rbi)/10)-(ABS(p1.bb-p2.bb)/25)-(ABS(p1.k-p2.k)/150)-(ABS(p1.sb-p2.sb)/20)-(ABS(p1.avg-p2.avg)/.001)-(ABS(p1.slg-p2.slg)/.002) as ss FROM (SELECT p.position,p.ip,p.totalIP,pcs.* FROM (SELECT player_id,position,ip,SUM(ip) as totalIP FROM (SELECT player_id,position,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND player_id=$pid GROUP BY player_id,position ORDER BY player_id,ip DESC) as y GROUP BY player_id) as p RIGHT JOIN (SELECT player_id,SUM(pa) as pa,SUM(g) as g,SUM(ab) as ab,SUM(r) as r,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(rbi) as rbi,SUM(bb) as bb,SUM(k) as k,SUM(sb) as sb,if(SUM(ab)=0,0,SUM(h)/SUM(ab)) as avg,if(SUM(ab)=0,0,(SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab)) as slg  FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND player_id=$pid GROUP BY player_id HAVING SUM(pa)>=500) as pcs ON p.player_id=pcs.player_id) as p1,(SELECT player_id,SUM(pa) as pa,SUM(g) as g,SUM(ab) as ab,SUM(r) as r,SUM(h) as h,SUM(d) as d,SUM(t) as t,SUM(hr) as hr,SUM(rbi) as rbi,SUM(bb) as bb,SUM(k) as k,SUM(sb) as sb,if(SUM(ab)=0,0,SUM(h)/SUM(ab)) as avg,if(SUM(ab)=0,0,(SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab)) as slg FROM players_career_batting_stats as pcs WHERE league_id=$lgid AND split_id=1 AND player_id!=$pid GROUP BY player_id HAVING SUM(PA)>=500) as p2 WHERE p1.player_id!=p2.player_id ORDER BY ss DESC LIMIT 300) as pss LEFT JOIN (SELECT player_id,position,ip,SUM(ip) as totalIP FROM (SELECT player_id,position,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND player_id!=$pid GROUP BY player_id,position ORDER BY player_id,ip DESC) as y GROUP BY player_id)  as pfs ON pss.player_id2=pfs.player_id ORDER BY ss DESC) as x WHERE players.player_id=x.player_id2 ORDER BY ss DESC LIMIT 10";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  echo "<div class='textbox' style='float:left;clear:right;margin-left:10px;'>   <!-- open similarity scores -->\n";
	  echo " <table cellpadding=2 cellspacing=0 border=0 style='width:250px;'>   <!-- open similarity scores -->\n";
	  echo "  <tr class='title'><td colspan=2 title='Minimum 500 PA'>Similar Batters</td></tr>\n";
	  echo "  <tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2'>Score</td></tr>\n";
	  $rowCnt=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $player_id=$row['player_id'];
		  $cls='s'.($rowCnt%2+1);
		  echo "  <tr class='$cls'>";
		  echo "<td class='".$cls."_l'>";
		  echo get_pos($row['position2'],1)." ";
		  echo "<a href='./player.php?player_id=$player_id'>".$row['first_name']." ".$row['last_name'];
		  if ($row['hall_of_fame']==1) {echo "<sup>HOF</sup>";}
		  echo "</td>";
		  echo "<td>".round($row['ss'],0)."</td>";
		  echo "</tr>\n";
		  $rowCnt++;
	  }
	  echo " </table>   <!-- close similarity scores -->\n";
	  echo "</div>   <!-- close similarity scores -->\n";
  }

  ##### Close Container Div
  echo "</div>   <!-- close container for metrics/SS Scores -->\n";

  ##### Trades #####
  $query="SELECT * FROM trade_history as th WHERE player_id_0_0=$pid OR player_id_0_1=$pid OR player_id_0_2=$pid OR player_id_0_3=$pid OR player_id_0_4=$pid OR player_id_1_0=$pid OR player_id_1_1=$pid OR player_id_1_2=$pid OR player_id_1_3=$pid OR player_id_1_4=$pid ORDER BY th.date";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {

	  echo "<div class='textbox'>\n";
	  echo " <table cellpadding=4 cellspacing=0 border=0 width='935px'>\n";
	  echo "  <tr class='title'><td colspan=5 style='padding:2px;'>Trades</td></tr>\n";
	  echo "  <tr class='headline'><td class='hsc2_l'>Date</td><td class='hsc2_l'>Traded By</td><td class='hsc2_l'>With</td><td class='hsc2_l'>Traded To</td><td class='hsc2_l'>For</td></tr>\n";

	  $rowCnt=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $cls='s'.($rowCnt%2+1);

		  echo "  <tr class='$cls' style='vertical-align:top;'>";
		  if (isset($trdDate)) {unset($trdDate);}
		  $trdDate=new Date($row['date']);
		  $year=$trdDate->format("Y");
		  echo "<td class='".$cls."_l'>".$trdDate->format("F jS, Y")."</td>\n";

		  if (($row['player_id_0_0']==$pid)||($row['player_id_0_1']==$pid)||($row['player_id_0_2']==$pid)||($row['player_id_0_3']==$pid)||($row['player_id_0_4']==$pid)) {$idx=0;} else {$idx=1;}
		  $frTid=$row['team_id_'.$idx];
		  $toTid=$row['team_id_'.abs($idx-1)];

		  if (!isset($teams[$frTid][$year]['name']))
		  {
			  $tQuery="SELECT name,nickname,abbr FROM team";
			  if ($year==$lgyear) {$tQuery.="s WHERE team_id=$frTid";}
			  else {$tQuery.="_history WHERE team_id=$toTid AND year=$year";}
			  $tResult=mysqli_query($db,$tQuery);
			  if (mysqli_num_rows($tResult))
			  {
				  $tRow=mysqli_fetch_array($tResult);
				  $teams[$frTid][$year]['city']=$tRow['name'];
				  $teams[$frTid][$year]['name']=$tRow['name']." ".$tRow['nickname'];
				  $teams[$frTid][$year]['abbr']=$tRow['abbr'];
			  }
		  }
		  echo "<td class='".$cls."_l'><a href='./team_summary.php?team_id=$frTid&year=$year'>".$teams[$frTid][$year]['name']."</a></td>";
		  
		   $fnd=0;
		   echo "<td class='".$cls."_l'>";
		   for ($i=0;$i<5;$i++)
		   {
			   if (($row['player_id_'.$idx.'_'.$i]!=0)&&($row['player_id_'.$idx.'_'.$i]!=$pid))
			   {
				   if ($fnd==1) {echo "<br/>";}
				   $fnd=1;
				   $player_id=$row['player_id_'.$idx.'_'.$i];
				   if (!isset($players[$player_id]['name']))
				   {
					   $nQuery="SELECT first_name,last_name,position FROM players WHERE player_id=$player_id";
					   $nResult=mysqli_query($db,$nQuery);
					   if (mysqli_num_rows($nResult))
					   {
						   $nRow=mysqli_fetch_array($nResult);
						   $players[$player_id]['name']=$nRow['first_name']." ".$nRow['last_name'];
						   $players[$player_id]['pos']=$nRow['position'];
					   }
					   else
					   {
						   $players[$player_id]['name']='Out of baseball';
						   $players[$player_id]['pos']=$row['position'];
					   }
				   }
				   echo get_pos($players[$player_id]['pos'],1)." <a href='./player.php?player_id=$player_id'>".$players[$player_id]['name']."</a>";
			   }
		   }
		   for ($i=0;$i<5;$i++)
		   {
			   if ($row['draft_round_'.$idx.'_'.$i]!=0)
			   {
				   if ($fnd==1) {echo "<br/>";}
				   $fnd=1;
				   $rnd=$row['draft_round_'.$idx.'_'.$i];
				   echo ordinal_suffix($rnd)." Round Draft Pick";
			   }
		   }
		   if ($row['cash_'.$idx]!=0)
		   {
			   if ($fnd==1) {echo "<br/>";}
			   $fnd=1;
			   echo stat_format('cash',$row['cash_'.$idx]);
		   }
		   if ($fnd!=1) {echo "-";}

		   echo "</td>\n";

		   if (!isset($teams[$toTid][$year]['name']))
		   {
			   $tQuery="SELECT name,nickname,abbr FROM team";
			   if ($year==$lgyear) {$tQuery.="s WHERE team_id=$toTid";}
			   else {$tQuery.="_history WHERE team_id=$toTid AND year=$year";}
			   $tResult=mysqli_query($db,$tQuery);
			   if (mysqli_num_rows($tResult))
			   {
				   $tRow=mysqli_fetch_array($tResult);
				   $teams[$toTid][$year]['city']=$tRow['name'];
				   $teams[$toTid][$year]['name']=$tRow['name']." ".$tRow['nickname'];
				   $teams[$toTid][$year]['abbr']=$tRow['abbr'];
			   }
		   }
		   echo "<td class='".$cls."_l'><a href='./team_summary.php?team_id=$toTid&year=$year'>".$teams[$toTid][$year]['name']."</a></td>";

		   $idx=abs($idx-1);
		   $fnd=0;
		   echo "<td class='".$cls."_l'>";
		   for ($i=0;$i<5;$i++)
		   {
			   if (($row['player_id_'.$idx.'_'.$i]!=0)&&($row['player_id_'.$idx.'_'.$i]!=$pid))
			   {
				   if ($fnd==1) {echo "<br/>";}
				   $fnd=1;
				   $player_id=$row['player_id_'.$idx.'_'.$i];
				   if (!isset($players[$player_id]['name']))
				   {
					   $nQuery="SELECT first_name,last_name,position FROM players WHERE player_id=$player_id";
					   $nResult=mysqli_query($db,$nQuery);
					   if (mysqli_num_rows($nResult))
					   {
						   $nRow=mysqli_fetch_array($nResult);
						   $players[$player_id]['name']=$nRow['first_name']." ".$nRow['last_name'];
						   $players[$player_id]['pos']=$nRow['position'];
					   }
					   else
					   {
						   $players[$player_id]['name']='Out of baseball';
						   $players[$player_id]['pos']=$row['position'];
					   }
				   }
				   echo get_pos($players[$player_id]['pos'],1)." <a href='./player.php?player_id=$player_id'>".$players[$player_id]['name']."</a>";
			   }
		   }
		   for ($i=0;$i<5;$i++)
		   {
			   if ($row['draft_round_'.$idx.'_'.$i]!=0)
			   {
				   if ($fnd==1) {echo "<br/>";}
				   $fnd=1;
				   $rnd=$row['draft_round_'.$idx.'_'.$i];
				   echo ordinal_suffix($rnd)." Round Draft Pick";
			   }
		   }
		   if ($row['cash_'.$idx]!=0)
		   {
			   if ($fnd==1) {echo "<br/>";}
			   $fnd=1;
			   echo stat_format('cash',$row['cash_'.$idx]);
		   }
		   if ($fnd!=1) {echo "-";}
		   echo "</td>\n";

		   echo "</tr>\n";

		   $rowCnt++;
	   }

	   echo " </table>\n";
	   echo "</div>   <!-- END of Trades -->\n";
   }
 
  mysqli_close($db);

  ################## END OF PAGE #########################
  echo " </div>   <!-- END contentpane DIV -->\n";
  page_foot($_SESSION['lgpath']);


?>
