<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgpath=$_SESSION['lgpath'];

  $date=new Date($_SESSION['lgdate']);

  $lgyear=$_SESSION['lgyear'];

  $lgMo=$date->format("m");



  $player_id=$_GET['player'];

  if (!is_numeric($player_id)) {unset($player_id);}



  $pidTrack=$_GET['pidTrack'];



  ini_set("memory_limit","64M");

  

  ##### Get Report Settings #####

  if ($_SESSION['user_team_id']>0) {$team_id=$_SESSION['user_team_id'];}

  if (isset($_GET['team_id'])) {$team_id=$_GET['team_id'];}

	  

  include($_SESSION['adminpath']."/dbopen.php");

  ##### Get Teams #####

  $query="SELECT team_id,name,nickname,abbr,league_id,level,parent_team_id FROM teams WHERE allstar_team=0 ORDER BY parent_team_id,league_id,name,nickname;";

  if ($_GET['showq']==1) {echo $query."<br/>\n";}

  $result=mysqli_query($db,$query);

  while ($row=mysqli_fetch_array($result))

  {

       	  $tid=$row['team_id'];

	  if ((($team_id=="")||($team_id<1))&&($row['league_id']==$lgid)) {$team_id=$tid;}

	  if (($team_id==$tid)&&($row['league_id']!=$lgid)&&($row['parent_team_id']==$team_id))

	  {

		  $_SESSION['lgid']=$row['league_id'];

		  header("Location: ./payroll.php?team_id=$tid&league_id=".$row['league_id']);

		  exit;

	  }

       	  $teams[$tid]['abbr']=$row['abbr'];

	  $teams[$tid]['league_id']=$row['league_id'];

       	  $teams[$tid]['name']=$row['name']." ".$row['nickname'];

	  $teams[$tid]['level']=get_level($row['level']);

	  $teams[$tid]['parent']=$row['parent_team_id'];

  }

  

  ##### Get Leagues #####

  $query="SELECT league_id,name FROM leagues";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  while ($row=mysqli_fetch_array($result))

  {

	  $league_id=$row['league_id'];

	  $leagues[$league_id]=$row['name'];

  }



  ##### Check If Offseason Prior to Year Rollover #####

  $query="SELECT game_id,date FROM games WHERE league_id=$lgid AND played=0 AND game_type IN (0,3);";

  $result=mysqli_query($db,$query);

  $nRows=mysqli_num_rows($result);

  $query="SELECT MONTH(start_date) as sMo FROM leagues WHERE league_id=$lgid;";

  $result=mysqli_query($db,$query);

  $row=mysqli_fetch_array($result);

  $strtMo=$row['sMo'];

  if (((!$nRows)||($nRows==0))&&($lgMo>=$strtMo)) {$chkYr=$lgyear+1;}

  else {$chkYr=$lgyear;}



  mysqli_close($db);



  # Title Bar

  if ($player_id!="") {$title='Contract Detail';}

  else {$title=$teams[$team_id]['name'].' - Projected Payroll';}



  page_head($title,$_SESSION['lgpath'],"","","./jquery/excanvas.js|./jquery/jquery.min.js|./jquery/jquery.jqplot.min.js|./jquery/plugins/jqplot.barRenderer.min.js|./jquery/plugins/jqplot.categoryAxisRenderer.min.js|./jquery/plugins/jqplot.pointLabels.min.js|./jquery/plugins/jqplot.canvasOverlay.min.js|./jquery/plugins/jqplot.highlighter.min.js|./jquery/plugins/jqplot.cursor.min.js");

  echo " <div id='topbar'>\n";

  if ($player_id!="") {main_titlebar($lgid,$_SESSION['lgpath'],$title);}

  else {main_titlebar($lgid,$_SESSION['lgpath'],$title,$team_id);}

  nav_toolbar('front_office',"Front Office");

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");



  ##### Display Player Info #####

  if ($player_id!="")

  {

	  $pid=$player_id;

       

	  ## Get Player Info

	  $query="SELECT first_name,last_name,position,role,age,team_id,organization_id,date_of_birth FROM players WHERE player_id=$player_id;";

       	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

       	  if (mysqli_num_rows($result))

	  {

		  $row=mysqli_fetch_array($result);

		  $name=$row['first_name']." ".$row['last_name'];

	    	  $bday=new Date($row['date_of_birth']);

		  if ($row['position']==1) {$pos=get_pos($row['role'],1);} else {$pos=get_pos($row['position'],1);}

	    	  $age=$row['age'];

		  $tid=$row['team_id'];

		  $orgID=$row['organization_id'];



		  if ($tid!=$orgID)

		  {

			  if ($teams[$orgID]['league_id']!=$_SESSION['lgid'])

			  {

				  $_SESSION['lgid']=$teams[$orgID]['league_id'];

				  header("Location: ./payroll.php?player_id=$pid");

				  exit;

			  }

		  }

		  else

		  {

			  if ($teams[$tid]['league_id']!=$_SESSION['lgid'])

			  {

				  $_SESSION['lgid']=$teams[$tid]['league_id'];

				  header("Location: ./payroll.php?player_id=$pid");

				  exit;

			  }

		  }

	  }

      	  else  ## Quit if player not found

	  {

		  echo " <div class='textbox' style='border:0;'>Player $player_id not found</div>\n";

	    	  ##### End Page #####

		  echo "</div>   <!-- END contentpane DIV -->\n";

	    	  page_foot($lgpath);

		  exit;

      	  }

       

	  ## Get Player Contract

	  $query="SELECT season_year,last_year_team_option,last_year_player_option,last_year_vesting_option,contract_team_id,no_trade,minimum_pa,minimum_pa_bonus,minimum_ip,minimum_ip_bonus,mvp_bonus,cyyoung_bonus,allstar_bonus,salary0,salary1,salary2,salary3,salary4,salary5,salary6,salary7,salary8,salary9 FROM players_contract WHERE player_id=$pid;";

       	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

       	  $numFields=mysqli_num_fields($result);

	  $row=mysqli_fetch_array($result);

       	  $yrOne=$row['season_year'];

	  $players[$pid]['startYr']=$yrOne;

       	  $tOpt=$row['last_year_team_option'];

	  $pOpt=$row['last_year_player_option'];

       	  $vOpt=$row['last_year_vesting_option'];

      	  $cTeamID=$row['contract_team_id'];

	  $cnoTrade=$row['no_trade'];

       	  $cminPA=$row['minimum_pa'];

	  $cminPAbonus=$row['minimum_pa_bonus'];

       	  $cminIP=$row['minimum_ip'];

	  $cminIPbonus=$row['minimum_ip_bonus'];

       	  $cboyBonus="$".number_format($row['mvp_bonus']);

	  $cpoyBonus="$".number_format($row['cyyoung_bonus']);

	  $casBonus="$".number_format($row['allstar_bonus']);

       	  $opt="";

	  if (($tOpt==1)&&($pOpt==1)) {$opt='mo';}

      	  elseif ($pOpt==1) {$opt='po';}

	  elseif ($tOpt==1) {$opt='to';}

	  elseif ($vOpt==1) {$opt='vo';}

       	  if ($opt!="") {$players[$pid]['last_year_option']=$opt;}

	  $remaining=0;

	  for ($i=13;$i<$numFields;$i++)

      	  {

				$fieldInfo = mysqli_fetch_field_direct( $result, $i);

				$fieldname = $fieldInfo->name;

	    	  $yr=$yrOne+$i-13;

		  $salary=$row[$fieldname];

	    	  $players[$pid][$yr]['salary']=$salary;

		  if ($salary!=0)

	   	  {

			  $players[$pid]['cfinalYr']=$yr;

		 	  $players[$pid]['cTotal']=$players[$pid]['cTotal']+$salary;

			  $players[$pid]['cYrs']=$players[$pid]['cYrs']+1;

		 	  if ($yr>$lgyear) {$remaining+=$salary;}

		  }

      	  }

	  if ($row['salary0']==0) {$mlc=1;} else {$mlc=0;}

	       

	  ## Get Player Contract Extensions

	  $query="SELECT season_year,last_year_team_option,last_year_player_option,last_year_vesting_option,contract_team_id,no_trade,minimum_pa,minimum_pa_bonus,minimum_ip,minimum_ip_bonus,mvp_bonus,cyyoung_bonus,allstar_bonus,salary0,salary1,salary2,salary3,salary4,salary5,salary6,salary7,salary8,salary9 FROM players_contract_extension WHERE player_id=$pid;";

       	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

       	  $numFields=mysqli_num_fields($result);

	  $row=mysqli_fetch_array($result);

       	  $yrOne=$players[$pid]['cfinalYr']+1;

	  $tOpt=$row['last_year_team_option'];

       	  $pOpt=$row['last_year_player_option'];

       	  $vOpt=$row['last_year_vesting_option'];

	  $eTeamID=$row['contract_team_id'];

       	  $enoTrade=$row['no_trade'];

	  $eminPA=$row['minimum_pa'];

       	  $eminPAbonus="$".number_format($row['minimum_pa_bonus']);

	  $eminIP=$row['minimum_ip'];

       	  $eminIPbonus="$".number_format($row['minimum_ip_bonus']);

	  $eboyBonus="$".number_format($row['mvp_bonus']);

       	  $epoyBonus="$".number_format($row['cyyoung_bonus']);

	  $easBonus="$".number_format($row['allstar_bonus']);

	  if ($row['salary0']!=0) {$opt="";}

       	  if (($tOpt==1)&&($pOpt==1)) {$opt='mo';}

	  elseif ($pOpt==1) {$opt='po';}

      	  elseif ($tOpt==1) {$opt='to';}

	  elseif ($vOpt==1) {$opt='vo';}

	  if ($opt!="") {$players[$pid]['last_year_option']=$opt;}

       	  for ($i=13;$i<$numFields;$i++)

	  {

				$fieldInfo = mysqli_fetch_field_direct( $result, $i);

				$fieldname = $fieldInfo->name;

		  $yr=$yrOne+$i-13;

	    	  $salary=$row[$fieldname];

		  $players[$pid][$yr]['salary']=$salary;

	    	  if ($salary!=0)

		  {

		 	  $players[$pid]['efinalYr']=$yr;

			  $players[$pid]['eTotal']=$players[$pid]['eTotal']+$salary;

		 	  $players[$pid]['eYrs']=$players[$pid]['eYrs']+1;

		  }

      	  }

       

	  ## Get Team Information

	  $query="SELECT team_id,name,nickname,abbr,level FROM teams WHERE team_id IN ($tid,$orgID,$cTeamID,$eTeamID);";

       	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

       	  while ($row=mysqli_fetch_array($result))

	  {

	    	  $teamID=$row['team_id'];

		  $teams[$teamID]['name']=$row['name']." ".$row['nickname'];

	    	  $teams[$teamID]['abbr']=$row['abbr'];

		  $teams[$teamID]['level']=get_level($row['level']);

      	  }

       

	  ## Get Remaining Salary from This Year

	  if ($players[$pid][$lgyear]['salary']>0)

      	  {

		  $query="SELECT g FROM team_record WHERE team_id=$orgID;";

	    	  $result=mysqli_query($db,$query);

		  $row=mysqli_fetch_array($result);

	    	  $tg=$row['g'];

		  $query="SELECT COUNT(DISTINCT game_id) as tg FROM games WHERE (home_team=$orgID OR away_team=$orgID) AND game_type=0;";

	    	  $result=mysqli_query($db,$query);

		  $row=mysqli_fetch_array($result);

	    	  $totg=$row['tg'];

		  $remg=$totg-$tg;

	    

		  $salary=$players[$pid][$lgyear]['salary'];

		  $salPerG=$salary/$totg;

	    	  $remaining+=ceil($salPerG*$remg);

	    

		  ## Check Playing Time For PT Clauses

		  if ($cminIP>0)

	   	  {

			  $query="SELECT SUM(ip)+SUM(ipf)/3 as ip FROM players_career_pitching_stats WHERE player_id=$pid AND year=$lgyear AND split_id=1 AND league_id=$lgid GROUP BY player_id;";

		 	  $result=mysqli_query($db,$query);

			  $row=mysqli_fetch_array($result);

		 	  $actIP=$row['ip'];

			  if ($tg==0) {$ipPerG=0;} else {$ipPerG=$actIP/$tg;}

		 	  $projIP=floor($actIP+$ipPerG*$remg);

		 

			  if ($actIP>=$cminIP) {$remaining+=$cminIPbonus;}

		  }

	    	  if ($cminPA>0)

		  {

		 	  $query="SELECT SUM(pa) as pa FROM players_career_batting_stats WHERE player_id=$pid AND year=$lgyear AND split_id=1 AND league_id=$lgid GROUP BY player_id;";

			  $result=mysqli_query($db,$query);

		 	  $row=mysqli_fetch_array($result);

			  $actPA=$row['pa'];

		 	  if ($tg==0) {$paPerG=0;} else {$paPerG=$actPA/$tg;}

			  $projPA=floor($actPA+$paPerG*$remg);

		   

			  if ($actPA>=$cminPA) {$remaining+=$cminPAbonus;}

		  }

      	  }

	  $cminIPbonus="$".number_format($cminIPbonus);

       	  $cminPAbonus="$".number_format($cminPAbonus);

       

	  ## Get Award Info & Service Time Settings

	  $query="SELECT mvp_award_name,pitcher_award_name,rules_min_service_days,rules_fa_minimum_years,rules_salary_arbitration_minimum_years,rules_minor_league_fa_minimum_years FROM leagues WHERE league_id=$lgid;";

       	  $result=mysqli_query($db,$query);

	  $row=mysqli_fetch_array($result);

       	  $awardName['boy']=$row['mvp_award_name'];

	  $awardName['poy']=$row['pitcher_award_name'];

	  $minService=$row['rules_min_service_days'];

	  $minFAyrs=$row['rules_fa_minimum_years'];

	  $minARByrs=$row['rules_salary_arbitration_minimum_years'];

	  $minMLFAyrs=$row['rules_minor_league_fa_minimum_years'];



	  ##### Get Service Time #####

	  $query="SELECT player_id,mlb_service_years,mlb_service_days,is_active,is_on_secondary,is_on_dl FROM players_roster_status WHERE player_id=$player_id;";

	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))

	  {

	       	  $pid=$row['player_id'];

		  $mlbYrs=$row['mlb_service_years'];

	       	  $mlbServ=$row['mlb_service_days'];

		  $mlbDays=$mlbServ%$minService;

	       	  $players[$pid]['arb']=1;

		  $players[$pid]['days']=$minService-$mlbDays;

	       	  $players[$pid]['is_active']=$row['is_active'];

		  $players[$pid]['is_on_secondary']=$row['is_on_secondary'];

	       	  $players[$pid]['is_on_dl']=$row['is_on_dl'];

		  $players[$pid]['mlb_service_years']=$mlbYrs;

	       	  $players[$pid]['mlb_service_days']=$mlbDays;

		  $players[$pid]['tot_service_days']=$mlbServ;

	       	  if ($pid==$pidTrack) {echo "Service</br>\nmlbYrs::$mlbYrs::mlbDays::$mlbDays::mlbServ::$mlbServ</br>\n";}

	  }



	  ## Display Output

	  echo " <div class='textbox'>\n";

       	  echo "  <table cellpadding=0 cellspacing=0 border=0>\n";

	  echo "   <tr class='title2'><td colspan=2>$pos $name ($age yrs old)</td></tr>\n";

       	  echo "   <tr>\n";

	  echo "    <td valign='top'>";

       	  $htmlpath=$_SESSION['htmlroot'].$_SESSION['htmlpath'];

	  $imgpath=$lgpath."/images/person_pictures/player_".$player_id.".png";            ## Check for photo by player ID

	  $ch = curl_init($imgpath);

	  curl_setopt($ch, CURLOPT_NOBODY, true);

	  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

	  curl_setopt($ch, CURLOPT_FILETIME, true); 

	  curl_exec($ch);

	  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

	  if ($retcode==200) {echo "<img src='$imgpath'>";}

	  else

      	  {

		  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".png";   ## Check for capitalized name PNG

		  $ch = curl_init($imgpath);

		  curl_setopt($ch, CURLOPT_NOBODY, true);

		  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		  curl_setopt($ch, CURLOPT_FILETIME, true); 

		  curl_exec($ch);

		  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

		  if ($retcode==200) {echo "<img src='$imgpath'>";}

		  else

	   	  {

			  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".png";   ## Check for lowercase name PNG

			  $ch = curl_init($imgpath);

			  curl_setopt($ch, CURLOPT_NOBODY, true);

			  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

			  curl_setopt($ch, CURLOPT_FILETIME, true); 

			  curl_exec($ch);

			  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

			  if ($retcode==200) {echo "<img src='$imgpath'>";}

			  else

			  {

				  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".jpg";   ## Check for capitalized name JPG

				  $ch = curl_init($imgpath);

				  curl_setopt($ch, CURLOPT_NOBODY, true);

				  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

				  curl_setopt($ch, CURLOPT_FILETIME, true); 

				  curl_exec($ch);

				  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

				  if ($retcode==200) {echo "<img src='$imgpath'>";}

				  else

		     		  {

					  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".jpg";   ## Check for lowercase name JPG

					  $ch = curl_init($imgpath);

					  curl_setopt($ch, CURLOPT_NOBODY, true);

					  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

					  curl_setopt($ch, CURLOPT_FILETIME, true); 

					  curl_exec($ch);

					  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

					  if ($retcode==200) {echo "<img src='$imgpath'>";}

					  else

			  		  {

						  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".bmp";   ## Check for capitalized name BMP

						  $ch = curl_init($imgpath);

						  curl_setopt($ch, CURLOPT_NOBODY, true);

						  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

						  curl_setopt($ch, CURLOPT_FILETIME, true); 

						  curl_exec($ch);

						  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

						  if ($retcode==200) {echo "<img src='$imgpath'>";}

						  else

			       			  {

							  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".bmp";   ## Check for lowercase name bmp

							  $ch = curl_init($imgpath);

							  curl_setopt($ch, CURLOPT_NOBODY, true);

							  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

							  curl_setopt($ch, CURLOPT_FILETIME, true); 

							  curl_exec($ch);

							  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

							  if ($retcode==200) {echo "<img src='$imgpath'>";}

							  else

				    			  {

								  echo "<img src='$lgpath/images/default_player_photo.jpg'>";   ## Show default

				    			  }

						  }

			  		  }

				  }

			  }

		  }

      	  }

	  echo "     </td>\n";

       	  echo "     <td style='border-left:1px solid black;'>\n";

       

	  ## Display Player Contract Info

	  echo "  <table cellpadding=2 cellspacing=0 border=0 width='600px'>\n";

       	  if ($orgID>0)

	  {

	    	  echo "   <tr class='s2_l'><td colspan=3><b>Team:</b> ";

		  echo "<a href='$lgpath/teams/team_$tid.html'>".$teams[$tid]['name']."</a>";

		  if ($teams[$tid]['league_id']!=$lgid) {echo " [".$teams[$tid]['level']." for <a href='$lgpath/teams/team_$orgID.html'>".$teams[$orgID]['abbr']."</a> (<a href='./payroll.php?team_id=$orgID' title='Show team payroll'>$</a>)]";}

		  else {echo " (<a href='./payroll.php?team_id=$tid' title='Show team payroll'>$</a>)";}

		  echo "</td></tr>";

      	  }

	  echo "   <tr class='s2_l'><td colspan=3><b>Links:</b> ";

       	  echo "<a href='$lgpath/players/player_$pid.html'>OOTP Player Page</a>";

	  echo ", <a href='./player.php?player_id=$pid'>StatsLab Player Page</a>";

       	  echo "</td></tr>\n";

	  echo "   <tr class='title'><td colspan=3>Service Time & Roster Status</td></tr>\n";

	  echo "   <tr class='s2'>";

	  echo "<td class='s2_l' colspan=2>Major League Service</td>";

	  echo "<td>".$players[$pid]['mlb_service_years']." years, ".$players[$pid]['mlb_service_days']." days</td>";

	  echo "</tr>\n";

	  if ($players[$pid]['is_active']==1)

	  {

		  $cls='s1_l';

		  echo "   <tr class='$cls'><td colspan=3>Currently on active roster</td></tr>";

	  }

      	  if (($players[$pid]['is_on_secondary']==1)&&($players[$pid]['is_active']!=1))

	  {

		  $cls='s1_l';

		  echo "   <tr class='$cls'><td colspan=3>Currently on secondary roster</td></tr>";

	  }

	  if ($players[$pid]['is_on_dl']==1)

	  {

		  $cls='s1_l';

		  if (($players[$pid]['is_on_secondary']==1)||($players[$pid]['is_active']==1)) {$cls='s2_l';}

		  echo "   <tr class='$cls'><td colspan=3 style='color:#990000;'>Currently on disabled list</td></tr>";

	  }



	  echo "   <tr class='title'><td colspan=3>Current Contract</td></tr>\n";

       	  if ($mlc==1)

	  {

	    	  if ($orgID>0) {echo "   <tr class='s2'><td class='hsc2_l' colspan=3>Minor league contract</td></tr>\n";}

		  else {echo "   <tr class='s2'><td class='hsc2_l' colspan=3>Free Agent</td></tr>\n";}

      	  }

	  else

      	  {

		  echo "   <tr class='s2_l'><td colspan=3>Signed with the ".$teams[$cTeamID]['name']."</td></tr>\n";

	    	  echo "   <tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2_l'>Age</td><td class='hsc2'>Salary</td></tr>\n";

		  $cnt=0;

	    	  for ($i=$players[$pid]['startYr'];$i<=$players[$pid]['cfinalYr'];$i++)

		  {

		 	  $cnt++;

			  $cls='s'.($cnt%2+1);

		 	  $yrDate=new Date($i."-7-1");

			  $age=floor(($yrDate->getTimestamp()-$bday->getTimestamp())/31536000);

		 	  $salary=$players[$pid][$i]['salary'];

			  $salary='$'.number_format($salary);

		 	  echo "   <tr class='$cls'><td class='".$cls."_l'>$i</td><td class='".$cls."_l'>$age</td><td>$salary</td></tr>\n";

		  }

	    	  echo "   <tr class='headline'><td class='hsc2_l' colspan=2>".$players[$pid]['cYrs']." years</td><td class='hsc2'>$".number_format($players[$pid]['cTotal'])."</td></tr>\n";

		  echo "   <tr class='headline'><td class='hsc2_l' colspan=2>Remaining</td><td class='hsc2'>$".number_format($remaining)."</td></tr>\n";

		  if (!isset($players[$pid]['efinalYr']))  //No extension

	   	  {

			  $remaining_g=$remaining;

			  if (isset($players[$pid]['last_year_option'])&&($players[$pid]['last_year_option']!='po'))

			  {

				  $remaining_g-=$players[$pid][$i-1]['salary'];

			  }

			  if ($remaining!=$remaining_g)

			  {

				  echo "   <tr class='headline'><td class='hsc2_l' colspan=2>Remaining Guaranteed</td><td class='hsc2'>$".number_format($remaining_g)."</td></tr>\n";

			  }

		  }

	    	  echo "   <tr class='headline'><td colspan=3>Clauses and Incentives</td></tr>\n";

		  if (!isset($players[$pid]['efinalYr']))

	   	  {

			  echo "   <tr class='s1'><td class='s1_l' colspan=2>Final Year Option</td><td class='hsc2'>";

		 	  switch ($opt)

			  {

	      		  case 'mo': echo "Mutual";  break;

			  case 'to': echo "Team";    break;

			  case 'po': echo "Player";  break;

			  case 'vo': echo "Vesting"; break;

			  default  : echo "None";    break;

			  }

			  echo "</td></tr>\n";

	   	  }

		  echo "   <tr class='s2'><td class='s2_l' colspan=2>No Trade Clause</td><td class='hsc2'>";

	    	  if ($cnoTrade==1) {echo "Yes";} else {echo "No";}

		  echo "</td></tr>\n";

	    	  echo "   <tr class='s1'><td class='s1_l' colspan=2>".$awardName['boy']." Bonus</td><td class='hsc2'>$cboyBonus</td></tr>\n";

		  echo "   <tr class='s2'><td class='s2_l' colspan=2>".$awardName['poy']." Bonus</td><td class='hsc2'>$cpoyBonus</td></tr>\n";

	    	  echo "   <tr class='s1'><td class='s1_l' colspan=2>All-Star Bonus</td><td class='hsc2'>$casBonus</td></tr>\n";

	    	  if (($pos=="SP")||($pos=="MR")||($pos=="CL"))

		  {

		 	  if ($cminIP>0)

			  {

		      		  echo "   <tr class='s2'><td class='s2_l' colspan=2>Bonus for reaching $cminIP IP</td><td>$cminIPbonus</td></tr>\n";

				  echo "   <tr class='s1'><td class='s1_l' colspan=2>$lgyear Accumulated IP: ".sprintf("%.1f",$actIP)."</td><td>Projected IP: $projIP</td></tr>\n";

			  }

			  else {echo "   <tr class='s2_l'><td colspan=3>No innings pitched bonus clause</td></tr>\n";}

	   	  }

		  else

	   	  {

			  if ($cminPA>0)

			  {

				  echo "   <tr class='s2'><td class='s2_l' colspan=2>Bonus for reaching $cminPA PA</td><td>$cminPAbonus</td></tr>\n";

		      		  echo "   <tr class='s1'><td class='s1_l' colspan=2>$lgyear Accumulated PA: $actPA</td><td> Projected PA: $projPA</td></tr>\n";

			  }

			  else {echo "   <tr class='s2_l'><td colspan=3>No plate appearances bonus clause</td></tr>\n";}

		  }

      	  }

	  echo "   <tr class='title'><td colspan=3>Contract Extension</td></tr>\n";

       	  if (!isset($players[$pid]['efinalYr'])) {echo "   <tr class='s2'><td class='hsc2_l' colspan=3>No extension signed</td></tr>\n";}

	  else

      	  {

		  echo "   <tr class='s2_l'><td colspan=3>Signed with the ".$teams[$eTeamID]['name']."</td></tr>\n";

	    	  echo "   <tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2_l'>Age</td><td class='hsc2'>Salary</td></tr>\n";

		  $cnt=0;

	    	  for ($i=($players[$pid]['cfinalYr']+1);$i<=$players[$pid]['efinalYr'];$i++)

		  {

		 	  $cnt++;

			  $cls='s'.($cnt%2+1);

		 	  $yrDate=new Date($i."-7-1");

			  $age=floor(($yrDate->getTimestamp()-$bday->getTimestamp())/31536000);

		 	  $salary=$players[$pid][$i]['salary'];

			  $salary='$'.number_format($salary);

		 	  echo "   <tr class='$cls'><td class='".$cls."_l'>$i</td><td class='".$cls."_l'>$age</td><td>$salary</td></tr>\n";

		  }

	    	  echo "   <tr class='headline'><td class='hsc2_l' colspan=2>".$players[$pid]['eYrs']." years</td><td class='hsc2'>$".number_format($players[$pid]['eTotal'])."</td></tr>\n";

		  $remaining_g=$remaining+$players[$pid]['eTotal'];

		  if (isset($players[$pid]['last_year_option'])&&($players[$pid]['last_year_option']!='po'))

		  {

			  $remaining_g-=$players[$pid][$i-1]['salary'];

		  }

		  if ($remaining!=$remaining_g)

		  {

			  echo "   <tr class='headline'><td class='hsc2_l' colspan=2 title='Includes remainder of current contract and guaranteed portion of extension'>Remaining Guaranteed</td><td class='hsc2'>$".number_format($remaining_g)."</td></tr>\n";

		  }

		  echo "   <tr class='headline'><td colspan=3>Clauses and Incentives</td></tr>\n";

	    	  echo "   <tr class='s1'><td class='s1_l' colspan=2>Final Year Option</td><td class='hsc2'>";

		  switch ($opt)

	   	  {

	      		  case 'mo': echo "Mutual";  break;

			  case 'to': echo "Team";    break;

			  case 'po': echo "Player";  break;

			  case 'vo': echo "Vesting"; break;

			  default  : echo "None";    break;

		  }

	    	  echo "</td></tr>\n";

		  echo "   <tr class='s2'><td class='s2_l' colspan=2>No Trade Clause</td><td class='hsc2'>";

	    	  if ($enoTrade==1) {echo "Yes";} else {echo "No";}

		  echo "</td></tr>\n";

	    	  echo "   <tr class='s1'><td class='s1_l' colspan=2>".$awardName['boy']." Bonus</td><td class='hsc2'>$eboyBonus</td></tr>\n";

		  echo "   <tr class='s2'><td class='s2_l' colspan=2>".$awardName['poy']." Bonus</td><td class='hsc2'>$epoyBonus</td></tr>\n";

	    	  echo "   <tr class='s1'><td class='s1_l' colspan=2>All-Star Bonus</td><td class='hsc2'>$easBonus</td></tr>\n";

	    	  if (($pos=="SP")||($pos=="MR")||($pos=="CL"))

		  {

		 	  if ($eminIP>0) {echo "   <tr class='s2'><td class='s2_l' colspan=2>Bonus for reaching $eminIP IP</td><td>$eminIPbonus</td></tr>\n";}

			  else {echo "   <tr class='s2_l'><td colspan=3>No innings pitched bonus clause</td></tr>\n";}

	   	  }

		  else

	   	  {

			  if ($eminPA>0) {echo "   <tr class='s2'><td class='s2_l' colspan=2>Bonus for reaching $eminPA PA</td><td>$eminPAbonus</td></tr>\n";}

			  else {echo "   <tr class='s2_l'><td colspan=3>No plate appearances bonus clause</td></tr>\n";}

		  }

      	  }

	  echo "  </table>\n";

       

	  ## Close Surrounding Table

	  echo "    </td>\n";

       	  echo "   </tr>\n";

	  echo "  </table>\n";

       	  echo " </div>\n";

       

	  echo " <div class='textbox' style='border:0;width:935px;'>Remaining salary includes prorated portion of this year's salary and playing time incentives if they have already been met.<br/>Age displayed is age on July 1st of year in question.</div>\n";

       

  }

  else 	  ##### Dispaly Team Info #####

  {

	  ##### Display Year Filter #####

	  echo " <div class='textbox'>\n";

	  echo "  <form method='get' action='./payroll.php' style='clear:left;'>\n";

	  echo "  <table cellspacing=0 cellpadding=2 border=0>\n";

	  echo "   <tr class='title'><td colspan=5>Filters</td></tr>\n";

	  echo "   <tr>\n";

	  

	  ## Show Team Filter

	  echo "    <td><label for='team_id'><b>Team:</b></label></td>\n";

	  echo "    <td>\n";

	  echo "     <select name='team_id' id='team_id'>\n";

	  $prevLGid=-1;

	  foreach ($teams as $tid => $val)

	  {

		  if ($teams[$tid]['parent']!=0) {continue;}

		  $tLGid=$teams[$tid]['league_id'];

		  if ($tLGid!=$prevLGid) {echo "      <optgroup label='".$leagues[$tLGid]."'>\n";}

		  echo "      <option value='$tid'";

	       	  if ($team_id==$tid) {echo " selected";}

		  echo ">".$teams[$tid]['name']."</option>\n";

		  $prevLGid=$tLGid;

	  }

	  echo "     </select>\n";

	  echo "    </td>\n";

	  

	  ## Close Form

	  echo "    <td><input type='submit' value='Go'></input></td>\n";

	  echo "   </tr>\n";

	  echo "  </table>\n";

	  echo "  </form>\n";

	  echo " </div>\n";

	  

	  ##### Get League Settings #####

	  $query="SELECT rules_min_service_days,rules_fa_minimum_years,rules_salary_arbitration_minimum_years,rules_minor_league_fa_minimum_years,rules_minimum_salary,rules_active_roster_limit  FROM leagues WHERE league_id=$lgid;";

	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $row=mysqli_fetch_array($result);

	  $minService=$row['rules_min_service_days'];

	  $minFAyrs=$row['rules_fa_minimum_years'];

	  $minARByrs=$row['rules_salary_arbitration_minimum_years'];

	  $minMLFAyrs=$row['rules_minor_league_fa_minimum_years'];

	  $minSalary=$row['rules_minimum_salary'];

	  $minRosterSize=$row['rules_active_roster_limit'];



	  ##### Get Remaining Service Days This Year #####

	  $query="SELECT lastDay,'$lgdate',DATEDIFF(lastDay,'$lgdate') as diff,DATEDIFF(lastDay,firstDay) as seaLen FROM (SELECT MIN(games.date) as firstDay,MAX(games.date) as lastDay FROM games WHERE league_id=$lgid AND game_type=0) as t;";

	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

	       	  $row=mysqli_fetch_array($result);

		  $lastDay=$row['lastDay'];

	       	  $remDays=$row['diff'];

		  $seaLen=$row['seaLen'];

	       	  if ($remDays<1) {$remDays=0;}

		  if ($remDays>$seaLen) {$remDays=$seaLen;}

	  }

	  else {$remDays=$minService;}

		  

	  ##### Get Players in Organization #####

	  $query="SELECT player_id,first_name,last_name,position,role,age FROM players WHERE organization_id=$team_id ORDER BY league_id,team_id,last_name,first_name;";

	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $pList="";

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

	      	  {

			  $pid=$row['player_id'];

		    	  $players[$pid]['name']=$row['first_name']." ".$row['last_name'];

			  $players[$pid]['sortname']=$row['last_name'].", ".$row['first_name'];

		    	  if ($row['position']==1)

			  {

			 	  $players[$pid]['pos']=get_pos($row['role'],1);

				  $players[$pid]['sortpos']=$row['role'];

		   	  }

			  else

		   	  {

				  $players[$pid]['pos']=get_pos($row['position'],1);

			 	  $players[$pid]['sortpos']=$row['position'];

			  }

		    	  $players[$pid]['age']=$row['age'];

			  $pList.=",$pid";

		    	  if ($pid==$pidTrack) {echo "Found $pid::".$players[$pid]['name']."</br>\n";}

		  }

	       	  $pList=trim($pList,",");

	  }

	  else

	  {

		  echo " <div class='textbox' style='border:0;'>No players found</div>\n";

	       	  ##### End Page #####

		  echo "</div>   <!-- END contentpane DIV -->\n";

	       	  page_foot($serverurl.$htmlpath);

		  exit;

	  }

	  

	  ##### Get Player Contracts #####

	  $query="SELECT player_id,season_year,last_year_team_option,last_year_player_option,last_year_vesting_option,salary0,salary1,salary2,salary3,salary4,salary5,salary6,salary7,salary8,salary9 FROM players_contract WHERE player_id IN ($pList);";

	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $numFields=mysqli_num_fields($result);

	  while ($row=mysqli_fetch_array($result))

	  {

		  $pid=$row['player_id'];

	       	  $yrOne=$row['season_year'];

		  $tOpt=$row['last_year_team_option'];

	       	  $pOpt=$row['last_year_player_option'];

	       	  $vOpt=$row['last_year_vesting_option'];

		  $opt="";

	       	  if (($tOpt==1)&&($pOpt==1)) {$opt='mo';}

		  elseif ($pOpt==1) {$opt='po';}

	      	  elseif ($tOpt==1) {$opt='to';}

	      	  elseif ($vOpt==1) {$opt='vo';}

		  if ($opt!="") {$players[$pid]['last_year_option']=$opt;}

	       	  if ($pid==$pidTrack) {echo "Contract</br>\nyrOne::$yrOne::tOpt::$tOpt::pOpt::$pOpt</br>\n";}

		  for ($i=5;$i<$numFields;$i++)

		  {

				$fieldInfo = mysqli_fetch_field_direct( $result, $i);

				$fieldname = $fieldInfo->name;

			  $yr=$yrOne+$i-5;

		    	  $salary=$row[$fieldname];

			  $players[$pid][$yr]['salary']=$salary;

		    	  if ($pid==$pidTrack) {echo "$fieldname::$salary::$yr::$chkYr</br>\n";}

			  if ($salary!=0)

		   	  {

				  $players[$pid]['finalYr']=$yr;

			 	  $teamSalary[$yr]=$teamSalary[$yr]+$salary;

				  $teamCnt[$yr]=$teamCnt[$yr]+1;

				  $teamGSalary[$yr]=$teamGSalary[$yr]+$salary;

				  $teamGCnt[$yr]=$teamGCnt[$yr]+1;

			  }

		    	  if ($yr==$chkYr) {$psort[$pid]=$salary;}

			  if ($pid==$pidTrack) {echo "finalYr::".$players[$pid]['finalYr']."</br>\n";}

	      	  }

	  }

	  

	  ##### Get Player Contract Extensions #####

	  $query="SELECT player_id,season_year,last_year_team_option,last_year_player_option,last_year_vesting_option,salary0,salary1,salary2,salary3,salary4,salary5,salary6,salary7,salary8,salary9 FROM players_contract_extension WHERE player_id IN ($pList);";

	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $numFields=mysqli_num_fields($result);

	  while ($row=mysqli_fetch_array($result))

	  {

		  $pid=$row['player_id'];

	       	  $yrOne=$players[$pid]['finalYr']+1;

		  $tOpt=$row['last_year_team_option'];

	       	  $pOpt=$row['last_year_player_option'];

	       	  $vOpt=$row['last_year_vesting_option'];

		  $opt="";

	       	  if (($tOpt==1)&&($pOpt==1)) {$opt='mo';}

		  elseif ($pOpt==1) {$opt='po';}

	      	  elseif ($tOpt==1) {$opt='to';}

	      	  elseif ($vOpt==1) {$opt='vo';}

		  if ($opt!="") {$players[$pid]['last_year_option']=$opt;}

	       	  if ($pid==$pidTrack) {echo "Extension</br>\nyrOne::$yrOne::tOpt::$tOpt::pOpt::$pOpt</br>\n";}

		  for ($i=5;$i<$numFields;$i++)

	      	  {

				$fieldInfo = mysqli_fetch_field_direct( $result, $i);

				$fieldname = $fieldInfo->name;

		    	  $yr=$yrOne+$i-5;

			  $salary=$row[$fieldname];

		    	  $players[$pid][$yr]['salary']=$salary;

			  if ($pid==$pidTrack) {echo "$fieldname::$salary::$yr::$chkYr</br>\n";}

		    	  if ($salary!=0) 

			  {

			 	  $players[$pid]['finalYr']=$yr;

				  $teamSalary[$yr]=$teamSalary[$yr]+$salary;

				  $teamCnt[$yr]=$teamCnt[$yr]+1;

				  $teamGSalary[$yr]=$teamGSalary[$yr]+$salary;

				  $teamGCnt[$yr]=$teamGCnt[$yr]+1;

		   	  }

			  if ($yr==$chkYr) {$psort[$pid]=$salary;}

		    	  if ($pid==$pidTrack) {echo "finalYr::".$players[$pid]['finalYr']."</br>\n";}

		  }

	  }

	  

	  ##### Get Service Time #####

	  $query="SELECT player_id,mlb_service_years,mlb_service_days,is_active,is_on_secondary,is_on_dl FROM players_roster_status WHERE player_id IN ($pList);";

	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))

	  {

	       	  $pid=$row['player_id'];

		  $mlbYrs=$row['mlb_service_years'];

	       	  $mlbServ=$row['mlb_service_days'];

		  $mlbDays=$mlbServ%$minService;

	       	  $players[$pid]['arb']=1;

		  $players[$pid]['days']=$minService-$mlbDays;

	       	  $players[$pid]['is_active']=$row['is_active'];

		  $players[$pid]['is_on_secondary']=$row['is_on_secondary'];

	       	  $players[$pid]['is_on_dl']=$row['is_on_dl'];

		  $players[$pid]['mlb_service_years']=$mlbYrs;

	       	  $players[$pid]['mlb_service_days']=$mlbDays;

		  $players[$pid]['tot_service_days']=$mlbServ;

	       	  if ($pid==$pidTrack) {echo "Service</br>\nmlbYrs::$mlbYrs::mlbDays::$mlbDays::mlbServ::$mlbServ</br>\n";}

	       

		  if ((($players[$pid]['finalYr']<$chkYr)&&($mlbYrs>max($minARByrs,$minFAyrs)))||(($mlbServ<1)&&($players[$pid]['finalYr']<$chkYr))||($players[$pid]['finalYr']==0)) {unset($psort[$pid]);continue;}

		  for ($i=$chkYr;$i<($chkYr+10);$i++)

	      	  {

			  $salary=$players[$pid][$i]['salary'];

		    	  if ($pid==$pidTrack) {echo "$i::$salary</br>\n";}

			  if ($salary==0)

		   	  {

				  if (($mlbYrs+$i-$chkYr)<=$minARByrs)

				  {

					  $players[$pid][$i]['salary']=$players[$pid][$i-1]['salary'];

			      		  if ($i==$chkYr) {$psort[$pid]=$players[$pid][$i]['salary'];}

					  $teamSalary[$i]=$teamSalary[$i]+$players[$pid][$i-1]['salary'];

					  //$teamGSalary[$i]=$teamGSalary[$i]+$players[$pid][$i-1]['salary'];

					  $teamGSalary[$i]=$teamGSalary[$i]+0;

			      		  $players[$pid][$i]['salStatus']="+";

				  }

				  elseif (($mlbYrs+$i-$chkYr)<=$minFAyrs) 

				  {

			      		  if ((($remDays+$mlbDays)>=$minService)&&(($mlbYrs+$i-$chkYr)==($minFAyrs))&&($i==$chkYr+1)) {$players[$pid][$i]['salary']='ArbFA';}

					  else {$players[$pid][$i]['salary']='Arbitration';}

				      	  if ($i==$chkYr) {$psort[$pid]=0;}

					  $teamSalary[$i]=$teamSalary[$i]+0;

					  $teamGSalary[$i]=$teamGSalary[$i]+0;

				  }

				  if ($pid==$pidTrack) {echo "Adjusted to salary::".$players[$pid][$i]['salary']."</br>\n";}

		   	  }

		  }

	  }

	  

	  arsort($psort);

	  

	  ##### Display Players #####

	  echo " <div class='textbox'>\n";

	  echo "  <table cellpadding=0 cellspacing=0 border=0>\n";

	  echo "   <tr class='title2'><td>Payroll Projections</td></tr>\n";

	  echo "   <tr><td>\n";   

	  echo "    <table cellpadding=2 cellspacing=0 border=0 width='935px' class='sortable'>\n";

	  echo "     <tr class='headline'>";

	  echo "<td class='hsc2_l'>Player</td>";

	  echo "<td class='hsc2'>Pos</td>";

	  echo "<td class='hsc2'>Age</td>";

	  echo "<td class='hsc2'>ML Service</td>";

	  for ($i=$chkYr;$i<($chkYr+10);$i++)

	  {

		  if (!isset($teamSalary[$i])) {continue;}

	       	  echo "<td class='hsc2'>$i</td>";

	  }

	  echo "</tr>\n";   

	  $cnt=0;

	  foreach ($psort as $pid => $val)

	  {

	       	  $name=$players[$pid]['name'];

		  $sortname=$players[$pid]['sortname'];

	       	  $pos=$players[$pid]['pos'];

		  $sortpos=$players[$pid]['sortpos'];

	       	  $age=$players[$pid]['age'];

		  $mlbDays=$players[$pid]['mlb_service_days'];

	       

		  $cls='s'.($cnt%2+1);

		  echo "     <tr class='$cls'>";

	       	  echo "<td class='".$cls."_l' sorttable_customkey=\"".$sortname."\"><a href='./payroll.php?player=$pid'>$name</a>";

		  if ($players[$pid]['is_active']==1) {echo "*";}

	       	  if ($players[$pid]['is_on_secondary']==1) {echo "~";}

		  if ($players[$pid]['is_on_dl']==1) {echo "!";}

	       	  echo "</td>";

		  echo "<td sorttable_customkey=\"".$sortpos."\">$pos</td>";

	       	  echo "<td>$age</td>";

		  echo "<td sorttable_customkey='".$players[$pid]['tot_service_days']."'>".$players[$pid]['mlb_service_years']." yrs, ".$players[$pid]['mlb_service_days']." days</td>";

	       	  for ($i=$chkYr;$i<($chkYr+10);$i++)

		  {

		    	  if (!isset($teamSalary[$i])) {continue;}

			  $salary=$players[$pid][$i]['salary'];

		    	  if ($salary>0) {$sortKey=$salary;$salary='$'.number_format($salary);}

			  elseif ($salary=='ArbFA')

		   	  {

				  $sortKey=-1;$salary="FA w/ ".($minService-$mlbDays)." day";

			 	  if ($minService-$mlbDays>1) {$salary.='s';}

			  }

		   	  elseif ($salary!='Arbitration') {$sortKey=-1;$salary='&nbsp;';}

			  else {$sortKey=0;}

		    	  $salary=$salary.$players[$pid][$i]['salStatus'];

			  echo "<td sorttable_customkey='$sortKey'>$salary";

			  if (($salary!="Arbitration")&&($salary!="&nbsp;")&&(isset($players[$pid]['last_year_option']))&&(($players[$pid][$i+1]['salary']=="")||($players[$pid][$i+1]['salary']==0)))

			  {

				  echo "<sup>".$players[$pid]['last_year_option']."</sup>";

				  $teamGSalary[$i]=$teamGSalary[$i]-$players[$pid][$i]['salary'];

				  $teamGCnt[$i]=$teamGCnt[$i]-1;



			  }

			  echo "</td>";

	      	  }

		  echo "</tr>\n";

	       	  $cnt++;

	  }

	  echo "     <tfoot>\n";

	  echo "      <tr class='headline'><td class='hsc2_l' colspan=4 title='Removes arbitration estimates, but includes option years and $minRosterSize man roster filled with $".number_format($minSalary)." players'>Total</td>";

	  for ($i=$chkYr;$i<($chkYr+10);$i++)

	  {

	       	  if (!isset($teamSalary[$i])) {continue;}

		  elseif ($teamCnt[$i]<$minRosterSize) {$teamSalary[$i]=$teamSalary[$i]+($minRosterSize-$teamCnt[$i])*$minSalary;}

		  $salary=$teamSalary[$i];

		  $maxSalary=max($salary,$maxSalary);

	       	  $salary='$'.number_format($salary);

		  echo "<td class='hsc2' title='".max(0,$teamCnt[$i])." players + ".max(0,$minRosterSize-$teamCnt[$i])." fillers'>$salary</td>";

	  }

	  echo "</tr>\n";

	  echo "      <tr class='headline'><td class='hsc2_l' colspan=4 title='Includes only guaranteed contracts'>Starting Base</td>";

	  for ($i=$chkYr;$i<($chkYr+10);$i++)

	  {

		  if (!isset($teamGSalary[$i])) {continue;}

		  $salary=$teamGSalary[$i];

	       	  $salary='$'.number_format($salary);

		  echo "<td class='hsc2' title='".max(0,$teamGCnt[$i])." players'>$salary</td>";

	  }

	  echo "</tr>\n";

	  echo "      <tr class='headline'><td class='hsc2_l' colspan=4 title='Starting base plus $minRosterSize man roster filled with $".number_format($minSalary)." players'>Guaranteed</td>";

	  for ($i=$chkYr;$i<($chkYr+10);$i++)

	  {

		  if (!isset($teamGSalary[$i])) {continue;}

		  elseif ($teamGCnt[$i]<$minRosterSize) {$teamGSalary[$i]=$teamGSalary[$i]+($minRosterSize-$teamGCnt[$i])*$minSalary;}

		  $salary=$teamGSalary[$i];

	       	  $salary='$'.number_format($salary);

		  echo "<td class='hsc2' title='".max(0,$teamGCnt[$i])." players + ".max(0,$minRosterSize-$teamGCnt[$i])." fillers'>$salary</td>";

	  }

	  echo "</tr>\n";

	  echo "     </tfoot>\n";   

	  echo "    </table>\n";

	  echo "   </td></tr>\n";

	  echo "  </table>\n";

	  echo " </div>\n";

	  

	  echo " <div class='textbox' style='border:0;width:935px;'>* indicates player is on active roster<br/>~ indicates player is on secondary roster<br/>! indicates player is on disabled list<br/>+ indicates automatic resign due to having less than $minARByrs years service time.  These players may qualify for 'Super Two' arbitration.<br/><sup>to</sup> indicates team option<br/><sup>po</sup> indicates player option<br/><sup>mo</sup> indicates mutual option<br/><sup>vo</sup> indicates vesting option<br/>Dashed line in graph is team budget</div>\n";



	  ## Display payroll chart

	  echo "  <div id='chartdiv' style='height:400px;width:800px;margin-left:auto;margin-right:auto;clear:both;'></div>\n";



	  # Get budget/max Salary

	  $query="SELECT budget FROM team_financials WHERE team_id=$team_id";

	  if ($_GET['showq']==1) {echo $query."<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $row=mysqli_fetch_array($result);

	  $budget=$row['budget'];



	  if ($budget>$maxSalary) {$maxSalary=$budget;}

	  $maxYAxis=$maxSalary*1.1;



	  # Display Graph

	  echo "  <script class='code' type='text/javascript'>\n";

	  echo "   <!--\n";

	  echo "    $(document).ready(function(){\n";

	  echo "      var data1 = [";

	  for ($i=$chkYr;$i<($chkYr+10);$i++)

	  {

	       	  if (!isset($teamGSalary[$i])) {continue;}

		  if ($i>$chkYr) {echo ",";}

		  echo $teamGSalary[$i];

	  }

	  echo "];\n";

	  echo "      var data2 = [";

	  for ($i=$chkYr;$i<($chkYr+10);$i++)

	  {

	       	  if (!isset($teamSalary[$i])) {continue;}

		  if ($i>$chkYr) {echo ",";}

		  echo ($teamSalary[$i]-$teamGSalary[$i]);

	  }

	  echo "];\n";

	  echo "      var ticks = [";

	  for ($i=$chkYr;$i<($chkYr+10);$i++)

	  {

	       	  if (!isset($teamSalary[$i])) {continue;}

		  if ($i>$chkYr) {echo ",";}

		  echo $i;

	  }

	  echo "];\n";

	  echo "      var plot1 = $.jqplot('chartdiv', [data1, data2], {\n";

	  echo "             title:'Projected Payroll',\n";

	  echo "             stackSeries: true,\n";

	  echo "             seriesDefaults:{\n";

	  echo "                  renderer:$.jqplot.BarRenderer,\n";

	  echo "		  rendererOptions: {fillToZero: true},\n";

	  echo "                  pointLabels: {show: true}\n";

	  echo "	     },\n";

	  echo "             series:[\n";

	  echo "                  {label:'Guaranteed'},\n";

	  echo "                  {label:'Total'}\n";

	  echo "             ],\n";

	  echo "             axes: {\n";

	  echo "                  xaxis: {\n";

	  echo "                    renderer: $.jqplot.CategoryAxisRenderer,\n";

	  echo "                    ticks: ticks\n";

	  echo "                  },\n";

	  echo "                  yaxis: {\n";

	  echo "                    min: 0,\n";

	  echo "                    max: $maxYAxis,\n";

	  echo "                    tickOptions: {formatString: \"$%'d\"}\n";

	  echo "                  }\n";

	  echo "             },\n";

	  echo "             legend: {\n";

	  echo "                  show: true,\n";

	  echo "                  location: 'e',\n";

	  echo "                  placement: 'outside'\n";

	  echo "             },\n";

	  echo "             cursor: {show: true, zoom: true, showTooltip: false},\n";

	  echo "             canvasOverlay: {\n";

	  echo "                         show: true,\n";

	  echo "                         objects: [\n";

	  echo "                             {dashedHorizontalLine: {\n";

	  echo "                                 name: 'budgetLine',\n";

	  echo "                                 y: $budget,\n";

	  echo "                                 lineWidth: 2,\n";

	  echo "                                 color: 'rgb(153, 0, 0)',\n";

	  echo "                                 shadow: false\n";

	  echo "                              }}\n";

	  echo "                         ]\n";

	  echo "             }\n";

	  echo "     });\n";

	  echo "    });\n";

	  echo "   -->\n";

	  echo "  </script>\n";

  }



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);





?>

