<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgpath=$_SESSION['lgpath'];

  $htmlpath=$_SESSION['htmlpath'];

  $htmlroot=$_SESSION['htmlroot'];

  $date=new Date($_SESSION['lgdate']);

  $lgyear=$_SESSION['lgyear'];



  $parkID=$_GET['park'];

  $league_id=$_GET['league'];

  $year=$_GET['year'];



  if ($league_id=="") {$league_id=$lgid;}

  if ($year=="") {$year=$lgyear;}



  # Title Bar

  $title='Park History';



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  nav_toolbar("history","History");

  nav_toolbar("leagues","",$lgid,$slid,"",$year);

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");

  

  ##### Check if park_factors table exists #####

  $query="SHOW TABLES LIKE 'park_factors';";

  $result=mysqli_query($db,$query);

  if (!mysqli_num_rows($result))

  {

	  echo "<div>Park factors have not yet been calculated.</div>\n";

	  mysqli_close($db);

	

	  ################## END OF PAGE #########################

	  echo " </div>   <!-- END contentpane DIV -->\n";

	  page_foot($_SESSION['lgpath']);

	  exit;

  }



  ##### Individual Park Data #####

  if ($parkID!="")

  {

   ## Get Park Dimensions    

   $query="SELECT distances0,distances1,distances2,distances3,distances4,distances5,distances6,wall_heights0,wall_heights1,wall_heights2,wall_heights3,wall_heights4,wall_heights5,wall_heights6,name,picture,picture_night,capacity,type,turf FROM parks WHERE park_id=$parkID;";

   if ($_GET['showq']==1) {echo "$query<br/>";}

   $result=mysqli_query($db,$query);

   $row=mysqli_fetch_array($result);

   $numFields=mysqli_num_fields($result);

   for ($i=0;$i<$numFields;$i++)

    {

				$fieldInfo = mysqli_fetch_field_direct( $result, $i);

				$fieldName = $fieldInfo->name;

      $parks[$parkID][$fieldName]=$row[$fieldName];

    }



   ## Display Header

   echo "<div class='textbox'>\n";

   echo " <table cellpadding=2 cellspacing=0 border=0 width='935px'>\n";

   echo "  <tr class='title2'><td colspan=3>".$parks[$parkID]['name']."</td></tr>\n";

   echo "  <tr class='headline'><td class='hsc2_l' colspan=3>Currently In Use By</td></tr>\n";

   $query="SELECT team_id,name,nickname,league_id FROM teams WHERE park_id=$parkID ORDER BY name,nickname;";

   if ($_GET['showq']==1) {echo "$query<br/>";}

   $result=mysqli_query($db,$query);

   if (mysqli_num_rows($result))

    {

      $cnt=1;

      while ($row=mysqli_fetch_array($result))

       {

         $tid=$row['team_id'];

	 $tname=$row['name']." ".$row['nickname'];

   	 $lid=$row['league_id'];

	 $lvl=get_level($leagues[$lid]['level']);



	 $cls='s'.($cnt%2+1);

	 echo "  <tr class='$cls'><td class='".$cls."_l' colspan=2><a href='$lgpath/teams/team_$tid.html'>$tname</a></td><td>$lvl</td></tr>\n";

       }

    }

    else

    {

      echo "  <tr class='s2_l'><td colspan=3><a href='$lgpath/teams/team_$tid.html'>$tname</a></td><td>$lvl</td></tr>\n";

    }

   echo "  <tr class='headline'><td class='hsc2_l' colspan=3>Capacity</td></tr>\n";

   echo "  <tr class='s2_l'><td colspan=3>".number_format($parks[$parkID]['capacity'])."</td></tr>\n";

   echo "  <tr class='headline'><td class='hsc2_l'>Dimensions</td><td class='hsc2'>Distance</td><td class='hsc2'>Wall Height</td></tr>\n";

   echo "  <tr class='s1'><td class='s1_l'>Left Foul Line</td><td>".$parks[$parkID]['distances0']."</td><td>".$parks[$parkID]['wall_heights0']."</td></tr>\n";

   echo "  <tr class='s2'><td class='s2_l'>Left Field</td><td>".$parks[$parkID]['distances1']."</td><td>".$parks[$parkID]['wall_heights1']."</td></tr>\n";

   echo "  <tr class='s1'><td class='s1_l'>Left Center</td><td>".$parks[$parkID]['distances2']."</td><td>".$parks[$parkID]['wall_heights2']."</td></tr>\n";

   echo "  <tr class='s2'><td class='s2_l'>Center Field</td><td>".$parks[$parkID]['distances3']."</td><td>".$parks[$parkID]['wall_heights3']."</td></tr>\n";

   echo "  <tr class='s1'><td class='s1_l'>Right Center</td><td>".$parks[$parkID]['distances4']."</td><td>".$parks[$parkID]['wall_heights4']."</td></tr>\n";

   echo "  <tr class='s2'><td class='s2_l'>Right Field</td><td>".$parks[$parkID]['distances5']."</td><td>".$parks[$parkID]['wall_heights5']."</td></tr>\n";

   echo "  <tr class='s1'><td class='s1_l'>Right Foul Line</td><td>".$parks[$parkID]['distances6']."</td><td>".$parks[$parkID]['wall_heights6']."</td></tr>\n";

   echo " </table>\n";

   echo "</div>\n";



   ## Get Attendance

   $query="SELECT pf.team_id,$lgyear as year,attendance FROM park_factors as pf,team_financials as thf WHERE pf.team_id=thf.team_id AND pf.year=$lgyear AND pf.park_id=$parkID UNION SELECT pf.team_id,pf.year,attendance FROM park_factors as pf,team_history_financials as thf WHERE pf.team_id=thf.team_id AND pf.year=thf.year AND pf.park_id=$parkID";

   $result=mysqli_query($db,$query);

   if (mysqli_num_rows($result))

   {

      while ($row=mysqli_fetch_array($result))

      {      

	      $tid=$row['team_id'];

	      $yr=$row['year'];

	      $att=$row['attendance'];



	      $attendance[$tid][$yr]=$att;

      }

   }



   ## Get Park Factors

   echo "<div class='textbox'>\n";

   echo " <table cellpadding=0 cellspacing=0 border=0>\n";

   echo "  <tr class='title'><td style='padding:2px'>Park Factors</td></tr>\n";

   echo "  <tr><td>";

   $query="SELECT pf.team_id,pf.league_id,pf.year,rpf,hrpf,t.name,t.nickname FROM park_factors as pf,teams as t WHERE pf.team_id=t.team_id AND pf.park_id=$parkID AND pf.year=$lgyear UNION SELECT pf.team_id,pf.league_id,pf.year,rpf,hrpf,t.name,t.nickname FROM park_factors as pf,team_history as t WHERE pf.team_id=t.team_id AND pf.year=t.year AND pf.park_id=$parkID AND pf.year!=$lgyear ORDER BY year,league_id,team_id;";

   if ($_GET['showq']==1) {echo "$query<br/>";}

   $result=mysqli_query($db,$query);

   if (mysqli_num_rows($result))

    {

      echo "   <table class='sortable' cellpadding=2 cellspacing=0 border=0 width='935px'>\n";

      echo "    <tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2_l'>Team</td><td class='hsc2_l'>League Level</td><td class='hsc2'>Attendance</td><td class='hsc2'>PFr</td><td class='hsc2'>PFhr</td></tr>\n";

      $cnt=0;

      $Trpf=0;

      $Thrpf=0;

      while ($row=mysqli_fetch_array($result))

       {      

         $tid=$row['team_id'];

	 $lid=$row['league_id'];

	 $lvl=get_level($leagues[$lid]['level']);

   	 $yr=$row['year'];

	 $rpf=$row['rpf'];

	 $hrpf=$row['hrpf'];

	 $Trpf+=$rpf;

	 $Thrpf+=$hrpf;

	 $rpf=sprintf("%.2f",$rpf);

	 $hrpf=sprintf("%.2f",$hrpf);

	 $tname=$row['name']." ".$row['nickname'];



	 $cls='s'.($cnt%2+1);

	 echo "    <tr class='$cls'>";

	 echo "<td class='".$cls."_l'><a href='./parks.php?league=$lid&year=$yr'>$yr</a></td>";

	 if ($lid==$lgid) {echo "<td class='".$cls."_l'><a href='./team_summary.php?team_id=$tid&year=$yr'>$tname</a></td>\n";}

	  else {echo "<td class='".$cls."_l'>$tname</td>\n";}

	 echo "<td class='".$cls."_l'>$lvl</td>";

	 echo "<td>".stat_format('attendance',$attendance[$tid][$yr])."</td>";

	 echo "<td>$rpf</td>";

	 echo "<td>$hrpf</td>";

	 echo "</tr>\n";

	 $cnt++;

       }

      echo "    <tfoot><tr class='headline'><td colspan=4>&nbsp;</td><td class='hsc2'>".sprintf("%.2f",$Trpf/$cnt)."</td><td class='hsc2'>".sprintf("%.2f",$Thrpf/$cnt)."</td></tr></tfoot>\n";

      echo "   </table>\n";

    }

    else {echo "No park factors have been recorded for this ballpark";}

   echo "  </td></tr>\n";

   echo " </table>\n";

   echo "</div>\n";



   ## Display Day Picture

   $dayImg="$lgpath/images/".rawurlencode($parks[$parkID]['picture']);

   $ch = curl_init($dayImg);

   curl_setopt($ch, CURLOPT_NOBODY, true);

   curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

   curl_setopt($ch, CURLOPT_FILETIME, true); 

   curl_exec($ch);

   $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

   if ($retcode==200)

   {

      echo "<div class='textbox'>\n";

      echo " <table cellpadding=0 cellspacing=0 border=0 width='935px'>\n";

      echo "  <tr class='title'><td style='padding:2px;'>Day Picture</td></tr>\n";

      echo "  <tr><td><img src=\"$lgpath/images/".$parks[$parkID]['picture']."\" width='935px' style='align:center;'/></td></tr>\n";

      echo " </table>\n";

      echo "</div>\n";

    }

   $dayImg="$lgpath/images/".rawurlencode($parks[$parkID]['picture_night']);

   $ch = curl_init($dayImg);

   curl_setopt($ch, CURLOPT_NOBODY, true);

   curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

   curl_setopt($ch, CURLOPT_FILETIME, true); 

   curl_exec($ch);

   $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

   if ($retcode==200)

   {

      ## Display Night Picture

      echo "<div class='textbox'>\n";

      echo " <table cellpadding=0 cellspacing=0 border=0 width='935px'>\n";

      echo "  <tr class='title'><td style='padding:2px;'>Night Picture</td></tr>\n";

      echo "  <tr><td><img src=\"$lgpath/images/".$parks[$parkID]['picture_night']."\" width='935px' style='align:center;'/></td></tr>\n";

      echo " </table>\n";

      echo "</div>\n";

    }

  }

  else

  {

	  $query="SELECT team_id,p.park_id,rpf,hrpf,p.name FROM parks as p,park_factors as pf WHERE p.park_id=pf.park_id AND pf.league_id=$league_id AND pf.year=$year ORDER BY rpf DESC,hrpf DESC;";

	  if ($_GET['showq']==1) {echo "$query<br/>";}

   $result=mysqli_query($db,$query);

   if (mysqli_num_rows($result))

    {

      ## Get Park Factors

      $teamList="";

      while ($row=mysqli_fetch_array($result))

       {

         $pkid=$row['park_id'];

	 $tid=$row['team_id'];

   	 $teamList.=",$tid";

	 $parks[$pkid][$tid]['rpf']=$row['rpf'];

   	 $parks[$pkid][$tid]['hrpf']=$row['hrpf'];

	 $parks[$pkid][$tid]['name']=$row['name'];

       }

      $teamList=trim($teamList,",");

   

      ## Get Team Names

      if ($year==$lgyear) {$query="SELECT team_id,name,nickname,abbr FROM teams WHERE team_id IN ($teamList);";}

       else {$query="SELECT team_id,name,nickname FROM team_history WHERE team_id IN ($teamList) AND year=$year;";}

       if ($_GET['showq']==1) {echo "$query<br/>";}

       $result=mysqli_query($db,$query);

      while ($row=mysqli_fetch_array($result))

       {

         $tid=$row['team_id'];

	 $teams[$tid]['name']=$row['name']." ".$row['nickname'];

	 $teams[$tid]['abbr']=$row['abbr'];

       }



      ## Display Results

      echo "<div class='textbox'>\n";

      echo " <table cellpadding=0 cellspacing=0 border=0>\n";

      echo "  <tr class='title'><td style='padding:2px'>$year ".$leagues[$league_id]['name']." Park Factors</td></tr>\n";

      echo "  <tr><td>";

      echo "   <table class='sortable' cellpadding=2 cellspacing=0 border=0 width='935px'>\n";

      echo "    <tr class='headline'><td class='hsc2_l'>Ballpark</td><td class='hsc2_l'>Team</td><td class='hsc2'>PFr</td><td class='hsc2'>PFhr</td></tr>\n";

      foreach ($parks as $pkid => $val)

       {

         foreach ($parks[$pkid] as $tid => $val2)

          {

            $pname=$parks[$pkid][$tid]['name'];

	    $rpf=sprintf("%.2f",$parks[$pkid][$tid]['rpf']);

   	    $hrpf=sprintf("%.2f",$parks[$pkid][$tid]['hrpf']);

	    $tname=$teams[$tid]['name'];

	    $tabbr=$teams[$tid]['abbr'];



	    $cls='s'.($cnt%2+1);

   	    echo "    <tr class='$cls'><td class='".$cls."_l'><a href='./parks.php?park=$pkid'>$pname</td>";

	    if ($league_id==$lgid) {echo "<td class='".$cls."_l'><a href='./team_park_history.php?team_id=$tid'>$tname</a></td>\n";}

	     else {echo "<td class='".$cls."_l'>$tname</td>\n";}

   	    echo "<td>$rpf</td>";

	    echo "<td>$hrpf</td>";

   	    echo "</tr>\n";

	    $cnt++;

   	  }

       }

      echo "   </table>\n";

      echo "  </td></tr>\n";

      echo " </table>\n";

      echo "</div>\n";

    }

    else

    {

      ## Display Results

      echo "<div class='textbox'>\n";

      echo " <table cellpadding=2 cellspacing=0 border=0 width='935px'>\n";

      echo "  <tr class='title'><td style='padding:2px'>$year ".$leagues[$league_id]['name']." Park Factors</td></tr>\n";

      echo "  <tr><td>No park factors recorded.</td></tr>\n";

      echo " </table>\n";

      echo "</div>\n";

    }

  }







  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);





?>

