<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgpath=$_SESSION['lgpath'];

  $date=new Date($_SESSION['lgdate']);

  $lgyear=$_SESSION['lgyear'];

  $lgMo=$date->format("m");

  $lgDay=$date->format("d");

  

  $view=$_GET['view'];

  $sub_league_id=$_GET['sub_league_id'];

  if ($sub_league_id=="") {$sub_league_id="ALL";}

  $team_id=$_GET['team_id'];

  if ($team_id=="") {$team_id="ALL";}

	  

  # Title Bar

  $title='Milestones';



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  nav_toolbar("season","Season");

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");

  

  ##### Display Filters #####

  echo " <div class='textbox'>\n";

  echo "  <form method='get' action='milestones.php' style='clear:left;'>\n";

  echo "  <table cellspacing=0 cellpadding=2 border=0>\n";

  echo "   <tr class='title'><td colspan=12>Filters</td></tr>\n";

  echo "   <tr>\n";

  

  ## Show Type Selection

  echo "     <td style='border-bottom:1px solid gray;'><label><b>Utility:</b></label></td>";

  echo "     <td style='border-bottom:1px solid gray;'><input type='radio' name='view' value='milestone' id='milestone'";

  if ($view=='milestone') {echo " checked='checked'";}

  echo "onclick=\"window.location='./milestones.php?view=milestone'\"></td>";

  echo "     <td style='border-bottom:1px solid gray;'><label for='milestone'>Milestone Watch</label></td>";

  echo "     <td style='border-bottom:1px solid gray;'><input type='radio' name='view' value='milestone_met' id='milestone_met'";

  if ($view=='milestone_met') {echo " checked='checked'";}

  echo "onclick=\"window.location='./milestones.php?view=milestone_met'\"></td>";

  echo "     <td style='border-bottom:1px solid gray;'><label for='milestone_met'>Milestones Reached</label></td>";

  echo "     <td style='border-bottom:1px solid gray;'><input type='radio' name='view' value='records' id='records'";

  if ($view=='records') {echo " checked='checked'";}

  echo "onclick=\"window.location='./milestones.php?view=records'\"></td>";

  echo "     <td style='border-bottom:1px solid gray;'><label for='records'>Record Watch</label></td>";



  if ($view!="")

  {

	  ## Get Subleagues

	  $query="SELECT sub_league_id,name,abbr FROM sub_leagues WHERE league_id=$lgid ORDER BY sub_league_id;";

     	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))

    	  {

		  $slid=$row['sub_league_id'];

	  	  $subleagues[$slid]['name']=$row['name'];

		  $subleagues[$slid]['abbr']=$row['abbr'];

	  }



	  ## Get Current Teams

	  $query="SELECT team_id,name,nickname,abbr,level,sub_league_id FROM teams WHERE league_id=$lgid AND allstar_team=0 ORDER BY name,nickname;";

     	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))

    	  {

		  $tid=$row['team_id'];

	  	  $slid=$row['sub_league_id'];

		  $teams[$tid]['name']=$row['name']." ".$row['nickname'];

	  	  $teams[$tid]['abbr']=$row['abbr'];

		  $teams[$tid]['level']=$row['level'];

	  	  $teams[$tid]['city']=$row['name'];

		  $teams[$tid]['slid']=$slid;

	  	  $subleagues[$slid]['teams']=$subleagues[$slid]['teams'].",$tid";

		  $LGtmList.=",$tid";

    	  }

	  $LGtmList=trim($LGtmList,",");

     	  foreach ($subleagues as $slid => $val) {$subleagues[$slid]['teams']=trim($subleagues[$slid]['teams'],",");}

  }

  

  if ($view=='records')

  {

     	  echo "    <td style='border-bottom:1px solid gray;' colspan=2>&nbsp;</td>\n";

	  echo "   </tr>\n";

     	  echo "   <tr>\n";

     

	  ## Show Subleague Filter

	  echo "    <td>&nbsp;</td>\n";

     	  echo "    <td><b>League:</b></td>\n";

	  echo "    <td>\n";

     	  echo "     <select name='sub_league_id' id='sub_league_id' onchange=\"if(this[this.selectedIndex].value!='ALL') {document.getElementById('team_id').selectedIndex=0;}\">\n";

	  echo "      <option value='ALL'>All</option>\n";

     	  foreach ($subleagues as $slid => $val)

	  {

	  	  echo "      <option value='$slid'";

		  if (($sub_league_id==$slid) && ($sub_league_id!="ALL")) {echo " selected";}

	  	  echo ">".$subleagues[$slid]['name']."</option>\n";

	  }

     	  echo "     </select>\n";

	  echo "    </td>\n";

     

	  ## Show Team Filter

	  echo "    <td>&nbsp;</td>\n";

     	  echo "    <td><b>Team:</b></td>\n";

	  echo "    <td>\n";

     	  echo "     <select name='team_id' id='team_id' onchange=\"if(this[this.selectedIndex].value!='ALL') {document.getElementById('sub_league_id').selectedIndex=0;}\">\n";

	  echo "      <option value='ALL'>All</option>\n";

     	  foreach ($teams as $tid => $val)

	  {

	  	  echo "      <option value='$tid'";

		  if ($team_id==$tid) {echo " selected";}

	  	  echo ">".$teams[$tid]['name']."</option>\n";

	  }

     	  echo "     </select>\n";

	  echo "    </td>\n";

     

	  ## Submission button

	  echo "    <td><input type='submit' value='Go'></input></td>\n";

  }

  

  ## Close Form

  echo "   </tr>\n";

  echo "  </table>\n";

  echo "  </form>\n";

  echo " </div>\n";



  if (($view=='milestone')||($view=='milestone_met'))

  {

	  ## Get Team Games Played

	  $query="SELECT t1.team_id,t1.played,t1.cnt+t2.cnt as cnt FROM (SELECT home_team as team_id,played,COUNT(game_id) as cnt FROM games WHERE league_id=$lgid AND game_type=0 GROUP BY team_id,played) as t1,(SELECT away_team as team_id,played,COUNT(game_id) as cnt FROM games WHERE league_id=$lgid AND game_type=0 GROUP BY team_id,played) as t2 WHERE t1.team_id=t2.team_id AND t1.played=t2.played";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  $played=$row['played'];

			  $cnt=$row['cnt'];



			  if (($played==1)&&($cnt>0)) {$maxYear=$lgyear;} else {$maxYear=$lgyear-1;}



			  $teams[$tid]['gcnt'][$played]=$cnt;

		  }

	  }

  }



  ##### Display Based on View #####

  switch ($view)

  {

  case 'milestone':

	  ##### Batting #####

	  echo "<div class='textbox'>\n";

       	  echo " <table cellpadding=2 cellspacing=0 border=0 width='935px'>\n";

	  $title="Batters";

       	  echo "  <tr class='title2'><td>$title</td></tr>\n";

	  echo "  <tr><td>\n";



	  $statArray=Array('H'=>'h','HR'=>'hr','RBI'=>'rbi','R'=>'r','2B'=>'d','3B'=>'t','SB'=>'sb','BB'=>'bb');

	  foreach ($statArray as $key => $statLbl)

	  {

		  ## Get Career Record Holder

		  $query="SELECT p.player_id,first_name,last_name,MIN(year) as minyr,MAX(year) as maxyr,".stat_query($statLbl)." as $statLbl FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id ORDER BY $statLbl ".stat_sort($statLbl)." LIMIT 2;";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  $cnt=1;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  $pname=$row['first_name']." ".$row['last_name'];

			  $statVal=$row[$statLbl];

			  if ($cnt==1)

			  {

				  $bleaders[$statLbl]['car']['pid']=$pid;

				  $bleaders[$statLbl]['car']['pname']=$pname;

				  $bleaders[$statLbl]['car']['years']=$row['minyr']."-".$row['maxyr'];

				  $bleaders[$statLbl]['car']['value']=$statVal;

			  }

			  $cnt++;

		  }



		  $twothirds=round($statVal*2/3,0);

		  $half=round($statVal/2,0);



		  if ($statVal>1500)

		  {

			  $step1=1000;

		 	  $step2=500;

			  $dpct=.4;

	   	  }

		  elseif ($statVal>1000)

	   	  {

			  $step1=500;

		 	  $step2=100;

			  $dpct=.4;

	   	  }

		  elseif ($statVal>200)

	   	  {

			  $step1=100;

		 	  $step2=50;

			  $dpct=.5;

	   	  }

		  elseif ($statVal>25)

	   	  {

			  $step1=50;

		 	  $step2=25;

			  $dpct=.4;

	   	  }

		  else

	   	  {

			  $step1=10;

		 	  $step2=5;

			  $dpct=.6;

	   	  }

		  $maxVal=$statVal-($statVal%$step2)+$step2;



		  ## Get Players Close to Milestone

		  $query="SELECT ".stat_query($statLbl,'pcs2')." as ".$statLbl."Sea,y.* FROM (";

		  $query.="SELECT first_name,last_name,($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'$lgMo-$lgDay')) as age,retired,team_id,organization_id,x.* FROM players as p,(";

		  $query.="SELECT player_id,$statLbl,milestone,milestone-$statLbl as diff,milestone/(milestone-$statLbl) as diffScore FROM (";



		  $query.="SELECT player_id,$statLbl,";



		  unset($point);

		  $point[1]=floor($half/$step1)*$step1;

		  if ($point[1]==0) {$point[1]=$step1;}

		  $nextAbove=ceil($bleaders[$statLbl]['car']['value']/$step2)*$step2;



		  for ($i=2;$i<=15;$i++)

		  {

			  if ($point[$i-1]>=$nextAbove)

			  {

				  break;

			  }

			  elseif ($point[$i-1]<$twothirds)

			  {

				  $point[$i]=$point[$i-1]+$step1;

			  }

			  else

			  {

				  $point[$i]=$point[$i-1]+$step2;

			  }

		  }



		  $ptQuery="";

		  for ($i=15;$i>=1;$i--)

		  {

			  if (!isset($point[$i])) {continue;}



			  if ($ptQuery=="")

			  {

				  $ptQuery="if($statLbl>=".$bleaders[$statLbl]['car']['value'].",".$nextAbove.",".$bleaders[$statLbl]['car']['value'].")";

			  }

			  else

			  {

				  $ptQuery="if($statLbl>=".$point[$i].",".$ptQuery.",".$point[$i].")";

			  }

		  }



		  $query.=$ptQuery." as milestone";



		  $query.=" FROM (";

		  $query.="SELECT player_id,".stat_query($statLbl)." as $statLbl FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING ".stat_query($statLbl).">=".($point[1]-$step2);

		  $query.=" AND MAX(year)=$maxYear";

		  $query.=") as pcs";

		  

		  $query.=") as mw ORDER BY diffScore DESC LIMIT 25) as x";

		  $query.=" WHERE p.player_id=x.player_id) as y";

		  $query.=" LEFT JOIN players_career_batting_stats as pcs2 ON pcs2.player_id=y.player_id WHERE league_id=$lgid AND split_id=1 AND year=$lgyear GROUP BY player_id";

		  $query.=" ORDER BY milestone DESC,diff";

		  



		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

		  {

			  echo "  <table cellpadding=2 cellspacing=0 border=0 width='915px' style='border:1px solid black;margin:10px'>\n";

		    	  echo "   <tr class='title'><td colspan=8>".stat_text($statLbl)." Milestones</td></tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l' colspan=2>Record Holder</td><td class='hsc2' colspan=2>Years</td><td class='hsc2' colspan=4>Value</td></tr>\n";

		    	  echo "   <tr class='s2'>";

			  echo "<td class='s2_l' colspan=2><a href='./player.php?player_id=".$bleaders[$statLbl]['car']['pid']."'>".$bleaders[$statLbl]['car']['pname']."</a></td>";

		    	  $yr=$bleaders[$statLbl]['car']['years'];

			  echo "<td colspan=2>".$yr."</td>";

		    	  echo "<td colspan=4>".$bleaders[$statLbl]['car']['value']."</td>";

			  echo "</tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2'>Tm</td><td class='hsc2'>Age</td><td class='hsc2'>Milestone</td><td class='hsc2'>Current ".stat_text($statLbl,2)."</td><td class='hsc2'>Diff</td><td class='hsc2'>This Year</td><td class='hsc2'>Projected ".stat_text($statLbl,2)."</td></tr>\n";



			  $cnt=0;

			  $seaLbl=$statLbl."Sea";

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];



				  $cls='s'.($cnt%2+1);

		   		  echo "   <tr class='$cls'>";

				  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";

		   		  $tid=$row['organization_id'];

				  echo "<td><a href='./team_summary.php?team_id=$tid&year=$lgyear'>".$teams[$tid]['abbr']."</a></td>";

		   		  echo "<td>".$row['age']."</td>";

		   		  echo "<td>".$row['milestone']."</td>";

		   		  echo "<td>".$row[$statLbl]."</td>";

		   		  echo "<td>".$row['diff']."</td>";



				  $thisYr=$row[$seaLbl];

				  if ($row['retired']==1)

				  {

					  $projTot=$row[$statLbl];

				  }

				  else

				  {

					  if ($teams[$tid]['gcnt'][1]==0) {$projSeaTot=$thisYr;}

					  else

					  {

						  $projSeaTot=$thisYr/$teams[$tid]['gcnt'][1];

						  $projSeaTot=$projSeaTot*($teams[$tid]['gcnt'][1]+$teams[$tid]['gcnt'][0]);

					  }

					  $projTot=$row[$statLbl]-$thisYr+round($projSeaTot,0);

				  }



				  echo "<td>".$thisYr."</td>";

		   		  echo "<td>".$projTot."</td>";

				  echo "</tr>\n";

				  $cnt++;

			  }



			  echo "   <tr class='headline'><td colspan=8 class='hsc2'>Show Leaderboard: <a href='./leaderboards.php?view=players&scope=career&sub_league_id=ALL&listing=top100&team_id=ALL&split=regular&stat=$statLbl&who=active&pos=ALL'>Active</a>/<a href='./leaderboards.php?view=players&scope=career&sub_league_id=ALL&listing=top100&team_id=ALL&split=regular&stat=$statLbl&who=ALL&pos=ALL'>All</a></td></tr>\n";

		    	  echo "  </table>\n";

		  }



	  }

	  echo "  </td></tr>\n";

	  echo " </table>\n";

       	  echo "</div>\n";



	  ##### Pitching #####

	  echo "<div class='textbox'>\n";

       	  echo " <table cellpadding=2 cellspacing=0 border=0 width='935px'>\n";

	  $title="Pitchers";

       	  echo "  <tr class='title2'><td>$title</td></tr>\n";

	  echo "  <tr><td>\n";



	  unset($bleaders);

	  $statArray=Array('W'=>'w','SV'=>'s','K'=>'k','CG'=>'cg','SHO'=>'sho','G'=>'g','HLD'=>'hld');

	  foreach ($statArray as $key => $statLbl)

	  {

		  ## Get Career Record Holder

		  $query="SELECT p.player_id,first_name,last_name,MIN(year) as minyr,MAX(year) as maxyr,".stat_query($statLbl)." as $statLbl FROM players as p,players_career_pitching_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id ORDER BY $statLbl ".stat_sort($statLbl)." LIMIT 2;";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  $cnt=1;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  $pname=$row['first_name']." ".$row['last_name'];

			  $statVal=$row[$statLbl];

			  if ($cnt==1)

			  {

				  $bleaders[$statLbl]['car']['pid']=$pid;

				  $bleaders[$statLbl]['car']['pname']=$pname;

				  $bleaders[$statLbl]['car']['years']=$row['minyr']."-".$row['maxyr'];

				  $bleaders[$statLbl]['car']['value']=$statVal;

			  }

			  $cnt++;

		  }



		  $twothirds=round($statVal*2/3,0);

		  $half=round($statVal/2,0);



		  if ($statVal>1500)

		  {

			  $step1=1000;

		 	  $step2=500;

			  $dpct=.4;

	   	  }

		  elseif ($statVal>1000)

	   	  {

			  $step1=500;

		 	  $step2=100;

			  $dpct=.4;

	   	  }

		  elseif ($statVal>200)

	   	  {

			  $step1=100;

		 	  $step2=50;

			  $dpct=.5;

	   	  }

		  elseif ($statVal>25)

	   	  {

			  $step1=50;

		 	  $step2=25;

			  $dpct=.4;

	   	  }

		  else

	   	  {

			  $step1=10;

		 	  $step2=5;

			  $dpct=.6;

	   	  }

		  $maxVal=$statVal-($statVal%$step2)+$step2;



		  ## Get Players Close to Milestone

		  $query="SELECT ".stat_query($statLbl,'pcs2')." as ".$statLbl."Sea,y.* FROM (";

		  $query.="SELECT first_name,last_name,($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'$lgMo-$lgDay')) as age,retired,team_id,organization_id,x.* FROM players as p,(";

		  $query.="SELECT player_id,$statLbl,milestone,milestone-$statLbl as diff,milestone/(milestone-$statLbl) as diffScore FROM (";



		  $query.="SELECT player_id,$statLbl,";



		  unset($point);

		  $point[1]=floor($half/$step1)*$step1;

		  if ($point[1]==0) {$point[1]=$step1;}

		  $nextAbove=ceil($bleaders[$statLbl]['car']['value']/$step2)*$step2;



		  for ($i=2;$i<=15;$i++)

		  {

			  if ($point[$i-1]>=$nextAbove)

			  {

				  break;

			  }

			  elseif ($point[$i-1]<$twothirds)

			  {

				  $point[$i]=$point[$i-1]+$step1;

			  }

			  else

			  {

				  $point[$i]=$point[$i-1]+$step2;

			  }

		  }



		  $ptQuery="";

		  for ($i=15;$i>=1;$i--)

		  {

			  if (!isset($point[$i])) {continue;}



			  if ($ptQuery=="")

			  {

				  $ptQuery="if($statLbl>=".$bleaders[$statLbl]['car']['value'].",".$nextAbove.",".$bleaders[$statLbl]['car']['value'].")";

			  }

			  else

			  {

				  $ptQuery="if($statLbl>=".$point[$i].",".$ptQuery.",".$point[$i].")";

			  }

		  }



		  $query.=$ptQuery." as milestone";



		  $query.=" FROM (";

		  $query.="SELECT player_id,".stat_query($statLbl)." as $statLbl FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING ".stat_query($statLbl).">=".($point[1]-$step2);

		  $query.=" AND MAX(year)=$maxYear";

		  $query.=") as pcs";

		  

		  $query.=") as mw ORDER BY diffScore DESC LIMIT 25) as x";

		  $query.=" WHERE p.player_id=x.player_id) as y";

		  $query.=" LEFT JOIN players_career_pitching_stats as pcs2 ON pcs2.player_id=y.player_id WHERE league_id=$lgid AND split_id=1 AND year=$lgyear GROUP BY player_id";

		  $query.=" ORDER BY milestone DESC,diff";

		  



		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

		  {

			  echo "  <table cellpadding=2 cellspacing=0 border=0 width='915px' style='border:1px solid black;margin:10px'>\n";

		    	  echo "   <tr class='title'><td colspan=8>".stat_text($statLbl)." Milestones</td></tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l' colspan=2>Record Holder</td><td class='hsc2' colspan=2>Years</td><td class='hsc2' colspan=4>Value</td></tr>\n";

		    	  echo "   <tr class='s2'>";

			  echo "<td class='s2_l' colspan=2><a href='./player.php?player_id=".$bleaders[$statLbl]['car']['pid']."'>".$bleaders[$statLbl]['car']['pname']."</a></td>";

		    	  $yr=$bleaders[$statLbl]['car']['years'];

			  echo "<td colspan=2>".$yr."</td>";

		    	  echo "<td colspan=4>".$bleaders[$statLbl]['car']['value']."</td>";

			  echo "</tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2'>Tm</td><td class='hsc2'>Age</td><td class='hsc2'>Milestone</td><td class='hsc2'>Current ".stat_text($statLbl,2)."</td><td class='hsc2'>Diff</td><td class='hsc2'>This Year</td><td class='hsc2'>Projected ".stat_text($statLbl,2)."</td></tr>\n";



			  $cnt=0;

			  $seaLbl=$statLbl."Sea";

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];



				  $cls='s'.($cnt%2+1);

		   		  echo "   <tr class='$cls'>";

				  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";

		   		  $tid=$row['organization_id'];

				  echo "<td><a href='./team_summary.php?team_id=$tid&year=$lgyear'>".$teams[$tid]['abbr']."</a></td>";

		   		  echo "<td>".$row['age']."</td>";

		   		  echo "<td>".$row['milestone']."</td>";

		   		  echo "<td>".$row[$statLbl]."</td>";

		   		  echo "<td>".$row['diff']."</td>";



				  $thisYr=$row[$seaLbl];

				  if ($row['retired']==1)

				  {

					  $projTot=$row[$statLbl];

				  }

				  else

				  {

					  if ($teams[$tid]['gcnt'][1]==0) {$projSeaTot=$thisYr;}

					  else

					  {

						  $projSeaTot=$thisYr/$teams[$tid]['gcnt'][1];

						  $projSeaTot=$projSeaTot*($teams[$tid]['gcnt'][1]+$teams[$tid]['gcnt'][0]);

					  }

					  $projTot=$row[$statLbl]-$thisYr+round($projSeaTot,0);

				  }



				  echo "<td>".$thisYr."</td>";

		   		  echo "<td>".$projTot."</td>";

				  echo "</tr>\n";

				  $cnt++;

			  }



			  echo "   <tr class='headline'><td colspan=8 class='hsc2'>Show Leaderboard: <a href='./leaderboards.php?view=players&scope=career&sub_league_id=ALL&listing=top100&team_id=ALL&split=regular&stat=$statLbl&who=active&pos=ALL'>Active</a>/<a href='./leaderboards.php?view=players&scope=career&sub_league_id=ALL&listing=top100&team_id=ALL&split=regular&stat=$statLbl&who=ALL&pos=ALL'>All</a></td></tr>\n";

		    	  echo "  </table>\n";

		  }



	  }

	  echo "  </td></tr>\n";

	  echo " </table>\n";

	  echo "</div>\n";



	  break;

  case 'milestone_met':

	  ##### Batting #####

	  echo "<div class='textbox'>\n";

       	  echo " <table cellpadding=2 cellspacing=0 border=0 width='935px'>\n";

	  $title="Batters";

       	  echo "  <tr class='title2'><td>$title</td></tr>\n";

	  echo "  <tr><td>\n";



	  $statArray=Array('H'=>'h','HR'=>'hr','RBI'=>'rbi','R'=>'r','2B'=>'d','3B'=>'t','SB'=>'sb','BB'=>'bb');

	  foreach ($statArray as $key => $statLbl)

	  {

		  ## Get Career Record Holder

		  $query="SELECT p.player_id,first_name,last_name,MIN(year) as minyr,MAX(year) as maxyr,".stat_query($statLbl)." as $statLbl FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id ORDER BY $statLbl ".stat_sort($statLbl)." LIMIT 2;";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  $cnt=1;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  $pname=$row['first_name']." ".$row['last_name'];

			  $statVal=$row[$statLbl];

			  if ($cnt==1)

			  {

				  $bleaders[$statLbl]['car']['pid']=$pid;

				  $bleaders[$statLbl]['car']['pname']=$pname;

				  $bleaders[$statLbl]['car']['years']=$row['minyr']."-".$row['maxyr'];

				  $bleaders[$statLbl]['car']['value']=$statVal;

			  }

			  $cnt++;

		  }



		  $twothirds=round($statVal*2/3,0);

		  $half=round($statVal/2,0);



		  if ($statVal>1500)

		  {

			  $step1=1000;

		 	  $step2=500;

			  $dpct=.4;

	   	  }

		  elseif ($statVal>1000)

	   	  {

			  $step1=500;

		 	  $step2=100;

			  $dpct=.4;

	   	  }

		  elseif ($statVal>200)

	   	  {

			  $step1=100;

		 	  $step2=50;

			  $dpct=.5;

	   	  }

		  elseif ($statVal>25)

	   	  {

			  $step1=50;

		 	  $step2=25;

			  $dpct=.4;

	   	  }

		  else

	   	  {

			  $step1=10;

		 	  $step2=5;

			  $dpct=.6;

	   	  }

		  $maxVal=$statVal-($statVal%$step2)+$step2;



		  ## Get Players Close to Milestone

		  unset($point);

		  $point[1]=floor($half/$step1)*$step1;

		  if ($point[1]==0) {$point[1]=$step1;}



		  for ($i=2;$i<=15;$i++)

		  {

			  if ($point[$i-1]>=$bleaders[$statLbl]['car']['value'])

			  {

				  break;

			  }

			  elseif ($point[$i-1]<$twothirds)

			  {

				  $point[$i]=$point[$i-1]+$step1;

			  }

			  else

			  {

				  $point[$i]=$point[$i-1]+$step2;

			  }

		  }



		  for ($i=1;$i<=15;$i++)

		  {

			  if (!isset($point[$i])) {break;}



			  if ($i==1)

			  {

				  $ptQuery="if((t2.$statLbl>=".$point[$i].")AND(t1.$statLbl<".$point[$i]."),".$point[$i].",0)";

			  }

			  else

			  {

				  $ptQuery="if((t2.$statLbl>=".$point[$i].")AND(t1.$statLbl<".$point[$i]."),".$point[$i].",$ptQuery)";

			  }

		  }

		  $ptQuery="if(t2.$statLbl=".$bleaders[$statLbl]['car']['value'].",".$bleaders[$statLbl]['car']['value'].",$ptQuery)";





		  $query="SELECT first_name,last_name,($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'$lgMo-$lgDay')) as age,retired,team_id,organization_id,x.* FROM players as p,(";

		  $query.="SELECT t1.player_id,t1.$statLbl as priorStat,t2.$statLbl-t1.$statLbl as thisYr,t2.$statLbl as carTot,";



		  $query.=$ptQuery." as milestone";



		  $query.=" FROM ";

		  $query.="(SELECT player_id,".stat_query($statLbl)." as $statLbl FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING MAX(year)=$maxYear) as t2";

		  $query.=" LEFT JOIN ";

		  $query.="(SELECT player_id,".stat_query($statLbl)." as $statLbl FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND year<$lgyear GROUP BY player_id) as t1";

		  $query.=" ON t1.player_id=t2.player_id WHERE t2.$statLbl>".$point[1];

		  $query.=") as x WHERE p.player_id=x.player_id AND milestone>0";

		  $query.=" ORDER BY milestone DESC,carTot DESC,thisYr DESC";

	

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

		  {

			  echo "  <table cellpadding=2 cellspacing=0 border=0 width='915px' style='border:1px solid black;margin:10px'>\n";

		    	  echo "   <tr class='title'><td colspan=8>".stat_text($statLbl)." Milestones</td></tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l' colspan=2>Record Holder</td><td class='hsc2' colspan=2>Years</td><td class='hsc2' colspan=4>Value</td></tr>\n";

		    	  echo "   <tr class='s2'>";

			  echo "<td class='s2_l' colspan=2><a href='./player.php?player_id=".$bleaders[$statLbl]['car']['pid']."'>".$bleaders[$statLbl]['car']['pname']."</a></td>";

		    	  $yr=$bleaders[$statLbl]['car']['years'];

			  echo "<td colspan=2>".$yr."</td>";

		    	  echo "<td colspan=4>".$bleaders[$statLbl]['car']['value']."</td>";

			  echo "</tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2'>Tm</td><td class='hsc2'>Age</td><td class='hsc2'>Milestone</td><td class='hsc2'>Prior to $lgyear</td><td class='hsc2'>Career ".stat_text($statLbl,2)."</td><td class='hsc2'>This Year</td><td class='hsc2'>Projected ".stat_text($statLbl,2)."</td></tr>\n";



			  $cnt=0;

			  $seaLbl=$statLbl."Sea";

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];



				  $cls='s'.($cnt%2+1);

		   		  echo "   <tr class='$cls'>";

				  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";

		   		  $tid=$row['organization_id'];

				  echo "<td><a href='./team_summary.php?team_id=$tid&year=$lgyear'>".$teams[$tid]['abbr']."</a></td>";

		   		  echo "<td>".$row['age']."</td>";

				  echo "<td>".$row['milestone']."</td>";

				  echo "<td>".$row['priorStat']."</td>";

		   		  echo "<td>".$row['carTot']."</td>";





				  $thisYr=$row['thisYr'];

				  if ($row['retired']==1)

				  {

					  $projTot=$row[$statLbl];

				  }

				  else

				  {

					  $projSeaTot=$thisYr/$teams[$tid]['gcnt'][1];

					  $projSeaTot=$projSeaTot*($teams[$tid]['gcnt'][1]+$teams[$tid]['gcnt'][0]);

					  $projTot=$row['priorStat']+round($projSeaTot,0);

				  }



				  echo "<td>".$thisYr."</td>";

		   		  echo "<td>".$projTot."</td>";

				  echo "</tr>\n";

				  $cnt++;

			  }



			  echo "   <tr class='headline'><td colspan=8 class='hsc2'>Show Leaderboard: <a href='./leaderboards.php?view=players&scope=career&sub_league_id=ALL&listing=top100&team_id=ALL&split=regular&stat=$statLbl&who=active&pos=ALL'>Active</a>/<a href='./leaderboards.php?view=players&scope=career&sub_league_id=ALL&listing=top100&team_id=ALL&split=regular&stat=$statLbl&who=ALL&pos=ALL'>All</a></td></tr>\n";

		    	  echo "  </table>\n";

		  }





	  }



	  echo "  </td></tr>\n";

	  echo " </table>\n";

	  echo "</div>\n";



	  ##### Pitching #####

	  echo "<div class='textbox'>\n";

       	  echo " <table cellpadding=2 cellspacing=0 border=0 width='935px'>\n";

	  $title="Pitchers";

       	  echo "  <tr class='title2'><td>$title</td></tr>\n";

	  echo "  <tr><td>\n";



	  $statArray=Array('W'=>'w','SV'=>'s','K'=>'k','CG'=>'cg','SHO'=>'sho','G'=>'g','HLD'=>'hld');

	  foreach ($statArray as $key => $statLbl)

	  {

		  ## Get Career Record Holder

		  $query="SELECT p.player_id,first_name,last_name,MIN(year) as minyr,MAX(year) as maxyr,".stat_query($statLbl)." as $statLbl FROM players as p,players_career_pitching_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id ORDER BY $statLbl ".stat_sort($statLbl)." LIMIT 2;";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  $cnt=1;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  $pname=$row['first_name']." ".$row['last_name'];

			  $statVal=$row[$statLbl];

			  if ($cnt==1)

			  {

				  $bleaders[$statLbl]['car']['pid']=$pid;

				  $bleaders[$statLbl]['car']['pname']=$pname;

				  $bleaders[$statLbl]['car']['years']=$row['minyr']."-".$row['maxyr'];

				  $bleaders[$statLbl]['car']['value']=$statVal;

			  }

			  $cnt++;

		  }



		  $twothirds=round($statVal*2/3,0);

		  $half=round($statVal/2,0);



		  if ($statVal>1500)

		  {

			  $step1=1000;

		 	  $step2=500;

			  $dpct=.4;

	   	  }

		  elseif ($statVal>1000)

	   	  {

			  $step1=500;

		 	  $step2=100;

			  $dpct=.4;

	   	  }

		  elseif ($statVal>200)

	   	  {

			  $step1=100;

		 	  $step2=50;

			  $dpct=.5;

	   	  }

		  elseif ($statVal>25)

	   	  {

			  $step1=50;

		 	  $step2=25;

			  $dpct=.4;

	   	  }

		  else

	   	  {

			  $step1=10;

		 	  $step2=5;

			  $dpct=.6;

	   	  }

		  $maxVal=$statVal-($statVal%$step2)+$step2;



		  ## Get Players Close to Milestone

		  unset($point);

		  $point[1]=floor($half/$step1)*$step1;

		  if ($point[1]==0) {$point[1]=$step1;}



		  for ($i=2;$i<=15;$i++)

		  {

			  if ($point[$i-1]>=$bleaders[$statLbl]['car']['value'])

			  {

				  break;

			  }

			  elseif ($point[$i-1]<$twothirds)

			  {

				  $point[$i]=$point[$i-1]+$step1;

			  }

			  else

			  {

				  $point[$i]=$point[$i-1]+$step2;

			  }

		  }



		  for ($i=1;$i<=15;$i++)

		  {

			  if (!isset($point[$i])) {break;}



			  if ($i==1)

			  {

				  $ptQuery="if((t2.$statLbl>=".$point[$i].")AND(t1.$statLbl<".$point[$i]."),".$point[$i].",0)";

			  }

			  else

			  {

				  $ptQuery="if((t2.$statLbl>=".$point[$i].")AND(t1.$statLbl<".$point[$i]."),".$point[$i].",$ptQuery)";

			  }

		  }

		  $ptQuery="if(t2.$statLbl=".$bleaders[$statLbl]['car']['value'].",".$bleaders[$statLbl]['car']['value'].",$ptQuery)";





		  $query="SELECT first_name,last_name,($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'$lgMo-$lgDay')) as age,retired,team_id,organization_id,x.* FROM players as p,(";

		  $query.="SELECT t1.player_id,t1.$statLbl as priorStat,t2.$statLbl-t1.$statLbl as thisYr,t2.$statLbl as carTot,";



		  $query.=$ptQuery." as milestone";



		  $query.=" FROM ";

		  $query.="(SELECT player_id,".stat_query($statLbl)." as $statLbl FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id HAVING MAX(year)=$maxYear) as t2";

		  $query.=" LEFT JOIN ";

		  $query.="(SELECT player_id,".stat_query($statLbl)." as $statLbl FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND year<$lgyear GROUP BY player_id) as t1";

		  $query.=" ON t1.player_id=t2.player_id WHERE t2.$statLbl>".$point[1];

		  $query.=") as x WHERE p.player_id=x.player_id AND milestone>0";

		  $query.=" ORDER BY milestone DESC,carTot DESC,thisYr DESC";

	

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

		  {

			  echo "  <table cellpadding=2 cellspacing=0 border=0 width='915px' style='border:1px solid black;margin:10px'>\n";

		    	  echo "   <tr class='title'><td colspan=8>".stat_text($statLbl)." Milestones</td></tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l' colspan=2>Record Holder</td><td class='hsc2' colspan=2>Years</td><td class='hsc2' colspan=4>Value</td></tr>\n";

		    	  echo "   <tr class='s2'>";

			  echo "<td class='s2_l' colspan=2><a href='./player.php?player_id=".$bleaders[$statLbl]['car']['pid']."'>".$bleaders[$statLbl]['car']['pname']."</a></td>";

		    	  $yr=$bleaders[$statLbl]['car']['years'];

			  echo "<td colspan=2>".$yr."</td>";

		    	  echo "<td colspan=4>".$bleaders[$statLbl]['car']['value']."</td>";

			  echo "</tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2'>Tm</td><td class='hsc2'>Age</td><td class='hsc2'>Milestone</td><td class='hsc2'>Prior to $lgyear</td><td class='hsc2'>Career ".stat_text($statLbl,2)."</td><td class='hsc2'>This Year</td><td class='hsc2'>Projected ".stat_text($statLbl,2)."</td></tr>\n";



			  $cnt=0;

			  $seaLbl=$statLbl."Sea";

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];



				  $cls='s'.($cnt%2+1);

		   		  echo "   <tr class='$cls'>";

				  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";

		   		  $tid=$row['organization_id'];

				  echo "<td><a href='./team_summary.php?team_id=$tid&year=$lgyear'>".$teams[$tid]['abbr']."</a></td>";

		   		  echo "<td>".$row['age']."</td>";

				  echo "<td>".$row['milestone']."</td>";

				  echo "<td>".$row['priorStat']."</td>";

		   		  echo "<td>".$row['carTot']."</td>";





				  $thisYr=$row['thisYr'];

				  if ($row['retired']==1)

				  {

					  $projTot=$row[$statLbl];

				  }

				  else

				  {

					  $projSeaTot=$thisYr/$teams[$tid]['gcnt'][1];

					  $projSeaTot=$projSeaTot*($teams[$tid]['gcnt'][1]+$teams[$tid]['gcnt'][0]);

					  $projTot=$row['priorStat']+round($projSeaTot,0);

				  }



				  echo "<td>".$thisYr."</td>";

		   		  echo "<td>".$projTot."</td>";

				  echo "</tr>\n";

				  $cnt++;

			  }



			  echo "   <tr class='headline'><td colspan=8 class='hsc2'>Show Leaderboard: <a href='./leaderboards.php?view=players&scope=career&sub_league_id=ALL&listing=top100&team_id=ALL&split=regular&stat=$statLbl&who=active&pos=ALL'>Active</a>/<a href='./leaderboards.php?view=players&scope=career&sub_league_id=ALL&listing=top100&team_id=ALL&split=regular&stat=$statLbl&who=ALL&pos=ALL'>All</a></td></tr>\n";

		    	  echo "  </table>\n";

		  }





	  }



	  echo "  </td></tr>\n";

	  echo " </table>\n";

	  echo "</div>\n";



	  break;

  case 'records':

	  ## Games played query

	  $gpQuery="SELECT played.team_id,totals.gms/played.gms as gpRate FROM (SELECT team_id,SUM(g) as gms FROM (SELECT home_team as team_id,COUNT(game_id) as g FROM games WHERE league_id=$lgid AND game_type=0 AND played=1 GROUP BY home_team UNION ALL SELECT away_team as team_id,COUNT(game_id) as g FROM games WHERE league_id=$lgid AND game_type=0 AND played=1 GROUP BY away_team) as x GROUP BY team_id) as played,(SELECT team_id,SUM(g) as gms FROM (SELECT home_team as team_id,COUNT(game_id) as g FROM games WHERE league_id=$lgid AND game_type=0 GROUP BY home_team UNION ALL SELECT away_team as team_id,COUNT(game_id) as g FROM games WHERE league_id=$lgid AND game_type=0 GROUP BY away_team) as x GROUP BY team_id) as totals WHERE played.team_id=totals.team_id";



	  ##### Batting #####

	  echo "<div class='textbox'>\n";

       	  echo " <table cellpadding=2 cellspacing=0 border=0 width='935px'>\n";

	  $title="Batters";

       	  echo "  <tr class='title2'><td>$title</td></tr>\n";

	  echo "  <tr><td>\n";





	  $statArray=Array('H'=>'h','HR'=>'hr','RBI'=>'rbi','R'=>'r','2B'=>'d','3B'=>'t','SB'=>'sb','BB'=>'bb');



	  ## Seasonal

	  echo " <div id='first' class='boxscores' style='margin-left:10px;width:440px;'>\n";

       	  echo "  <table cellpadding=2 cellspacing=0 border=0 style='border:0;margin:0;width:100%;'>\n";

	  echo "   <tr class='title'><td>Seasonal Projections</td></tr>\n";

       	  echo "  </table>\n";

	  foreach ($statArray as $key => $statLbl)

	  {

		  ## Get record holder

		  $query="SELECT p.player_id,first_name,last_name,pcs.team_id,year,".stat_query($statLbl)." as stat FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1";

	    	  if ($sub_league_id!="ALL") {$query.=" AND pcs.team_id IN (".$subleagues[$sub_league_id]['teams'].")";}

		  if ($team_id!="ALL") {$query.=" AND pcs.team_id=$team_id";}

	    	  $query.=" GROUP BY player_id,year ORDER BY stat DESC LIMIT 1;";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  $row=mysqli_fetch_array($result);

		  $pid=$row['player_id'];

	    	  $pname=$row['first_name']." ".$row['last_name'];

		  $yr=$row['year'];

	    	  $statVal=$row['stat'];

		  $bleaders[$statLbl]['sea']['pid']=$pid;

	    	  $bleaders[$statLbl]['sea']['tid']=$row['team_id'];

		  $bleaders[$statLbl]['sea']['pname']=$pname;

	    	  $bleaders[$statLbl]['sea']['value']=$statVal;

		  $bleaders[$statLbl]['sea']['yr']=$yr;



		  ## Get top 5 players

		  $statQuery="SELECT player_id,team_id,".stat_query($statLbl)." as $statLbl FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND year=$lgyear";

		  if ($sub_league_id!="ALL") {$statQuery.=" AND team_id IN (".$subleagues[$sub_league_id]['teams'].")";}

	       	  if ($team_id!="ALL") {$statQuery.=" AND team_id=$team_id";}

		  $statQuery.=" GROUP BY player_id ORDER BY $statLbl DESC LIMIT 100";



		  $statQuery="SELECT p.player_id,first_name,last_name,($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'$lgMo-$lgDay')) as age,p.team_id,$statLbl FROM players as p,($statQuery) as y WHERE p.player_id=y.player_id ";

		  if ($sub_league_id!="ALL") {$statQuery.=" AND p.team_id IN (".$subleagues[$sub_league_id]['teams'].")";}

	       	  if ($team_id!="ALL") {$statQuery.=" AND p.team_id=$team_id";}



		  $query="SELECT player_id,first_name,last_name,age,pcs.team_id,$statLbl as thisYr,$statLbl*gpRate as projTot FROM ($statQuery) as pcs,($gpQuery) as t WHERE pcs.team_id=t.team_id ORDER BY projTot DESC LIMIT 5";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

		  {

			  echo "  <table cellpadding=2 cellspacing=0 border=0 width='420px'>\n";

		    	  echo "   <tr class='title'><td colspan=4>".stat_text($statLbl)." Projections</td></tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l'>Record Holder</td><td class='hsc2'>Tm</td><td class='hsc2'>Year</td><td class='hsc2'>Value</td></tr>\n";

		    	  echo "   <tr class='s2'>";

			  echo "<td class='s2_l'><a href='./player.php?player_id=".$bleaders[$statLbl]['sea']['pid']."'>".$bleaders[$statLbl]['sea']['pname']."</a></td>";

		    	  $tid=$bleaders[$statLbl]['sea']['tid'];

			  $yr=$bleaders[$statLbl]['sea']['yr'];

		    	  echo "<td><a href='./team_summary.php?team_id=$tid&year=$yr'>".$teams[$tid]['abbr']."</a></td>";

			  echo "<td>".$yr."</td>";

		    	  echo "<td>".$bleaders[$statLbl]['sea']['value']."</td>";

			  echo "</tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2'>Tm</td><td class='hsc2'>Current</td><td class='hsc2'>Projected</td></tr>\n";



			  $cnt=0;

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];



				  $cls='s'.($cnt%2+1);

		      		  echo "   <tr class='$cls'>";

				  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";

		      		  $tid=$row['team_id'];

				  echo "<td><a href='./team_summary.php?team_id=$tid&year=$lgyear'>".$teams[$tid]['abbr']."</a></td>";

		      		  echo "<td>".$row['thisYr']."</td>";

				  echo "<td>".round($row['projTot'],0)."</td>";

		      		  echo "</tr>\n";

				  $cnt++;

			  }

			  if ($sub_league_id=="ALL") {$dispSL="ALL";} else {$dispSL=$sub_league_id;}

		    	  if ($team_id=="ALL") {$dispTeam="ALL";} else {$dispTeam=$team_id;}

			  echo "   <tr class='headline'><td colspan=4 class='hsc2'>Leaderboard: <a href='./leaderboards.php?view=players&scope=season&sub_league_id=$dispSL&listing=top100&team_id=$dispTeam&split=regular&stat=$statLbl&who=ALL&pos=ALL'>Show</a></td></tr>\n";

			  echo "  </table>\n";

		  }

	  }

	  echo " </div>\n";



	  ## Career

	  echo " <div class='boxscores' style='margin-right:10px;width:440px;float:right;'>\n";

       	  echo "  <table cellpadding=2 cellspacing=0 border=0 style='border:0;margin:0;width:100%;'>\n";

	  echo "   <tr class='title'><td>Career Projections (through remainder of this season)</td></tr>\n";

       	  echo "  </table>\n";

	  foreach ($statArray as $key => $statLbl)

	  {

		  ## Get record holder

		  $query="SELECT p.player_id,first_name,last_name,MIN(year) as minyr,MAX(year) as maxyr,".stat_query($statLbl)." as stat FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1";

	    	  if ($sub_league_id!="ALL") {$query.=" AND pcs.team_id IN (".$subleagues[$sub_league_id]['teams'].")";}

		  if ($team_id!="ALL") {$query.=" AND pcs.team_id=$team_id";}

		    	  $query.=" GROUP BY player_id ORDER BY stat DESC LIMIT 1;";

		  $result=mysqli_query($db,$query);

	    	  $row=mysqli_fetch_array($result);

		  $pid=$row['player_id'];

	    	  $pname=$row['first_name']." ".$row['last_name'];

		  $statVal=$row['stat'];

	    	  $bleaders[$statLbl]['car']['pid']=$pid;

		  $bleaders[$statLbl]['car']['pname']=$pname;

	    	  $bleaders[$statLbl]['car']['years']=$row['minyr']."-".$row['maxyr'];

		  $bleaders[$statLbl]['car']['value']=$statVal;



		  ## Get top 5 players

		  $statQuery="SELECT first_name,last_name,organization_id as team_id,($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'$lgMo-$lgDay')) as age,y.* FROM players as p,(";

		  $statQuery.="SELECT t2.player_id,IF(t1.$statLbl IS NULL,t2.$statLbl,t2.$statLbl-t1.$statLbl) as thisYr,IF(t1.$statLbl IS NULL,0,t1.$statLbl) as priorStat,t2.$statLbl as carTot FROM ";

		  $statQuery.="(SELECT player_id,".stat_query($statLbl)." as $statLbl FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1";

		  if ($sub_league_id!="ALL") {$statQuery.=" AND team_id IN (".$subleagues[$sub_league_id]['teams'].")";}

	       	  if ($team_id!="ALL") {$statQuery.=" AND team_id=$team_id";}

		  $statQuery.=" GROUP BY player_id HAVING MAX(year)=$lgyear AND ".stat_query($statLbl).">0) as t2";

		  $statQuery.=" LEFT JOIN ";

		  $statQuery.="(SELECT player_id,".stat_query($statLbl)." as $statLbl FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND year<$lgyear";

		  if ($sub_league_id!="ALL") {$statQuery.=" AND team_id IN (".$subleagues[$sub_league_id]['teams'].")";}

	       	  if ($team_id!="ALL") {$statQuery.=" AND team_id=$team_id";}

		  $statQuery.=" GROUP BY player_id) as t1";

		  $statQuery.=" ON t1.player_id=t2.player_id WHERE t2.$statLbl>0";

		  $statQuery.=" ORDER BY carTot DESC LIMIT 200) as y";

		  $statQuery.=" WHERE p.player_id=y.player_id";

		  if ($sub_league_id!="ALL") {$statQuery.=" AND p.organization_id IN (".$subleagues[$sub_league_id]['teams'].")";}

	       	  if ($team_id!="ALL") {$statQuery.=" AND p.organization_id=$team_id";}

	

		  $query="SELECT x.*,priorStat+thisYr*gpRate as projTot FROM ($gpQuery) as t,($statQuery) as x WHERE t.team_id=x.team_id ORDER BY projTot DESC,thisYr DESC LIMIT 5";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

		  {

			  echo "  <table cellpadding=2 cellspacing=0 border=0 width='420px'>\n";

		    	  echo "   <tr class='title'><td colspan=5>".stat_text($statLbl)." Projections</td></tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l'>Record Holder</td><td class='hsc2' colspan=3>Years</td><td class='hsc2'>Value</td></tr>\n";

		    	  echo "   <tr class='s2'>";

			  echo "<td class='s2_l'><a href='./player.php?player_id=".$bleaders[$statLbl]['car']['pid']."'>".$bleaders[$statLbl]['car']['pname']."</a></td>";

			  echo "<td colspan=3>".$bleaders[$statLbl]['car']['years']."</td>";

		    	  echo "<td>".$bleaders[$statLbl]['car']['value']."</td>";

			  echo "</tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2'>Tm</td><td class='hsc2'>Age</td><td class='hsc2'>Current</td><td class='hsc2'>Projected</td></tr>\n";



			  $cnt=0;

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];



				  $cls='s'.($cnt%2+1);

		      		  echo "   <tr class='$cls'>";

				  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";

		      		  $tid=$row['team_id'];

				  echo "<td><a href='./team_summary.php?team_id=$tid&year=$lgyear'>".$teams[$tid]['abbr']."</a></td>";

		      		  echo "<td>".$row['age']."</td>";

		      		  echo "<td title='".$row['thisYr']." this year'>".$row['carTot']."</td>";

				  echo "<td>".round($row['projTot'],0)."</td>";

		      		  echo "</tr>\n";

				  $cnt++;

			  }

			  while ($cnt<5)

			  {

				  $cls='s'.($cnt%2+1);

		      		  echo "   <tr class='$cls'><td colspan=5>&nbsp;</td></tr>\n";

				  $cnt++;

			  }

			  if ($sub_league_id=="ALL") {$dispSL="ALL";} else {$dispSL=$sub_league_id;}

		    	  if ($team_id=="ALL") {$dispTeam="ALL";} else {$dispTeam=$team_id;}

			  echo "   <tr class='headline'><td colspan=5 class='hsc2'>Leaderboard: <a href='./leaderboards.php?view=players&scope=career&sub_league_id=$dispSL&listing=top100&team_id=$dispTeam&split=regular&stat=$statLbl&who=ALL&pos=ALL'>Show</a></td></tr>\n";

			  echo "  </table>\n";

		  }

	  }

	  echo " </div>\n";



	  ## Close Batters

	  echo "  </td></tr>\n";

	  echo " </table>\n";

	  echo "</div>\n";



	  ##### Pitching #####

	  echo "<div class='textbox'>\n";

       	  echo " <table cellpadding=2 cellspacing=0 border=0 width='935px'>\n";

	  $title="Pitchers";

       	  echo "  <tr class='title2'><td>$title</td></tr>\n";

	  echo "  <tr><td>\n";





	  $statArray=Array('W'=>'w','L'=>'l','SV'=>'s','IP'=>'ip','K'=>'k','CG'=>'cg','SHO'=>'sho','G'=>'g','HLD'=>'hld');



	  ## Seasonal

	  echo " <div id='first' class='boxscores' style='margin-left:10px;width:440px;'>\n";

       	  echo "  <table cellpadding=2 cellspacing=0 border=0 style='border:0;margin:0;width:100%;'>\n";

	  echo "   <tr class='title'><td>Seasonal Projections</td></tr>\n";

       	  echo "  </table>\n";

	  foreach ($statArray as $key => $statLbl)

	  {

		  ## Get record holder

		  $query="SELECT p.player_id,first_name,last_name,pcs.team_id,year,".stat_query($statLbl)." as stat FROM players as p,players_career_pitching_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1";

	    	  if ($sub_league_id!="ALL") {$query.=" AND pcs.team_id IN (".$subleagues[$sub_league_id]['teams'].")";}

		  if ($team_id!="ALL") {$query.=" AND pcs.team_id=$team_id";}

	    	  $query.=" GROUP BY player_id,year ORDER BY stat DESC LIMIT 1;";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

	    	  $row=mysqli_fetch_array($result);

		  $pid=$row['player_id'];

	    	  $pname=$row['first_name']." ".$row['last_name'];

		  $yr=$row['year'];

	    	  $statVal=$row['stat'];

		  $bleaders[$statLbl]['sea']['pid']=$pid;

	    	  $bleaders[$statLbl]['sea']['tid']=$row['team_id'];

		  $bleaders[$statLbl]['sea']['pname']=$pname;

	    	  $bleaders[$statLbl]['sea']['value']=$statVal;

		  $bleaders[$statLbl]['sea']['yr']=$yr;



		  ## Get top 5 players

		  $statQuery="SELECT player_id,team_id,".stat_query($statLbl)." as $statLbl FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND year=$lgyear";

		  if ($sub_league_id!="ALL") {$statQuery.=" AND team_id IN (".$subleagues[$sub_league_id]['teams'].")";}

	       	  if ($team_id!="ALL") {$statQuery.=" AND team_id=$team_id";}

		  $statQuery.=" GROUP BY player_id ORDER BY $statLbl DESC LIMIT 100";



		  $statQuery="SELECT p.player_id,first_name,last_name,($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'$lgMo-$lgDay')) as age,p.team_id,$statLbl FROM players as p,($statQuery) as y WHERE p.player_id=y.player_id ";

		  if ($sub_league_id!="ALL") {$statQuery.=" AND p.team_id IN (".$subleagues[$sub_league_id]['teams'].")";}

	       	  if ($team_id!="ALL") {$statQuery.=" AND p.team_id=$team_id";}



		  $query="SELECT player_id,first_name,last_name,age,pcs.team_id,$statLbl as thisYr,$statLbl*gpRate as projTot FROM ($statQuery) as pcs,($gpQuery) as t WHERE pcs.team_id=t.team_id ORDER BY projTot DESC LIMIT 5";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

		  {

			  echo "  <table cellpadding=2 cellspacing=0 border=0 width='420px'>\n";

		    	  echo "   <tr class='title'><td colspan=4>".stat_text($statLbl)." Projections</td></tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l'>Record Holder</td><td class='hsc2'>Tm</td><td class='hsc2'>Year</td><td class='hsc2'>Value</td></tr>\n";

		    	  echo "   <tr class='s2'>";

			  echo "<td class='s2_l'><a href='./player.php?player_id=".$bleaders[$statLbl]['sea']['pid']."'>".$bleaders[$statLbl]['sea']['pname']."</a></td>";

		    	  $tid=$bleaders[$statLbl]['sea']['tid'];

			  $yr=$bleaders[$statLbl]['sea']['yr'];

		    	  echo "<td><a href='./team_summary.php?team_id=$tid&year=$yr'>".$teams[$tid]['abbr']."</a></td>";

			  echo "<td>".$yr."</td>";

		    	  echo "<td>".stat_format($statLbl,$bleaders[$statLbl]['sea']['value'])."</td>";

			  echo "</tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2'>Tm</td><td class='hsc2'>Current</td><td class='hsc2'>Projected</td></tr>\n";



			  $cnt=0;

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];



				  $cls='s'.($cnt%2+1);

		      		  echo "   <tr class='$cls'>";

				  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";

		      		  $tid=$row['team_id'];

				  echo "<td><a href='./team_summary.php?team_id=$tid&year=$lgyear'>".$teams[$tid]['abbr']."</a></td>";

		      		  echo "<td>".stat_format($statLbl,$row['thisYr'])."</td>";

				  echo "<td>".stat_format($statLbl,round($row['projTot'],0))."</td>";

		      		  echo "</tr>\n";

				  $cnt++;

			  }

			  if ($sub_league_id=="ALL") {$dispSL="ALL";} else {$dispSL=$sub_league_id;}

		    	  if ($team_id=="ALL") {$dispTeam="ALL";} else {$dispTeam=$team_id;}

			  echo "   <tr class='headline'><td colspan=4 class='hsc2'>Leaderboard: <a href='./leaderboards.php?view=players&scope=season&sub_league_id=$dispSL&listing=top100&team_id=$dispTeam&split=regular&stat=$statLbl&who=ALL&pos=ALL'>Show</a></td></tr>\n";

			  echo "  </table>\n";

		  }

	  }

	  echo " </div>\n";



	  ## Career

	  echo " <div class='boxscores' style='margin-right:10px;width:440px;float:right;'>\n";

       	  echo "  <table cellpadding=2 cellspacing=0 border=0 style='border:0;margin:0;width:100%;'>\n";

	  echo "   <tr class='title'><td>Career Projections (through remainder of this season)</td></tr>\n";

       	  echo "  </table>\n";

	  foreach ($statArray as $key => $statLbl)

	  {

		  ## Get record holder

		  $query="SELECT p.player_id,first_name,last_name,MIN(year) as minyr,MAX(year) as maxyr,".stat_query($statLbl)." as stat FROM players as p,players_career_pitching_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1";

	    	  if ($sub_league_id!="ALL") {$query.=" AND pcs.team_id IN (".$subleagues[$sub_league_id]['teams'].")";}

		  if ($team_id!="ALL") {$query.=" AND pcs.team_id=$team_id";}

		    	  $query.=" GROUP BY player_id ORDER BY stat DESC LIMIT 1;";

		  $result=mysqli_query($db,$query);

	    	  $row=mysqli_fetch_array($result);

		  $pid=$row['player_id'];

	    	  $pname=$row['first_name']." ".$row['last_name'];

		  $statVal=$row['stat'];

	    	  $bleaders[$statLbl]['car']['pid']=$pid;

		  $bleaders[$statLbl]['car']['pname']=$pname;

	    	  $bleaders[$statLbl]['car']['years']=$row['minyr']."-".$row['maxyr'];

		  $bleaders[$statLbl]['car']['value']=$statVal;



		  ## Get top 5 players

		  $statQuery="SELECT first_name,last_name,organization_id as team_id,($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'$lgMo-$lgDay')) as age,y.* FROM players as p,(";

		  $statQuery.="SELECT t2.player_id,IF(t1.$statLbl IS NULL,t2.$statLbl,t2.$statLbl-t1.$statLbl) as thisYr,IF(t1.$statLbl IS NULL,0,t1.$statLbl) as priorStat,t2.$statLbl as carTot FROM ";

		  $statQuery.="(SELECT player_id,".stat_query($statLbl)." as $statLbl FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1";

		  if ($sub_league_id!="ALL") {$statQuery.=" AND team_id IN (".$subleagues[$sub_league_id]['teams'].")";}

	       	  if ($team_id!="ALL") {$statQuery.=" AND team_id=$team_id";}

		  $statQuery.=" GROUP BY player_id HAVING MAX(year)=$lgyear AND ".stat_query($statLbl).">0) as t2";

		  $statQuery.=" LEFT JOIN ";

		  $statQuery.="(SELECT player_id,".stat_query($statLbl)." as $statLbl FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND year<$lgyear";

		  if ($sub_league_id!="ALL") {$statQuery.=" AND team_id IN (".$subleagues[$sub_league_id]['teams'].")";}

	       	  if ($team_id!="ALL") {$statQuery.=" AND team_id=$team_id";}

		  $statQuery.=" GROUP BY player_id) as t1";

		  $statQuery.=" ON t1.player_id=t2.player_id WHERE t2.$statLbl>0";

		  $statQuery.=" ORDER BY carTot DESC LIMIT 200) as y";

		  $statQuery.=" WHERE p.player_id=y.player_id";

		  if ($sub_league_id!="ALL") {$statQuery.=" AND p.organization_id IN (".$subleagues[$sub_league_id]['teams'].")";}

	       	  if ($team_id!="ALL") {$statQuery.=" AND p.organization_id=$team_id";}

			  

		  $query="SELECT x.*,priorStat+thisYr*gpRate as projTot FROM ($gpQuery) as t,($statQuery) as x WHERE t.team_id=x.team_id ORDER BY projTot DESC,thisYr DESC LIMIT 5";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

		  {

			  echo "  <table cellpadding=2 cellspacing=0 border=0 width='420px'>\n";

		    	  echo "   <tr class='title'><td colspan=5>".stat_text($statLbl)." Projections</td></tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l'>Record Holder</td><td class='hsc2' colspan=3>Years</td><td class='hsc2'>Value</td></tr>\n";

		    	  echo "   <tr class='s2'>";

			  echo "<td class='s2_l'><a href='./player.php?player_id=".$bleaders[$statLbl]['car']['pid']."'>".$bleaders[$statLbl]['car']['pname']."</a></td>";

			  echo "<td colspan=3>".$bleaders[$statLbl]['car']['years']."</td>";

		    	  echo "<td>".stat_format($statLbl,$bleaders[$statLbl]['car']['value'])."</td>";

			  echo "</tr>\n";

			  echo "   <tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2'>Tm</td><td class='hsc2'>Age</td><td class='hsc2'>Current</td><td class='hsc2'>Projected</td></tr>\n";



			  $cnt=0;

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];



				  $cls='s'.($cnt%2+1);

		      		  echo "   <tr class='$cls'>";

				  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";

		      		  $tid=$row['team_id'];

				  echo "<td><a href='./team_summary.php?team_id=$tid&year=$lgyear'>".$teams[$tid]['abbr']."</a></td>";

		      		  echo "<td>".$row['age']."</td>";

		      		  echo "<td title='".stat_format($statLbl,$row['thisYr'])." this year'>".stat_format($statLbl,$row['carTot'])."</td>";

				  echo "<td>".stat_format($statLbl,round($row['projTot'],0))."</td>";

		      		  echo "</tr>\n";

				  $cnt++;

			  }

			  while ($cnt<5)

			  {

				  $cls='s'.($cnt%2+1);

		      		  echo "   <tr class='$cls'><td colspan=5>&nbsp;</td></tr>\n";

				  $cnt++;

			  }

			  if ($sub_league_id=="ALL") {$dispSL="ALL";} else {$dispSL=$sub_league_id;}

		    	  if ($team_id=="ALL") {$dispTeam="ALL";} else {$dispTeam=$team_id;}

			  echo "   <tr class='headline'><td colspan=5 class='hsc2'>Leaderboard: <a href='./leaderboards.php?view=players&scope=career&sub_league_id=$dispSL&listing=top100&team_id=$dispTeam&split=regular&stat=$statLbl&who=ALL&pos=ALL'>Show</a></td></tr>\n";

			  echo "  </table>\n";

		  }

	  }

	  echo " </div>\n";



	  ## Close Pitchers

	  echo "  </td></tr>\n";

	  echo " </table>\n";

	  echo "</div>\n";



	  break;	

  }



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);





?>

