<?php
  include("html_functions.php");

  ################## PAGE INITIALIZATION #########################
  $lgid=$_SESSION['lgid'];
  $lgpath=$_SESSION['lgpath'];
  $lgyear=$_SESSION['lgyear'];

  include($_SESSION['adminpath']."/dbopen.php");

  ## Get league info
  $query="SELECT league_id,name,abbr,league_level FROM leagues";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  while ($row=mysqli_fetch_array($result))
	  {
		  $league_id=$row['league_id'];
		  $leagues[$league_id]['name']=$row['name'];
		  $leagues[$league_id]['abbr']=$row['abbr'];
		  $leagues[$league_id]['league_level']=$row['league_level'];
	  }
  }

  ## Get team info
  $query="SELECT * FROM (SELECT t.team_id,t.year,name,nickname,abbr,t.league_id,level_id FROM team_history as t,team_history_pitching_stats as ths WHERE t.team_id=ths.team_id AND t.year=ths.year UNION SELECT team_id,'$lgyear' as year,name,nickname,abbr,league_id,level as leve_id FROM teams WHERE allstar_team=0) as t GROUP BY team_id,year ORDER BY team_id,year";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  $prevTid=-1;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $tid=$row['team_id'];
		  $yr=$row['year'];
		  $teams[$tid][$yr]['level_id']=$row['level_id'];
		  $teams[$tid][$yr]['name']=$row['name']." ".$row['nickname'];
		  $teams[$tid][$yr]['abbr']=$row['abbr'];
		  $teams[$tid][$yr]['lgid']=$row['league_id'];
		  if ($prevTid!=$tid) {$teams[$tid]['ingname']=$row['name']." ".$row['nickname'];}
		  $prevTid=$tid;
	  }
  }

  ## Get manager info
  $query="SELECT human_manager_id,first_name,last_name,retired,team_id,organization_id FROM human_managers WHERE 1;";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  while ($row=mysqli_fetch_array($result))
	  {
		  $hmid=$row['human_manager_id'];
		  $managers[$hmid]['name']=$row['first_name']." ".$row['last_name'];
		  $managers[$hmid]['sortname']=$row['last_name'].", ".$row['first_name'];
	    	  $managers[$hmid]['retired']=$row['retired'];
		  $managers[$hmid]['tid']=$row['team_id'];
	    	  $managers[$hmid]['orgID']=$row['organization_id'];
	}
  }

  mysqli_close($db);

  # Title Bar
  $title='Manager Records';
  page_head($title,$_SESSION['lgpath']);
  echo " <div id='topbar'>\n";
  main_titlebar($lgid,$_SESSION['lgpath'],$title);
  nav_toolbar("managers","Managers");
  echo " </div>   <!-- END topbar DIV -->\n";
  echo " <div id='contentpane'>\n";

  if (!isset($managers))
  {
	  echo "No human managers";
	  echo " </div>   <!-- END contentpane DIV -->\n";
	  page_foot($_SESSION['lgpath']);
	  exit;
  }

  ################## START OF PAGE CONTENT #########################
  include($_SESSION['adminpath']."/dbopen.php");

  ## Get Manager Data
  $query="SELECT human_manager_id,COUNT(year) as yrs,MAX(year) as maxYr,MIN(year) as minYr,SUM(g) as g,SUM(w) as w,SUM(l) as l,SUM(w)/SUM(g) as winpct,MIN(pos) as bestFin,MAX(pos) as worstFin,AVG(pos) as avgFin,SUM(made_playoffs) as made_playoffs,SUM(won_playoffs) as won_playoffs FROM (SELECT hmr.human_manager_id,hmr.year,hmr.league_id,hmr.sub_league_id,hmr.division_id,hmr.team_id,g,w,l,pos,gb,made_playoffs,won_playoffs FROM human_manager_history_record as hmr,human_manager_history as hmh WHERE hmh.human_manager_id=hmr.human_manager_id AND hmh.year=hmr.year) as t GROUP BY human_manager_id ORDER BY w DESC";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  echo "<div class='textbox'>   <!-- open manager records -->\n";
	  echo " <table cellpadding=0 cellspacing=0 border=0>   <!-- open manager records -->\n";
	  echo "  <tr class='title'><td style='padding:2px;'>Manager Records</td></tr>\n";
	  echo "  <tr><td>\n";
	  echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' style='width:935px;'>\n";
	  echo "    <thead><tr class='headline'><td class='hsc2_l'>Manager</td>";
	  echo "<td class='hsc2' title='Years managed'>Yrs</td>";
	  echo "<td class='hsc2' title='First year'>From</td>";
	  echo "<td class='hsc2' title='Last year'>To</td>";
	  echo "<td class='hsc2' title='".stat_text('g')."'>".stat_text('g',2)."</td>";
	  echo "<td class='hsc2' title='".stat_text('w')."'>".stat_text('w',2)."</td>";
	  echo "<td class='hsc2' title='".stat_text('l')."'>".stat_text('l',2)."</td>";
	  echo "<td class='hsc2' title='Win percentage'>Win%</td>";
	  echo "<td class='hsc2' title='Games over .500'>Gm>.500</td>";
	  echo "<td class='hsc2' title='Best Finish'>Best Fin</td>";
	  echo "<td class='hsc2' title='Worst Finish'>Worst Fin</td>";
	  echo "<td class='hsc2' title='Average Finish'>Avg Fin</td>";
	  echo "<td class='hsc2' title='Made Playoffs'>Postseason</td>";
	  echo "<td class='hsc2' title='Championships Won'>Titles</td>";
	  echo "</tr></thead>\n";

	  $rowCnt=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $hmid=$row['human_manager_id'];
		  $g=$row['g'];
		  $w=$row['w'];
		  $l=$row['l'];

		  $winsOver500=$w-$l;
		  $winpct=($g==0?0:$w/$g);

		  $cls='s';
		  $cls.=($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l' sorttable_customkey='".$managers[$hmid]['sortname']."'><a href='./manager.php?human_manager_id=$hmid'>".$managers[$hmid]['name']."</a></td>";
		  echo "<td>".$row['yrs']."</td>";
		  echo "<td>".$row['minYr']."</td>";
		  echo "<td>".$row['maxYr']."</td>";
		  echo "<td>$g</td>";
		  echo "<td>$w</td>";
		  echo "<td>$l</td>";
		  echo "<td>".stat_format('winpct',$winpct)."</td>";
		  echo "<td>".stat_format('gmovr500',$winsOver500)."</td>";
		  echo "<td sorttable_customkey=".$row['bestFin'].">".ordinal_suffix($row['bestFin'])."</td>";
		  echo "<td sorttable_customkey=".$row['worstFin'].">".ordinal_suffix($row['worstFin'])."</td>";
		  echo "<td>".stat_format('ip',$row['avgFin'])."</td>";
		  echo "<td>".$row['made_playoffs']."</td>";
		  echo "<td>".$row['won_playoffs']."</td>";
		  echo "</tr>\n";
		  $rowCnt++;
	  }

  	  echo "   </table>\n";
	  echo "  </td></tr>\n";
	  echo " </table>   <!-- close manager records -->\n";
	  echo "</div>   <!-- close manager records -->\n";

  }

  mysqli_close($db);

  ################## END OF PAGE #########################
  echo " </div>   <!-- END contentpane DIV -->\n";
  page_foot($_SESSION['lgpath']);


?>
