<?php
  include("html_functions.php");

  ################## PAGE INITIALIZATION #########################
  $lgid=$_SESSION['lgid'];
  $hmid=$_GET['human_manager_id'];
  if (!is_numeric($hmid)) {$hmid="";}

  $lgpath=$_SESSION['lgpath'];
  $lgyear=$_SESSION['lgyear'];

  if ($hmid=="") 
  {
	  header('Location: ./managers.php');
  }
  else
  {
	  include($_SESSION['adminpath']."/dbopen.php");

	  ## Get league info
	  $query="SELECT league_id,name,abbr,league_level FROM leagues";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  if (mysqli_num_rows($result))
	  {
		  while ($row=mysqli_fetch_array($result))
		  {
			  $league_id=$row['league_id'];
			  $leagues[$league_id]['name']=$row['name'];
			  $leagues[$league_id]['abbr']=$row['abbr'];
			  $leagues[$league_id]['league_level']=$row['league_level'];
		  }
	  }

	  ## Get team info
	  $query="SELECT * FROM (SELECT t.team_id,t.year,name,nickname,abbr,t.league_id,level_id FROM team_history as t,team_history_pitching_stats as ths WHERE t.team_id=ths.team_id AND t.year=ths.year UNION SELECT team_id,'$lgyear' as year,name,nickname,abbr,league_id,level as leve_id FROM teams WHERE allstar_team=0) as t GROUP BY team_id,year ORDER BY team_id,year";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  if (mysqli_num_rows($result))
	  {
		  $prevTid=-1;
		  while ($row=mysqli_fetch_array($result))
		  {
			  $tid=$row['team_id'];
			  $yr=$row['year'];
			  $teams[$tid][$yr]['level_id']=$row['level_id'];
			  $teams[$tid][$yr]['name']=$row['name']." ".$row['nickname'];
			  $teams[$tid][$yr]['abbr']=$row['abbr'];
			  $teams[$tid][$yr]['lgid']=$row['league_id'];
			  if ($prevTid!=$tid) {$teams[$tid]['ingname']=$row['name']." ".$row['nickname'];}
			  $prevTid=$tid;
		  }
	  }

	  ## Get manager info
	  $query="SELECT first_name,last_name,nick_name,date_of_birth,($lgyear-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as ageNow,weight,height,retired,team_id,organization_id FROM human_managers WHERE human_manager_id=$hmid;";
	  if ($_GET['showq']==1) {echo "$query<br/>\n";}
	  $result=mysqli_query($db,$query);
	  if (mysqli_num_rows($result)==0) {$title='Manager Page';}
      	  else
	  {
	    	  $row=mysqli_fetch_array($result);
		  $name=$row['first_name']." ".$row['last_name'];
		  $bday=new Date($row['date_of_birth']);
		  $ageNow=$row['ageNow'];
	    	  $title="Manager Report for #$uni $name";
		  $nickname=$row['nick_name'];
	    	  $height=$row['height'];
		  $weight=$row['weight'];
	    	  $retired=$row['retired'];
		  $pTmID=$row['team_id'];
	    	  $pOrgID=$row['organization_id'];
		  $dateOfBirth=new Date($row['date_of_birth']);
		
		  $pstatus='Free Agent';
  		  if ($pOrgID!=0)
		  {
			  $pstatus="Currently with <a href='$lgpath/teams/team_$pTmID.html'>".$teams[$pTmID][$lgyear]['name']."</a>";
			  $tmLgID=$teams[$pTmID][$lgyear]['lgid'];
			  $pstatus.=" (<a href='$lgpath/leagues/league_".$tmLgID."_home.html'>".$leagues[$tmLgID]['abbr']."</a>";
			  if (($teams[$pTmID][$lgyear]['level_id']!=1)&&($teams[$pTmID][$lgyear]['level_id']!=8))
  			  {
				  $pstatus.=" <a href='$lgpath/teams/team_$pOrgID.html'>".$teams[$pOrgID][$lgyear]['abbr']."</a> ".get_level($teams[$pTmID][$lgyear]['level_id']);
			  }
			  $pstatus.=")";
		  }
	}
	
	  mysqli_close($db);
  }

  # Title Bar
  page_head($title,$_SESSION['lgpath']);
  echo " <div id='topbar'>\n";
  main_titlebar($lgid,$_SESSION['lgpath'],$title);
  nav_toolbar("managers","Managers");
  echo " </div>   <!-- END topbar DIV -->\n";
  echo " <div id='contentpane'>\n";

  if ($hmid=="")
  {
	  echo "Please select a manager";
	  echo " </div>   <!-- END contentpane DIV -->\n";
	  page_foot($_SESSION['lgpath']);
	  exit;
  }

  ################## START OF PAGE CONTENT #########################
  include($_SESSION['adminpath']."/dbopen.php");

  ##### Manager Demographics
  echo "<div class='textbox'>   <!-- open manager demographics -->\n";
  echo " <table cellpadding=2 cellspacing=0 border=0 width='935px'>   <!-- open manager demographics -->\n";
  echo "  <tr class='title'><td colspan=5>Manager Demographics</td></tr>\n";
  echo "  <tr class='s2'><td rowspan=6 width='94px'>";
  $htmlpath=$_SESSION['htmlroot'].$_SESSION['htmlpath'];
  $imgpath=$lgpath."/images/person_pictures/manager_".$hmid.".png";            ## Check for photo by manager ID
  $ch = curl_init($imgpath);
  curl_setopt($ch, CURLOPT_NOBODY, true);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_FILETIME, true); 
  curl_exec($ch);
  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
  if ($retcode==200) {echo "<img src='$imgpath'>";}
  else
  {
	  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".png";   ## Check for capitalized name PNG
	  $ch = curl_init($imgpath);
	  curl_setopt($ch, CURLOPT_NOBODY, true);
	  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	  curl_setopt($ch, CURLOPT_FILETIME, true); 
	  curl_exec($ch);
	  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
	  if ($retcode==200) {echo "<img src='$imgpath'>";}
	  else
	  {
		  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".png";   ## Check for lowercase name PNG
		  $ch = curl_init($imgpath);
		  curl_setopt($ch, CURLOPT_NOBODY, true);
		  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		  curl_setopt($ch, CURLOPT_FILETIME, true); 
		  curl_exec($ch);
		  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
		  if ($retcode==200) {echo "<img src='$imgpath'>";}
		  else
		  {
			  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".jpg";   ## Check for capitalized name JPG
			  $ch = curl_init($imgpath);
			  curl_setopt($ch, CURLOPT_NOBODY, true);
			  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			  curl_setopt($ch, CURLOPT_FILETIME, true); 
			  curl_exec($ch);
			  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
			  if ($retcode==200) {echo "<img src='$imgpath'>";}
			  else
			  {
				  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".jpg";   ## Check for lowercase name JPG
				  $ch = curl_init($imgpath);
				  curl_setopt($ch, CURLOPT_NOBODY, true);
				  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				  curl_setopt($ch, CURLOPT_FILETIME, true); 
				  curl_exec($ch);
				  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
				  if ($retcode==200) {echo "<img src='$imgpath'>";}
				  else
				  {
					  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".bmp";   ## Check for capitalized name BMP
					  $ch = curl_init($imgpath);
					  curl_setopt($ch, CURLOPT_NOBODY, true);
					  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					  curl_setopt($ch, CURLOPT_FILETIME, true); 
					  curl_exec($ch);
					  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
					  if ($retcode==200) {echo "<img src='$imgpath'>";}
					  else
					  {
						  $imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".bmp";   ## Check for lowercase name bmp
						  $ch = curl_init($imgpath);
						  curl_setopt($ch, CURLOPT_NOBODY, true);
						  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
						  curl_setopt($ch, CURLOPT_FILETIME, true); 
						  curl_exec($ch);
						  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.
						  if ($retcode==200) {echo "<img src='$imgpath'>";}
						  else
						  {
							  echo "<img src='$lgpath/images/person_pictures/default_player_photo.png'>";   ## Show default
						  }
					  }
				  }
			  }
		  }
	  }
  }
  echo "</td><td><b>Name:</b></td><td class='s2_l' width='500px'><a href='$lgpath/coaches/human_manager_$hmid.html'>$name</a></td><td><b>Height:</b></td><td class='s2_l'>".cm_to_ft_in($height)."</td></tr>\n";
  echo "  <tr class='s1'><td><b>Nickname:</b></td><td class='s1_l'>$nickname</td><td><b>Weight:</b></td><td class='s1_l'>$weight lbs</td></tr>\n";
  echo "  <tr class='s2'><td><b>Date of Birth:</b></td><td class='s2_l'>".$dateOfBirth->format("F j, Y")."</td><td>&nbsp;</td><td>&nbsp;</td></tr>\n";
  echo "  <tr class='s1'><td><b>Current Status:</b></td><td class='s1_l' colspan=3>".$pstatus."</td></tr>\n";
  echo "  <tr class='s2'><td colspan=4>&nbsp;</td></tr>\n";
  echo "  <tr class='s2'><td colspan=4>&nbsp;</td></tr>\n";
  echo " </table>   <!-- close player demographics -->\n";
  echo "</div>   <!-- close player demographics -->\n";

  ## Get Managing History
  $statArray=Array('g','w','l','pos','gb','winpct');
  $query="SELECT hmr.year,hmr.league_id,hmr.sub_league_id,hmr.division_id,hmr.team_id,g,w,l,pos,gb,w/g as winpct,made_playoffs,won_playoffs FROM human_manager_history_record as hmr,human_manager_history as hmh WHERE hmh.human_manager_id=hmr.human_manager_id AND hmr.human_manager_id=$hmid AND hmh.year=hmr.year ORDER BY year";
  if ($_GET['showq']==1) {echo "$query<br/>\n";}
  $result=mysqli_query($db,$query);
  if (mysqli_num_rows($result))
  {
	  echo "<div class='textbox'>   <!-- open manager stats -->\n";
	  echo " <table cellpadding=0 cellspacing=0 border=0>   <!-- open manager stats -->\n";
	  echo "  <tr class='title'><td style='padding:2px;'>Manager History</td></tr>\n";
	  echo "  <tr><td>\n";
	  echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' style='width:935px;'>\n";
	  echo "    <thead><tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2_l'>League</td><td class='hsc2_l'>Team</td>";
	  foreach ($statArray as $key => $statLbl) {echo "<td class='hsc2' title='".stat_text($statLbl)."'>".stat_text($statLbl,2)."</td>";}
	  echo "<td class='hsc2_l'>Postseason</td>";
	  echo "</tr></thead>\n";

	  $rowCnt=0;
	  $prevYr=0;
	  while ($row=mysqli_fetch_array($result))
	  {
		  $yr=$row['year'];
		  $league_id=$row['league_id'];
		  $tid=$row['team_id'];
		  $slid=$row['sub_league_id'];
		  $g=$row['g'];
		  $w=$row['w'];
		  $l=$row['l'];
		  $pos=$row['pos'];
		  $gb=$row['gb'];
		  $made_playoffs=$row['made_playoffs'];
		  $won_playoffs=$row['won_playoffs'];

          if ($g==0) {$winpct=0;} else {$winpct=$w/$g;}

		  $cls='s';
		  $cls.=($rowCnt%2+1);
		  echo "    <tr class='$cls'>";
		  echo "<td class='".$cls."_l'>$yr</td>";
		  echo "<td class='".$cls."_l' sorttable_customkey='".$leagues[$league_id]['name']."'><a href='./league_summary.php?sub_league_id=$slid&year=$yr&league_id=$league_id'>".$leagues[$league_id]['name']."</a></td>";
		  echo "<td class='".$cls."_l' sorttable_customkey='".$teams[$tid][$yr]['name']."'><a href='./team_summary.php?team_id=$tid&year=$yr&league_id=$league_id'>".$teams[$tid][$yr]['name']."</a></td>";
		  foreach ($statArray as $key => $statLbl) {echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";}
		  echo "<td class='".$cls."_l' sorttable_customkey=";
		  if ($won_playoffs==1) {echo "2>Won Championship";}
		  elseif ($made_playoffs==1) {echo "1>Made Playoffs";}
		  else {echo "0>-";}
		  echo "</td>";
		  echo "</tr>\n";

		  $rowCnt++;
		  $prevYr=$yr;
	  }
	  echo "   </table>\n";
	  echo "  </td></tr>\n";
	  echo " </table>   <!-- close manager stats -->\n";
	  echo "</div>   <!-- close manager stats -->\n";

  }

  mysqli_close($db);

  ################## END OF PAGE #########################
  echo " </div>   <!-- END contentpane DIV -->\n";
  page_foot($_SESSION['lgpath']);


?>
