<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgyear=$_SESSION['lgyear'];

  $lgpath=$_SESSION['lgpath'];



  include($_SESSION['adminpath']."/dbopen.php");

  # Get Teams

  $query="SELECT team_id,name,nickname,abbr,logo_file_name FROM teams WHERE league_id=$lgid AND allstar_team=0";

  $query.=" UNION ";

  $query.="SELECT * FROM (SELECT team_id,name,nickname,abbr,NULL as logo_file_name FROM team_history WHERE league_id=$lgid ORDER BY year DESC) as t WHERE team_id NOT IN (SELECT team_id FROM teams WHERE league_id=$lgid) GROUP BY team_id";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  while ($row=mysqli_fetch_array($result))

  {

	  $tid=$row['team_id'];

	  $teams[$tid]['name']=$row['name']." ".$row['nickname'];

	  $teams[$tid]['abbr']=$row['abbr'];

	  $logo=$row['logo_file_name'];

	  if ($logo!="") {$teams[$tid]['logo']=$logo;}

	  else

	  {

		  $logo=$teams[$tid]['name'].".png";

		  $logo=str_replace(" ","_",$teams[$tid]['logo']);

		  $hideChars=Array(".","'","&");

		  $logo=str_replace($hideChars,"_",$teams[$tid]['logo']);



		  $teams[$tid]['logo']=$logo;

	  }

	  $teams[$tid]['logo']=urlencode($teams[$tid]['logo']);

  }

  mysqli_close($db);



  $title='League Index';

  page_head($title,$_SESSION['lgpath'],"","","./jquery/excanvas.js|./jquery/jquery.min.js|./jquery/jquery.jqplot.min.js|./jquery/plugins/jqplot.highlighter.min.js|./jquery/plugins/jqplot.cursor.min.js|./jquery/plugins/jqplot.pieRenderer.min.js");

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  nav_toolbar("history","History");

  nav_toolbar("leagues","",$lgid,$slid,"",$yr);

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";









  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");



  ## Display Season Listing

  $query="SELECT t.team_id,$lgyear as year,sub_league_id,name,nickname,if(magic_number=0,1,0) as made_playoffs,0 as won_playoffs,w,l,pos FROM teams as t,team_record as tr WHERE t.team_id=tr.team_id AND t.league_id=$lgid AND allstar_team=0 AND (pos=1 OR magic_number=0)";

  $query.=" UNION ";

  $query.="SELECT t1.team_id,t1.year,t1.sub_league_id,name,nickname,made_playoffs,won_playoffs,w,l,pos FROM (SELECT team_id,year,sub_league_id,name,nickname,made_playoffs,won_playoffs FROM team_history WHERE league_id=$lgid AND (made_playoffs=1 OR won_playoffs=1)) as t1 JOIN (SELECT team_id,year,sub_league_id,w,l,pos FROM team_history_record WHERE league_id=$lgid) as t2 ON t1.team_id=t2.team_id AND t1.year=t2.year ORDER BY year DESC,won_playoffs DESC,w DESC";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

	  $lgQuery="(SELECT $lgyear as year,sl.sub_league_id,sl.abbr FROM sub_leagues as sl,teams as t WHERE sl.sub_league_id=t.sub_league_id AND sl.league_id=t.league_id AND t.league_id=$lgid GROUP BY year,sub_league_id) UNION (SELECT year,sl.sub_league_id,sl.abbr FROM sub_leagues as sl,team_history as t WHERE sl.sub_league_id=t.sub_league_id AND sl.league_id=t.league_id AND t.league_id=$lgid GROUP BY year,sub_league_id) ORDER BY year DESC,sub_league_id";

	  if ($_GET['showq']==1) {echo "$lgQuery<br/>\n";}

	  $lgResult=mysqli_query($db,$lgQuery);

	  while ($row=mysqli_fetch_array($lgResult))

	  {

		  $yr=$row['year'];

		  $slid=$row['sub_league_id'];

		  if (!isset($leagues[$yr])) {$leagues[$yr]="<a href='./league_summary.php?sub_league_id=$slid&year=$yr'>".$row['abbr']."</a>";}

		  else {$leagues[$yr]=$leagues[$yr]." | <a href='./league_summary.php?sub_league_id=$slid&year=$yr'>".$row['abbr']."</a>";}

	  }



	  echo "<div class='textbox' style='width:100%;margin-bottom:20px;'>   <!-- open league listing -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open league listing -->\n";

	  echo "  <tr class='title2'><td colspan=5>Historical Results</td></tr>\n";

	  echo "  <tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2_l'>League</td><td class='hsc2_l' colspan=2>Champion</td><td class='hsc2_l'>Playoff Teams</td></tr>\n";



	  $rowCnt=-1;

	  $prevYr=-1;

	  while ($row=mysqli_fetch_array($result))

	  {

		  $tid=$row['team_id'];

		  $yr=$row['year'];



		  if ($yr!=$prevYr)

		  {

			  $noChamp=1;

			  if ($prevYr>0)

			  {

				  if ($noPOtms==1)

				  {

					  echo "</td><td>";

					  echo "&nbsp;";

				  }

				  echo "</td></tr>\n";

				  $noPOtms=1;

			  }



			  $rowCnt++;

			  $cls='s'.($rowCnt%2+1)."_l";

			  echo "  <tr class='$cls' style='vertical-align:top;'>";

			  echo "<td>$yr</td>";

			  echo "<td>".$leagues[$yr]."</td>";

			  if ($row['won_playoffs']==1)

			  {

				  echo "<td style='width:40px;'><img src='$lgpath/images/team_logos/".str_replace(".png","_40.png",$teams[$tid]['logo'])."' width=40 height=40></td>";

				  echo "<td><a href='./team_summary.php?team_id=$tid&year=$yr' style='font-weight:bold;'>".$row['name']." ".$row['nickname']."</a> (".$row['w']."-".$row['l'].", ".ordinal_suffix($row['pos'],1).")</td>";

				  $tmCnt=0;

			  }

			  else 

			  {

				  echo "<td colspan=2>TBD</td>";

				  echo "<td>";

				  echo "<a href='./team_summary.php?team_id=$tid&year=$yr'>".$row['name']." ".$row['nickname']."</a> (".$row['w']."-".$row['l'].", ".ordinal_suffix($row['pos'],1).")";

				  if ($row['made_playoffs']==0) {echo "<sup>*</sup>";}

				  $tmCnt=1;

				  $noPOtms=0;

			  }

		  }

		  else

		  {

			  if ($tmCnt==1) {echo "<td>";} else {echo "<br/>";}

			  echo "<a href='./team_summary.php?team_id=$tid&year=$yr'>".$row['name']." ".$row['nickname']."</a> (".$row['w']."-".$row['l'].", ".ordinal_suffix($row['pos'],1).")";

			  if ($row['made_playoffs']==0) {echo "<sup>*</sup>";}

			  $noPOtms=0;

		  }



		  $prevYr=$yr;

		  $tmCnt++;

	  }

	  if ($noPOtms==1)

	  {

		  echo "</td><td>";

		  echo "&nbsp;";

	  }

	  echo "</td></tr>\n";



	  echo " </table>   <!-- close league listing -->\n";

	  echo "</div>   <!-- close league listing -->\n";



  }

  else

  {

	  echo "<div class='textbox' style='border:0px;'></div>\n";

  }



  ## Display Championship Pie Chart

  $query="SELECT team_id,COUNT(won_playoffs) as titles FROM team_history WHERE league_id=$lgid AND won_playoffs=1 GROUP BY team_id ORDER BY titles DESC";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

	  $chartdiv='champpie';

  	  echo "  <div id='$chartdiv' style='clear:both;height:300px;width:600px;margin-left:auto;margin-right:auto;'></div>\n";

	  echo "  <script class='code' type='text/javascript'>\n";

	  echo "   <!--\n";

	  echo "    $(document).ready(function(){\n";

	  echo "      var data = [";

	  $rowCnt=0;

	  while ($row=mysqli_fetch_array($result))

	  {

		  $tid=$row['team_id'];

		  if ($rowCnt>0) {echo ",";}

		  echo "['".$teams[$tid]['abbr']."', ".$row['titles']."]";

		  $rowCnt++;

	  }

	  echo "];\n";

	  echo "      var plot1 = jQuery.jqplot ('$chartdiv', [data], {\n";

	  echo "          title:'Championships By Team',\n";

	  echo "	  seriesDefaults: {\n";

	  echo "                 renderer: jQuery.jqplot.PieRenderer,\n";

	  echo "                 rendererOptions: {showDataLabels: true, dataLabels: 'value', startAngle: -180}\n";

	  echo "                 },\n";

	  echo "	  legend: {\n";

	  echo "                 show: true, location: 'e',\n";

	  echo "                 placement: 'outsideGrid'\n";

	  if ($rowCnt>10)

	  {

		  echo "                 ,rendererOptions: {numberColumns: ";

		  if (($rowCnt%10)!=0) {echo floor($rowCnt/10)+1;} else {echo $rowCnt/10;}

		  echo "}\n";

	  }

	  echo "                 }\n";

	  echo "       });\n";



	  echo "      $(\"#$chartdiv\").bind('jqplotDataHighlight', function(ev, seriesIndex, pointIndex, data) {\n";

	  echo "	  var $"."this = $(this);\n";

	  echo "	  $"."this.attr('title', data[0] + \": \" + data[1]);\n";

	  echo "      });\n";

	  echo "      $(\"#$chartdiv\").bind('jqplotDataUnhighlight', function(ev, seriesIndex, pointIndex, data) {\n";

	  echo "	  var $"."this = $(this);\n";

	  echo "	  $"."this.attr('title',\"\");\n";

	  echo "      });\n";



	  echo "    });\n";

	  echo "   -->\n";

	  echo "  </script>\n";

  }



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";



  page_foot($_SESSION['lgpath']);





?>

