<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgyear=$_SESSION['lgyear'];

  $slid=$_GET['sub_league_id'];

  $view=$_GET['awards'];

  if (($view==0)&&(!is_numeric($view))) {$view=-1;}

  $page=$view;



  include($_SESSION['adminpath']."/dbopen.php");

  $query="SELECT sub_league_id,name,abbr FROM sub_leagues WHERE league_id=$lgid;";

  $result=mysqli_query($db,$query);

  while ($row=mysqli_fetch_array($result))

  {

	  $sub_league_id=$row['sub_league_id'];

	  $subleagues[$sub_league_id]['name']=$row['name'];

	  $subleagues[$sub_league_id]['abbr']=$row['abbr'];

	  if ($slid==$sub_league_id) {$fndSL=true;}

  }

  if (!$fndSL) {$slid=$sub_league_id;}

  if ($slid!="")

  {

	  $title=$subleagues[$slid]['name'];

  }

  else {$title='League';}

  switch ($view)

  {

  case -1:

	  $title.=" Awards Overview";

	  $page="ovr";

	  break;

  case 0:

	  $awName="Player of the Week";

	  $title.=" $awName";

	  $page="potw";

	  break;

  case 1:

  case 2:

  case 3:

  case 11:

  case 13:

  case 15:

	  $awName=get_award($view);

	  $title.=" $awName";

	  break;

  case 10:

	  $query="SELECT setting,value FROM ootp_sql_admin WHERE scope=$lgid AND module='Awards' AND setting IN ('cmAwardName','cmWho')";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))

	  {

		  $setting=$row['setting'];

		  switch ($setting)

		  {

		  case 'cmAwardName':

			  $awName=$row['value'];

			  $title.=" ".$awName." Winners";

			  break;

		  case 'cmWho':

			  $val=$row['value'];

			  switch ($val)

			  {

			  case 'batters':

				  $page='cusB';

				  break;

			  case 'pitchers':

			  case 'relievers':

				  $page='cusP';

				  break;

			  default:

				  $page='cusPB';

				  break;

			  }

		  }

	  }

	  break;

  case 9:

	  $title.=" All-Stars";

	  break;

  default:

	  $query="SELECT pitcher_award_name,mvp_award_name,rookie_award_name,defense_award_name FROM leagues WHERE league_id=$lgid;";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $row=mysqli_fetch_array($result);

	  $idx=$view-4;

	  $awName=$row[$idx];

	  $title.=" ".$awName." Winners";

	  break;



  }



  page_head($title,$_SESSION['lgpath'],"","","./jquery/excanvas.js|./jquery/jquery.min.js|./jquery/jquery.jqplot.min.js|./jquery/plugins/jqplot.categoryAxisRenderer.min.js|./jquery/plugins/jqplot.pointLabels.min.js|./jquery/plugins/jqplot.barRenderer.min.js|./jquery/plugins/jqplot.EnhancedLegendRenderer.min.js|./jquery/plugins/jqplot.highlighter.min.js");

   echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  nav_toolbar("history","History");

  nav_toolbar("leagues","",$lgid,$slid,"",$lgyear,"awards^idx");

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");



  ## Get League Team Stats

  switch ($page)

  {

  case 'ovr':

	  ## Get Award Names

  	  $query="SELECT pitcher_award_name,mvp_award_name,rookie_award_name,defense_award_name FROM leagues WHERE league_id=$lgid;";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $row=mysqli_fetch_array($result);

	  $awName[4]['name']=$row['pitcher_award_name'];

	  $awName[5]['name']=$row['mvp_award_name'];

	  $awName[6]['name']=$row['rookie_award_name'];

	  $awName[7]['name']=$row['defense_award_name'];



  	  $query="SELECT setting,value FROM ootp_sql_admin WHERE scope=$lgid AND module='Awards' AND (setting LIKE '%Abbr' OR setting='cmAwardName')";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))

	  {

		  $setting=$row['setting'];

		  $val=$row['value'];



		  switch ($setting)

		  {

		  case 'poyAbbr'    : $awName[4]['abbr']=$val; break;

		  case 'boyAbbr'    : $awName[5]['abbr']=$val; break;

		  case 'royAbbr'    : $awName[6]['abbr']=$val; break;

		  case 'ggAbbr'     : $awName[7]['abbr']=$val; break;

		  case 'cmAwardName': $awName[10]['name']=$val; break;

		  case 'cmAwardAbbr': $awName[10]['abbr']=$val; break;

		  }

	  }

	  if ($awName[4]['abbr']=="") {$awName[4]['abbr']='POY';}

	  if ($awName[5]['abbr']=="") {$awName[5]['abbr']='BOY';}

	  if ($awName[6]['abbr']=="") {$awName[6]['abbr']='ROY';}

	  if ($awName[7]['abbr']=="") {$awName[7]['abbr']='GG';}





	  ## Most Decorated Players

	  $awArray=Array(4,5,6,7,9,1,2,3,0);

	  $wtArray=Array(4=>8,5=>7,6=>5,7=>3,9=>4,0=>.5,1=>1,2=>1,3=>1);

	  $awQuery="(SELECT best_pitcher_id as player_id,year,4 as award_id FROM league_history WHERE league_id=$lgid) UNION (SELECT best_hitter_id as player_id,year,5 as award_id FROM league_history WHERE league_id=$lgid) UNION (SELECT best_rookie_id as player_id,year,6 as award_id FROM league_history WHERE league_id=$lgid) UNION (SELECT player_id,year,award_id FROM players_awards WHERE league_id=$lgid AND award_id IN (99";

	  foreach ($awArray as $key => $awID)

	  {

	  	if (($awID==4)||($awID==5)||($awID==6)) {continue;}

	  	else $awQuery.=",$awID";

	  }

	  $awQuery.="))";

	  $scoreQuery="SELECT player_id,SUM(score) as score,COUNT(*) as awWon FROM (SELECT player_id,award_id,CASE award_id";

	  foreach ($awArray as $key => $awID) {$scoreQuery.=" WHEN $awID THEN ".$wtArray[$awID];}

	  $scoreQuery.=" END as score FROM ($awQuery) as pa) as x GROUP BY player_id";

	  $query=$scoreQuery." ORDER BY score DESC LIMIT 15,1";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $row=mysqli_fetch_array($result);

	  $minScore=$row['score'];



	  $query="SELECT first_name,last_name,retired,hall_of_fame,x.* FROM players as p,($scoreQuery HAVING SUM(score)>=$minScore) as x WHERE p.player_id=x.player_id ORDER BY score DESC, awWon DESC, last_name";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  # Start Table

  		  echo "<div class='textbox' style='width:100%;'>   <!-- open most decorated listing -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open most decorated listing -->\n";

		  echo "  <tr class='title2'><td colspan=".(3+count($awArray)).">Most Decorated Players<br/>(Top 15, by Weighted Score)</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2_l'>Player</td>";

		  foreach ($awArray as $key => $awID)

		  {

			  echo "<td class='hsc2'";

			  if (!isset($awName[$awID]))

			  {

				  echo " title='".get_award($awID)." (Score: ".$wtArray[$awID].")'>".get_award($awID,1);

			  }

			  else

			  {

				  echo " title='".$awName[$awID]['name']." (Score: ".$wtArray[$awID].")'>".$awName[$awID]['abbr'];

			  }

			  echo "</td>";

		  }

		  echo "<td class='hsc2' title='Number of awards won'># Won</td><td class='hsc2' title='Weighted score'>Score</td>";

		  echo "</tr>\n";



		  # Get Individual Awards Won

		  $rowCnt=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];



			  $cls='s'.($rowCnt%2+1);

			  echo "  <tr class='$cls'>";

			  echo "<td class='".$cls."_l'>";

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

			  echo "</td>";

			  

			  $awQuery="(SELECT best_pitcher_id as player_id,year,4 as award_id FROM league_history WHERE league_id=$lgid AND best_pitcher_id=$pid) UNION (SELECT best_hitter_id as player_id,year,5 as award_id FROM league_history WHERE league_id=$lgid AND best_hitter_id=$pid) UNION (SELECT best_rookie_id as player_id,year,6 as award_id FROM league_history WHERE league_id=$lgid AND best_rookie_id=$pid) UNION (SELECT player_id,year,award_id FROM players_awards WHERE league_id=$lgid AND player_id=$pid AND award_id IN (99";

			  foreach ($awArray as $key => $awID)

			  {

			  	if (($awID==4)||($awID==5)||($awID==6)) {continue;}

			  	else $awQuery.=",$awID";

			  }

			  $awQuery.="))";

			  

			  $pQuery="SELECT CASE award_id";

			  foreach ($awArray as $key => $awID) {$pQuery.=" WHEN $awID THEN $key";}

			  $pQuery.=" END as award_val,award_id,COUNT(*) as yrs FROM ($awQuery) as pa WHERE 1 GROUP BY award_id ORDER BY award_val";

			  if ($_GET['showq']==1) {echo "$pQuery<br/>\n";}

			  $pResult=mysqli_query($db,$pQuery);



			  $lastKey=-1;

			  while ($pRow=mysqli_fetch_array($pResult))

			  {

				  $awID=$pRow['award_id'];



				  $key=array_search($awID,$awArray);

				  if (($key-$lastKey)>1) {echo str_repeat("<td>-</td>",$key-$lastKey-1);}

				  echo "<td>".$pRow['yrs']."</td>";



				  $lastKey=$key;

			  }

			  if ((count($awArray)-$lastKey)>1) {echo str_repeat("<td>-</td>",count($awArray)-$lastKey-1);}

			  echo "<td>".$row['awWon']."</td>";

			  echo "<td>".$row['score']."</td>";



			  echo "</tr>";



			  $rowCnt++;

		  }

		  echo " </table>   <!-- close most decorated listing -->\n";

		  echo "</div>   <!-- close most decorated listing -->\n";

	  }



	  ## Most Times Gold Glove

	  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,COUNT(year) as yrs,MIN(year) as minYr,MAX(year) as maxYr FROM players as p,(SELECT player_id,year FROM players_awards WHERE league_id=$lgid AND award_id=7) as x WHERE p.player_id=x.player_id GROUP BY p.player_id HAVING COUNT(year)>=2 ORDER BY yrs DESC,minYr,maxYr,last_name,first_name";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $rowCnt=-1;

	  if (mysqli_num_rows($result))

	  {

		  $cntQuery="SELECT yrs,COUNT(DISTINCT player_id) as players FROM ($query) as y GROUP BY yrs";

		  if ($_GET['showq']==1) {echo "$cntQuery<br/>\n";}

		  $cntResult=mysqli_query($db,$cntQuery);

		  while ($row=mysqli_fetch_array($cntResult))

		  {

			  $times=$row['yrs'];

			  if ($row['players']<=20) {$xTimes[$times]=$row['players'];}			  

		  }



		  echo "<div class='textbox' style='width:100%;'>   <!-- open frequent player listing -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open frequent player listing -->\n";

		  echo "  <tr class='title2'><td colspan=2>Most Frequent ".$awName[7]['name']." Winners</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2' style='text-align:center;' title='Times Won'>Times</td><td class='hsc2_l'>Players</td></tr>\n";



		  $lastTimes=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $times=$row['yrs'];

			  if (!isset($xTimes[$times])) {break;}



			  if ($times!=$lastTimes)

			  {

				  if ($rowCnt>=0) {echo "</td></tr>\n";}



				  $cls='s'.($rowCnt%2+1);

				  echo "  <tr class='$cls'>";

				  echo "<td style='text-align:center;font-weight:bold;' title='".$xTimes[$times]." player";

				  if ($xTimes[$times]!=1) {echo "s";}

				  echo "'>".$row['yrs']."</td>";

				  echo "<td class='".$cls."_l'>";

				  $rowCnt++;

				  $pcnt=0;

			  }



			  $pid=$row['player_id'];

			  if ($pcnt>0) {echo ", ";}

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo " title='Between ".$row['minYr']." and ".$row['maxYr']."'";

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

	

			  $lastTimes=$times;

			  $pcnt++;

		  }

		  echo "</td></tr>\n";

		  echo " </table>   <!-- close frequent player listing -->\n";

		  echo "</div>   <!-- close frequent player listing -->\n";

	  }

	  unset($xTimes);



	  ## Determine Voting Critera for Outfielders

	  $query="SELECT value FROM ootp_sql_admin WHERE scope=$lgid AND module='Awards' AND setting='splitOF'";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $row=mysqli_fetch_array($result);

	  $splitOF=$row['value'];



	  ## Most Different Positions

	  unset($xTimes);

	  $query="SELECT first_name,last_name,retired,hall_of_fame,x.player_id,COUNT(DISTINCT x.position) as posCnt,COUNT(DISTINCT year) as yrs FROM players as p,(SELECT player_id,year,";

	  if ($splitOF==1) {$query.="position";}

	  else {$query.="if((position=7) OR (position=8) OR (position=9),20,position) as position";}

	  $query.=" FROM players_awards WHERE league_id=$lgid AND award_id=7) as x WHERE p.player_id=x.player_id GROUP BY x.player_id HAVING COUNT(DISTINCT x.position)>1 ORDER BY posCnt DESC,last_name,first_name";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  $cntQuery="SELECT posCnt,COUNT(DISTINCT player_id) as players FROM ($query) as y GROUP BY posCnt";

		  if ($_GET['showq']==1) {echo "$cntQuery<br/>\n";}

		  $cntResult=mysqli_query($db,$cntQuery);

		  while ($row=mysqli_fetch_array($cntResult))

		  {

			  $times=$row['posCnt'];

			  if ($row['players']<=20) {$xTimes[$times]=$row['players'];}			  

		  }



		  echo "<div class='textbox' style='width:100%;'>   <!-- open multiple position listing -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open multiple position listing -->\n";

		  echo "  <tr class='title2'><td colspan=2>".$awName[7]['name']." Winners At Multiple Positions</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2' style='text-align:center;' title='Positions Won'>Positions</td><td class='hsc2_l'>Players</td></tr>\n";



		  $lastTimes=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $times=$row['posCnt'];

			  if (!isset($xTimes[$times])) {break;}



			  if ($times!=$lastTimes)

			  {

				  if ($rowCnt>=0) {echo "</td></tr>\n";}



				  $cls='s'.($rowCnt%2+1);

				  echo "  <tr class='$cls'>";

				  echo "<td style='text-align:center;font-weight:bold;' title='".$xTimes[$times]." player";

				  if ($xTimes[$times]!=1) {echo "s";}

				  echo "'>".$row['posCnt']."</td>";

				  echo "<td class='".$cls."_l'>";

				  $rowCnt++;

				  $pcnt=0;

			  }



			  $pid=$row['player_id'];



			  $pQuery="SELECT DISTINCT position as position FROM (SELECT ";

			  if ($splitOF==1) {$pQuery.="position";}

			  else {$pQuery.="if((position=7) OR (position=8) OR (position=9),20,position) as position";}

			  $pQuery.=" FROM players_awards WHERE league_id=$lgid AND award_id=7 AND player_id=$pid) as x ORDER BY position";

			  if ($_GET['showq']==1) {echo "$pQuery<br/>\n";}

			  $pResult=mysqli_query($db,$pQuery);

			  $posList="";

			  while ($pRow=mysqli_fetch_array($pResult))

			  {

				  if ($posList!="") {$posList.=", ";}

				  $pos=$pRow['position'];

				  $posList.=get_pos($pos,1);

			  }



			  if ($pcnt>0) {echo ", ";}

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo " title='".$row['yrs']." times won'";

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

			  echo " ($posList)";

	

			  $lastTimes=$times;

			  $pcnt++;

		  }

		  echo "</td></tr>\n";

		  echo " </table>   <!-- close multiple position listing -->\n";

		  echo "</div>   <!-- close multiple position listing -->\n";

	  }



	  ## Most Frequent All-Stars

	  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,COUNT(year) as yrs,MIN(year) as minYr,MAX(year) as maxYr FROM players as p,(SELECT player_id,year FROM players_awards WHERE league_id=$lgid AND award_id=9) as x WHERE p.player_id=x.player_id GROUP BY p.player_id HAVING COUNT(year)>=2 ORDER BY yrs DESC,minYr,maxYr,last_name,first_name";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $rowCnt=-1;

	  if (mysqli_num_rows($result))

	  {

		  $cntQuery="SELECT yrs,COUNT(DISTINCT player_id) as players FROM ($query) as y GROUP BY yrs";

		  if ($_GET['showq']==1) {echo "$cntQuery<br/>\n";}

		  $cntResult=mysqli_query($db,$cntQuery);

		  while ($row=mysqli_fetch_array($cntResult))

		  {

			  $times=$row['yrs'];

			  if ($row['players']<=20) {$xTimes[$times]=$row['players'];}			  

		  }



		  echo "<div class='textbox' style='width:100%;'>   <!-- open frequent player listing -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open frequent player listing -->\n";

		  echo "  <tr class='title2'><td colspan=2>Most Frequent All-Stars</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2' style='text-align:center;' title='Times On All-Star Roster'>App.</td><td class='hsc2_l'>Players</td></tr>\n";



		  $lastTimes=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $times=$row['yrs'];

			  if (!isset($xTimes[$times])) {break;}



			  if ($times!=$lastTimes)

			  {

				  if ($rowCnt>=0) {echo "</td></tr>\n";}



				  $cls='s'.($rowCnt%2+1);

				  echo "  <tr class='$cls'>";

				  echo "<td style='text-align:center;font-weight:bold;' title='".$xTimes[$times]." player";

				  if ($xTimes[$times]!=1) {echo "s";}

				  echo "'>".$row['yrs']."</td>";

				  echo "<td class='".$cls."_l'>";

				  $rowCnt++;

				  $pcnt=0;

			  }



			  $pid=$row['player_id'];

			  if ($pcnt>0) {echo ", ";}

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo " title='Between ".$row['minYr']." and ".$row['maxYr']."'";

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

	

			  $lastTimes=$times;

			  $pcnt++;

		  }

		  echo "</td></tr>\n";

		  echo " </table>   <!-- close frequent player listing -->\n";

		  echo "</div>   <!-- close frequent player listing -->\n";



	  }

	  break;

  case 'potw':  //POTW

	  ## Most Frequent Winners

	  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,COUNT(year) as yrs,MIN(year) as minYr,MAX(year) as maxYr FROM players as p,(SELECT player_id,year FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=$view) as x WHERE p.player_id=x.player_id GROUP BY p.player_id HAVING COUNT(year)>=2 ORDER BY yrs DESC,last_name,first_name,minYr,maxYr";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $rowCnt=-1;

	  if (mysqli_num_rows($result))

	  {

		  $cntQuery="SELECT yrs,COUNT(DISTINCT player_id) as players FROM ($query) as y GROUP BY yrs";

		  if ($_GET['showq']==1) {echo "$cntQuery<br/>\n";}

		  $cntResult=mysqli_query($db,$cntQuery);

		  while ($row=mysqli_fetch_array($cntResult))

		  {

			  $times=$row['yrs'];

			  if ($row['players']<=20) {$xTimes[$times]=$row['players'];}			  

		  }



		  echo "<div class='textbox' style='width:100%;'>   <!-- open frequent player listing -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open frequent player listing -->\n";

		  echo "  <tr class='title2'><td colspan=2>Most Frequent $awName Winners</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2' style='text-align:center;width:80px;' title='Times Won'>Times</td><td class='hsc2_l'>Players</td></tr>\n";



		  $lastTimes=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $times=$row['yrs'];

			  if (!isset($xTimes[$times])) {break;}



			  if ($times!=$lastTimes)

			  {

				  if ($rowCnt>=0) {echo "</td></tr>\n";}



				  $cls='s'.($rowCnt%2+1);

				  echo "  <tr class='$cls'>";

				  echo "<td style='text-align:center;font-weight:bold;' title='".$xTimes[$times]." player";

				  if ($xTimes[$times]!=1) {echo "s";}

				  echo "'>".$row['yrs']."</td>";

				  echo "<td class='".$cls."_l'>";

				  $rowCnt++;

				  $pcnt=0;

			  }



			  $pid=$row['player_id'];

			  if ($pcnt>0) {echo ", ";}

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo " title='Between ".$row['minYr']." and ".$row['maxYr']."'";

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

	

			  $lastTimes=$times;

			  $pcnt++;

		  }

		  echo "</td></tr>\n";

		  echo " </table>   <!-- close frequent player listing -->\n";

		  echo "</div>   <!-- close frequent player listing -->\n";

	  }



	  ## Get ROY Statistics

	  unset($winners);

	  # Batter Stats

	  $bStatArray=Array('g','ab','h','d','t','hr','rbi','r','bb','sb','cs','avg','obp','slg','ops','war');

	  $bStatArray=Array('hr','rbi','sb','avg','obp','slg','ops','war');

	  $awQuery="SELECT pa.player_id,pa.team_id,pa.year,pa.month,pa.day";

	  foreach ($bStatArray as $key => $statLbl) {$awQuery.=",".stat_query($statLbl)." as $statLbl";}

	  $awQuery.=" FROM players_career_batting_stats as pcs,players_awards as pa WHERE pa.player_id=pcs.player_id AND pa.season=pcs.year AND pcs.league_id=$lgid AND pa.league_id=$lgid AND pa.sub_league_id=$slid AND split_id=1 AND award_id=$view GROUP BY pcs.player_id,pa.year,pa.month,pa.day";

	  $query="SELECT first_name,last_name,retired,hall_of_fame,(x.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,x.* FROM players as p,($awQuery) as x WHERE p.player_id=x.player_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $yr=$row['year'];

			  $pid=$row['player_id'];

			  $mo=$row['month'];

			  $day=$row['day'];

			  $tid=$row['team_id'];

			  $idx=$yr.str_pad($mo,2,0,STR_PAD_LEFT).str_pad($day,2,0,STR_PAD_LEFT);



			  $winners[$yr][$idx]=$pid;

			  $winTeams[$tid]=$winTeams[$tid]+1;



			  $players[$pid]['name']=$row['first_name']." ".$row['last_name'];

			  $players[$pid]['sortname']=$row['last_name'].", ".$row['first_name'];

			  $players[$pid]['nameshort']=$row['first_name'][0].". ".$row['last_name'];

			  $players[$pid]['retired']=$row['retired'];

			  $players[$pid]['hall_of_fame']=$row['hall_of_fame'];

			  $players[$pid]['age']=$row['age'];

			  foreach ($bStatArray as $key => $statLbl) {$players[$pid][$yr][$statLbl]=$row[$statLbl];}

			  $players[$pid][$yr][$idx]=$tid;

		  }

	  }



	  # Pitcher Stats

	  $pStatArray=Array('pg','gs','w','l','s','era','ip','hra','pbb','pk','hld','cg','sho','whip','pwar');

	  $pStatArray=Array('w','l','s','era','ip','pk','whip','pwar');

	  $awQuery="SELECT pa.player_id,pa.team_id,pa.year,pa.month,pa.day";

	  foreach ($pStatArray as $key => $statLbl) {$awQuery.=",".stat_query($statLbl)." as $statLbl";}

	  $awQuery.=" FROM players_career_pitching_stats as pcs,players_awards as pa WHERE pa.player_id=pcs.player_id AND pa.season=pcs.year AND pcs.league_id=$lgid AND pa.league_id=$lgid AND pa.sub_league_id=$slid AND split_id=1 AND award_id=$view GROUP BY pcs.player_id,pa.year,pa.month,pa.day";

	  $query="SELECT first_name,last_name,retired,hall_of_fame,(x.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,x.* FROM players as p,($awQuery) as x WHERE p.player_id=x.player_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $yr=$row['year'];

			  $pid=$row['player_id'];

			  $mo=$row['month'];

			  $day=$row['day'];

			  $tid=$row['team_id'];

			  $idx=$yr.str_pad($mo,2,0,STR_PAD_LEFT).str_pad($day,2,0,STR_PAD_LEFT);



			  $winners[$yr][$idx]=$pid;

			  $winTeams[$tid]=$winTeams[$tid]+1;



			  $players[$pid]['name']=$row['first_name']." ".$row['last_name'];

			  $players[$pid]['sortname']=$row['last_name'].", ".$row['first_name'];

			  $players[$pid]['nameshort']=$row['first_name'][0].". ".$row['last_name'];

			  $players[$pid]['ret']=$row['retired'];

			  $players[$pid]['hof']=$row['hall_of_fame'];

			  $players[$pid]['age']=$row['age'];

			  foreach ($pStatArray as $key => $statLbl) {$players[$pid][$yr][$statLbl]=$row[$statLbl];}

			  $players[$pid][$yr][$idx]=$tid;

		  }

	  }



	  # Get Team Colors

	  unset($teams);

	  $tidList="";

	  foreach ($winTeams as $tid => $val) {$tidList.=",$tid";}

	  $tidList=trim($tidList,",");

	  $query="SELECT x.team_id,abbr,text_color_id,background_color_id,sub_league_id FROM teams as t,(SELECT pcs.year,pcs.team_id FROM players_awards as pa,players_career_".$table."_stats as pcs WHERE pa.player_id=pcs.player_id AND pa.league_id=$lgid AND pcs.league_id=$lgid AND pa.sub_league_id=$slid AND pa.season=pcs.year AND split_id=1 AND award_id=$view) as x WHERE t.team_id=x.team_id GROUP BY team_id UNION SELECT team_id,abbr,text_color_id,background_color_id,sub_league_id FROM teams WHERE league_id=$lgid AND sub_league_id=$slid AND allstar_team=0 ORDER BY team_id";

	  $query="SELECT team_id,abbr,text_color_id,background_color_id,sub_league_id FROM teams WHERE team_id IN ($tidList) ORDER BY team_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  if (($row['sub_league_id']!=$slid)&&(!isset($winTeams[$tid]))) {continue;}

			  $teams[$tid]['abbr']=$row['abbr'];

			  $teams[$tid][$lgyear]['abbr']=$row['abbr'];

			  $teams[$tid]['text_color_id']=$row['text_color_id'];

			  $teams[$tid]['background_color_id']=$row['background_color_id'];

			  if (!isset($winTeams[$tid])) {$winTeams[$tid]=0;}

		  }

	  }

	  # Get Historical Abbreviations

	  $query="SELECT team_id,year,name,nickname,abbr FROM team_history WHERE team_id IN ($tidList)";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  $yr=$row['year'];

			  $teams[$tid][$yr]['abbr']=$row['abbr'];

			  $teams[$tid][$yr]['name']=$row['name']." ".$row['nickname'];

		  }

	  }



	  # Display

	  if (isset($winners))

	  { 

		  echo "<div class='textbox' style='padding:0;width:100%;'>   <!-- open stats table -->\n";

		  echo " <table border=0 cellpadding=0 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open stats table -->\n";

		  echo "  <tr class='title2'><td style='padding:4px;'>$awName Statistics<br/>(with season stats)</td></tr>\n";

		  echo "  <tr><td>";

		  echo "   <table border=0 cellpadding=2 cellspacing=0 class='sortable' width='100%'>\n";

		  echo "    <tr class='headline'><td class='hsc2_l'>Date</td><td class='hsc2_l'>Year</td><td class='hsc2_l'>Player</td><td class='hsc2_l'>Team</td><td class='hsc2'>Age</td>";

		  foreach ($bStatArray as $key => $statLbl) {echo "<td class='hsc2'>".stat_text($statLbl,2)."</td>";}

		  foreach ($pStatArray as $key => $statLbl) {echo "<td class='hsc2'>".stat_text($statLbl,2)."</td>";}

		  echo "</tr>\n";



		  ksort($winners);

		  $rowCnt=0;

		  foreach ($winners as $yr => $val)

		  {

			  ksort($winners[$yr],SORT_NUMERIC);

			  foreach ($winners[$yr] as $idx => $pid)

			  {

				  $mo=substr($idx,4,2);

				  $day=substr($idx,6,2);

				  $awDate=mktime(0, 0, 0, $mo, $day, $yr);

				  $moTxt=date('M j',$awDate);



				  $cls='s'.($rowCnt%2+1);

				  echo "    <tr class='$cls'>";

				  echo "<td class='".$cls."_l' sorttable_customkey=\"".$mo.$day."\">$moTxt</td>";

				  echo "<td class='".$cls."_l'>$yr</td>";

				  echo "<td class='".$cls."_l' sorttable_customkey=\"".$players[$pid]['sortname']."\">";

				  echo "<a href='./player.php?player_id=$pid'";

				  if ($players[$pid]['hof']==1) {echo " style='font-weight:bold;'";}

				  echo ">".$players[$pid]['name']."</a>";

				  if ($players[$pid]['ret']!=1) {echo "<sup>+</sup>";}

				  echo "</td>";

				  $tid=$players[$pid][$yr][$idx];

				  if (isset($teams[$tid][$yr]['abbr'])) {echo "<td class='".$cls."_l'><a href='./team_summary.php?team_id=$tid&year=$yr'>".$teams[$tid][$yr]['abbr']."</a></td>";}

				  else {echo "<td class='".$cls."_l'><a href='./team_summary.php?team_id=$tid&year=".($yr-1)."'>".$teams[$tid][$yr-1]['abbr']."</a></td>";}

				  echo "<td>".$players[$pid]['age']."</td>";

				  foreach ($bStatArray as $key => $statLbl)

				  {

					  if (isset($players[$pid][$yr][$statLbl])) {echo "<td>".stat_format($statLbl,$players[$pid][$yr][$statLbl])."</td>";}

					  else  {echo "<td>&nbsp;</td>";}

				  }

				  foreach ($pStatArray as $key => $statLbl)

				  {

					  if (isset($players[$pid][$yr][$statLbl])) {echo "<td>".stat_format($statLbl,$players[$pid][$yr][$statLbl])."</td>";}

					  else  {echo "<td>&nbsp;</td>";}

				  }

				  echo "</tr>\n";

				  $rowCnt++;

			  }

		  }

		  echo "   </table>\n";

		  echo "  </td></tr>\n";

		  echo " </table>   <!-- close stats table -->\n";

		  echo "</div>   <!-- close stats table -->\n";

	  }



	  ### Prep Chart

	  # Create Chart Container

	  echo "<div class='textbox' style='width:100%;'>   <!-- open graph -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open graph -->\n";

	  echo "  <tr class='title2'><td colspan=5>$awName Winners By Team</td></tr>\n";

	  echo "  <tr><td>\n";

	  echo "   <div id='chartwrapper' style='overflow:scroll;overflow:auto;max-width:930px;'>\n";

	  echo "    <div id='chartdiv' style='height:300px;width:".(100+35*count($teams))."px;margin-left:auto;margin-right:auto;'></div>";

	  echo "   </div>\n";

	  echo "  </td></tr>\n";

	  echo " </table>   <!-- close graph -->\n";

	  echo "</div>   <!-- close graph -->\n";



	  # Build Chart

	  echo "  <script class='code' type='text/javascript'>\n";

	  echo "   <!--\n";

	  echo "    $(document).ready(function(){\n";

	  $dCnt=0;

	  $dTxt="";

	  $tTxt="";

	  $scTxt="";

	  $maxCnt=0;

	  $minCnt=9999999;

	  foreach ($teams as $tid => $val)

	  {

		  if ($dCnt>0)

		  {

			  $dTxt.=", ";

			  $tTxt.=", ";

			  $scTxt.=", ";

		  }

		  $dTxt.=$winTeams[$tid];

		  if ($winTeams[$tid]>$maxCnt) {$maxCnt=$winTeams[$tid];}

		  if ($winTeams[$tid]<$minCnt) {$minCnt=$winTeams[$tid];}

		  $tTxt.="'".$teams[$tid]['abbr']."'";

		  $scTxt.="'".$teams[$tid]['background_color_id']."'";

		  $dCnt++;

	  }

	  $yTickInt=max(1,floor(($maxCnt-$minCnt)/10));

	  $yMin=max(0,$minCnt-2*$yTickInt);

	  $nTeams=$dCnt;

	  echo "      var data  = [$dTxt];\n";

	  echo "      var ticks = [$tTxt];\n";

	  echo "      var plot1 = jQuery.jqplot ('chartdiv', [data], {\n";

	  echo "	  seriesDefaults: {\n";

	  echo "                 renderer: jQuery.jqplot.BarRenderer,\n";

	  echo "                 pointLabels: {show: true, location: 's', ypadding:2},\n";

	  echo "                 rendererOptions: {fillToZero: true, varyBarColor: true, barMargin:10}\n";

	  echo "                 },\n";

	  echo "          seriesColors:[$scTxt],\n";

	  echo "	  legend: {show: false},\n";

	  echo "          axes: {\n";

	  echo "                 xaxis: {\n";

	  echo "                       renderer:jQuery.jqplot.CategoryAxisRenderer,\n";

	  echo "                       ticks: ticks";

	  echo "                        },\n";

	  echo "                 yaxis: {\n";

	  echo "                       min: $yMin,";

	  echo "                       tickInterval: $yTickInt";

	  echo "                        }\n";

	  echo "                 }\n";

	  echo "       });\n";

	  echo "\n";

	  echo "      jQuery('.jqplot-point-label').css('font-weight','bold');\n";

	  $idx=0;

	  foreach ($teams as $tid => $val)

	  {

		  $lbl=$winTeams[$tid];

		  if (($lbl>0)&&($lbl<10))

		  {

			  echo "      jQuery('.jqplot-point-$idx').css('font-size','".(0.75+($lbl-$yTickInt)*.05)."em');\n";

			  echo "      jQuery('.jqplot-point-$idx').css('color','".$teams[$tid]['text_color_id']."');\n";

		  }

		  if ($lbl>=10)

		  {

			  echo "      jQuery('.jqplot-point-$idx').css('font-size','".(0.75+(10-$yTickInt)*.05)."em');\n";

			  echo "      jQuery('.jqplot-point-$idx').css('color','".$teams[$tid]['text_color_id']."');\n";

			  echo "      if (jQuery('.jqplot-point-$idx').length) {\n";

			  echo "          jQuery('.jqplot-point-$idx').css('left',";

			  echo "(jQuery('.jqplot-point-$idx').position().left - 4)";

			  echo " + 'px');\n";

			  echo "      }\n";

		  }

		  if ($lbl>=100)

		  {

			  echo "      jQuery('.jqplot-point-$idx').css('font-size','".(0.75+(10-$yTickInt)*.025)."em');\n";

			  echo "      jQuery('.jqplot-point-$idx').css('color','".$teams[$tid]['text_color_id']."');\n";

			  echo "      if (jQuery('.jqplot-point-$idx').length) {\n";

			  echo "          jQuery('.jqplot-point-$idx').css('left',";

			  echo "(jQuery('.jqplot-point-$idx').position().left + 1)";

			  echo " + 'px');\n";

			  echo "      }\n";

		  }

		  $idx++;

	  }

	  echo "    });\n";

	  echo "   -->\n";

	  echo "  </script>\n"; 

	  break;

  case 1:  //POTM

  case 2:  //BOTM

	  switch ($page)

	  {

	  case 1:

		  $statArray=Array('g','gs','w','l','s','era','ip','ha','ra','er','hra','bb','k','hp','hld','cg','sho','whip','babip','war');

		  $table='pitching';

		  break;

	  case 2:

		  $statArray=Array('g','ab','h','d','t','hr','rbi','r','bb','hp','sh','sf','k','sb','cs','avg','obp','slg','ops','war');

		  $table='batting';

		  break;

	  }



	  ## Most Frequent Winners

	  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,COUNT(year) as yrs,MIN(year) as minYr,MAX(year) as maxYr FROM players as p,(SELECT player_id,year FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=$view) as x WHERE p.player_id=x.player_id GROUP BY p.player_id HAVING COUNT(year)>=2 ORDER BY yrs DESC,minYr,maxYr,last_name,first_name";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $rowCnt=-1;

	  if (mysqli_num_rows($result))

	  {

		  $cntQuery="SELECT yrs,COUNT(DISTINCT player_id) as players FROM ($query) as y GROUP BY yrs";

		  if ($_GET['showq']==1) {echo "$cntQuery<br/>\n";}

		  $cntResult=mysqli_query($db,$cntQuery);

		  while ($row=mysqli_fetch_array($cntResult))

		  {

			  $times=$row['yrs'];

			  if ($row['players']<=20) {$xTimes[$times]=$row['players'];}			  

		  }



		  echo "<div class='textbox' style='width:100%;'>   <!-- open frequent player listing -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open frequent player listing -->\n";

		  echo "  <tr class='title2'><td colspan=2>Most Frequent $awName Winners</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2' style='text-align:center;width:80px;' title='Times Won'>Times</td><td class='hsc2_l'>Players</td></tr>\n";



		  $lastTimes=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $times=$row['yrs'];

			  if (!isset($xTimes[$times])) {break;}



			  if ($times!=$lastTimes)

			  {

				  if ($rowCnt>=0) {echo "</td></tr>\n";}



				  $cls='s'.($rowCnt%2+1);

				  echo "  <tr class='$cls'>";

				  echo "<td style='text-align:center;font-weight:bold;' title='".$xTimes[$times]." player";

				  if ($xTimes[$times]!=1) {echo "s";}

				  echo "'>".$row['yrs']."</td>";

				  echo "<td class='".$cls."_l'>";

				  $rowCnt++;

				  $pcnt=0;

			  }



			  $pid=$row['player_id'];

			  if ($pcnt>0) {echo ", ";}

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo " title='Between ".$row['minYr']." and ".$row['maxYr']."'";

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

	

			  $lastTimes=$times;

			  $pcnt++;

		  }

		  echo "</td></tr>\n";

		  echo " </table>   <!-- close frequent player listing -->\n";

		  echo "</div>   <!-- close frequent player listing -->\n";

	  }



	  ## Standard Listing

	  # Get Team Names

	  $query="SELECT x.team_id,x.year,name,nickname,abbr FROM team_history as t,(SELECT pcs.year,pcs.team_id FROM players_awards as pa,players_career_".$table."_stats as pcs WHERE pa.player_id=pcs.player_id AND pa.league_id=$lgid AND pcs.league_id=$lgid AND pa.sub_league_id=$slid AND pa.season=pcs.year AND split_id=1 AND award_id=$view) as x WHERE t.team_id=x.team_id AND t.year=x.year";

	  $query.=" UNION SELECT team_id,$lgyear as year,name,nickname,abbr FROM teams WHERE league_id=$lgid AND sub_league_id=$slid AND allstar_team=0";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  $yr=$row['year'];

			  $teams[$tid][$yr]['abbr']=$row['abbr'];

			  $teams[$tid][$yr]['name']=$row['name']." ".$row['nickname'];

		  }

	  }



	  # Get Player Stats

	  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,(x.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,x.* FROM players as p,(SELECT pa.player_id,if(pa.month=1,pa.year-1,pa.year) as year,if(pa.day>1,pa.month+1,pa.month) as month,pcs.team_id";

	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}

 	  $query.=" FROM players_awards as pa,players_career_".$table."_stats as pcs WHERE pa.player_id=pcs.player_id AND pa.league_id=$lgid AND pcs.league_id=$lgid AND pa.sub_league_id=$slid AND pa.season=pcs.year AND split_id=1 AND award_id=$view GROUP BY player_id,year,month,day) as x WHERE p.player_id=x.player_id ORDER BY year,month";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  echo "<div class='textbox' style='width:100%;'>   <!-- open stat listing -->\n";

		  echo " <table border=0 cellpadding=0 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open stat listing -->\n";

		  echo "  <tr class='title2'><td style='padding:4px;' colspan=".(5+count($statArray)).">$awName Listing<br/>(with season stats)</td></tr>\n";

		  echo "  <tr><td>\n";

		  echo "   <table border=0 cellpadding=2 cellspacing=0 class='sortable' style='width:100%;'>\n";

		  echo "    <tr class='headline'><td class='hsc2_l'>Month</td><td class='hsc2_l'>Year</td><td class='hsc2_l'>Player</td><td class='hsc2_l'>Team</td><td class='hsc2'>Age</td>";

		  foreach ($statArray as $key => $statLbl) {echo "<td class='hsc2'>".stat_text($statLbl,2)."</td>";}

		  echo "</tr>\n";



		  $startYr=99999;

		  $endYr=0;



		  $rowCnt=0;

		  while ($row=mysqli_fetch_array($result))

		  {		  

			  $pid=$row['player_id'];

			  $tid=$row['team_id'];

			  $yr=$row['year'];

			  if ($yr<$startYr) {$startYr=$yr;}

			  if ($yr>$endYr) {$endYr=$yr;}

			  $mo=$row['month']-1;

			  $moTxt=str_pad($mo,2,"0",STR_PAD_LEFT);

			  $awDate=mktime(0, 0, 0, $mo, 1, $yr);

			  $moTxt=date('M',$awDate);



			  $winners[$tid]=$winners[$tid]+1;



			  $cls='s'.($rowCnt%2+1);

			  echo "    <tr class='$cls'>";

			  echo "<td class='".$cls."_l' sorttable_customkey=\"$mo\">$moTxt</td>";

			  echo "<td class='".$cls."_l'>$yr</td>";

			  echo "<td class='".$cls."_l' sorttable_customkey=\"".$row['last_name'].", ".$row['first_name']."\">";

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

			  echo "</td>";

			  if (isset($teams[$tid][$yr]['abbr'])) {echo "<td class='".$cls."_l' title='".$teams[$tid][$yr]['name']."'><a href='./team_summary.php?year=$yr&team_id=$tid'>".$teams[$tid][$yr]['abbr']."</td>";}

			  else {echo "<td class='".$cls."_l' title='".$teams[$tid][$yr-1]['name']."'><a href='./team_summary.php?year=".($yr-1)."&team_id=$tid'>".$teams[$tid][$yr-1]['abbr']."</td>";}

			  echo "<td>".$row['age']."</td>";

			  foreach ($statArray as $key => $statLbl)

			  {

				  echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";

			  }

			  echo "</tr>\n";

	

			  $rowCnt++;

		  }

		  echo "   </table>\n";

		  echo "  </td></tr>\n";

		  echo " </table>   <!-- close stat listing -->\n";

		  echo "</div>   <!-- close stat listing -->\n";

	  }



	  ### Prep Chart

	  # Get Team Colors

	  unset($teams);

	  $query="SELECT x.team_id,abbr,text_color_id,background_color_id,sub_league_id FROM teams as t,(SELECT pcs.year,pcs.team_id FROM players_awards as pa,players_career_".$table."_stats as pcs WHERE pa.player_id=pcs.player_id AND pa.league_id=$lgid AND pcs.league_id=$lgid AND pa.sub_league_id=$slid AND pa.season=pcs.year AND split_id=1 AND award_id=$view) as x WHERE t.team_id=x.team_id GROUP BY team_id UNION SELECT team_id,abbr,text_color_id,background_color_id,sub_league_id FROM teams WHERE league_id=$lgid AND sub_league_id=$slid AND allstar_team=0 ORDER BY team_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  if (($row['sub_league_id']!=$slid)&&(!isset($winners[$tid]))) {continue;}

			  $teams[$tid]['abbr']=$row['abbr'];

			  $teams[$tid]['text_color_id']=$row['text_color_id'];

			  $teams[$tid]['background_color_id']=$row['background_color_id'];

			  if (!isset($winners[$tid])) {$winners[$tid]=0;}

		  }

	  }



	  # Create Chart Container

	  echo "<div class='textbox' style='width:100%;'>   <!-- open graph -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open graph -->\n";

	  echo "  <tr class='title2'><td colspan=5>$awName Winners By Team</td></tr>\n";

	  echo "  <tr><td>\n";

	  echo "   <div id='chartwrapper' style='overflow:scroll;overflow:auto;max-width:930px;'>\n";

	  echo "    <div id='chartdiv' style='height:300px;width:".(100+35*count($teams))."px;margin-left:auto;margin-right:auto;'></div>";

	  echo "   </div>\n";

	  echo "  </td></tr>\n";

	  echo " </table>   <!-- close graph -->\n";

	  echo "</div>   <!-- close graph -->\n";



	  # Build Chart

	  echo "  <script class='code' type='text/javascript'>\n";

	  echo "   <!--\n";

	  echo "    $(document).ready(function(){\n";

	  $dCnt=0;

	  $dTxt="";

	  $tTxt="";

	  $scTxt="";

	  $maxCnt=0;

	  foreach ($teams as $tid => $val)

	  {

		  if ($dCnt>0)

		  {

			  $dTxt.=", ";

			  $tTxt.=", ";

			  $scTxt.=", ";

		  }

		  $dTxt.=$winners[$tid];

		  if ($winners[$tid]>$maxCnt) {$maxCnt=$winners[$tid];}

		  $tTxt.="'".$teams[$tid]['abbr']."'";

		  $scTxt.="'".$teams[$tid]['background_color_id']."'";

		  $dCnt++;

	  }

	  $yTickInt=max(1,floor($maxCnt/10));

	  $nTeams=$dCnt;

	  echo "      var data  = [$dTxt];\n";

	  echo "      var ticks = [$tTxt];\n";

	  echo "      var plot1 = jQuery.jqplot ('chartdiv', [data], {\n";

	  echo "	  seriesDefaults: {\n";

	  echo "                 renderer: jQuery.jqplot.BarRenderer,\n";

	  echo "                 pointLabels: {show: true, location: 's', ypadding:2},\n";

	  echo "                 rendererOptions: {fillToZero: true, varyBarColor: true, barMargin:10}\n";

	  echo "                 },\n";

	  echo "          seriesColors:[$scTxt],\n";

	  echo "	  legend: {show: false},\n";

	  echo "          axes: {\n";

	  echo "                 xaxis: {\n";

	  echo "                       renderer:jQuery.jqplot.CategoryAxisRenderer,\n";

	  echo "                       ticks: ticks";

	  echo "                        },\n";

	  echo "                 yaxis: {\n";

	  echo "                       min: 0,";

	  echo "                       tickInterval: $yTickInt";

	  echo "                        }\n";

	  echo "                 }\n";

	  echo "       });\n";

	  echo "\n";

	  echo "      jQuery('.jqplot-point-label').css('font-weight','bold');\n";

	  $idx=0;

	  foreach ($teams as $tid => $val)

	  {

		  $lbl=$winners[$tid];

		  if (($lbl>0)&&($lbl<10))

		  {

			  echo "      jQuery('.jqplot-point-$idx').css('font-size','".(0.75+($lbl-$yTickInt)*.05)."em');\n";

			  echo "      jQuery('.jqplot-point-$idx').css('color','".$teams[$tid]['text_color_id']."');\n";

		  }

		  if ($lbl>=10)

		  {

			  echo "      jQuery('.jqplot-point-$idx').css('font-size','".(0.75+(10-$yTickInt)*.05)."em');\n";

			  echo "      jQuery('.jqplot-point-$idx').css('color','".$teams[$tid]['text_color_id']."');\n";

			  echo "      if (jQuery('.jqplot-point-$idx').length) {\n";

			  echo "          jQuery('.jqplot-point-$idx').css('left',";

			  echo "(jQuery('.jqplot-point-$idx').position().left - 4)";

			  echo " + 'px');\n";

			  echo "      }\n";

		  }

		  $idx++;

	  }

	  echo "    });\n";

	  echo "   -->\n";

	  echo "  </script>\n"; 

	  break;

  case 3:  //ROTM

	  ## Most Frequent Winners

	  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,COUNT(year) as yrs,MIN(year) as minYr,MAX(year) as maxYr FROM players as p,(SELECT player_id,year FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=$view) as x WHERE p.player_id=x.player_id GROUP BY p.player_id HAVING COUNT(year)>=2 ORDER BY yrs DESC,minYr,maxYr,last_name,first_name";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $rowCnt=-1;

	  if (mysqli_num_rows($result))

	  {

		  $cntQuery="SELECT yrs,COUNT(DISTINCT player_id) as players FROM ($query) as y GROUP BY yrs";

		  if ($_GET['showq']==1) {echo "$cntQuery<br/>\n";}

		  $cntResult=mysqli_query($db,$cntQuery);

		  while ($row=mysqli_fetch_array($cntResult))

		  {

			  $times=$row['yrs'];

			  if ($row['players']<=20) {$xTimes[$times]=$row['players'];}			  

		  }



		  echo "<div class='textbox' style='width:100%;'>   <!-- open frequent player listing -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open frequent player listing -->\n";

		  echo "  <tr class='title2'><td colspan=2>Most Frequent $awName Winners</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2' style='text-align:center;width:80px;' title='Times Won'>Times</td><td class='hsc2_l'>Players</td></tr>\n";



		  $lastTimes=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $times=$row['yrs'];

			  if (!isset($xTimes[$times])) {break;}



			  if ($times!=$lastTimes)

			  {

				  if ($rowCnt>=0) {echo "</td></tr>\n";}



				  $cls='s'.($rowCnt%2+1);

				  echo "  <tr class='$cls'>";

				  echo "<td style='text-align:center;font-weight:bold;' title='".$xTimes[$times]." player";

				  if ($xTimes[$times]!=1) {echo "s";}

				  echo "'>".$row['yrs']."</td>";

				  echo "<td class='".$cls."_l'>";

				  $rowCnt++;

				  $pcnt=0;

			  }



			  $pid=$row['player_id'];

			  if ($pcnt>0) {echo ", ";}

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo " title='Between ".$row['minYr']." and ".$row['maxYr']."'";

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

	

			  $lastTimes=$times;

			  $pcnt++;

		  }

		  echo "</td></tr>\n";

		  echo " </table>   <!-- close frequent player listing -->\n";

		  echo "</div>   <!-- close frequent player listing -->\n";

	  }



	  ## Get ROY Statistics

	  unset($winners);

	  # Batter Stats

	  $bStatArray=Array('g','ab','h','d','t','hr','rbi','r','bb','sb','cs','avg','obp','slg','ops','war');

	  $bStatArray=Array('hr','rbi','sb','avg','obp','slg','ops','war');

	  $awQuery="SELECT pa.player_id,pa.team_id,if(pa.month=1,pa.year-1,pa.year) as year,if(pa.day>1,pa.month+1,pa.month) as month";

	  foreach ($bStatArray as $key => $statLbl) {$awQuery.=",".stat_query($statLbl)." as $statLbl";}

	  $awQuery.=" FROM players_career_batting_stats as pcs,players_awards as pa WHERE pa.player_id=pcs.player_id AND pa.season=pcs.year AND pcs.league_id=$lgid AND pa.league_id=$lgid AND pa.sub_league_id=$slid AND split_id=1 AND award_id=$view GROUP BY pcs.player_id,pa.year,pa.month,pa.day";

	  $query="SELECT first_name,last_name,retired,hall_of_fame,(x.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,x.* FROM players as p,($awQuery) as x WHERE p.player_id=x.player_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $yr=$row['year'];

			  $pid=$row['player_id'];

			  $mo=$row['month']-1;

			  $tid=$row['team_id'];



			  $winners[$yr][$mo]=$pid;

			  $winTeams[$tid]=$winTeams[$tid]+1;



			  $players[$pid]['name']=$row['first_name']." ".$row['last_name'];

			  $players[$pid]['sortname']=$row['last_name'].", ".$row['first_name'];

			  $players[$pid]['nameshort']=$row['first_name'][0].". ".$row['last_name'];

			  $players[$pid]['retired']=$row['retired'];

			  $players[$pid]['hall_of_fame']=$row['hall_of_fame'];

			  $players[$pid]['age']=$row['age'];

			  foreach ($bStatArray as $key => $statLbl) {$players[$pid][$yr][$statLbl]=$row[$statLbl];}

			  $players[$pid][$yr][$mo]=$tid;

		  }

	  }



	  # Pitcher Stats

	  $pStatArray=Array('pg','gs','w','l','s','era','ip','hra','pbb','pk','hld','cg','sho','whip','pwar');

	  $pStatArray=Array('w','l','s','era','ip','pk','whip','pwar');

	  $awQuery="SELECT pa.player_id,pa.team_id,if(pa.month=1,pa.year-1,pa.year) as year,if(pa.month=1,12,pa.month-1) as month";

	  foreach ($pStatArray as $key => $statLbl) {$awQuery.=",".stat_query($statLbl)." as $statLbl";}

	  $awQuery.=" FROM players_career_pitching_stats as pcs,players_awards as pa WHERE pa.player_id=pcs.player_id AND pa.season=pcs.year AND pcs.league_id=$lgid AND pa.league_id=$lgid AND pa.sub_league_id=$slid AND split_id=1 AND award_id=$view GROUP BY pcs.player_id,pa.year,pa.month";

	  $query="SELECT first_name,last_name,retired,hall_of_fame,(x.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,x.* FROM players as p,($awQuery) as x WHERE p.player_id=x.player_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $yr=$row['year'];

			  $pid=$row['player_id'];

			  $mo=$row['month'];

			  $tid=$row['team_id'];



			  $winners[$yr][$mo]=$pid;

			  $winTeams[$tid]=$winTeams[$tid]+1;



			  $players[$pid]['name']=$row['first_name']." ".$row['last_name'];

			  $players[$pid]['sortname']=$row['last_name'].", ".$row['first_name'];

			  $players[$pid]['nameshort']=$row['first_name'][0].". ".$row['last_name'];

			  $players[$pid]['ret']=$row['retired'];

			  $players[$pid]['hof']=$row['hall_of_fame'];

			  $players[$pid]['age']=$row['age'];

			  foreach ($pStatArray as $key => $statLbl) {$players[$pid][$yr][$statLbl]=$row[$statLbl];}

			  $players[$pid][$yr][$mo]=$tid;

		  }

	  }



	  if (!isset($winners))

	  {

		  echo "<div class='textbox' style='border:0;'>No $awName winners</div>\n";

		  break;

	  }



	  # Get Team Colors

	  unset($teams);

	  $tidList="";

	  foreach ($winTeams as $tid => $val) {$tidList.=",$tid";}

	  $tidList=trim($tidList,",");

	  $query="SELECT x.team_id,abbr,text_color_id,background_color_id,sub_league_id FROM teams as t,(SELECT pcs.year,pcs.team_id FROM players_awards as pa,players_career_".$table."_stats as pcs WHERE pa.player_id=pcs.player_id AND pa.league_id=$lgid AND pcs.league_id=$lgid AND pa.sub_league_id=$slid AND pa.season=pcs.year AND split_id=1 AND award_id=$view) as x WHERE t.team_id=x.team_id GROUP BY team_id UNION SELECT team_id,abbr,text_color_id,background_color_id,sub_league_id FROM teams WHERE league_id=$lgid AND sub_league_id=$slid AND allstar_team=0 ORDER BY team_id";

	  $query="SELECT team_id,abbr,text_color_id,background_color_id,sub_league_id FROM teams WHERE team_id IN ($tidList) ORDER BY team_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  if (($row['sub_league_id']!=$slid)&&(!isset($winTeams[$tid]))) {continue;}

			  $teams[$tid]['abbr']=$row['abbr'];

			  $teams[$tid][$lgyear]['abbr']=$row['abbr'];

			  $teams[$tid]['text_color_id']=$row['text_color_id'];

			  $teams[$tid]['background_color_id']=$row['background_color_id'];

			  if (!isset($winTeams[$tid])) {$winTeams[$tid]=0;}

		  }

	  }

	  # Get Historical Abbreviations

	  $query="SELECT team_id,year,name,nickname,abbr FROM team_history WHERE team_id IN ($tidList)";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  $yr=$row['year'];

			  $teams[$tid][$yr]['abbr']=$row['abbr'];

			  $teams[$tid][$yr]['name']=$row['name']." ".$row['nickname'];

		  }

	  }



	  # Display

	  if (isset($winners))

	  { 

		  echo "<div class='textbox' style='padding:0;width:100%;'>   <!-- open stats table -->\n";

		  echo " <table border=0 cellpadding=0 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open stats table -->\n";

		  echo "  <tr class='title2'><td style='padding:4px;'>$awName Statistics<br/>(with season stats)</td></tr>\n";

		  echo "  <tr><td>";

		  echo "   <table border=0 cellpadding=2 cellspacing=0 class='sortable' width='100%'>\n";

		  echo "    <tr class='headline'><td class='hsc2_l'>Month</td><td class='hsc2_l'>Year</td><td class='hsc2_l'>Player</td><td class='hsc2_l'>Team</td><td class='hsc2'>Age</td>";

		  foreach ($bStatArray as $key => $statLbl) {echo "<td class='hsc2'>".stat_text($statLbl,2)."</td>";}

		  foreach ($pStatArray as $key => $statLbl) {echo "<td class='hsc2'>".stat_text($statLbl,2)."</td>";}

		  echo "</tr>\n";



		  ksort($winners);

		  $rowCnt=0;

		  foreach ($winners as $yr => $val)

		  {

			  ksort($winners[$yr]);

			  foreach ($winners[$yr] as $mo => $pid)

			  {

				  $moTxt=str_pad($mo,2,"0",STR_PAD_LEFT);

				  $awDate=mktime(0, 0, 0, $mo, 1, $yr);

				  $moTxt=date('M',$awDate);



				  $cls='s'.($rowCnt%2+1);

				  echo "    <tr class='$cls'>";

				  echo "<td class='".$cls."_l' sorttable_customkey=\"$mo\">$moTxt</td>";

				  echo "<td class='".$cls."_l'>$yr</td>";

				  echo "<td class='".$cls."_l' sorttable_customkey=\"".$players[$pid]['sortname']."\">";

				  echo "<a href='./player.php?player_id=$pid'";

				  if ($players[$pid]['hof']==1) {echo " style='font-weight:bold;'";}

				  echo ">".$players[$pid]['name']."</a>";

				  if ($players[$pid]['ret']!=1) {echo "<sup>+</sup>";}

				  echo "</td>";

				  $tid=$players[$pid][$yr][$mo];

				  if (isset($teams[$tid][$yr]['abbr'])) {echo "<td class='".$cls."_l'><a href='./team_summary.php?team_id=$tid&year=$yr'>".$teams[$tid][$yr]['abbr']."</a></td>";}

				  else {echo "<td class='".$cls."_l'><a href='./team_summary.php?team_id=$tid&year=".($yr-1)."'>".$teams[$tid][$yr-1]['abbr']."</a></td>";}

				  echo "<td>".$players[$pid]['age']."</td>";

				  foreach ($bStatArray as $key => $statLbl)

				  {

					  if (isset($players[$pid][$yr][$statLbl])) {echo "<td>".stat_format($statLbl,$players[$pid][$yr][$statLbl])."</td>";}

					  else  {echo "<td>&nbsp;</td>";}

				  }

				  foreach ($pStatArray as $key => $statLbl)

				  {

					  if (isset($players[$pid][$yr][$statLbl])) {echo "<td>".stat_format($statLbl,$players[$pid][$yr][$statLbl])."</td>";}

					  else  {echo "<td>&nbsp;</td>";}

				  }

				  echo "</tr>\n";

				  $rowCnt++;

			  }

		  }

		  echo "   </table>\n";

		  echo "  </td></tr>\n";

		  echo " </table>   <!-- close stats table -->\n";

		  echo "</div>   <!-- close stats table -->\n";

	  }



	  ### Prep Chart

	  # Create Chart Container

	  echo "<div class='textbox' style='width:100%;'>   <!-- open graph -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open graph -->\n";

	  echo "  <tr class='title2'><td colspan=5>$awName Winners By Team</td></tr>\n";

	  echo "  <tr><td>\n";

	  echo "   <div id='chartwrapper' style='overflow:scroll;overflow:auto;max-width:930px;'>\n";

	  echo "    <div id='chartdiv' style='height:300px;width:".(100+35*count($teams))."px;margin-left:auto;margin-right:auto;'></div>";

	  echo "   </div>\n";

	  echo "  </td></tr>\n";

	  echo " </table>   <!-- close graph -->\n";

	  echo "</div>   <!-- close graph -->\n";



	  # Build Chart

	  echo "  <script class='code' type='text/javascript'>\n";

	  echo "   <!--\n";

	  echo "    $(document).ready(function(){\n";

	  $dCnt=0;

	  $dTxt="";

	  $tTxt="";

	  $scTxt="";

	  $maxCnt=0;

	  foreach ($teams as $tid => $val)

	  {

		  if ($dCnt>0)

		  {

			  $dTxt.=", ";

			  $tTxt.=", ";

			  $scTxt.=", ";

		  }

		  $dTxt.=$winTeams[$tid];

		  if ($winTeams[$tid]>$maxCnt) {$maxCnt=$winTeams[$tid];}

		  $tTxt.="'".$teams[$tid]['abbr']."'";

		  $scTxt.="'".$teams[$tid]['background_color_id']."'";

		  $dCnt++;

	  }

	  $yTickInt=max(1,floor($maxCnt/10));

	  $nTeams=$dCnt;

	  echo "      var data  = [$dTxt];\n";

	  echo "      var ticks = [$tTxt];\n";

	  echo "      var plot1 = jQuery.jqplot ('chartdiv', [data], {\n";

	  echo "	  seriesDefaults: {\n";

	  echo "                 renderer: jQuery.jqplot.BarRenderer,\n";

	  echo "                 pointLabels: {show: true, location: 's', ypadding:2},\n";

	  echo "                 rendererOptions: {fillToZero: true, varyBarColor: true, barMargin:10}\n";

	  echo "                 },\n";

	  echo "          seriesColors:[$scTxt],\n";

	  echo "	  legend: {show: false},\n";

	  echo "          axes: {\n";

	  echo "                 xaxis: {\n";

	  echo "                       renderer:jQuery.jqplot.CategoryAxisRenderer,\n";

	  echo "                       ticks: ticks";

	  echo "                        },\n";

	  echo "                 yaxis: {\n";

	  echo "                       min: 0,";

	  echo "                       tickInterval: $yTickInt";

	  echo "                        }\n";

	  echo "                 }\n";

	  echo "       });\n";

	  echo "\n";

	  echo "      jQuery('.jqplot-point-label').css('font-weight','bold');\n";

	  $idx=0;

	  foreach ($teams as $tid => $val)

	  {

		  $lbl=$winTeams[$tid];

		  if (($lbl>0)&&($lbl<10))

		  {

			  echo "      jQuery('.jqplot-point-$idx').css('font-size','".(0.75+($lbl-$yTickInt)*.05)."em');\n";

			  echo "      jQuery('.jqplot-point-$idx').css('color','".$teams[$tid]['text_color_id']."');\n";

		  }

		  if ($lbl>=10)

		  {

			  echo "      jQuery('.jqplot-point-$idx').css('font-size','".(0.75+(10-$yTickInt)*.05)."em');\n";

			  echo "      jQuery('.jqplot-point-$idx').css('color','".$teams[$tid]['text_color_id']."');\n";

			  echo "      if (jQuery('.jqplot-point-$idx').length) {\n";

			  echo "          jQuery('.jqplot-point-$idx').css('left',";

			  echo "(jQuery('.jqplot-point-$idx').position().left - 4)";

			  echo " + 'px');\n";

			  echo "      }\n";

		  }

		  $idx++;

	  }

	  echo "    });\n";

	  echo "   -->\n";

	  echo "  </script>\n"; 

	  break;

  case 4:  //POY

  case 5:  //BOY

  case 'cusP':  //Custom Pitchers

  case 'cusB':  //Custom Batters

	  switch ($page)

	  {

	  case 4:

	  case 'cusP':

		  $statArray=Array('g','gs','w','l','s','era','ip','ha','ra','er','hra','bb','k','hp','hld','cg','sho','whip','babip','war');

		  $table='pitching';

		  break;

	  case 5:

	  case 'cusB':

		  $statArray=Array('g','ab','h','d','t','hr','rbi','r','bb','hp','sh','sf','k','sb','cs','avg','obp','slg','ops','war');

		  $table='batting';

		  break;

	  }



	  ## Most Frequent Winners

	  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,COUNT(year) as yrs,MIN(year) as minYr,MAX(year) as maxYr FROM players as p,(SELECT ";

	  switch ($page)

	  {

	  	case 4:

	  	case 'cusP':

	  		$query.="best_pitcher_id";

	  		break;

	  	case 5:

	  	case 'cusB':

	  		$query.="best_hitter_id";

	  		break;

	  }

	  $query.=" as player_id,year FROM league_history WHERE league_id=$lgid AND sub_league_id=$slid) as x WHERE p.player_id=x.player_id GROUP BY p.player_id HAVING COUNT(year)>=2 ORDER BY yrs DESC,minYr,maxYr,last_name,first_name";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $rowCnt=-1;

	  if (mysqli_num_rows($result))

	  {

		  $cntQuery="SELECT yrs,COUNT(DISTINCT player_id) as players FROM ($query) as y GROUP BY yrs";

		  if ($_GET['showq']==1) {echo "$cntQuery<br/>\n";}

		  $cntResult=mysqli_query($db,$cntQuery);

		  while ($row=mysqli_fetch_array($cntResult))

		  {

			  $times=$row['yrs'];

			  if ($row['players']<=20) {$xTimes[$times]=$row['players'];}			  

		  }



		  echo "<div class='textbox' style='width:100%;'>   <!-- open frequent player listing -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open frequent player listing -->\n";

		  echo "  <tr class='title2'><td colspan=2>Most Frequent $awName Winners</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2' style='text-align:center;width:80px;' title='Times Won'>Times</td><td class='hsc2_l'>Players</td></tr>\n";



		  $lastTimes=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $times=$row['yrs'];

			  if (!isset($xTimes[$times])) {break;}



			  if ($times!=$lastTimes)

			  {

				  if ($rowCnt>=0) {echo "</td></tr>\n";}



				  $cls='s'.($rowCnt%2+1);

				  echo "  <tr class='$cls'>";

				  echo "<td style='text-align:center;font-weight:bold;' title='".$xTimes[$times]." player";

				  if ($xTimes[$times]!=1) {echo "s";}

				  echo "'>".$row['yrs']."</td>";

				  echo "<td class='".$cls."_l'>";

				  $rowCnt++;

				  $pcnt=0;

			  }



			  $pid=$row['player_id'];

			  if ($pcnt>0) {echo ", ";}

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo " title='Between ".$row['minYr']." and ".$row['maxYr']."'";

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

	

			  $lastTimes=$times;

			  $pcnt++;

		  }

		  echo "</td></tr>\n";

		  echo " </table>   <!-- close frequent player listing -->\n";

		  echo "</div>   <!-- close frequent player listing -->\n";

	  }



	  ## Standard Listing

	  # Get Team Names

	  $query="SELECT x.team_id,x.year,name,nickname,abbr FROM team_history as t,(SELECT pcs.year,pcs.team_id FROM players_awards as pa,players_career_".$table."_stats as pcs WHERE pa.player_id=pcs.player_id AND pa.league_id=$lgid AND pcs.league_id=$lgid AND pa.sub_league_id=$slid AND pa.season=pcs.year AND split_id=1 AND award_id=$view) as x WHERE t.team_id=x.team_id AND t.year=x.year";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  $yr=$row['year'];

			  $teams[$tid][$yr]['abbr']=$row['abbr'];

			  $teams[$tid][$yr]['name']=$row['name']." ".$row['nickname'];

		  }

	  }



	  # Get Player Stats

	  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,(x.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,x.* FROM players as p,(SELECT ";

	  switch ($page)

	  {

	  	case 4:

	  	case 'cusP':

	  		$query.="best_pitcher_id";

	  		break;

	  	case 5:

	  	case 'cusB':

	  		$query.="best_hitter_id";

	  		break;

	  }

	  $query.=" as player_id,pa.year,pcs.team_id";

	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}

 	  $query.=" FROM league_history as pa,players_career_".$table."_stats as pcs WHERE pa.";

	  switch ($page)

	  {

	  	case 4:

	  	case 'cusP':

	  		$query.="best_pitcher_id";

	  		break;

	  	case 5:

	  	case 'cusB':

	  		$query.="best_hitter_id";

	  		break;

	  }

 	  $query.="=pcs.player_id AND pa.league_id=$lgid AND pcs.league_id=$lgid AND pa.sub_league_id=$slid AND pa.year=pcs.year AND split_id=1 GROUP BY player_id,year) as x WHERE p.player_id=x.player_id ORDER BY year";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  echo "<div class='textbox' style='width:100%;'>   <!-- open stat listing -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open stat listing -->\n";

		  echo "  <tr class='title2'><td colspan=".(4+count($statArray)).">$awName Listing</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2_l'>Player</td><td class='hsc2_l'>Team</td><td class='hsc2'>Age</td>";

		  foreach ($statArray as $key => $statLbl) {echo "<td class='hsc2'>".stat_text($statLbl,2)."</td>";}

		  echo "</tr>\n";



		  $startYr=99999;

		  $endYr=0;



		  $rowCnt=0;

		  while ($row=mysqli_fetch_array($result))

		  {		  

			  $pid=$row['player_id'];

			  $tid=$row['team_id'];

			  $yr=$row['year'];

			  if ($yr<$startYr) {$startYr=$yr;}

			  if ($yr>$endYr) {$endYr=$yr;}



			  $winners[$tid]=$winners[$tid]+1;



			  $cls='s'.($rowCnt%2+1);

			  echo "  <tr class='$cls'>";

			  echo "<td class='".$cls."_l'>$yr</td>";

			  echo "<td class='".$cls."_l'>";

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

			  echo "</td>";

			  if (isset($teams[$tid][$yr]['abbr'])) {echo "<td class='".$cls."_l' title='".$teams[$tid][$yr]['name']."'><a href='./team_summary.php?year=$yr&team_id=$tid'>".$teams[$tid][$yr]['abbr']."</td>";}

			  else {echo "<td class='".$cls."_l' title='".$teams[$tid][$yr-1]['name']."'><a href='./team_summary.php?year=".($yr-1)."&team_id=$tid'>".$teams[$tid][$yr-1]['abbr']."</td>";}

			  echo "<td>".$row['age']."</td>";

			  foreach ($statArray as $key => $statLbl)

			  {

				  echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";

			  }

			  echo "</tr>\n";

	

			  $rowCnt++;

		  }

		  echo " </table>   <!-- close stat listing -->\n";

		  echo "</div>   <!-- close stat listing -->\n";

	  }



	  ### Prep Chart

	  # Get Team Colors

	  unset($teams);

	  $query="SELECT x.team_id,abbr,text_color_id,background_color_id FROM teams as t,(SELECT pcs.year,pcs.team_id FROM players_awards as pa,players_career_".$table."_stats as pcs WHERE pa.player_id=pcs.player_id AND pa.league_id=$lgid AND pcs.league_id=$lgid AND pa.sub_league_id=$slid AND pa.season=pcs.year AND split_id=1 AND award_id=$view) as x WHERE t.team_id=x.team_id GROUP BY team_id UNION SELECT team_id,abbr,text_color_id,background_color_id FROM teams WHERE league_id=$lgid AND sub_league_id=$slid AND allstar_team=0 ORDER BY team_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  $teams[$tid]['abbr']=$row['abbr'];

			  $teams[$tid]['text_color_id']=$row['text_color_id'];

			  $teams[$tid]['background_color_id']=$row['background_color_id'];

			  if (!isset($winners[$tid])) {$winners[$tid]=0;}

		  }

	  }



	  # Create Chart Container

	  echo "<div class='textbox' style='width:100%;'>   <!-- open graph -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open graph -->\n";

	  echo "  <tr class='title2'><td colspan=5>$awName Winners By Team</td></tr>\n";

	  echo "  <tr><td>\n";

	  echo "   <div id='chartwrapper' style='overflow:scroll;overflow:auto;max-width:930px;'>\n";

	  echo "    <div id='chartdiv' style='height:300px;width:".(100+35*count($teams))."px;margin-left:auto;margin-right:auto;'></div>";

	  echo "   </div>\n";

	  echo "  </td></tr>\n";

	  echo " </table>   <!-- close graph -->\n";

	  echo "</div>   <!-- close graph -->\n";



	  # Build Chart

	  echo "  <script class='code' type='text/javascript'>\n";

	  echo "   <!--\n";

	  echo "    $(document).ready(function(){\n";

	  $dCnt=0;

	  $dTxt="";

	  $tTxt="";

	  $scTxt="";

	  foreach ($teams as $tid => $val)

	  {

		  if ($dCnt>0)

		  {

			  $dTxt.=", ";

			  $tTxt.=", ";

			  $scTxt.=", ";

		  }

		  $dTxt.=$winners[$tid];

		  $tTxt.="'".$teams[$tid]['abbr']."'";

		  $scTxt.="'".$teams[$tid]['background_color_id']."'";

		  $dCnt++;

	  }

	  $nTeams=$dCnt;

	  echo "      var data  = [$dTxt];\n";

	  echo "      var ticks = [$tTxt];\n";

	  echo "      var plot1 = jQuery.jqplot ('chartdiv', [data], {\n";

	  echo "	  seriesDefaults: {\n";

	  echo "                 renderer: jQuery.jqplot.BarRenderer,\n";

	  echo "                 pointLabels: {show: true, location: 's'},\n";

	  echo "                 rendererOptions: {fillToZero: true, varyBarColor: true, barMargin:10}\n";

	  echo "                 },\n";

	  echo "          seriesColors:[$scTxt],\n";

	  echo "	  legend: {show: false},\n";

	  echo "          axes: {\n";

	  echo "                 xaxis: {\n";

	  echo "                       renderer:jQuery.jqplot.CategoryAxisRenderer,\n";

	  echo "                       ticks: ticks";

	  echo "                        },\n";

	  echo "                 yaxis: {\n";

	  echo "                       tickInterval: 1";

	  echo "                        }\n";

	  echo "                 }\n";

	  echo "       });\n";

	  echo "\n";

	  echo "      jQuery('.jqplot-point-label').css('font-weight','bold');\n";

	  $idx=0;

	  foreach ($teams as $tid => $val)

	  {

		  $lbl=$winners[$tid];

		  if ($lbl>0)

		  {

			  echo "      jQuery('.jqplot-point-$idx').css('font-size','".(0.75+($lbl-1)*.05)."em');\n";

			  echo "      jQuery('.jqplot-point-$idx').css('color','".$teams[$tid]['text_color_id']."');\n";

		  }

		  $idx++;

	  }

	  echo "    });\n";

	  echo "   -->\n";

	  echo "  </script>\n"; 

	  break;

  case 6:  //ROY

  case 'cusPB':

	  ## ROY By Team

  	  echo "<div class='textbox' style='width:100%;'>   <!-- open team listing -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open team listing -->\n";

	  echo "  <tr class='title2'><td colspan=3>$awName Winners by Team</td></tr>\n";

	  echo "  <tr class='headline'><td class='hsc2_l'>Team</td><td class='hsc2_l' style='text-align:center;' title='Times Won'>Times</td><td class='hsc2_l'>Players</td></tr>\n";



  	  # Get Team Player Appearances

	  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,x.team_id,year FROM players as p,(SELECT best_rookie_id as player_id,team_id,lh.year FROM league_history as lh,players_awards as pa WHERE best_rookie_id=pa.player_id AND lh.league_id=$lgid AND lh.sub_league_id=$slid AND award_id=$view) as x WHERE p.player_id=x.player_id ORDER BY team_id,year";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  $tid=$row['team_id'];

			  $yr=$row['year'];



			  if (isset($teamText[$tid]['display']))

			  {

				  if (($teamText[$tid]['totCnt']>0)&&($teamText[$tid]['totCnt']%5==0)) {$teamText[$tid]['display']=$teamText[$tid]['display']."<br/>";}

				  else {$teamText[$tid]['display']=$teamText[$tid]['display'].", ";}

			  }

			  $teamText[$tid]['display']=$teamText[$tid]['display']."<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {$teamText[$tid]['display']=$teamText[$tid]['display']." style='font-weight:bold;'";}

			  $teamText[$tid]['display']=$teamText[$tid]['display'].">".$row['first_name']." ".$row['last_name'];

			  $teamText[$tid]['display']=$teamText[$tid]['display']."</a>";

			  if ($row['retired']!=1) {$teamText[$tid]['display']=$teamText[$tid]['display']."<sup>+</sup>";}

			  $teamText[$tid]['display']=$teamText[$tid]['display']." ($yr)";

			  $teamText[$tid]['totCnt']=$teamText[$tid]['totCnt']+1;

		  }

	  }



	  # Get Teams

	  $query="SELECT t.team_id,name,nickname,abbr,COUNT(DISTINCT x.player_id) as players FROM teams as t LEFT JOIN (SELECT best_rookie_id as player_id,team_id,lh.year FROM league_history as lh,players_awards as pa WHERE best_rookie_id=pa.player_id AND lh.league_id=$lgid AND lh.sub_league_id=$slid AND award_id=$view) as x ON t.team_id=x.team_id WHERE t.league_id=$lgid AND t.sub_league_id=$slid AND allstar_team=0 GROUP BY team_id ORDER BY players DESC,team_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  $rowCnt=0;

		  $tidList="";

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  $tidList.=",".$tid;



			  $cls='s'.($rowCnt%2+1);

			  echo "  <tr class='$cls' style='vertical-align:top;'>";

			  echo "<td class='".$cls."_l'><a href='./team_overview.php?league_id=$lgid&team_id=$tid'>".$row['name']." ".$row['nickname']."</a></td>";

			  echo "<td style='text-align:center;'>".$row['players']."</td>";



			  echo "<td class='".$cls."_l'>";

			  if ($row['players']==0) {echo " - No winners -";}

			  else {echo $teamText[$tid]['display'];}

			  echo "</td></tr>\n";



			  $rowCnt++;

		  }

		  $tidList=trim($tidList,",");

	  }

	  echo " </table>   <!-- close team listing -->\n";

	  echo "</div>   <!-- close team listing -->\n";



	  ## Get ROY Statistics

	  unset($winners);

	  # Batter Stats

	  $bStatArray=Array('g','ab','h','d','t','hr','rbi','r','bb','sb','cs','avg','obp','slg','ops','war');

	  $bStatArray=Array('hr','rbi','sb','avg','obp','slg','ops','war');

	  $awQuery="SELECT best_rookie_id as player_id,pa.year";

	  foreach ($bStatArray as $key => $statLbl) {$awQuery.=",".stat_query($statLbl)." as $statLbl";}

	  $awQuery.=" FROM players_career_batting_stats as pcs,league_history as pa WHERE best_rookie_id=pcs.player_id AND pa.year=pcs.year AND pcs.league_id=$lgid AND pa.league_id=$lgid AND pa.sub_league_id=$slid AND split_id=1 GROUP BY pcs.player_id";

	  $query="SELECT first_name,last_name,retired,hall_of_fame,(x.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,x.* FROM players as p,($awQuery) as x WHERE p.player_id=x.player_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $yr=$row['year'];

			  $pid=$row['player_id'];



			  $winners[$yr]=$pid;



			  $players[$pid]['name']=$row['first_name']." ".$row['last_name'];

			  $players[$pid]['sortname']=$row['last_name'].", ".$row['first_name'];

			  $players[$pid]['nameshort']=$row['first_name'][0].". ".$row['last_name'];

			  $players[$pid]['retired']=$row['retired'];

			  $players[$pid]['hall_of_fame']=$row['hall_of_fame'];

			  $players[$pid]['age']=$row['age'];

			  foreach ($bStatArray as $key => $statLbl) {$players[$pid][$statLbl]=$row[$statLbl];}

		  }

	  }



	  # Pitcher Stats

	  $pStatArray=Array('pg','gs','w','l','s','era','ip','hra','pbb','pk','hld','cg','sho','whip','pwar');

	  $pStatArray=Array('w','l','s','era','ip','pk','whip','pwar');

	  $awQuery="SELECT best_rookie_id as player_id,pa.year";

	  foreach ($pStatArray as $key => $statLbl) {$awQuery.=",".stat_query($statLbl)." as $statLbl";}

	  $awQuery.=" FROM players_career_pitching_stats as pcs,league_history as pa WHERE best_rookie_id=pcs.player_id AND pa.year=pcs.year AND pcs.league_id=$lgid AND pa.league_id=$lgid AND pa.sub_league_id=$slid AND split_id=1 GROUP BY pcs.player_id";

	  $query="SELECT first_name,last_name,retired,hall_of_fame,(x.year-YEAR(date_of_birth)-(RIGHT(date_of_birth,5)>'07-01')) as age,x.* FROM players as p,($awQuery) as x WHERE p.player_id=x.player_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $yr=$row['year'];

			  $pid=$row['player_id'];



			  $winners[$yr]=$pid;



			  $players[$pid]['name']=$row['first_name']." ".$row['last_name'];

			  $players[$pid]['sortname']=$row['last_name'].", ".$row['first_name'];

			  $players[$pid]['nameshort']=$row['first_name'][0].". ".$row['last_name'];

			  $players[$pid]['ret']=$row['retired'];

			  $players[$pid]['hof']=$row['hall_of_fame'];

			  $players[$pid]['age']=$row['age'];

			  foreach ($pStatArray as $key => $statLbl) {$players[$pid][$statLbl]=$row[$statLbl];}

		  }

	  }



	  # Display

	  if (isset($winners))

	  { 

		  echo "<div class='textbox' style='padding:0;width:100%;'>   <!-- open stats table -->\n";

		  echo " <table border=0 cellpadding=0 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open stats table -->\n";

		  echo "  <tr class='title2'><td style='padding:4px;'>$awName Statistics</td></tr>\n";

		  echo "  <tr><td>";

		  echo "   <table border=0 cellpadding=2 cellspacing=0 class='sortable' width='100%'>\n";

		  echo "    <tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2_l'>Player</td><td class='hsc2'>Age</td>";

		  foreach ($bStatArray as $key => $statLbl) {echo "<td class='hsc2'>".stat_text($statLbl,2)."</td>";}

		  foreach ($pStatArray as $key => $statLbl) {echo "<td class='hsc2'>".stat_text($statLbl,2)."</td>";}

		  echo "</tr>\n";



		  ksort($winners);

		  $rowCnt=0;

		  foreach ($winners as $yr => $pid)

		  {

			  $cls='s'.($rowCnt%2+1);

			  echo "    <tr class='$cls'>";

			  echo "<td class='".$cls."_l'>$yr</td>";

			  echo "<td class='".$cls."_l' sorttable_customkey=\"".$players[$pid]['sortname']."\">";

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($players[$pid]['hof']==1) {echo " style='font-weight:bold;'";}

			  echo ">".$players[$pid]['name']."</a>";

			  if ($players[$pid]['ret']!=1) {echo "<sup>+</sup>";}

			  echo "</td>";

			  echo "<td>".$players[$pid]['age']."</td>";

			  foreach ($bStatArray as $key => $statLbl)

			  {

				  if (isset($players[$pid][$statLbl])) {echo "<td>".stat_format($statLbl,$players[$pid][$statLbl])."</td>";}

				  else  {echo "<td>&nbsp;</td>";}

			  }

			  foreach ($pStatArray as $key => $statLbl)

			  {

				  if (isset($players[$pid][$statLbl])) {echo "<td>".stat_format($statLbl,$players[$pid][$statLbl])."</td>";}

				  else  {echo "<td>&nbsp;</td>";}

			  }

			  echo "</tr>\n";

			  $rowCnt++;

		  }

		  echo "   </table>\n";

		  echo "  </td></tr>\n";

		  echo " </table>   <!-- close stats table -->\n";

		  echo "</div>   <!-- close stats table -->\n";

	  }



	  break;

  case 7:  //GG

	  ## Most Times Won

	  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,COUNT(year) as yrs,MIN(year) as minYr,MAX(year) as maxYr FROM players as p,(SELECT player_id,year FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=7) as x WHERE p.player_id=x.player_id GROUP BY p.player_id HAVING COUNT(year)>=2 ORDER BY yrs DESC,minYr,maxYr,last_name,first_name";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $rowCnt=-1;

	  if (mysqli_num_rows($result))

	  {

		  $cntQuery="SELECT yrs,COUNT(DISTINCT player_id) as players FROM ($query) as y GROUP BY yrs";

		  if ($_GET['showq']==1) {echo "$cntQuery<br/>\n";}

		  $cntResult=mysqli_query($db,$cntQuery);

		  while ($row=mysqli_fetch_array($cntResult))

		  {

			  $times=$row['yrs'];

			  if ($row['players']<=20) {$xTimes[$times]=$row['players'];}			  

		  }



		  echo "<div class='textbox' style='width:100%;'>   <!-- open frequent player listing -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open frequent player listing -->\n";

		  echo "  <tr class='title2'><td colspan=2>Most Frequent $awName Winners</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2' style='text-align:center;' title='Times Won'>Times</td><td class='hsc2_l'>Players</td></tr>\n";



		  $lastTimes=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $times=$row['yrs'];

			  if (!isset($xTimes[$times])) {break;}



			  if ($times!=$lastTimes)

			  {

				  if ($rowCnt>=0) {echo "</td></tr>\n";}



				  $cls='s'.($rowCnt%2+1);

				  echo "  <tr class='$cls'>";

				  echo "<td style='text-align:center;font-weight:bold;' title='".$xTimes[$times]." player";

				  if ($xTimes[$times]!=1) {echo "s";}

				  echo "'>".$row['yrs']."</td>";

				  echo "<td class='".$cls."_l'>";

				  $rowCnt++;

				  $pcnt=0;

			  }



			  $pid=$row['player_id'];

			  if ($pcnt>0) {echo ", ";}

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo " title='Between ".$row['minYr']." and ".$row['maxYr']."'";

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

	

			  $lastTimes=$times;

			  $pcnt++;

		  }

		  echo "</td></tr>\n";

		  echo " </table>   <!-- close frequent player listing -->\n";

		  echo "</div>   <!-- close frequent player listing -->\n";

	  }



	  ## Determine Voting Critera for Outfielders

	  $query="SELECT value FROM ootp_sql_admin WHERE scope=$lgid AND module='Awards' AND setting='splitOF'";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $row=mysqli_fetch_array($result);

	  $splitOF=$row['value'];



	  ## Most Different Positions

	  unset($xTimes);

	  $query="SELECT first_name,last_name,retired,hall_of_fame,x.player_id,COUNT(DISTINCT x.position) as posCnt,COUNT(DISTINCT year) as yrs FROM players as p,(SELECT player_id,year,";

	  if ($splitOF==1) {$query.="position";}

	  else {$query.="if((position=7) OR (position=8) OR (position=9),20,position) as position";}

	  $query.=" FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=$view) as x WHERE p.player_id=x.player_id GROUP BY x.player_id HAVING COUNT(DISTINCT x.position)>1 ORDER BY posCnt DESC,last_name,first_name";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  $cntQuery="SELECT posCnt,COUNT(DISTINCT player_id) as players FROM ($query) as y GROUP BY posCnt";

		  if ($_GET['showq']==1) {echo "$cntQuery<br/>\n";}

		  $cntResult=mysqli_query($db,$cntQuery);

		  while ($row=mysqli_fetch_array($cntResult))

		  {

			  $times=$row['posCnt'];

			  if ($row['players']<=20) {$xTimes[$times]=$row['players'];}			  

		  }



		  echo "<div class='textbox' style='width:100%;'>   <!-- open multiple position listing -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open multiple position listing -->\n";

		  echo "  <tr class='title2'><td colspan=2>Winners At Multiple Positions</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2' style='text-align:center;' title='Positions Won'>Positions</td><td class='hsc2_l'>Players</td></tr>\n";



		  $lastTimes=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $times=$row['posCnt'];

			  if (!isset($xTimes[$times])) {break;}



			  if ($times!=$lastTimes)

			  {

				  if ($rowCnt>=0) {echo "</td></tr>\n";}



				  $cls='s'.($rowCnt%2+1);

				  echo "  <tr class='$cls'>";

				  echo "<td style='text-align:center;font-weight:bold;' title='".$xTimes[$times]." player";

				  if ($xTimes[$times]!=1) {echo "s";}

				  echo "'>".$row['posCnt']."</td>";

				  echo "<td class='".$cls."_l'>";

				  $rowCnt++;

				  $pcnt=0;

			  }



			  $pid=$row['player_id'];



			  $pQuery="SELECT DISTINCT position as position FROM (SELECT ";

			  if ($splitOF==1) {$pQuery.="position";}

			  else {$pQuery.="if((position=7) OR (position=8) OR (position=9),20,position) as position";}

			  $pQuery.=" FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=$view AND player_id=$pid) as x ORDER BY position";

			  if ($_GET['showq']==1) {echo "$pQuery<br/>\n";}

			  $pResult=mysqli_query($db,$pQuery);

			  $posList="";

			  while ($pRow=mysqli_fetch_array($pResult))

			  {

				  if ($posList!="") {$posList.=", ";}

				  $pos=$pRow['position'];

				  $posList.=get_pos($pos,1);

			  }



			  if ($pcnt>0) {echo ", ";}

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo " title='".$row['yrs']." times won'";

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

			  echo " ($posList)";

	

			  $lastTimes=$times;

			  $pcnt++;

		  }

		  echo "</td></tr>\n";

		  echo " </table>   <!-- close multiple position listing -->\n";

		  echo "</div>   <!-- close multiple position listing -->\n";

	  }



	  ## Gold Gloves By Team

  	  echo "<div class='textbox' style='width:100%;'>   <!-- open team listing -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open team listing -->\n";

	  echo "  <tr class='title2'><td colspan=3>Most $awName Winners by Team</td></tr>\n";

	  echo "  <tr class='headline'><td class='hsc2_l'>Team</td><td class='hsc2_l' title='Number of times winning $awName'>App.</td><td class='hsc2_l'>Most Frequent Players</td></tr>\n";



  	  # Get Team Player Appearances

	  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,x.team_id,COUNT(year) as yrs,MIN(year) as minYr,MAX(year) as maxYr FROM players as p,(SELECT player_id,team_id,year FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=7) as x WHERE p.player_id=x.player_id GROUP BY x.player_id,x.team_id HAVING COUNT(year)>1 ORDER BY team_id,yrs DESC,minYr,maxYr";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  $tid=$row['team_id'];

			  $yrs=$row['yrs'];



			  if (max(0,$teams[$tid]['totCnt'])<5)

			  {

				  if (isset($teamText[$tid]['display'])) {$teamText[$tid]['display']=$teamText[$tid]['display'].", ";}

				  $teamText[$tid]['display']=$teamText[$tid]['display']."<a href='./player.php?player_id=$pid'";

				  if ($row['hall_of_fame']==1) {$teamText[$tid]['display']=$teamText[$tid]['display']." style='font-weight:bold;'";}

				  $teamText[$tid]['display']=$teamText[$tid]['display'].">".$row['first_name']." ".$row['last_name'];

				  $teamText[$tid]['display']=$teamText[$tid]['display']."</a>";

				  if ($row['retired']!=1) {$teamText[$tid]['display']=$teamText[$tid]['display']."<sup>+</sup>";}

				  $teamText[$tid]['display']=$teamText[$tid]['display']." ($yrs)";

			  }

			  $teams[$tid]['totCnt']=$teams[$tid]['totCnt']+1;

		  }

	  }



	  # Get Teams

	  $query="SELECT t.team_id,name,nickname,abbr,COUNT(x.player_id) as apps,COUNT(DISTINCT x.player_id) as players FROM teams as t LEFT JOIN (SELECT player_id,team_id,year FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=7) as x ON t.team_id=x.team_id WHERE t.league_id=$lgid AND t.sub_league_id=$slid AND allstar_team=0 GROUP BY team_id ORDER BY apps DESC,players,team_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  $rowCnt=0;

		  $tidList="";

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  $tidList.=",".$tid;



			  $cls='s'.($rowCnt%2+1);

			  echo "  <tr class='$cls'>";

			  echo "<td class='".$cls."_l'><a href='./team_overview.php?league_id=$lgid&team_id=$tid'>".$row['name']." ".$row['nickname']."</a></td>";

			  echo "<td style='text-align:center;' title='".$row['players']." unique players'>".$row['apps']."</td>";



			  echo "<td class='".$cls."_l'>";

			  if ($row['apps']==0) {echo " - No winners -";}

			  elseif ($teamText[$tid]['display']=="") {echo " - No repeat winners -";}

			  else {echo $teamText[$tid]['display'];}

			  echo "</td></tr>\n";



			  $rowCnt++;

		  }

		  $tidList=trim($tidList,",");

	  }

	  echo " </table>   <!-- close team listing -->\n";

	  echo "</div>   <!-- close team listing -->\n";	  



	  ## Winners Table

	  unset($rowCnt);

	  $query="SELECT first_name,last_name,retired,hall_of_fame,x.* FROM players as p,(SELECT player_id,position,year,team_id FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=$view) as x WHERE p.player_id=x.player_id ORDER BY year,position";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  $startYr=99999;

		  $endYr=0;



		  # Get Winners

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pos=$row['position'];

			  $pid=$row['player_id'];

			  $tid=$row['team_id'];

			  $yr=$row['year'];

			  if ($yr<$startYr) {$startYr=$yr;}

			  if ($yr>$endYr) {$endYr=$yr;}



			  $players[$pid]['name']=$row['first_name']." ".$row['last_name'];

			  $players[$pid]['sortname']=$row['last_name'].", ".$row['first_name'];

			  $players[$pid]['nameshort']=$row['first_name'][0].". ".$row['last_name'];

			  $players[$pid]['ret']=$row['retired'];

			  $players[$pid]['hof']=$row['hall_of_fame'];

			  $players[$pid][$yr]['tid']=$row['team_id'];

			  $players[$pid]['cnt']=$players[$pid]['cnt']+1;



			  $winners[$yr][$pos]['pid']=$pid;

			  if (($splitOF!=1)&&($pos>=7)) {$pos=20;}

			  $winnersByPos[$pos][$pid]=$winnersByPos[$pos][$pid]+1;

			  $players[$pid]['positions'][$pos]['cnt']=$players[$pid]['positions'][$pos]['cnt']+1;



			  $goldgloves[$tid][$yr]['cnt']=$goldgloves[$tid][$yr]['cnt']+1;

			  $ggYrTots[$yr]=$ggYrTots[$yr]+1;

		  }



		  # Reorder Outfield Slots if Outfielders Combined

		  if ($splitOF!=1)

		  {

			  foreach ($winners as $yr => $val)

			  {

				  for ($j=7;$j<=9;$j++)

				  {

		

					  for ($pos=7;$pos<=9;$pos++)

					  {

						  $pid=$winners[$yr][$pos]['pid'];

						  $slot[$pos]=$pid;

						  $tmpSlot=$lastSlot[$pid][$yr-1];



						  if (($tmpSlot!=$pos)&&(isset($lastSlot[$pid][$yr-1])))

						  {

							  $tmpPid=$winners[$yr][$tmpSlot]['pid'];

							  $winners[$yr][$tmpSlot]['pid']=$pid;

							  if ($tmpPid>0) {$winners[$yr][$pos]['pid']=$tmpPid;}

						  }



						  $lastSlot[$pid][$yr]=$pos;

					  }

				  }

			  }

		  }



		  # Display Winners

		  echo "<div class='textbox' style='width:100%;'>   <!-- open winner table -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open winner table -->\n";

		  echo "  <tr class='title2'><td colspan=10>$awName Winners Table</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2_l' style='border-right:1px solid black;'>Year</td><td class='hsc2_l'>P</td><td class='hsc2_l' style='border-right:1px solid black;'>C</td><td class='hsc2_l'>1B</td><td class='hsc2_l'>2B</td><td class='hsc2_l'>3B</td><td class='hsc2_l' style='border-right:1px solid black;'>SS</td>";

		  if ($splitOF==1)

		  {

			  echo "<td class='hsc2_l'>LF</td><td class='hsc2_l'>CF</td><td class='hsc2_l'>RF</td>";

		  }

		  else

		  {

			  echo "<td class='hsc2_l' colspan=3>OF</td>";

		  }

		  echo "</tr>\n";

		  $rowCnt[0]=0;

		  foreach ($winners as $yr => $val)

		  {

			  $cls='s'.($rowCnt[0]%2+1)."_l";

			  echo "  <tr class='$cls'><td style='border-right:1px solid black;'>$yr</td>";

			  $pos=0;

			  ksort($winners[$yr]);

			  reset($winners[$yr]);

			  $firstPos = key($winners[$yr]);

			  if ($firstPos>1)

			  {

				  for ($pos=1;$pos<$firstPos;$pos++)

				  {

					  echo "<td";

					  if (($pos==2)||($pos==6)) {echo " style='border-right:1px solid black;'";}

					  echo ">&nbsp;</td>";

				  }

			  }

			  $lastPos=$pos;

			  foreach ($winners[$yr] as $pos => $val2)

			  {

				  $pid=$winners[$yr][$pos]['pid'];

				  if ($pid=="")

				  {

					  unset($winners[$yr][$pos]);

					  continue;

				  }

	

				  if ($lastPos<($pos-1))

				  {

		  			  for ($i=$lastPos+1;$i<$pos;$i++)

					  {

						  echo "<td";

						  if (($i==2)||($i==6)) {echo " style='border-right:1px solid black;'";}

						  echo ">&nbsp;</td>";

					  }



				  }



				  if (!isset($rowCnt[$pos])) {$rowCnt[$pos]=$rowCnt[0];}

				  elseif ($pid!=$lastPID[$pos]) {$rowCnt[$pos]++;}

		

				  $cls='s'.($rowCnt[$pos]%2+1)."_l";



				  echo "<td class='$cls'";

				  if (($pos==2)||($pos==6)) {echo " style='border-right:1px solid black;'";}

				  echo ">";

				  echo "<a href='./player.php?player_id=$pid'";

				  if ($players[$pid]['hof']==1) {echo " style='font-weight:bold;'";}

				  echo " title=\"".$players[$pid]['name']."\">".$players[$pid]['nameshort']."</a>";

				  if ($players[$pid]['ret']!=1) {echo "<sup>+</sup>";}

				  echo "</td>";



				  $lastPID[$pos]=$pid;

				  $lastPos=$pos;

			  }

			  for ($pos=$lastPos+1;$pos<=9;$pos++)

			  {

					  echo "<td";

					  if (($pos==2)||($pos==6)) {echo " style='border-right:1px solid black;'";}

					  echo ">&nbsp;</td>";

			  }

			  echo "</tr>\n";

			  $rowCnt[0]++;

		  }

		  echo "  <tr class='headline'>";

		  echo "<td class='hsc2_l' style='border-right:1px solid black;'>".count($winners)." years</td>";

		  for ($pos=1;$pos<=9;$pos++)

		  {

			  echo "<td class='hsc2_l'";

			  if (($pos==2)||($pos==6)) {echo " style='border-right:1px solid black;'";}

			  if (($splitOF!=1)&&($pos>=7))

			  {

				  echo " colspan=3";

				  $pos=20;

			  }

			  echo ">".count($winnersByPos[$pos])." players</td>";

		  }

		  echo "</tr>\n";

		  echo "  <tr style='vertical-align:top;'>";

		  echo "<td style='text-align:left;font-weight:bold;border-right:1px solid black;'>Most Common</td>";

		  for ($pos=1;$pos<=9;$pos++)

		  {

			  $maxCnt=0;

			  echo "<td style='text-align:left;font-weight:bold;";

			  if (($pos==2)||($pos==6)) {echo "border-right:1px solid black;";}

			  echo "'";

			  if (($splitOF!=1)&&($pos>=7))

			  {

				  $pos=20;

				  $ofCnt=1;

			  }

			  echo ">";

			  arsort($winnersByPos[$pos]);

			  foreach ($winnersByPos[$pos] as $pid => $cnt)

			  {

				  if (($splitOF!=1)&&($pos>=7)&&($lastCnt>$cnt)&&($maxCnt>0)&&($ofCnt<3)&&($cnt>1))

				  {

					  $maxCnt=0;

					  echo "</td><td style='text-align:left;font-weight:bold;'>";

					  $ofCnt=$ofCnt+1;

				  }



				  if ($maxCnt==0)

				  {

					  $maxCnt=$cnt;

					  echo "$maxCnt Time".($maxCnt>1?'s':'')."<br/>";

				  }

				  elseif ($cnt<$maxCnt) {break;}

				  else {echo "<br/>";}



				  echo "<a href='./player.php?player_id=$pid'";

				  if ($players[$pid]['hof']==1) {echo " style='font-weight:bold;'";}

				  echo " title=\"".$players[$pid]['name']."\">".$players[$pid]['nameshort']."</a>";

				  if ($players[$pid]['ret']!=1) {echo "<sup>+</sup>";}



				  $lastCnt=$cnt;

			  }

			  echo "</td>";

		  }

		  echo "</tr>\n";



		  echo " </table>   <!-- close winner table -->\n";

		  echo "</div>   <!-- close winner table -->\n";

	

		  ## Create Chart Container

		  $maxP=0;

		  for ($yr=$startYr;$yr<=$endYr;$yr++)

		  {

			  if ($maxP<$ggYrTots[$yr]) {$maxP=$ggYrTots[$yr];}

		  }

		  echo "<div class='textbox' style='width:100%;'>   <!-- open graph -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open graph -->\n";

		  echo "  <tr class='title2'><td colspan=5>Annual Distribution By Team</td></tr>\n";

		  echo "  <tr><td>\n";

		  echo "   <div id='chartwrapper' style='overflow:scroll;overflow:auto;max-width:930px;'>\n";

		  echo "    <div id='chartdiv' style='height:".(100+20*$maxP)."px;width:".(30*($endYr-$startYr+1)+200)."px;margin-left:auto;margin-right:auto;'></div>";

		  echo "   </div>\n";

		  echo "  </td></tr>\n";

		  echo " </table>   <!-- close graph -->\n";

		  echo "</div>   <!-- close graph -->\n";

	  

		  ## Build Chart

		  if ($tidList=="") {break;}

		  $query="SELECT team_id,abbr,text_color_id,background_color_id FROM teams WHERE team_id IN ($tidList)";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  	  $result=mysqli_query($db,$query);

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  $teams[$tid]['abbr']=$row['abbr'];

			  $teams[$tid]['text_color_id']=$row['text_color_id'];

			  $teams[$tid]['background_color_id']=$row['background_color_id'];

			  $fndList[$tid]=1;

		  }

		  krsort($goldgloves);

		  echo "  <script class='code' type='text/javascript'>\n";

		  echo "   <!--\n";

		  echo "    $(document).ready(function(){\n";

		  $dCnt=0;

		  foreach ($goldgloves as $tid => $val)

		  {

			  if (!isset($fndList[$tid]))

			  {

				  unset($goldgloves[$tid]);

				  continue;

			  }

	

			  if ($dCnt>0) {$dataArray.=", ";}

			  $dataArray=$dataArray.$teams[$tid]['abbr']."Data";



			  ksort($goldgloves[$tid]);

			  echo "      var ".$teams[$tid]['abbr']."Data = [";

			  for ($yr=$startYr;$yr<=$endYr;$yr++)

			  {

				  if ($yr>$startYr) {echo ", ";}

				  echo max(0,$goldgloves[$tid][$yr]['cnt']);

			  }

			  echo "];\n";

			  $dCnt++;

		  }

		  $nTeams=$dCnt;

		  echo "      var ticks = [";

		  for ($yr=$startYr;$yr<=$endYr;$yr++)

		  {

			  if ($yr>$startYr) {echo ", ";}

			  echo "\"'".substr($yr,2,2)."\"";

		  }

		  echo "];\n";

		  echo "      var plot1 = jQuery.jqplot ('chartdiv', [$dataArray], {\n";

		  echo "          stackSeries: true,\n";

		  //echo "       title:'Annual Distribution By Team',\n";

		  echo "	  seriesDefaults: {\n";

		  echo "                 renderer: jQuery.jqplot.BarRenderer,\n";

		  echo "                 rendererOptions: {highlightMouseDown: true},\n";

		  echo "                 pointLabels: {show: true, stackedValue: false, location: 's', ypadding:3, formatString: '%#.0f'}\n";

		  echo "                 },\n";

		  echo "	  legend: {\n";

		  if ($nTeams>10)

		  {

			  echo "                 renderer: jQuery.jqplot.EnhancedLegendRenderer,\n";

			  echo "                 rendererOptions: {\n";

			  echo "                     numberColumns: ".(floor($nTeams/10)+1)."\n";

			  echo "                     },\n";

		  }

		  echo "                 show: true,\n";

		  echo "                 location: 'w',\n";

		  echo "                 placement: 'outsideGrid'\n";

		  echo "                 },\n";

		  /*

		  echo "          highlighter: {\n";

		  echo "                 show: true\n";

		  echo "                 },\n";

		   */

		  echo "          axes: {\n";

		  echo "                 xaxis: {renderer: jQuery.jqplot.CategoryAxisRenderer, ticks: ticks},\n";

		  echo "                 yaxis: {padMin: 0, min: 0, max: ".(5*floor($maxP/5)+5).", tickInterval: 1}\n";

		  echo "                 },\n";

		  echo "          series:[\n";

		  $dCnt=0;

		  foreach ($goldgloves as $tid => $val)

		  {

			  if ($dCnt>0) {echo ",\n";}

			  echo "                 {";

			  echo "label:'".$teams[$tid]['abbr']."',";

			  echo "pointLabels:{labels:[";

			  for ($yr=$startYr;$yr<=$endYr;$yr++)

			  {

				  if ($yr>$startYr) {echo ", ";}

				  $lbl=max(0,$goldgloves[$tid][$yr]['cnt']);

				  if ($lbl==0) {echo "''";} else {echo $lbl;}

			  }

			  echo "]}";

			  echo "}";

			  $dCnt++;

		  }

		  echo "\n";

		  echo "                 ],\n";

		  echo "          seriesColors:[";

		  $dCnt=0;

		  foreach ($goldgloves as $tid => $val)

		  {

			  if ($dCnt>0) {echo ",";}

			  echo "'".$teams[$tid]['background_color_id']."'";

			  $dCnt++;

		  }

		  echo "]\n";

		  echo "       });\n";

		  echo "\n";

		  $dCnt=0;

		  echo "      jQuery('.jqplot-point-label').css('font-weight','bold');\n";

		  foreach ($goldgloves as $tid => $val)

		  {

			  echo "      var element;\n";

			  echo "      jQuery('.jqplot-series-$dCnt').css('color','".$teams[$tid]['text_color_id']."');\n";

	

			  $pCnt=0;

			  for ($yr=$startYr;$yr<=$endYr;$yr++)

			  {

				  $lbl=max(0,$goldgloves[$tid][$yr]['cnt']);

				  if ($lbl>0)

				  {

					  echo "      jQuery('.jqplot-point-label.jqplot-series-$dCnt.jqplot-point-$pCnt').css('font-size','".(0.75+($lbl-1)*.10)."em');\n";

					  echo "      if (jQuery('.jqplot-point-label.jqplot-series-$dCnt.jqplot-point-$pCnt').length) {\n";

					  echo "          jQuery('.jqplot-point-label.jqplot-series-$dCnt.jqplot-point-$pCnt').css('top',";

					  echo "jQuery('.jqplot-point-label.jqplot-series-$dCnt.jqplot-point-$pCnt').position().top + ".(3+11*($lbl-1));

					  echo " + 'px');\n";

					  echo "      }\n";

				  }

				  $pCnt++;

			  }

	

			  $dCnt++;

		  }



		  echo "      $(\"#chartdiv\").bind('jqplotDataHighlight', function(ev, seriesIndex, pointIndex, data) {\n";

		  echo "	  var $"."this = $(this);\n";

		  echo "	  $"."this.attr('title', data[0] + \": \" + data[1]);\n";

		  echo "      });\n";

		  echo "      $(\"#chartdiv\").bind('jqplotDataUnhighlight', function(ev, seriesIndex, pointIndex, data) {\n";

		  echo "	  var $"."this = $(this);\n";

		  echo "	  $"."this.attr('title',\"\");\n";

		  echo "      });\n";

	

		  echo "    });\n";

		  echo "   -->\n";

		  echo "  </script>\n"; 

	  }

	  unset($rowCnt);



	  ## Position by Position Stats

	  $statArray=Array("g","po","a","dp","tp","tc","e","fpct","inn","rng","pb","sba","rto","rtoPct");

	  $cStatArray=Array("pb","sba","rto","rtoPct");

	  $query="SELECT pa.player_id,pa.year,pa.position";

	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}

	  $query.=" FROM players_career_fielding_stats as pcs,players_awards as pa WHERE pcs.player_id=pa.player_id AND pcs.year=pa.season AND pcs.position=pa.position AND pcs.league_id=$lgid AND pa.league_id=$lgid AND sub_league_id=$slid AND award_id=$view";

	  if ($splitOF!=1) {$query.=" AND pcs.position<=6";}

	  $query.=" GROUP BY pcs.player_id,pcs.year,pcs.position";

	  if ($splitOF!=1)

	  {

		  $query.=" UNION ";

		  $query.="SELECT pa.player_id,pa.year,20 as position";

		  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}

		  $query.=" FROM players_career_fielding_stats as pcs,players_awards as pa WHERE pcs.player_id=pa.player_id AND pcs.year=pa.season AND pcs.league_id=$lgid AND pa.league_id=$lgid AND sub_league_id=$slid AND award_id=$view AND pa.position IN (7,8,9) AND pcs.position IN (7,8,9)";

		  $query.=" GROUP BY pcs.player_id,pcs.year";

	  }

	  $query.=" ORDER BY position,year,inn DESC";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  $lastPos=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pos=$row['position'];



			  if ($lastPos!=$pos)

			  {

				  if ($lastPos>0)

				  {

					  echo "   </table>\n";

					  echo "  </td></tr>\n";

					  echo " </table>   <!-- close ".get_pos($lastPos)." table -->\n";

					  echo "</div>   <!-- close ".get_pos($lastPos)." table -->\n";

				  }



				  $rowCnt=0;

				  echo "<div class='textbox' style='padding:0;width:100%;'>   <!-- open ".get_pos($pos)." table -->\n";

				  echo " <table border=0 cellpadding=0 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open ".get_pos($pos)." table -->\n";

				  echo "  <tr class='title2'><td style='padding:4px;'>".get_pos($pos)." Statistics</td></tr>\n";

				  echo "  <tr><td>";

				  echo "   <table border=0 cellpadding=2 cellspacing=0 class='sortable' width='100%'>\n";

				  echo "    <tr class='headline'><td class='hsc2_l' style='width:50px;'>Year</td><td class='hsc2_l' style='width:150px;'>Player</td>";

				  foreach ($statArray as $key => $statLbl)

				  {

					  if (($pos!=2)&&(in_array($statLbl,$cStatArray))) {continue;}

					  echo "<td class='hsc2'>".stat_text($statLbl,2)."</td>";

				  }

				  echo "</tr>\n";



			  }

			  

			  $pid=$row['player_id'];

			  $yr=$row['year'];



			  $cls='s'.($rowCnt%2+1);

			  echo "    <tr class='$cls'>";

			  echo "<td class='".$cls."_l'>$yr</td>";

			  echo "<td class='".$cls."_l' sorttable_customkey=\"".$players[$pid]['sortname']."\">";

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($players[$pid]['hof']==1) {echo " style='font-weight:bold;'";}

			  echo ">".$players[$pid]['name']."</a>";

			  if ($players[$pid]['ret']!=1) {echo "<sup>+</sup>";}

			  echo "</td>";

			  foreach ($statArray as $key => $statLbl)

			  {

				  if (($pos!=2)&&(in_array($statLbl,$cStatArray))) {continue;}

				  echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";

			  }

			  echo "</tr>\n";

			  $lastPos=$pos;

			  $rowCnt++;

		  }

		  echo "   </table>\n";

		  echo "  </td></tr>\n";

		  echo " </table>   <!-- close ".get_pos($lastPos)." table -->\n";

		  echo "</div>   <!-- close ".get_pos($lastPos)." table -->\n";

	  }

	  break;

  case 9:  //AS

	  ## Most Frequent All-Stars

	  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,COUNT(year) as yrs,MIN(year) as minYr,MAX(year) as maxYr FROM players as p,(SELECT player_id,year FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=9) as x WHERE p.player_id=x.player_id GROUP BY p.player_id HAVING COUNT(year)>=2 ORDER BY yrs DESC,minYr,maxYr,last_name,first_name";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  $rowCnt=-1;

	  if (mysqli_num_rows($result))

	  {

		  $cntQuery="SELECT yrs,COUNT(DISTINCT player_id) as players FROM ($query) as y GROUP BY yrs";

		  if ($_GET['showq']==1) {echo "$cntQuery<br/>\n";}

		  $cntResult=mysqli_query($db,$cntQuery);

		  while ($row=mysqli_fetch_array($cntResult))

		  {

			  $times=$row['yrs'];

			  if ($row['players']<=20) {$xTimes[$times]=$row['players'];}			  

		  }



		  echo "<div class='textbox' style='width:100%;'>   <!-- open frequent player listing -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open frequent player listing -->\n";

		  echo "  <tr class='title2'><td colspan=2>Most Frequent All-Stars</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2' title='Times On All-Star Roster'>App.</td><td class='hsc2_l'>Players</td></tr>\n";



		  $lastTimes=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $times=$row['yrs'];

			  if (!isset($xTimes[$times])) {break;}



			  if ($times!=$lastTimes)

			  {

				  if ($rowCnt>=0) {echo "</td></tr>\n";}



				  $cls='s'.($rowCnt%2+1);

				  echo "  <tr class='$cls'>";

				  echo "<td style='text-align:center;font-weight:bold;' title='".$xTimes[$times]." player";

				  if ($xTimes[$times]!=1) {echo "s";}

				  echo "'>".$row['yrs']."</td>";

				  echo "<td class='".$cls."_l'>";

				  $rowCnt++;

				  $pcnt=0;

			  }



			  $pid=$row['player_id'];

			  if ($pcnt>0) {echo ", ";}

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo " title='Between ".$row['minYr']." and ".$row['maxYr']."'";

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

	

			  $lastTimes=$times;

			  $pcnt++;

		  }

		  echo "</td></tr>\n";

		  echo " </table>   <!-- close frequent player listing -->\n";

		  echo "</div>   <!-- close frequent player listing -->\n";

	  }



	  ## All-Stars By Team

  	  echo "<div class='textbox' style='width:100%;'>   <!-- open team listing -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open team listing -->\n";

	  echo "  <tr class='title2'><td colspan=3>Most All-Stars by Team</td></tr>\n";

	  echo "  <tr class='headline'><td class='hsc2_l'>Team</td><td class='hsc2_l' title='Number of times represented on All-Star roster'>App.</td><td class='hsc2_l'>Most Frequent Players</td></tr>\n";



  	  # Get Team Player Appearances

	  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,x.team_id,COUNT(year) as yrs,MIN(year) as minYr,MAX(year) as maxYr FROM players as p,(SELECT player_id,team_id,year FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=9) as x WHERE p.player_id=x.player_id GROUP BY x.player_id,x.team_id HAVING COUNT(year)>1 ORDER BY team_id,yrs DESC,minYr,maxYr";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  $tid=$row['team_id'];

			  $yrs=$row['yrs'];



			  if (max(0,$teams[$tid]['totCnt'])<5)

			  {

				  if (isset($teamText[$tid]['display'])) {$teamText[$tid]['display']=$teamText[$tid]['display'].", ";}

				  $teamText[$tid]['display']=$teamText[$tid]['display']."<a href='./player.php?player_id=$pid'";

				  if ($row['hall_of_fame']==1) {$teamText[$tid]['display']=$teamText[$tid]['display']." style='font-weight:bold;'";}

				  $teamText[$tid]['display']=$teamText[$tid]['display'].">".$row['first_name']." ".$row['last_name'];

				  $teamText[$tid]['display']=$teamText[$tid]['display']."</a>";

				  if ($row['retired']!=1) {$teamText[$tid]['display']=$teamText[$tid]['display']."<sup>+</sup>";}

				  $teamText[$tid]['display']=$teamText[$tid]['display']." ($yrs)";

			  }

			  $teams[$tid]['totCnt']=$teams[$tid]['totCnt']+1;

		  }

	  }



	  # Get Teams

	  $query="SELECT t.team_id,name,nickname,abbr,COUNT(x.player_id) as apps,COUNT(DISTINCT x.player_id) as players FROM teams as t LEFT JOIN (SELECT player_id,team_id,year FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=9) as x ON t.team_id=x.team_id WHERE t.league_id=$lgid AND t.sub_league_id=$slid AND allstar_team=0 GROUP BY team_id ORDER BY apps DESC,players,team_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  $rowCnt=0;

		  $tidList="";

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];

			  $tidList.=",".$tid;



			  $cls='s'.($rowCnt%2+1);

			  echo "  <tr class='$cls'>";

			  echo "<td class='".$cls."_l'><a href='./team_overview.php?league_id=$lgid&team_id=$tid'>".$row['name']." ".$row['nickname']."</a></td>";

			  echo "<td style='text-align:center;' title='".$row['players']." unique players'>".$row['apps']."</td>";



			  echo "<td class='".$cls."_l'>";

			  if ($row['apps']==0) {echo " - No appearances -";}

			  elseif ($teamText[$tid]['display']=="") {echo " - No repeat appearances -";}

			  else {echo $teamText[$tid]['display'];}

			  echo "</td></tr>\n";



			  $rowCnt++;

		  }

		  $tidList=trim($tidList,",");

	  }

	  echo " </table>   <!-- close team listing -->\n";

	  echo "</div>   <!-- close team listing -->\n";	  



	  ## All-Stars for Multiple Teams

	  $query="SELECT first_name,last_name,COUNT(DISTINCT x.team_id) as teams FROM players as p,(SELECT player_id,team_id,year FROM players_awards WHERE league_id=$lgid AND award_id=9) as x WHERE p.player_id=x.player_id GROUP BY p.player_id HAVING COUNT(DISTINCT x.team_id)>2 ORDER BY teams DESC LIMIT 5,1";

  	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result)>0)

	  {

		  $row=mysqli_fetch_array($result);

		  $lim=$row['teams'];

	  }

	  else {$lim=3;}



  	  $query="SELECT first_name,last_name,retired,hall_of_fame,COUNT(DISTINCT x.team_id) as teams,x.* FROM players as p,(SELECT player_id,team_id,year FROM players_awards WHERE league_id=$lgid AND award_id=9) as x WHERE p.player_id=x.player_id GROUP BY player_id HAVING COUNT(DISTINCT x.team_id)>=$lim ORDER BY teams DESC";

  	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  echo "<div class='textbox' style='width:100%;'>   <!-- open multiteam listing -->\n";

		  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open multiteam listing -->\n";

		  echo "  <tr class='title2'><td colspan=2>All-Stars for Multiple Teams</td></tr>\n";

		  echo "  <tr class='headline'><td class='hsc2_l'>Player</td><td class='hsc2_l'>Teams</td></tr>\n";

		  $rowCnt=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $cls='s'.($rowCnt%2+1)."_l";

			  echo "  <tr class='$cls'>";

			  $pid=$row['player_id'];

			  echo "<td>".$row['teams']." - <a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo " title='Between ".$row['minYr']." and ".$row['maxYr']."'";

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

			  echo "</td>";

			  echo "<td>";



			  $tmQuery="SELECT pa.team_id,name,nickname,MIN(year) as minYr FROM teams as t,players_awards as pa WHERE t.team_id=pa.team_id AND pa.player_id=$pid AND pa.league_id=$lgid AND award_id=9 GROUP BY pa.team_id ORDER BY minYr";

			  if ($_GET['showq']==1) {echo "$tmQuery<br/>\n";}

			  $tmResult=mysqli_query($db,$tmQuery);

			  $tCnt=0;

			  while ($row=mysqli_fetch_array($tmResult))

			  {

				  $tid=$row['team_id'];

				  if ($tCnt>0) {echo ", ";}

				  echo "<a href='./team_overview.php?league_id=$lgid&team_id=$tid'>".$row['name']." ".$row['nickname']."</a>";

				  $tCnt++;

			  }

			  echo "</td>";

			  echo "</tr>\n";

			  $rowCnt++;

		  }

		  echo " </table>   <!-- close multiteam listing -->\n";

		  echo "</div>   <!-- close multiteam listing -->\n";

	  }



	  ## Annual All-Star Listing

	  echo "<div class='textbox' style='width:100%;'>   <!-- open roster listing -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open roster listing -->\n";

	  echo "  <tr class='title2'><td colspan=5>All-Star Listing</td></tr>\n";

	  # Historical

	  $startYr=99999;

	  $endYr=0;

	  $query="SELECT p.player_id,first_name,last_name,t.abbr,x.team_id,x.year FROM players as p,team_history as t,(SELECT player_id,team_id,year FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=9) as x WHERE p.player_id=x.player_id AND t.team_id=x.team_id AND t.year=x.year ORDER BY x.year,last_name,first_name,player_id";

  	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  $lastYr=0;

		  $rowCnt=0;

		  $pCnt=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  $yr=$row['year'];

			  if ($yr<$startYr) {$startYr=$yr;}

			  if ($yr>$endYr) {$endYr=$yr;}



			  if ($lastYr!=$yr)

			  {

				  if ($pCnt>0)

				  {

					  if ($pCnt%5>0) {echo str_repeat("<td>&nbsp;</td>",5-$pCnt%5);}

					  echo "</tr>\n";

				  }

				  echo "  <tr class='headline'><td class='hsc2_l' colspan=5>$yr</td></tr>\n";

				  $pCnt=0;

			  }



			  if (($pCnt%5==0)&&($pCnt!=0))

			  {

				  $rowCnt++;

				  echo "</tr>\n";

			  }



			  $cls='s'.($rowCnt%2+1)."_l";



			  if ($pCnt%5==0) {echo "  <tr class='$cls'>";}



			  echo "<td>";

			  echo "<a href='./player.php?player_id=$pid'";

			  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

			  echo ">".$row['first_name']." ".$row['last_name']."</a>";

			  if ($row['retired']!=1) {echo "<sup>+</sup>";}

			  $tid=$row['team_id'];

			  echo " (<a href='./team_summary.php?year=$lgyear&team_id=$tid'>".$row['abbr'].")";

			  echo "</td>";



			  $allstars[$tid][$yr]['cnt']=$allstars[$tid][$yr]['cnt']+1;

			  $asYrTots[$yr]=$asYrTots[$yr]+1;



			  $pCnt++;



			  $lastYr=$yr;

		  }

		  if ($pCnt%5>0) {echo str_repeat("<td>&nbsp;</td>",5-$pCnt%5);}

		  echo "</tr>\n";

	  }

	  # Current Year

	  if ($lastYr<$lgyear)

	  {

		  $query="SELECT p.player_id,first_name,last_name,t.abbr,x.team_id FROM players as p,teams as t,(SELECT player_id,team_id FROM players_awards WHERE league_id=$lgid AND sub_league_id=$slid AND award_id=9 AND year=$lgyear) as x WHERE p.player_id=x.player_id AND t.team_id=x.team_id ORDER BY last_name,first_name,player_id";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

		  {

			  echo "  <tr class='headline'><td class='hsc2_l' colspan=5>$lgyear</td></tr>\n";

	

			  if ($lgyear<$startYr) {$startYr=$lgyear;}

			  if ($lgyear>$endYr) {$endYr=$lgyear;}



			  $rowCnt=0;

			  $pCnt=0;

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];

				  if (($pCnt%5==0)&&($pCnt!=0))

				  {

					  $rowCnt++;

					  echo "</tr>\n";

				  }

	

				  $cls='s'.($rowCnt%2+1)."_l";

	

				  if ($pCnt%5==0) {echo "  <tr class='$cls'>";}

		

				  echo "<td>";

				  echo "<a href='./player.php?player_id=$pid'";

				  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

				  echo ">".$row['first_name']." ".$row['last_name']."</a>";

				  if ($row['retired']!=1) {echo "<sup>+</sup>";}

				  $tid=$row['team_id'];

				  echo " (<a href='./team_summary.php?year=$lgyear&team_id=$tid'>".$row['abbr'].")";

				  echo "</td>";



				  $allstars[$tid][$lgyear]['cnt']=$allstars[$tid][$lgyear]['cnt']+1;

				  $asYrTots[$lgyear]=$asYrTots[$lgyear]+1;

	

				  $pCnt++;

			  }

			  if ($pCnt%5>0) {echo str_repeat("<td>&nbsp;</td>",5-$pCnt%5);}

			  echo "</tr>\n";

		  }

	  }

	  echo " </table>   <!-- close roster listing -->\n";

	  echo "</div>   <!-- close roster listing -->\n";

	

	  ## Create Chart Container

	  $maxP=0;

	  for ($yr=$startYr;$yr<=$endYr;$yr++)

	  {

		  if ($maxP<$asYrTots[$yr]) {$maxP=$asYrTots[$yr];}

	  }

	  echo "<div class='textbox' style='width:100%;'>   <!-- open graph -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open graph -->\n";

	  echo "  <tr class='title2'><td colspan=5>Annual Distribution By Team</td></tr>\n";

	  echo "  <tr><td>\n";

	  echo "   <div id='chartwrapper' style='overflow:scroll;overflow:auto;max-width:930px;'>\n";

	  echo "    <div id='chartdiv' style='height:".(100+10*$maxP)."px;width:".(30*($endYr-$startYr+1)+200)."px;margin-left:auto;margin-right:auto;'></div>";

	  echo "   </div>\n";

	  echo "  </td></tr>\n";

	  echo " </table>   <!-- close graph -->\n";

	  echo "</div>   <!-- close graph -->\n";



	  ## Build Chart

	  if ($tidList=="") {break;}

	  $query="SELECT team_id,abbr,text_color_id,background_color_id FROM teams WHERE team_id IN ($tidList)";

    	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  while ($row=mysqli_fetch_array($result))

	  {

		  $tid=$row['team_id'];

		  $teams[$tid]['abbr']=$row['abbr'];

		  $teams[$tid]['text_color_id']=$row['text_color_id'];

		  $teams[$tid]['background_color_id']=$row['background_color_id'];

		  $fndList[$tid]=1;

	  }

	  krsort($allstars);

	  echo "  <script class='code' type='text/javascript'>\n";

	  echo "   <!--\n";

	  echo "    $(document).ready(function(){\n";

	  $dCnt=0;

	  foreach ($allstars as $tid => $val)

	  {

		  if (!isset($fndList[$tid]))

		  {

			  unset($allstars[$tid]);

			  continue;

		  }



		  if ($dCnt>0) {$dataArray.=", ";}

		  $dataArray=$dataArray.$teams[$tid]['abbr']."Data";



		  ksort($allstars[$tid]);

		  echo "      var ".$teams[$tid]['abbr']."Data = [";

		  for ($yr=$startYr;$yr<=$endYr;$yr++)

		  {

			  if ($yr>$startYr) {echo ", ";}

			  echo max(0,$allstars[$tid][$yr]['cnt']);

		  }

		  echo "];\n";

		  $dCnt++;

	  }

	  $nTeams=$dCnt;

	  echo "      var ticks = [";

	  for ($yr=$startYr;$yr<=$endYr;$yr++)

	  {

		  if ($yr>$startYr) {echo ", ";}

		  echo "\"'".substr($yr,2,2)."\"";

	  }

	  echo "];\n";

	  echo "      var plot1 = jQuery.jqplot ('chartdiv', [$dataArray], {\n";

	  echo "          stackSeries: true,\n";

	  //echo "       title:'Annual Distribution By Team',\n";

	  echo "	  seriesDefaults: {\n";

	  echo "                 renderer: jQuery.jqplot.BarRenderer,\n";

	  echo "                 rendererOptions: {highlightMouseDown: true},\n";

	  echo "                 pointLabels: {show: true, stackedValue: false, location: 's', ypadding:3, formatString: '%#.0f'}\n";

	  echo "                 },\n";

	  echo "	  legend: {\n";

	  if ($nTeams>10)

	  {

		  echo "                 renderer: jQuery.jqplot.EnhancedLegendRenderer,\n";

		  echo "                 rendererOptions: {\n";

		  echo "                     numberColumns: ".(floor($nTeams/10)+1)."\n";

		  echo "                     },\n";

	  }

	  echo "                 show: true,\n";

	  echo "                 location: 'w',\n";

	  echo "                 placement: 'outsideGrid'\n";

	  echo "                 },\n";

	  /*

	   echo "          highlighter: {\n";

	  echo "                 show: true\n";

	  echo "                 },\n";

	   */

	  echo "          axes: {\n";

	  echo "                 xaxis: {renderer: jQuery.jqplot.CategoryAxisRenderer, ticks: ticks},\n";

	  echo "                 yaxis: {padMin: 0, min: 0, max: ".(5*floor($maxP/5)+5).", tickInterval: 5}\n";

	  echo "                 },\n";

	  echo "          series:[\n";

	  $dCnt=0;

	  foreach ($allstars as $tid => $val)

	  {

		  if ($dCnt>0) {echo ",\n";}

		  echo "                 {";

		  echo "label:'".$teams[$tid]['abbr']."',";

		  echo "pointLabels:{labels:[";

		  for ($yr=$startYr;$yr<=$endYr;$yr++)

		  {

			  if ($yr>$startYr) {echo ", ";}

			  $lbl=max(0,$allstars[$tid][$yr]['cnt']);

			  if ($lbl==0) {echo "''";} else {echo $lbl;}

		  }

		  echo "]}";

		  echo "}";

		  $dCnt++;

	  }

	  echo "\n";

	  echo "                 ],\n";

	  echo "          seriesColors:[";

	  $dCnt=0;

	  foreach ($allstars as $tid => $val)

	  {

		  if ($dCnt>0) {echo ",";}

		  echo "'".$teams[$tid]['background_color_id']."'";

		  $dCnt++;

	  }

	  echo "]\n";

	  echo "       });\n";

	  echo "\n";

	  $dCnt=0;

	  echo "      jQuery('.jqplot-point-label').css('font-weight','bold');\n";

	  foreach ($allstars as $tid => $val)

	  {

		  echo "      var element;\n";

		  echo "      jQuery('.jqplot-series-$dCnt').css('color','".$teams[$tid]['text_color_id']."');\n";



		  $pCnt=0;

		  for ($yr=$startYr;$yr<=$endYr;$yr++)

		  {

			  $lbl=max(0,$allstars[$tid][$yr]['cnt']);

			  if ($lbl>0)

			  {

				  echo "      jQuery('.jqplot-point-label.jqplot-series-$dCnt.jqplot-point-$pCnt').css('font-size','".(0.75+($lbl-1)*.10)."em');\n";

				  echo "      if (jQuery('.jqplot-point-label.jqplot-series-$dCnt.jqplot-point-$pCnt').length) {\n";

				  echo "          jQuery('.jqplot-point-label.jqplot-series-$dCnt.jqplot-point-$pCnt').css('top',";

				  echo "jQuery('.jqplot-point-label.jqplot-series-$dCnt.jqplot-point-$pCnt').position().top + ".(-4+4*($lbl-1));

				  echo " + 'px');\n";

				  echo "      }\n";

			  }

			  if ($lbl>=10)

			  {

				  echo "      if (jQuery('.jqplot-point-label.jqplot-series-$dCnt.jqplot-point-$pCnt').length) {\n";

				  echo "          jQuery('.jqplot-point-label.jqplot-series-$dCnt.jqplot-point-$pCnt').css('left',";

				  echo "(jQuery('.jqplot-point-label.jqplot-series-$dCnt.jqplot-point-$pCnt').position().left - 7)";

				  echo " + 'px');\n";

				  echo "      }\n";

			  }

			  $pCnt++;

		  }



		  $dCnt++;

	  }



	  echo "      $(\"#chartdiv\").bind('jqplotDataHighlight', function(ev, seriesIndex, pointIndex, data) {\n";

	  echo "	  var $"."this = $(this);\n";

	  echo "	  $"."this.attr('title', data[0] + \": \" + data[1]);\n";

	  echo "      });\n";

	  echo "      $(\"#chartdiv\").bind('jqplotDataUnhighlight', function(ev, seriesIndex, pointIndex, data) {\n";

	  echo "	  var $"."this = $(this);\n";

	  echo "	  $"."this.attr('title',\"\");\n";

	  echo "      });\n";



	  echo "    });\n";

	  echo "   -->\n";

	  echo "  </script>\n"; 



	  break;

  }







  mysqli_close($db);



  echo "<div class='textbox' style='border:0;'><sup>+</sup> = active player<br/><b>Bold</b> = Hall of Famer</div>\n";



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";



  echo "<script type='text/javascript'>\n";

  echo " <!--\n";

  echo "   document.getElementById('yearnav').disabled=1;\n";

  echo " -->\n";

  echo "</script>\n";



  page_foot($_SESSION['lgpath']);





?>

