<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgpath=$_SESSION['lgpath'];

  $date=new Date($_SESSION['lgdate']);

  $lgyear=$date->format("Y");

  $lgMo=$date->format("m");



  $player_id=$_GET['player'];

  if (!is_numeric($player_id)) {unset($player_id);}



  ini_set("memory_limit","64M");

  

  ##### Get Report Settings #####

  if ($_SESSION['user_team_id']>0) {$team_id=$_SESSION['user_team_id'];}

  if (isset($_GET['team_id'])) {$team_id=$_GET['team_id'];}

	  

  include($_SESSION['adminpath']."/dbopen.php");

  ##### Get Teams #####

  $query="SELECT team_id,name,nickname,abbr,league_id,level,parent_team_id,background_color_id,text_color_id FROM teams WHERE allstar_team=0 ORDER BY league_id,name,nickname;";

  if ($_GET['showq']==1) {echo $query."<br/>\n";}

  $result=mysqli_query($db,$query);

  while ($row=mysqli_fetch_array($result))

  {

       	  $tid=$row['team_id'];

	  if ((($team_id=="")||($team_id<1))&&($row['league_id']==$lgid)) {$team_id=$tid;}

	  if (($team_id==$tid)&&($row['league_id']!=$lgid))

	  {

		  $_SESSION['lgid']=$row['league_id'];

		  header("Location: ./injury_report.php?team_id=$tid");

		  exit;

	  }

       	  $teams[$tid]['abbr']=$row['abbr'];

	  $teams[$tid]['league_id']=$row['league_id'];

       	  $teams[$tid]['name']=$row['name']." ".$row['nickname'];

	  $teams[$tid]['level']=get_level($row['level']);

	  $teams[$tid]['parent']=$row['parent_team_id'];

	  $teams[$tid]['background_color_id']=$row['background_color_id'];

	  $teams[$tid]['text_color_id']=$row['text_color_id'];

  }

  

  ##### Get Leagues #####

  $query="SELECT league_id,name FROM leagues";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  while ($row=mysqli_fetch_array($result))

  {

	  $league_id=$row['league_id'];

	  $leagues[$league_id]=$row['name'];

  }



  mysqli_close($db);



  # Title Bar

  $title=$teams[$team_id]['name'].' - Injury Report';



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title,$team_id);

  nav_toolbar('front_office',"Front Office");

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");



  ##### Display Year Filter #####

  echo " <div class='textbox'>\n";

  echo "  <form method='get' action='./injury_report.php' style='clear:left;'>\n";

  echo "  <table cellspacing=0 cellpadding=2 border=0>\n";

  echo "   <tr class='title'><td colspan=5>Filters</td></tr>\n";

  echo "   <tr>\n";



  ## Show Team Filter

  echo "    <td><label for='team_id'><b>Team:</b></label></td>\n";

  echo "    <td>\n";

  echo "     <select name='team_id' id='team_id'>\n";

  $prevLGid=-1;

  foreach ($teams as $tid => $val)

  {

	  if ($teams[$tid]['parent']!=0) {continue;}

	  $tLGid=$teams[$tid]['league_id'];

	  if ($tLGid!=$prevLGid) {echo "      <optgroup label='".$leagues[$tLGid]."'>\n";}

	  echo "      <option value='$tid'";

	  if ($team_id==$tid) {echo " selected";}

	  echo ">".$teams[$tid]['name']."</option>\n";

	  $prevLGid=$tLGid;

  }

  echo "     </select>\n";

  echo "    </td>\n";



  ## Close Form

  echo "    <td><input type='submit' value='Go'></input></td>\n";

  echo "   </tr>\n";

  echo "  </table>\n";

  echo "  </form>\n";

  echo " </div>\n";



  ##### Get Injured Players #####

  echo "<div class='textbox'>\n";

  echo " <table border=0 cellpadding=2 cellspacing=0 style='width:935px;'>\n";

  echo " <tr class='title2'><td colspan=6>Injury Listing</td></tr>\n";

  echo " <tr class='headline'>";

  echo "<td class='hsc2' colspan=2>Pos</td>";

  echo "<td class='hsc2_l'>Player</td>";

  echo "<td class='hsc2'>Status</td>";

  echo "<td class='hsc2'>Injury Time Remaining</td>";

  echo "<td class='hsc2'>DL Time Remaining</td>";

  echo "</tr>\n";

  $nCols=6;



  $query="SELECT x.*,if(x.team_id=$team_id,0,1000)+level as torder FROM teams as t,(SELECT p.player_id,first_name,last_name,age,p.position,p.role,p.team_id,p.league_id,organization_id,injury_is_injured,injury_dtd_injury,injury_career_ending,injury_dl_left,injury_left,dtd_injury_effect,is_on_dl,is_on_dl60,is_active,is_on_secondary,dl_days_this_year FROM players as p,players_roster_status as prs WHERE p.player_id=prs.player_id AND organization_id=$team_id AND (injury_is_injured=1 OR is_on_dl=1 OR is_on_dl60=1)) as x WHERE t.team_id=x.team_id ORDER BY torder,injury_dl_left,injury_left";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

	  $rowCnt=0;

	  $prevLevel=-1;

	  while ($row=mysqli_fetch_array($result))

	  {

		  $pid=$row['player_id'];

		  $tid=$row['team_id'];

		  $pos=$row['position'];

		  if ($pos==1) {$pos=$row['role'];}

		  $onDL=$row['is_on_dl'];

		  $onDL60=$row['is_on_dl60'];

		  $injStatus=$row['injury_is_injured'];

		  $injLeft=$row['injury_left'];

		  $dlLeft=$row['injury_dl_left'];

		  $dtdStatus=$row['injury_dtd_injury'];

		  $lvl=$row['torder'];

		  if ($lvl>100) {$lvl-=1000;}



		  if ($prevLevel!=$lvl)

		  {

			  echo " <tr class='title'><td colspan=$nCols style='color:".$teams[$tid]['text_color_id'].";background-color:".$teams[$tid]['background_color_id'].";'>".$teams[$tid]['name']." (".get_level($lvl).")</td></tr>\n";

			  $rowCnt=0;

		  }



		  $cls='s'.($rowCnt%2+1);

		  echo "  <tr class='$cls'>";

		  echo "<td>";

		  if ((($onDL==1)||($onDL60==1))&&($injLeft==0)&&($dlLeft==0)) {echo "<img src='./images/go.png'>";}

		  if (($injStatus==1)&&($onDL==0)&&($onDL60==0))

		  {

			  if ($dtdStatus==1) {echo "<img src='./images/caution.png'>";}

			  else {echo "<img src='./images/stop.png'>";}

		  }

		  echo "</td>";

		  echo "<td>".get_pos($pos,1)."</td>";

		  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";

		  echo "<td>";

		  if ($injStatus==1)

		  {

			  if ($dtdStatus==1)

			  {

				  echo "DtD: ".(100-$row['dtd_injury_effect'])."%";

			  }

			  else

			  {

				  if ($onDL60==1) {echo "On 60-day DL";}

				  elseif ($onDL==1) {echo "On DL";}

				  else {echo "Out, not on DL";}

			  }

		  }

		  else {echo "Now healthy";}

		  echo "</td>";

		  echo "<td>".$injLeft." day".($injLeft!=1?'s':'')."</td>";

		  echo "<td>".$dlLeft." day".($dlLeft!=1?'s':'')."</td>";

		  echo "</tr>\n";



		  $rowCnt++;

		  $prevLevel=$lvl;

	  }

  }

  else

  {

	  echo "<tr><td colspan=$nCols>No players currently injured or on the DL.</td></tr>\n";

  }



  echo " </table>\n";

  echo "</div>\n";



  ##### Injury Days this Season #####

  $query="SELECT p.player_id,first_name,last_name,p.position,p.role,p.team_id,dl_days_this_year FROM players as p,players_roster_status as prs WHERE p.player_id=prs.player_id AND organization_id=$team_id AND dl_days_this_year>0 ORDER BY dl_days_this_year DESC;";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

	  echo "<div class='textbox'>\n";

	  echo " <table border=0 cellpadding=2 cellspacing=0 style='width:935px;'>\n";

	  echo " <tr class='title2'><td colspan=6>Days on DL this year</td></tr>\n";

	  echo " <tr class='headline'>";

	  echo "<td class='hsc2'>Pos</td>";

	  echo "<td class='hsc2_l'>Player</td>";

	  echo "<td class='hsc2'>DL Days</td>";

	  echo "</tr>\n";



	  $rowCnt=0;

	  $totDLDays=0;

	  while ($row=mysqli_fetch_array($result))

	  {

		  $pid=$row['player_id'];

		  $tid=$row['team_id'];

		  $pos=$row['position'];

		  if ($pos==1) {$pos=$row['role'];}



  		  $cls='s'.($rowCnt%2+1);

		  echo "  <tr class='$cls'>";

		  echo "<td>".get_pos($pos,1)."</td>";

		  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";

		  echo "<td>".$row['dl_days_this_year']."</td>";

		  echo "</tr>\n";



		  $totDLDays+=$row['dl_days_this_year'];



		  $rowCnt++;

		  $prevLevel=$lvl;

	  }



	  echo "  <tr class='headline'><td class='hsc2' colspan=3>$totDLDays</td></tr>\n";

	  echo " </table>\n";

	  echo "</div>\n";

  }



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);





?>

