<?php

session_start();



include_once("gen_functions.php");

include_once("session_functions.php");

include_once("nav_functions.php");

include_once("date.class.php");



check_cookie();



if ((!logged_in())&&(basename($_SERVER['PHP_SELF'])!='login.php')&&(basename($_SERVER['PHP_SELF'])!='widget.php'))

{

	$link='./login.php';



	header('Refresh: 5; URL='.$link); 

	echo "You must login to access StatsLab.<br/>\n";

	echo "<a href='$link'>Click here</a> to go there now.";

	exit;

}



if (!check_nav())

{

	$link='./boxscores.php';

	if (isset($_GET['league_id'])){$link.="?league_id=".$_GET['league_id'];}

	

	header('Refresh: 5; URL='.$link); 

	echo "The requested page isn't enabled for the league specified.  You will be redirected to the default page in 5 seconds.<br/>\n";

	echo "<a href='$link'>Click here</a> to go there now.";

	exit;

}



####################################################

# page_head

#  generates the opening html section of the page

#

# Parameters:

#  title - the title for the page

#  htmlpath - the path to the league's html

#  refresh - the autorefresh rate, in seconds

#  focus - the element to put cursor focus on when the page loads

#  jscripts - pipe delimited list of additional java script to include

####################################################

function page_head($title,$htmlpath,$refresh=0,$focus="",$jscripts="")

 {

   echo "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>\n";

   echo "<html>\n";

   echo "<head>\n";

   if ($title=="")

    {

       $title="StatsLab SQL Utilities for OOTP20";

    }

    else {$title.=" - StatsLab for OOTP20";}

   echo "<title>".$title."</title>\n";

   if ($refresh>0) {echo "<meta http-equiv=refresh content='$refresh'>\n";}

   echo "<meta name='viewport' content='width=device-width, initial-scale=1'>\n";

   echo "<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>\n";

   echo "<link class='include' rel='stylesheet' type='text/css' href='./ootpsqlstyles.css' />\n";

   echo "<link class='include' rel='stylesheet' type='text/css' href='./styles.css' />\n";

   echo "<link class='include' rel='stylesheet' type='text/css' href='./jquery/jquery.jqplot.css' />\n";



   if ($jscripts!="")

   {

      $e=explode("|",$jscripts);

      foreach ($e as $key => $val)

      {

	      if (($val=='./jquery/excanvas.js')||($val=='./jquery/excanvas.min.js')) {echo "<!--[if lt IE 9]><script type='text/javascript' src='".$val."'></script><![endif]-->\n";}

	      else {echo "<script type='text/javascript' src='".$val."'></script>\n";}

      }

   }

   echo "<script type='text/javascript' src='./sorttable.js'></script>\n";

   echo "</head>\n";

   

   echo "\n";

   if ($focus=="") {echo "<body>\n";}

    else {echo "<body onload=\"document.$focus.focus()\">\n";}

   echo "<div id='pagebody'>\n";



   if (isset($_SESSION['configerr']))

    {

      echo " <p class='error'>".$_SESSION['configerr']."</p>";

    }

 }





####################################################

# main_titlebar

#  generates the page's titlebar

#

# Parameters:

#  lgID - the primary league ID for the purposes of menu links

#  htmlpath - the path to the league's html

#  title - alternate title if the page title is not to be used

#  tid   - team ID to use on team pages

####################################################

function main_titlebar($lgID,$htmlpath,$title="",$tid="")

 {

   if ($htmlpath=="") {$htmlpath=$_SESSION['htmlpath'];}

   if ($title=="") {$title=$_SERVER['PHP_SELF'];}



   include($_SESSION['adminpath']."/dbopen.php");

   $query="SHOW TABLES LIKE 'leagues';";

   $result=mysqli_query($db,$query);

   if (mysqli_num_rows($result))

    {

      $query="SELECT name,leagues.current_date FROM leagues WHERE league_id=".$lgID." GROUP BY leagues.current_date;";

      $result=mysqli_query($db,$query);

      $row=mysqli_fetch_array($result);

      $lgname=$row[0];

      $lgdate=$row[1];

  

      $_SESSION['lgname']=$lgname;

      $_SESSION['lgdate']=$lgdate;

	   

      $query="SELECT league_id,abbr,logo_file_name,background_color_id,text_color_id FROM leagues WHERE league_id=$lgID;";

      $result=mysqli_query($db,$query);

      $row=mysqli_fetch_array($result);

      $abbr=$row['abbr'];

      $logo=urlencode($row['logo_file_name']);

      $background_color_id=$row['background_color_id'];

      $text_color_id=$row['text_color_id'];

    }



   ## Get Team Info if relevant

   if ($tid!="")

   {

	   $query="SELECT lg.league_id,lg.name,level,t.logo_file_name,t.background_color_id,t.text_color_id,t.name as tname,t.nickname as nickname,parent_team_id FROM teams as t,leagues as lg WHERE t.league_id=lg.league_id AND team_id=$tid";

	   $result=mysqli_query($db,$query);

	   $row=mysqli_fetch_array($result);

	   $logo=urlencode($row['logo_file_name']);

     	   $background_color_id=$row['background_color_id'];

	   $text_color_id=$row['text_color_id'];

	   $tlgid=$row['league_id'];

	   $tlgname=$row['name'];

	   $tname=$row['tname']." ".$row['nickname'];

	   if (($row['level']!=1)&&($row['level']!=8)) {$tlgname.=" (".get_level($row['level']).")";}

	   if ($row['parent_team_id']!=0)

	   {

		   $query="SELECT name,nickname,abbr FROM teams WHERE team_id=".$row['parent_team_id'];

		   $result=mysqli_query($db,$query);

		   $row=mysqli_fetch_array($result);

		   $parent_name=$row['name'];

		   $tlgname.=" - Affiliate of $parent_name";

	   }

   }



   $defbg="#1E1E9E";

   $deftxt="#DD0101";

   if ($background_color_id=="") {$background_color_id=$defbg;}

   if ($text_color_id=="") {$text_color_id=$deftxt;}



   if ((substr_count("#",$background_color_id)!=1)&&(strlen($background_color_id)!=7)) {$background_color_id=$defbg;}

   if ((substr_count("#",$text_color_id)!=1)&&(strlen($text_color_id)!=7)) {$text_color_id=$deftxt;}



   $date=new Date($_SESSION['lgdate']);

   echo "  <div style='clear:both;float:left;width:959px;padding:0;margin:0;border:0;'>\n";   ## class='shadow'

   echo "   <div style='clear:both;float:left;width:110px;height:110px;padding:10px 12px 10px 8px;margin:0;background-image:url(./images/report_header_logo_left_bg.jpg); background-repeat:no-repeat;'>";

   if ($tid!="") {echo "<a href='$htmlpath/teams/team_".$tid.".html'><img src='$htmlpath/images/team_logos/".str_replace(".png","_110.png",$logo)."' style='width:110px;height:110px;border:0px;' alt=\"$tname\" /></a>";}

   else {echo "<a href='$htmlpath/leagues/league_".$lgID."_home.html'><img src='$htmlpath/images/league_logos/".str_replace(".png","_110.png",$logo)."' style='width:110px;height:110px;border:0px;' alt=\"$tlgname\" /></a>";}

   echo "</div>\n";

   echo "   <div style='clear:right;float:left;padding:0;margin:0;width:829px;height:130px;'>\n";

   echo "    <div style='clear:both;float:left;padding:0;margin:0;width:829px;height:36px;'>\n";

   echo "     <div style='clear:both;float:left;width:8px;height:36px;'><img src='./images/report_header_banner_left.jpg' style='border:0px' /></div>\n";

   echo "     <div style='float:left;width:410px;height:36px;padding:8px 0 0 0;background-image:url(./images/report_header_banner_mid.jpg); background-repeat:repeat-x;'><span style='color:#FFFFFF; font-size:14px; font-weight:bold;'>".$date->format("m-d-Y")."</span></div>\n";

   echo "     <div style='float:left;width:411px;height:36px;padding:0;margin:0;'><img src='./images/report_header_banner_right.jpg' style='border:0px' /></div>\n";

   echo "    </div>\n";

   echo "    <div id='mainmenu' style='float:left;width:821px;height:21px;margin:0;padding:7px 8px 0 0;background-image:url(./images/report_header_menu_bg.jpg); background-repeat:repeat-x;'>\n";   ## class='head_2'

   echo "     <ul class='head2' style='float:right;'>\n";

   echo "      <li><a href='".$htmlpath."/index.html' class='menu' id='first'>BNN Index</a></li>\n";

   echo "      <li><a href='".$htmlpath."/leagues/league_".$lgID."_home.html' class='menu'>$abbr</a></li>\n";

   echo "      <li><a href='".$htmlpath."/leagues/league_".$lgID."_scores.html' class='menu'>Scores</a></li>\n";

   echo "      <li><a href='".$htmlpath."/leagues/league_".$lgID."_standings.html' class='menu'>Standings</a></li>\n";

   echo "      <li><a href='".$htmlpath."/leagues/league_".$lgID."_stats.html' class='menu'>Stats</a></li>\n";

   echo "      <li><a href='".$htmlpath."/leagues/league_".$lgID."_teams.html' class='menu'>Teams</a></li>\n";

   echo "      <li><a href='".$htmlpath."/leagues/league_".$lgID."_players.html' class='menu'>Players</a></li>\n";

   echo "      <li><a href='".$htmlpath."/leagues/league_".$lgID."_transactions_0_0.html' class='menu'>Transactions</a></li>\n";

   echo "      <li><a href='".$htmlpath."/history/league_".$lgID."_index.html' class='menu'>History</a></li>\n";

   echo "     </ul>\n";

   echo "    </div>   <!-- END mainmenu DIV -->\n";

   if ($tid!="")

   {

	   echo "   <div style='float:left;width:821px;height:59px;background-color:$background_color_id;margin:0;padding:7px 0 0 8px;'><span style='color:$text_color_id; font-size:24px; font-weight:bold;'>$title</span><br/><span style='color:$text_color_id; font-size:18px; font-weight:bold;'>$tlgname</span></div>\n";

   }

   else

   {

	   echo "   <div style='float:left;width:821px;height:59px;background-color:$background_color_id;margin:0;padding:7px 0 0 8px;'><span style='color:$text_color_id; font-size:24px; font-weight:bold;'>".$_SESSION['lgname']."</span><br/><span style='color:$text_color_id; font-size:18px; font-weight:bold;'>$title</span></div>\n";

   }

   echo "   </div>\n";

   echo "  </div>\n";



   mysqli_close($db);

   nav_toolbar('main',"",$lgid);

 }



####################################################

# get_player_pic

#  gets the url of the player picture

#

# Parameters:

#  lgpath - the path to the league's html

#  pid    - the player ID

####################################################

function get_player_pic($lgpath,$pid)

{

      	$imgpath=$lgpath."/images/person_pictures/player_".$pid.".png";            ## Check for photo by player ID

	$ch = curl_init($imgpath);

      	curl_setopt($ch, CURLOPT_NOBODY, true);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

      	curl_setopt($ch, CURLOPT_FILETIME, true); 

	curl_exec($ch);

      	$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

	if ($retcode==200) {return $imgpath;}

      	else

	{

      		$imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".png";   ## Check for capitalized name PNG

		$ch = curl_init($imgpath);

      		curl_setopt($ch, CURLOPT_NOBODY, true);

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

      		curl_setopt($ch, CURLOPT_FILETIME, true); 

		curl_exec($ch);

      		$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

		if ($retcode==200) {return $imgpath;}

		else

		{

      			$imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".png";   ## Check for lowercase name PNG

			$ch = curl_init($imgpath);

      			curl_setopt($ch, CURLOPT_NOBODY, true);

			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

      			curl_setopt($ch, CURLOPT_FILETIME, true); 

			curl_exec($ch);

      			$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

			if ($retcode==200) {return $imgpath;}

			else

			{

      				$imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".jpg";   ## Check for capitalized name JPG

				$ch = curl_init($imgpath);

      				curl_setopt($ch, CURLOPT_NOBODY, true);

				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

      				curl_setopt($ch, CURLOPT_FILETIME, true); 

				curl_exec($ch);

      				$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

				if ($retcode==200) {return $imgpath;}

      				else

				{

      					$imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".jpg";   ## Check for lowercase name JPG

					$ch = curl_init($imgpath);

      					curl_setopt($ch, CURLOPT_NOBODY, true);

					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

      					curl_setopt($ch, CURLOPT_FILETIME, true); 

					curl_exec($ch);

      					$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

					if ($retcode==200) {return $imgpath;}

					else

					{

						$imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",$name).".bmp";   ## Check for capitalized name BMP

						$ch = curl_init($imgpath);

      						curl_setopt($ch, CURLOPT_NOBODY, true);

						curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

      						curl_setopt($ch, CURLOPT_FILETIME, true); 

						curl_exec($ch);

      						$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

						if ($retcode==200) {return $imgpath;}

      						else

						{

      							$imgpath=$lgpath."/images/person_pictures/".str_replace(" ","_",strtolower($name)).".bmp";   ## Check for lowercase name bmp

							$ch = curl_init($imgpath);

      							curl_setopt($ch, CURLOPT_NOBODY, true);

							curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

      							curl_setopt($ch, CURLOPT_FILETIME, true); 

							curl_exec($ch);

      							$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

							if ($retcode==200) {return $imgpath;}

      							else

							{

      								return "$lgpath/images/default_player_photo.jpg";   ## Show default

							}

      						}

					}

      				}

			}

      		}

	}

}



####################################################

# get_award_pic

#  gets the url of the award picture

#

# Parameters:

#  basename - the default image.png name (sans extension)

#  lgid     - the league ID

#  slid     - the subleague ID

#  year     - the year

####################################################

function get_award_pic($basename,$lgid,$slid,$year)

{

	$pathbase="http://".$_SERVER['HTTP_HOST'].dirname($_SERVER['PHP_SELF']);

	$imgpath=$pathbase."/images/".$basename."_".$lgid."_".$slid."_".$year.".png";            ## Check for fully qualified award image

	$ch = curl_init($imgpath);

      	curl_setopt($ch, CURLOPT_NOBODY, true);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

      	curl_setopt($ch, CURLOPT_FILETIME, true); 

	curl_exec($ch);

      	$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

	if ($retcode==200) {return $imgpath;}

      	else

	{

		$imgpath=$pathbase."/images/".$basename."_".$lgid."_".$slid.".png";            ## Check for subleague award image

		$ch = curl_init($imgpath);

      		curl_setopt($ch, CURLOPT_NOBODY, true);

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

      		curl_setopt($ch, CURLOPT_FILETIME, true); 

		curl_exec($ch);

      		$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

		if ($retcode==200) {return $imgpath;}

		else

		{

			$imgpath=$pathbase."/images/".$basename."_".$lgid."__".$year.".png";            ## Check for annual award image

			$ch = curl_init($imgpath);

      			curl_setopt($ch, CURLOPT_NOBODY, true);

			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

      			curl_setopt($ch, CURLOPT_FILETIME, true); 

			curl_exec($ch);

      			$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

			if ($retcode==200) {return $imgpath;}

			else

			{

				$imgpath=$pathbase."/images/".$basename."_".$lgid.".png";            ## Check for league specific award image

				$ch = curl_init($imgpath);

      				curl_setopt($ch, CURLOPT_NOBODY, true);

				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

      				curl_setopt($ch, CURLOPT_FILETIME, true); 

				curl_exec($ch);

      				$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

				if ($retcode==200) {return $imgpath;}

      				else

				{

					$imgpath=$pathbase."/images/".$basename."_".$lgid.".png";            ## Check for fully qualified award image

					$ch = curl_init($imgpath);

      					curl_setopt($ch, CURLOPT_NOBODY, true);

					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

      					curl_setopt($ch, CURLOPT_FILETIME, true); 

					curl_exec($ch);

      					$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

					if ($retcode==200) {return $imgpath;}

					else

					{

						return $pathbase."/images/".$basename.".png";   ## Show default

					}

				}

			}

      		}

	}

}



####################################################

# page_foot

#  generates the closing html section of the page

#

# Parameters:

#  htmlpath - the path to the league's html

####################################################

function page_foot($htmlpath)

 {

   echo " <div id='bottombar'>\n";

   echo "  <a href='http://www.ootpdevelopments.com'><img src='".$htmlpath."/images/bnn_logo_bottom.jpg' border='0' width='220' height='28' /></a>\n";

   echo "  <div id='credits'>\n";

   echo "   StatsLab SQL Utilities for OOTP20 v.".get_version()."<br />\n";

   echo "   ".date('l, F jS, Y');

   echo "\n  </div>   <!-- END credits DIV -->\n";

   include ("./page_footer.php");

   echo " </div>   <!-- END bottombar DIV -->\n";

   echo "</div>   <!-- END pagebody DIV -->\n";

   echo "</body>\n";

   echo "</html>\n"; 

 }



####################################################

# check_local

#  Checks if a URL is local to this install of StatsLab

#

# Parameters:

#  checkURL - the URL to check

####################################################

function check_local($checkURL="")

{

	$retVal=false;

	if ($checkURL=="") {return false;}

	

	$slPath=$_SESSION['StatsLabPath'];

	if ($slPath=="") {return false;}

	

	if (strpos($checkURL, $slPath) !== false) {$retVal=true;}

	

	return $retVal;

}

?>