<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgpath=$_SESSION['lgpath'];

  $date=new Date($_SESSION['lgdate']);

  $lgyear=$date->format("Y");



  include($_SESSION['adminpath']."/dbopen.php");



  # Check if awards vote table exists

  $query="SHOW TABLES LIKE 'awards_vote';";

  $result=mysqli_query($db,$query);

  if (!mysqli_num_rows($result))

  {

	  ##### Initialize Table #####

	  $query="CREATE TABLE IF NOT EXISTS awards_vote (player_id INT, league_id INT, sub_league_id INT, year SMALLINT, human_manager_id INT, award_id SMALLINT, position SMALLINT, vote INT DEFAULT 0, PRIMARY KEY (player_id, league_id, sub_league_id, year, human_manager_id, award_id));";

	  $result=mysqli_query($db,$query);

  }



  # Check Admin Table

  $module='HOF';

  $query="SHOW TABLES LIKE 'ootp_sql_admin';";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)) 

  {

	  # Get Settings

	  $query="SELECT setting,value FROM ootp_sql_admin WHERE scope IN ('ALL',$lgid) AND module='$module'";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $field=$row['setting'];

		 	  $val=$row['value'];

			  $val=stripslashes($val);

		 	  switch ($field)

			  {

			  case 'hofVoteEnable' : $hofVoteEnable=$val;  break;

	  		  case 'hofResults': $hofResults=$val; break;

			  case 'numVotes'  : $numVotes=$val;   break;

	  		  case 'maxPerc'   : $maxPerc=$val;    break;

			  case 'minPerc'   : $minPerc=$val;    break;

			  }

		  }

      	  }

  }

  if (($maxPerc=="")||($maxPerc<0)) {$maxPerc=75;}

  elseif ($maxPerc>100) {$maxPerc=100;}

  if (($minPerc=="")||($minPerc<0)) {$minPerc=0;}

  elseif ($minPerc>100) {$minPerc=100;}

  if ($minPerc>$maxPerc) {$minPerc=$maxPerc;}

  

  ##### Get Parameters #####

  $hmid=$_SESSION['user_id'];

  $year=$_GET['year'];

    

  ##### Get years and awards in DB #####

  $query="SHOW TABLES LIKE 'awards_vote';";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

	  ## Get History of Voting

	  $query="SELECT DISTINCT(year) as year FROM awards_vote WHERE league_id=$lgid AND award_id=100 ORDER BY year DESC;";

	  $result=mysqli_query($db,$query);

       	  while ($row=mysqli_fetch_array($result))

	  {

	    	  $yr=$row['year'];

		  $years[$yr]=1;

      	  }

  }

  else {$noHist=1;}



  mysqli_close($db);



  # Title Bar

  $title='Hall of Fame Voting History';



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  nav_toolbar("hof","Hall of Fame Voting");

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  if ($noHist==1)

  {

	  echo "<div class='textbox'>No Hall of Fame voting history yet</div>\n";    

       	  ##### End Page #####

	  echo " </div>   <!-- END contentpane DIV -->\n";

       

	  page_foot($lgpath);

	  exit;

  }

 

  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");



##### Filters #####

echo "<div class='textbox'>\n";

echo " <table cellspacing=0 cellpadding=2 border=0>\n";

echo "  <tr class='title'><td colspan=7>Filters</td></tr>\n";

echo "  <form method='get' action='hofVotingHist.php' class='inline'>\n";

echo "   <tr>\n";



## Show Year Filter

echo "    <td><label for='year'>Year:</label></td>\n";

echo "    <td>\n";

echo "     <select name='year'>\n";

echo "      <option value='ALL'>All Years</option>\n";

foreach ($years as $yr => $val)

{

  if ($yr==$lgyear) {continue;}

   echo "      <option value='$yr'";

   if ($year==$yr) {echo " selected";}

   echo ">$yr</option>\n";

 }

echo "     </select>\n";

echo "    </td>\n";



## Close Form

echo "    <td align='right'>\n";

echo "     <input type='submit' class='submitButton' value='Go' />\n";

echo "    </td>\n";

echo "   </tr>\n";

echo "  </form>\n";

echo " </table>\n";

  

echo "</div>\n";



if (!isset($_GET['year'])) 

{

	##### End Page #####

	echo " </div>   <!-- END contentpane DIV -->\n";



	page_foot($lgpath);

	exit;

}



  $showGMVote=0;

  if ($hmid!="") {$showGMVote=1;}



  ## Get all players

  $query="SELECT p.player_id,p.position,first_name,last_name FROM awards_vote as av,players as p WHERE av.player_id=p.player_id AND av.league_id=$lgid AND award_id=100";

  if ($year!="ALL") {$query.=" AND av.year=$year";}

  $query.=" GROUP BY player_id;";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

	  $pList="";

	  while ($row=mysqli_fetch_array($result))

	  {

		  $pid=$row['player_id'];

		  $pos=get_pos($row['position'],1);

		  $name=$row['first_name']." ".$row['last_name'];



		  $pList.=",$pid";



		  $players[$pid]['name']=$name;

		  $players[$pid]['pos']=get_pos($pos,1);

	  }

	  $pList=trim($pList,",");



	  ## Get user votes

	  if ($hmid>0)

	  {

		  $query="SELECT player_id,year FROM awards_vote WHERE league_id=$lgid AND award_id=100 AND human_manager_id=$hmid";

		  if ($year!="ALL") {$query.=" AND year=$year";}

		  if ($_GET['showq']==1) {$text.="BList: $query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result)>0)

		  {

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];

				  $yr=$row['year'];

				  $votedFor[$yr][$pid]=1;

			  }

		  }

	  }



	  ## Get position

	  $query="SELECT player_id,position,ip,SUM(ip) as totalIP FROM (SELECT player_id,position,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position>1 AND player_id IN ($pList) GROUP BY player_id,position ORDER BY player_id,ip DESC) as y GROUP BY player_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  $players[$pid]['pos']=$row['position'];

			  $players[$pid]['Inn']=$row['ip'];

			  $players[$pid]['TotInn']=$row['totalIP'];

			  $players[$pid]['pos']=get_pos($players[$pid]['pos'],1);

		  }

	  }



	  ## Check PA

	  $query="SELECT player_id,".stat_query('pa')." as pa FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN ($pList) GROUP BY player_id"; 

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  if ($row['pa']>$players[$pid]['TotInn'])

			  {

				  $players[$pid]['pos']=10;

				  $players[$pid]['pos']=get_pos($players[$pid]['pos'],1);

			  }

		  }

	  }



	  ## Check Pitching

	  $pstatArray=Array('g','gs','ip');

	  $query="SELECT pcs.player_id";

	  foreach ($pstatArray as $key => $statlbl) {$query.=",".stat_query($statlbl)." as $statlbl";}

	  $query.=" FROM players_career_pitching_stats as pcs,awards_vote as av WHERE pcs.player_id=av.player_id AND pcs.league_id=$lgid AND av.league_id=$lgid AND split_id=1 AND pcs.player_id IN ($pList) AND av.position=1 GROUP BY player_id"; 

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  $ip=$row['ip'];

			  if ((($ip/$row['g'])<4.00)&&(($row['g']-$row['gs'])>$row['gs'])) {$pos="RP";} else {$pos="SP";}

			  $players[$pid]['pos']=$pos;

		  }

	  }

	

	  ## Loop Through Years

	  foreach ($years as $yr => $val)

	  {

		  if (($year!="ALL")&&($year!=$yr)) {continue;}

		  if ($yr==$lgyear) {continue;}



		  ## Get votes cast

		  $votesCast=0;

	     	  $query="SELECT COUNT(DISTINCT(human_manager_id)) as blt FROM awards_vote WHERE league_id=$lgid AND year=$yr AND award_id=100 AND human_manager_id!=-1;";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	     	  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

	     	  {

			  $row=mysqli_fetch_array($result);

	     		  $votesCast=$row['blt'];

		  }



		  echo "  <div class='textbox'>\n";

		  echo "   <table cellpadding=2 cellspacing=0 border=0 width='400px'>\n";

     		  echo "    <tr class='title'><td colspan=5>$yr Hall of Fame Ballot Results";

		  echo "</td></tr>\n";

     		  echo "    <tr class='headline'><td class='hsc2_l' width='25px'>Pos</td><td class='hsc2_l'>Player</td><td class='hsc2'>Votes</td><td class='hsc2'>Vote%</td>";

     		  if ($hmid>0) {echo "<td class='hsc2'>Your Vote</td>";}

		  echo "</tr>\n";



		  ## Get annual vote

		  $query="SELECT p.player_id,first_name,last_name,SUM(vote) as votes,(SUM(vote)/$votesCast) as pct FROM awards_vote as av,players as p WHERE av.player_id=p.player_id AND av.league_id=$lgid AND av.year=$yr AND award_id=100 GROUP BY player_id ORDER BY votes DESC,last_name,first_name;";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	     	  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

		  {

			  $cnt=0;

     			  $lastPct=101;

			  while ($row=mysqli_fetch_array($result))

			  {

				  $pid=$row['player_id'];

				  $name=$players[$pid]['name'];

     				  $pos=$players[$pid]['pos'];

				  $vote=$row['votes'];

				  $pct=$row['pct'];

				  $pct=sprintf("%.1f",100*$pct);

			  

				  $rowStyle="";

     				  if (($lastPct>=$minPerc)&&($pct<$minPerc)) {$rowStyle=" style='border-top:2px solid red;'";}

				  if (($lastPct>=$maxPerc)&&($pct<$maxPerc)) {$rowStyle=" style='border-top:2px solid green;'";}



				  $cls='s'.($cnt%2+1);

     				  echo "    <tr class='$cls'><td$rowStyle>$pos</td><td class='hsc2_l'$rowStyle><a href='./player.php?player_id=$pid'>$name</a></td>";

				  if (!isset($_GET['human_manager_id'])) {echo "<td$rowStyle>$vote</td><td$rowStyle>$pct</td>";}

     				  if (isset($_SESSION['user_id']))

				  {

     					  echo "<td$rowStyle>";

					  if ($votedFor[$yr][$pid]==1) {echo "X";}

     					  echo "</td>";

				  }

     				  echo "</tr>\n";

				  $cnt++;

     				  $lastPct=$pct;

			  }

		  }

		  else

		  {

			  $cls='s'.($cnt%2+1);

			  echo "   <tr class='".$cls."_l'><td colspan=5>--------------- No votes cast ---------------</td></tr>\n";

			  $cnt++;

		  }

		  echo "   </table>\n";

		  echo "  </div>\n";



		  ## Report blank ballots

		  $query="SELECT COUNT(DISTINCT(human_manager_id)) as blt FROM awards_vote WHERE league_id=$lgid AND year=$yr AND award_id=100 AND player_id=-999";

		  if ($_GET['showq']==1) {echo "$query<br/>\n";}

		  $result=mysqli_query($db,$query);

		  if (mysqli_num_rows($result))

		  {

			  $row=mysqli_fetch_array($result);

			  if ($row['blt']>0)

			  {

				  echo "   <div class='textbox' style='border:0;width:400px;padding-right:20px;text-align:right;'>$yr included ".$row['blt']." blank ballot";

				  if ($row['blt']!=1) {echo "s";}

				  echo "</div>\n";

			  }

		  }

	  }

  }

  else

  {

	  echo "  <div class='textbox' style='border:0px;'>No votes cast for year(s) selected.</div>\n";

  }

  

  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);





?>

