<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  

  # Title Bar

  $title='StatsLab Help Page';



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");

  

  ## Get minimum PT settings

  $query="SELECT year,SUM(g)/COUNT(DISTINCT team_id) as avgG FROM team_history_record WHERE league_id=$lgid AND year>=($year-10) GROUP BY year ORDER BY year;";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

	  $tgame=0;

	  while ($row=mysqli_fetch_array($result))

	  {

		  $yr=$row['year'];

		  $g=$row['avgG'];

		  $tgame+=$g;

	  }

	  $minCarPA=min(ceil(3.1*$tgame),2000);

	  $minCarPA=floor($minCarPA);

	  $minCarIP=min(1.0*$tgame,1000);

	  $minCarIP=floor($minCarIP);

  }

  else

  {

	  $minCarPA=2000;

	  $minCarIP=1000;

  }



  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo get_nav_links();

  echo "  </div>\n";



  ## Stats Glossary

  $statsArray=array("AVG"=>"AVG","BABIP"=>"BABIP","BBK"=>"BB/K","BB9"=>"BB/9","BF"=>"BF","BS"=>"BS","CGPct"=>"CG%","DEff"=>"DEff","EBH"=>"EBH","EqA"=>"EqA","ERA+"=>"ERA+","ERC"=>"ERC","GBPct"=>"GB%","GDP"=>"GDP","GF"=>"GF","H9"=>"H/9","HP"=>"HP","HR9"=>"HR/9","Inn"=>"Inn","ISO"=>"ISO","IBB"=>"K/BB","K9"=>"K/9","OBP"=>"OBP","OPS"=>"OPS","OPS+"=>"OPS+","Outs"=>"Outs","OWS"=>"OWS","PAHR"=>"PA/HR","Pct"=>"Pct","PFhr"=>"PFhr","PFr"=>"PFr","PI"=>"PI","PS"=>"PS","PSPA"=>"PS/PA","PWRSPD"=>"PwrSpd","PWS"=>"PWS","QSPct"=>"QS%","R9"=>"R/9","Range"=>"Range","RC"=>"RC","RC27"=>"RC/27","RSTA"=>"RSTA","RTO"=>"RTO","RTOPct"=>"RTO%","SBPct"=>"SB%","SIMDIFF"=>"Sim Score Diff","SLG"=>"SLG","SVO"=>"SVO","SVPct"=>"SV%","TB"=>"TB","TOB"=>"TOB","TTO"=>"TTO","UER"=>"UER","VORP"=>"VORP","WHIP"=>"WHIP","wOBA"=>"wOBA","WS"=>"WS");



  echo "  <div class='textbox' style='border:0px;font-size:1.5em;font-weight:bold;width:935px;'>\n";

  echo "   <a name='glossary'>Glossary</a>\n";

  echo "   <SELECT style='float:left;clear:both;' onchange=\"window.location='./help.php#'+this[this.selectedIndex].value;\">\n";

  foreach ($statsArray as $key => $val) {echo "    <OPTION value='$key'>$val</OPTION>\n";}

  echo "   </SELECT>\n";

  echo "  </div>\n";

  

  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo "  <p><b><a 'name='AVG'>AVG</a></b> - Batting average; H/AB</p>\n";

  echo "  <p><b><a name='BABIP'>BABIP</a></b> - Batting average on balls in play; (H-HR)/(AB-K-HR+SF)</p>\n";

  echo "  <p><b><a name='BBK'>BB/K</a></b> - Walks per strikeout</p>\n";

  echo "  <p><b><a name='BB9'>BB/9</a></b> - Walks allowed per 9 innings pitched</p>\n";

  echo "  <p><b><a name='BF'>BF</a></b> - Batters Faced</p>\n";

  echo "  <p><b><a name='BS'>BS</a></b> - Blown Saves</p>\n";

  echo "  <p><b><a name='CGPct'>CG%</a></b> - Complete game percentage; CG/GS</p>\n";

  echo "  <p><b><a name='DEff'>DEff</a></b> - Defensive Efficiency (H-E)/(PA-BB-K-HP-HR)</p>\n";

  echo "  <p><b><a name='EBH'>EBH</a></b> - Extra base hits; 2B+3B+HR</p>\n";

  echo "  <p><b><a name='EqA'>EqA</a></b> - Equivalent Average</p>\n";

  echo "  <p><b><a name='ERA+'>ERA+</a></b> - Adjusted ERA, park adjusted (if park factor available) and relative to league average</p>\n";

  echo "  <p><b><a name='ERC'>ERC</a></b> - Component ERA</p>\n";

  echo "  <p><b><a name='GBPct'>GB%</a></b> - Ground ball percentage; GB/(GB+FB)</p>\n";

  echo "  <p><b><a name='GDP'>GDP</a></b> - Ground into double play</p>\n";

  echo "  <p><b><a name='GF'>GF</a></b> - Games finished</p>\n";

  echo "  <p><b><a name='H9'>H/9</a></b> - Hits allowed per 9 innings pitched</p>\n";

  echo "  <p><b><a name='HP'>HP</a></b> - Hit by pitch</p>\n";

  echo "  <p><b><a name='HR9'>HR/9</a></b> - Home runs allowed per 9 innings pitched</p>\n";

  echo "  <p><b><a name='Inn'>Inn</a></b> - Defensive innings played</p>\n";

  echo "  <p><b><a name='ISO'>ISO</a></b> - Isolated power (TB-H)/AB</p>\n";

  echo "  <p><b><a name='KBB'>K/BB</a></b> - Strikeouts per walk</p>\n";

  echo "  <p><b><a name='K9'>K/9</a></b> - Strikeouts per 9 innings pitched</p>\n";

  echo "  <p><b><a name='OBP'>OBP</a></b> - On-base percentage; (H+BB+HP)/(AB+BB+HP+SF)</p>\n";

  echo "  <p><b><a name='OPS'>OPS</a></b> - On-base plus slugging; OBP+SLG</p>\n";

  echo "  <p><b><a name='OPS+'>OPS+</a></b> - Adjusted OPS, park adjusted (if park factor available) and relative to league average</p>\n";

  echo "  <p><b><a name='Outs'>Outs</a></b> - Batter generated outs; AB-H+CS+SH+SF</p>\n";

  echo "  <p><b><a name='OWS'>OWS</a></b> - Offensive Win Shares</p>\n";

  echo "  <p><b><a name='PAPA'>PA/HR</a></b> - Plate appearances per home run hit</p>\n";

  echo "  <p><b><a name='Pct'>Pct</a></b> - Fielding percentage; (PO+A)/TC</p>\n";

  echo "  <p><b><a name='PFhr'>PFhr</a></b> - Park factor - home runs</p>\n";

  echo "  <p><b><a name='PFr'>PFr</a></b> - Park factor - runs</p>\n";

  echo "  <p><b><a name='PI'>PI</a></b> - Pitches thrown</p>\n";

  echo "  <p><b><a name='PS'>PS</a></b> - Pitches seen</p>\n";

  echo "  <p><b><a name='PSPA'>PS/PA</a></b> - Pitches seen per plate appearance</p>\n";

  echo "  <p><b><a name='PWRSPD'>PwrSpd</a></b> - Power-Speed number; (2*HR*SB)/(HR+SB)</p>\n";

  echo "  <p><b><a name='PWS'>PWS</a></b> - Pitching Win Shares</p>\n";

  echo "  <p><b><a name='QSPct'>QS%</a></b> - Quality start percentage; QS/GS</p>\n";

  echo "  <p><b><a name='R9'>R/9</a></b> - Runs allowed per 9 innings pitched</p>\n";

  echo "  <p><b><a name='Range'>Range</a></b> - Range factor; 9*(PO+A)/Inn</p>\n";

  echo "  <p><b><a name='RC'>RC</a></b> - Runs created; ((H+BB-CS+HBP-GDP)*(TB+(.26*(BB-IBB+HBP))+(.52*(SH+SF+SB))))/(AB+BB+HBP+SH+SF)</p>\n";

  echo "  <p><b><a name='RC27'>RC/27</a></b> - Runs created per 27 outs</p>\n";

  echo "  <p><b><a name='RSTA'>RSTA</a></b> - Runner steal attempts against</p>\n";

  echo "  <p><b><a name='RTO'>RTO</a></b> - Runners thrown out</p>\n";

  echo "  <p><b><a name='RTOPct'>RTO%</a></b> - Runner thrown out percentage; RTO/RSTA</p>\n";

  echo "  <p><b><a name='SBPct'>SB%</a></b> - Stolen base success rate; SB/(SB+CS)</p>\n";

  echo "  <p><b><a name='SIMDIFF'>Sim Score Diff</a></b> - Similarity Score Difference.  On the leaderboards search, this will display the most unique/similar players.  Unique players are those with the lowest Similarity Score for their most similar player.  The value displayed is 1000 minus the Similarity Score of the most similar player</p>\n";

  echo "  <p><b><a name='SLG'>SLG</a></b> - Slugging percentage; (1B+2*2B+3*3B+4*HR)/AB</p>\n";

  echo "  <p><b><a name='SVO'>SVO</a></b> - Save opportunities</p>\n";

  echo "  <p><b><a name='SVPct'>SV%</a></b> - Save percentage; SV/(SV+BS)</p>\n";

  echo "  <p><b><a name='TB'>TB</a></b> - Total bases; 1B+2*2B+3*3B+4*HR</p>\n";

  echo "  <p><b><a name='TOB'>TOB</a></b> - Times on base; H+BB+HP</p>\n";

  echo "  <p><b><a name='TTO'>TTO</a></b> - Three true outcomes; HR+K+BB</p>\n";

  echo "  <p><b><a name='UER'>UER</a></b> - Unearned runs (R-ER)</p>\n";

  echo "  <p><b><a name='VORP'>VORP</a></b> - Value over replacement player</p>\n";

  echo "  <p><b><a name='WHIP'>WHIP</a></b> - Walks plus hits per innings pitched; (H+BB)/IP</p>\n";

  echo "  <p><b><a name='wOBA'>wOBA</a></b> - Weighted On-Base Average; (0.72*BB+0.75*HP+0.9*(H-2B-3B-HR)+0.92*RBOE+1.24*2B+1.56*3B+1.95*HR)/PA;<br/>Note - OOTP does not provide RBOE data, so 0 RBOE is used</p>\n";

  echo "  <p><b><a name='WS'>WS</a></b> - Win Shares</p>\n";

  echo "  </div>\n";

  

  echo "  <p><b><a name=''>PI</a></b> - </p>\n";

  

  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo get_nav_links();

  echo "  </div>\n";

  

  ## League Leading Stats

  echo "  <div class='textbox' style='border:0px;font-size:1.5em;font-weight:bold;width:935px;'><a name='leaders'>League Leaders</a></div>\n";

  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo "   <p>League leading stats that are tracked by OOTP are displayed on the player page with an underline.  Any performance that finishes in the top 10 in a league will display at the bottom of the player page.  OOTP only tracks league leading stats in years simmed in OOTP.  Historical seasons prior to play in OOTP will not display.  Stats tracked by OOTP are the following:</p>\n";

  echo "   <p><b>Batting Statistics</b><br/>";

  for ($i=0;$i<=26;$i++)

  {

	  if ($i!=0) {echo ", ";}

       	  echo get_ll_cat($i);

  }

  echo "</p>\n";

  echo "   <p><b>Pitching Statistics</b><br/>";

  for ($i=27;$i<=57;$i++)

  {

       	  if ($i!=27) {echo ", ";}

	  echo get_ll_cat($i);

  }

  echo "</p>\n";

  echo "  </div>\n";



  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo get_nav_links();

  echo "  </div>\n";



  ## HOF Standards

  echo "  <div class='textbox' style='border:0px;font-size:1.5em;font-weight:bold;width:935px;'><a name='hofstandards'>HOF Standards</a></div>\n";

  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo "   <p>This test awards points to players based on career numbers.  It gives a score of 50 for an average Hall of Famer, with 100 as the intended max. It is used to measure the overall quality of a player's career as opposed to singular brilliance (peak value). </p>\n";

  echo "   <p><b>Batting Statistics </b></p>\n";

  echo "   <ul>\n";

  echo "    <li>One point for each 150 hits above 1500, limit 10. </li>\n";

  echo "    <li>One point for each 100 runs over 900, limit 8. </li>\n";

  echo "    <li>One point for each 100 rbi's over 800, limit 8. </li>\n";

  echo "    <li>One point for each 200 home runs. </li>\n";

  echo "    <li>One point for each 200 extra base hits over 300, limit 5. </li>\n";

  echo "    <li>One point for each 200 walks over 300, limit 5. </li>\n";

  echo "    <li>One point for each 100 stolen bases, limit 5. </li>\n";

  echo "    <li>Additional points based on primary position:\n";

  echo "     <ul>\n";

  echo "      <li>20 - Catcher</li>\n";

  echo "      <li>16 - Shortstop</li>\n";

  echo "      <li>14 - Second Base</li>\n";

  echo "      <li>13 - Third Base</li>\n";

  echo "      <li>12 - Center Field</li>\n";

  echo "      <li>6 - Right Field</li>\n";

  echo "      <li>3 - Left Field</li>\n";

  echo "      <li>1 - First Base</li>\n";

  echo "      <li>0 - Designated Hitter</li>\n";

  echo "     </ul>\n";

  echo "    </li>\n";

  echo "   </ul>\n";

  echo "   <p>For each of the following a minimum of $minCarPA plate appearances is required before these points are added.</p>\n";

  echo "   <ul>\n";

  echo "    <li>One point for each .005 of batting average above .275, limit 9 </li>\n";

  echo "    <li>One point for batting over .300 </li>\n";

  echo "    <li>One point for scoring more than .500 runs per game. </li>\n";

  echo "    <li>One point for scoring more than .644 runs per game. </li>\n";

  echo "    <li>One point for driving in more than .500 runs per game. </li>\n";

  echo "    <li>One point for driving in more than .600 runs per game. </li>\n";

  echo "    <li>One point for each .025 of slugging percentage above .300, limit 10 </li>\n";

  echo "    <li>One point for each .010 of on-base percentage above .300, limit 10 </li>\n";

  echo "    <li>One point if home runs are more than 10% of hits. </li>\n";

  echo "    <li>One point if home runs are more than 20% of hits. </li>\n";

  echo "   </ul>\n";

  echo "   <p><b>Pitching Statistics </b></p>\n";

  echo "   <ul>\n";

  echo "    <li>One point for each 10 wins over 100, limit 25. </li>\n";

  echo "    <li>One point for each 20 games over .500, limit 10. </li>\n";

  echo "    <li>One point for each 200 strikeouts over 1000, limit 10. </li>\n";

  echo "    <li>One point for each 1000 innings above 1000, limit 5. </li>\n";

  echo "    <li>One point for each 100 complete games above 200, limit 5. Changed from James's slightly </li>\n";

  echo "    <li>One point for each 30 shutouts, limit 5.</li>\n";

  echo "   </ul>\n";

  echo "   <p>For each of the following a minimum of $minCarIP innings is required before these points are added.</p>\n";

  echo "   <ul>\n";

  echo "    <li>One point for each .013 of winning percentage above .500, limit 15. </li>\n";

  echo "    <li>One point for each .20 of ERA below 4.00, limit 10. </li>\n";

  echo "    <li>One point for each .30 of BB/9IP below 4.00, limit 10. </li>\n";

  echo "    <li>One point for each .30 of H/9IP below 10.00, limit 10. </li>\n";

  echo "   </ul>\n";

  echo "  </div>\n";



  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo get_nav_links();

  echo "  </div>\n";

  

  ## Ink Scores

  echo "  <div class='textbox' style='border:0px;font-size:1.5em;font-weight:bold;width:935px;'><a name='inkscores'>Black and Gray Ink</a></div>\n";

  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo "   <p>The Black and Gray Ink Scores award points to player based on leaderboard finishes.  Black Ink points are awarded for leading the league in a category, while Gray Ink points are awarded for each top 10 finish.  Points are awarded as follows:</p>\n";

  echo "   <p><b>Batting Statistics</b></p>\n";

  echo "   <ul>\n";

  echo "    <li>4 pts - HR, RBI, AVG</li>\n";

  echo "    <li>3 pts - R, H, SLG</li>\n";

  echo "    <li>2 pts - 2B, BB, SB</li>\n";

  echo "    <li>1 pt - G, AB, 3B</li>\n";

  echo "   </ul>\n";

  echo "   <p><b>Pitching Statistics</b></p>\n";

  echo "   <ul>\n";

  echo "    <li>4 pts - W, ERA, K</li>\n";

  echo "    <li>3 pts - IP, W/L Pct, SV</li>\n";

  echo "    <li>2 pts - CG, BB/9, H/9</li>\n";

  echo "    <li>1 pt - G, GS, SHO</li>\n";

  echo "   </ul>\n";

  echo "  </div>\n";



  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo get_nav_links();

  echo "  </div>\n";

  

  ## Similarity Scores

  echo "  <div class='textbox' style='border:0px;font-size:1.5em;font-weight:bold;width:935px;'><a name='similarity'>Similarity Scores</a></div>\n";

  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo "   <p>Similarity Scores are designed to compare players based on their statistical accomplishments.  Players are compared by starting with a score of 1000, and then subtracting based on statistical differences.</p>\n";

  echo "   <p><b>Batters</b> (minimum 500 PA)</p>\n";

  echo "   <ul>\n";

  echo "    <li>One point for each difference of 20 games played</li>\n";

  echo "    <li>One point for each difference of 75 at bats</li>\n";

  echo "    <li>One point for each difference of 10 runs scored</li>\n";

  echo "    <li>One point for each difference of 15 hits</li>\n";

  echo "    <li>One point for each difference of 5 doubles</li>\n";

  echo "    <li>One point for each difference of 4 triples</li>\n";

  echo "    <li>One point for each difference of 2 home runs</li>\n";

  echo "    <li>One point for each difference of 10 RBI</li>\n";

  echo "    <li>One point for each difference of 25 walks</li>\n";

  echo "    <li>One point for each difference of 150 strikeouts</li>\n";

  echo "    <li>One point for each difference of 20 stolen bases</li>\n";

  echo "    <li>One point for each difference of .001 in batting average</li>\n";

  echo "    <li>One point for each difference of .002 in slugging percentage</li>\n";

  echo "   </ul>\n";

  echo "   <p>In addition, batters are further differentiated by position.  Each position has a value, and twelve times the difference between the two player's positions is subtracted as well.  Position values are as follows:</p>\n";

  echo "   <ul>\n";

  echo "    <li>20 - Catcher</li>\n";

  echo "    <li>14 - Shortstop</li>\n";

  echo "    <li>11 - Second Base</li>\n";

  echo "    <li>7 - Third Base</li>\n";

  echo "    <li>5 - Center Field</li>\n";

  echo "    <li>4 - Right Field</li>\n";

  echo "    <li>3 - Left Field</li>\n";

  echo "    <li>1 - First Base</li>\n";

  echo "    <li>0 - Designated Hitter</li>\n";

  echo "   </ul>\n";

  echo "   <p><b>Pitchers</b> (minimum 100 IP)</p>\n";

  echo "   <ul>\n";

  echo "    <li>One point for each difference of 1 win</li>\n";

  echo "    <li>One point for each difference of 2 losses</li>\n";

  echo "    <li>One point for each difference of .002 in winning percentage (max 100 points)</li>\n";

  echo "    <li>One point for each difference of .02 in ERA (max 100 points)</li>\n";

  echo "    <li>One point for each difference of 10 games pitched</li>\n";

  echo "    <li>One point for each difference of 20 games started</li>\n";

  echo "    <li>One point for each difference of 20 complete games</li>\n";

  echo "    <li>One point for each difference of 50 innings pitched</li>\n";

  echo "    <li>One point for each difference of 50 hits allowed</li>\n";

  echo "    <li>One point for each difference of 30 strikeouts</li>\n";

  echo "    <li>One point for each difference of 10 walks</li>\n";

  echo "    <li>One point for each difference of 5 shutouts</li>\n";

  echo "    <li>One point for each difference of 3 saves</li>\n";

  echo "   </ul>\n";

  echo "   <p>In addition, pitchers are assigned a role.  A relief pitcher is determined as having more relief appearances than starts and a maximum of 4 innings per appearance.</p>\n";

  echo "   <ul>\n";

  echo "    <li>Subtract 10 points if the pitchers are starters and threw with different hands</li>\n";

  echo "    <li>Subtract 25 points if the pitchers are relievers and threw with different hands</li>\n";

  echo "    <li>For relievers, halve the winning percentage penalty and allow it to go up to 1.5 times the wins and losses penalty</li>\n";

  echo "   </ul>\n";

  echo "  </div>\n";



  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo get_nav_links();

  echo "  </div>\n";

  

  ## Win Shares

  echo "  <div class='textbox' style='border:0px;font-size:1.5em;font-weight:bold;width:935px;'><a name='winshares'>Win Shares</a></div>\n";

  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo "   <p>Win Shares attempt to assign players a single value to represent their contribution to their team's success over the course of a season.  Win shares are divided up between batting, pitching, and defensive contributions, and each win share represents 1/3 of a team win.  For more information on how win shares are calculated, see the book 'Win Shares', by Bill James.  Some accomodation has been made in the calculation of Win Shares in StatsLab where OOTP does not provide sufficient detail, however, these are relatively minor.</p>\n";

  echo "  </div>\n";

  

  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo get_nav_links();

  echo "  </div>\n";



  echo "  <div class='textbox' style='border:0px;font-size:1.5em;font-weight:bold;width:935px;'><a name='graphs'>Graphs</a></div>\n";

  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo "   <p>Some graphs in StatsLab have added features that allow you to zoom in or hover over a data point to get the exact value.  If the cursor changes to a large '+' sign, then clicking and dragging around an area will (almost always) allow you to zoom in on a section of the plot.  Doubleclicking will return the graph to the default view.</p>\n";

  echo "  </div>\n";

  

  echo "  <div class='textbox' style='border:0px;width:935px;'>\n";

  echo get_nav_links();

  echo "  </div>\n";



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);



function get_nav_links()

 {

   $txt="  <p><a href='#glossary'>Glossary</a> | <a href='#leaders'>League Leaders</a> | <a href='#hofstandards'>HOF Standards</a> | <a href='#inkscores'>Ink Scores</a> | <a href='#similarity'>Similarity Scores</a> | <a href='#winshares'>Win Shares</a> | <a href='#graphs'>Graphs</a></p>\n";

   return $txt;

 }

?>

