<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgyear=$_SESSION['lgyear'];

  $lgpath=$_SESSION['lgpath'];

  $hmid=$_SESSION['user_id'];



  $page=$_GET['page'];



  include($_SESSION['adminpath']."/dbopen.php");



  # Check if awards vote table exists

  $query="SHOW TABLES LIKE 'awards_vote';";

  $result=mysqli_query($db,$query);

  if (!mysqli_num_rows($result))

  {

	  ##### Initialize Table #####

	  $query="CREATE TABLE IF NOT EXISTS awards_vote (player_id INT, league_id INT, sub_league_id INT, year SMALLINT, human_manager_id INT, award_id SMALLINT, position SMALLINT, vote INT DEFAULT 0, PRIMARY KEY (player_id, league_id, sub_league_id, year, human_manager_id, award_id));";

	  $result=mysqli_query($db,$query);

  }



  # Check Admin Table

  $module='HOF';

  $query="SHOW TABLES LIKE 'ootp_sql_admin';";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)) 

  {

	  # Get Settings

	  $query="SELECT setting,value FROM ootp_sql_admin WHERE scope IN ('ALL',$lgid) AND module='$module'";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $field=$row['setting'];

		 	  $val=$row['value'];

			  $val=stripslashes($val);

		 	  switch ($field)

			  {

			  case 'hofVoteEnable' : $hofVoteEnable=$val;  break;

	  		  case 'hofResults': $hofResults=$val; break;

			  case 'numVotes'  : $numVotes=$val;   break;

	  		  case 'maxPerc'   : $maxPerc=$val;    break;

			  case 'minPerc'   : $minPerc=$val;    break;

			  }

		  }

      	  }

  }

  if (($maxPerc=="")||($maxPerc<0)) {$maxPerc=75;}

  elseif ($maxPerc>100) {$maxPerc=100;}

  if (($minPerc=="")||($minPerc<0)) {$minPerc=0;}

  elseif ($minPerc>100) {$minPerc=100;}

  if ($minPerc>$maxPerc) {$minPerc=$maxPerc;}

	

  mysqli_close($db);



  # Title Bar

  $title='Hall of Fame Voting';



  page_head($title,$_SESSION['lgpath'],"","","./jquery/jquery.min.js");

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  nav_toolbar("hof","Hall of Fame Voting");

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ## Exit Conditions

  if ($hofVoteEnable!=1)

  {

	  echo "  <p>Hall of Fame voting is not enabled.</p>";

      	  echo " </div>   <!-- END contentpane DIV -->\n";

	  page_foot($lgpath);

      	  exit;

  }

  if (($hmid=="")&&($page!='results'))

  {

	  echo "  <p>You must be logged in to vote.</p>";

	  echo " </div>   <!-- END contentpane DIV -->\n";

       	  page_foot($lgpath);

	  exit;

  }

  if (($hmid=="")&&($page=='results'))

  {

	  echo "  <p>You must be logged in to see current season results.</p>";

	  echo " </div>   <!-- END contentpane DIV -->\n";

       	  page_foot($lgpath);

	  exit;

  }



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");



switch ($page)

 {

   case 'submit':

     ## Get players to vote for

     echo "  <div class='textbox'>\n";

     echo "   <table cellpadding=2 cellspacing=0 border=0>\n";

     echo "    <tr class='title'><td colspan=2>Hall of Fame Ballot</td></tr>\n";

     echo "    <tr class='headline'><td class='hsc2_l' width='25px'>Pos</td><td class='hsc2_l'>Player</td></tr>\n";

     $cnt=count($_GET['hofvote']);

     if ($cnt>0)

     {

	     for ($i=0;$i<$cnt;$i++)

    	     {

		     $pList.=",".$_GET['hofvote'][$i];

    	     }

	     $pList=trim($pList,",");

     

	     ## Get position

	     $query="SELECT player_id,position,ip,SUM(ip) as totalIP FROM (SELECT player_id,position,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position>1 AND player_id IN ($pList) GROUP BY player_id,position ORDER BY player_id,ip DESC) as y GROUP BY player_id";

  	     if ($_GET['showq']==1) {echo "$query<br/>\n";}

	     $result=mysqli_query($db,$query);

  	     if (mysqli_num_rows($result))

	     {

  		     while ($row=mysqli_fetch_array($result))

		     {

  			     $pid=$row['player_id'];

			     $players[$pid]['pos']=$row['position'];

  			     $players[$pid]['Inn']=$row['ip'];

			     $players[$pid]['TotInn']=$row['totalIP'];

			     $players[$pid]['pos']=get_pos($players[$pid]['pos'],1);

  		     }

	     }



	     ## Check PA

	     $query="SELECT player_id,".stat_query('pa')." as pa FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN ($pList) GROUP BY player_id"; 

  	     if ($_GET['showq']==1) {echo "$query<br/>\n";}

	     $result=mysqli_query($db,$query);

  	     if (mysqli_num_rows($result)>0)

	     {

  		     while ($row=mysqli_fetch_array($result))

		     {

			     $pid=$row['player_id'];

			     if ($row['pa']>$players[$pid]['TotInn'])

			     {

				     $players[$pid]['pos']=10;

				     $players[$pid]['pos']=get_pos($players[$pid]['pos'],1);

			     }

		     }

	     }



	     ## Check Pitching

	     $pstatArray=Array('g','gs','ip');

	     $query="SELECT pcs.player_id";

  	     foreach ($pstatArray as $key => $statlbl) {$query.=",".stat_query($statlbl)." as $statlbl";}

	     $query.=" FROM players_career_pitching_stats as pcs,awards_vote as av WHERE pcs.player_id=av.player_id AND pcs.league_id=$lgid AND av.league_id=$lgid AND split_id=1 AND av.player_id IN ($pList) AND av.position=1 GROUP BY player_id"; 

  	     if ($_GET['showq']==1) {echo "$query<br/>\n";}

	     $result=mysqli_query($db,$query);

  	     if (mysqli_num_rows($result)>0)

	     {

  		     while ($row=mysqli_fetch_array($result))

		     {

			     $pid=$row['player_id'];

			     $ip=$row['ip'];

			     if ((($ip/$row['g'])<4.00)&&(($row['g']-$row['gs'])>$row['gs'])) {$pos="RP";} else {$pos="SP";}

			     $players[$pid]['pos']=$pos;

		     }

	     }

 

	     ## Display Players

	     $query="SELECT p.position,p.player_id,first_name,last_name FROM players as p WHERE p.player_id IN ($pList) ORDER BY position,last_name,first_name;";

  	     if ($_GET['showq']==1) {echo "$query<br/>\n";}

     	     $result=mysqli_query($db,$query);

	     $cnt=0;

     	     while ($row=mysqli_fetch_array($result))

	     {

	  	     $pid=$row['player_id'];

		     $name=$row['first_name']." ".$row['last_name'];

		     $pos=$players[$pid]['pos'];

		     $cls='s'.($cnt%2+1)."_l";

	  	     echo "    <tr class='$cls'><td width='25px'>$pos</td><td><a href='./player.php?player_id=$pid'>$name</a></td></tr>\n";

		     $cnt++;

    	     }

     }

     else

     {

     	     echo "   <tr class='s2_l'><td colspan=2>--------------- BLANK BALLOT ---------------<input type='hidden' name='hofvote' value='-999'></td></tr>\n";

	     $pList=-999;

     }

     echo "    <tr><td colspan=2>\n";

     echo "     <form action='./hofSubmit.php' method='post'>\n";

     echo "      <input type='hidden' name='league_id' value='$lgid'>\n";

     echo "      <input type='hidden' name='year' value='$lgyear'>\n";

     echo "      <input type='hidden' name='ballot' value='$pList'>\n";

     echo "      <input type='submit' name='Submit Vote' value='Submit Vote' />\n";

     echo "     <form>\n";

     echo "    </td></tr>\n";

     echo "   </table>\n";

     echo "  </div>\n";

     break;

   case 'results':

     echo "  <div class='textbox'>\n";

     $votesCast=0;

     $query="SELECT COUNT(DISTINCT(human_manager_id)) as blt FROM awards_vote WHERE league_id=$lgid AND year=$lgyear AND award_id=100 AND human_manager_id!=-1;";

     if ($_GET['showq']==1) {echo "$query<br/>\n";}

     $result=mysqli_query($db,$query);

     if (mysqli_num_rows($result))

     {

     	     $row=mysqli_fetch_array($result);

	     $votesCast=$row['blt'];

     }

     if ($votesCast>0)

     {

	     echo "   <table cellpadding=2 cellspacing=0 border=0 width='400px'>\n";

	     echo "    <tr class='title'><td colspan=5>Hall of Fame Ballot ";

	     if (!isset($_GET['human_manager_id'])) {echo "Results";}

	     else

	     {

		     $query="SELECT first_name,last_name FROM human_managers WHERE human_manager_id=".$_GET['human_manager_id'];

		     if ($_GET['showq']==1) {echo "$query<br/>\n";}

		     $result=mysqli_query($db,$query);

		     if (mysqli_num_rows($result))

		     {

			     $row=mysqli_fetch_array($result);

			     echo "for ".$row['first_name']." ".$row['last_name'];

		     }

	     }

	     echo "</td></tr>\n";

	     echo "    <tr class='headline'><td class='hsc2_l' width='25px'>Pos</td><td class='hsc2_l'>Player</td>";

	     if (!isset($_GET['human_manager_id'])) {echo "<td class='hsc2'>Votes</td><td class='hsc2'>Vote%</td>";}

	     if (isset($_SESSION['user_id'])) {echo "<td class='hsc2'>Your Vote</td>";}

	     echo "</tr>\n";

     	     $query="SELECT p.player_id,p.position,first_name,last_name,SUM(vote) as votes,(SUM(vote)/$votesCast) as pct FROM awards_vote as av,players as p WHERE av.player_id=p.player_id AND av.league_id=$lgid AND av.year=$lgyear AND award_id=100";

	     if (isset($_GET['human_manager_id'])) {$query.=" AND av.human_manager_id=".$_GET['human_manager_id'];}

     	     $query.=" GROUP BY player_id ORDER BY votes DESC,last_name,first_name;";

  	     if ($_GET['showq']==1) {echo "$query<br/>\n";}

	     $result=mysqli_query($db,$query);

     	     if (mysqli_num_rows($result))

	     {

		     $pList="";

	  	     while ($row=mysqli_fetch_array($result))

		     {

	       		     $pid=$row['player_id'];

			     $pos=get_pos($row['position'],1);

	       		     $vote=$row['votes'];

			     $name=$row['first_name']." ".$row['last_name'];

	       		     $pct=$row['pct'];

			     $pct=sprintf("%.1f",100*$pct);



			     $pList.=",$pid";



			     $players[$pid]['name']=$name;

			     $players[$pid]['vote']=$vote;

			     $players[$pid]['pct']=$pct;

		     }

		     $pList=trim($pList,",");



		     ## Get user votes

		     $hmid=$_SESSION['user_id'];

		     if ($hmid>0)

		     {

		  	     $query="SELECT player_id FROM awards_vote WHERE league_id=$lgid AND year=$lgyear AND award_id=100 AND human_manager_id=$hmid";

			     if ($_GET['showq']==1) {$text.="BList: $query<br/>\n";}

		  	     $result=mysqli_query($db,$query);

			     if (mysqli_num_rows($result)>0)

		  	     {

				     while ($row=mysqli_fetch_array($result))

		  		     {

					     $pid=$row['player_id'];

		  			     $votedFor[$pid]=1;

				     }

		  	     }

		     }



	     	     ## Get position

		     $query="SELECT player_id,position,ip,SUM(ip) as totalIP FROM (SELECT player_id,position,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position>1 AND player_id IN ($pList) GROUP BY player_id,position ORDER BY player_id,ip DESC) as y GROUP BY player_id";

		     if ($_GET['showq']==1) {echo "$query<br/>\n";}

		     $result=mysqli_query($db,$query);

		     if (mysqli_num_rows($result))

		     {

			     while ($row=mysqli_fetch_array($result))

			     {

				     $pid=$row['player_id'];

				     $players[$pid]['pos']=$row['position'];

				     $players[$pid]['Inn']=$row['ip'];

				     $players[$pid]['TotInn']=$row['totalIP'];

				     $players[$pid]['pos']=get_pos($players[$pid]['pos'],1);

			     }

		     }

	

		     ## Check PA

		     $query="SELECT player_id,".stat_query('pa')." as pa FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN ($pList) GROUP BY player_id"; 

		     if ($_GET['showq']==1) {echo "$query<br/>\n";}

		     $result=mysqli_query($db,$query);

		     if (mysqli_num_rows($result))

		     {

			     while ($row=mysqli_fetch_array($result))

			     {

				     $pid=$row['player_id'];

				     if ($row['pa']>$players[$pid]['TotInn'])

				     {

					     $players[$pid]['pos']=10;

					     $players[$pid]['pos']=get_pos($players[$pid]['pos'],1);

				     }

			     }

		     }

	     

		     ## Check Pitching

		     $pstatArray=Array('g','gs','ip');

		     $query="SELECT pcs.player_id";

		     foreach ($pstatArray as $key => $statlbl) {$query.=",".stat_query($statlbl)." as $statlbl";}

		     $query.=" FROM players_career_pitching_stats as pcs,awards_vote as av WHERE pcs.player_id=av.player_id AND pcs.league_id=$lgid AND av.league_id=$lgid AND split_id=1 AND pcs.player_id IN ($pList) AND av.position=1 GROUP BY player_id"; 

		     if ($_GET['showq']==1) {echo "$query<br/>\n";}

		     $result=mysqli_query($db,$query);

		     if (mysqli_num_rows($result))

		     {

			     while ($row=mysqli_fetch_array($result))

			     {

				     $pid=$row['player_id'];

				     $ip=$row['ip'];

				     if ((($ip/$row['g'])<4.00)&&(($row['g']-$row['gs'])>$row['gs'])) {$pos="RP";} else {$pos="SP";}

				     $players[$pid]['pos']=$pos;

			     }

		     }



		     ## Display Players

		     $cnt=0;

		     $lastPct=101;

		     foreach ($players as $pid => $val)

		     {

			     $name=$players[$pid]['name'];

			     $vote=$players[$pid]['vote'];

			     $pct=$players[$pid]['pct'];

			     $pos=$players[$pid]['pos'];



			     $rowStyle="";

	       		     if (($lastPct>=$minPerc)&&($pct<$minPerc)) {$rowStyle=" style='border-top:2px solid red;'";}

			     if (($lastPct>=$maxPerc)&&($pct<$maxPerc)) {$rowStyle=" style='border-top:2px solid green;'";}



			     $cls='s'.($cnt%2+1);

			     echo "    <tr class='$cls'><td$rowStyle>$pos</td><td class='hsc2_l'$rowStyle><a href='./player.php?player_id=$pid'>$name</a></td>";

			     if (!isset($_GET['human_manager_id'])) {echo "<td$rowStyle>$vote</td><td$rowStyle>$pct</td>";}

			     if (isset($_SESSION['user_id']))

			     {

				     echo "<td$rowStyle>";

				     if ($votedFor[$pid]==1) {echo "X";}

				     echo "</td>";

			     }

			     echo "</tr>\n";

			     $cnt++;

	       		     $lastPct=$pct;

		     }

    	     }

	     elseif (isset($_GET['human_manager_id']))

    	     {

		     echo "   <tr class='s2_l'><td colspan=5>--------------- BLANK BALLOT ---------------</td></tr>\n";

    	     }

	     echo "   </table>\n";



	     if (!isset($_GET['human_manager_id'])) 

	     {

		     $query="SELECT COUNT(DISTINCT(human_manager_id)) as blt FROM awards_vote WHERE league_id=$lgid AND year=$lgyear AND award_id=100 AND player_id=-999";

		     if ($_GET['showq']==1) {echo "$query<br/>\n";}

		     $result=mysqli_query($db,$query);

		     if (mysqli_num_rows($result))

		     {

			     $row=mysqli_fetch_array($result);

			     if ($row['blt']>0)

			     {

				     $bbTxt="   <div class='textbox' style='border:0;'>Plus ".$row['blt']." blank ballot";

				     if ($row['blt']!=1) {$bbTxt.="s";}

				     $bbTxt.="</div>\n";

			     }

		     }

	     }

     }

     else

     {

     	     echo "No votes have been cast\n";

     }

     echo "  </div>\n";

     if (!isset($_GET['human_manager_id'])) {echo $bbTxt;}

     break;

   default:

     ## Insert Validation Script

     echo "<script type=\"text/javascript\">\n";

     include("./hof.js");

     echo "</script>\n";



     ## Show Sidebar

     echo "<div style='border-top: 1px solid #000000; border-bottom: 1px solid #000000; border-left: 1px solid #000000; background:#FFFFFF; position:fixed; z-index:100; right:0px; top:10px; padding:3px 40px 3px 3px;'>\n";

     echo " <p style='font-weight:bold;'>Your current ballot:</p>\n";

     echo " <div id='ballotText'>0 players</div>\n";

     echo "</div>\n";

	

     ## Start Form

     echo "  <table cellpadding=0 cellspacing=0 border=0>\n";

     echo "   <tr><td>\n";

     echo "    <form action='./hall_of_fame_vote.php' method='get' onsubmit=\"return checkVote(this['hofvote[]'],$numVotes);\">\n";

     echo "     <input type='hidden' name='page' value='submit' />\n";



     echo gen_hof_ballot($lgid);



     echo "   </td></tr>\n";

     ## Close Form

     echo "   <tr><td>\n";

     echo "     <input type='submit' name='Submit Vote' value='Submit Vote' />\n";

     echo "    </form>\n";

     echo "   </td></tr>\n";

     echo "  </table>\n";

     break;

 }



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";



  page_foot($_SESSION['lgpath']);



#########################################################################

# gen_hof_ballot

#  creates Hall of Fame ballot

#########################################################################

function gen_hof_ballot($lgid)

 {

   include($_SESSION['adminpath']."/dbopen.php");

   $lgyear=$_SESSION['lgyear'];

   $lgpath=$_SESSION['lgpath'];



   $text="";

		  

   ##### Get Award Names ######

   $query="SELECT mvp_award_name,pitcher_award_name,rookie_award_name,defense_award_name FROM leagues WHERE league_id=$lgid;";

   $result=mysqli_query($db,$query);

   $row=mysqli_fetch_array($result);

   $awardName[5]=$row['mvp_award_name'];

   $awardName[4]=$row['pitcher_award_name'];

   $awardName[6]=$row['rookie_award_name'];

   $awardName[7]=$row['defense_award_name'];

   $awardName[9]='All-Star';



   ##### Get Team Names #####

   $tList="";

   $query="SELECT team_id,league_id,name,nickname FROM teams;";

   $result=mysqli_query($db,$query);

   while ($row=mysqli_fetch_array($result))

   {

     	   $tid=$row['team_id'];

	   $teams[$tid]=$row['name']." ".$row['nickname'];

     	   if ($row['league_id']==$lgid) {$tList.=",$tid";}

   }

   if (isset($tList)) {$tList=trim($tList,",");}



   ##### Get User Votes #####

   $hmid=$_SESSION['user_id'];

   if ($hmid>0)

   {

	   $query="SELECT player_id FROM awards_vote WHERE league_id=$lgid AND year=$lgyear AND award_id=100 AND human_manager_id=$hmid";

	   if ($_GET['showq']==1) {$text.="BList: $query<br/>\n";}

	   $result=mysqli_query($db,$query);

	   if (mysqli_num_rows($result)>0)

	   {

		   while ($row=mysqli_fetch_array($result))

		   {

			   $pid=$row['player_id'];

			   $votedFor[$pid]=1;

		   }

	   }

   }

   

   ##### Get Batters #####

   $bList=-999;

   $query="SELECT player_id FROM awards_vote WHERE league_id=$lgid AND year=$lgyear AND award_id=100 AND human_manager_id=-1 AND position=10";

   if ($_GET['showq']==1) {$text.="BList: $query<br/>\n";}

   $result=mysqli_query($db,$query);

   if (mysqli_num_rows($result)>0)

   {

	   $bList="";

     	   while ($row=mysqli_fetch_array($result))

	   {

		   $pid=$row['player_id'];

		   $bList.=",$pid";

	   }

	   $bList=trim($bList,",");



	   ## Get position

	   $query="SELECT player_id,position,ip,SUM(ip) as totalIP FROM (SELECT player_id,position,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position>1 AND player_id IN ($bList) GROUP BY player_id,position ORDER BY player_id,ip DESC) as y GROUP BY player_id";

	   if ($_GET['showq']==1) {$text.="BPos: $query<br/>\n";}

	   $result=mysqli_query($db,$query);

	   if (mysqli_num_rows($result))

	   {

		   while ($row=mysqli_fetch_array($result))

		   {

			   $pid=$row['player_id'];

			   $players[$pid]['pos']=$row['position'];

			   $players[$pid]['Inn']=$row['ip'];

			   $players[$pid]['TotInn']=$row['totalIP'];

		   }

	   }



	   ## Get regular season stats

	   $bstatArray=Array('g','ab','h','d','t','hr','rbi','r','bb','hp','sh','sf','k','sb','cs','pa','avg','obp','slg','ops','wOBA','war');

	   $query="SELECT p.player_id,first_name,last_name,MIN(pcs.year) as strt,MAX(pcs.year) as lst,COUNT(DISTINCT(pcs.year)) as yrs";

	   foreach ($bstatArray as $key => $statlbl) {$query.=",".stat_query($statlbl)." as $statlbl";}

	   $query.=" FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND p.player_id IN ($bList) AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id";

	   $query.=" ORDER BY last_name,first_name;";

	   if ($_GET['showq']==1) {$text.="BQ: $query<br/>\n";}

	   $result=mysqli_query($db,$query);

	   if (mysqli_num_rows($result))

	   {

		   while ($row=mysqli_fetch_array($result))

		   {

			   $pid=$row['player_id'];

			   $fname=$row['first_name'];

			   $lname=$row['last_name'];

			   $batters[$pid]=$lname.", ".$first_name;

			   $bList.=",$pid";



			   $players[$pid]['name']=$fname." ".$lname;

			   $players[$pid]['strt']=$row['strt'];

			   $players[$pid]['lst']=$row['lst'];

			   $players[$pid]['yrs']=$row['yrs'];

	

			   foreach ($bstatArray as $key => $statlbl) {$players[$pid][$statlbl]=stat_format($statlbl,$row[$statlbl]);}



			   if ($row['pa']>$players[$pid]['TotInn']) {$players[$pid]['pos']=10;}

		   }

	   }

	

	   ## Get postseason batting stats

	   $query="SELECT player_id,COUNT(DISTINCT(year)) as yrs";

	   foreach ($bstatArray as $key => $statlbl) {$query.=",".stat_query($statlbl)." as $statlbl";}

	   $query.=" FROM players_career_batting_stats WHERE player_id IN ($bList) AND league_id=$lgid AND split_id=21 GROUP BY player_id;";

	   if ($_GET['showq']==1) {$text.="Bps: $query<br/>\n";}

	   $result=mysqli_query($db,$query);

	   if (mysqli_num_rows($result))

	   {

		   while ($row=mysqli_fetch_array($result))

		   {

			   $pid=$row['player_id'];

			   foreach ($bstatArray as $key => $statlbl) {$players[$pid]['ps'][$statlbl]=stat_format($statlbl,$row[$statlbl]);}

		   }

	   }

	

	   ## Get Teams

	   $query="SELECT player_id,year,team_id FROM players_career_batting_stats WHERE player_id IN ($bList) AND league_id=$lgid AND split_id=1 ORDER BY player_id,year,team_id;";

	   $result=mysqli_query($db,$query);

	   if (mysqli_num_rows($result))

	   {

		   while ($row=mysqli_fetch_array($result))

		   {

			   $pid=$row['player_id'];

			   $tid=$row['team_id'];

			   $yr=$row['year'];

			   $players[$pid]['teams'][$tid][$yr]=1;

		   }

	   }



	   ## Get HOF Standards

	   $query="SELECT x.player_id,if(h<1500,0,FLOOR((if(h>3000,3000,h)-1500)/150))+if(r<900,0,FLOOR((if(r>1700,1700,r)-900)/100))+if(rbi<800,0,FLOOR((if(rbi>1600,1600,rbi)-800)/100))+FLOOR(hr/200)+if(ebh<300,0,FLOOR((if(ebh>1300,1300,ebh)-300)/200))+if(bb<300,0,FLOOR((if(bb>1300,1300,bb)-300)/200))+FLOOR(if(sb>500,500,sb)/100)+if(pa>=2000,if(avg<.275,0,FLOOR((if(avg>.320,.320,avg)-.275)/.005)),0)+if(pa>=2000,if(avg>=.300,1,0),0)+if(pa>=2000,if(rRate>=.500,1,0),0)+if(pa>=2000,if(rRate>=.644,1,0),0)+if(pa>=2000,if(rbiRate>=.500,1,0),0)+if(pa>=2000,if(rbiRate>=.600,1,0),0)+if(pa>=2000,if(slg<.300,0,FLOOR((if(slg>.550,.550,slg)-.300)/.025)),0)+if(pa>=2000,if(obp<.300,0,FLOOR((if(obp>.400,.400,obp)-.300)/.010)),0)+if(pa>=2000,if(hrPct>=.10,1,0),0)+if(pa>=2000,if(hrPct>=.20,1,0),0)+if(((position IS NULL) OR (pa>ip)),0,if(position=2,20,if(position=6,16,if(position=4,14,if(position=5,13,if(position=8,12,if(position=9,6,if(position=7,3,1)))))))) as hofStandards FROM (SELECT t1.*,position,ip FROM (SELECT player_id,SUM(g) as g,SUM(pa) as pa,SUM(ab) as ab,SUM(h) as h,SUM(r) as r,SUM(rbi) as rbi,SUM(hr) as hr,SUM(d)+SUM(t)+SUM(hr) as ebh,SUM(bb) as bb,SUM(sb) as sb,if(SUM(ab)=0,0,SUM(h)/SUM(ab)) as avg,if(SUM(g)=0,0,SUM(r)/SUM(g)) as rRate,if(SUM(g)=0,0,SUM(rbi)/SUM(g)) as rbiRate,if(SUM(ab)=0,0,(SUM(h)+SUM(d)+2*SUM(t)+3*SUM(hr))/SUM(ab)) as slg,if((SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))=0,0,(SUM(h)+SUM(bb)+SUM(hp))/(SUM(ab)+SUM(bb)+SUM(hp)+SUM(sf))) as obp,if(SUM(h)=0,0,SUM(hr)/SUM(h)) as hrPct FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN ($bList) GROUP BY player_id) as t1 LEFT JOIN (SELECT player_id,position,ip,SUM(ip) as totalIP FROM (SELECT player_id,position,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position>1 AND player_id IN ($bList) GROUP BY player_id,position ORDER BY player_id,ip DESC) as y GROUP BY player_id) as t2 ON t1.player_id=t2.player_id) as x";

	   $result=mysqli_query($db,$query);

	   if (mysqli_num_rows($result))

	   {

		   while ($row=mysqli_fetch_array($result))

		   {

			   $pid=$row['player_id'];

			   $players[$pid]['hof_standards']=$row['hofStandards'];

		   }

	   }	   

   }



   ##### Get Pitchers #####

   $pList=-999;

   $query="SELECT player_id FROM awards_vote WHERE league_id=$lgid AND year=$lgyear AND award_id=100 AND human_manager_id=-1 AND position=1";

   if ($_GET['showq']==1) {$text.="PList: $query<br/>\n";}

   $result=mysqli_query($db,$query);

   if (mysqli_num_rows($result)>0)

   {

	   $pList="";

     	   while ($row=mysqli_fetch_array($result))

	   {

		   $pid=$row['player_id'];

		   $pList.=",$pid";

	   }

	   $pList=trim($pList,",");

	

	   $pstatArray=Array('g','gs','w','l','s','ip','ha','r','er','hra','bb','k','hld','cg','sho','winpct','era','whip','babip','war');

	   $query="SELECT p.player_id,first_name,last_name,MIN(pcs.year) as strt,MAX(pcs.year) as lst,COUNT(DISTINCT(pcs.year)) as yrs";

	   foreach ($pstatArray as $key => $statlbl) {$query.=",".stat_query($statlbl)." as $statlbl";}

	   $query.=" FROM players as p,players_career_pitching_stats as pcs WHERE p.player_id=pcs.player_id AND p.player_id IN ($pList) AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id";

	   $query.=" ORDER BY last_name,first_name;";

	   if ($_GET['showq']==1) {$text.="PQ: $query<br/>\n";}

	   $result=mysqli_query($db,$query);

	   if (mysqli_num_rows($result))

	   {

		   while ($row=mysqli_fetch_array($result))

		   {

			   $pid=$row['player_id'];

			   $fname=$row['first_name'];

			   $lname=$row['last_name'];

			   $pitchers[$pid]=$lname.", ".$first_name;

			   $pList.=",$pid";



			   $ip=$row['ip'];

			   if ((($ip/$row['g'])<4.00)&&(($row['g']-$row['gs'])>$row['gs'])) {$pos="RP";} else {$pos="SP";}



			   $players[$pid]['name']=$fname." ".$lname;

			   $players[$pid]['pos']=$pos;

			   $players[$pid]['strt']=$row['strt'];

			   $players[$pid]['lst']=$row['lst'];

			   $players[$pid]['yrs']=$row['yrs'];

	

			   foreach ($pstatArray as $key => $statlbl) {$players[$pid][$statlbl]=stat_format($statlbl,$row[$statlbl]);}

		   }

	   }

	

	   ## Get postseason pitching stats

	   $query="SELECT player_id,COUNT(DISTINCT(year)) as yrs";

	   foreach ($pstatArray as $key => $statlbl) {$query.=",".stat_query($statlbl)." as $statlbl";}

	   $query.=" FROM players_career_pitching_stats WHERE player_id IN ($pList) AND league_id=$lgid AND split_id=21 GROUP BY player_id;";

	   if ($_GET['showq']==1) {$text.="Pps: $query<br/>\n";}

	   $result=mysqli_query($db,$query);

	   if (mysqli_num_rows($result))

	   {

		   while ($row=mysqli_fetch_array($result))

		   {

			   $pid=$row['player_id'];

	  

			   $players[$pid]['ps']['yrs']=$row['yrs'];

			   foreach ($pstatArray as $key => $statlbl) {$players[$pid]['ps'][$statlbl]=stat_format($statlbl,$row[$statlbl]);}

		   }

	   }

	

	   ## Get Teams

	   $query="SELECT player_id,year,team_id FROM players_career_pitching_stats WHERE player_id IN ($pList) AND league_id=$lgid AND split_id=1 ORDER BY player_id,year,team_id;";

	   $result=mysqli_query($db,$query);

	   if (mysqli_num_rows($result))

	   {

		   while ($row=mysqli_fetch_array($result))

		   {

			   $pid=$row['player_id'];

			   $tid=$row['team_id'];

			   $yr=$row['year'];

			   $players[$pid]['teams'][$tid][$yr]=1;

		   }

	   }



	   ## Get HOF Standards

	   $query="SELECT x.*,if(w<100,0,FLOOR((if(w>350,350,w)-100)/10))+if(gm500<0,0,FLOOR(if(gm500>200,200,gm500)/20))+if(k<1000,0,FLOOR((if(k>3000,3000,k)-1000)/200))+if(ip<1000,0,FLOOR((if(ip>6000,6000,ip)-1000)/1000))+if(cg<200,0,FLOOR((if(cg>700,700,cg)-200)/100))+FLOOR(if(sho>150,150,sho)/30)+if(ip>=1000,if(winPct<.500,0,FLOOR((if(winPct>.700,.700,winPct)-.500)/.013)),0)+if(ip>=1000,if(era>4.00,0,FLOOR((4.00-if(era<2.00,2.00,era))/.20)),0)+if(ip>=1000,if(bbper9>4.00,0,FLOOR((4.00-if(bbper9<1.00,1.00,bbper9))/.30)),0)+if(ip>=1000,if(hper9>10.00,0,FLOOR((10.00-if(hper9<7.00,7.00,hper9))/.30)),0) as hofStandards FROM (SELECT player_id,SUM(w) as w,SUM(w)-SUM(l) as gm500,SUM(k) as k,SUM(ip)+SUM(ipf)/3 as ip,SUM(cg) as cg,SUM(sho) as sho,if(SUM(w)+SUM(l)=0,0,SUM(w)/(SUM(w)+SUM(l))) as winPct,if(SUM(ip)+SUM(ipf)/3=0,0,9*SUM(er)/(SUM(ip)+SUM(ipf)/3)) as era,if(SUM(ip)+SUM(ipf)/3=0,0,9*SUM(bb)/(SUM(ip)+SUM(ipf)/3)) as bbper9,if(SUM(ip)+SUM(ipf)/3=0,0,9*SUM(ha)/(SUM(ip)+SUM(ipf)/3)) as hper9 FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN ($pList) GROUP BY player_id) as x";

	   $result=mysqli_query($db,$query);

	   if (mysqli_num_rows($result))

	   {

		   while ($row=mysqli_fetch_array($result))

		   {

			   $pid=$row['player_id'];

			   $players[$pid]['hof_standards']=$row['hofStandards'];

		   }

	   }	   

   }



   ##### Check if win shares table exists #####

   $query="SHOW TABLES LIKE 'players_win_shares';";

   $result=mysqli_query($db,$query);

   if (!mysqli_num_rows($result)) {$noWS=1;}

   else

   {

	   $query="SELECT player_id,SUM(ows) as ows,SUM(pws) as pws,SUM(fwsTot) as fwsTot,SUM(wsTot) as wsTot FROM players_win_shares WHERE player_id IN ($bList,$pList) AND team_id IN ($tList) GROUP BY player_id;";

	   if ($_GET['showq']==1) {$text.="WSq: $query<br/>\n";}

	   $result=mysqli_query($db,$query);

     	   if (mysqli_num_rows($result))

	   {

	  	   while ($row=mysqli_fetch_array($result))

		   {

	       		   $pid=$row['player_id'];

			   $ows=$row['ows'];

	       		   $pws=$row['pws'];

			   $fwsTot=$row['fwsTot'];

	       		   $wsTot=$row['wsTot'];

			   $players[$pid]['ows']=sprintf("%.1f",$ows);

	       		   $players[$pid]['pws']=sprintf("%.1f",$pws);

			   $players[$pid]['fwsTot']=sprintf("%.1f",$fwsTot);

	       		   $players[$pid]['wsTot']=sprintf("%.1f",$wsTot);

		   }

    	   }

	   else {$noWS=1;}

   }



   ##### Get Voting History #####

   $query="SELECT year,COUNT(DISTINCT(human_manager_id)) as blt FROM awards_vote WHERE league_id=$lgid AND year<$lgyear AND award_id=100 AND human_manager_id!=-1 GROUP BY year;";

   if ($_GET['showq']==1) {$text.="VotingQ1: $query<br/>\n";}

   $result=mysqli_query($db,$query);

   if (mysqli_num_rows($result))

   {

     	   while ($row=mysqli_fetch_array($result))

	   {

	  	   $yr=$row['year'];

		   $votesCast[$yr]=$row['blt'];

    	   }

   }

   $query="SELECT player_id,year,SUM(vote) as vote FROM awards_vote WHERE player_id IN ($bList,$pList) AND league_id=$lgid AND award_id=100 AND year<$lgyear AND human_manager_id!=-1 GROUP BY player_id,year ORDER BY player_id,year DESC;";

   if ($_GET['showq']==1) {$text.="VotingQ2: $query<br/>\n";}

   $result=mysqli_query($db,$query);

   if (mysqli_num_rows($result))

   {

	   while ($row=mysqli_fetch_array($result))

    	   {

		   $pid=$row['player_id'];

	  	   $yr=$row['year'];

		   $vote=$row['vote'];

	  	   $players[$pid]['hof_vote'][$yr]['vote']=$vote;

		   $players[$pid]['hof_vote'][$yr]['pct']=sprintf("%.1f",100*$vote/$votesCast[$yr]);

    	   }

   }   



   ##### Get Awards #####

   $query="SELECT player_id,award_id,year FROM players_awards WHERE player_id IN ($bList,$pList) AND league_id=$lgid AND award_id IN (4,5,6,7,9) ORDER BY player_id,award_id,year;";

   if ($_GET['showq']==1) {$text.="$query<br/>\n";}

   $result=mysqli_query($db,$query);

   if (mysqli_num_rows($result))

   {

     	   while ($row=mysqli_fetch_array($result))

	   {

	  	   $pid=$row['player_id'];

		   $awID=$row['award_id'];

	  	   $yr=$row['year'];

		   $players[$pid]['awards'][$awID]['cnt']=$players[$pid]['awards'][$awID]['cnt']+1;

	  	   if ($players[$pid]['awards'][$awID]['yrs']=="") {$players[$pid]['awards'][$awID]['yrs']=$yr;}

		   else {$players[$pid]['awards'][$awID]['yrs']=$players[$pid]['awards'][$awID]['yrs'].", $yr";}

    	   }

   }



   ##### Get Black & Gray Ink #####

   $query="SELECT player_id,SUM(bink) as bink,SUM(gink) as gink FROM (SELECT player_id,category,place,if(place=1,1,0) as bink,if(place<11,1,0) as gink FROM players_league_leader WHERE league_id=$lgid AND category IN (0,2,7,27,28,56) AND player_id IN ($bList,$pList) UNION SELECT player_id,category,place,if(place=1,2,0) as bink,if(place<11,2,0) as gink FROM players_league_leader WHERE league_id=$lgid AND category IN (6,9,12,46,47,54) AND player_id IN ($bList,$pList) UNION SELECT player_id,category,place,if(place=1,3,0) as bink,if(place<11,3,0) as gink FROM players_league_leader WHERE league_id=$lgid AND category IN (3,11,20,31,32,34) AND player_id IN ($bList,$pList) UNION SELECT player_id,category,place,if(place=1,4,0) as bink,if(place<11,4,0) as gink FROM players_league_leader WHERE league_id=$lgid AND category IN (8,10,18,29,38,40) AND player_id IN ($bList,$pList)) as t GROUP BY player_id ORDER BY gink DESC";

   if ($_GET['showq']==1) {$text.="InkQ: $query<br/>\n";}

   $result=mysqli_query($db,$query);

   if (mysqli_num_rows($result))

   {

	   while ($row=mysqli_fetch_array($result))

    	   {

		   $pid=$row['player_id'];

		   $players[$pid]['black_ink']=$row['bink'];

		   $players[$pid]['gray_ink']=$row['gink'];

	   }

   }



   ## Trim lists

   if (isset($players))

   {

	   foreach ($players as $pid => $val)

    	   {

		   for ($i=4;$i<=9;$i++)

	 	   {

			   if ($i==8) {continue;}

		       	   if ($players[$pid]['awards'][$i]['cnt']=="")

			   {

				   $players[$pid]['awards'][$i]['cnt']=0;

				   $players[$pid]['awards'][$i]['yrs']="&nbsp;";

	      		   }

		   }

    	   }

   }



   if ($bList==-999) {unset($bList);}

   if ($pList==-999) {unset($pList);}



   ##### Batters #####

   $text.=" <div class='textbox'>\n";

   $text.="  <table cellpadding=0 cellspacing=0 border=0 width='935px'>\n";

   $text.="   <tr class='title2'><td>Batters</td></tr>\n";

   if (isset($bList))

   {

     	   foreach ($batters as $pid => $name)

	   {

		   ## Display Batters

		   $text.="   <tr><td>\n";

	  	   $text.="    <div class='tablebox'>\n";

		   $text.="     <table cellpadding=2 cellspacing=0 border=0 width='915px'>\n";

	  	   $text.="      <tr class='title2'><td colspan=3><a id='pid$pid'>".get_pos($players[$pid]['pos'],1)." ".$players[$pid]['name']."</a></td></tr>\n";

	  

		   ## Show Voting Box & Player Links

		   $text.="      <tr class='s2_l'>\n";

		   $text.="       <td rowspan=10 valign='top' style='border-right:1px solid black;'><input type='checkbox' name='hofvote[]' value=$pid onclick=\"updBallot('hofvote[]','ballotText');\"";

		   if ($votedFor[$pid]==1) {$text.=" checked";}

		   $text.=" /></td>\n";

		   $text.="       <td colspan=2><b>Links:</b> <a href='./player.php?player_id=$pid'>StatsLab Player Page</a>, <a href='$lgpath/players/player_$pid.html'>OOTP Player Page</a></td>\n";

	  	   $text.="      </tr>\n";

	  

		   ## Show Teams Played For

		   $text.="      <tr class='s1_l'>\n";

	  	   $text.="       <td colspan=2><b>Teams:</b> ";

		   $cnt=0;

	  	   foreach ($players[$pid]['teams'] as $tid => $val)

		   {

	       		   if ($cnt!=0) {$text.=", ";}

			   $text.="<a href='./teamHist.php?team_id=$tid'>".$teams[$tid]."</a> (";

	       		   $prevYr=-1;

			   $dset=0;

	       		   foreach ($players[$pid]['teams'][$tid] as $yr =>$val)

			   {

		    		   if (($prevYr+1)==$yr)

				   {

			 		   if ($dset!=1) {$text.="-";}

					   $dset=1;

		   		   }

				   elseif ($prevYr!=-1)

		   		   {

					   if ($dset==1) $text.=$prevYr;

			 		   $text.=", $yr";

					   $dset=0;

		   		   }

				   else {$text.=$yr;}

		    		   $prevYr=$yr;

			   }

	       		   if ($dset==1) {$text.=$yr;}

			   $text.=")";

	       		   $cnt++;

		   }

	  	   $text.="</td>\n";

		   $text.="      </tr>\n";



		   ## Show Accomplishments

		   if (!isset($players[$pid]['black_ink'])) {$players[$pid]['black_ink']=0;}

		   if (!isset($players[$pid]['gray_ink'])) {$players[$pid]['gray_ink']=0;}

		   if (!isset($players[$pid]['hof_standards'])) {$players[$pid]['hof_standards']=0;}



		   $text.="      <tr class='title'><td colspan=2>Accomplishments</td></tr>\n";

		   $text.="      <tr><td valign='top'>\n";

	  	   $text.="       <table cellpadding=2 cellspacing=0 border=0 width='100%'>\n";

		   $text.="        <tr class='headline'><td class='hsc2_l' colspan=3>Awards</td></tr>\n";

	  	   $text.="        <tr class='s2'><td class='s2_l' width='200px'>".$awardName[6].":</td><td>".$players[$pid]['awards'][6]['yrs']."</td><td width='20px'>".$players[$pid]['awards'][6]['cnt']."</td></tr>\n";

		   $text.="        <tr class='s1'><td class='s1_l'>".$awardName[5].":</td><td>".$players[$pid]['awards'][5]['yrs']."</td><td>".$players[$pid]['awards'][5]['cnt']."</td></tr>\n";

	  	   $text.="        <tr class='s2'><td class='s2_l'>".$awardName[7].":</td><td>".$players[$pid]['awards'][7]['yrs']."</td><td>".$players[$pid]['awards'][7]['cnt']."</td></tr>\n";

		   $text.="        <tr class='s1'><td class='s1_l'>".$awardName[9].":</td><td>".$players[$pid]['awards'][9]['yrs']."</td><td>".$players[$pid]['awards'][9]['cnt']."</td></tr>\n";

	  	   $text.="       </table>\n";

		   $text.="      </td><td valign='top' style='max-width:120px;border-left:1px solid black;'>\n";

	  	   $text.="       <table cellpadding=2 cellspacing=0 border=0 width='100%'>\n";

		   $text.="        <tr class='headline'><td class='hsc2_l' colspan=2>Career Metrics</td></tr>\n";

	  	   $text.="        <tr class='s2'><td class='s2_l'>Black Ink:</td><td>".$players[$pid]['black_ink']."</td></tr>\n";

		   $text.="        <tr class='s1'><td class='s1_l'>Gray Ink:</td><td>".$players[$pid]['gray_ink']."</td></tr>\n";

	  	   $text.="        <tr class='s2'><td class='s2_l'>HOF Standards:</td><td>".$players[$pid]['hof_standards']."</td></tr>\n";

		   $text.="        <tr class='s1'><td class='s1_l' colspan=2>&nbsp;</td></tr>\n";

	  	   $text.="       </table>\n";

		   $text.="      </td></tr>\n";

	     

		   ## Show Statistics

		   $text.="      <tr class='title'><td colspan=2>Statistics</td></tr>\n";

	  	   $text.="      <tr><td colspan=2>\n";

		   $text.="       <table cellpadding=2 cellspacing=0 border=0 width='100%'>\n";

		   $text.="        <tr class='headline'><td class='hsc2_l'>&nbsp;</td>";

		   foreach ($bstatArray as $key => $statlbl) {$text.="<td class='hsc2'>".stat_text($statlbl,1)."</td>";}

		   $text.="</tr>\n";

		   $text.="        <tr class='s2'><td class='s2_l'>Regular</td>";

	  	   foreach ($bstatArray as $key => $statlbl) {$text.="<td>".$players[$pid][$statlbl]."</td>";}

		   $text.="</tr>\n";

	  	   $text.="        <tr class='s1'><td class='s1_l'>Postseason</td>";

		   if (isset($players[$pid]['ps']['ab']))

		   {

			   foreach ($bstatArray as $key => $statlbl) {$text.="<td>".$players[$pid]['ps'][$statlbl]."</td>";}

		   }

	 	   else

		   {

	       		   $text.="<td colspan=21 align='center'>No postseason appearances</td>";

		   }

	  	   $text.="</tr>\n";

		   $text.="       </table>\n";

	  	   $text.="      </td></tr>\n";

	   

		   ## Show Win Shares

		   if ($noWS!=1)

	 	   {

			   $text.="      <tr class='title'><td colspan=2>Win Shares</td></tr>\n";

			   $text.="      <tr><td colspan=2>\n";

			   $text.="       <table cellpadding=2 cellspacing=0 border=0 width='100%'>\n";

			   $text.="        <tr class='s2'>";

			   $text.="<td class='s2_l'><b>Offense:</b></td><td class='s2'>".$players[$pid]['ows']."</td>";

			   $text.="<td class='s2_l'><b>Pitching:</b></td><td class='s2'>".$players[$pid]['pws']."</td>";

			   $text.="<td class='s2_l'><b>Fielding:</b></td><td class='s2'>".$players[$pid]['fwsTot']."</td>";

			   $text.="<td class='s2_l'><b>Total:</b></td><td class='s2'>".$players[$pid]['wsTot']."</td>";

			   $text.="</tr>\n";

			   $text.="       </table>\n";

			   $text.="      </td></tr>\n";

	 	   }

	  

		   ## Show Voting History

		   $text.="      <tr class='title'><td colspan=2>Hall of Fame Voting History</td></tr>\n";

	  	   $text.="      <tr><td colspan=2>\n";

		   $text.="       <table cellpadding=2 cellspacing=0 border=0 width='100%'>\n";

	  	   if (isset($players[$pid]['hof_vote']))

		   {

	       		   $text.="        <tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2'>Votes</td><td class='hsc2'>Vote%</td></tr>\n";

			   $cnt=1;

	       		   foreach ($players[$pid]['hof_vote'] as $yr => $val)

			   {

		    		   $cls='s'.($cnt%2+1);

				   $vote=$players[$pid]['hof_vote'][$yr]['vote'];

		    		   $pct=$players[$pid]['hof_vote'][$yr]['pct'];

				   $text.="        <tr class='$cls'><td class='".$cls."_l'>$yr</td><td>$vote</td><td>$pct</td></tr>\n";

		    		   $cnt++;

			   }

	 	   }

		   else {$text.="        <tr class='s2'><td class='s2_l' colspan=2>No previous voting history</td></tr>\n";}

		   $text.="       </table>\n";

		   $text.="      </td></tr>\n";



		   $text.="     </table>\n";

	  	   $text.="    </div>\n";

		   $text.="   </td></tr>\n";

    	   }

   }

   else 

   {

     	   $text.="   <tr><td>No batters eligible</td></tr>\n";

   }

   $text.="  </table>\n";

   $text.=" </div>\n";



   ##### Pitchers #####

   $text.=" <div class='textbox'>\n";

   $text.="  <table cellpadding=0 cellspacing=0 border=0 width='935px'>\n";

   $text.="   <tr class='title2'><td>Pitchers</td></tr>\n";

   if (isset($pList))

   {

     	   foreach ($pitchers as $pid => $name)

	   {

		   ## Display Pitchers

		   $text.="   <tr><td>\n";

	  	   $text.="    <div class='tablebox'>\n";

		   $text.="     <table cellpadding=2 cellspacing=0 border=0 width='915px'>\n";

	  	   $text.="      <tr class='title2'><td colspan=3><a id='pid$pid'>".$players[$pid]['pos']." ".$players[$pid]['name']."</a></td></tr>\n";

	   

		   ## Show Voting Box & Player Links

		   $text.="      <tr class='s2_l'>\n";

	  	   $text.="       <td rowspan=10 valign='top' style='border-right:1px solid black;'><input type='checkbox' name='hofvote[]' value=$pid onclick=\"updBallot('hofvote[]','ballotText');\"";

		   if ($votedFor[$pid]==1) {$text.=" checked";}

		   $text.=" /></td>\n";

		   $text.="       <td colspan=2><b>Links:</b> <a href='./player.php?player_id=$pid'>StatsLab Player Page</a>, <a href='$lgpath/players/player_$pid.html'>OOTP Player Page</a></td>\n";

	  	   $text.="      </tr>\n";

	  

		   ## Show Teams Played For

		   $text.="      <tr class='s1_l'>\n";

	  	   $text.="       <td colspan=2><b>Teams:</b> ";

		   $cnt=0;

	  	   foreach ($players[$pid]['teams'] as $tid => $val)

		   {

	       		   if ($cnt!=0) {$text.=", ";}

			   $text.="<a href='./teamHist.php?team_id=$tid'>".$teams[$tid]."</a> (";

	       		   $prevYr=-1;

			   $dset=0;

	       		   foreach ($players[$pid]['teams'][$tid] as $yr =>$val)

			   {

		    		   if (($prevYr+1)==$yr)

				   {

			 		   if ($dset!=1) {$text.="-";}

					   $dset=1;

		   		   }

				   elseif ($prevYr!=-1)

		   		   {

					   if ($dset==1) $text.=$prevYr;

			 		   $text.=", $yr";

					   $dset=0;

		   		   }

				   else {$text.=$yr;}

			    	   $prevYr=$yr;

			   }

	       		   if ($dset==1) {$text.=$yr;}

			   $text.=")";

	       		   $cnt++;

		   }

	  	   $text.="</td>\n";

		   $text.="      </tr>\n";

	     

		   ## Show Accomplishments

		   if (!isset($players[$pid]['black_ink'])) {$players[$pid]['black_ink']=0;}

		   if (!isset($players[$pid]['gray_ink'])) {$players[$pid]['gray_ink']=0;}

		   if (!isset($players[$pid]['hof_standards'])) {$players[$pid]['hof_standards']=0;}



		   $text.="      <tr class='title'><td colspan=2>Accomplishments</td></tr>\n";

	  	   $text.="      <tr><td valign='top'>\n";

		   $text.="       <table cellpadding=2 cellspacing=0 border=0 width='100%'>\n";

	  	   $text.="        <tr class='headline'><td class='hsc2_l' colspan=3>Awards</td></tr>\n";

		   $text.="        <tr class='s2'><td class='s2_l' width='200px'>".$awardName[6].":</td><td>".$players[$pid]['awards'][6]['yrs']."</td><td width='20px'>".$players[$pid]['awards'][6]['cnt']."</td></tr>\n";

	  	   $text.="        <tr class='s1'><td class='s1_l'>".$awardName[4].":</td><td>".$players[$pid]['awards'][4]['yrs']."</td><td>".$players[$pid]['awards'][4]['cnt']."</td></tr>\n";

		   $text.="        <tr class='s2'><td class='s2_l'>".$awardName[7].":</td><td>".$players[$pid]['awards'][7]['yrs']."</td><td>".$players[$pid]['awards'][7]['cnt']."</td></tr>\n";

	  	   $text.="        <tr class='s1'><td class='s1_l'>".$awardName[9].":</td><td>".$players[$pid]['awards'][9]['yrs']."</td><td>".$players[$pid]['awards'][9]['cnt']."</td></tr>\n";

		   $text.="       </table>\n";

	  	   $text.="      </td><td valign='top' style='max-width:120px;border-left:1px solid black;'>\n";

		   $text.="       <table cellpadding=2 cellspacing=0 border=0 width='100%'>\n";

	  	   $text.="        <tr class='headline'><td class='hsc2_l' colspan=2>Career Metrics</td></tr>\n";

		   $text.="        <tr class='s2'><td class='s2_l'>Black Ink:</td><td>".$players[$pid]['black_ink']."</td></tr>\n";

	  	   $text.="        <tr class='s1'><td class='s1_l'>Gray Ink:</td><td>".$players[$pid]['gray_ink']."</td></tr>\n";

		   $text.="        <tr class='s2'><td class='s2_l'>HOF Standards:</td><td>".$players[$pid]['hof_standards']."</td></tr>\n";

	  	   $text.="        <tr class='s1'><td class='s1_l' colspan=2>&nbsp;</td></tr>\n";

		   $text.="       </table>\n";

	  	   $text.="      </td></tr>\n";

	  

		   ## Show Statistics

		   $text.="      <tr class='title'><td colspan=2>Statistics</td></tr>\n";

	  	   $text.="      <tr><td colspan=2>\n";

		   $text.="       <table cellpadding=2 cellspacing=0 border=0 width='100%'>\n";

	  	   $text.="        <tr class='headline'><td class='hsc2_l'>&nbsp;</td>";

		   foreach ($pstatArray as $key => $statlbl) {$text.="<td class='hsc2'>".stat_text($statlbl,1)."</td>";}

		   $text.="</tr>\n";

		   $text.="        <tr class='s2'><td class='s2_l'>Regular</td>";

	  	   foreach ($pstatArray as $key => $statlbl) {$text.="<td>".$players[$pid][$statlbl]."</td>";}

		   $text.="</tr>\n";

	  	   $text.="        <tr class='s1'><td class='s1_l'>Postseason</td>";

		   if (isset($players[$pid]['ps']['ip']))

	 	   {

			   foreach ($pstatArray as $key => $statlbl) {$text.="<td>".$players[$pid]['ps'][$statlbl]."</td>";}

		   }

	 	   else

		   {

	       		   $text.="<td colspan=19 align='center'>No postseason appearances</td>";

		   }

	  	   $text.="</tr>\n";

		   $text.="       </table>\n";

	  	   $text.="      </td></tr>\n";

	  

		   ## Show Win Shares

		   if ($noWS!=1)

	 	   {

			   $text.="      <tr class='title'><td colspan=2>Win Shares</td></tr>\n";

			   $text.="      <tr><td colspan=2>\n";

			   $text.="       <table cellpadding=2 cellspacing=0 border=0 width='100%'>\n";

			   $text.="        <tr class='s2'>";

			   $text.="<td class='s2_l'><b>Offense:</b></td><td class='s2'>".$players[$pid]['ows']."</td>";

			   $text.="<td class='s2_l'><b>Pitching:</b></td><td class='s2'>".$players[$pid]['pws']."</td>";

			   $text.="<td class='s2_l'><b>Fielding:</b></td><td class='s2'>".$players[$pid]['fwsTot']."</td>";

			   $text.="<td class='s2_l'><b>Total:</b></td><td class='s2'>".$players[$pid]['wsTot']."</td>";

			   $text.="</tr>\n";

			   $text.="       </table>\n";

			   $text.="      </td></tr>\n";

	 	   }

	  

		   ## Show Voting History

		   $text.="      <tr class='title'><td colspan=2>Hall of Fame Voting History</td></tr>\n";

	  	   $text.="      <tr><td colspan=2>\n";

		   $text.="       <table cellpadding=2 cellspacing=0 border=0 width='100%'>\n";

	  	   if (isset($players[$pid]['hof_vote']))

		   {

	       		   $text.="        <tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2'>Votes</td><td class='hsc2'>Vote%</td></tr>\n";

			   $cnt=1;

	       		   foreach ($players[$pid]['hof_vote'] as $yr => $val)

			   {

		    		   $cls='s'.($cnt%2+1);

				   $vote=$players[$pid]['hof_vote'][$yr]['vote'];

		    		   $pct=$players[$pid]['hof_vote'][$yr]['pct'];

				   $text.="        <tr class='$cls'><td class='".$cls."_l'>$yr</td><td>$vote</td><td>$pct</td></tr>\n";

		    		   $cnt++;

			   }

	 	   }

		   else {$text.="        <tr class='s2'><td class='s2_l' colspan=2>No previous voting history</td></tr>\n";}

		   $text.="       </table>\n";

		   $text.="      </td></tr>\n";



		   $text.="     </table>\n";

	  	   $text.="    </div>\n";

		   $text.="   </td></tr>\n";

    	   }

   }

   else 

   {

     	   $text.="   <tr><td>No pitchers eligible</td></tr>\n";

   }

   $text.="  </table>\n";

   $text.=" </div>\n";



   $text.=" <script type=\"text/javascript\">\n";

   $text.="  $(document).ready(function() {\n";

   if (isset($bList))

   {

     	   foreach ($batters as $pid => $name)

	   {

		   $text.="   playerList[$pid] = \"".get_pos($players[$pid]['pos'],1)." ".$players[$pid]['name']."\";\n";

	   }

   }

   if (isset($pList))

   {

     	   foreach ($pitchers as $pid => $name)

	   {

		   $text.="   playerList[$pid] = \"".$players[$pid]['pos']." ".$players[$pid]['name']."\";\n";

	   }

   }

   $text.="   updBallot('hofvote[]','ballotText');\n";

   $text.="   }\n";

   $text.="  );\n";

   $text.=" </script>\n";



   return $text;

 }



?>

