<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $year=$_SESSION['lgyear'];

  $lgpath=$_SESSION['lgpath'];



  $view=$_GET['view'];

  

  $title='Hall of Fame';



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  nav_toolbar("history","History");

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");



  ## Get HoF Players

  $query="SELECT player_id,first_name,last_name,inducted,position FROM players WHERE hall_of_fame=1";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  $pidList="";

  if (mysqli_num_rows($result)>0)

  {

	  while ($row=mysqli_fetch_array($result))

	  {

		  $pid=$row['player_id'];

		  $players[$pid]['name']=$row['first_name']." ".$row['last_name'];

		  $players[$pid]['sortname']=$row['last_name'].", ".$row['first_name'];

		  $players[$pid]['inducted']=$row['inducted'];

		  $players[$pid]['pos']=$row['position'];

		  



		  $pidList.=",$pid";

	  }



	  $pidList=trim($pidList,",");

  }

  else

  {

	  echo "<p>No players have been inducted to the Hall of Fame</p>\n";

	  mysqli_close($db);

	

	  ################## END OF PAGE #########################

	  echo " </div>   <!-- END contentpane DIV -->\n";

	

	  page_foot($_SESSION['lgpath']);

	  exit;

  }



  ## Get Primary Positions

  // Batting Plate Appearances

  $query="SELECT player_id,SUM(pa) as pa FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN ($pidList) GROUP BY player_id";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)>0)

  {

	  while ($row=mysqli_fetch_array($result))

	  {

		  $pid=$row['player_id'];

		  $pa=$row['pa'];



		  $players[$pid]['pa']=$pa;

	  }

  }

  // Fielding positions

  $query="SELECT player_id,position,ip,SUM(ip) as totalIP FROM (SELECT player_id,position,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_fielding_stats WHERE league_id=$lgid AND split_id<=1 AND position>1 AND player_id IN ($pidList) GROUP BY player_id,position ORDER BY player_id,ip DESC) as y GROUP BY player_id";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)>0)

  {

	  while ($row=mysqli_fetch_array($result))

	  {

		  $pid=$row['player_id'];



		  $players[$pid]['fpos']=$row['position'];

		  $players[$pid]['posIP']=$row['ip'];

		  $players[$pid]['totFIP']=$row['totalIP'];

	  }

  }

  // Pitching Innings

  $query="SELECT player_id,SUM(ip)+SUM(ipf)/3 as ip FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN ($pidList) GROUP BY player_id";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)>0)

  {

	  while ($row=mysqli_fetch_array($result))

	  {

		  $pid=$row['player_id'];

		  $players[$pid]['pIP']=$row['ip'];

	  }

  }

  // Assign as batter or pitcher

  $bList="";

  $pList="";

  foreach ($players as $pid => $val)

  {

	  if (!isset($players[$pid]['pIP']))   // Exclusive Batter (no IP)

	  {

		  $bList.=",$pid";

	  }

	  elseif ((!isset($players[$pid]['posIP']))&&(!isset($players[$pid]['pa']))&&(isset($players[$pid]['pIP'])))   // Exclusive Pitcher

	  {

		  $pList.=",$pid";

	  }

	  elseif (!isset($players[$pid]['posIP']))    // No fielding, but did bat

	  {

		  if ($players[$pid]['pIP']>=$players[$pid]['pa']) {$pList.=",$pid";}

		  else {$bList.=",$pid";}

	  }

	  else   // Fielded and Pitched

	  {

		  if ((2.5*$players[$pid]['pIP'])>=$players[$pid]['totFIP']) {$pList.=",$pid";}

		  else {$bList.=",$pid";}

	  }

  }

  $bList=trim($bList,",");

  $pList=trim($pList,",");



  ## Display Tables

  switch ($view)

  {

  case 'detail':

	  echo "<div class='textbox' style='border:0;'><a href='./hall_of_fame.php'>Show Table View</a></div>\n";

	  break;

  case 'table':

  default:

	  //echo "<div class='textbox' style='border:0;'><a href='./hall_of_fame.php?view=detail'>Show Expanded View</a></div>\n";



	  ## Batters

	  if ($bList=="") {$bList=-999;}

	  $statArray=Array('g','ab','h','d','t','hr','rbi','r','bb','hp','sh','sf','k','sb','cs','avg','obp','slg','ops','war');



	  echo "<div class='textbox'>\n";

	  echo " <table cellpadding=0 cellspacing=0 border=0>\n";

	  echo "  <tr class='title2'><td style='padding:5px';>Batters</td></tr>\n";

	  echo "  <tr><td>\n";

	  echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' style='width:935px;'>\n";

	  echo "    <thead><tr class='headline'>";

	  echo "<td class='hsc2'>Pos</td>";

	  echo "<td class='hsc2_l'>Player</td>";

	  echo "<td class='hsc2'>From</td>";

	  echo "<td class='hsc2'>To</td>";

	  echo "<td class='hsc2'>Yrs</td>";

	  foreach ($statArray as $key => $statlbl) {echo "<td class='hsc2'>".stat_text($statlbl,2)."</td>";}

	  echo "</tr></thead>\n";



	  $query="SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT year) as yrs";

	  foreach ($statArray as $key => $statlbl) {$query.=",".stat_query($statlbl)." as $statlbl";}

	  $query.=" FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN ($bList) GROUP BY player_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result)>0)

	  {

		  $rowCnt=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  if (!isset($players[$pid]['fpos'])) {$pos=$players[$pid]['pos'];}

			  else {$pos=$players[$pid]['fpos'];}



			  $cls='s'.($rowCnt%2+1);

			  echo "    <tr class='$cls'>";

			  echo "<td sorttable_customkey=$pos>".get_pos($pos,1)."</td>";

			  echo "<td sorttable_customkey='".$players[$pid]['sortname']."'><a href='./player.php?player_id=$pid'>".$players[$pid]['name']."</a></td>";

			  echo "<td>".$row['minYr']."</td>";

			  echo "<td>".$row['maxYr']."</td>";

			  echo "<td>".$row['yrs']."</td>";

			  foreach ($statArray as $key => $statlbl)

			  {

				  echo "<td>".stat_format($statlbl,$row[$statlbl])."</td>";

				  $hofTotals[$pos][$statlbl]=$hofTotals[$pos][$statlbl]+$row[$statlbl];

				  $hofTotals['all'][$statlbl]=$hofTotals['all'][$statlbl]+$row[$statlbl];

			  }

			  echo "</tr>\n";



			  $hofTotals[$pos]['yrs']=$hofTotals[$pos]['yrs']+$row['yrs'];

			  $hofTotals[$pos]['cnt']=$hofTotals[$pos]['cnt']+1;

			  $hofTotals['all']['yrs']=$hofTotals['all']['yrs']+$row['yrs'];

			  $hofTotals['all']['cnt']=$hofTotals['all']['cnt']+1;

			  $rowCnt++;

		  }



		  // Display Footer

		  echo "    <tfoot>";

		  echo "     <tr class='headline'>";

		  echo "<td class='hsc2_l' colspan=4>HOF Averages</td>";

		  echo "<td class='hsc2'>Yrs</td>";

		  foreach ($statArray as $key => $statlbl) {echo "<td class='hsc2'>".stat_text($statlbl,2)."</td>";}

		  echo "</tr>\n";

		  foreach ($hofTotals as $pos => $val)

		  {

			  if ($pos=='all') {continue;}

			  echo "     <tr class='headline'>";

			  echo "<td class='hsc2_l' colspan=4>".get_pos($pos,1)." - ".$hofTotals[$pos]['cnt']." players</td>";

			  echo "<td class='hsc2'>".stat_format('yrs',$hofTotals[$pos]['yrs']/$hofTotals[$pos]['cnt'],0)."</td>";

			  foreach ($statArray as $key => $statlbl) 

			  {

				  $precision=0;

				  switch ($statlbl)

				  {

				  case 'avg':

				  case 'obp':

				  case 'slg':

				  case 'ops':

				  case 'war':

					  $precision="";

					  break;

				  }

				  echo "<td class='hsc2'>".stat_format($statlbl,$hofTotals[$pos][$statlbl]/$hofTotals[$pos]['cnt'],$precision)."</td>";

			  }

			  echo "</tr>\n";

		  }

		  echo "     <tr class='headline'>";

		  echo "<td class='hsc2_l' colspan=4>Totals - ".$hofTotals['all']['cnt']." players</td>";

		  echo "<td class='hsc2'>".stat_format('yrs',$hofTotals['all']['yrs']/$hofTotals['all']['cnt'],0)."</td>";

		  foreach ($statArray as $key => $statlbl) 

		  {

			  $precision=0;

			  switch ($statlbl)

			  {

			  case 'avg':

			  case 'obp':

			  case 'slg':

			  case 'ops':

			  case 'war':

				  $precision="";

				  break;

			  }

			  echo "<td class='hsc2'>".stat_format($statlbl,$hofTotals['all'][$statlbl]/$hofTotals['all']['cnt'],$precision)."</td>";

		  }

		  echo "</tr>\n";

		  echo "    </tfoot>\n";

		  unset ($hofTotals);

	  }

	  else

	  {

		  echo "     <tr><td colspan=".(5+count($statArray))." style='text-align:center;'>No hall of famers have accumulated batting stats in this league.</td></tr>\n";

	  }



	  echo "   </table>\n";

	  echo "  </td></tr>\n";

	  echo " </table>\n";

	  echo "</div>\n";



	  ## Pitchers

	  $statArray=Array('g','gs','w','l','s','era','ip','ha','r','er','hra','bb','k','hld','cg','sho','whip','war');

	  if ($pList=="") {$pList=-999;}



	  echo "<div class='textbox'>\n";

	  echo " <table cellpadding=0 cellspacing=0 border=0>\n";

	  echo "  <tr class='title2'><td style='padding:5px';>Pitchers</td></tr>\n";

	  echo "  <tr><td>\n";

	  echo "   <table cellpadding=2 cellspacing=0 border=0 class='sortable' style='width:935px;'>\n";

	  echo "    <thead><tr class='headline'>";

	  echo "<td class='hsc2'>Pos</td>";

	  echo "<td class='hsc2_l'>Player</td>";

	  echo "<td class='hsc2'>From</td>";

	  echo "<td class='hsc2'>To</td>";

	  echo "<td class='hsc2'>Yrs</td>";

	  foreach ($statArray as $key => $statlbl) {echo "<td class='hsc2'>".stat_text($statlbl,2)."</td>";}

	  echo "</tr></thead>\n";



	  $query="SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr,COUNT(DISTINCT year) as yrs";

	  foreach ($statArray as $key => $statlbl) {$query.=",".stat_query($statlbl)." as $statlbl";}

	  $query.=" FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 AND player_id IN ($pList) GROUP BY player_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result)>0)

	  {

		  $rowCnt=0;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];



			  if ((($row['g']-$row['gs'])>$row['gs']) && (($row['ip']/$row['g'])<=4))

			  {

				  if ($row['s']>(0.4*($row['g']-$row['gs']))) {$pos=13;}   // Closer

				  else {$pos=12;}   // Middle Relief

			  }

			  else {$pos=11;}   // Starter



			  $cls='s'.($rowCnt%2+1);

			  echo "    <tr class='$cls'>";

			  echo "<td sorttable_customkey=$pos>".get_pos($pos,1)."</td>";

			  echo "<td sorttable_customkey='".$players[$pid]['sortname']."'><a href='./player.php?player_id=$pid'>".$players[$pid]['name']."</a></td>";

			  echo "<td>".$row['minYr']."</td>";

			  echo "<td>".$row['maxYr']."</td>";

			  echo "<td>".$row['yrs']."</td>";

			  foreach ($statArray as $key => $statlbl)

			  {

				  echo "<td>".stat_format($statlbl,$row[$statlbl])."</td>";

				  $hofTotals[$pos][$statlbl]=$hofTotals[$pos][$statlbl]+$row[$statlbl];

				  $hofTotals['all'][$statlbl]=$hofTotals['all'][$statlbl]+$row[$statlbl];

			  }



			  $hofTotals[$pos]['yrs']=$hofTotals[$pos]['yrs']+$row['yrs'];

			  $hofTotals[$pos]['cnt']=$hofTotals[$pos]['cnt']+1;

			  $hofTotals['all']['yrs']=$hofTotals['all']['yrs']+$row['yrs'];

			  $hofTotals['all']['cnt']=$hofTotals['all']['cnt']+1;



			  echo "</tr>\n";

			  $rowCnt++;

		  }



		  // Display Footer

		  echo "    <tfoot>";

		  echo "     <tr class='headline'>";

		  echo "<td class='hsc2_l' colspan=4>HOF Averages</td>";

		  echo "<td class='hsc2'>Yrs</td>";

		  foreach ($statArray as $key => $statlbl) {echo "<td class='hsc2'>".stat_text($statlbl,2)."</td>";}

		  echo "</tr>\n";

		  foreach ($hofTotals as $pos => $val)

		  {

			  if ($pos=='all') {continue;}

			  echo "     <tr class='headline'>";

			  echo "<td class='hsc2_l' colspan=4>".get_pos($pos,1)." - ".$hofTotals[$pos]['cnt']." players</td>";

			  echo "<td class='hsc2'>".stat_format('yrs',$hofTotals[$pos]['yrs']/$hofTotals[$pos]['cnt'],0)."</td>";

			  foreach ($statArray as $key => $statlbl) 

			  {

				  $precision=0;

				  switch ($statlbl)

				  {

				  case 'ip':

				  case 'era':

				  case 'whip':

				  case 'war':

					  $precision="";

					  break;

				  }

				  echo "<td class='hsc2'>".stat_format($statlbl,$hofTotals[$pos][$statlbl]/$hofTotals[$pos]['cnt'],$precision)."</td>";

			  }

			  echo "</tr>\n";

		  }

		  echo "     <tr class='headline'>";

		  echo "<td class='hsc2_l' colspan=4>Totals - ".$hofTotals['all']['cnt']." players</td>";

		  echo "<td class='hsc2'>".stat_format('yrs',$hofTotals['all']['yrs']/$hofTotals['all']['cnt'],0)."</td>";

		  foreach ($statArray as $key => $statlbl) 

		  {

			  $precision=0;

			  switch ($statlbl)

			  {

			  case 'ip':

			  case 'era':

			  case 'whip':

			  case 'war':

				  $precision="";

				  break;

			  }

			  echo "<td class='hsc2'>".stat_format($statlbl,$hofTotals['all'][$statlbl]/$hofTotals['all']['cnt'],$precision)."</td>";

		  }

		  echo "</tr>\n";

		  echo "    </tfoot>\n";

		  unset ($hofTotals);

	  }

	  else

	  {

		  echo "     <tr><td colspan=".(5+count($statArray))." style='text-align:center;'>No hall of famers have accumulated pitching stats in this league.</td></tr>\n";

	  }



	  echo "   </table>\n";

	  echo "  </td></tr>\n";

	  echo " </table>\n";

	  echo "</div>\n";



	  break;

  }



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";



  page_foot($_SESSION['lgpath']);



?>

