<?php



####################################################

# gen_functions contents

# 

# Stat functions

#   stat_query

#   stat_text

#   stat_format

#   stat_sort

#

# Ratings functions

#   ratings_query

#   get_scale

#

# OOTP DB ID translation

#   get_award

#   get_pos

#   get_velocity

#   get_level

#   get_sim_length

#   get_hand

#

# General Purpose

#   ordinal_suffix

#   cm_to_ft_in

#   get_vote_query

#   clean_html

#   clean_bbcode

#   outputCSV

#   formatBytes

#   average

#   deviation

#

####################################################







####################################################

# stat_query

#  returns the stat formula for a one-table stat

#

# Parameters:

#  statLbl - the stat to return the query for

#  tbAbbr  - prepend the table abbreviation specified to the column names

#  qual    - for offensive rate stats, the table abbreviation of the team games table to add hitless AB's from

#  defVal  - default value for rate stats if denominator is 0

#  pos     - position to use for fielding win shares

####################################################

function stat_query($statLbl,$tbAbbr="",$qual="",$defVal="",$pos="")

{

	if ($tbAbbr!="") {$tbAbbr.=".";}



	switch ($statLbl)

	{

	case 'outs':

		$statCalc="SUM(".$tbAbbr."ab)-SUM(".$tbAbbr."h)+SUM(".$tbAbbr."cs)+SUM(".$tbAbbr."sh)+SUM(".$tbAbbr."sf)";

		break;		

	case 'ebh':

		$statCalc="SUM(".$tbAbbr."d)+SUM(".$tbAbbr."t)+SUM(".$tbAbbr."hr)";

		break;		

	case 'tb':

		$statCalc="SUM(".$tbAbbr."h)+SUM(".$tbAbbr."d)+2*SUM(".$tbAbbr."t)+3*SUM(".$tbAbbr."hr)";

		break;		

	case 'tob':

		$statCalc="SUM(".$tbAbbr."h)+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp)";

		break;		

	case 'tto':

		$statCalc="SUM(".$tbAbbr."hr)+SUM(".$tbAbbr."k)+SUM(".$tbAbbr."bb)";

		break;		

	case 'pipa':

		$statCalc="if(SUM(".$tbAbbr."pa)=0,0,SUM(".$tbAbbr."pitches_seen)/SUM(".$tbAbbr."pa))";

		break;		

	case 'abhr':

		if ($defVal=="") {$defVal=9999;}

		$statCalc="if(SUM(".$tbAbbr."hr)=0,$defVal,SUM(".$tbAbbr."ab)/SUM(".$tbAbbr."hr))";

		break;		

	case 'pahr':

		if ($defVal=="") {$defVal=9999;}

		$statCalc="if(SUM(".$tbAbbr."hr)=0,$defVal,SUM(".$tbAbbr."pa)/SUM(".$tbAbbr."hr))";

		break;		

	case 'bbk':

		$statCalc="if(SUM(".$tbAbbr."k)=0,0,SUM(".$tbAbbr."bb)/SUM(".$tbAbbr."k))";

		break;		

	case 'avg':

		$statCalc="if(SUM(".$tbAbbr."ab)=0,0,SUM(".$tbAbbr."h)/SUM(".$tbAbbr."ab))";

		if ($qual!="")

		{

			$qual=$qual.".";

			$statCalc="SUM(".$tbAbbr."h) / if(SUM(".$tbAbbr."pa)<(3.1*SUM(".$qual."g)),SUM(".$tbAbbr."ab)+(3.1*SUM(ts.g))-SUM(".$tbAbbr."pa),SUM(".$tbAbbr."ab))";

		}

		break;		

	case 'obp':

		$statCalc="if((SUM(".$tbAbbr."ab)+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp)+SUM(".$tbAbbr."sf))=0,0,(SUM(".$tbAbbr."h)+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp))/(SUM(".$tbAbbr."ab)+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp)+SUM(".$tbAbbr."sf)))";

		if ($qual!="")

		{

			$qual=$qual.".";

			$statCalc="(SUM(".$tbAbbr."h)+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp)) / (if(SUM(".$tbAbbr."pa)<(3.1*SUM(".$qual."g)),SUM(".$tbAbbr."ab)+(3.1*SUM(ts.g))-SUM(".$tbAbbr."pa),SUM(".$tbAbbr."ab))+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp)+SUM(".$tbAbbr."sf))";

		}

		break;		

	case 'slg':

		$statCalc="if(SUM(".$tbAbbr."ab)=0,0,(SUM(".$tbAbbr."h)+SUM(".$tbAbbr."d)+2*SUM(".$tbAbbr."t)+3*SUM(".$tbAbbr."hr))/SUM(".$tbAbbr."ab))";

		if ($qual!="")

		{

			$qual=$qual.".";

			$statCalc="(SUM(".$tbAbbr."h)+SUM(".$tbAbbr."d)+2*SUM(".$tbAbbr."t)+3*SUM(".$tbAbbr."hr)) / if(SUM(".$tbAbbr."pa)<(3.1*SUM(".$qual."g)),SUM(".$tbAbbr."ab)+(3.1*SUM(ts.g))-SUM(".$tbAbbr."pa),SUM(".$tbAbbr."ab))";

		}

		break;		

	case 'ops':

		$statCalc="if(SUM(".$tbAbbr."ab)=0,0,if((SUM(".$tbAbbr."ab)+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp)+SUM(".$tbAbbr."sf))=0,0,(SUM(".$tbAbbr."h)+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp))/(SUM(".$tbAbbr."ab)+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp)+SUM(".$tbAbbr."sf))+(SUM(".$tbAbbr."h)+SUM(".$tbAbbr."d)+2*SUM(".$tbAbbr."t)+3*SUM(".$tbAbbr."hr))/SUM(".$tbAbbr."ab)))";

		if ($qual!="")

		{

			$qual=$qual.".";

			$statCalc="(SUM(".$tbAbbr."h)+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp)) / (if(SUM(".$tbAbbr."pa)<(3.1*SUM(".$qual."g)),SUM(".$tbAbbr."ab)+(3.1*SUM(ts.g))-SUM(".$tbAbbr."pa),SUM(".$tbAbbr."ab))+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp)+SUM(".$tbAbbr."sf)) + (SUM(".$tbAbbr."h)+SUM(".$tbAbbr."d)+2*SUM(".$tbAbbr."t)+3*SUM(".$tbAbbr."hr)) / if(SUM(".$tbAbbr."pa)<(3.1*SUM(".$qual."g)),SUM(".$tbAbbr."ab)+(3.1*SUM(ts.g))-SUM(".$tbAbbr."pa),SUM(".$tbAbbr."ab))";

		}

		break;		

	case 'iso':

		$statCalc="if(SUM(".$tbAbbr."ab)=0,0,(SUM(".$tbAbbr."d)+2*SUM(".$tbAbbr."t)+3*SUM(".$tbAbbr."hr))/SUM(".$tbAbbr."ab))";

		break;	

	case 'rperg':

		$statCalc="if(SUM(".$tbAbbr."g)=0,0,SUM(".$tbAbbr."r)/SUM(".$tbAbbr."g))";

		break;		

	case 'bbabip':

		$statCalc="if((SUM(".$tbAbbr."ab)-SUM(".$tbAbbr."k)-SUM(".$tbAbbr."hr)+SUM(".$tbAbbr."sf))=0,0,(SUM(".$tbAbbr."h)-SUM(".$tbAbbr."hr))/(SUM(".$tbAbbr."ab)-SUM(".$tbAbbr."k)-SUM(".$tbAbbr."hr)+SUM(".$tbAbbr."sf)))";

		break;		

	case 'wOBA':

		$statCalc="if(SUM(".$tbAbbr."pa)=0,0,(0.72*SUM(".$tbAbbr."bb)+0.75*SUM(".$tbAbbr."hp)+0.9*(SUM(".$tbAbbr."h)-SUM(".$tbAbbr."d)-SUM(".$tbAbbr."t)-SUM(".$tbAbbr."hr))+0.92*0+1.24*SUM(".$tbAbbr."d)+1.56*SUM(".$tbAbbr."t)+1.95*SUM(".$tbAbbr."hr))/SUM(".$tbAbbr."pa))";

		break;	

	case 'lw':

		$statCalc="(0.47*(SUM(".$tabbr."h)-SUM(".$tabbr."d)-SUM(".$tabbr."t)-SUM(".$tabbr."hr)) + .78*SUM(".$tabbr."d) + 1.09*SUM(".$tabbr."t) + 1.4*SUM(".$tabbr."hr) + .33*(SUM(".$tabbr."bb)-SUM(".$tabbr."hp)) + .3*SUM(".$tabbr."sb) - .52*SUM(".$tabbr."cs) - .26*(SUM(".$tabbr."ab)-SUM(".$tabbr."h)-SUM(".$tabbr."gdp)) - .72*SUM(".$tabbr."gdp))";

		break;

	case 'pwrspd':

		$statCalc="if((SUM(".$tbAbbr."hr)+SUM(".$tbAbbr."sb))=0,0,(2*SUM(".$tbAbbr."hr)*SUM(".$tbAbbr."sb))/(SUM(".$tbAbbr."hr)+SUM(".$tbAbbr."sb)))";

		break;			

	case 'sbPct':

		$statCalc="if((SUM(".$tbAbbr."sb)+SUM(".$tbAbbr."cs))=0,0,SUM(".$tbAbbr."sb)/(SUM(".$tbAbbr."sb)+SUM(".$tbAbbr."cs)))";

		break;

	case 'rc':

		$statCalc="if((SUM(".$tbAbbr."ab)+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp)+SUM(".$tbAbbr."sh)+SUM(".$tbAbbr."sf))=0,0,((SUM(".$tbAbbr."h)+SUM(".$tbAbbr."bb)-SUM(".$tbAbbr."cs)+SUM(".$tbAbbr."hp)-SUM(".$tbAbbr."gdp))*(SUM(".$tbAbbr."h)+SUM(".$tbAbbr."d)+2*SUM(".$tbAbbr."t)+3*SUM(".$tbAbbr."hr)+(.26*(SUM(".$tbAbbr."bb)-SUM(".$tbAbbr."ibb)+SUM(".$tbAbbr."hp)))+(.52*(SUM(".$tbAbbr."sh)+SUM(".$tbAbbr."sf)+SUM(".$tbAbbr."sb)))))/(SUM(".$tbAbbr."ab)+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp)+SUM(".$tbAbbr."sh)+SUM(".$tbAbbr."sf)))";

		break;

	case 'rc27':

		$statCalc="(27*((SUM(".$tbAbbr."h)+SUM(".$tbAbbr."bb)-SUM(".$tbAbbr."cs)+SUM(".$tbAbbr."hp)-SUM(".$tbAbbr."gdp))*(SUM(".$tbAbbr."h)+SUM(".$tbAbbr."d)+2*SUM(".$tbAbbr."t)+3*SUM(".$tbAbbr."hr)+(.26*(SUM(".$tbAbbr."bb)-SUM(".$tbAbbr."ibb)+SUM(".$tbAbbr."hp)))+(.52*(SUM(".$tbAbbr."sh)+SUM(".$tbAbbr."sf)+SUM(".$tbAbbr."sb)))))/(SUM(".$tbAbbr."ab)+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."hp)+SUM(".$tbAbbr."sh)+SUM(".$tbAbbr."sf)))/(SUM(".$tbAbbr."ab)-SUM(".$tbAbbr."h)+SUM(".$tbAbbr."cs)+SUM(".$tbAbbr."sh)+SUM(".$tbAbbr."sf))";

		break;

	case 'ip':

		$statCalc="(SUM(".$tbAbbr."ip)+SUM(".$tbAbbr."ipf)/3)";

		break;

	case 'pk':

		$statCalc="SUM(".$tbAbbr."k)";

		break;

	case 'pbb':

		$statCalc="SUM(".$tbAbbr."bb)";

		break;

	case 'pr':

		$statCalc="SUM(".$tbAbbr."r)";

		break;

	case 'ptto':

		$statCalc="SUM(".$tbAbbr."hra)+SUM(".$tbAbbr."bb)+SUM(".$tbAbbr."k)";

		break;

	case 'era':

		$statCalc="9*SUM(".$tbAbbr."er)/(SUM(".$tbAbbr."ip)+SUM(".$tbAbbr."ipf)/3)";

		break;

	case 'whip':

		$statCalc="(SUM(".$tbAbbr."ha)+SUM(".$tbAbbr."bb))/(SUM(".$tbAbbr."ip)+SUM(".$tbAbbr."ipf)/3)";

		break;

	case 'oavg':

		$statCalc="if(SUM(".$tbAbbr."ab)=0,0,SUM(".$tbAbbr."ha)/SUM(".$tbAbbr."ab))";

		break;		

	case 'pvorp':

		$statCalc="SUM(".$tbAbbr."vorp)";

		break;

	case 'pwar':

		$statCalc="SUM(".$tbAbbr."war)";

		break;

	case 'fip':

		$statCalc="if((SUM(ip)+SUM(ipf)/3)=0,0,(13*SUM(hra)+3*SUM(bb)-2*SUM(k))/(SUM(ip)+SUM(ipf)/3)+3.2)";

		break;

	case 'erc':

		$statCalc="IF((SUM(bf)*(SUM(ip)+SUM(ipf)/3))=0,0,IF(((SUM(ha)+SUM(bb)+SUM(hp))*(.89*(1.255*(SUM(ha)-SUM(hra))+4*SUM(hra))+.56*(SUM(bb)+SUM(hp)-SUM(iw)))*9/(SUM(bf)*(SUM(ip)+SUM(ipf)/3)))<=2.24,((SUM(ha)+SUM(bb)+SUM(hp))*(.89*(1.255*(SUM(ha)-SUM(hra))+4*SUM(hra))+.56*(SUM(bb)+SUM(hp)-SUM(iw)))*9/(SUM(bf)*(SUM(ip)+SUM(ipf)/3)))*.75,((SUM(ha)+SUM(bb)+SUM(hp))*(.89*(1.255*(SUM(ha)-SUM(hra))+4*SUM(hra))+.56*(SUM(bb)+SUM(hp)-SUM(iw)))*9/(SUM(bf)*(SUM(ip)+SUM(ipf)/3)))-.56))";

		break;

	case 'kper9':

		$statCalc="9*SUM(".$tbAbbr."k)/(SUM(".$tbAbbr."ip)+SUM(".$tbAbbr."ipf)/3)";

		break;

	case 'bbper9':

		$statCalc="9*SUM(".$tbAbbr."bb)/(SUM(".$tbAbbr."ip)+SUM(".$tbAbbr."ipf)/3)";

		break;

	case 'hper9':

		$statCalc="9*SUM(".$tbAbbr."ha)/(SUM(".$tbAbbr."ip)+SUM(".$tbAbbr."ipf)/3)";

		break;

	case 'rper9':

		$statCalc="9*SUM(".$tbAbbr."r)/(SUM(".$tbAbbr."ip)+SUM(".$tbAbbr."ipf)/3)";

		break;

	case 'hrper9':

		$statCalc="9*SUM(".$tbAbbr."hra)/(SUM(".$tbAbbr."ip)+SUM(".$tbAbbr."ipf)/3)";

		break;

	case 'kperbb':

		$statCalc="if(SUM(".$tbAbbr."bb)=0,0,SUM(".$tbAbbr."k)/SUM(".$tbAbbr."bb))";

		break;

	case 'gbPct':

		$statCalc="if((SUM(".$tbAbbr."gb)+SUM(".$tbAbbr."fb))=0,0,SUM(".$tbAbbr."gb)/(SUM(".$tbAbbr."gb)+SUM(".$tbAbbr."fb)))";

		break;

	case 'cgPct':

		$statCalc="if(SUM(".$tbAbbr."gs)=0,0,SUM(".$tbAbbr."cg)/SUM(".$tbAbbr."gs))";

		break;

	case 'qsPct':

		$statCalc="if(SUM(".$tbAbbr."gs)=0,0,SUM(".$tbAbbr."qs)/SUM(".$tbAbbr."gs))";

		break;

	case 'svPct':

		$statCalc="if((SUM(".$tbAbbr."s)+SUM(".$tbAbbr."bs))=0,0,SUM(".$tbAbbr."s)/(SUM(".$tbAbbr."s)+SUM(".$tbAbbr."bs)))";

		break;

	case 'babip':

		$statCalc="(SUM(".$tbAbbr."ha)-SUM(".$tbAbbr."hra))/(SUM(".$tbAbbr."ab)-SUM(".$tbAbbr."k)-SUM(".$tbAbbr."hra)+SUM(".$tbAbbr."sf))";

		break;		

	case 'winpct':

		$statCalc="if((SUM(".$tbAbbr."w)+SUM(".$tbAbbr."l))=0,0,SUM(".$tbAbbr."w)/(SUM(".$tbAbbr."w)+SUM(".$tbAbbr."l)))";

		break;		

	case 'gmovr500':

		$statCalc="SUM(".$tbAbbr."w)-SUM(".$tbAbbr."l)";

		break;		

	case 'fgs':

		$statCalc="SUM(".$tbAbbr."gs)";

		break;		

	case 'inn':

		$statCalc="(SUM(".$tbAbbr."ip)+SUM(".$tbAbbr."ipf)/3)";

		break;		

	case 'fpct':

		$statCalc="(SUM(".$tbAbbr."po)+SUM(".$tbAbbr."a))/SUM(".$tbAbbr."tc)";

		break;		

	case 'rng':

		$statCalc="(9*(SUM(".$tbAbbr."po)+SUM(".$tbAbbr."a)))/(SUM(".$tbAbbr."ip)+SUM(".$tbAbbr."ipf)/3)";

		break;		

	case 'rtoPct':

		$statCalc="if(SUM(".$tbAbbr."sba)=0,0,SUM(".$tbAbbr."rto)/SUM(".$tbAbbr."sba))";

		break;		

	case 'ows':

		$statCalc="SUM(".$tbAbbr."ows)";

		break;

	case 'pws':

		$statCalc="SUM(".$tbAbbr."pws)";

		break;

	case 'fwsTot':

		$statCalc="SUM(".$tbAbbr."fwsTot)";

		break;

	case 'fws':

		switch ($pos)

		{

		case 2: $statCalc="SUM(".$tbAbbr."fws2)"; break;

		case 3: $statCalc="SUM(".$tbAbbr."fws3)"; break;

		case 4: $statCalc="SUM(".$tbAbbr."fws4)"; break;

		case 5: $statCalc="SUM(".$tbAbbr."fws5)"; break;

		case 6: $statCalc="SUM(".$tbAbbr."fws6)"; break;

		case 7: $statCalc="SUM(".$tbAbbr."fws7)"; break;

		case 8: $statCalc="SUM(".$tbAbbr."fws8)"; break;

		case 9: $statCalc="SUM(".$tbAbbr."fws9)"; break;

		case 'IF': $statCalc="SUM(".$tbAbbr."fws3)+SUM(".$tbAbbr."fws4)+SUM(".$tbAbbr."fws5)+SUM(".$tbAbbr."fws6)"; break;

		case 'CI': $statCalc="SUM(".$tbAbbr."fws3)+SUM(".$tbAbbr."fws5)"; break;

		case 'MI': $statCalc="SUM(".$tbAbbr."fws4)+SUM(".$tbAbbr."fws6)"; break;

		case 'OF': $statCalc="SUM(".$tbAbbr."fws7)+SUM(".$tbAbbr."fws8)+SUM(".$tbAbbr."fws9)"; break;

		default: $statCalc="SUM(".$tbAbbr."fwsTot)"; break;

		}

		break;

	case 'wsTot':

		$statCalc="SUM(".$tbAbbr."wsTot)";

		break;

	case 'black_ink':

		$statCalc="black_ink";

		break;

	case 'gray_ink':

		$statCalc="gray_ink";

		break;

	case 'hof_standards':

		$statCalc="hof_standards";

		break;

	case 'bSSdiff':

		$statCalc="1000-bat_ss_val";

		break;

	case 'pSSdiff':

		$statCalc="1000-pit_ss_val";

		break;

	case 'avgtix':

		$statCalc="AVG(".$tbAbbr."ticket_price)";

		break;

	case 'tot_revenue':

		$statCalc="SUM(".$tbAbbr."gate_revenue)+SUM(".$tbAbbr."media_revenue)+SUM(".$tbAbbr."merchandising_revenue)+SUM(".$tbAbbr."playoff_revenue)";

		break;

	case 'tot_expenses':

		$statCalc="SUM(".$tbAbbr."player_expenses)+SUM(".$tbAbbr."staff_expenses)";

		break;

	case 'profit':

		$statCalc="SUM(".$tbAbbr."gate_revenue)+SUM(".$tbAbbr."media_revenue)+SUM(".$tbAbbr."merchandising_revenue)+SUM(".$tbAbbr."playoff_revenue)-(SUM(".$tbAbbr."player_expenses)+SUM(".$tbAbbr."staff_expenses))+SUM(".$tbAbbr."revenue_sharing)";

		break;

	default:

		$statCalc="SUM(".$tbAbbr."$statLbl)";

		break;

	}

	return $statCalc;

}



####################################################

# stat_text

#  returns the stat formula for a one-table stat

#

# Parameters:

#  statLbl - the stat to return the text for

#  caps    - flag to just return label in all caps

#             1=capitalize

#             2=use standard shorthand

#  alttxt  - string to use instead of default

####################################################

function stat_text($statLbl,$caps="",$alttxt="")

{

	## String override

	if (($alttxt!="")&&(!is_numeric($alttxt))) {return $alttxt;}

	## Capitalize

	if ($caps==1) 

	{

		$statDisp=strtoupper($statLbl);

		return $statDisp;

	}

	## Shorthand

	if ($caps==2)

	{

		switch ($statLbl)

		{

		case "attendance"           : $statDisp="Att";                   break;

		case "avgtix"               : $statDisp="Tix";                   break;

		case "bbk"                  : $statDisp="BB/K";                  break;

		case "bbper9"               : $statDisp="BB/9IP";                break;

		case "bink"                 : $statDisp="Black Ink";             break;

		case "budget"               : $statDisp="Budget";                break;

		case "cgPct"                : $statDisp="CG%";                   break;

		case "d"                    : $statDisp="2B";                    break;

		case "fgs"                  : $statDisp="GS";                    break;

		case "fpct"                 : $statDisp="Pct";                   break;

		case "fws2"                 : $statDisp="C FWS";                 break;

		case "fws3"                 : $statDisp="1B FWS";                break;

		case "fws4"                 : $statDisp="2B FWS";                break;

		case "fws5"                 : $statDisp="3B FWS";                break;

		case "fws6"                 : $statDisp="SS FWS";                break;

		case "fws7"                 : $statDisp="LF FWS";                break;

		case "fws8"                 : $statDisp="CF FWS";                break;

		case "fws9"                 : $statDisp="RF FWS";                break;

		case "fwsIF"                : $statDisp="IF FWS";                break;

		case "fwsCI"                : $statDisp="CI FWS";                break;

		case "fwsMI"                : $statDisp="MI FWS";                break;

		case "fwsOF"                : $statDisp="OF FWS";                break;

		case "fwsTot"               : $statDisp="FWS Tot";               break;

		case "gate_revenue"         : $statDisp="Gate";                  break;

		case "gbPct"                : $statDisp="GB%";                   break;

		case "gink"                 : $statDisp="Gray Ink";              break;

		case "gmovr500"             : $statDisp="Gm>.500";               break;

		case "ha"                   : $statDisp="H";                     break;

		case "hper9"                : $statDisp="H/9IP";                 break;

		case "hra"                  : $statDisp="HR";                    break;

		case "hrper9"               : $statDisp="HR/9IP";                break;

		case "inn"                  : $statDisp="Inn";                   break;

		case "kper9"                : $statDisp="K/9IP";                 break;

		case "kperbb"               : $statDisp="K/BB";                  break;

		case "media_revenue"        : $statDisp="Media";                 break;

		case "merchandising_revenue": $statDisp="Merch";                 break;

		case "outs"                 : $statDisp="Outs";                  break;

		case "pahr"                 : $statDisp="PA/HR";                 break;

		case "pbb"                  : $statDisp="BB";                    break;

		case "pipa"                 : $statDisp="PS/PA";                 break;

		case "pitches_seen"         : $statDisp="PS";                    break;

		case "pk"                   : $statDisp="K";                     break;

		case "player_expenses"      : $statDisp="Players";               break;

		case "playoff_revenue"      : $statDisp="Playoffs";              break;

		case "pOdds"                : $statDisp="POdds";                 break;

		case "pr"                   : $statDisp="R";                     break;

		case "profit"               : $statDisp="Profit";                break;

		case "ptto"                 : $statDisp="TTO";                   break;

		case "pvorp"                : $statDisp="VORP";                  break;

		case "pwar"                 : $statDisp="WAR";                   break;

		case "pwrspd"               : $statDisp="PwrSpd";                break;

		case "qsPct"                : $statDisp="QS%";                   break;

		case "ra"                   : $statDisp="R";                     break;

		case "rc27"                 : $statDisp="RC/27";                 break;

		case "revenue_sharing"      : $statDisp="Rev Share";             break;

		case "rper9"                : $statDisp="R/9IP";                 break;

		case "rperg"                : $statDisp="R/G";                   break;

		case "rng"                  : $statDisp="Rng";                   break;

		case "rtoPct"               : $statDisp="RTO%";                  break;

		case "s"                    : $statDisp="SV";                    break;

		case "sbPct"                : $statDisp="SB%";                   break;

		case "svPct"                : $statDisp="SV%";                   break;

		case "staff_expenses"       : $statDisp="Staff";                 break;

		case "t"                    : $statDisp="3B";                    break;

		case "tot_revenue"          : $statDisp="Tot Rev";               break;

		case "tot_expenses"         : $statDisp="Tot Exp";               break;

		case "winpct"               : $statDisp="Win%";                  break;

		case "wOBA"                 : $statDisp="wOBA";                  break;

		case "wsTot"                : $statDisp="WS Tot";                break;

		case 'batting_ratings_overall_contact':

		case 'batting_ratings_vsl_contact':

		case 'batting_ratings_vsr_contact':

		case 'batting_ratings_talent_contact'              : $statDisp="Con";       break;

		case 'batting_ratings_overall_gap':

		case 'batting_ratings_vsl_gap':

		case 'batting_ratings_vsr_gap':

		case 'batting_ratings_talent_gap'                  : $statDisp="Gap";       break;

		case 'batting_ratings_overall_power':

		case 'batting_ratings_vsl_power':

		case 'batting_ratings_vsr_power':

		case 'batting_ratings_talent_power'                : $statDisp="Pow";       break;

		case 'batting_ratings_overall_eye':

		case 'batting_ratings_vsl_eye':

		case 'batting_ratings_vsr_eye':

		case 'batting_ratings_talent_eye'                  : $statDisp="Eye";       break;

		case 'batting_ratings_overall_strikeouts':

		case 'batting_ratings_vsl_strikeouts':

		case 'batting_ratings_vsr_strikeouts':

		case 'batting_ratings_talent_strikeouts'           : $statDisp="AvK";       break;

		case 'batting_ratings_misc_bunt'         	   : $statDisp="Bnt";       break;

		case 'batting_ratings_misc_bunt_for_hit'           : $statDisp="BnH";       break;

		case 'running_ratings_speed'                       : $statDisp="Sp";        break;

		case 'running_ratings_stealing'                    : $statDisp="Sta";       break;

		case 'running_ratings_baserunning'                 : $statDisp="BR";        break;

		case 'pitching_ratings_overall_stuff':

		case 'pitching_ratings_vsl_stuff':

		case 'pitching_ratings_vsr_stuff':

		case 'pitching_ratings_talent_stuff'               : $statDisp="Stf";       break;

		case 'pitching_ratings_overall_control':

		case 'pitching_ratings_vsl_control':

		case 'pitching_ratings_vsr_control':

		case 'pitching_ratings_talent_control'             : $statDisp="Con";       break;

		case 'pitching_ratings_overall_movement':

		case 'pitching_ratings_vsl_movement':

		case 'pitching_ratings_vsr_movement':

		case 'pitching_ratings_talent_movement'            : $statDisp="Mvmt";       break;

		case 'pitching_ratings_overall_balk':

		case 'pitching_ratings_vsl_balk':

		case 'pitching_ratings_vsr_balk':

		case 'pitching_ratings_talent_balk'            : $statDisp="Blk";       break;

		case 'pitching_ratings_overall_hp':

		case 'pitching_ratings_vsl_hp':

		case 'pitching_ratings_vsr_hp':

		case 'pitching_ratings_talent_hp'            : $statDisp="HBP";       break;

		case 'pitching_ratings_overall_wild_pitch':

		case 'pitching_ratings_vsl_wild_pitch':

		case 'pitching_ratings_vsr_wild_pitch':

		case 'pitching_ratings_talent_wild_pitch'            : $statDisp="WP";       break;

		case 'pitching_ratings_pitches_fastball'           :

		case 'pitching_ratings_pitches_talent_fastball'    : $statDisp="Fst";       break;

		case 'pitching_ratings_pitches_slider'             :

		case 'pitching_ratings_pitches_talent_slider'      : $statDisp="Sld";       break;

		case 'pitching_ratings_pitches_curveball'   :

		case 'pitching_ratings_pitches_talent_curveball'   : $statDisp="Crv";       break;

		case 'pitching_ratings_pitches_screwball'   :

		case 'pitching_ratings_pitches_talent_screwball'   : $statDisp="Scw";       break;

		case 'pitching_ratings_pitches_forkball'    :

		case 'pitching_ratings_pitches_talent_forkball'    : $statDisp="Frk";       break;

		case 'pitching_ratings_pitches_changeup'    :

		case 'pitching_ratings_pitches_talent_changeup'    : $statDisp="Chg";       break;

		case 'pitching_ratings_pitches_sinker'      :

		case 'pitching_ratings_pitches_talent_sinker'      : $statDisp="Snk";       break;

		case 'pitching_ratings_pitches_splitter'    :

		case 'pitching_ratings_pitches_talent_splitter'    : $statDisp="Spl";       break;

		case 'pitching_ratings_pitches_knuckleball' :

		case 'pitching_ratings_pitches_talent_knuckleball' : $statDisp="Knk";       break;

		case 'pitching_ratings_pitches_cutter'      :

		case 'pitching_ratings_pitches_talent_cutter'      : $statDisp="Cut";       break;

		case 'pitching_ratings_pitches_circlechange':

		case 'pitching_ratings_pitches_talent_circlechange': $statDisp="CCh";       break;

		case 'pitching_ratings_pitches_knucklecurve':

		case 'pitching_ratings_pitches_talent_knucklecurve': $statDisp="KCv";       break;

		case 'pitching_ratings_misc_stamina'               : $statDisp="Stm";       break;

		case 'pitching_ratings_misc_velocity'              : $statDisp="Velo";      break;

		case 'pitching_ratings_misc_ground_fly'            : $statDisp="GB%";       break;

		case 'pitching_ratings_misc_hold'                  : $statDisp="Hld";       break;

		case 'fielding_rating_pos1'                        : $statDisp="P";         break;

		case 'fielding_rating_pos2'                        : $statDisp="C";         break;

		case 'fielding_rating_pos3'                        : $statDisp="1B";        break;

		case 'fielding_rating_pos4'                        : $statDisp="2B";        break;

		case 'fielding_rating_pos5'                        : $statDisp="3B";        break;

		case 'fielding_rating_pos6'                        : $statDisp="SS";        break;

		case 'fielding_rating_pos7'                        : $statDisp="LF";        break;

		case 'fielding_rating_pos8'                        : $statDisp="CF";        break;

		case 'fielding_rating_pos9'                        : $statDisp="RF";        break;

		case 'fielding_ratings_catcher_arm'                : $statDisp="C Arm";     break;

		case 'fielding_ratings_catcher_ability'            : $statDisp="C Abil";    break;

		case 'fielding_ratings_infield_arm'                : $statDisp="IF Arm";    break;

		case 'fielding_ratings_infield_range'              : $statDisp="IF Rng";    break;

		case 'fielding_ratings_infield_error'              : $statDisp="IF Err";    break;

		case 'fielding_ratings_turn_doubleplay'            : $statDisp="DP";        break;

		case 'fielding_ratings_outfield_arm'               : $statDisp="OF Arm";    break;

		case 'fielding_ratings_outfield_range'             : $statDisp="OF Rng";    break;

		case 'fielding_ratings_outfield_error'             : $statDisp="OF Err";    break;

		default                     : $statDisp=strtoupper($statLbl);    break;

		}

		return $statDisp;

	}

	## Long form

	switch ($statLbl)

	{

	case "a"     : $statDisp="Assists";                  break;

	case "ab"    : $statDisp="At Bats";                  break;

	case "avg"   : $statDisp="Batting Average";          break;

	case "avgtix": $statDisp="Average Ticket";           break;

	case "babip" : $statDisp="Batting Average on Balls In Play"; break;

	case "bbabip": $statDisp="Batting Average on Balls In Play"; break;

	case "bb"    : $statDisp="Walks";                    break;

	case "bbk"   : $statDisp="Walks Per Strikeout";      break;

	case "bbper9": $statDisp="Walks/9IP";                break;

	case "bf"    : $statDisp="Batters Faced";            break;

	case "bink"  : $statDisp="Black Ink";                break;

	case "bk"    : $statDisp="Balks";                    break;

	case "bs"    : $statDisp="Blown Saves";              break;

	case "cg"    : $statDisp="Complete Games";           break;

	case "cgPct" : $statDisp="Complete Game Percentage"; break;

	case "cs"    : $statDisp="Caught Stealing";          break;

	case "d"     : $statDisp="Doubles";                  break;

	case "dp"    : $statDisp="Double Plays";             break;

	case "ebh"   : $statDisp="Extra Base Hits";          break;

	case "e"     : $statDisp="Errors";                   break;

	case "er"    : $statDisp="Earned Runs Allowed";      break;

	case "era"   : $statDisp="Earned Run Average";       break;

	case "erc"   : $statDisp="Component ERA";            break;

	case "fb"    : $statDisp="Fly Balls";                break;

	case "fgs"   : $statDisp="Games Started";            break;

	case "fip"   : $statDisp="Fielding Independant Pitching"; break;

	case "fpct"  : $statDisp="Fielding Percentage";      break;

	case "fws"   : $statDisp="Fielding Win Shares";      break;

	case "fws2"  : $statDisp="Catcher Win Shares";       break;

	case "fws3"  : $statDisp="First Base Win Shares";    break;

	case "fws4"  : $statDisp="Second Base Win Shares";   break;

	case "fws5"  : $statDisp="Third Base Win Shares";    break;

	case "fws6"  : $statDisp="Shortstop Win Shares";     break;

	case "fws7"  : $statDisp="Left Field Win Shares";    break;

	case "fws8"  : $statDisp="Center Field Win Shares";  break;

	case "fws9"  : $statDisp="Right Field Win Shares";   break;

	case "g"     : $statDisp="Games";                    break;

	case "gb"    : $statDisp="Ground Balls";             break;

	case "gbPct" : $statDisp="Ground Ball Percentage";   break;

	case "gdp"   : $statDisp="Grounded Into Double Play"; break;

	case "gf"    : $statDisp="Games Finished";           break;

	case "gink"  : $statDisp="Gray Ink";                 break;

	case "gmovr500": $statDisp="Games Over .500";        break;

	case "gs"    : $statDisp="Games Started";            break;

	case "h"     : $statDisp="Hits";                     break;

	case "ha"    : $statDisp="Hits Allowed";             break;

	case "hld"   : $statDisp="Holds";                    break;

	case "hp"    : $statDisp="Hit by Pitch";             break;

	case "hper9" : $statDisp="Hits/9IP";                 break;

	case "hr"    : $statDisp="Home Runs";                break;

	case "hra"   : $statDisp="Home Runs Allowed";        break;

	case "hrper9": $statDisp="Home Runs/9IP";            break;

	case "ibb"   : $statDisp="Intentional Walks";        break;

	case "inn"   : $statDisp="Defensive Innings";        break;

	case "ip"    : $statDisp="Innings Pitched";          break;

	case "iso"   : $statDisp="Isolated Power";           break;

	case "k"     : $statDisp="Strikeouts";               break;

	case "kper9" : $statDisp="Strikeouts/9IP";           break;

	case "kperbb": $statDisp="Strikeouts/Walk";          break;

	case "l"     : $statDisp="Losses";                   break;

	case "oavg"  : $statDisp="Opponent Average";         break;

	case "obp"   : $statDisp="On-Base Percentage";       break;

	case "ops"   : $statDisp="On-Base Plus Slugging";    break;

	case "outs"  : $statDisp="Outs";                     break;

	case "ows"   : $statDisp="Batting Win Shares";       break;

	case "pa"    : $statDisp="Plate Appearances";        break;

	case "pahr"  : $statDisp="Plate Appearances Per Home Run"; break;

	case "pb"    : $statDisp="Passed Balls";             break;

	case "pbb"   : $statDisp="Walks";                    break;

	case "pi"    : $statDisp="Pitches Thrown";           break;

	case "pipa"  : $statDisp="Pitches Seen Per PA";      break;

	case "pitches_seen": $statDisp="Pitches Seen";       break;

	case "pk"    : $statDisp="Strikeouts";               break;

	case "po"    : $statDisp="Putouts";                  break;

	case "pOdds" : $statDisp="Playoff Odds";             break;

	case "pr"    : $statDisp="Runs Allowed";             break;

	case "ptto"  : $statDisp="Three True Outcomes";      break;

	case "pvorp" : $statDisp="Value Over Repl. Player";  break;

	case "pwar"  : $statDisp="Wins Above Replacement";   break;

	case "pwrspd": $statDisp="Power-Speed Number";       break;

	case "pws"   : $statDisp="Pitching Win Shares";      break;

	case "qs"    : $statDisp="Quality Starts";           break;

	case "qsPct" : $statDisp="Quality Start Percentage"; break;

	case "r"     : $statDisp="Runs";                     break;

	case "ra"    : $statDisp="Runs Allowed";             break;

	case "rbi"   : $statDisp="Runs Batted In";           break;

	case "rc"    : $statDisp="Runs Created";             break;

	case "rc27"  : $statDisp="Runs Created Per 27 Outs"; break;

	case "rper9" : $statDisp="Runs/9IP";                 break;

	case "rng"   : $statDisp="Range Factor";             break;

	case "rperg" : $statDisp="Runs/Game";                break;

	case "rto"   : $statDisp="Runners Thrown Out";       break;

	case "rtoPct": $statDisp="Runners Thrown Out %";     break;

	case "s"     : $statDisp="Saves";                    break;

	case "sb"    : $statDisp="Stolen Bases";             break;

	case "sba"   : $statDisp="Stolen Bases Attempted";   break;

	case "sbPct" : $statDisp="Stolen Base Percentage";   break;

	case "sf"    : $statDisp="Sac Flies";                break;

	case "sh"    : $statDisp="Sac Hits";                 break;

	case "sho"   : $statDisp="Shutouts";                 break;

	case "slg"   : $statDisp="Slugging Percentage";      break;

	case "svo"   : $statDisp="Save Opportunities";       break;

	case "svPct" : $statDisp="Save Percentage";          break;

	case "t"     : $statDisp="Triples";                  break;

	case "tb"    : $statDisp="Total Bases";              break;

	case "tc"    : $statDisp="Total Chances";            break;

	case "tp"    : $statDisp="Triple Plays";             break;

	case "tto"   : $statDisp="Three True Outcomes";      break;

	case "vorp"  : $statDisp="Value Over Replacement Player"; break;

	case "w"     : $statDisp="Wins";                     break;

	case "war"   : $statDisp="Wins Above Replacmenet";   break;

	case "wp"    : $statDisp="Wild Pitches";             break;

	case "whip"  : $statDisp="Walks+Hits Per Inning";    break;

	case "winpct": $statDisp="Win-Loss %";               break;

	case "wOBA"  : $statDisp="Weighted OnBase Average";  break;

	case "ws"    : $statDisp="Win Shares";               break;

	case "zr"    : $statDisp="Zone Rating";              break;

	case 'batting_ratings_overall_contact':

	case 'batting_ratings_vsl_contact':

	case 'batting_ratings_vsr_contact':

	case 'batting_ratings_talent_contact'              : $statDisp="Contact"; break;

	case 'batting_ratings_overall_gap':

	case 'batting_ratings_vsl_gap':

	case 'batting_ratings_vsr_gap':

	case 'batting_ratings_talent_gap'                  : $statDisp="Gap";       break;

	case 'batting_ratings_overall_power':

	case 'batting_ratings_vsl_power':

	case 'batting_ratings_vsr_power':

	case 'batting_ratings_talent_power'                : $statDisp="Power";       break;

	case 'batting_ratings_overall_eye':

	case 'batting_ratings_vsl_eye':

	case 'batting_ratings_vsr_eye':

	case 'batting_ratings_talent_eye'                  : $statDisp="Eye";       break;

	case 'batting_ratings_overall_strikeouts':

	case 'batting_ratings_vsl_strikeouts':

	case 'batting_ratings_vsr_strikeouts':

	case 'batting_ratings_talent_strikeouts'           : $statDisp="Avoid K's";       break;

	case 'running_ratings_speed'                       : $statDisp="Speed";        break;

	case 'running_ratings_stealing'                    : $statDisp="Stealing";       break;

	case 'running_ratings_baserunning'                 : $statDisp="Baserunning";        break;

	case 'batting_ratings_misc_bunt'         	   : $statDisp="Bunt";       break;

	case 'batting_ratings_misc_bunt_for_hit'           : $statDisp="Bunt For Hit";       break;

	case 'pitching_ratings_overall_stuff':

	case 'pitching_ratings_vsl_stuff':

	case 'pitching_ratings_vsr_stuff':

	case 'pitching_ratings_talent_stuff'               : $statDisp="Stuff";       break;

	case 'pitching_ratings_overall_control':

	case 'pitching_ratings_vsl_control':

	case 'pitching_ratings_vsr_control':

	case 'pitching_ratings_talent_control'             : $statDisp="Contact";       break;

	case 'pitching_ratings_overall_movement':

	case 'pitching_ratings_vsl_movement':

	case 'pitching_ratings_vsr_movement':

	case 'pitching_ratings_talent_movement'            : $statDisp="Movement";       break;

	case 'pitching_ratings_overall_balk':

	case 'pitching_ratings_vsl_balk':

	case 'pitching_ratings_vsr_balk':

	case 'pitching_ratings_talent_balk'            : $statDisp="Balk";       break;

	case 'pitching_ratings_overall_hp':

	case 'pitching_ratings_vsl_hp':

	case 'pitching_ratings_vsr_hp':

	case 'pitching_ratings_talent_hp'            : $statDisp="Hit By Pitch";       break;

	case 'pitching_ratings_overall_wild_pitch':

	case 'pitching_ratings_vsl_wild_pitch':

	case 'pitching_ratings_vsr_wild_pitch':

	case 'pitching_ratings_talent_wild_pitch'            : $statDisp="Wild Pitch";       break;

	case 'pitching_ratings_pitches_fastball'           :

	case 'pitching_ratings_pitches_talent_fastball'    : $statDisp="Fastball";       break;

	case 'pitching_ratings_pitches_slider'             :

	case 'pitching_ratings_pitches_talent_slider'      : $statDisp="Slider";       break;

	case 'pitching_ratings_pitches_curveball'   :

	case 'pitching_ratings_pitches_talent_curveball'   : $statDisp="Curveball";       break;

	case 'pitching_ratings_pitches_screwball'   :

	case 'pitching_ratings_pitches_talent_screwball'   : $statDisp="Screwball";       break;

	case 'pitching_ratings_pitches_forkball'    :

	case 'pitching_ratings_pitches_talent_forkball'    : $statDisp="Forkball";       break;

	case 'pitching_ratings_pitches_changeup'    :

	case 'pitching_ratings_pitches_talent_changeup'    : $statDisp="Changeup";       break;

	case 'pitching_ratings_pitches_sinker'      :

	case 'pitching_ratings_pitches_talent_sinker'      : $statDisp="Sinker";       break;

	case 'pitching_ratings_pitches_splitter'    :

	case 'pitching_ratings_pitches_talent_splitter'    : $statDisp="Splitter";       break;

	case 'pitching_ratings_pitches_knuckleball' :

	case 'pitching_ratings_pitches_talent_knuckleball' : $statDisp="Knuckleball";       break;

	case 'pitching_ratings_pitches_cutter'      :

	case 'pitching_ratings_pitches_talent_cutter'      : $statDisp="Cutter";       break;

	case 'pitching_ratings_pitches_circlechange':

	case 'pitching_ratings_pitches_talent_circlechange': $statDisp="Circle Change";       break;

	case 'pitching_ratings_pitches_knucklecurve':

	case 'pitching_ratings_pitches_talent_knucklecurve': $statDisp="Knuckle Curve";       break;

	case 'pitching_ratings_misc_stamina'               : $statDisp="Stamina";       break;

	case 'pitching_ratings_misc_velocity'              : $statDisp="Velocity";      break;

	case 'pitching_ratings_misc_ground_fly'            : $statDisp="Groundball %";       break;

	case 'pitching_ratings_misc_hold'                  : $statDisp="Hold Runners";       break;

	case 'fielding_rating_pos1'                        : $statDisp="Position: P";         break;

	case 'fielding_rating_pos2'                        : $statDisp="Position: C";         break;

	case 'fielding_rating_pos3'                        : $statDisp="Position: 1B";        break;

	case 'fielding_rating_pos4'                        : $statDisp="Position: 2B";        break;

	case 'fielding_rating_pos5'                        : $statDisp="Position: 3B";        break;

	case 'fielding_rating_pos6'                        : $statDisp="Position: SS";        break;

	case 'fielding_rating_pos7'                        : $statDisp="Position: LF";        break;

	case 'fielding_rating_pos8'                        : $statDisp="Position: CF";        break;

	case 'fielding_rating_pos9'                        : $statDisp="Position: RF";        break;

	case 'fielding_ratings_catcher_arm'                : $statDisp="Catcher Arm";     break;

	case 'fielding_ratings_catcher_ability'            : $statDisp="Catcher Ability";    break;

	case 'fielding_ratings_infield_arm'                : $statDisp="Infield Arm";    break;

	case 'fielding_ratings_infield_range'              : $statDisp="Infield Range";    break;

	case 'fielding_ratings_infield_error'              : $statDisp="Infield Errors";    break;

	case 'fielding_ratings_turn_doubleplay'            : $statDisp="Double Play";        break;

	case 'fielding_ratings_outfield_arm'               : $statDisp="Outfield Arm";    break;

	case 'fielding_ratings_outfield_range'             : $statDisp="Outfield Range";    break;

	case 'fielding_ratings_outfield_error'             : $statDisp="Outfield Errors";    break;

	case 'attendance':

	case 'budget':

	case 'gate_revenue':

	case 'merchandising_revenue':

	case 'media_revenue':

	case 'playoff_revenue':

	case 'revenue_sharing':

	case 'tot_revenue':

	case 'player_expenses':

	case 'staff_expenses':

	case 'tot_expenses':

	case 'profit':

		$statDisp=str_replace("_"," ",$statLbl);

		$statDisp=str_replace("tot ","Total ",$statLbl);

		$statDisp=ucwords($statLbl);

		break;

	default      : $statDisp=strtoupper($statLbl);    break;

	}



	# Add identifier for long form of ratings

	if ($caps=="")

	{

		$e=explode("_",$statLbl);

		if ($e[2]=='overall') {$statDisp.=" (Ovr)";}

		elseif ($e[2]=='vsl') {$statDisp.=" (Vs L)";}

		elseif ($e[2]=='vsr') {$statDisp.=" (Vs R)";}

		elseif (($e[2]=='talent')||($e[3]=='talent')) {$statDisp.=" (Pot)";}

		elseif ($e[2]=='pitches') {$statDisp.=" (Ovr)";}

	}



	return $statDisp;

}



####################################################

# stat_format

#  returns stat value formatted to default

#

# Parameters:

#  statLbl - the stat to return the text for

#  statVal - the stat's value

#  precision - the precision to use for the stat

####################################################

function stat_format($statLbl,$statVal,$precision="")

{

	switch ($statLbl)

	{

	case "bats":

	case "throws":

		switch ($statVal)

		{

		case 1: $statVal="R"; break;

		case 2: $statVal="L"; break;

		case 3: $statVal="S"; break;

		}

		break;

	case "rc":

	case "rc27":

	case "pwrspd":

	case "pahr":

	case "inn":

	case "ip":

	case "vorp":

	case "pvorp":

	case "war":

	case "pwar":

	case 'zr':

	case "pws":

	case "ows":

	case "fws":

	case "fws2":

	case "fws3":

	case "fws4":

	case "fws5":

	case "fws6":

	case "fws7":

	case "fws8":

	case "fws9":

	case "fwsCI":

	case "fwsMI":

	case "fwsIF":

	case "fwsOF":

	case "fwsTot":

	case "wsTot":

		if ($precision=="") {$precision=1;}

		$statVal=sprintf("%.".$precision."f",$statVal);

		break;

	case "cgPct":

	case "gbPct":

	case "qsPct":

	case "sbPct":

	case "svPct":

	case "rtoPct":

		if ($precision=="") {$precision=1;}

		$statVal=sprintf("%.".$precision."f",100*$statVal);

		break;

	case "bbk":

	case "pipa":

	case "rperg":

	case "era":

	case "erc":

	case "fip":

	case "whip":

	case "kper9":

	case "bbper9":

	case "hper9":

	case "hrper9":

	case "rper9":

	case "kperbb":

	case "rng":

	case "WAR":

		if ($precision=="") {$precision=2;}

		$statVal=sprintf("%.".$precision."f",$statVal);

		break;

	case "avg":

	case "obp":

	case "slg":

	case "ops":

	case "iso":

	case "bbabip":

	case "babip":

	case "oavg":

	case "winpct":

	case "wOBA":

	case "fpct":

		if ($precision=="") {$precision=3;}

		$statVal=sprintf("%.".$precision."f",$statVal);

		if ($statVal<1) {$statVal=strstr($statVal,".");}

			break;

	case 'attendance':

		$statVal=number_format($statVal,0,".",",");

		break;

	case 'cash':

	case 'budget':

	case 'gate_revenue':

	case 'merchandising_revenue':

	case 'media_revenue':

	case 'playoff_revenue':

	case 'revenue_sharing':

	case 'tot_revenue':

	case 'player_expenses':

	case 'staff_expenses':

	case 'tot_expenses':

	case 'profit':

		$statVal="$".number_format($statVal,0,".",",");

		break;

	case 'avgtix':

		$statVal="$".number_format($statVal,2,".",",");

		break;

	case 'pitching_ratings_misc_velocity':

		$statVal=get_velocity($statVal);

		break;

	case 'pitching_ratings_misc_ground_fly':

		$statVal=number_format($statVal,0,".",",")."%";

		break;

	default:

		if (is_numeric($precision))

		{

			$statVal=sprintf("%.".$precision."f",$statVal);

		}

		break;

	}

	return $statVal;

}



####################################################

# stat_sort

#  returns the default stat sort order

#

# Parameters:

#  statLbl - the stat to return the text for

#  boolTxt - set to 1 to return logical operator

#  reverse - flag to indicate reverse order

####################################################

function stat_sort($statLbl,$boolTxt=0,$reverse=0)

{

	if ($reverse==="R") {$reverse=1;}



	switch ($statLbl)

	{

	case 'abhr':

	case 'pahr':

	case 'era':

	case 'whip':

	case 'bbper9':	   

	case 'hper9':	   

	case 'rper9':	   

	case 'hrper9':	   

	case 'babip':

	case 'cERA':

	case 'age':

	case 'lvl':

	case 'last_name':

	case 'first_name':

	case 'porder':

		$sortOrder="ASC";

		break;

	default:

		$sortOrder="DESC";

		break;

	}

	if ($reverse==1)

	{

		if ($sortOrder=="ASC") {$sortOrder="DESC";}

		else {$sortOrder="ASC";}

	}



	if ($boolTxt==1)

	{

		switch ($sortOrder)

		{

		case "ASC": $sortOrder=">=";break;

		case "DESC":$sortOrder="<=";break;

		}

	}

	return $sortOrder;

}





####################################################

# ratings_query

#  returns the standard calculation of a player rating based on scale

#

# Parameters:

#  ratLbl - the rating to return the formula for

#  scale  - the scale on which to return it

#  tbAbbr - table abbreviation to use for a ratLbl

#  zeroVal - override defaule of - for a zero'd rating

####################################################

function ratings_query($ratLbl,$scale,$tbAbbr="",$zeroVal="-")

{

	# Get Formula

	switch ($scale)

	{

	case 'Hidden':

		$text=0;

		break;

	case '2-8':

		$text="TRUNCATE(($tbAbbr$ratLbl/31)+2,0)";

		break;

	case '20-80':

		$text="TRUNCATE(($tbAbbr$ratLbl+10)/15,0)";

		$text="if($text<1,1,if($text>13,13,$text))";

		$text="5*($text)+15";

		break;

	default:

		switch ($scale)

		{

		case "1-5":   $maxRat=5;   break; 

		case "1-10":  $maxRat=10;  break;

		case "1-20":  $maxRat=20;  break;

		case "1-100"; $maxRat=100; break;

		}

		$sc=200/$maxRat;

		$text="TRUNCATE(($tbAbbr$ratLbl+$sc)/$sc,0)";

		$text="if($text<1,1,if($text>$maxRat,$maxRat,$text))";

		break;

	}



	# Zero out unneeded ratings

	switch ($ratLbl)

	{

	      case 'pitching_ratings_pitches_fastball':

   	      case 'pitching_ratings_pitches_slider':

	      case 'pitching_ratings_pitches_curveball':

   	      case 'pitching_ratings_pitches_screwball':

	      case 'pitching_ratings_pitches_forkball':

   	      case 'pitching_ratings_pitches_changeup':

	      case 'pitching_ratings_pitches_sinker':

   	      case 'pitching_ratings_pitches_splitter':

	      case 'pitching_ratings_pitches_knuckleball':

   	      case 'pitching_ratings_pitches_cutter':

	      case 'pitching_ratings_pitches_circlechange':

	      case 'pitching_ratings_pitches_knucklecurve':

	      case 'pitching_ratings_pitches_talent_fastball':

   	      case 'pitching_ratings_pitches_talent_slider':

	      case 'pitching_ratings_pitches_talent_curveball':

   	      case 'pitching_ratings_pitches_talent_screwball':

	      case 'pitching_ratings_pitches_talent_forkball':

   	      case 'pitching_ratings_pitches_talent_changeup':

	      case 'pitching_ratings_pitches_talent_sinker':

              case 'pitching_ratings_pitches_talent_splitter':

	      case 'pitching_ratings_pitches_talent_knuckleball':

	      case 'pitching_ratings_pitches_talent_cutter':

	      case 'pitching_ratings_pitches_talent_circlechange':

	      case 'pitching_ratings_pitches_talent_knucklecurve':

	      case 'pitching_ratings_misc_stamina':

    	      case 'fielding_rating_pos1':

	      case 'fielding_rating_pos2':

    	      case 'fielding_rating_pos3':

	      case 'fielding_rating_pos4':

    	      case 'fielding_rating_pos5':

	      case 'fielding_rating_pos6':

    	      case 'fielding_rating_pos7':

	      case 'fielding_rating_pos8':

    	      case 'fielding_rating_pos9':

   	      case 'fielding_ratings_catcher_arm':

	      case 'fielding_ratings_infield_arm':

	      case 'fielding_ratings_outfield_arm':

		      $text="if($tbAbbr$ratLbl=0,'$zeroVal',$text)";

		      break;

	      case 'fielding_ratings_catcher_ability':

		      $text="if(($tbAbbr$ratLbl<40) AND (fielding_rating_pos2=0),'$zeroVal',$text)";

      		      break;

	      case 'fielding_ratings_infield_range':

	      case 'fielding_ratings_infield_error':

	      case 'fielding_ratings_turn_doubleplay':

		      $text="if(($tbAbbr$ratLbl<40) AND (fielding_rating_pos3=0) AND (fielding_rating_pos4=0) AND (fielding_rating_pos5=0) AND (fielding_rating_pos6=0),'$zeroVal',$text)";

		      break;

	      case 'fielding_ratings_outfield_range':

	      case 'fielding_rating_outfield_error':

		      $text="if(($tbAbbr$ratLbl<40) AND (fielding_rating_pos7=0) AND (fielding_rating_pos8=0) AND (fielding_rating_pos9=0),'$zeroVal',$text)";

		      break;

	      case 'pitching_ratings_misc_velocity':

	      case 'pitching_ratings_misc_ground_fly':

		      $text=$tbAbbr.$ratLbl;

		      break;

	}



	return $text;

}





####################################################

# get_scale

#  returns the scale identifier for a rating

#

# Parameters:

#  ratLbl - the rating to return the formula for

####################################################

function get_scale($ratLbl)

{

	switch ($ratLbl)

	{

	case 'batting_ratings_talent_contact':

	case 'batting_ratings_talent_gap':

	case 'batting_ratings_talent_power':

	case 'batting_ratings_talent_eye':

	case 'batting_ratings_talent_strikeouts':

	case 'pitching_ratings_talent_stuff':

	case 'pitching_ratings_talent_control':

	case 'pitching_ratings_talent_movement':

	case 'pitching_ratings_pitches_talent_fastball':

	case 'pitching_ratings_pitches_talent_slider':

	case 'pitching_ratings_pitches_talent_curveball':

	case 'pitching_ratings_pitches_talent_screwball':

	case 'pitching_ratings_pitches_talent_forkball':

	case 'pitching_ratings_pitches_talent_changeup':

	case 'pitching_ratings_pitches_talent_sinker':

	case 'pitching_ratings_pitches_talent_splitter':

	case 'pitching_ratings_pitches_talent_knuckleball':

	case 'pitching_ratings_pitches_talent_cutter':

	case 'pitching_ratings_pitches_talent_circlechange':

	case 'pitching_ratings_pitches_talent_knucklecurve':

		$scale='Talents';

		break;

	case 'running_ratings_speed':

	case 'running_ratings_stealing':

	case 'running_ratings_baserunning':

	case 'fielding_rating_pos1':

	case 'fielding_rating_pos2':

	case 'fielding_rating_pos3':

	case 'fielding_rating_pos4':

	case 'fielding_rating_pos5':

	case 'fielding_rating_pos6':

	case 'fielding_rating_pos7':

	case 'fielding_rating_pos8':

	case 'fielding_rating_pos9':

	case 'pitching_ratings_misc_stamina':

	case 'fielding_ratings_catcher_arm':

	case 'fielding_ratings_catcher_ability':

	case 'fielding_ratings_infield_arm':

	case 'fielding_ratings_infield_range':

	case 'fielding_ratings_infield_error':

	case 'fielding_ratings_turn_doubleplay':

	case 'fielding_ratings_outfield_arm':

	case 'fielding_ratings_outfield_range':

	case 'fielding_rating_outfield_error':

		$scale='Others';

		break;

	default:

		$scale='Ratings';

		break;

	}

	return $scale;

}





####################################################

# get_award

#  returns the name or abbreviation of an award

#

# Parameters:

#  awid - the award ID

#  abbr - set to 1 to return the abbreviation

####################################################

function get_award($awid,$abbr="",$pos=0)

 {

    switch ($awid)

     {

       case 0:

         if ($abbr==1) {$txt="POW";} else {$txt="Player of the Week";}

	 break;

       case 1:

         if ($abbr==1) {$txt="POM";} else {$txt="Pitcher of the Month";}

         break;

       case 2:

         if ($abbr==1) {$txt="BOM";} else {$txt="Batter of the Month";}

         break;

       case 3:

         if ($abbr==1) {$txt="ROM";} else {$txt="Rookie of the Month";}

         break;

       case 4:

         if ($abbr==1) {$txt="POY";} else {$txt="Oustanding Pitcher";}

         break;

       case 5:

         if ($abbr==1) {$txt="MVP";} else {$txt="Most Valuable Player";}

         break;

       case 6:

         if ($abbr==1) {$txt="ROY";} else {$txt="Oustanding Rookie";}

         break;

       case 7:

         if ($abbr==1) {$txt="GG";} else {$txt="Gold Glove";}

         break;

       case 8:  //Custom Award

         $txt=$awid;

         break;

       case 9:

         if ($abbr==1) {$txt="AS";} else {$txt="All-Star";}

         break;

       case 11:

         if ($abbr==1) {$txt="SS";} else {$txt="Silver Slugger";}

         break;

       case 13:

         if ($abbr==1) {$txt="RPoY";} else {$txt="Reliever of the Year";}

         break;

       case 15:

		 switch ($pos)

		 {

			 case 2:

				if ($abbr==1) {$txt="LDS MVP";} else {$txt="League Divisional Series Most Valuable Player";}

				break;

			 case 1:

				if ($abbr==1) {$txt="LCS MVP";} else {$txt="League Championship Series Most Valuable Player";}

				break;

			 case 0:

				if ($abbr==1) {$txt="WS MVP";} else {$txt="World Series Most Valuable Player";}

				break;

		 }

         break;

       default:

         $txt=$awid." not found";

	 break;

     }

    return $txt;

 }





####################################################

# get_pos

#  returns the name or abbreviation of a position

#

# Parameters:

#  pos - position

#  abbr - set to 1 to return the abbreviation

#  pluralize - set to 1 to pluralize the text

####################################################

function get_pos($pos,$abbr="",$pluralize="")

 {

   switch ($pos)

    {

      case 1:

        if ($abbr==1) {$txt="P";} else {$txt="Pitcher";}

	break;

      case 2:

        if ($abbr==1) {$txt="C";} else {$txt="Catcher";}

	break;

      case 3:

        if ($abbr==1) {$txt="1B";} else {$txt="First Base";}

	break;

      case 4:

        if ($abbr==1) {$txt="2B";} else {$txt="Second Base";}

	break;

      case 5:

        if ($abbr==1) {$txt="3B";} else {$txt="Third Base";}

	break;

      case 6:

        if ($abbr==1) {$txt="SS";} else {$txt="Shortstop";}

	break;

      case 7:

        if ($abbr==1) {$txt="LF";} else {$txt="Left Field";}

	break;

      case 8:

        if ($abbr==1) {$txt="CF";} else {$txt="Center Field";}

	break;

      case 9:

        if ($abbr==1) {$txt="RF";} else {$txt="Right Field";}

	break;

      case 10:

        if ($abbr==1) {$txt="DH";} else {$txt="Designated Hitter";}

	break;

      case 11:

      case 'SP':

        if ($abbr==1) {$txt="SP";} else {$txt="Starting Pitcher";}

	break;

      case 12:

      case 'MR':

        if ($abbr==1) {$txt="MR";} else {$txt="Middle Relief";}

	break;

      case 13:

      case 'CL':

        if ($abbr==1) {$txt="CL";} else {$txt="Closer";}

	break;

      case 20:

      case 'OF':

        if ($abbr==1) {$txt="OF";} else {$txt="Outfield";}

	break;

      case 21:

      case 'RP':

        if ($abbr==1) {$txt="RP";} else {$txt="Relief Pitcher";}

	break;

      case 'IF':

        if ($abbr==1) {$txt="IF";} else {$txt="Infield";}

	break;

      case 'MI':

        if ($abbr==1) {$txt="MI";} else {$txt="Middle Infield";}

	break;

      case 'CI':

        if ($abbr==1) {$txt="CI";} else {$txt="Corner Infield";}

	break;

      default:

        $txt="-";

	break;

    }



   if ((is_numeric($pos))&&($pos==0))

   {

	   if ($abbr==1) {$txt="PH";} else {$txt="Pinch Hitter";}

   }



   if (($pluralize==1)&&($abbr==1)) {$txt.="'s";}

   elseif ($pluralize==1)

   {

	   switch ($pos)

	   {

	   case 3:

	   case 4:

	   case 5:

		   $txt.="men";

		   break;

	   case 7:

	   case 8:

	   case 9:

	   case 20:

	   case 'IF':

	   case 'MI':

	   case 'CI':

	   case 'OF':

		   $txt.="ers";

		   break;

	   case 12:

	   case 'MR':

		   $txt="Middle Relievers";

		   break;

	   default:

		   $txt.="s";

		   break;

	   }

   }



   return $txt;

 }





####################################################

# get_velocity

#  returns the translated velocity

#

# Parameters:

#  velo - the internal velocity value

####################################################

function get_velocity($velo)

{

	switch ($velo)

     	{

	case 1:  $txt="<75 Mph";    break;

   	case 2:  $txt="81-83 Mph";  break;

	case 3:  $txt="82-84 Mph";  break;

   	case 4:  $txt="83-85 Mph";  break;

	case 5:  $txt="84-86 Mph";  break;

   	case 6:  $txt="85-87 Mph";  break;

	case 7:  $txt="86-88 Mph";  break;

   	case 8:  $txt="87-89 Mph";  break;

	case 9:  $txt="89-90 Mph";  break;

   	case 10: $txt="90-92 Mph";  break;

	case 11: $txt="91-93 Mph";  break;

   	case 12: $txt="92-94 Mph";  break;

	case 13: $txt="93-95 Mph";  break;

   	case 14: $txt="94-96 Mph";  break;

	case 15: $txt="95-97 Mph";  break;

   	case 16: $txt="96-98 Mph";  break;

	case 17: $txt="97-99 Mph";  break;

   	case 18: $txt="98-100 Mph"; break;

	case 19: $txt="99-101 Mph"; break;

   	case 20: $txt="101+ Mph";   break;

	}

      	return $txt;

}





####################################################

# get_level

#  returns the league level

#

# Parameters:

#  lvl - the internal level ID

####################################################

function get_level($lvl)

{

	switch ($lvl)

	{

	case 0:

  	case 1: $txt="ML"; break;

	case 2: $txt="AAA"; break;

  	case 3: $txt="AA"; break;

	case 4: $txt="A"; break;

  	case 5: $txt="SS"; break;

	case 6: $txt="R"; break;

	case 7: $txt="IND"; break;

	case 8: $txt="INT"; break;

	case 9: $txt="WL"; break;

  	case 10: $txt="COL"; break;

	case 11: $txt="HS"; break;

  	default: $txt=$lvl; break;

	}

	return $txt;

}





####################################################

# get_sim_length

#  returns the league level

#

# Parameters:

#  adminpath - the path to the sql files

#  lgid      - the league ID for which to request the information

####################################################

function get_sim_length($adminpath,$lgid)

{

	include($adminpath."/dbopen.php");

	

	$query="SELECT * FROM ootp_sql_admin WHERE scope IN ('ALL','$lgid') AND setting LIKE '%Len%';";

      	$result=mysqli_query($db,$query);

	if (mysqli_num_rows($result)) 

      	{

		while ($row=mysqli_fetch_array($result))

      		{

			$field=$row['setting'];

      			$val=$row['value'];

	      

			switch ($field)

			{

      			case 'calcLength'   : $calcLength=$val;   break;

			case 'autoSimLength': $autoSimLength=$val;break;

			case 'simLength'    : $simLength=$val;    break;

			case 'simLenAdj'    : $simLenAdj=$val;    break;

			}

      		}

	}



	# Get defined sim length

	if ($autoSimLength==1)

    	{

		$simLen=$calcLength+$simLenAdj;

		if (($simLen=="") || ($simLen==0)) {$simLen=$simLength;}

		else {$simLen++;}

	}

    	else {$simLen=$simLength;}



	# Default to 10 days	

	if (($simLen=="") || ($simLen==0)) {$simLen=10;}



	mysqli_close($db);



	return $simLen;

}





####################################################

# get_hand

#  returns the handedness of a player based on OOTP internal ID

#

# Parameters:

#  handID - the OOTP internal id for handedness

####################################################

function get_hand($handID)

{

      	switch ($handID)

	{

   	case 3: $hand="S"; break;

	case 2: $hand="L"; break;

   	case 1: $hand="R"; break;

	default: $hand="U"; break;

     	}

	return $hand;

}



####################################################

# get_ll_cat

#  translates a league leader category ID to text

#

# Parameters:

#  catID  - the OOPT category ID

#  altNm  - flag to return alternate translation from default

#            1 = StatsLab internal abbreviation

####################################################

function get_ll_cat($catID,$altNm="")

{

	switch ($altNm)

	{

	case 1:

		switch ($catID)

	    	{

			## Batter Stats

			case 0: $txt="gs"; break;

			case 1: $txt="pa"; break;

		  	case 2: $txt="ab"; break;

			case 3: $txt="h"; break;

		  	case 4: $txt="k"; break;

			case 5: $txt="tb"; break;

		  	case 6: $txt="d"; break;

			case 7: $txt="t"; break;

		  	case 8: $txt="hr"; break;

			case 9: $txt="sb"; break;

		  	case 10: $txt="rbi"; break;

			case 11: $txt="r"; break;

		  	case 12: $txt="bb"; break;

			case 13: $txt="ibb"; break;

		  	case 14: $txt="hp"; break;

			case 15: $txt="sh"; break;

		  	case 16: $txt="sf"; break;

			case 17: $txt="ebh"; break;

		  	case 18: $txt="avg"; break;

			case 19: $txt="obp"; break;

		  	case 20: $txt="slg"; break;

			case 21: $txt="rc"; break;

		  	case 22: $txt="rc27"; break;

			case 23: $txt="iso"; break;

		  	case 24: $txt="tavg"; break;

			case 25: $txt="ops"; break;

		  	case 26: $txt="wRC+"; break;

			case 58: $txt="WAR"; break;

		  

			## Pitcher Stats

			case 27: $txt="g"; break;

		  	case 28: $txt="gs"; break;

			case 29: $txt="w"; break;

		  	case 30: $txt="l"; break;

			case 31: $txt="winpct"; break;

		  	case 32: $txt="s"; break;

			case 33: $txt="hld"; break;

		  	case 34: $txt="ip"; break;

			case 35: $txt="bf"; break;

		  	case 36: $txt="hra"; break;

			case 37: $txt="bb"; break;

		  	case 38: $txt="k"; break;

			case 39: $txt="wp"; break;

		  	case 40: $txt="era"; break;

			case 41: $txt="babip"; break;

		  	case 42: $txt="whip"; break;

			case 43: $txt="kperbb"; break;

		  	case 44: $txt="rper9"; break;

			case 45: $txt="hrper9"; break;

		  	case 46: $txt="hper9"; break;

			case 47: $txt="bbper9"; break;

		  	case 48: $txt="kper9"; break;

			case 49: $txt="vorp"; break;

		  	case 50: $txt="r"; break;

			case 51: $txt="gf"; break;

		  	case 52: $txt="qs"; break;

			case 53: $txt="qsPct"; break;

		  	case 54: $txt="cg"; break;

			case 55: $txt="cgPct"; break;

		  	case 56: $txt="sho"; break;

			case 57: $txt="gbPct"; break;

			case 59: $txt="WAR"; break;



		  	default: $txt=$catID; break;

		}	 

		break;

	default:

		switch ($catID)

	    	{

			## Batter Stats

			case 0: $txt="GS"; break;

			case 1: $txt="PA"; break;

		  	case 2: $txt="AB"; break;

			case 3: $txt="H"; break;

		  	case 4: $txt="K"; break;

			case 5: $txt="TB"; break;

		  	case 6: $txt="2B"; break;

			case 7: $txt="3B"; break;

		  	case 8: $txt="HR"; break;

			case 9: $txt="SB"; break;

		  	case 10: $txt="RBI"; break;

			case 11: $txt="R"; break;

		  	case 12: $txt="BB"; break;

			case 13: $txt="IBB"; break;

		  	case 14: $txt="HBP"; break;

			case 15: $txt="SH"; break;

		  	case 16: $txt="SF"; break;

			case 17: $txt="EBH"; break;

		  	case 18: $txt="AVG"; break;

			case 19: $txt="OBP"; break;

		  	case 20: $txt="SLG"; break;

			case 21: $txt="RC"; break;

		  	case 22: $txt="RC/27"; break;

			case 23: $txt="ISO"; break;

		  	case 24: $txt="TAVG"; break;

			case 25: $txt="OPS"; break;

		  	case 26: $txt="wRC+"; break;

			case 58: $txt="WAR"; break;

		  

			## Pitcher Stats

			case 27: $txt="G"; break;

		  	case 28: $txt="GS"; break;

			case 29: $txt="W"; break;

		  	case 30: $txt="L"; break;

			case 31: $txt="Win%"; break;

		  	case 32: $txt="SV"; break;

			case 33: $txt="HLD"; break;

		  	case 34: $txt="IP"; break;

			case 35: $txt="BF"; break;

		  	case 36: $txt="HRA"; break;

			case 37: $txt="BB"; break;

		  	case 38: $txt="K"; break;

			case 39: $txt="WP"; break;

		  	case 40: $txt="ERA"; break;

			case 41: $txt="BABIP"; break;

		  	case 42: $txt="WHIP"; break;

			case 43: $txt="K/BB"; break;

		  	case 44: $txt="RA/9IP"; break;

			case 45: $txt="HR/9IP"; break;

		  	case 46: $txt="H/9IP"; break;

			case 47: $txt="BB/9IP"; break;

		  	case 48: $txt="K/9IP"; break;

			case 49: $txt="VORP"; break;

		  	case 50: $txt="RA"; break;

			case 51: $txt="GF"; break;

		  	case 52: $txt="QS"; break;

			case 53: $txt="QS%"; break;

		  	case 54: $txt="CG"; break;

			case 55: $txt="CG%"; break;

		  	case 56: $txt="SHO"; break;

			case 57: $txt="GB%"; break;

			case 59: $txt="WAR"; break;



		  	default: $txt=$catID; break;

		}	 

		break;

	}	

     	return $txt;

}





####################################################

# log5WinPct

#  returns the odds of a home win based on log 5 win percentage

#

# Parameters:

#  homeWpct - the home team's win percentage

#  awayWpct - the away team's win percentage

####################################################

function log5WinPct($homeWpct=0,$awayWpct=0)

{

	if (($homeWpct==0) && ($awayWpct==0)) {return 0;}

	$homeChc=($homeWpct-$homeWpct*$awayWpct)/($homeWpct+$awayWpct-2*$homeWpct*$awayWpct);

	return $homeChc;

}



####################################################

# ordinal_suffix

#  returns a number with ordinal suffix attached

#

# Parameters:

#  value - the number to add the suffix to

#  sup   - set to 1 to add superscript tags around suffix

####################################################

function ordinal_suffix($value, $sup = 0) {

    if(substr($value, -2, 2) == 11 || substr($value, -2, 2) == 12 || substr($value, -2, 2) == 13){

        $suffix = "th";

    }

    else if (substr($value, -1, 1) == 1){

        $suffix = "st";

    }

    else if (substr($value, -1, 1) == 2){

        $suffix = "nd";

    }

    else if (substr($value, -1, 1) == 3){

        $suffix = "rd";

    }

    else {

        $suffix = "th";

    }

    if($sup){

        $suffix = "<sup>" . $suffix . "</sup>";

    }

    return $value . $suffix;

}





####################################################

# cm_to_ft_in

#  converts centimeters to feet & inches

#

# Parameters:

#  len   - the number of centimeters to convert

####################################################

function cm_to_ft_in($len)

{

     	$in=$len/2.54;

	$ft=floor($in/12);

     	$in=$in%12;

	$in=round($in);

     	$txt=$ft."' ".$in."\"";

	return $txt;

}





####################################################

# get_vote_query

#  gets the vote scoring component of a query based on number of votes

#

# Parameters:

#  votes - the number of votes for the award in question

####################################################

function get_vote_query($votes)

{

	$txt="";

	switch ($votes)

	{

	case 10: $txt="if(vote=1,14,11-vote)"; break;

	case 5: $txt="if(vote=1,10,if(vote=2,7,if(vote=3,4,if(vote=4,2,1))))"; break;

	case 3: $txt="if(vote=1,5,if(vote=2,3,1))"; break;

	default: $txt="1"; break;

	}

	return $txt;

}



####################################################

# clean_html

#  allows display of certain HTML tags

#

# Parameters:

#  text - the htmlspecialchars'd string

####################################################

function clean_html($text)

{

	$text=str_replace("&lt;b&gt;","<b>",$text);

	$text=str_replace("&lt;/b&gt;","</b>",$text);

	$text=str_replace("&lt;i&gt;","<i>",$text);

	$text=str_replace("&lt;/i&gt;","</i>",$text);

	$text=str_replace("&lt;u&gt;","<u>",$text);

	$text=str_replace("&lt;/u&gt;","</u>",$text);

	return $text;

}



####################################################

# clean_bbcode

#  converts bbcode to HTML tags

#

# Parameters:

#  text - the htmlspecialchars'd string

####################################################

function clean_bbcode($text)

{

	$text=str_replace("[b]","<b>",$text);

	$text=str_replace("[/b]","</b>",$text);

	$text=str_replace("[i]","<i>",$text);

	$text=str_replace("[/i]","</i>",$text);

	$text=str_replace("[u]","<u>",$text);

	$text=str_replace("[/u]","</u>",$text);

	return $text;

}



####################################################

# outputCSV

#  outputs an array to CSV format for immediate download

#

# Parameters:

#  data - the arry to send to CSV output

####################################################

function outputCSV($data)

{

	$outstream = fopen("php://output", "w");

	function __outputCSV(&$vals, $key, $filehandler)

	{

		fputcsv($filehandler, $vals); // add parameters if you want

	}

	array_walk($data, "__outputCSV", $outstream);  

	fclose($outstream); 

} 



####################################################

# formatBytes

#  converts number (bytes) into formatted text for display

#

# Parameters:

#  bytes     - integer value to convert to formatted bytes

#  precision - precision to which to round the result

####################################################

function formatBytes($bytes, $precision = 1) { 

    $units = array('B', 'KB', 'MB', 'GB', 'TB'); 

   

    $bytes = max($bytes, 0); 

    $pow = floor(($bytes ? log($bytes) : 0) / log(1024)); 

    $pow = min($pow, count($units) - 1); 

   

    $bytes /= pow(1024, $pow); 

   

    return round($bytes, $precision) . ' ' . $units[$pow]; 

}



####################################################

# average

#  calculates the average value in a numeric array

#

# Parameters:

#  array     - the arry to process

####################################################

function average($array)

{

	$sum   = array_sum($array);

	$count = count($array);

	return $sum/$count;

}



####################################################

# deviation

#  calculates the standard deviation of the values in a numeric array

#

# Parameters:

#  array     - the arry to process

####################################################

function deviation($array) 

{

	$avg = average($array);

	foreach ($array as $value)

	{

		$variance[] = pow($value-$avg, 2);

	}

	$deviation = sqrt(average($variance));

	return $deviation;

}



?>