<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgpath=$_SESSION['lgpath'];

  $lgid=$_SESSION['lgid'];



  # Get Settings

  include($_SESSION['adminpath']."/dbopen.php");

  $query="SELECT setting,value FROM ootp_sql_admin WHERE scope='ALL' AND setting IN ('expfilenm','lgfile','expfile','renameFiles')";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

	  while ($row=mysqli_fetch_array($result))

	  {

		  $setting=$row['setting'];

		  $value=$row['value'];



		  switch ($setting)

		  {

		  case 'expfilenm'   : $lgfname=$value;      break;

      		  case 'lgfile'      : $lg_file_path=$value; break;

		  case 'expfile'     : $export_path=$value;  break;

      		  case 'renameFiles' : $renameFiles=$value;  break;

		  }

	  }

  }

  mysqli_close($db);



  # Title Bar

  $title='Export Tracker';



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");



  ## Get League File Info

  echo "  <div class='textbox' style='width:100%;'>\n";

  $e=explode(".",$lgfname);

  if (count($e)>1) {$lgfilepath=$lg_file_path."/".$lgfname;} else {$lgfilepath=$lg_file_path."/".$lgfname.".tar.gz";}



  $h=explode(":",$lg_file_path);

  ## Remotely hosted

  if ($h[0]=='http')

  {

	  $ch = curl_init($lgfilepath);

	  curl_setopt($ch, CURLOPT_NOBODY, true);

	  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

	  curl_setopt($ch, CURLOPT_FILETIME, true); 

	  curl_exec($ch);

	  $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.



	  if ($retcode==200)

	  {

		  $lgftime = curl_getinfo($ch, CURLINFO_FILETIME);

		  $text="League File Updated: ".date("l F j, Y H:i:s T",$lgftime);

		  echo "   <table cellpadding=2 cellspacing=0 border=0 width='935px'><tr class='title'><td>$text</td></tr></table>\n";

		  echo "  </div>\n";

	  }

	  else

	  {

		  $text="ERROR: No League File Found at: \"$lgfilepath\" <br/> $fpath";

		  echo "   <p class='error'>$text</p>\n";

		  echo "  </div>\n";

		  echo " </div>   <!-- END contentpane DIV -->\n";

		  page_foot($_SESSION['lgpath']);

		  exit;

	  }



	  curl_close($ch);

  }



  ## Locally defined

  else

  {

	  if (file_exists($lgfilepath))

	  {

		  $lgftime=filemtime($lgfilepath);

		  $text="League File Updated: ".date("l F j, Y H:i:s T",$lgftime);

		  echo "   <table cellpadding=2 cellspacing=0 border=0 width='935px'><tr class='title'><td>$text</td></tr></table>\n";

		  echo "  </div>\n";

	  }

	  else

	  {

		  $text="ERROR: No League File Found at: \"$lgfilepath\" <br/> $fpath";

		  echo "   <p class='error'>$text</p>\n";

		  echo "  </div>\n";

		  echo " </div>   <!-- END contentpane DIV -->\n";

		  page_foot($_SESSION['lgpath']);

		  exit;

	  }

  }



  ## Get Human Controlled Leagues

  $query="SELECT DISTINCT l.league_id,l.name FROM leagues as l,human_managers as hm WHERE l.league_id=hm.league_id AND hm.team_id!=0 ORDER BY league_id;";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

       	  while ($row=mysqli_fetch_array($result))

	  {

	    	  $lid=$row['league_id'];

		  $leagues[$lid]=$lid;

	    	  $leaguenames[$lid]=$row['name'];

	  }

  }

  

  if (!isset($leagues)) 

  {

       	  echo "  <p>No human controlled teams</p>\n";

	  echo " </div>   <!-- END contentpane DIV -->\n";

	  page_foot($_SESSION['lgpath']);

	  exit;

  }



  ## Dispaly Results

  asort($leagues);

  foreach ($leagues as $lid=>$val)

  {

       	  $lname=$leaguenames[$lid];

	  # Get Team Info

	  $query="SELECT t.team_id,t.name as city,t.abbr,t.nickname,t.logo_file_name,sl.name as sub_league,d.name as division FROM teams as t,team_relations as tr,sub_leagues as sl,divisions as d WHERE t.league_id=$lid AND t.team_id=tr.team_id AND tr.division_id=d.division_id AND t.league_id=d.league_id AND t.sub_league_id=d.sub_league_id AND tr.sub_league_id=d.sub_league_id AND t.league_id=sl.league_id AND t.sub_league_id=sl.sub_league_id ORDER BY sl.sub_league_id,d.division_id,t.team_id;";

	  $result=mysqli_query($db,$query);

       	  echo "   <div class='textbox'>\n";

	  echo "   <table cellpadding=2 cellspacing=0 border=0 width='935px';>\n";

       	  echo "    <tr class='title'><td>".$lname."</td></tr>\n";

	  $lgcnt=0;

       	  $divcnt=0;

	  $tcnt=0;

       	  while ($row=mysqli_fetch_array($result))

	  {

	    	  $tid=$row['team_id'];

		  $tfull=$row['city']." ".$row['nickname'];

	    	  $logo=urlencode($row['logo_file_name']);

		  $exptime=getExport($tid,$lgftime,$export_path,$renameFiles);

	    	  $e=explode("^",$exptime);

		  $exptime=$e[0];

	    	  $expstat=$e[1];

		  $expmsg=date("l F j, Y H:i:s T",$exptime);

	    	  if ($exptime==0) {$expmsg="No export";}

		  else

	   	  {

			  if ($expstat==1) {$expmsg="<span style='color:#339933;'>".$expmsg."<br />New Export</span>";}

			  else {$expmsg="<span style='color:#AA3333;'>".$expmsg."<br />Old Export</span>";}

		  }



		  $sl=$row['sub_league'];

	    	  if ($sl!=$prevSl)

		  {

		 	  if ($lgcnt>0) 

			  {

		      		  echo "\n     </table>\n";

				  echo "    </div>\n";

		      		  echo "   </td></tr>\n";

			  }

		 	  echo "   <tr class='headline'><td class='hsc2_l'>$sl</td></tr>\n";

			  echo "   <tr><td>\n";

		 	  echo "    <div class='tablebox'>\n";

			  echo "     <table cellpadding=5 cellspacing=0 width='915px'>\n";

		 	  $tcnt=0;

			  $divcnt=0;

		 	  $lgcnt++;

		  }

	    	  $div=$row['division'];

		  if ($div!=$prevDiv)

	   	  {

			  if ($divcnt>0) {echo "</tr>\n";}

		 	  echo "      <tr class='title'><td colspan=6>$div</td></tr>\n";

			  $tcnt=0;

		 	  $divcnt++;

		  }

	    	  if ($tcnt==0) {echo "      <tr>";}

		  echo "<td width='43px' valign='top'><img src='$lgpath/images/team_logos/".str_replace(".png","_40.png",$logo)."' style='width:40px;height:40px;'/></td>";

	    	  echo "<td width='262px' valign='top'><a href='$lgpath/teams/team_$tid.html'>$tfull</a><br />";

		  echo "$expmsg</td>";

	    	  if ($tcnt==2) {echo "</tr>\n";$tcnt=-1;}

		  $prevDiv=$div;

	    	  $prevSl=$sl;

		  $tcnt++;

      	  }

	  echo "     </table>\n";

       	  echo "    </div>\n";

	  echo "   </td></tr></table>\n";

       	  echo "   </div>\n";

  }



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);









#########################################

# getExport

#  - checks for a team's export file

#########################################

function getExport($team_id="",$lgftime=0,$export_path,$rename=0)

 {

   if ($team_id=="") {return -1;}

   if ($export_path=="") {return "";}



   $new=0;

   $time=0;



   $chk="team_".$team_id.".ootp";



   $h=explode(":",$export_path);

   ## Remotely hosted

   if ($h[0]=='http')

   {

	   $expfilepath =$export_path ."/".$chk;



	   //Check for base file

	   $ch = curl_init($expfilepath);

 	   curl_setopt($ch, CURLOPT_NOBODY, true);

	   curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

 	   curl_setopt($ch, CURLOPT_FILETIME, true); 

	   curl_exec($ch);

 	   $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // $retcode > 400 -> not found, $retcode = 200, found.

 	   if ($retcode==200)

	   {

		   $ftime = curl_getinfo($ch, CURLINFO_FILETIME);

		   if ($rename==1) {return $ftime."^1";}

		   elseif ($time>$lgftime) {return $ftime."^1";}

		   elseif ($ftime>$time) {$time=$ftime;}

	   }



	   curl_close($ch);

   }

 

   ## Locally defined

   else

   {

	   if ($dir = opendir($export_path))

	   {

	     	   while (false != ($file = readdir($dir)))

		   {

		  	   if (substr_count($file,$chk)==0) {continue;}

			   $ftime=filemtime($export_path."/".$file);

		  	   if ((substr_count($file,".imported")==0)&&($rename==1)) {return $ftime."^1";}

			   elseif ((substr_count($file,".imported")==0)&&($ftime>$lgftime)) {return $ftime."^1";}

		  	   elseif ($ftime>$time) {$time=$ftime;}

		   }

       	   }

   }	



   if ($rename!=1)

   {

	   if ($time>$lgftime) {$new=1;}

   }

   

   return $time."^".$new;

 }







?>

