<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $date=new Date($_SESSION['lgdate']);

  $lgyear=$date->format("Y");

  $hmid=$_SESSION['user_id'];

  

  ################## PAGE INITIALIZATION #########################

  $title='Draft Pool Import';



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($_SESSION['lgid'],$_SESSION['lgpath'],$title);



  if ($_SESSION['user_is_commish']!=1)

  {

	  echo " </div>   <!-- END topbar DIV -->\n";

	  echo " <div id='contentpane'>\n";

	  echo "You must be a commisioner to access this page";

	

	  ################## END OF PAGE #########################

	  echo " </div>   <!-- END contentpane DIV -->\n";

	  page_foot($_SESSION['lgpath']);

	  exit;

  }

  else

  {

	  nav_toolbar('admin','Admin Pages');

	  nav_toolbar("draft","Draft");

	  echo " </div>   <!-- END topbar DIV -->\n";

	  echo " <div id='contentpane'>\n";

  }



  ################## START OF PAGE CONTENT #########################

  $target = "./uploads/"; 

  $target = $target . "draft_pool_$lgid.csv" ; 

  $ok=1; 

 

  //This is our size condition 

  if ($uploaded_size > 350000) 

  { 

	  echo "Your file is too large.<br/>\n"; 

	  $ok=0; 

  } 

 

  //This is our limit file type condition 

  $validTypes=Array("text/csv","text/comma-separated-values","application/vnd.ms-excel","text/plain","application/octet-stream");

  $uploaded_type=$_FILES['uploaded']['type'];

  $e=explode(".",$_FILES['uploaded']['name']);

  $lastIdx=count($e)-1;

  $ext=strtolower($e[$lastIdx]);

  if ((!in_array($uploaded_type,$validTypes))||($ext!="csv"))

  { 

	  echo "Only *.csv files are permitted, but you have uploaded a file of type \"".$uploaded_type."\" with a *.$ext extension.<br/> Please note that you may receive this error message if you have the file open while uploading.<br/>\n"; 

	  $ok=0; 

  } 

 

  //Here we check that $ok was not set to 0 by an error 

  if ($ok==0) 

  { 

	  Echo "Sorry your file was not uploaded<br/>\n"; 

  } 

  

  //If everything is ok we try to upload it 

  else 

  { 

	  if(move_uploaded_file($_FILES['uploaded']['tmp_name'], $target)) 

	  { 

		  // Set file to read only (with write for owner)

		  chmod($target, 0644);

		  

		  echo "The file ". basename( $_FILES['uploadedfile']['name']). " has been uploaded and renamed draft_pool_$lgid.csv<br/>\n"; 



		  // Read file and import to database

		  include($_SESSION['adminpath']."/dbopen.php");



		  //open the csv file for reading

		  $handle = fopen($target, 'r');



		  $cnt=1;

		  $query="";

		  while (($data = fgetcsv($handle, 1000, ',')) !== FALSE)

		  {



			  // do your thing

			  $pid=mysqli_real_escape_string($db,$data[0]);

			  $slot=mysqli_real_escape_string($db,$data[2]);

			  if (!is_numeric($slot)) {$slot=0;}



			  if (is_numeric($pid))

			  {

				  $query.="INSERT INTO ootp_sql_draft_pool (league_id,player_id,slot)";

 				  $query.=" VALUES ($lgid,$pid,$slot);";



				  $cnt++;

			  }

		  } 

		  fclose($handle);



		  if ($query!="")

		  {

			  $clearQuery="DELETE FROM ootp_sql_draft_pool WHERE league_id=$lgid";

			  mysqli_query($db,$clearQuery);



			  $q=explode(";",$query);

			  foreach ($q as $key => $impQuery)

			  {

				  mysqli_query($db,$impQuery);

			  }



			  echo "Imported ".($cnt-1)." players to your draft pool<br/> - NOTE: this import does not verify that your imported player ID's are draft eligible.<br/>\n";

		  }

		  else

		  {

			  echo "Invalid file contents or no players found to import.<br/>\n";

		  }



		  // Remove file from server

		  unlink($target);

		  echo "Your draft pool file has been deleted from the server<br/>\n";



		  mysqli_close($db);



	  } 

	  else 

	  { 

		  echo "Sorry, there was a problem uploading your file.<br/>\n"; 

	  } 

  } 



  echo "Return to the <a href='./draftAdmin.php'>draft admin</a> page<br/>\n";



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);









?>

