<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  if (isset($_POST['hmid'])) {$hmid=$_POST['hmid'];}

  else {$hmid=$_SESSION['user_id'];}

  

  ################## PAGE INITIALIZATION #########################

  $title='Draft List Import';



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($_SESSION['lgid'],$_SESSION['lgpath'],$title);

  nav_toolbar("draft","Draft");

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ################## START OF PAGE CONTENT #########################

  $target = "./uploads/"; 

  $target = $target . "draft_list_$hmid.csv" ; 

  $ok=1; 

 

  //This is our size condition 

  if ($uploaded_size > 350000) 

  { 

	  echo "Your file is too large.<br/>\n"; 

	  $ok=0; 

  } 

 

  //This is our limit file type condition 

  $validTypes=Array("text/csv","text/comma-separated-values","application/vnd.ms-excel","text/plain","application/octet-stream");

  $uploaded_type=$_FILES['uploaded']['type'];

  $e=explode(".",$_FILES['uploaded']['name']);

  $lastIdx=count($e)-1;

  $ext=strtolower($e[$lastIdx]);

  if ((!in_array($uploaded_type,$validTypes))||($ext!="csv"))

  { 

	  echo "Only *.csv files are permitted, but you have uploaded a file of type \"".$uploaded_type."\" with a *.$ext extension.<br/> Please note that you may receive this error message if you have the file open while uploading.<br/>\n"; 

	  $ok=0; 

  } 

 

  //Here we check that $ok was not set to 0 by an error 

  if ($ok==0) 

  { 

	  Echo "Sorry your file was not uploaded<br/>\n"; 

  } 

  

  //If everything is ok we try to upload it 

  else 

  { 

	  if(move_uploaded_file($_FILES['uploaded']['tmp_name'], $target)) 

	  { 

		  // Set file to read only (with write for owner)

		  chmod($target, 0644);

		  

		  echo "The file ". basename( $_FILES['uploadedfile']['name']). " has been uploaded and renamed draft_list_$lgid.csv<br/>\n"; 



		  // Read file and import to database

		  include($_SESSION['adminpath']."/dbopen.php");



		  //open the csv file for reading

		  $handle = fopen($target, 'r');



		  $cnt=1;

		  $query="";

		  while (($data = fgetcsv($handle, 1000, ',')) !== FALSE)

		  {



			  // do your thing

			  $pid=mysqli_real_escape_string($db,$data[0]);

			  if (is_numeric($pid))

			  {

				  $query.="INSERT INTO ootp_sql_draft_list (human_manager_id,league_id,porder,player_id)";

 				  $query.=" VALUES ($hmid,$lgid,$cnt,$pid);";



				  $cnt++;

			  }

		  } 

		  fclose($handle);



		  if ($query!="")

		  {

			  $clearQuery="DELETE FROM ootp_sql_draft_list WHERE human_manager_id=$hmid AND league_id=$lgid";

			  mysqli_query($db,$clearQuery);



			  $q=explode(";",$query);

			  foreach ($q as $key => $impQuery)

			  {

				  mysqli_query($db,$impQuery);

			  }



			  echo "Imported ".($cnt-1)." players to your draft list<br/> - NOTE: this import does not verify that your imported player ID's are draft eligible.<br/> ------: Also, any players on your imported draft list that have already been drafted will not appear.\n";

		  }

		  else

		  {

			  echo "Invalid file contents or no players found to import.<br/>\n";

		  }



		  // Remove file from server

		  if (unlink($target)) {echo "Your draft list file has successfully been deleted from the server after processing<br/>\n";}

		  else {echo "Unable to remove file from server.  Please contact your league commissioner.<br/>\n";}



		  mysqli_close($db);



	  } 

	  else 

	  { 

		  echo "Sorry, there was a problem uploading your file.<br/>\n"; 

	  } 

  } 



  if ($hmid==-999) {echo "<br/><br/><a href='./draftAdmin.php'>Click here to return to draft admin page</a><br/>\n";}

  else {echo "<br/><br/><a href='./draftWarroom.php'>Click here to return to draft warroom</a><br/>\n";}



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);



?>

