<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgyear=$_SESSION['lgyear'];

  $lgpath=$_SESSION['lgpath'];

  $yr=$_GET['year'];



  $title="Draft History";



  page_head($title,$_SESSION['lgpath'],"","","./jquery/jquery.min.js");

  echo " <div id='topbar'>\n";

  main_titlebar($lgid,$_SESSION['lgpath'],$title);

  nav_toolbar("history","History");

  nav_toolbar("leagues","",$lgid,$slid,"",$yr);

  echo " </div>   <!-- END topbar DIV -->\n";

  echo " <div id='contentpane'>\n";



  ################## START OF PAGE CONTENT #########################

  include($_SESSION['adminpath']."/dbopen.php");



  ## Get League Abbreviation

  $query="SELECT abbr FROM leagues WHERE league_id=$lgid";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  $row=mysqli_fetch_array($result);

  $lgabbr=$row['abbr'];



  $query="SELECT player_id FROM players WHERE draft_league_id=$lgid AND draft_year>0 LIMIT 1";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  if (!mysqli_num_rows($result))

  {

	  echo "The $lgabbr has never held an amateur draft";

	  mysqli_close($db);

	

	  ################## END OF PAGE #########################

	  echo " </div>   <!-- END contentpane DIV -->\n";

	  page_foot($_SESSION['lgpath']);

	  exit;

  }



  ## Get Team Abbreviations

  $minYear=$lgyear;

  $query="SELECT team_id,year,abbr,name,nickname FROM team_history WHERE league_id=$lgid UNION SELECT team_id,'$lgyear' as year,abbr,name,nickname FROM teams WHERE league_id=$lgid AND allstar_team=0 ORDER BY team_id,year";

  if ($_GET['showq']==1) {echo "$query<br/>\n";}

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

	  while ($row=mysqli_fetch_array($result))

	  {

		  $tid=$row['team_id'];

		  $tyr=$row['year'];



		  if ($tyr<$minYear) {$minYear=$tyr;}



		  $teams[$tid][$tyr]['abbr']=$row['abbr'];

		  $teams[$tid][$tyr]['name']=$row['name']." ".$row['nickname'];

	  }

  }



  ##### Index View #####

  if ($yr=="")

  {

	  ## Display Round Listing

  	  echo "<div class='textbox' style='width:100%;'>   <!-- open player listing -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open player listing -->\n";

	  echo "  <tr class='title2'><td colspan=3>Top Players Drafted</td></tr>\n";



	  $dquery="SELECT DISTINCT(draft_year) as draft_year FROM players WHERE draft_league_id=$lgid AND draft_year!=0 ORDER BY draft_year";

	  if ($_GET['showq']==1) {echo "$dquery<br/>\n";}

	  $dresult=mysqli_query($db,$dquery);

	  if (mysqli_num_rows($dresult))

	  {

		  $rowCnt=0;

		  while ($drow=mysqli_fetch_array($dresult))

		  {

			  $dyear=$drow['draft_year'];



			  $cls='s'.($rowCnt%2+1)."_l";



			  echo "  <tr class='$cls'>";

			  echo "<td rowspan=2><a href='./draft_history.php?year=$dyear' style='font-size:20px;'>$dyear</a></td>";

			  echo "<td style='border-bottom:1px dotted #CCCCCC;'>Batters</td>";

			  echo "<td style='border-bottom:1px dotted #CCCCCC;'>";

			  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,draft_round,draft_supplemental,draft_pick,draft_overall_pick,draft_team_id,SUM(war) as war FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 AND draft_year=$dyear AND draft_league_id=$lgid GROUP BY player_id ORDER BY war DESC LIMIT 5;";

			  if ($_GET['showq']==1) {echo "$query<br/>\n";}

			  $result=mysqli_query($db,$query);

			  if (mysqli_num_rows($result))

			  {

				  $pcnt=0;

				  while ($row=mysqli_fetch_array($result))

				  {

					  $pid=$row['player_id'];

					  $tid=$row['draft_team_id'];

					  if ($pcnt>0) {echo ", ";}

					  echo "<a href='./player.php?player_id=$pid'";

					  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

					  echo " title='".$teams[$tid][$dyear]['name']." - Round ";

					  if ($row['draft_supplemental']==1) {echo "S";}

					  echo $row['draft_round']." Pick ".$row['draft_pick']." (".ordinal_suffix($row['draft_overall_pick']).") - ".stat_format('war',$row['war'])." WAR'";

					  echo ">".$row['first_name']." ".$row['last_name']."</a>";

					  if ($row['retired']!=1) {echo "<sup>+</sup>";}

					  $pcnt++;

				  }

			  }

			  else {echo "<i> - No one has played at the $lgabbr level -</i>";}

			  echo "</td>";

			  echo "</tr>\n";

			  echo "  <tr class='$cls'>";

			  echo "<td>Pitchers</td>";

			  echo "<td>";

			  $query="SELECT p.player_id,first_name,last_name,retired,hall_of_fame,draft_round,draft_supplemental,draft_pick,draft_overall_pick,draft_team_id,SUM(war) as war FROM players as p,players_career_pitching_stats as pcs WHERE p.player_id=pcs.player_id AND pcs.league_id=$lgid AND split_id=1 AND draft_year=$dyear AND draft_league_id=$lgid GROUP BY player_id ORDER BY war DESC LIMIT 5;";

			  if ($_GET['showq']==1) {echo "$query<br/>\n";}

			  $result=mysqli_query($db,$query);

			  if (mysqli_num_rows($result))

			  {

				  $pcnt=0;

				  while ($row=mysqli_fetch_array($result))

				  {

					  $pid=$row['player_id'];

					  $tid=$row['draft_team_id'];

					  if ($pcnt>0) {echo ", ";}

					  echo "<a href='./player.php?player_id=$pid'";

					  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

					  echo " title='".$teams[$tid][$dyear]['name']." - Round ";

					  if ($row['draft_supplemental']==1) {echo "S";}

					  echo $row['draft_round']." Pick ".$row['draft_pick']." (".ordinal_suffix($row['draft_overall_pick']).") - ".stat_format('war',$row['war'])." WAR'";

					  echo ">".$row['first_name']." ".$row['last_name']."</a>";

					  if ($row['retired']!=1) {echo "<sup>+</sup>";}

					  $pcnt++;

				  }

			  }

			  else {echo "<i> - No one has played at the $lgabbr level -</i>";}

			  echo "</td>";

			  echo "</tr>\n";



			  $rowCnt++;

		  }

	  }

	  echo " </table>   <!-- close player listing -->\n";

	  echo "</div>   <!-- close player listing -->\n";



	  ## Display Top Draft Rounds

  	  echo "<div class='textbox' style='width:100%;'>   <!-- open round listing -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open round listing -->\n";

	  echo "  <tr class='title2'><td colspan=4>Top 10 Draft Rounds</td></tr>\n";

	  echo "  <tr class='headline'><td class='hsc2_l'>Year</td><td class='hsc2_l'>Round</td><td class='hsc2_l'>Top 5 Players</td><td class='hsc2' title='Total Accumulated WAR of all players drafted in this round'>WAR</td></tr>\n";



	  $dquery="SELECT draft_year,draft_round,draft_supplemental,SUM(war) as war FROM (SELECT p.player_id, draft_year, draft_round,draft_supplemental,SUM(war) AS war FROM players AS p,players_career_batting_stats AS pcs WHERE p.player_id=pcs.player_id AND draft_year>0 AND draft_league_id=$lgid AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id UNION SELECT p.player_id,draft_year,draft_round,draft_supplemental,SUM(war) AS war FROM players AS p,players_career_pitching_stats AS pcs WHERE p.player_id=pcs.player_id AND draft_year>0 AND draft_league_id=$lgid AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id) as x GROUP BY draft_year,draft_round,draft_supplemental ORDER BY war DESC LIMIT 10";

	  if ($_GET['showq']==1) {echo "$dquery<br/>\n";}

	  $dresult=mysqli_query($db,$dquery);

	  if (mysqli_num_rows($dresult))

	  {

		  $rowCnt=0;

		  while ($drow=mysqli_fetch_array($dresult))

		  {

			  $dyear=$drow['draft_year'];

			  $drnd=$drow['draft_round'];

			  $dsupp=$drow['draft_supplemental'];

			  $dwar=$drow['war'];



			  $cls='s'.($rowCnt%2+1)."_l";



			  echo "  <tr class='$cls'>";

			  echo "<td><a href='./draft_history.php?year=$dyear'>$dyear</a></td>";

			  echo "<td>";

			  if ($dsupp==1) {echo "S";}

			  echo "$drnd</td>";

			  echo "<td>";



			  $query="SELECT p.player_id,first_name,last_name,position,role,retired,hall_of_fame,draft_team_id,draft_pick,draft_overall_pick,war FROM players as p,(SELECT player_id,SUM(war) as war FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id UNION SELECT player_id,SUM(war) as war FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as x WHERE p.player_id=x.player_id AND draft_year=$dyear AND draft_round=$drnd AND draft_supplemental=$dsupp ORDER BY war DESC LIMIT 5";

			  if ($_GET['showq']==1) {echo "$query<br/>\n";}

			  $result=mysqli_query($db,$query);

			  if (mysqli_num_rows($result))

			  {

				  $pcnt=0;

				  while ($row=mysqli_fetch_array($result))

				  {

					  $pid=$row['player_id'];

					  $tid=$row['draft_team_id'];

					  $pos=$row['position'];

					  if ($pos==1) {$pos=$row['role'];}

					  if ($pcnt>0) {echo ", ";}

					  echo get_pos($pos,1);

					  echo " <a href='./player.php?player_id=$pid'";

					  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

					  echo " title='".$teams[$tid][$dyear]['name']." - Round ";

					  if ($dsupp==1) {echo "S";}

					  echo "$drnd Pick ".$row['draft_pick']." (".ordinal_suffix($row['draft_overall_pick']).") - ".stat_format('war',$row['war'])." WAR'";

					  echo ">".$row['first_name']." ".$row['last_name']."</a>";

					  if ($row['retired']!=1) {echo "<sup>+</sup>";}

					  $pcnt++;

				  }

			  }



			  echo "</td>";

			  echo "<td class='s".($rowCnt%2+1)."'>".stat_format('war',$dwar)."</td>";

			  echo "</tr>\n";



			  $rowCnt++;

		  }

	  }

	  echo " </table>   <!-- close round listing -->\n";

	  echo "</div>   <!-- close round listing -->\n";



	  ## Display Top Draft Teams

  	  echo "<div class='textbox' style='width:100%;'>   <!-- open team listing -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open team listing -->\n";

	  echo "  <tr class='title2'><td colspan=4>Top Draft Teams</td></tr>\n";

	  echo "  <tr class='headline'><td class='hsc2_l'>Team</td><td class='hsc2_l'>Top 5 Players</td><td class='hsc2' title='Number of players to reach $lgabbr level'>Cnt</td><td class='hsc2' title='Total Accumulated WAR of all players drafted by this team'>WAR</td></tr>\n";



	  $dquery="SELECT draft_team_id,COUNT(DISTINCT player_id) as playerCnt,SUM(war) as war FROM (SELECT p.player_id,draft_team_id,SUM(war) AS war FROM players AS p,players_career_batting_stats AS pcs WHERE p.player_id=pcs.player_id AND draft_year>0 AND draft_league_id=$lgid AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id UNION SELECT p.player_id,draft_team_id,SUM(war) AS war FROM players AS p,players_career_pitching_stats AS pcs WHERE p.player_id=pcs.player_id AND draft_year>0 AND draft_league_id=$lgid AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id) as x GROUP BY draft_team_id ORDER BY war DESC";

	  if ($_GET['showq']==1) {echo "$dquery<br/>\n";}

	  $dresult=mysqli_query($db,$dquery);

	  if (mysqli_num_rows($dresult))

	  {

		  $rowCnt=0;

		  while ($drow=mysqli_fetch_array($dresult))

		  {

			  $dtid=$drow['draft_team_id'];

			  $dpcnt=$drow['playerCnt'];

			  $dwar=$drow['war'];



			  $cls='s'.($rowCnt%2+1)."_l";



			  echo "  <tr class='$cls'>";

			  echo "<td><a href='./team_hist.php?league_id=$lgid&team_id=$dtid'>".$teams[$dtid][$lgyear]['name']."</a></td>";

			  echo "<td>";



			  $query="SELECT p.player_id,first_name,last_name,position,role,retired,hall_of_fame,draft_year,draft_round,draft_supplemental,draft_pick,draft_overall_pick,war FROM players as p,(SELECT player_id,SUM(war) as war FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id UNION SELECT player_id,SUM(war) as war FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as x WHERE p.player_id=x.player_id AND draft_team_id=$dtid AND draft_year>0 ORDER BY war DESC LIMIT 5";

			  if ($_GET['showq']==1) {echo "$query<br/>\n";}

			  $result=mysqli_query($db,$query);

			  if (mysqli_num_rows($result))

			  {

				  $pcnt=0;

				  while ($row=mysqli_fetch_array($result))

				  {

					  $pid=$row['player_id'];

					  $rnd=$row['draft_round'];

					  $supp=$row['draft_supplemental'];

					  $pos=$row['position'];

					  if ($pos==1) {$pos=$row['role'];}

					  if ($pcnt>0) {echo ", ";}

					  echo get_pos($pos,1);

					  echo " <a href='./player.php?player_id=$pid'";

					  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

					  echo " title='".$row['draft_year']." - Round ";

					  if ($supp==1) {echo "S";}

					  echo "$rnd Pick ".$row['draft_pick']." (".ordinal_suffix($row['draft_overall_pick']).") - ".stat_format('war',$row['war'])." WAR'";

					  echo ">".$row['first_name']." ".$row['last_name']."</a>";

					  if ($row['retired']!=1) {echo "<sup>+</sup>";}

					  $pcnt++;

				  }

			  }



			  echo "</td>";

			  echo "<td class='s".($rowCnt%2+1)."'>$dpcnt</td>";

			  echo "<td class='s".($rowCnt%2+1)."'>".stat_format('war',$dwar)."</td>";

			  echo "</tr>\n";



			  $rowCnt++;

		  }

	  }

	  echo " </table>   <!-- close team listing -->\n";

	  echo "</div>   <!-- close team listing -->\n";	  



	  ## Display Top Draft Rounds

  	  echo "<div class='textbox' style='width:100%;'>   <!-- open picks by round listing -->\n";

	  echo " <table border=0 cellpadding=4 cellspacing=0 width='100%' style='margin-left:auto;margin-right:auto;'>   <!-- open picks by round listing -->\n";

	  echo "  <tr class='title2'><td colspan=4>Top Draftees By Round</td></tr>\n";

	  echo "  <tr class='headline'><td class='hsc2_l'>Round</td><td class='hsc2_l'>Top 5 Players</td><td class='hsc2' title='Total Accumulated WAR of all players drafted in this round'>WAR</td></tr>\n";



	  $dquery="SELECT draft_round,draft_supplemental,SUM(war) as war FROM (SELECT p.player_id,draft_round,draft_supplemental,SUM(war) AS war FROM players AS p,players_career_batting_stats AS pcs WHERE p.player_id=pcs.player_id AND draft_year>0 AND draft_league_id=$lgid AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id UNION SELECT p.player_id,draft_round,draft_supplemental,SUM(war) AS war FROM players AS p,players_career_pitching_stats AS pcs WHERE p.player_id=pcs.player_id AND draft_year>0 AND draft_league_id=$lgid AND pcs.league_id=$lgid AND split_id=1 GROUP BY player_id) as x GROUP BY draft_round,draft_supplemental ORDER BY draft_round,draft_supplemental";

	  if ($_GET['showq']==1) {echo "$dquery<br/>\n";}

	  $dresult=mysqli_query($db,$dquery);

	  if (mysqli_num_rows($dresult))

	  {

		  $rowCnt=0;

		  while ($drow=mysqli_fetch_array($dresult))

		  {

			  $drnd=$drow['draft_round'];

			  $dsupp=$drow['draft_supplemental'];

			  $dwar=$drow['war'];



			  $cls='s'.($rowCnt%2+1)."_l";



			  echo "  <tr class='$cls'>";

			  echo "<td>";

			  if ($dsupp==1) {echo "S";}

			  echo "$drnd</td>";

			  echo "<td>";



			  $query="SELECT p.player_id,first_name,last_name,position,role,retired,hall_of_fame,draft_team_id,draft_year,draft_pick,draft_overall_pick,war FROM players as p,(SELECT player_id,SUM(war) as war FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id UNION SELECT player_id,SUM(war) as war FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as x WHERE p.player_id=x.player_id AND draft_year>0 AND draft_round=$drnd AND draft_supplemental=$dsupp ORDER BY war DESC LIMIT 5";

			  if ($_GET['showq']==1) {echo "$query<br/>\n";}

			  $result=mysqli_query($db,$query);

			  if (mysqli_num_rows($result))

			  {

				  $pcnt=0;

				  while ($row=mysqli_fetch_array($result))

				  {

					  $pid=$row['player_id'];

					  $tid=$row['draft_team_id'];

					  $pos=$row['position'];

					  if ($pos==1) {$pos=$row['role'];}

					  if ($pcnt>0) {echo ", ";}

					  echo get_pos($pos,1);

					  echo " <a href='./player.php?player_id=$pid'";

					  if ($row['hall_of_fame']==1) {echo " style='font-weight:bold;'";}

					  echo " title='".$teams[$tid][$dyear]['name']." - ".$row['draft_year']." Pick ".$row['draft_pick']." (".ordinal_suffix($row['draft_overall_pick']).") - ".stat_format('war',$row['war'])." WAR'";

					  echo ">".$row['first_name']." ".$row['last_name']."</a>";

					  if ($row['retired']!=1) {echo "<sup>+</sup>";}

					  $pcnt++;

				  }

			  }



			  echo "</td>";

			  echo "<td class='s".($rowCnt%2+1)."'>".stat_format('war',$dwar)."</td>";

			  echo "</tr>\n";



			  $rowCnt++;

		  }

	  }

	  echo " </table>   <!-- close picks by round listing -->\n";

	  echo "</div>   <!-- close picks by round listing -->\n";



	  echo "<div class='textbox' style='border:0;'><sup>+</sup> = active player<br/><b>Bold</b> = Hall of Famer</div>\n";

  }



  ##### Year View #####

  else

  {

	  if ($yr=='inaug') {$dyr=$minYear;}

	  else {$dyr=$yr;}



	  ## Get current team abbreviations and level

	  $query="SELECT team_id,abbr,level,league_id FROM teams WHERE allstar_team=0";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $tid=$row['team_id'];



			  $teams[$tid]['abbr']=$row['abbr'];

			  $teams[$tid]['level']=$row['level'];

			  $teams[$tid]['lgid']=$row['league_id'];

		  }

	  }



	  ## Get Feeder League

	  $feederFlag=0;

	  $query="SELECT * FROM (SELECT p.player_id,pcs.team_id FROM players as p,players_career_batting_stats as pcs WHERE p.player_id=pcs.player_id AND draft_league_id=$lgid AND draft_year=$dyr AND split_id=1 AND level_id IN (10,11) AND pcs.team_id>0 ORDER BY player_id,level_id,year DESC) as x GROUP BY player_id UNION SELECT * FROM (SELECT p.player_id,pcs.team_id FROM players as p,players_career_pitching_stats as pcs WHERE p.player_id=pcs.player_id AND draft_league_id=$lgid AND draft_year=$dyr AND split_id=1 AND level_id IN (10,11) AND pcs.team_id>0 ORDER BY player_id,level_id,year DESC) as x GROUP BY player_id";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result)>0)

	  {

		  $feederFlag=1;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  $tid=$row['team_id'];

			  $players[$pid]['feederTID']=$tid;

		  }

	  }



	  ## Batters

	  $statArray=Array("g","ab","h","hr","sb","avg","obp","slg","ops","war");



	  $query="SELECT p.*,minYr,maxYr";

  	  foreach ($statArray as $key => $statLbl) {$query.=",$statLbl";}

	  $query.=" FROM (SELECT player_id,first_name,last_name,position,team_id,organization_id,draft_round,draft_supplemental,draft_pick,draft_overall_pick,draft_team_id,retired,hall_of_fame FROM players WHERE draft_league_id=$lgid AND position!=1";

	  if ($yr=='inaug') {$query.=" AND draft_year=0 AND draft_round>0";}

	  else {$query.=" AND draft_year=$yr";}

	  $query.=") as p";

	  $query.=" LEFT JOIN ";

	  $query.="(SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr";

  	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}

	  $query.=" FROM players_career_batting_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as pcs";

	  $query.=" ON p.player_id=pcs.player_id ORDER BY draft_round,draft_supplemental,draft_pick";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  echo "<div class='textbox'>\n";

		  echo " <table cellpadding=2 cellspacing=0 border=0 style='width:935px;'>\n";

		  echo "  <tr class='title2'><td colspan=".(count($statArray)+9)." class='largeText'>Batters</td></tr>\n";

		  $rowCnt=0;

		  $rnd=0;

		  $prevRnd=-1;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  $dtid=$row['draft_team_id'];

			  $rnd=$row['draft_round'];

			  $supp=$row['draft_supplemental'];



			  if (($rnd+($supp/10))!=$prevRnd)

			  {

				  echo "  <tr class='title'><td colspan=".(count($statArray)+9).">";

				  if ($supp==1) {echo "Supplemental to ";}

				  echo "Round $rnd</td></tr>\n";

				  echo "  <tr class='headline'>";

				  echo "<td class='hsc2'>Rnd</td>";

				  echo "<td class='hsc2'>Pick</td>";

				  echo "<td class='hsc2' title='Overall pick'>Ovr</td>";

				  echo "<td class='hsc2_l' title='Drafted By'>Dft Tm</td>";

				  echo "<td class='hsc2'>Pos</td>";

				  echo "<td class='hsc2_l'>Player</td>";

				  if ($feederFlag==1) {echo "<td class='hsc2_l'>Out Of</td>";}

				  echo "<td class='hsc2'>Years</td>";

				  foreach ($statArray as $key => $statLbl) {echo "<td class='hsc2'>".stat_text($statLbl,2)."</td>";}

				  echo "<td class='hsc2_l' title='Current Team'>Cur Tm</td>";

				  echo "</tr>\n";

			  }



			  $cls='s'.($rowCnt%2+1);



			  echo "  <tr class='$cls'>";

			  echo "<td>";

			  if ($supp==1) {echo "S";}

			  echo $row['draft_round']."</td>";

			  echo "<td>".$row['draft_pick']."</td>";

			  echo "<td>".$row['draft_overall_pick']."</td>";

			  echo "<td class='".$cls."_l'><a href='$lgpath/teams/team_$dtid.html'>".$teams[$dtid][$dyr]['abbr']."</a></td>";

			  echo "<td>".get_pos($row['position'],1)."</td>";

			  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";

			  if ($feederFlag==1)

			  {

				  echo "<td class='".$cls."_l'>";

				  $ftid=$players[$pid]['feederTID'];

				  echo "<a href='$lgpath/teams/team_$ftid.html'>".$teams[$ftid]['abbr']."</a>";

				  echo "</td>";

			  }

			  if ($row['minYr']=="") {echo "<td colspan=".(count($statArray)+1)." class='fadeText' style='text-align:center;'> --- Has not played at the $lgabbr level ---</td>";}

			  else

			  {

				  echo "<td>";

				  if ($row['minYr']==$row['maxYr']) {echo $row['minYr'];}

				  else {echo $row['minYr']."-".$row['maxYr'];}

				  echo "</td>";

				  foreach ($statArray as $key => $statLbl) {echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";}

			  }

			  echo "<td class='".$cls."_l'>";

			  $tid=$row['team_id'];

			  $orgid=$row['organization_id'];

			  echo "<a href='$lgpath/teams/team_$tid.html'>".$teams[$tid]['abbr']."</a>";

			  if ($tid!=$orgid) {echo " (<a href='$lgpath/teams/team_$orgid.html'>".$teams[$orgid]['abbr']."</a> ".get_level($teams[$tid]['level']).")";}

			  echo "</td>";

			  echo "</tr>\n";

			  $rowCnt++;

			  $prevRnd=($rnd+($supp/10));

		  }

		  echo " </table>\n";

		  echo "</div>\n";

	  }



	  ## Pitchers

	  $statArray=Array("g","gs","w","l","s","ip","k","era","whip","war");



	  $query="SELECT p.*,minYr,maxYr";

  	  foreach ($statArray as $key => $statLbl) {$query.=",$statLbl";}

	  $query.=" FROM (SELECT player_id,first_name,last_name,position,team_id,organization_id,draft_round,draft_supplemental,draft_pick,draft_overall_pick,draft_team_id,retired,hall_of_fame FROM players WHERE draft_league_id=$lgid AND position=1";

	  if ($yr=='inaug') {$query.=" AND draft_year=0 AND draft_round>0";}

	  else {$query.=" AND draft_year=$yr";}

	  $query.=") as p";

	  $query.=" LEFT JOIN ";

	  $query.="(SELECT player_id,MIN(year) as minYr,MAX(year) as maxYr";

  	  foreach ($statArray as $key => $statLbl) {$query.=",".stat_query($statLbl)." as $statLbl";}

	  $query.=" FROM players_career_pitching_stats WHERE league_id=$lgid AND split_id=1 GROUP BY player_id) as pcs";

	  $query.=" ON p.player_id=pcs.player_id ORDER BY draft_round,draft_supplemental,draft_pick";

	  if ($_GET['showq']==1) {echo "$query<br/>\n";}

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  echo "<div class='textbox'>\n";

		  echo " <table cellpadding=2 cellspacing=0 border=0 style='width:935px;'>\n";

		  echo "  <tr class='title2'><td colspan=".(count($statArray)+9)." class='largeText'>Pitchers</td></tr>\n";

		  $rowCnt=0;

		  $rnd=0;

		  $prevRnd=-1;

		  while ($row=mysqli_fetch_array($result))

		  {

			  $pid=$row['player_id'];

			  $dtid=$row['draft_team_id'];

			  $rnd=$row['draft_round'];

			  $supp=$row['draft_supplemental'];



			  if (($rnd+($supp/10))!=$prevRnd)

			  {

				  echo "  <tr class='title'><td colspan=".(count($statArray)+9).">";

				  if ($supp==1) {echo "Supplemental to ";}

				  echo "Round $rnd</td></tr>\n";

				  echo "  <tr class='headline'>";

				  echo "<td class='hsc2'>Rnd</td>";

				  echo "<td class='hsc2'>Pick</td>";

				  echo "<td class='hsc2' title='Overall pick'>Ovr</td>";

				  echo "<td class='hsc2_l' title='Drafted By'>Dft Tm</td>";

				  echo "<td class='hsc2'>Pos</td>";

				  echo "<td class='hsc2_l'>Player</td>";

				  if ($feederFlag==1) {echo "<td class='hsc2_l'>Out Of</td>";}

				  echo "<td class='hsc2'>Years</td>";

				  foreach ($statArray as $key => $statLbl) {echo "<td class='hsc2'>".stat_text($statLbl,2)."</td>";}

				  echo "<td class='hsc2_l' title='Current Team'>Cur Tm</td>";

				  echo "</tr>\n";

			  }



			  $cls='s'.($rowCnt%2+1);



			  echo "  <tr class='$cls'>";

			  echo "<td>";

			  if ($supp==1) {echo "S";}

			  echo $row['draft_round']."</td>";

			  echo "<td>".$row['draft_pick']."</td>";

			  echo "<td>".$row['draft_overall_pick']."</td>";

			  echo "<td class='".$cls."_l'><a href='$lgpath/teams/team_$dtid.html'>".$teams[$dtid][$dyr]['abbr']."</a></td>";

			  echo "<td>".get_pos($row['position'],1)."</td>";

			  echo "<td class='".$cls."_l'><a href='./player.php?player_id=$pid'>".$row['first_name']." ".$row['last_name']."</a></td>";

			  if ($feederFlag==1)

			  {

				  echo "<td class='".$cls."_l'>";

				  $ftid=$players[$pid]['feederTID'];

				  echo "<a href='$lgpath/teams/team_$ftid.html'>".$teams[$ftid]['abbr']."</a>";

				  echo "</td>";

			  }

			  if ($row['minYr']=="") {echo "<td colspan=".(count($statArray)+1)." class='fadeText' style='text-align:center;'> --- Has not played at the $lgabbr level ---</td>";}

			  else

			  {

				  echo "<td>";

				  if ($row['minYr']==$row['maxYr']) {echo $row['minYr'];}

				  else {echo $row['minYr']."-".$row['maxYr'];}

				  echo "</td>";

				  foreach ($statArray as $key => $statLbl) {echo "<td>".stat_format($statLbl,$row[$statLbl])."</td>";}

			  }

			  echo "<td class='".$cls."_l'>";

			  $tid=$row['team_id'];

			  $orgid=$row['organization_id'];

			  echo "<a href='$lgpath/teams/team_$tid.html'>".$teams[$tid]['abbr']."</a>";

			  if ($tid!=$orgid) {echo " (<a href='$lgpath/teams/team_$orgid.html'>".$teams[$orgid]['abbr']."</a> ".get_level($teams[$tid]['level']).")";}

			  echo "</td>";

			  echo "</tr>\n";

			  $rowCnt++;

			  $prevRnd=($rnd+($supp/10));

		  }

		  echo " </table>\n";

		  echo "</div>\n";

	  }



  }



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);





?>

