<?php

  include("html_functions.php");



  ################## PAGE INITIALIZATION #########################

  $lgid=$_SESSION['lgid'];

  $lgpath=$_SESSION['lgpath'];

  $htmlpath=$_SESSION['htmlpath'];

  $date=new Date($_SESSION['lgdate']);

  $year=$date->format("Y");



  # Check Admin Table

  include($_SESSION['adminpath']."/dbopen.php");

  $query="SHOW TABLES LIKE 'ootp_sql_admin';";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)) 

  {

	  # Get Settings

	  $query="SELECT * FROM ootp_sql_admin WHERE scope IN ('ALL',$lgid) AND module IN ('admin','Draft')";

	  $result=mysqli_query($db,$query);

	  if (mysqli_num_rows($result))

	  {

		  while ($row=mysqli_fetch_array($result))

		  {

			  $scope=$row['scope'];

			  $module=$row['module'];

			  $setting=$row['setting'];

			  $identifier=$row['identifier'];

			  $value=$row['value'];



			  $settings[$scope][$module][$identifier][$setting]=$value;

		  }

	  }

  }



  ## Create draft table

  $query="SHOW TABLES LIKE 'amateur_draft'";

  $result=mysqli_query($db,$query);

  if (!mysqli_num_rows($result)) 

  {

	  $query="CREATE TABLE IF NOT EXISTS amateur_draft (league_id INT, round INT, supplemental SMALLINT, pick_round INT, team_id INT, player_id INT, pick_time DATETIME, PRIMARY KEY (league_id,round,supplemental,pick_round))";

	  mysqli_query($db,$query);

  }

  ## Create draft pool table

  $query="SHOW TABLES LIKE 'ootp_sql_draft_pool'";

  $result=mysqli_query($db,$query);

  if (!mysqli_num_rows($result)) 

  {

	  $query="CREATE TABLE IF NOT EXISTS ootp_sql_draft_pool (league_id INT, player_id INT, slot INT DEFAULT 0, PRIMARY KEY (league_id, player_id))";

	  mysqli_query($db,$query);

  }

  ## Create draft list table

  $query="SHOW TABLES LIKE 'ootp_sql_draft_list'";

  $result=mysqli_query($db,$query);

  if (!mysqli_num_rows($result)) 

  {

	  $query="CREATE TABLE IF NOT EXISTS ootp_sql_draft_list (human_manager_id INT, league_id INT, porder INT, player_id INT DEFAULT NULL, PRIMARY KEY (human_manager_id,league_id,porder))";

	  mysqli_query($db,$query);

  }



  mysqli_close($db);





  ################## PAGE INITIALIZATION #########################

  $title='Draft Admin';



  page_head($title,$_SESSION['lgpath']);

  echo " <div id='topbar'>\n";

  main_titlebar($_SESSION['lgid'],$_SESSION['lgpath'],$title);



  if ($_SESSION['user_is_commish']!=1)

  {

	  nav_toolbar("draft","Draft");

	  echo " </div>   <!-- END topbar DIV -->\n";

	  echo " <div id='contentpane'>\n";

	  echo "You must be a commisioner to access this page";

	

	  ################## END OF PAGE #########################

	  echo " </div>   <!-- END contentpane DIV -->\n";

	  page_foot($_SESSION['lgpath']);

	  exit;

  }

  else

  {

	  nav_toolbar('admin','Admin Pages');

	  nav_toolbar("draft","Draft");

	  echo " </div>   <!-- END topbar DIV -->\n";

	  echo " <div id='contentpane'>\n";

  }



  include($_SESSION['adminpath']."/dbopen.php");



  ################## START OF PAGE CONTENT #########################

  $module="Draft";

  echo "  <div class='textbox'>\n";

  echo "   <FORM ACTION=\"save_settings.php\" METHOD=\"post\" onsubmit=\"if (document.getElementById('createDraft').checked==true) {return confirm('You are about to recreate the draft order, which will clear any picks already made. \\n\\n Do you really want to do this?');}\">\n";

  echo "    <input type='hidden' name='module' value='".$module."'>\n";

  if ($_GET['debug']==1) {echo "    <input type='hidden' name='debug' value='1'>\n";}

  echo "    <table cellpadding=2 cellspacing=0 style='width:450px;'>";



  echo "     <TR class='title'><TD colspan=2>Draft Settings</TD></TR>\n";

  echo "     <TR><TD>Enable Draft:</TD><TD align='left'><INPUT type=\"checkbox\" name=\"draftOn\" value=1";

  if ($settings[$lgid][$module][-1]['draftOn']==1) {echo " checked";}

  echo "></TD></TR>\n";

  echo "     <TR><TD>Pause Auto Picks (manual only):</TD><TD align='left'><INPUT type=\"checkbox\" name=\"pauseAuto\" value=1";

  if ($settings[$lgid][$module][-1]['pauseAuto']==1) {echo " checked";}

  echo "></TD></TR>\n";

  echo "     <TR><TD>Set Team to Auto After Auto Pick:</TD><TD align='left'><INPUT type=\"checkbox\" name=\"setAuto\" value=1";

  if ($settings[$lgid][$module][-1]['setAuto']==1) {echo " checked";}

  echo "></TD></TR>\n";

  echo "     <TR><TD>Auto Open Teams (no human GM):</TD><TD align='left'><INPUT type=\"checkbox\" name=\"autoOpen\" value=1";

  if ($settings[$lgid][$module][-1]['autoOpen']==1) {echo " checked";}

  echo "></TD></TR>\n";

  echo "     <TR><TD>Autopick Delay (sec):</TD><TD align='left'><INPUT type=\"text\" size=10 name=\"autoDelay\" value=\"".$settings[$lgid][$module][-1]['autoDelay']."\"></TD></TR>\n";



  echo "     <TR class='headline'><TD colspan=2>Draft Creation</TD></TR>\n";

  echo "     <TR><TD colspan=2 style='font-style:italic;'>You can ignore this section if importing the draft order</TD></TR>\n";

  echo "     <TR><TD>Number of Rounds:</TD><TD align='left'><INPUT type=\"text\" size=20 name=\"nRounds\" title=\"Enter the number of rounds in your draft, not including supplemental rounds\" value=\"".$settings[$lgid][$module][-1]['nRounds']."\" onchange=\"document.getElementById('createDraft').checked=true;\"></TD></TR>\n";

  echo "     <TR><TD>Supplemental Round After Round X:</TD><TD align='left'><INPUT type=\"text\" size=20 name=\"suppRounds\" title=\"Enter a semicolon delimited list of rounds which are followed by supplemental rounds: e.g. 2;6\" value=\"".$settings[$lgid][$module][-1]['suppRounds']."\" onchange=\"document.getElementById('createDraft').checked=true;\"></TD></TR>\n";

  echo "     <TR><TD>Alternate Round Length:</TD><TD align='left'><INPUT type=\"text\" size=20 name=\"rndLength\" title=\"Enter round number, comma, round length.\nSeparate rounds with a semicolon.\nUse S1 for supplemental after round 1.\ne.g. 1,32;S1,5;3,35\" value=\"".$settings[$lgid][$module][-1]['rndLength']."\" onchange=\"document.getElementById('createDraft').checked=true;\"></TD></TR>\n";

  $query="SELECT sub_league_id,abbr FROM sub_leagues WHERE league_id=$lgid ORDER BY sub_league_id";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)>1)

  {

	  $orderArray=Array("Worst to First");

	  while ($row=mysqli_fetch_array($result))

	  {

		  array_push($orderArray,"Alternating: ".$row['abbr']." First");

	  }

	  echo "     <TR><TD>Draft Order:</TD><TD>";

	  echo "<SELECT name='draftOrder' onchange=\"document.getElementById('createDraft').checked=true;\">";

	  foreach ($orderArray as $key => $value)

	  {

		  echo "<OPTION value='$key'";

		  if ($key==$settings[$lgid]['Draft'][-1]['draftOrder']) {echo " selected";}

		  echo ">".$value."</OPTION>";

	  }

	  echo "</SELECT>";

	  echo "</TD></TR>\n";

  }

  $orderArray=Array("Linear","Serpentine");

  echo "     <TR><TD>Draft Pattern:</TD><TD>";

  echo "<SELECT name='draftPattern' onchange=\"document.getElementById('createDraft').checked=true;\">";

  foreach ($orderArray as $key => $value)

  {

	  echo "<OPTION value='$value'";

      	  if ($value==$settings[$lgid]['Draft'][-1]['draftPattern']) {echo " selected";}

	  echo ">".$value."</OPTION>";

  }

  echo "</SELECT>";

  echo "</TD></TR>\n";

  echo "     <TR><TD>(Re)Create draft order:</TD><TD align='left'><INPUT type=\"checkbox\" name=\"createDraft\" id=\"createDraft\" title=\"Check this box to create your draft.  Leaving it unchecked will prevent your draft order from being modified.\" value=1></TD></TR>\n";

  echo "     <TR><TD colspan=2 style='font-style:italic;padding-left:10px'>This will clear all picks.  Use the import function to modify draft order and retain selections.</TD></TR>\n";



  ## Get Feeder Leagues

  $query="SELECT league_id,name,abbr FROM leagues WHERE parent_league_id=$lgid AND league_level IN (10,11);";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result))

  {

       	  echo "     <TR class='headline'><TD class='hsc2_l' colspan=2>Feeder League Settings</TD></TR>\n";

       	  echo "     <TR><TD colspan=2 style='font-style:italic;'>You can ignore this section if importing the player pool</TD></TR>\n";

	  while ($row=mysqli_fetch_array($result))

      	  {

		  $flgid=$row['league_id'];

	    	  $name=$row['name'];

		  echo "     <TR><TD>$name Age Limit:</TD><TD align='left'><INPUT type=\"text\" size=10 name=\"feeder_$flgid\" value=\"".$settings[$lgid]['Draft'][$flgid]['feeder']."\"></TD></TR>\n";

	  }

  }



  echo "     <TR class='headline'><TD class='hsc2_l' colspan=2>Draft Schedule Settings</TD></TR>\n";

  echo "     <TR><TD>Enable Draft Timer:</TD><TD align='left'><INPUT type=\"checkbox\" name=\"timerEnable\" value=1";

  if ($settings[$lgid][$module][-1]['timerEnable']==1) {echo " checked";}

  echo "></TD></TR>\n";

  echo "     <TR><TD>Adjust Pick Time With Each Pick:</TD><TD align='left'><INPUT type=\"checkbox\" name=\"flexTimer\" value=1";

  if ($settings[$lgid][$module][-1]['flexTimer']==1) {echo " checked";}

  echo "></TD></TR>\n";

  echo "     <TR><TD>Current server time:</TD><TD align='right'>".date("Y-m-d H:i T",time())."</TD></TR>\n";

  echo "     <TR><TD>Start Date:</TD><TD align='left'><INPUT type=\"text\" size=10 name=\"dStartDt\" value=\"".$settings[$lgid][$module][-1]['dStartDt']."\"></TD></TR>\n";

  echo "     <TR><TD>Start Time:</TD><TD align='left'><INPUT type=\"text\" size=10 name=\"dStartTm\" value=\"".$settings[$lgid][$module][-1]['dStartTm']."\"></TD></TR>\n";

  echo "     <TR><TD>Time Per Pick (min):</TD><TD align='left'><INPUT type=\"text\" size=10 name=\"timePick1\" value=\"".$settings[$lgid][$module][-1]['timePick1']."\"></TD></TR>\n";

  echo "     <TR><TD>- Through Round:</TD><TD align='left'><INPUT type=\"text\" size=10 name=\"rndSwitch\" value=\"".$settings[$lgid][$module][-1]['rndSwitch']."\"></TD></TR>\n";

  echo "     <TR><TD>Time Per Pick After (min):</TD><TD align='left'><INPUT type=\"text\" size=10 name=\"timePick2\" value=\"".$settings[$lgid][$module][-1]['timePick2']."\"></TD></TR>\n";

  echo "     <TR><TD>Timer Starts At:</TD><TD align='left'><INPUT type=\"text\" size=10 name=\"timeStart\" value=\"".$settings[$lgid][$module][-1]['timeStart']."\"></TD></TR>\n";

  echo "     <TR><TD>Timer Stops At:</TD><TD align='left'><INPUT type=\"text\" size=10 name=\"timeStop\" value=\"".$settings[$lgid][$module][-1]['timeStop']."\"></TD></TR>\n";

  echo "     <TR><TD>Pause Timer on Weekends:</TD><TD align='left'><INPUT type=\"checkbox\" name=\"pauseWkEnd\" value=1";

  if ($settings[$lgid][$module][-1]['pauseWkEnd']==1) {echo " checked";}

  echo "></TD></TR>\n";

  //echo "     <TR><TD>Skip Pick When Time Expires:</TD><TD align='left'><INPUT type=\"checkbox\" name=\"skipPicks\" value=1";

  //if ($settings[$lgid][$module][-1]['skipPicks']==1) {echo " checked";}

  //echo "></TD></TR>\n";

  //echo "     <TR><TD colspan=2 style='font-style:italic;padding-left:10px'>If you check this box, teams will not be placed on auto when their time is up.  Instead, the next team will be allowed to pick even though the pick before them has not been made.</TD></TR>\n";

  echo "     <TR><TD>(Re)Schedule Picks:</TD><TD align='left'><INPUT type=\"checkbox\" name=\"schedulePicks\" id=\"schedulePicks\" title=\"Check this box to schedule your draft selections.  Leaving it unchecked will prevent your draft schedule from being adjusted.\" value=1></TD></TR>\n";



	## Email Settings

  echo "     <TR class='headline'><TD class='hsc2_l' colspan=2>Email Settings</TD></TR>\n";

  $emailArray=Array("None","All","Commish","Subscribed","Active Pick");

  echo "     <TR><TD>Send Email To:</TD><TD>";

  echo "<SELECT name='emailList'>";

  foreach ($emailArray as $key => $value)

  {

	  echo "<OPTION name='$value'";

      	  if ($value==$settings[$lgid]['Draft'][-1]['emailList']) {echo " selected";}

	  echo ">".$value."</OPTION>";

  }

  echo "</SELECT>";

  echo "</TD></TR>\n";

  $emailArray=Array("All","Commish","Subscribed");

  echo "     <TR><TD>Email Reply-to Field:</TD><TD>";

  echo "<SELECT name='replyList'>";

  foreach ($emailArray as $key => $value)

  {

	  echo "<OPTION name='$value'";

      	  if ($value==$settings[$lgid]['Draft'][-1]['replyList']) {echo " selected";}

	  echo ">".$value."</OPTION>";

  }

  echo "</SELECT>";

  echo "</TD></TR>\n";

  

	## Slack Settings

	echo "     <TR class='headline'><TD class='hsc2_l' colspan=2>Slack Settings</TD></TR>\n";

	echo "     <TR><TD colspan=2>Slack is currently ";

  	if ($settings['ALL']['admin'][-1]['slackEnable']==1) {echo "enabled";} else {echo "disabled.  You can enable it from the <a href=\"./admin.php\">admin page</a>.";}

	echo "</TD></TR>\n";

	echo "     <TR><TD>Default Slack Channel:</TD><TD align='left'><INPUT type=\"text\" disabled size=20 name=\"slackDefChannel\" value=\"".$settings['ALL']['admin'][-1]['slackDefChannel']."\"></TD></TR>\n";

	echo "     <TR><TD>Draft Slack Channel:</TD><TD align='left'><INPUT type=\"text\" size=20 name=\"slackDraftChannel\" value=\"".$settings[$lgid]['Draft'][-1]['slackDraftChannel']."\"></TD></TR>\n";

	



  echo "     <TR><TD></TD><TD><INPUT type=\"submit\" value=\"Save\"></TD></TR>\n";

  echo "    </table>";

  echo "   </FORM>\n";

  echo "  </div>\n";



  ##### Import/Admin Functions #####

  echo "  <div class='textbox' style='float:right;clear:right;'>\n";

  echo "    <table cellpadding=2 cellspacing=0 style='width:400px;'>";



  echo "     <TR class='title'><TD colspan=2>Administrative Functions</TD></TR>\n";

  echo "     <tr class='s2'>\n";

  echo "      <td colspan=2>\n";

  echo "       <form action='draft_initialize.php' method='POST' onsubmit=\"return confirm('WARNING: This will clear the draft order, draft pool, and all user created draft lists. Are you sure you want to continue?');\">\n";

  echo "        <input type='submit' value='Purge Last Draft' />\n";

  echo "       </form>\n";

  echo "      </td>\n";

  echo "     </tr>\n";

  echo "     <TR class='s2_l'><TD colspan=2 style='font-style:italic;padding-left:10px'>This will clear last year's draft results, draft pool, and user draft lists.</TD></TR>\n";

  echo "     <TR class='headline'><TD class='hsc2_l' colspan=2>Import Draft Order</TD></TR>\n";

  echo "     <tr class='s2'><td colspan=2>\n";

  echo "<form enctype=\"multipart/form-data\" action=\"draft_order_import.php\" method=\"POST\" onsubmit=\"return confirm('Are you sure you want to overwrite the current draft order and made picks?')\">\n";

  echo " Please choose a file: <input name=\"uploaded\" type=\"file\" /><br />\n";

  echo " <input type=\"submit\" value=\"Upload\" />\n";

  echo "</form>\n";

  echo "     </td></tr>\n";

  echo "     <tr  class='s2_l'><td style='border-top:1px dotted #CCCCCC;' colspan=2><a href='./draft_results_export.php'>Export Draft Order</a></td></tr>\n";

  echo "     <TR class='headline'><TD class='hsc2_l' colspan=2>Player Pool (Auto-Generate or Import)</TD></TR>\n";

  echo "     <tr class='s1_l'><td colspan=2 style='font-weight:bold;font-style:italic;padding-left:10px;'>Auto-Generate</td></tr>\n";

  echo "     <tr class='s1'>\n";

  $query="SELECT COUNT(*) as cnt FROM ootp_sql_draft_pool WHERE league_id=$lgid";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)) {$row=mysqli_fetch_array($result);} else {$row['cnt']=0;}

  echo "      <td class='s1_l' style='font-style:italic;padding-left:10px'>Draft Pool: ".$row['cnt']." players</td>";

  echo "      <td>\n";

  echo "       <form action='./draft_pool_generate.php' method='POST'>\n";

  echo "        <input type='submit' value='(Re)Generate Draft Pool' />\n";

  echo "       </form>\n";

  echo "      </td>\n";

  echo "     </tr>\n";

  echo "     <tr class='s2_l'><td colspan=2 style='font-weight:bold;font-style:italic;padding-left:10px'>Import</td></tr>\n";

  echo "     <tr class='s2'><td colspan=2>\n";

  echo "<form enctype=\"multipart/form-data\" action=\"draft_pool_import.php\" method=\"POST\" onsubmit=\"return confirm('Are you sure you want to overwrite the draft pool with the imported file?')\">\n";

  echo " Please choose a file: <input name=\"uploaded\" type=\"file\" /><br />\n";

  echo " <input type=\"submit\" value=\"Upload\" />\n";

  echo "</form>\n";

  echo "     </td></tr>\n";

  echo "     <tr class='s2_l'><td style='border-top:1px dotted #CCCCCC;' colspan=2><a href='./draft_pool_export.php'>Export Draft Pool</a></td></tr>\n";

  echo "     <TR class='headline'><TD class='hsc2_l' colspan=2>Auto Draft List (Auto-Generate or Import)</TD></TR>\n";

  echo "     <tr class='s1_l'><td colspan=2 style='font-weight:bold;font-style:italic;padding-left:10px;'>Auto-Generate</td></tr>\n";

  echo "     <tr class='s1'>\n";

  $query="SELECT COUNT(*) as cnt FROM ootp_sql_draft_list WHERE league_id=$lgid AND human_manager_id=-999";

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)) {$row=mysqli_fetch_array($result);} else {$row['cnt']=0;}

  echo "      <td class='s1_l' style='font-style:italic;padding-left:10px''>Auto List: ".$row['cnt']." players</td>\n";

  echo "      <td colspan=2>\n";

  echo "       <form action='./draft_auto_list_generate.php' method='POST'>\n";

  echo "        <input type='submit' value='(Re)Generate Auto Draft List' />\n";

  echo "       </form>\n";

  echo "      </td>\n";

  echo "     </tr>\n";

  echo "     <TR class='s1_l'><TD colspan=2 style='font-style:italic;padding-left:10px'>Make sure you've imported or generated the draft pool first!</TD></TR>\n";

  echo "     <tr class='s2_l'><td colspan=2 style='font-weight:bold;font-style:italic;padding-left:10px'>Import</td></tr>\n";

  echo "     <tr class='s2'><td colspan=2>\n";

  echo "     <form enctype=\"multipart/form-data\" action=\"draft_list_import.php\" method=\"POST\" onsubmit=\"return confirm('Are you sure you want to overwrite your draft list and replace it with the uploaded file?')\">\n";

  echo "      <label for='uploaded'>Import Draft List:</label> <input name=\"uploaded\" type=\"file\" />\n";

  echo "      <input type=\"hidden\" name='hmid' value='-999' />\n";

  echo "      <input type=\"submit\" value=\"Upload\" />\n";

  echo "     </form>\n";

  echo "     <tr class='s2_l'><td style='border-top:1px dotted #CCCCCC;' colspan=2><a href='./draft_list_export.php?hmid=-999'>Export Auto Draft List</a></td></tr>\n";

  echo "     </td></tr>\n";

  echo "    </table>\n";

  echo "  </div>\n";



  ## Get Draft List Counts

  $query="SELECT human_manager_id,COUNT(DISTINCT player_id) as cnt FROM (SELECT human_manager_id,dp1.player_id FROM (SELECT dl.human_manager_id,dp.player_id FROM ootp_sql_draft_pool as dp,ootp_sql_draft_list as dl WHERE dp.league_id=$lgid AND dp.player_id=dl.player_id) as dp1 LEFT JOIN amateur_draft as ad on dp1.player_id=ad.player_id WHERE ad.player_id IS NULL) as x GROUP BY human_manager_id";

  if ($_GET['showq']==1) {echo $query;}

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)>0)

  {

	  while ($row=mysqli_fetch_array($result))

	  {

		  $hmid=$row['human_manager_id'];

		  $dlist[$hmid]=$row['cnt'];

	  }

  }



  ##### User Configuration #####

  echo "  <div class='textbox'>\n";

  echo "    <table cellpadding=2 cellspacing=0 border=0 style='width:935px;'>";

  echo "     <TR class='title'><TD colspan=7>User Configuration</TD></TR>\n";

  echo "     <TR class='headline'><TD class='hsc2_l'>Team</TD><TD class='hsc2_l'>Human Manager</TD><TD class='hsc2'>Email</TD><TD class='hsc2'>Subscribed</TD><TD class='hsc2'>Auto Draft?</TD><TD class='hsc2'>Draft List?</TD><TD class='hsc2' title='Number of players remaining on draft list'>#</TD></TR>\n";

  $query="SELECT x.*,setting,value FROM (SELECT t.team_id,t.name,t.nickname,hm.first_name,hm.last_name,hm.human_manager_id FROM teams as t,human_managers as hm WHERE t.team_id=hm.team_id AND t.league_id=$lgid) as x LEFT JOIN (SELECT setting,identifier,value FROM ootp_sql_admin WHERE scope IN ('ALL',$lgid) AND module='users' AND setting IN ('auto','auto_list','autoRnd','email','draftSubscribe')) as y ON x.human_manager_id=y.identifier ORDER BY name,nickname";

  if ($_GET['showq']==1) {echo $query;}

  $result=mysqli_query($db,$query);

  if (mysqli_num_rows($result)>0)

  {

	  while ($row=mysqli_fetch_array($result))

	  {

		  $hmid=$row['human_manager_id'];



		  $gms[$hmid]['name']=$row['first_name']." ".$row['last_name'];

		  $gms[$hmid]['tid']=$row['team_id'];

		  $gms[$hmid]['tname']=$row['name']." ".$row['nickname'];



		  $setting=$row['setting'];

		  $gms[$hmid][$setting]=$row['value'];

	  }



	  $cnt=0;

	  foreach ($gms as $hmid => $value)

	  {

		  $tid=$gms[$hmid]['tid'];

		  $hmlist.=",$hmid";



		  if ($gms[$hmid]['auto']==1)

		  {

			  $auto='ON';

			  $autoRnd=$gms[$hmid]['autoRnd'];

			  if ($autoRnd>0) {$auto.=" (after round $autoRnd)";}

			  $auto.=" (<a href='./draftProcess.php?mode=auto_off&hmid=$hmid'>disable</a>)";

		  }

		  else {$auto="OFF (<a href='./draftProcess.php?mode=auto_on&hmid=$hmid'>enable</a>)";}

		

		  if ($gms[$hmid]['auto_list']==1) {$autoList="ON (<a href='./draftProcess.php?mode=auto_list_off&hmid=$hmid'>disable</a>)";}

		  else 

		  {

			  $autoList="OFF (<a href='./draftProcess.php?mode=auto_list_on&hmid=$hmid'>enable</a>)";

		  }



		  $email=$gms[$hmid]['email'];

		  if ($email=="") {$email="None entered";}

		  elseif (filter_var($email,FILTER_VALIDATE_EMAIL))

		  {

			  $email="<a href='mailto:$email'>$email</a>";

		  }

		  else {$email="Invalid Email: $email";}



		  $cls='s'.($cnt%2+1);

		  echo "     <tr class='$cls'>";

		  echo "<td class='".$cls."_l'><a href='$lgpath/teams/team_$tid.html'>".$gms[$hmid]['tname']."</a></td>";

		  echo "<td class='".$cls."_l'>".$gms[$hmid]['name']."</td>";

		  echo "<td>$email</td>";

		  echo "<td>";

		  if ($gms[$hmid]['draftSubscribe']==1) {echo "Y";} else {echo "N";}

		  echo "</td>";

		  echo "<td>$auto</td>";

		  echo "<td>$autoList</td>";

		  echo "<td>".max(0,$dlist[$hmid])."</td>";

		  echo "</tr>\n";

		  $cnt++;

	  }

  }

	

  $hmlist=trim($hmlist,",");

  echo "     <tr class='headline'><td class='hsc2' colspan=4>For all:</td>";

  echo "<td class='hsc2'>(<a href='./draftProcess.php?mode=auto_on_all&hmid=$hmlist'>enable</a>/<a href='./draftProcess.php?mode=auto_off_all&hmid=$hmlist'>disable</a>)</td>";

  echo "<td class='hsc2'>(<a href='./draftProcess.php?mode=auto_list_on_all&hmid=$hmlist'>enable</a>/<a href='./draftProcess.php?mode=auto_list_off_all&hmid=$hmlist'>disable</a>)</td>";

  echo "<td class='hsc2' colspan=4>&nbsp;</td>";

  echo "</tr>\n";

  

  echo "    </table>\n";

  echo "  </div>\n";



  mysqli_close($db);



  ################## END OF PAGE #########################

  echo " </div>   <!-- END contentpane DIV -->\n";

  page_foot($_SESSION['lgpath']);





?>

