function countDown(pickTime,nowTime,lastTime,toName,pickDelay,pickStatus,pauseAuto) {
    var dateFuture = new Date();
    var dateNow = new Date();
    var dateLast = new Date();
    var amount;
    var to=document.getElementById(toName);
    var out;

    dateFuture.setTime(pickTime);
    dateNow.setTime(nowTime);
    dateLast.setTime(lastTime);
    
    if (lastTime==0) {pickStatus='none';}

    switch (pickStatus)
    {
	    case 'list':
	    case 'auto':
		    amount = pickDelay - (dateNow.getTime() - dateLast.getTime());
		    break;
	    default:
		    amount = dateFuture.getTime() - dateNow.getTime();
		    break;
    }

    if ((pickStatus=='list')&&(amount<0))
    {
	    pickStatus='nolist';
	    amount = dateFuture.getTime() - dateNow.getTime();
    }

    if ((pickStatus=='auto')&&(pauseAuto==1)&&(amount<0))
    {
	    pickStatus='noauto';
	    amount = dateFuture.getTime() - dateNow.getTime();
    }

    if (amount <= 0) {
      out="<b>Next pick due in:</b></br> ";
      if (pauseAuto==1) {out += "<span style='color:red;'>Pick overdue!</span></br><span style='color:#000099;'>*-- Auto Picks Paused --*</span>";}
      else {out += "<span style='color:red;'>Processing pick...</span>";}
      
      to.innerHTML=out;

      if (pauseAuto!=1) {setTimeout("location.href='./draftBoard.php'", 1000);}
    }
    else {
      var days=0;
      var hours=0;
      var mins=0;
      var secs=0;
      var redAlert=0;
      
      switch (pickStatus)
      {
	      case 'list':
		      out="<b>Next pick due in:</b></br>List processed in ";
		      break;
	      case 'auto':
		      out="<b>Next pick due in:</b></br>Auto pick taken in ";
		      break;
	      default:
		      out="<b>Next pick due in:</b></br>";
		      break;
      }
      
      days = Math.floor(amount/86400);
      amount = amount%86400;

      hours = Math.floor(amount/3600);
      amount = amount%3600;
      if ((hours<1)&&(days==0)) {redAlert=1;}

      mins = Math.floor(amount/60);
      amount = amount%60;

      secs = Math.floor(amount);

      if (redAlert==1) {out += "<span style='color:red;'>";}
      if(days != 0) {out += days +" day"+((days!=1)?"s":"")+", ";}
      if(days != 0 || hours != 0) {out += hours +" hour"+((hours!=1)?"s":"")+", ";}
      if(days != 0 || hours != 0 || mins != 0) {out += mins +" minute"+((mins!=1)?"s":"")+", ";}
      out += secs +" seconds";
      if (redAlert==1) {out += "</span>";}

      if ((pickStatus=='nolist')&&(pauseAuto!=1)) {out += "</br><span style='color:#EC9900;font-style:italic;font-weight:bold;'>No players remaining on draft list</span>";}

      if (pauseAuto==1) {out += "</br><span style='color:#000099;'>*-- Auto Picks Paused --*</span>";}

      to.innerHTML=out;

      setTimeout("countDown('"+pickTime+"','"+(parseInt(nowTime)+1)+"','"+lastTime+"','"+toName+"',"+pickDelay+",'"+pickStatus+"',"+pauseAuto+")", 1000);
    }
}

//Draft List Functions
function moveUp(element) {
    var j;
    var who;
    for(i = 0; i < element.options.length; i++) {
        if(element.options[i].selected == true) {
            if(i != 0) {
                var text1 = element.options[i-1].text;
                j = text1.indexOf('.');
                who = text1.substr(j+1);
                j = text1.substr(0,j);
                text1=(parseInt(j)+1)+"."+who;
                var text2 = element.options[i].text;
                j = text2.indexOf('.');
                who = text2.substr(j+1);
                j = text2.substr(0,j);
                text2=(j-1)+"."+who;
                var temp = new Option(text1,element.options[i-1].value);
                var temp2 = new Option(text2,element.options[i].value);
                element.options[i-1] = temp2;
                element.options[i-1].selected = true;
                element.options[i] = temp;
            }
        }
    }
}

function moveDown(element) {
    var j;
    var who;
    for(i = (element.options.length - 1); i >= 0; i--) {
        if(element.options[i].selected == true) {
            if(i != (element.options.length - 1)) {
                var text1 = element.options[i+1].text;
                j = text1.indexOf('.');
                who = text1.substr(j+1);
                j = text1.substr(0,j);
                text1=(j-1)+"."+who;
                var text2 = element.options[i].text;
                j = text2.indexOf('.');
                who = text2.substr(j+1);
                j = text2.substr(0,j);
                text2=(parseInt(j)+1)+"."+who;
                var temp1 = new Option(text1 ,element.options[i+1].value);
                var temp2 = new Option(text2,element.options[i].value);
                element.options[i+1] = temp2;
                element.options[i+1].selected = true;
                element.options[i] = temp1;
            }
        }
    }
}

function addToList(list,from) {
    var len = list.options.length;
    if (len == 1 && list.options[0].value == '0') {
        list.options[0] = null;
        len = 0;
    }
    var found = false;
    var val = '';
    var name = '';
    var j = 0;
    for (var i =0; i < from.player.length; i++) {
        if (from.player[i].checked) {
            found = false;
            val = from.player[i].value;
            j = val.indexOf(',');
            name = val.substr(j+1);
            val = val.substr(0, j);
            for (j = 0; j < list.options.length; j++) {
                if (list.options[j].value == val) {
                    found = true;
                    break;
                }
            }
            if (!found) {
                name = (len+1)+". "+name;
                list.options[len] = new Option(name, val);
                len++;
            }
            from.player[i].checked=false;
        }
    }
}

function view(list, url) {
    for (var i = 0; i < list.options.length; i++) {
        if(list.options[i].selected == true) {
            window.open(url+list.options[i].value+".html", "draftWindow");
            break;
        }
    }
}

function removeFromList(list) {
    var found;
    var text;
    var j;
    var who;
    var fcnt=0;
    for (var i = 0; i < list.options.length; i++) {
        if(list.options[i].selected == true) {
            var message="Really remove "+list.options[i].text+"?";
            //var choice=confirm(message);
            var choice=true;
            if (choice===true) {
               list.options[i] = null;
               found=i;
               fcnt=fcnt+1;
            i--;
            }

        }
        if (i>=found) {        
        text = list.options[i].text;
        j = text.indexOf('.');
        who = text.substr(j+1);
        j = text.substr(0,j);
        text=(j-fcnt)+"."+who;
        temp = new Option(text, list.options[i].value);
        list.options[i]=temp;}
    }
}

function moveList(fromElem, toElem) {
    toElem.value = '';
    for (var i=0; i<fromElem.options.length; i++) {
        if (toElem.value == '') {
            toElem.value =  fromElem.options[i].value;
        }
        else {
            toElem.value = toElem.value + '|' + fromElem.options[i].value;
        }
    }
    return true;
}

// Correct sorts based on who is selected to display
function whoChange() {
    var whoElem=document.getElementById('whoObj');
    var viewElem=document.getElementById('viewObj');
    var sort1=document.getElementById('sort1Obj');
    var sort2=document.getElementById('sort2Obj');
    var sort3=document.getElementById('sort3Obj');
    var whoVal=whoElem[whoElem.selectedIndex].value;
    var viewVal=viewElem[viewElem.selectedIndex].value;
    var sort1Val=sort1[sort1.selectedIndex].value;
    var sort2Val=sort1[sort2.selectedIndex].value;
    var sort3Val=sort1[sort3.selectedIndex].value;

    // Get sortList
    switch (whoVal)
    {
	    case 'pitchers':
	    case '11':
	    case '12':
	    case '13':
		    switch (viewVal)
		    {
			    case 'overall':
			    case 'talent':
				    var sortList=new Array("pitching_ratings_talent_stuff","pitching_ratings_talent_control","pitching_ratings_talent_movement","pitching_ratings_misc_velocity","pitching_ratings_misc_stamina","last_name,first_name","age","lvl","porder");
				    break;
			    default:
				    var sortList=new Array('pk','era','whip','w','l','s','cg','sho','pg','gs','ip','ha','pr','er','hra','pbb','oavg','babip',"last_name,first_name","age","lvl","porder");
				    break;
		    }
		    break;
	    default:
		    switch (viewVal)
		    {
			    case 'overall':
			    case 'talent':
				    var sortList=new Array('batting_ratings_talent_contact','batting_ratings_talent_power','batting_ratings_talent_eye','batting_ratings_talent_gap','batting_ratings_talent_strikeouts','running_ratings_speed','running_ratings_stealing','running_ratings_baserunning',"last_name,first_name","age","lvl","porder");
				    break;
			    default:
				    var sortList=new Array('h','hr','bb','g','ab','r','d','t','rbi','k','sb','cs','avg','obp','slg','ops','wOBA',"last_name,first_name","age","lvl","porder");
				    break;
		    }
		    break;
    }

    // Validate sort1
    var i,option;
    for (i=0, option; option = sort1.options[i]; i++) {
	    if ($.inArray(option.value,sortList)<0) {
		    option.disabled='disabled';
		    option.style.color = "graytext";
	    }
	    else
	    {
		    option.disabled='';
		    option.style.color = "menutext";
	    }
    }
    if ($.inArray(sort1Val,sortList)<0) {sort1.value=sortList[0];}
    // Validate sort2
    for (i=0, option; option = sort2.options[i]; i++) {
	    if ($.inArray(option.value,sortList)<0) {
		    option.disabled='disabled';
		    option.style.color = "graytext";
	    }
	    else
	    {
		    option.disabled='';
		    option.style.color = "menutext";
	    }
    }
    if ($.inArray(sort2Val,sortList)<0) {sort2.value=sortList[1];}
    // Validate sort3
    for (i=0, option; option = sort3.options[i]; i++) {
	    if ($.inArray(option.value,sortList)<0) {
		    option.disabled='disabled';
		    option.style.color = "graytext";
	    }
	    else
	    {
		    option.disabled='';
		    option.style.color = "menutext";
	    }
    }
    if ($.inArray(sort3Val,sortList)<0) {sort3.value=sortList[2];}

}

//Sets player as draftee from draft list box
function listClick(fromElem,path) {
    var txt,pid,name,playerText,myarr;

    for (var i=0; i<fromElem.options.length; i++)
    {
	    if (fromElem.options[i].selected)
	    {
		    pid=fromElem.options[i].value;

		    playerText=fromElem.options[i].text;
		    
		    var myarr = playerText.split(". ");
		    name="";
		    for (var i=1; i<myarr.length; i++)
		    {
			    if (i==1) {name+=myarr[i];}
			    else {name+=". "+myarr[i];}
		    }

		    txt="<a href='"+path+"/players/player_"+pid+".html'>"+name+"</a>";

		    document.getElementById('draftSelection').innerHTML=txt;
		    document.getElementById('draftPID').value=pid;
		    document.getElementById('draftName').value=name;

		    return true;
	    }
    }

    return true;
}

//Sets player as draftee from player listing
function listingClick(fromElem,path) {
    var txt,pid,name,playerText,myarr;

    playerText=fromElem.value;

    var myarr = playerText.split(",");
    pid=myarr[0];
    name=myarr[1];

    txt="<a href='"+path+"/players/player_"+pid+".html'>"+name+"</a>";

    document.getElementById('draftSelection').innerHTML=txt;
    document.getElementById('draftPID').value=pid;
    document.getElementById('draftName').value=name;
}

//Player Selection
function pickPlayer(from,to) {
    var pid = document.getElementById('draftPID').value;
    var name= document.getElementById('draftName').value;

    if (pid>0)
    {
	    var r=confirm("Draft "+name+"?");
	    if (r==true) {return true;}
	    else {return false;}
    }
    else
    {
        alert ('Select a player first');
        return false;
    }

    alert ("Invalid processing");
    return false;
}

